export type CharGrabberOptions = {
    onSkip?: () => void;
};
export declare class CharGrabber {
    private s;
    private c;
    private o;
    constructor(source: string, options?: CharGrabberOptions);
    skip(num?: number, silent?: boolean): void;
    hasNext(): boolean;
    getCurr(): string;
    getPos(): number;
    getLength(): number;
    getRest(): string;
    getNext(): string | null;
    getPrev(): string | null;
    isLast(): boolean;
    includes(val: string): boolean;
    grabWhile(condition: (curr: string) => boolean, silent?: boolean): string;
    grabN(num?: number): string;
    /**
     * Grabs rest of string until it find a char
     */
    substrUntilChar(char: string): string;
}
/**
 * Creates a grabber wrapper for source string, that helps to iterate over string char by char
 */
export declare const createCharGrabber: (source: string, options?: CharGrabberOptions) => CharGrabber;
/**
 * Trims string from start and end by char
 * @example
 *  trimChar('*hello*', '*') ==> 'hello'
 */
export declare const trimChar: (str: string, charToRemove: string) => string;
/**
 * Unquotes \" to "
 */
export declare const unquote: (str: string) => string;
//# sourceMappingURL=utils.d.mts.map