(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define(['exports'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.BbobPreset = {}));
})(this, (function (exports) { 'use strict';

    function isTagNode(el) {
        return typeof el === 'object' && el !== null && 'tag' in el;
    }

    function process(tags, tree, core, options) {
        return tree.walk((node)=>{
            if (isTagNode(node)) {
                const tag = node.tag;
                const tagCallback = tags[tag];
                if (typeof tagCallback === "function") {
                    return tagCallback(node, core, options);
                }
            }
            return node;
        });
    }
    /**
     * Create a preset plugin for @bbob/core
     */ function createPreset(defTags, processor = process) {
        const presetFactory = (opts)=>{
            presetFactory.options = Object.assign(presetFactory.options || {}, opts);
            function presetExecutor(tree, core) {
                return processor(defTags, tree, core, presetFactory.options || {});
            }
            presetExecutor.options = presetFactory.options;
            return presetExecutor;
        };
        presetFactory.extend = function presetExtend(callback) {
            const newTags = callback(defTags, presetFactory.options);
            return createPreset(newTags, processor);
        };
        return presetFactory;
    }

    exports.createPreset = createPreset;
    exports.default = createPreset;
    exports.process = process;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
