import { OpenAPIRegistry, OpenApiGeneratorV3, RouteConfig as RouteConfig$1, ZodContentObject, ZodMediaTypeObject, ZodRequestBody, extendZodWithOpenApi } from "@asteasolutions/zod-to-openapi";
import { Context, Env, ErrorHandler, Handler, Hono, Input, MiddlewareHandler, NotFoundHandler, Schema, ToSchema, TypedResponse, ValidationTargets } from "hono";
import { H, MergePath, MergeSchemaPath } from "hono/types";
import { ClientErrorStatusCode, InfoStatusCode, RedirectStatusCode, ServerErrorStatusCode, StatusCode, SuccessStatusCode } from "hono/utils/http-status";
import { JSONParsed, RemoveBlankRecord } from "hono/utils/types";
import { OpenAPIObject } from "openapi3-ts/oas30";
import { OpenAPIObject as OpenAPIObject$1 } from "openapi3-ts/oas31";
import { ZodError, ZodType, z } from "zod";

//#region src/index.d.ts

type MaybePromise<T> = Promise<T> | T;
type RouteConfig = RouteConfig$1 & {
  middleware?: H | H[];
  hide?: boolean;
};
type RequestTypes = {
  body?: ZodRequestBody;
  params?: ZodType;
  query?: ZodType;
  cookies?: ZodType;
  headers?: ZodType | ZodType[];
};
type IsJson<T> = T extends string ? T extends `application/${infer Start}json${infer _End}` ? Start extends "" | `${string}+` | `vnd.${string}+` ? "json" : never : never : never;
type IsForm<T> = T extends string ? T extends `multipart/form-data${infer _Rest}` | `application/x-www-form-urlencoded${infer _Rest}` ? "form" : never : never;
type ReturnJsonOrTextOrResponse<ContentType, Content$1, Status$1 extends keyof StatusCodeRangeDefinitions | StatusCode> = ContentType extends string ? ContentType extends `application/${infer Start}json${infer _End}` ? Start extends "" | `${string}+` | `vnd.${string}+` ? TypedResponse<JSONParsed<Content$1>, ExtractStatusCode<Status$1>, "json"> : never : ContentType extends `text/plain${infer _Rest}` ? TypedResponse<Content$1, ExtractStatusCode<Status$1>, "text"> : Response : never;
type RequestPart<R$1 extends RouteConfig, Part extends string> = Part extends keyof R$1["request"] ? R$1["request"][Part] : {};
type HasUndefined<T> = undefined extends T ? true : false;
type InputTypeBase<R$1 extends RouteConfig, Part extends string, Type extends keyof ValidationTargets> = R$1["request"] extends RequestTypes ? RequestPart<R$1, Part> extends ZodType ? {
  in: { [K in Type]: HasUndefined<ValidationTargets[K]> extends true ? { [K2 in keyof z.input<RequestPart<R$1, Part>>]?: z.input<RequestPart<R$1, Part>>[K2] } : { [K2 in keyof z.input<RequestPart<R$1, Part>>]: z.input<RequestPart<R$1, Part>>[K2] } };
  out: { [K in Type]: z.output<RequestPart<R$1, Part>> };
} : {} : {};
type InputTypeJson<R$1 extends RouteConfig> = R$1["request"] extends RequestTypes ? R$1["request"]["body"] extends ZodRequestBody ? R$1["request"]["body"]["content"] extends ZodContentObject ? IsJson<keyof R$1["request"]["body"]["content"]> extends never ? {} : R$1["request"]["body"]["content"][keyof R$1["request"]["body"]["content"]] extends Record<"schema", ZodType<any>> ? {
  in: {
    json: z.input<R$1["request"]["body"]["content"][keyof R$1["request"]["body"]["content"]]["schema"]>;
  };
  out: {
    json: z.output<R$1["request"]["body"]["content"][keyof R$1["request"]["body"]["content"]]["schema"]>;
  };
} : {} : {} : {} : {};
type InputTypeForm<R$1 extends RouteConfig> = R$1["request"] extends RequestTypes ? R$1["request"]["body"] extends ZodRequestBody ? R$1["request"]["body"]["content"] extends ZodContentObject ? IsForm<keyof R$1["request"]["body"]["content"]> extends never ? {} : R$1["request"]["body"]["content"][keyof R$1["request"]["body"]["content"]] extends Record<"schema", ZodType<any>> ? {
  in: {
    form: z.input<R$1["request"]["body"]["content"][keyof R$1["request"]["body"]["content"]]["schema"]>;
  };
  out: {
    form: z.output<R$1["request"]["body"]["content"][keyof R$1["request"]["body"]["content"]]["schema"]>;
  };
} : {} : {} : {} : {};
type InputTypeParam<R$1 extends RouteConfig> = InputTypeBase<R$1, "params", "param">;
type InputTypeQuery<R$1 extends RouteConfig> = InputTypeBase<R$1, "query", "query">;
type InputTypeHeader<R$1 extends RouteConfig> = InputTypeBase<R$1, "headers", "header">;
type InputTypeCookie<R$1 extends RouteConfig> = InputTypeBase<R$1, "cookies", "cookie">;
type ExtractContent<T> = T extends { [K in keyof T]: infer A } ? A extends Record<"schema", ZodType> ? z.infer<A["schema"]> : never : never;
type StatusCodeRangeDefinitions = {
  "1XX": InfoStatusCode;
  "2XX": SuccessStatusCode;
  "3XX": RedirectStatusCode;
  "4XX": ClientErrorStatusCode;
  "5XX": ServerErrorStatusCode;
};
type RouteConfigStatusCode = keyof StatusCodeRangeDefinitions | StatusCode;
type ExtractStatusCode<T extends RouteConfigStatusCode> = T extends keyof StatusCodeRangeDefinitions ? StatusCodeRangeDefinitions[T] : T;
type DefinedStatusCodes<R$1 extends RouteConfig> = keyof R$1["responses"] & RouteConfigStatusCode;
type RouteConfigToTypedResponse<R$1 extends RouteConfig> = { [Status in DefinedStatusCodes<R$1>]: R$1["responses"][Status] extends {
  content: infer Content;
} ? undefined extends Content ? never : ReturnJsonOrTextOrResponse<keyof R$1["responses"][Status]["content"], ExtractContent<R$1["responses"][Status]["content"]>, Status> : TypedResponse<{}, ExtractStatusCode<Status>, string> }[DefinedStatusCodes<R$1>] | ("default" extends keyof R$1["responses"] ? R$1["responses"]["default"] extends {
  content: infer Content;
} ? undefined extends Content ? never : ReturnJsonOrTextOrResponse<keyof Content, ExtractContent<Content>, Exclude<StatusCode, ExtractStatusCode<DefinedStatusCodes<R$1>>>> : TypedResponse<{}, Exclude<StatusCode, ExtractStatusCode<DefinedStatusCodes<R$1>>>, string> : never);
type Hook<T, E$1 extends Env, P$1 extends string, R$1> = (result: {
  target: keyof ValidationTargets;
} & ({
  success: true;
  data: T;
} | {
  success: false;
  error: ZodError;
}), c: Context<E$1, P$1>) => R$1;
type ConvertPathType<T extends string> = T extends `${infer Start}/{${infer Param}}${infer Rest}` ? `${Start}/:${Param}${ConvertPathType<Rest>}` : T;
type OpenAPIHonoOptions<E$1 extends Env> = {
  defaultHook?: Hook<any, E$1, any, any>;
};
type HonoInit<E$1 extends Env> = ConstructorParameters<typeof Hono>[0] & OpenAPIHonoOptions<E$1>;
/**
* Turns `T | T[] | undefined` into `T[]`
*/
type AsArray<T> = T extends undefined ? [] : T extends any[] ? T : [T];
/**
* Like simplify but recursive
*/
type DeepSimplify<T> = { [KeyType in keyof T]: T[KeyType] extends Record<string, unknown> ? DeepSimplify<T[KeyType]> : T[KeyType] } & {};
/**
* Helper to infer generics from {@link MiddlewareHandler}
*/
type OfHandlerType<T extends MiddlewareHandler> = T extends MiddlewareHandler<infer E, infer P, infer I> ? {
  env: E;
  path: P;
  input: I;
} : never;
/**
* Reduce a tuple of middleware handlers into a single
* handler representing the composition of all
* handlers.
*/
type MiddlewareToHandlerType<M extends MiddlewareHandler<any, any, any>[]> = M extends [infer First, infer Second, ...infer Rest] ? First extends MiddlewareHandler<any, any, any> ? Second extends MiddlewareHandler<any, any, any> ? Rest extends MiddlewareHandler<any, any, any>[] ? MiddlewareToHandlerType<[MiddlewareHandler<DeepSimplify<OfHandlerType<First>["env"] & OfHandlerType<Second>["env"]>, OfHandlerType<First>["path"], OfHandlerType<First>["input"]>, ...Rest]> : never : never : never : M extends [infer Last] ? Last : MiddlewareHandler<Env>;
type RouteMiddlewareParams<R$1 extends RouteConfig> = OfHandlerType<MiddlewareToHandlerType<AsArray<R$1["middleware"]>>>;
type RouteConfigToEnv<R$1 extends RouteConfig> = RouteMiddlewareParams<R$1> extends never ? Env : RouteMiddlewareParams<R$1>["env"];
type RouteHandler<R$1 extends RouteConfig, E$1 extends Env = RouteConfigToEnv<R$1>, I$1 extends Input = InputTypeParam<R$1> & InputTypeQuery<R$1> & InputTypeHeader<R$1> & InputTypeCookie<R$1> & InputTypeForm<R$1> & InputTypeJson<R$1>, P$1 extends string = ConvertPathType<R$1["path"]>> = Handler<E$1, P$1, I$1, R$1 extends {
  responses: {
    [statusCode: number]: {
      content: {
        [mediaType: string]: ZodMediaTypeObject;
      };
    };
  };
} ? MaybePromise<RouteConfigToTypedResponse<R$1>> : MaybePromise<RouteConfigToTypedResponse<R$1>> | MaybePromise<Response>>;
type RouteHook<R$1 extends RouteConfig, E$1 extends Env = RouteConfigToEnv<R$1>, I$1 extends Input = InputTypeParam<R$1> & InputTypeQuery<R$1> & InputTypeHeader<R$1> & InputTypeCookie<R$1> & InputTypeForm<R$1> & InputTypeJson<R$1>, P$1 extends string = ConvertPathType<R$1["path"]>> = Hook<I$1, E$1, P$1, RouteConfigToTypedResponse<R$1> | Response | Promise<Response> | void | Promise<void>>;
type OpenAPIObjectConfig = Parameters<InstanceType<typeof OpenApiGeneratorV3>["generateDocument"]>[0];
type OpenAPIObjectConfigure<E$1 extends Env, P$1 extends string> = OpenAPIObjectConfig | ((context: Context<E$1, P$1>) => OpenAPIObjectConfig);
type OpenAPIGeneratorOptions = ConstructorParameters<typeof OpenApiGeneratorV3>[1];
type OpenAPIGeneratorConfigure<E$1 extends Env, P$1 extends string> = OpenAPIGeneratorOptions | ((context: Context<E$1, P$1>) => OpenAPIGeneratorOptions);
declare class OpenAPIHono<E$1 extends Env = Env, S extends Schema = {}, BasePath extends string = "/"> extends Hono<E$1, S, BasePath> {
  openAPIRegistry: OpenAPIRegistry;
  defaultHook?: OpenAPIHonoOptions<E$1>["defaultHook"];
  constructor(init?: HonoInit<E$1>);
  /**
  *
  * @param {RouteConfig} route - The route definition which you create with `createRoute()`.
  * @param {Handler} handler - The handler. If you want to return a JSON object, you should specify the status code with `c.json()`.
  * @param {Hook} hook - Optional. The hook method defines what it should do after validation.
  * @example
  * app.openapi(
  *   route,
  *   (c) => {
  *     // ...
  *     return c.json(
  *       {
  *         age: 20,
  *         name: 'Young man',
  *       },
  *       200 // You should specify the status code even if it's 200.
  *     )
  *   },
  *  (result, c) => {
  *    if (!result.success) {
  *      return c.json(
  *        {
  *          code: 400,
  *          message: 'Custom Message',
  *        },
  *        400
  *      )
  *    }
  *  }
  *)
  */
  openapi: <R extends RouteConfig, I extends Input = InputTypeParam<R> & InputTypeQuery<R> & InputTypeHeader<R> & InputTypeCookie<R> & InputTypeForm<R> & InputTypeJson<R>, P extends string = ConvertPathType<R["path"]>>({
    middleware: routeMiddleware,
    hide,
    ...route
  }: R, handler: Handler<R["middleware"] extends MiddlewareHandler[] | MiddlewareHandler ? RouteMiddlewareParams<R>["env"] & E$1 : E$1, P, I, R extends {
    responses: {
      [statusCode: number]: {
        content: {
          [mediaType: string]: ZodMediaTypeObject;
        };
      };
    };
  } ? MaybePromise<RouteConfigToTypedResponse<R>> : MaybePromise<RouteConfigToTypedResponse<R>> | MaybePromise<Response>>, hook?: Hook<I, E$1, P, R extends {
    responses: {
      [statusCode: number]: {
        content: {
          [mediaType: string]: ZodMediaTypeObject;
        };
      };
    };
  } ? MaybePromise<RouteConfigToTypedResponse<R>> | undefined : MaybePromise<RouteConfigToTypedResponse<R>> | MaybePromise<Response> | undefined> | undefined) => OpenAPIHono<E$1, S & ToSchema<R["method"], MergePath<BasePath, P>, I, RouteConfigToTypedResponse<R>>, BasePath>;
  getOpenAPIDocument: (objectConfig: OpenAPIObjectConfig, generatorConfig?: OpenAPIGeneratorOptions) => OpenAPIObject;
  getOpenAPI31Document: (objectConfig: OpenAPIObjectConfig, generatorConfig?: OpenAPIGeneratorOptions) => OpenAPIObject$1;
  doc: <P extends string>(path: P, configureObject: OpenAPIObjectConfigure<E$1, P>, configureGenerator?: OpenAPIGeneratorConfigure<E$1, P>) => OpenAPIHono<E$1, S & ToSchema<"get", MergePath<BasePath, P>, {}, {}>, BasePath>;
  doc31: <P extends string>(path: P, configureObject: OpenAPIObjectConfigure<E$1, P>, configureGenerator?: OpenAPIGeneratorConfigure<E$1, P>) => OpenAPIHono<E$1, S & ToSchema<"get", MergePath<BasePath, P>, {}, {}>, BasePath>;
  route<SubPath extends string, SubEnv extends Env, SubSchema extends Schema, SubBasePath extends string>(path: SubPath, app: Hono<SubEnv, SubSchema, SubBasePath>): OpenAPIHono<E$1, MergeSchemaPath<SubSchema, MergePath<BasePath, SubPath>> & S, BasePath>;
  route<SubPath extends string>(path: SubPath): Hono<E$1, RemoveBlankRecord<S>, BasePath>;
  basePath<SubPath extends string>(path: SubPath): OpenAPIHono<E$1, S, MergePath<BasePath, SubPath>>;
  onError: (handler: ErrorHandler<E$1>) => OpenAPIHono<E$1, S, BasePath>;
  notFound: (handler: NotFoundHandler<E$1>) => OpenAPIHono<E$1, S, BasePath>;
}
type RoutingPath<P$1 extends string> = P$1 extends `${infer Head}/{${infer Param}}${infer Tail}` ? `${Head}/:${Param}${RoutingPath<Tail>}` : P$1;
declare const createRoute: <P extends string, R extends Omit<RouteConfig, "path"> & {
  path: P;
}>(routeConfig: R) => R & {
  getRoutingPath(): RoutingPath<R["path"]>;
};
//#endregion
export { DeepSimplify, Hook, MiddlewareToHandlerType, OfHandlerType, OpenAPIGeneratorConfigure, OpenAPIGeneratorOptions, OpenAPIHono, OpenAPIHonoOptions, OpenAPIObjectConfigure, RouteConfig, RouteConfigToEnv, RouteConfigToTypedResponse, RouteHandler, RouteHook, createRoute, extendZodWithOpenApi, z };
//# sourceMappingURL=index.d.cts.map