"use strict";
// cspell:disable-file
// Note: This is a generated file. DO NOT EDIT!
Object.defineProperty(exports, "__esModule", { value: true });
exports.movePage = exports.oauthIntrospect = exports.oauthRevoke = exports.oauthToken = exports.getFileUpload = exports.completeFileUpload = exports.sendFileUpload = exports.listFileUploads = exports.createFileUpload = exports.getComment = exports.listComments = exports.createComment = exports.search = exports.createDatabase = exports.updateDatabase = exports.getDatabase = exports.listDataSourceTemplates = exports.createDataSource = exports.queryDataSource = exports.updateDataSource = exports.getDataSource = exports.appendBlockChildren = exports.listBlockChildren = exports.deleteBlock = exports.updateBlock = exports.getBlock = exports.getPageProperty = exports.updatePage = exports.getPage = exports.createPage = exports.listUsers = exports.getUser = exports.getSelf = void 0;
/**
 * Retrieve your token's bot user
 */
exports.getSelf = {
    method: "get",
    pathParams: [],
    queryParams: [],
    bodyParams: [],
    path: () => `users/me`,
};
/**
 * Retrieve a user
 */
exports.getUser = {
    method: "get",
    pathParams: ["user_id"],
    queryParams: [],
    bodyParams: [],
    path: (p) => `users/${p.user_id}`,
};
/**
 * List all users
 */
exports.listUsers = {
    method: "get",
    pathParams: [],
    queryParams: ["start_cursor", "page_size"],
    bodyParams: [],
    path: () => `users`,
};
/**
 * Create a page
 */
exports.createPage = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: [
        "parent",
        "properties",
        "icon",
        "cover",
        "content",
        "children",
        "template",
    ],
    path: () => `pages`,
};
/**
 * Retrieve a page
 */
exports.getPage = {
    method: "get",
    pathParams: ["page_id"],
    queryParams: ["filter_properties"],
    bodyParams: [],
    path: (p) => `pages/${p.page_id}`,
};
/**
 * Update page properties
 */
exports.updatePage = {
    method: "patch",
    pathParams: ["page_id"],
    queryParams: [],
    bodyParams: [
        "properties",
        "icon",
        "cover",
        "is_locked",
        "template",
        "erase_content",
        "archived",
        "in_trash",
    ],
    path: (p) => `pages/${p.page_id}`,
};
/**
 * Retrieve a page property item
 */
exports.getPageProperty = {
    method: "get",
    pathParams: ["page_id", "property_id"],
    queryParams: ["start_cursor", "page_size"],
    bodyParams: [],
    path: (p) => `pages/${p.page_id}/properties/${p.property_id}`,
};
/**
 * Retrieve a block
 */
exports.getBlock = {
    method: "get",
    pathParams: ["block_id"],
    queryParams: [],
    bodyParams: [],
    path: (p) => `blocks/${p.block_id}`,
};
/**
 * Update a block
 */
exports.updateBlock = {
    method: "patch",
    pathParams: ["block_id"],
    queryParams: [],
    bodyParams: [
        "embed",
        "type",
        "archived",
        "in_trash",
        "bookmark",
        "image",
        "video",
        "pdf",
        "file",
        "audio",
        "code",
        "equation",
        "divider",
        "breadcrumb",
        "table_of_contents",
        "link_to_page",
        "table_row",
        "heading_1",
        "heading_2",
        "heading_3",
        "paragraph",
        "bulleted_list_item",
        "numbered_list_item",
        "quote",
        "to_do",
        "toggle",
        "template",
        "callout",
        "synced_block",
        "table",
        "column",
    ],
    path: (p) => `blocks/${p.block_id}`,
};
/**
 * Delete a block
 */
exports.deleteBlock = {
    method: "delete",
    pathParams: ["block_id"],
    queryParams: [],
    bodyParams: [],
    path: (p) => `blocks/${p.block_id}`,
};
/**
 * Retrieve block children
 */
exports.listBlockChildren = {
    method: "get",
    pathParams: ["block_id"],
    queryParams: ["start_cursor", "page_size"],
    bodyParams: [],
    path: (p) => `blocks/${p.block_id}/children`,
};
/**
 * Append block children
 */
exports.appendBlockChildren = {
    method: "patch",
    pathParams: ["block_id"],
    queryParams: [],
    bodyParams: ["children", "after"],
    path: (p) => `blocks/${p.block_id}/children`,
};
/**
 * Retrieve a data source
 */
exports.getDataSource = {
    method: "get",
    pathParams: ["data_source_id"],
    queryParams: [],
    bodyParams: [],
    path: (p) => `data_sources/${p.data_source_id}`,
};
/**
 * Update a data source
 */
exports.updateDataSource = {
    method: "patch",
    pathParams: ["data_source_id"],
    queryParams: [],
    bodyParams: ["title", "icon", "properties", "in_trash", "archived", "parent"],
    path: (p) => `data_sources/${p.data_source_id}`,
};
/**
 * Query a data source
 */
exports.queryDataSource = {
    method: "post",
    pathParams: ["data_source_id"],
    queryParams: ["filter_properties"],
    bodyParams: [
        "sorts",
        "filter",
        "start_cursor",
        "page_size",
        "archived",
        "in_trash",
        "result_type",
    ],
    path: (p) => `data_sources/${p.data_source_id}/query`,
};
/**
 * Create a data source
 */
exports.createDataSource = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: ["parent", "properties", "title", "icon"],
    path: () => `data_sources`,
};
/**
 * List templates in a data source
 */
exports.listDataSourceTemplates = {
    method: "get",
    pathParams: ["data_source_id"],
    queryParams: ["name", "start_cursor", "page_size"],
    bodyParams: [],
    path: (p) => `data_sources/${p.data_source_id}/templates`,
};
/**
 * Retrieve a database
 */
exports.getDatabase = {
    method: "get",
    pathParams: ["database_id"],
    queryParams: [],
    bodyParams: [],
    path: (p) => `databases/${p.database_id}`,
};
/**
 * Update a database
 */
exports.updateDatabase = {
    method: "patch",
    pathParams: ["database_id"],
    queryParams: [],
    bodyParams: [
        "parent",
        "title",
        "description",
        "is_inline",
        "icon",
        "cover",
        "in_trash",
        "is_locked",
    ],
    path: (p) => `databases/${p.database_id}`,
};
/**
 * Create a database
 */
exports.createDatabase = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: [
        "parent",
        "title",
        "description",
        "is_inline",
        "initial_data_source",
        "icon",
        "cover",
    ],
    path: () => `databases`,
};
/**
 * Search by title
 */
exports.search = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: ["sort", "query", "start_cursor", "page_size", "filter"],
    path: () => `search`,
};
/**
 * Create a comment
 */
exports.createComment = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: [
        "rich_text",
        "attachments",
        "display_name",
        "parent",
        "discussion_id",
    ],
    path: () => `comments`,
};
/**
 * List comments
 */
exports.listComments = {
    method: "get",
    pathParams: [],
    queryParams: ["block_id", "start_cursor", "page_size"],
    bodyParams: [],
    path: () => `comments`,
};
/**
 * Retrieve a comment
 */
exports.getComment = {
    method: "get",
    pathParams: ["comment_id"],
    queryParams: [],
    bodyParams: [],
    path: (p) => `comments/${p.comment_id}`,
};
/**
 * Create a file upload
 */
exports.createFileUpload = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: [
        "mode",
        "filename",
        "content_type",
        "number_of_parts",
        "external_url",
    ],
    path: () => `file_uploads`,
};
/**
 * List file uploads
 */
exports.listFileUploads = {
    method: "get",
    pathParams: [],
    queryParams: ["status", "start_cursor", "page_size"],
    bodyParams: [],
    path: () => `file_uploads`,
};
/**
 * Upload a file
 */
exports.sendFileUpload = {
    method: "post",
    pathParams: ["file_upload_id"],
    queryParams: [],
    bodyParams: [],
    formDataParams: ["file", "part_number"],
    path: (p) => `file_uploads/${p.file_upload_id}/send`,
};
/**
 * Complete a multi-part file upload
 */
exports.completeFileUpload = {
    method: "post",
    pathParams: ["file_upload_id"],
    queryParams: [],
    bodyParams: [],
    path: (p) => `file_uploads/${p.file_upload_id}/complete`,
};
/**
 * Retrieve a file upload
 */
exports.getFileUpload = {
    method: "get",
    pathParams: ["file_upload_id"],
    queryParams: [],
    bodyParams: [],
    path: (p) => `file_uploads/${p.file_upload_id}`,
};
/**
 * Exchange an authorization code for an access and refresh token
 */
exports.oauthToken = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: [
        "grant_type",
        "code",
        "redirect_uri",
        "external_account",
        "refresh_token",
    ],
    path: () => `oauth/token`,
};
/**
 * Revoke a token
 */
exports.oauthRevoke = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: ["token"],
    path: () => `oauth/revoke`,
};
/**
 * Introspect a token
 */
exports.oauthIntrospect = {
    method: "post",
    pathParams: [],
    queryParams: [],
    bodyParams: ["token"],
    path: () => `oauth/introspect`,
};
/**
 * Move a page
 */
exports.movePage = {
    method: "post",
    pathParams: ["page_id"],
    queryParams: [],
    bodyParams: ["parent"],
    path: (p) => `pages/${p.page_id}/move`,
};
//# sourceMappingURL=api-endpoints.js.map