'use strict';

var index_js = require('../number/index.js');

function token(type, content = "", meta) {
  return { type, content, meta };
}
const tokenSpace = tokenText(" ");
const tokenSeparator = token("separator", "; ");
function join(tokens, sep = tokenSpace) {
  return tokens.reduce((acc, t) => {
    acc.push(sep, t);
    return acc;
  }, []).slice(1);
}
function tokenText(t) {
  return token("text", t);
}
function tokenName(t) {
  return token("name", t);
}
function tokenImage(t) {
  return token("image", t || "");
}
function tokenNetwork(t) {
  return token("network", t || "");
}
function tokenTime(t) {
  return token("time", new Date(t * 1e3).toJSON());
}
function tokenAddr(t) {
  return token("address", t || "");
}
function tokenHandle(t, addr, network) {
  if (!addr) return token("address", t || "");
  return token("address", t || "", { address: addr, network: network || "" });
}
const INFINITY_VALUE = "115792089237316195423570985008687907853269984665640564039457584007913129639935";
function tokenValue(t) {
  if (!t) return [token("number", "0")];
  if (t.value === INFINITY_VALUE)
    return [token("number", "infinite"), token("symbol", t.symbol)];
  return [
    token("symbolImage", t.image),
    token("number", index_js.formatTokenValue(t.value, t.decimals) || "0"),
    token("symbol", t.symbol)
  ];
}
function tokenPlatform(t) {
  let platform = "";
  if (t.platform) {
    platform = t.platform;
    return [tokenText("on"), token("platform", platform)];
  }
  return [];
}
function tokenPost(t) {
  if (t.tag !== "social") {
    return tokenText("");
  }
  if (t.metadata) {
    if ("title" in t.metadata && t.metadata.title && !(t.platform === "Lens" && t.metadata.title)) {
      return token("html", t.metadata.title);
    }
    if ("body" in t.metadata && t.metadata.body) {
      return token("html", t.metadata.body);
    }
    if ("target" in t.metadata && t.metadata.target && "body" in t.metadata.target && // FIXME: remove ts-ignore after GI fixing the type
    // @ts-ignore target is not null
    t.metadata.target.body) {
      return token("html", t.metadata.target.body);
    }
  }
  return token("html", "");
}
function tokenAsset(name, meta) {
  const img = meta?.preview;
  if (img) {
    return [token("assetImage", img), token("name", name, meta)];
  }
  return [token("name", name, meta)];
}

exports.join = join;
exports.token = token;
exports.tokenAddr = tokenAddr;
exports.tokenAsset = tokenAsset;
exports.tokenHandle = tokenHandle;
exports.tokenImage = tokenImage;
exports.tokenName = tokenName;
exports.tokenNetwork = tokenNetwork;
exports.tokenPlatform = tokenPlatform;
exports.tokenPost = tokenPost;
exports.tokenSeparator = tokenSeparator;
exports.tokenSpace = tokenSpace;
exports.tokenText = tokenText;
exports.tokenTime = tokenTime;
exports.tokenValue = tokenValue;
//# sourceMappingURL=token.cjs.map
//# sourceMappingURL=token.cjs.map