import { handleMetadata } from '../../metadata/index.js';

function formatContent(activity) {
  const [action] = activity.actions ?? [];
  return action ? extractContent(activity, action) : void 0;
}
function extractContent(activity, action) {
  let content;
  handleMetadata(action, {
    "social-post": (metadata) => {
      content = extractSocialPost(activity, action, metadata);
    },
    "social-comment": (metadata) => {
      content = extractSocialPost(activity, action, metadata);
    },
    "social-mint": (metadata) => {
      content = extractSocialPost(activity, action, metadata);
    },
    "social-share": (metadata) => {
      content = extractSocialPost(activity, action, metadata);
    },
    "social-revise": (metadata) => {
      content = extractSocialPost(activity, action, metadata);
    },
    "social-delete": (metadata) => {
      content = extractSocialPost(activity, action, metadata);
    }
  });
  return content;
}
function formatTitle(title, body) {
  if (!title) return title;
  const _title = title.replaceAll("\u2026", "");
  return body?.startsWith(_title) ? void 0 : _title;
}
function checkTargetExist(target) {
  if (!target) return false;
  if (!!target.body || !!target.media || !!target.title) return true;
  return false;
}
function extractSocialPost(activity, action, metadata) {
  const raw = metadata.target;
  const target = raw ? {
    authorUrl: raw.authorUrl,
    handle: raw.handle,
    address: action.to,
    profileId: raw.profileId,
    title: formatTitle(raw.title, raw.body),
    body: raw.body,
    media: raw.media
  } : void 0;
  if (target?.media && activity.network?.toLowerCase() === "mastodon") {
    target.media = target.media.slice(1);
  }
  const res = {
    authorUrl: metadata.authorUrl,
    handle: metadata.handle,
    address: action.from,
    profileId: metadata.profileId,
    title: formatTitle(metadata.title, metadata.body),
    body: metadata.body,
    media: metadata.media,
    target
  };
  if (res.media && activity.network?.toLowerCase() === "mastodon") {
    res.media = res.media.slice(1);
  }
  return res;
}

export { checkTargetExist, extractContent, formatContent, formatTitle };
//# sourceMappingURL=index.js.map
//# sourceMappingURL=index.js.map