/**
 * Method configuration and request processing for MCP server instrumentation
 */
/**
 * Extracts target info from method and params based on method type
 * @param method - MCP method name
 * @param params - Method parameters
 * @returns Target name and attributes for span instrumentation
 */
export declare function extractTargetInfo(method: string, params: Record<string, unknown>): {
    target?: string;
    attributes: Record<string, string>;
};
/**
 * Extracts request arguments based on method type
 * @param method - MCP method name
 * @param params - Method parameters
 * @returns Arguments as span attributes with mcp.request.argument prefix
 */
export declare function getRequestArguments(method: string, params: Record<string, unknown>): Record<string, string>;
//# sourceMappingURL=methodConfig.d.ts.map