# node-narou

[![npm version](https://badge.fury.io/js/narou.svg)](https://badge.fury.io/js/narou)
[![Node.js CI](https://github.com/deflis/node-narou/actions/workflows/nodejs-test.yml/badge.svg)](https://github.com/deflis/node-narou/actions/workflows/nodejs-test.yml)

[![DeepWiki](https://img.shields.io/badge/DeepWiki-deflis%2Fnode--narou-blue.svg?logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAyCAYAAAAnWDnqAAAAAXNSR0IArs4c6QAAA05JREFUaEPtmUtyEzEQhtWTQyQLHNak2AB7ZnyXZMEjXMGeK/AIi+QuHrMnbChYY7MIh8g01fJoopFb0uhhEqqcbWTp06/uv1saEDv4O3n3dV60RfP947Mm9/SQc0ICFQgzfc4CYZoTPAswgSJCCUJUnAAoRHOAUOcATwbmVLWdGoH//PB8mnKqScAhsD0kYP3j/Yt5LPQe2KvcXmGvRHcDnpxfL2zOYJ1mFwrryWTz0advv1Ut4CJgf5uhDuDj5eUcAUoahrdY/56ebRWeraTjMt/00Sh3UDtjgHtQNHwcRGOC98BJEAEymycmYcWwOprTgcB6VZ5JK5TAJ+fXGLBm3FDAmn6oPPjR4rKCAoJCal2eAiQp2x0vxTPB3ALO2CRkwmDy5WohzBDwSEFKRwPbknEggCPB/imwrycgxX2NzoMCHhPkDwqYMr9tRcP5qNrMZHkVnOjRMWwLCcr8ohBVb1OMjxLwGCvjTikrsBOiA6fNyCrm8V1rP93iVPpwaE+gO0SsWmPiXB+jikdf6SizrT5qKasx5j8ABbHpFTx+vFXp9EnYQmLx02h1QTTrl6eDqxLnGjporxl3NL3agEvXdT0WmEost648sQOYAeJS9Q7bfUVoMGnjo4AZdUMQku50McDcMWcBPvr0SzbTAFDfvJqwLzgxwATnCgnp4wDl6Aa+Ax283gghmj+vj7feE2KBBRMW3FzOpLOADl0Isb5587h/U4gGvkt5v60Z1VLG8BhYjbzRwyQZemwAd6cCR5/XFWLYZRIMpX39AR0tjaGGiGzLVyhse5C9RKC6ai42ppWPKiBagOvaYk8lO7DajerabOZP46Lby5wKjw1HCRx7p9sVMOWGzb/vA1hwiWc6jm3MvQDTogQkiqIhJV0nBQBTU+3okKCFDy9WwferkHjtxib7t3xIUQtHxnIwtx4mpg26/HfwVNVDb4oI9RHmx5WGelRVlrtiw43zboCLaxv46AZeB3IlTkwouebTr1y2NjSpHz68WNFjHvupy3q8TFn3Hos2IAk4Ju5dCo8B3wP7VPr/FGaKiG+T+v+TQqIrOqMTL1VdWV1DdmcbO8KXBz6esmYWYKPwDL5b5FA1a0hwapHiom0r/cKaoqr+27/XcrS5UwSMbQAAAABJRU5ErkJggg==)](https://deepwiki.com/deflis/node-narou)
<!-- DeepWiki badge generated by https://deepwiki.ryoppippi.com/ -->


[なろうデベロッパー](https://dev.syosetu.com/)の API を fluent interface で利用できるラッパーライブラリです。
ブラウザでの JSONP の利用も可能です。

以下の API をラップしています。

- [なろう小説 API](https://dev.syosetu.com/man/api/)
- [なろう小説ランキング API](https://dev.syosetu.com/man/rankapi/)
- [なろう殿堂入り API](https://dev.syosetu.com/man/rankinapi/)
- [なろう R18 小説 API](https://dev.syosetu.com/xman/api/)

## Installation

以下のコマンドでインストールできます。

```
npm install narou
```

## Usage - API

https://deflis.github.io/node-narou/ を参照してください。

ブラウザで利用したい場合 `narou/browser` をimportしてください。こちらを利用することで自動的にfetch(nodejs)への依存がなくなり、JSONPを利用するようになります。

すでにサポート終了していますがfetchをサポートしないNode.jsバージョンで利用する場合は 、 `NarouNovelFetch` にfetchのNode.js実装を渡してください。
なお、その場合の動作は確認していないので動かなければIssueを立ててください。


## Example

```typescript
import { search, ranking, rankingHistory, searchR18 } from "narou";
import {
  Genre,
  GenreNotation,
  Order,
  NovelTypeParam,
  RankingType,
  R18Site,
  R18SiteNotation,
} from "narou";

// なろう小説 API
const searchResult = await search("word")
  .genre(Genre.RenaiIsekai) // 異世界〔恋愛〕
  .order(Order.FavoriteNovelCount) // ブックマーク数の多い順
  .type(NovelTypeParam.RensaiNow) // 連載中
  .execute();

console.log(searchResult.allcount);

for (const novel of searchResult.values) {
  console.log(novel.title);
  console.log(novel.ncode);
  console.log(GenreNotation[novel.genre]); // 値から名前を取得できるヘルパーもあります
}

// なろう小説ランキング API
const rankingResult = await ranking()
  .date(new Date("2023-04-01"))
  .type(RankingType.Daily)
  .execute();

for (const novel of rankingResult) {
  console.log(novel.ncode);
  console.log(novel.rank);
  console.log(novel.pt);
}

// なろう小説ランキング API となろう小説 API を組み合わせたヘルパーもあります
const rankingResultWithDetail = await ranking()
  .date(new Date("2023-04-01"))
  .type(RankingType.Daily)
  .executeWithFields();

for (const novel of rankingResultWithDetail) {
  console.log(novel.ncode);
  console.log(novel.rank);
  console.log(novel.pt);
  console.log(novel.title);
}

// なろう殿堂入り API
const rankingHistoryResult = await rankingHistory("**NCODE**");

for (const history of rankingHistoryResult) {
  console.log(history.type);
  console.log(history.date);
  console.log(history.pt);
  console.log(history.rank);
}

// 18禁小説 API
const searchR18Result = await searchR18("word")
  .r18Site(R18Site.Nocturne) // ノクターン
  .order(Order.FavoriteNovelCount) // ブックマーク数の多い順
  .type(NovelTypeParam.RensaiNow) // 連載中
  .execute();

console.log(searchR18Result.allcount);

for (const novel of searchR18Result.values) {
  console.log(novel.title);
  console.log(novel.ncode);
  console.log(R18SiteNotation[novel.nocgenre]); // 値から名前を取得できるヘルパーもあります
}
```

## Development

```

# watch

npm run watch

# build

npm run build

# test

npm run test

```

## Contributing

1. Fork it!
2. Create your feature branch: `git checkout -b my-new-feature`
3. Commit your changes: `git commit -am 'Add some feature'`
4. Push to the branch: `git push origin my-new-feature`
5. Submit a pull request :D

## License

MIT
