"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/narou-jsonp.ts
var narou_jsonp_exports = {};
__export(narou_jsonp_exports, {
  default: () => NarouNovelJsonp
});
module.exports = __toCommonJS(narou_jsonp_exports);

// src/narou-search-results.ts
var NarouSearchResults = class {
  /**
   * @constractor
   * @private
   */
  constructor([header, ...result], params) {
    const count2 = header.allcount;
    const limit = params.lim ?? 20;
    const start = params.st ?? 0;
    this.allcount = count2;
    this.limit = limit;
    this.start = start;
    this.page = start / limit;
    this.length = result.length;
    this.values = result;
  }
};

// src/narou.ts
var NarouNovel = class {
  /**
   * APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @param endpoint APIエンドポイント
   * @returns 検索結果
   */
  async executeSearch(params, endpoint = "https://api.syosetu.com/novelapi/api/") {
    return new NarouSearchResults(await this.execute(params, endpoint), params);
  }
  /**
   * 小説APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/man/api/
   */
  async executeNovel(params) {
    return await this.executeSearch(
      params,
      "https://api.syosetu.com/novelapi/api/"
    );
  }
  /**
   * R18小説APIへの検索リクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/xman/api/
   */
  async executeNovel18(params) {
    return await this.executeSearch(
      params,
      "https://api.syosetu.com/novel18api/api/"
    );
  }
  /**
   * ランキングAPIへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns ランキング結果
   * @see https://dev.syosetu.com/man/rankapi/
   */
  async executeRanking(params) {
    return await this.execute(params, "https://api.syosetu.com/rank/rankget/");
  }
  /**
   * 殿堂入りAPiへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns ランキング履歴結果
   * @see https://dev.syosetu.com/man/rankinapi/
   */
  async executeRankingHistory(params) {
    return await this.execute(params, "https://api.syosetu.com/rank/rankin/");
  }
  /**
   * ユーザー検索APIへのリクエストを実行する
   * @param params クエリパラメータ
   * @returns 検索結果
   * @see https://dev.syosetu.com/man/userapi/
   */
  async executeUserSearch(params) {
    return new NarouSearchResults(
      await this.execute(params, "https://api.syosetu.com/userapi/api/"),
      params
    );
  }
};

// src/util/jsonp.ts
var count = 0;
var noop = function() {
};
function jsonp(url, { prefix = "__jp", param = "callback", timeout = 15e3 } = {}) {
  return new Promise(function(resolve, reject) {
    const targetChild = document.getElementsByTagName("script").item(0);
    const target = targetChild?.parentNode ?? document.head;
    const id = `${prefix}${count++}`;
    const cleanup = function() {
      if (script && script.parentNode) {
        script.parentNode.removeChild(script);
      }
      window[id] = noop;
      if (timer) {
        clearTimeout(timer);
      }
    };
    const timer = timeout > 0 ? setTimeout(() => {
      cleanup();
      reject(new Error("Timeout"));
    }, timeout) : void 0;
    const callback = (data) => {
      cleanup();
      resolve(data);
    };
    window[id] = callback;
    const script = document.createElement("script");
    const urlObj = new URL(url);
    urlObj.searchParams.set(param, id);
    script.setAttribute("src", urlObj.toString());
    target.insertBefore(script, targetChild);
  });
}

// src/narou-jsonp.ts
var NarouNovelJsonp = class extends NarouNovel {
  async execute(params, endpoint) {
    const query = { ...params, out: "jsonp" };
    query.gzip = 0;
    const url = new URL(endpoint);
    Object.entries(query).forEach(([key, value]) => {
      if (value !== void 0) {
        url.searchParams.append(key, value.toString());
      }
    });
    return await jsonp(url.toString());
  }
};
//# sourceMappingURL=narou-jsonp.cjs.map