/**
 * 文字列の日付（yyyyMMdd形式）をDateオブジェクトに変換する
 * @param dateStr yyyyMMdd形式の日付文字列
 * @returns Dateオブジェクト
 */
declare function parseDate(dateStr: string): Date;
/**
 * 日付をyyyyMMdd形式の文字列に変換する
 * @param date 日付
 * @returns yyyyMMdd形式の文字列
 */
declare function formatDate(date: Date): string;
/**
 * 指定された日数を加算した新しい日付を返す
 * @param date 元の日付
 * @param days 加算する日数
 * @returns 新しい日付
 */
declare function addDays(date: Date, days: number): Date;

export { addDays, formatDate, parseDate };
