import { renderToString } from 'hono/jsx/dom/server';

import type { Route } from '@/types';
import got from '@/utils/got';
import { parseDate } from '@/utils/parse-date';

export const route: Route = {
    path: '/onair/:lang?',
    categories: ['anime'],
    example: '/bgmlist/onair/zh-Hans',
    parameters: { lang: '语言' },
    features: {
        requireConfig: false,
        requirePuppeteer: false,
        antiCrawler: false,
        supportBT: false,
        supportPodcast: false,
        supportScihub: false,
    },
    name: '开播提醒',
    maintainers: ['x2cf'],
    handler,
};

async function handler(ctx) {
    const lang = ctx.req.param('lang');
    const { data: sites } = await got('https://bgmlist.com/api/v1/bangumi/site');
    const { data } = await got('https://bgmlist.com/api/v1/bangumi/onair');

    return {
        title: '番组放送 开播提醒',
        link: 'https://bgmlist.com/',
        item: data.items.map((item) => {
            item.sites.push({ site: 'dmhy', id: item.titleTranslate['zh-Hans']?.[0] ?? item.title });
            const mappedSites = item.sites.map((site) => ({
                title: sites[site.site].title,
                url: sites[site.site].urlTemplate.replaceAll('{{id}}', site.id),
                begin: site.begin,
            }));
            return {
                title: item.titleTranslate[lang]?.[0] ?? item.title,
                link: item.officialSite,
                description: renderToString(
                    <>
                        {mappedSites.map((site) => (
                            <>
                                <a href={site.url}>{site.title}</a>
                                {site.begin ? <>（开播时间：{site.begin}）</> : null}
                                <br />
                            </>
                        ))}
                    </>
                ),
                pubDate: parseDate(item.begin),
                guid: item.id,
            };
        }),
    };
}
