/* eslint-disable no-plusplus */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    iterate: function() {
        return iterate;
    },
    match: function() {
        return match;
    },
    same: function() {
        return same;
    }
});
function _type_of(obj) {
    "@swc/helpers - typeof";
    return obj && typeof Symbol !== "undefined" && obj.constructor === Symbol ? "symbol" : typeof obj;
}
var isObj = function(value) {
    return typeof value === "object" && value !== null;
};
var isBool = function(value) {
    return typeof value === "boolean";
};
function iterate(t, cb) {
    var tree = t;
    if (Array.isArray(tree)) {
        for(var idx = 0; idx < tree.length; idx++){
            tree[idx] = iterate(cb(tree[idx]), cb);
        }
    } else if (isObj(tree) && "content" in tree) {
        iterate(tree.content, cb);
    }
    return tree;
}
function same(expected, actual) {
    if ((typeof expected === "undefined" ? "undefined" : _type_of(expected)) !== (typeof actual === "undefined" ? "undefined" : _type_of(actual))) {
        return false;
    }
    if (!isObj(expected) || expected === null) {
        return expected === actual;
    }
    if (Array.isArray(expected)) {
        return expected.every(function(exp) {
            return [].some.call(actual, function(act) {
                return same(exp, act);
            });
        });
    }
    if (isObj(expected) && isObj(actual)) {
        return Object.keys(expected).every(function(key) {
            var ao = actual[key];
            var eo = expected[key];
            if (isObj(eo) && isObj(ao)) {
                return same(eo, ao);
            }
            if (isBool(eo)) {
                return eo !== (ao === null);
            }
            return ao === eo;
        });
    }
    return false;
}
function match(t, expression, cb) {
    if (Array.isArray(expression)) {
        return iterate(t, function(node) {
            for(var idx = 0; idx < expression.length; idx++){
                if (same(expression[idx], node)) {
                    return cb(node);
                }
            }
            return node;
        });
    }
    return iterate(t, function(node) {
        return same(expression, node) ? cb(node) : node;
    });
}
