import { TagNodeTree, TagPosition } from "./common.mjs";
export interface ParseError {
    tagName: string;
    lineNumber: number;
    columnNumber: number;
}
export interface TagNode {
    readonly tag: string;
    attrs?: Record<string, unknown>;
    content?: TagNodeTree;
    start?: TagPosition;
    end?: TagPosition;
}
export interface Token<TokenValue = string> {
    readonly t: number;
    readonly v: string;
    readonly l: number;
    readonly r: number;
}
export interface LexerTokenizer {
    tokenize: () => Token<string>[];
    isTokenNested?: (tokenValue: string) => boolean;
}
export interface CommonOptions {
    openTag?: string;
    closeTag?: string;
    onlyAllowTags?: string[];
    enableEscapeTags?: boolean;
    caseFreeTags?: boolean;
    whitespaceInTags?: boolean;
    contextFreeTags?: string[];
}
export interface LexerOptions extends CommonOptions {
    onToken?: (token?: Token<string>) => void;
}
export interface ParseOptions extends CommonOptions {
    createTokenizer?: (input: string, options?: LexerOptions) => LexerTokenizer;
    onError?: (error: ParseError) => void;
}
//# sourceMappingURL=parser.d.mts.map