import _createClient from 'openapi-fetch';

let client = null;
function getDefaultClient() {
  if (!client) {
    client = createClient();
  }
  return client;
}
function setDefaultClient(newClient) {
  client = newClient;
}
function createClient({
  baseUrl = "https://gi.rss3.io",
  ...options
} = {}) {
  return Object.freeze(
    Object.assign({ baseUrl }, _createClient({ baseUrl, ...options }))
  );
}

export { createClient, getDefaultClient, setDefaultClient };
//# sourceMappingURL=client.js.map
//# sourceMappingURL=client.js.map