import { Activity, Action } from '@rss3/api-core';

type TokenType = "text" | "html" | "number" | "image" | "symbolImage" | "assetImage" | "symbol" | "address" | "name" | "platform" | "network" | "separator" | "time" | "unknown";
type Token = {
    type: TokenType;
    content: string;
    meta?: {
        address?: string | null;
        network?: string | null;
        id?: string | null;
        preview?: string;
    };
};
declare function token(type: Token["type"], content?: string, meta?: Token["meta"]): Token;
declare const tokenSpace: Token;
declare const tokenSeparator: Token;
declare function join(tokens: Token[], sep?: Token): Token[];
declare function tokenText(t: string): Token;
declare function tokenName(t: string): Token;
declare function tokenImage(t: string | null | undefined): Token;
declare function tokenNetwork(t: string | null | undefined): Token;
declare function tokenTime(t: number): Token;
declare function tokenAddr(t: string | null | undefined): Token;
declare function tokenHandle(t: string | null | undefined, addr: string | null | undefined, network: string | null | undefined): Token;
type TokenMetadata = {
    symbol?: string;
    decimals?: number;
    image?: string;
    value?: string | null;
};
declare function tokenValue(t: TokenMetadata | null | undefined): Token[];
declare function tokenPlatform(t: Activity | Action): Token[];
declare function tokenPost(t: Action): Token;
declare function tokenAsset(name: string, meta?: Token["meta"]): Token[];

export { type Token, type TokenMetadata, type TokenType, join, token, tokenAddr, tokenAsset, tokenHandle, tokenImage, tokenName, tokenNetwork, tokenPlatform, tokenPost, tokenSeparator, tokenSpace, tokenText, tokenTime, tokenValue };
