import request = require("request");
import http = require("http");
import errors = require("./errors");
import Promise = require("bluebird");

declare namespace requestPromise {
    interface RequestPromise<T = any> extends request.Request {
        then: Promise<T>["then"];
        catch: Promise<T>["catch"];
        finally: Promise<T>["finally"];
        cancel: Promise<T>["cancel"];
        promise(): Promise<T>;
    }

    interface RequestPromiseOptions extends request.CoreOptions {
        simple?: boolean | undefined;
        transform?(body: any, response: request.Response, resolveWithFullResponse?: boolean): any;
        transform2xxOnly?: boolean | undefined;
        resolveWithFullResponse?: boolean | undefined;
    }

    type RequestPromiseAPI<T = any> = request.RequestAPI<
        RequestPromise<T>,
        RequestPromiseOptions,
        request.RequiredUriUrl
    >;
    type OptionsWithUri = request.UriOptions & RequestPromiseOptions;
    type OptionsWithUrl = request.UrlOptions & RequestPromiseOptions;
    type Options = OptionsWithUri | OptionsWithUrl;
}

declare const requestPromise: requestPromise.RequestPromiseAPI;
export = requestPromise;
