import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosResponseWithHTTP2, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace documentai_v1beta3 {
    export interface Options extends GlobalOptions {
        version: 'v1beta3';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Cloud Document AI API
     *
     * Service to parse structured information from unstructured or semi-structured documents using state-of-the-art Google AI such as natural language, computer vision, translation, and AutoML.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const documentai = google.documentai('v1beta3');
     * ```
     */
    export class Documentai {
        context: APIRequestContext;
        projects: Resource$Projects;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * Definition of the validation rules. Those are the input to the validator logic and they are used to validate a document. Next ID: 3
     */
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInput {
        validationRules?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRule[];
    }
    /**
     * Next ID: 9
     */
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRule {
        childAlignmentRule?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleChildAlignmentRule;
        /**
         * Description of the validation rule. This has no use but for documentation
         */
        description?: string | null;
        entityAlignmentRule?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleEntityAlignmentRule;
        fieldOccurrences?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldOccurrences;
        fieldRegex?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldRegex;
        formValidation?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidation;
        /**
         * Name of the validation rule.
         */
        name?: string | null;
        /**
         * Unique identifier of the rule. Optional.
         */
        ruleId?: string | null;
    }
    /**
     * A rule for checking field alignment. Horizontal alignment checks if fields are on the same row by comparing y-coordinates of bounding box centers, while vertical alignment checks if fields are on the same column by comparing x-coordinates of bounding box centers.
     */
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleAlignmentRule {
        alignmentType?: string | null;
        /**
         * The tolerance to use when comparing coordinates.
         */
        tolerance?: number | null;
    }
    /**
     * A rule that aligns specified child fields with a parent field.
     */
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleChildAlignmentRule {
        /**
         * The alignment rule to apply to the child fields.
         */
        alignmentRule?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleAlignmentRule;
        /**
         * The child fields to be aligned within the parent field.
         */
        childFields?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField[];
        /**
         * The full path of the parent field.
         */
        parentField?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField;
    }
    /**
     * The constant value used in the validation rules.
     */
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant {
        floatValue?: number | null;
    }
    /**
     * A rule that aligns specified fields with each other.
     */
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleEntityAlignmentRule {
        /**
         * The alignment rule to apply to the fields.
         */
        alignmentRule?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleAlignmentRule;
        /**
         * The fields to be aligned.
         */
        fields?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField[];
    }
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField {
        /**
         * Default value to use if the field is not present. If the field is missing and the default value is not set, the validation run as if the field is not present in the validation logic.
         */
        defaultValue?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant;
        /**
         * The field name to validate. This can be a simple field name or a nested field one using the ':' (meant as an aggregator) or '*' (meant as foreach) operators.
         */
        fieldName?: string | null;
    }
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldOccurrences {
        field?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField;
        maxOccurrences?: number | null;
        /**
         * Min and max occurrences of the field. If not set, there is limit set. The defined interval is a closed-closed interval, i.e. [min, max].
         */
        minOccurrences?: number | null;
    }
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFieldRegex {
        field?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField;
        /**
         * Python regex to validate the field values.
         */
        pattern?: string | null;
    }
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidation {
        leftOperand?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation;
        rightOperand?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation;
        /**
         * The relational operator to be applied to the operands.
         */
        validationOperator?: string | null;
    }
    export interface Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation {
        /**
         * A list of constants to be used as operands.
         */
        constants?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleConstant[];
        /**
         * A list of fields to be used as operands.
         */
        fields?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleField[];
        /**
         * A list of recursive operations to be used as operands.
         */
        operations?: Schema$CloudAiDocumentaiLabHifiaToolsValidationValidatorInputValidationRuleFormValidationOperation[];
        /**
         * The operation type to be applied to all the operands.
         */
        operationType?: string | null;
    }
    /**
     * Metadata of the auto-labeling documents operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
        /**
         * The list of individual auto-labeling statuses of the dataset documents.
         */
        individualAutoLabelStatuses?: Schema$GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus[];
        /**
         * Total number of the auto-labeling documents.
         */
        totalDocumentCount?: number | null;
    }
    /**
     * The status of individual documents in the auto-labeling process.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsMetadataIndividualAutoLabelStatus {
        /**
         * The document id of the auto-labeled document. This will replace the gcs_uri.
         */
        documentId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentId;
        /**
         * The status of the document auto-labeling.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * The response proto of AutoLabelDocuments method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3AutoLabelDocumentsResponse {
    }
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
        /**
         * Total number of documents that failed to be deleted in storage.
         */
        errorDocumentCount?: number | null;
        /**
         * The list of response details of each document.
         */
        individualBatchDeleteStatuses?: Schema$GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus[];
        /**
         * Total number of documents deleting from dataset.
         */
        totalDocumentCount?: number | null;
    }
    /**
     * The status of each individual document in the batch delete process.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus {
        /**
         * The document id of the document.
         */
        documentId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentId;
        /**
         * The status of deleting the document in storage.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * Response of the delete documents operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchDeleteDocumentsResponse {
    }
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
        /**
         * The destination dataset split type.
         */
        destDatasetType?: string | null;
        /**
         * The destination dataset split type.
         */
        destSplitType?: string | null;
        /**
         * The list of response details of each document.
         */
        individualBatchMoveStatuses?: Schema$GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus[];
    }
    /**
     * The status of each individual document in the batch move process.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsMetadataIndividualBatchMoveStatus {
        /**
         * The document id of the document.
         */
        documentId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentId;
        /**
         * The status of moving the document.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * Response of the batch move documents operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchMoveDocumentsResponse {
    }
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
        /**
         * The list of response details of each document.
         */
        individualBatchUpdateStatuses?: Schema$GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus[];
    }
    /**
     * The status of each individual document in the batch update process.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsMetadataIndividualBatchUpdateStatus {
        /**
         * The document id of the document.
         */
        documentId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentId;
        /**
         * The status of updating the document in storage.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * Response of the batch update documents operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3BatchUpdateDocumentsResponse {
    }
    /**
     * The common metadata for long running operations.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata {
        /**
         * The creation time of the operation.
         */
        createTime?: string | null;
        /**
         * A related resource to this operation.
         */
        resource?: string | null;
        /**
         * The state of the operation.
         */
        state?: string | null;
        /**
         * A message providing more details about the current state of processing.
         */
        stateMessage?: string | null;
        /**
         * The last update time of the operation.
         */
        updateTime?: string | null;
    }
    /**
     * The long-running operation metadata for the CreateLabelerPool method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3CreateLabelerPoolOperationMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for DeleteLabelerPool.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DeleteLabelerPoolOperationMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the DeleteProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DeleteProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the DeleteProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DeleteProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the DeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * Response message for the DeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DeployProcessorVersionResponse {
    }
    /**
     * The long-running operation metadata for the DisableProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DisableProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * Response message for the DisableProcessor method. Intentionally empty proto for adding fields in future.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DisableProcessorResponse {
    }
    /**
     * Document Identifier.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DocumentId {
        /**
         * A document id within user-managed Cloud Storage.
         */
        gcsManagedDocId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId;
        /**
         * Points to a specific revision of the document if set.
         */
        revisionRef?: Schema$GoogleCloudDocumentaiUiv1beta3RevisionRef;
        /**
         * A document id within unmanaged dataset.
         */
        unmanagedDocId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId;
    }
    /**
     * Identifies a document uniquely within the scope of a dataset in the user-managed Cloud Storage option.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DocumentIdGCSManagedDocumentId {
        /**
         * Id of the document (indexed) managed by Content Warehouse.
         */
        cwDocId?: string | null;
        /**
         * Required. The Cloud Storage URI where the actual document is stored.
         */
        gcsUri?: string | null;
    }
    /**
     * Identifies a document uniquely within the scope of a dataset in unmanaged option.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DocumentIdUnmanagedDocumentId {
        /**
         * Required. The id of the document.
         */
        docId?: string | null;
    }
    /**
     * The schema defines the output of the processed document by a processor.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchema {
        /**
         * Description of the schema.
         */
        description?: string | null;
        /**
         * Display name to show to users.
         */
        displayName?: string | null;
        /**
         * Optional. Document level prompt provided by the user. This custom text is injected into the AI model's prompt to provide extra, document-wide guidance for processing.
         */
        documentPrompt?: string | null;
        /**
         * Entity types of the schema.
         */
        entityTypes?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityType[];
        /**
         * Metadata of the schema.
         */
        metadata?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchemaMetadata;
    }
    /**
     * EntityType is the wrapper of a label of the corresponding model with detailed attributes and limitations for entity-based processors. Multiple types can also compose a dependency tree to represent nested types.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityType {
        /**
         * The entity type that this type is derived from. For now, one and only one should be set.
         */
        baseTypes?: string[] | null;
        /**
         * The description of the entity type. Could be used to provide more information about the entity type for model calls.
         */
        description?: string | null;
        /**
         * User defined name for the type.
         */
        displayName?: string | null;
        /**
         * Metadata for the entity type.
         */
        entityTypeMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3EntityTypeMetadata;
        /**
         * If specified, lists all the possible values for this entity. This should not be more than a handful of values. If the number of values is \>10 or could change frequently use the `EntityType.value_ontology` field and specify a list of all possible values in a value ontology file.
         */
        enumValues?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityTypeEnumValues;
        /**
         * Name of the type. It must be unique within the schema file and cannot be a "Common Type". The following naming conventions are used: - Use `snake_casing`. - Name matching is case-sensitive. - Maximum 64 characters. - Must start with a letter. - Allowed characters: ASCII letters `[a-z0-9_-]`. (For backward compatibility internal infrastructure and tooling can handle any ascii character.) - The `/` is sometimes used to denote a property of a type. For example `line_item/amount`. This convention is deprecated, but will still be honored for backward compatibility.
         */
        name?: string | null;
        /**
         * Description the nested structure, or composition of an entity.
         */
        properties?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityTypeProperty[];
    }
    /**
     * Defines the a list of enum values.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityTypeEnumValues {
        /**
         * The individual values that this enum values type can include.
         */
        values?: string[] | null;
    }
    /**
     * Defines properties that can be part of the entity type.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityTypeProperty {
        /**
         * The description of the property. Could be used to provide more information about the property for model calls.
         */
        description?: string | null;
        /**
         * User defined name for the property.
         */
        displayName?: string | null;
        /**
         * Specifies how the entity's value is obtained.
         */
        method?: string | null;
        /**
         * The name of the property. Follows the same guidelines as the EntityType name.
         */
        name?: string | null;
        /**
         * Occurrence type limits the number of instances an entity type appears in the document.
         */
        occurrenceType?: string | null;
        /**
         * Any additional metadata about the property can be added here.
         */
        propertyMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3PropertyMetadata;
        /**
         * A reference to the value type of the property. This type is subject to the same conventions as the `Entity.base_types` field.
         */
        valueType?: string | null;
    }
    /**
     * Metadata for global schema behavior.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchemaMetadata {
        /**
         * If true, on a given page, there can be multiple `document` annotations covering it.
         */
        documentAllowMultipleLabels?: boolean | null;
        /**
         * If true, a `document` entity type can be applied to subdocument (splitting). Otherwise, it can only be applied to the entire document (classification).
         */
        documentSplitter?: boolean | null;
        /**
         * If set, all the nested entities must be prefixed with the parents.
         */
        prefixedNamingOnProperties?: boolean | null;
        /**
         * If set, we will skip the naming format validation in the schema. So the string values in `DocumentSchema.EntityType.name` and `DocumentSchema.EntityType.Property.name` will not be checked.
         */
        skipNamingValidation?: boolean | null;
    }
    /**
     * The long-running operation metadata for the EnableProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3EnableProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * Response message for the EnableProcessor method. Intentionally empty proto for adding fields in future.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3EnableProcessorResponse {
    }
    /**
     * Metadata about an entity type.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3EntityTypeMetadata {
        /**
         * Field tier metadata on the property
         */
        fieldTierMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3FieldTierMetadata;
        /**
         * Human review labeling config on the entity.
         */
        humanReviewLabelingMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3HumanReviewLabelingMetadata;
        /**
         * Human review config on the entity.
         */
        humanReviewMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3HumanReviewValidationMetadata;
        /**
         * Whether the entity type should be considered inactive.
         */
        inactive?: boolean | null;
        /**
         * Schema editability metadata on the entity.
         */
        schemaEditabilityMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3SchemaEditabilityMetadata;
        /**
         * Schema inference metadata on the entity.
         */
        schemaInferenceMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3SchemaInferenceMetadata;
    }
    /**
     * Metadata of the EvaluateProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * Response of the EvaluateProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3EvaluateProcessorVersionResponse {
        /**
         * The resource name of the created evaluation.
         */
        evaluation?: string | null;
    }
    /**
     * Evaluation metrics, either in aggregate or about a specific entity.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3EvaluationMetrics {
        /**
         * The calculated f1 score.
         */
        f1Score?: number | null;
        /**
         * The amount of false negatives.
         */
        falseNegativesCount?: number | null;
        /**
         * The amount of false positives.
         */
        falsePositivesCount?: number | null;
        /**
         * The amount of documents with a ground truth occurrence.
         */
        groundTruthDocumentCount?: number | null;
        /**
         * The amount of occurrences in ground truth documents.
         */
        groundTruthOccurrencesCount?: number | null;
        /**
         * The calculated precision.
         */
        precision?: number | null;
        /**
         * The amount of documents with a predicted occurrence.
         */
        predictedDocumentCount?: number | null;
        /**
         * The amount of occurrences in predicted documents.
         */
        predictedOccurrencesCount?: number | null;
        /**
         * The calculated recall.
         */
        recall?: number | null;
        /**
         * The amount of documents that had an occurrence of this label.
         */
        totalDocumentsCount?: number | null;
        /**
         * The amount of true positives.
         */
        truePositivesCount?: number | null;
    }
    /**
     * Gives a short summary of an evaluation, and links to the evaluation itself.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3EvaluationReference {
        /**
         * An aggregate of the statistics for the evaluation with fuzzy matching on.
         */
        aggregateMetrics?: Schema$GoogleCloudDocumentaiUiv1beta3EvaluationMetrics;
        /**
         * An aggregate of the statistics for the evaluation with fuzzy matching off.
         */
        aggregateMetricsExact?: Schema$GoogleCloudDocumentaiUiv1beta3EvaluationMetrics;
        /**
         * The resource name of the evaluation.
         */
        evaluation?: string | null;
        /**
         * The resource name of the Long Running Operation for the evaluation.
         */
        operation?: string | null;
    }
    /**
     * Metadata of the batch export documents operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
        /**
         * The list of response details of each document.
         */
        individualExportStatuses?: Schema$GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus[];
        /**
         * The list of statistics for each dataset split type.
         */
        splitExportStats?: Schema$GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat[];
    }
    /**
     * The status of each individual document in the export process.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataIndividualExportStatus {
        /**
         * The path to source docproto of the document.
         */
        documentId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentId;
        /**
         * The output_gcs_destination of the exported document if it was successful, otherwise empty.
         */
        outputGcsDestination?: string | null;
        /**
         * The status of the exporting of the document.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * The statistic representing a dataset split type for this export.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ExportDocumentsMetadataSplitExportStat {
        /**
         * The dataset split type.
         */
        splitType?: string | null;
        /**
         * Total number of documents with the given dataset split type to be exported.
         */
        totalDocumentCount?: number | null;
    }
    /**
     * The response proto of ExportDocuments method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ExportDocumentsResponse {
    }
    /**
     * Metadata message associated with the ExportProcessorVersion operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionMetadata {
        /**
         * The common metadata about the operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * Response message associated with the ExportProcessorVersion operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ExportProcessorVersionResponse {
        /**
         * The Cloud Storage URI containing the output artifacts.
         */
        gcsUri?: string | null;
    }
    /**
     * Metadata for how this field value is extracted.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3FieldExtractionMetadata {
        /**
         * Entity query config.
         */
        entityQuery?: Schema$GoogleCloudDocumentaiUiv1beta3FieldExtractionMetadataEntityQuery;
        /**
         * Summary options config.
         */
        summaryOptions?: Schema$GoogleCloudDocumentaiUiv1beta3SummaryOptions;
    }
    /**
     * Message for entity query.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3FieldExtractionMetadataEntityQuery {
        /**
         * The original entity query inputed by the user.
         */
        userEntityQuery?: string | null;
    }
    /**
     * Metadata for the field tier of a property.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3FieldTierMetadata {
        /**
         * Integer that indicates the tier of a property. e.g. Invoice has entities that are classified as tier 1 which is the most important, while tier 2 and tier 3 less so. This attribute can be used to filter schema attributes before running eval. e.g. compute F1 score for only tier 1 entities. If not present this attribute should be inferred as 1.
         */
        tierLevel?: number | null;
    }
    /**
     * Metadata for human review labeling config.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3HumanReviewLabelingMetadata {
        /**
         * Whether to enable normalization editing.
         */
        enableNormalizationEditing?: boolean | null;
    }
    /**
     * Metadata for Human Review config.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3HumanReviewValidationMetadata {
        /**
         * The confidence threshold if human review validation is enabled.
         */
        confidenceThreshold?: number | null;
        /**
         * Whether to enable human review validation.
         */
        enableValidation?: boolean | null;
    }
    /**
     * Metadata of the import document operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
        /**
         * Validation statuses of the batch documents import config.
         */
        importConfigValidationResults?: Schema$GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult[];
        /**
         * The list of response details of each document.
         */
        individualImportStatuses?: Schema$GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus[];
        /**
         * Total number of the documents that are qualified for importing.
         */
        totalDocumentCount?: number | null;
    }
    /**
     * The validation status of each import config. Status is set to an error if there are no documents to import in the `import_config`, or `OK` if the operation will try to proceed with at least one document.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataImportConfigValidationResult {
        /**
         * The source Cloud Storage URI specified in the import config.
         */
        inputGcsSource?: string | null;
        /**
         * The validation status of import config.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * The status of each individual document in the import process.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ImportDocumentsMetadataIndividualImportStatus {
        /**
         * The source Cloud Storage URI of the document.
         */
        inputGcsSource?: string | null;
        /**
         * The document id of imported document if it was successful, otherwise empty.
         */
        outputDocumentId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentId;
        /**
         * The output_gcs_destination of the processed document if it was successful, otherwise empty.
         */
        outputGcsDestination?: string | null;
        /**
         * The status of the importing of the document.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * Response of the import document operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ImportDocumentsResponse {
    }
    /**
     * The long-running operation metadata for the ImportProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionMetadata {
        /**
         * The basic metadata for the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The response message for the ImportProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ImportProcessorVersionResponse {
        /**
         * The destination processor version name.
         */
        processorVersion?: string | null;
    }
    /**
     * The first-class citizen for Document AI. Each processor defines how to extract structural information from a document.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3Processor {
        /**
         * Optional. SchemaVersion used by the Processor. It is the same as Processor's DatasetSchema.schema_version Format is `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}
         */
        activeSchemaVersion?: string | null;
        /**
         * Output only. The time the processor was created.
         */
        createTime?: string | null;
        /**
         * The default processor version.
         */
        defaultProcessorVersion?: string | null;
        /**
         * The display name of the processor.
         */
        displayName?: string | null;
        /**
         * The [KMS key](https://cloud.google.com/security-key-management) used for encryption and decryption in CMEK scenarios.
         */
        kmsKeyName?: string | null;
        /**
         * Output only. Immutable. The resource name of the processor. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`
         */
        name?: string | null;
        /**
         * Output only. Immutable. The http endpoint that can be called to invoke processing.
         */
        processEndpoint?: string | null;
        /**
         * Output only. The processor version aliases.
         */
        processorVersionAliases?: Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionAlias[];
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. The state of the processor.
         */
        state?: string | null;
        /**
         * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`. To get a list of processor types, see FetchProcessorTypes.
         */
        type?: string | null;
    }
    /**
     * A processor version is an implementation of a processor. Each processor can have multiple versions, pretrained by Google internally or uptrained by the customer. A processor can only have one default version at a time. Its document-processing behavior is defined by that version.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersion {
        /**
         * Output only. The time the processor version was created.
         */
        createTime?: string | null;
        /**
         * Output only. Denotes that this `ProcessorVersion` can be deployed and undeployed.
         */
        deploymentAllowed?: boolean | null;
        /**
         * Output only. If set, information about the eventual deprecation of this version.
         */
        deprecationInfo?: Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionDeprecationInfo;
        /**
         * The display name of the processor version.
         */
        displayName?: string | null;
        /**
         * Output only. The schema of the processor version. Describes the output.
         */
        documentSchema?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentSchema;
        /**
         * Output only. Information about Generative AI model-based processor versions.
         */
        genAiModelInfo?: Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionGenAiModelInfo;
        /**
         * Output only. Denotes that this `ProcessorVersion` is managed by Google.
         */
        googleManaged?: boolean | null;
        /**
         * Output only. The KMS key name used for encryption.
         */
        kmsKeyName?: string | null;
        /**
         * Output only. The KMS key version with which data is encrypted.
         */
        kmsKeyVersionName?: string | null;
        /**
         * Output only. The most recently invoked evaluation for the processor version.
         */
        latestEvaluation?: Schema$GoogleCloudDocumentaiUiv1beta3EvaluationReference;
        /**
         * Output only. The model type of this processor version.
         */
        modelType?: string | null;
        /**
         * Identifier. The resource name of the processor version. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processor_version\}`
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * The schema of the processor version. Describes the output.
         */
        schema?: Schema$GoogleCloudDocumentaiUiv1beta3Schema;
        /**
         * Output only. The state of the processor version.
         */
        state?: string | null;
    }
    /**
     * Contains the alias and the aliased resource name of processor version.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionAlias {
        /**
         * The alias in the form of `processor_version` resource name.
         */
        alias?: string | null;
        /**
         * The resource name of aliased processor version.
         */
        processorVersion?: string | null;
    }
    /**
     * Information about the upcoming deprecation of this processor version.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionDeprecationInfo {
        /**
         * The time at which this processor version will be deprecated.
         */
        deprecationTime?: string | null;
        /**
         * If set, the processor version that will be used as a replacement.
         */
        replacementProcessorVersion?: string | null;
    }
    /**
     * Information about Generative AI model-based processor versions.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionGenAiModelInfo {
        /**
         * Information for a custom Generative AI model created by the user.
         */
        customGenAiModelInfo?: Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionGenAiModelInfoCustomGenAiModelInfo;
        /**
         * Information for a pretrained Google-managed foundation model.
         */
        foundationGenAiModelInfo?: Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo;
    }
    /**
     * Information for a custom Generative AI model created by the user. These are created with `Create New Version` in either the `Call foundation model` or `Fine tuning` tabs.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionGenAiModelInfoCustomGenAiModelInfo {
        /**
         * The base processor version ID for the custom model.
         */
        baseProcessorVersionId?: string | null;
        /**
         * The type of custom model created by the user.
         */
        customModelType?: string | null;
    }
    /**
     * Information for a pretrained Google-managed foundation model.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo {
        /**
         * Whether finetuning is allowed for this base processor version.
         */
        finetuningAllowed?: boolean | null;
        /**
         * The minimum number of labeled documents in the training dataset required for finetuning.
         */
        minTrainLabeledDocuments?: number | null;
    }
    /**
     * Metadata about a property.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3PropertyMetadata {
        /**
         * Field extraction metadata on the property.
         */
        fieldExtractionMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3FieldExtractionMetadata;
        /**
         * Field tier metadata on the property
         */
        fieldTierMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3FieldTierMetadata;
        /**
         * Human review labeling config on the property.
         */
        humanReviewLabelingMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3HumanReviewLabelingMetadata;
        /**
         * Human review validation config on the property.
         */
        humanReviewMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3HumanReviewValidationMetadata;
        /**
         * Whether the property should be considered as "inactive".
         */
        inactive?: boolean | null;
        /**
         * Schema editability metadata on the property.
         */
        schemaEditabilityMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3SchemaEditabilityMetadata;
        /**
         * Schema inference metadata on the property.
         */
        schemaInferenceMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3SchemaInferenceMetadata;
    }
    /**
     * The metadata proto of `ResyncDataset` method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
        /**
         * The list of dataset resync statuses. Not checked when ResyncDatasetRequest.dataset_documents is specified.
         */
        datasetResyncStatuses?: Schema$GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus[];
        /**
         * The list of document resync statuses. The same document could have multiple `individual_document_resync_statuses` if it has multiple inconsistencies.
         */
        individualDocumentResyncStatuses?: Schema$GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus[];
    }
    /**
     * Resync status against inconsistency types on the dataset level.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataDatasetResyncStatus {
        /**
         * The type of the inconsistency of the dataset.
         */
        datasetInconsistencyType?: string | null;
        /**
         * The status of resyncing the dataset with regards to the detected inconsistency. Empty if ResyncDatasetRequest.validate_only is `true`.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * Resync status for each document per inconsistency type.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ResyncDatasetMetadataIndividualDocumentResyncStatus {
        /**
         * The document identifier.
         */
        documentId?: Schema$GoogleCloudDocumentaiUiv1beta3DocumentId;
        /**
         * The type of document inconsistency.
         */
        documentInconsistencyType?: string | null;
        /**
         * The status of resyncing the document with regards to the detected inconsistency. Empty if ResyncDatasetRequest.validate_only is `true`.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * The response proto of ResyncDataset method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3ResyncDatasetResponse {
    }
    /**
     * The revision reference specifies which revision on the document to read.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3RevisionRef {
        /**
         * Reads the revision generated by the processor version. The format takes the full resource name of processor version. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        latestProcessorVersion?: string | null;
        /**
         * Reads the revision by the predefined case.
         */
        revisionCase?: string | null;
        /**
         * Reads the revision given by the id.
         */
        revisionId?: string | null;
    }
    /**
     * Metadata of the sample documents operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SampleDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * Response of the sample documents operation.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponse {
        /**
         * The status of sampling documents in test split.
         */
        sampleTestStatus?: Schema$GoogleRpcStatus;
        /**
         * The status of sampling documents in training split.
         */
        sampleTrainingStatus?: Schema$GoogleRpcStatus;
        /**
         * The result of the sampling process.
         */
        selectedDocuments?: Schema$GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument[];
    }
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SampleDocumentsResponseSelectedDocument {
        /**
         * An internal identifier for document.
         */
        documentId?: string | null;
    }
    /**
     * The schema defines the output of the processed document by a processor.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3Schema {
        /**
         * Description of the schema.
         */
        description?: string | null;
        /**
         * Display name to show to users.
         */
        displayName?: string | null;
        /**
         * Entity types of the schema.
         */
        entityTypes?: Schema$GoogleCloudDocumentaiUiv1beta3SchemaEntityType[];
    }
    /**
     * Metadata that specifies whether a label is editable and reasons why. These fields are read-only. Changing these fields has no impact on the backend.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SchemaEditabilityMetadata {
        /**
         * Explicit flag that controls whether the label is editable.
         */
        editable?: boolean | null;
        /**
         * Full resource name of processor versions that contain this label. e.g. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        processorVersions?: string[] | null;
    }
    /**
     * EntityType is the wrapper of a label of the corresponding model with detailed attributes and limitations for entity-based processors. Multiple types can also compose a dependency tree to represent nested types.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SchemaEntityType {
        baseType?: string | null;
        /**
         * Description of the entity type.
         */
        description?: string | null;
        /**
         * If specified, lists all the possible values for this entity.
         */
        enumValues?: string[] | null;
        /**
         * If the entity type is hidden in the schema. This provides the functionality to temporally "disable" an entity without deleting it.
         */
        hide?: boolean | null;
        /**
         * Specifies how the entity's value is obtained.
         */
        method?: string | null;
        /**
         * Occurrence type limits the number of times an entity type appears in the document.
         */
        occurrenceType?: string | null;
        /**
         * Describing the nested structure of an entity. An EntityType may consist of several other EntityTypes. For example, in a document there can be an EntityType `ID`, which consists of EntityType `name` and `address`, with corresponding attributes, such as TEXT for both types and ONCE for occurrence types.
         */
        properties?: Schema$GoogleCloudDocumentaiUiv1beta3SchemaEntityType[];
        /**
         * Source of this entity type.
         */
        source?: string | null;
        /**
         * Name of the type. It must satisfy the following constraints: 1. Must be unique within the set of same level types (with case-insensitive match). 2. Maximum 64 characters. 3. Must start with a letter. 4. Allowed characters: ASCII letters [a-zA-Z], ASCII digits [0-9], or one of the following punctuation characters: * underscore '_' (recommended) * hyphen '-' (allowed, not recommended) * colon ':' (allowed, not recommended) NOTE: Whitespace characters are not allowed. 5. Cannot end with a punctuation character. 6. Cannot contain the following restricted strings: "google", "DocumentAI" (case-insensitive match). 7. A slash character '/' is reserved as a separator in flattened representations of nested entity types (e.g., "line_item/amount") in which case each part (e.g., "line_item", "amount") must comply with the rules defined above. We recommend using the snake case ("snake_case") in entity type names.
         */
        type?: string | null;
    }
    /**
     * Metadata for schema inference. Only used on dataset.schema for schema inference, can be safely ignored elsewhere.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SchemaInferenceMetadata {
        /**
         * True if is inferred by schema inference.
         */
        inferred?: boolean | null;
    }
    /**
     * The long-running operation metadata for the SetDefaultProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * Response message for the SetDefaultProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SetDefaultProcessorVersionResponse {
    }
    /**
     * Metadata for document summarization.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3SummaryOptions {
        /**
         * The format the summary should be in.
         */
        format?: string | null;
        /**
         * How long the summary should be.
         */
        length?: string | null;
    }
    /**
     * The metadata that represents a processor version being created.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
        /**
         * The test dataset validation information.
         */
        testDatasetValidation?: Schema$GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation;
        /**
         * The training dataset validation information.
         */
        trainingDatasetValidation?: Schema$GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation;
    }
    /**
     * The dataset validation information. This includes any and all errors with documents and the dataset.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionMetadataDatasetValidation {
        /**
         * The total number of dataset errors.
         */
        datasetErrorCount?: number | null;
        /**
         * Error information for the dataset as a whole. A maximum of 10 dataset errors will be returned. A single dataset error is terminal for training.
         */
        datasetErrors?: Schema$GoogleRpcStatus[];
        /**
         * The total number of document errors.
         */
        documentErrorCount?: number | null;
        /**
         * Error information pertaining to specific documents. A maximum of 10 document errors will be returned. Any document with errors will not be used throughout training.
         */
        documentErrors?: Schema$GoogleRpcStatus[];
    }
    /**
     * The response for TrainProcessorVersion.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3TrainProcessorVersionResponse {
        /**
         * The resource name of the processor version produced by training.
         */
        processorVersion?: string | null;
    }
    /**
     * The long-running operation metadata for the UndeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * Response message for the UndeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3UndeployProcessorVersionResponse {
    }
    export interface Schema$GoogleCloudDocumentaiUiv1beta3UpdateDatasetOperationMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for updating the human review configuration.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3UpdateHumanReviewConfigMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for UpdateLabelerPool.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3UpdateLabelerPoolOperationMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the UpdateProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiUiv1beta3UpdateProcessorVersionMetadata {
        /**
         * The basic metadata for the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiUiv1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for BatchProcessDocuments.
     */
    export interface Schema$GoogleCloudDocumentaiV1BatchProcessMetadata {
        /**
         * The creation time of the operation.
         */
        createTime?: string | null;
        /**
         * The list of response details of each document.
         */
        individualProcessStatuses?: Schema$GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus[];
        /**
         * The state of the current batch processing.
         */
        state?: string | null;
        /**
         * A message providing more details about the current state of processing. For example, the error message if the operation is failed.
         */
        stateMessage?: string | null;
        /**
         * The last update time of the operation.
         */
        updateTime?: string | null;
    }
    /**
     * The status of a each individual document in the batch process.
     */
    export interface Schema$GoogleCloudDocumentaiV1BatchProcessMetadataIndividualProcessStatus {
        /**
         * The status of human review on the processed document.
         */
        humanReviewStatus?: Schema$GoogleCloudDocumentaiV1HumanReviewStatus;
        /**
         * The source of the document, same as the input_gcs_source field in the request when the batch process started.
         */
        inputGcsSource?: string | null;
        /**
         * The Cloud Storage output destination (in the request as DocumentOutputConfig.GcsOutputConfig.gcs_uri) of the processed document if it was successful, otherwise empty.
         */
        outputGcsDestination?: string | null;
        /**
         * The status processing the document.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * Response message for BatchProcessDocuments.
     */
    export interface Schema$GoogleCloudDocumentaiV1BatchProcessResponse {
    }
    /**
     * Encodes the detailed information of a barcode.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3Barcode {
        /**
         * Format of a barcode. The supported formats are: - `CODE_128`: Code 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type. - `CODABAR`: Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. - `ITF`: ITF type. - `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. - `QR_CODE`: 2D QR code type. - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E type. - `PDF417`: PDF417 type. - `AZTEC`: 2D Aztec code type. - `DATABAR`: GS1 DataBar code type.
         */
        format?: string | null;
        /**
         * Raw value encoded in the barcode. For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
         */
        rawValue?: string | null;
        /**
         * Value format describes the format of the value that a barcode encodes. The supported formats are: - `CONTACT_INFO`: Contact information. - `EMAIL`: Email address. - `ISBN`: ISBN identifier. - `PHONE`: Phone number. - `PRODUCT`: Product. - `SMS`: SMS message. - `TEXT`: Text string. - `URL`: URL address. - `WIFI`: Wifi information. - `GEO`: Geo-localization. - `CALENDAR_EVENT`: Calendar event. - `DRIVER_LICENSE`: Driver's license.
         */
        valueFormat?: string | null;
    }
    /**
     * Dataset documents that the batch operation will be applied to.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchDatasetDocuments {
        /**
         * A filter matching the documents. Follows the same format and restriction as [google.cloud.documentai.master.ListDocumentsRequest.filter].
         */
        filter?: string | null;
        /**
         * Document identifiers.
         */
        individualDocumentIds?: Schema$GoogleCloudDocumentaiV1beta3BatchDatasetDocumentsIndividualDocumentIds;
    }
    /**
     * List of individual DocumentIds.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchDatasetDocumentsIndividualDocumentIds {
        /**
         * Required. List of Document IDs indicating where the actual documents are stored.
         */
        documentIds?: Schema$GoogleCloudDocumentaiV1beta3DocumentId[];
    }
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
        /**
         * Total number of documents that failed to be deleted in storage.
         */
        errorDocumentCount?: number | null;
        /**
         * The list of response details of each document.
         */
        individualBatchDeleteStatuses?: Schema$GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus[];
        /**
         * Total number of documents deleting from dataset.
         */
        totalDocumentCount?: number | null;
    }
    /**
     * The status of each individual document in the batch delete process.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsMetadataIndividualBatchDeleteStatus {
        /**
         * The document id of the document.
         */
        documentId?: Schema$GoogleCloudDocumentaiV1beta3DocumentId;
        /**
         * The status of deleting the document in storage.
         */
        status?: Schema$GoogleRpcStatus;
    }
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsRequest {
        /**
         * Required. Dataset documents input. If given `filter`, all documents satisfying the filter will be deleted. If given documentIds, a maximum of 50 documents can be deleted in a batch. The request will be rejected if more than 50 document_ids are provided.
         */
        datasetDocuments?: Schema$GoogleCloudDocumentaiV1beta3BatchDatasetDocuments;
    }
    /**
     * Response of the delete documents operation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsResponse {
    }
    /**
     * The common config to specify a set of documents used as input.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig {
        /**
         * The set of documents individually specified on Cloud Storage.
         */
        gcsDocuments?: Schema$GoogleCloudDocumentaiV1beta3GcsDocuments;
        /**
         * The set of documents that match the specified Cloud Storage `gcs_prefix`.
         */
        gcsPrefix?: Schema$GoogleCloudDocumentaiV1beta3GcsPrefix;
    }
    /**
     * The long-running operation metadata for BatchProcessDocuments.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchProcessMetadata {
        /**
         * The creation time of the operation.
         */
        createTime?: string | null;
        /**
         * The list of response details of each document.
         */
        individualProcessStatuses?: Schema$GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus[];
        /**
         * The state of the current batch processing.
         */
        state?: string | null;
        /**
         * A message providing more details about the current state of processing. For example, the error message if the operation is failed.
         */
        stateMessage?: string | null;
        /**
         * The last update time of the operation.
         */
        updateTime?: string | null;
    }
    /**
     * The status of a each individual document in the batch process.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchProcessMetadataIndividualProcessStatus {
        /**
         * The name of the operation triggered by the processed document. If the human review process isn't triggered, this field will be empty. It has the same response type and metadata as the long-running operation returned by the ReviewDocument method.
         */
        humanReviewOperation?: string | null;
        /**
         * The status of human review on the processed document.
         */
        humanReviewStatus?: Schema$GoogleCloudDocumentaiV1beta3HumanReviewStatus;
        /**
         * The source of the document, same as the input_gcs_source field in the request when the batch process started.
         */
        inputGcsSource?: string | null;
        /**
         * The Cloud Storage output destination (in the request as DocumentOutputConfig.GcsOutputConfig.gcs_uri) of the processed document if it was successful, otherwise empty.
         */
        outputGcsDestination?: string | null;
        /**
         * The status processing the document.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * Request message for BatchProcessDocuments.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchProcessRequest {
        /**
         * The output configuration for the BatchProcessDocuments method.
         */
        documentOutputConfig?: Schema$GoogleCloudDocumentaiV1beta3DocumentOutputConfig;
        /**
         * The input config for each single document in the batch process.
         */
        inputConfigs?: Schema$GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchInputConfig[];
        /**
         * The input documents for the BatchProcessDocuments method.
         */
        inputDocuments?: Schema$GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig;
        /**
         * Optional. The labels with user-defined metadata for the request. Label keys and values can be no longer than 63 characters (Unicode codepoints) and can only contain lowercase letters, numeric characters, underscores, and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * The overall output config for batch process.
         */
        outputConfig?: Schema$GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchOutputConfig;
        /**
         * Inference-time options for the process API
         */
        processOptions?: Schema$GoogleCloudDocumentaiV1beta3ProcessOptions;
        /**
         * Whether human review should be skipped for this request. Default to `false`.
         */
        skipHumanReview?: boolean | null;
    }
    /**
     * The message for input config in batch process.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchInputConfig {
        /**
         * The Cloud Storage location as the source of the document.
         */
        gcsSource?: string | null;
        /**
         * An IANA published [media type (MIME type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of the input. If the input is a raw document, refer to [supported file types](https://cloud.google.com/document-ai/docs/file-types) for the list of media types. If the input is a Document, the type should be `application/json`.
         */
        mimeType?: string | null;
    }
    /**
     * The output configuration in the BatchProcessDocuments method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchProcessRequestBatchOutputConfig {
        /**
         * The output Cloud Storage directory to put the processed documents.
         */
        gcsDestination?: string | null;
    }
    /**
     * Response message for BatchProcessDocuments.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BatchProcessResponse {
    }
    /**
     * A bounding polygon for the detected image annotation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3BoundingPoly {
        /**
         * The bounding polygon normalized vertices.
         */
        normalizedVertices?: Schema$GoogleCloudDocumentaiV1beta3NormalizedVertex[];
        /**
         * The bounding polygon vertices.
         */
        vertices?: Schema$GoogleCloudDocumentaiV1beta3Vertex[];
    }
    /**
     * The common metadata for long running operations.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata {
        /**
         * The creation time of the operation.
         */
        createTime?: string | null;
        /**
         * A related resource to this operation.
         */
        resource?: string | null;
        /**
         * The state of the operation.
         */
        state?: string | null;
        /**
         * A message providing more details about the current state of processing.
         */
        stateMessage?: string | null;
        /**
         * The last update time of the operation.
         */
        updateTime?: string | null;
    }
    /**
     * A singleton resource under a Processor which configures a collection of documents.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3Dataset {
        /**
         * Optional. Deprecated. Warehouse-based dataset configuration is not supported.
         */
        documentWarehouseConfig?: Schema$GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig;
        /**
         * Optional. User-managed Cloud Storage dataset configuration. Use this configuration if the dataset documents are stored under a user-managed Cloud Storage location.
         */
        gcsManagedConfig?: Schema$GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig;
        /**
         * Dataset resource name. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/dataset`
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Optional. A lightweight indexing source with low latency and high reliability, but lacking advanced features like CMEK and content-based search.
         */
        spannerIndexingConfig?: Schema$GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig;
        /**
         * Required. State of the dataset. Ignored when updating dataset.
         */
        state?: string | null;
        /**
         * Optional. Unmanaged dataset configuration. Use this configuration if the dataset documents are managed by the document service internally (not user-managed).
         */
        unmanagedDatasetConfig?: Schema$GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig;
    }
    /**
     * Configuration specific to the Document AI Warehouse-based implementation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DatasetDocumentWarehouseConfig {
        /**
         * Output only. The collection in Document AI Warehouse associated with the dataset.
         */
        collection?: string | null;
        /**
         * Output only. The schema in Document AI Warehouse associated with the dataset.
         */
        schema?: string | null;
    }
    /**
     * Configuration specific to the Cloud Storage-based implementation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DatasetGCSManagedConfig {
        /**
         * Required. The Cloud Storage URI (a directory) where the documents belonging to the dataset must be stored.
         */
        gcsPrefix?: Schema$GoogleCloudDocumentaiV1beta3GcsPrefix;
    }
    /**
     * Dataset Schema.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DatasetSchema {
        /**
         * Optional. Schema of the dataset.
         */
        documentSchema?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchema;
        /**
         * Dataset schema resource name. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/dataset/datasetSchema`
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
    }
    /**
     * Configuration specific to spanner-based indexing.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DatasetSpannerIndexingConfig {
    }
    /**
     * Configuration specific to an unmanaged dataset.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DatasetUnmanagedDatasetConfig {
    }
    /**
     * The long-running operation metadata for the DeleteProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DeleteProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the DeleteProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DeleteProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the DeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DeployProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * Request message for the DeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DeployProcessorVersionRequest {
    }
    /**
     * Response message for the DeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DeployProcessorVersionResponse {
    }
    /**
     * The long-running operation metadata for the DisableProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DisableProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * Request message for the DisableProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DisableProcessorRequest {
    }
    /**
     * Response message for the DisableProcessor method. Intentionally empty proto for adding fields in future.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DisableProcessorResponse {
    }
    /**
     * Document represents the canonical document resource in Document AI. It is an interchange format that provides insights into documents and allows for collaboration between users and Document AI to iterate and optimize for quality.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3Document {
        /**
         * Optional. The blob assets in this document. This is used to store the content of the inline blobs in this document, e.g. image bytes, such that it can be referenced by other fields in the document via asset id.
         */
        blobAssets?: Schema$GoogleCloudDocumentaiV1beta3DocumentBlobAsset[];
        /**
         * Document chunked based on chunking config.
         */
        chunkedDocument?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocument;
        /**
         * Optional. Inline document content, represented as a stream of bytes. Note: As with all `bytes` fields, protobuffers use a pure binary representation, whereas JSON representations use base64.
         */
        content?: string | null;
        /**
         * Optional. An internal identifier for document. Should be loggable (no PII).
         */
        docid?: string | null;
        /**
         * Parsed layout of the document.
         */
        documentLayout?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayout;
        /**
         * A list of entities detected on Document.text. For document shards, entities in this list may cross shard boundaries.
         */
        entities?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntity[];
        /**
         * The entity revision id that `document.entities` field is based on. If this field is set and `entities_revisions` is not empty, the entities in `document.entities` field are the entities in the entity revision with this id and `document.entity_validation_output` field is the `entity_validation_output` field in this entity revision.
         */
        entitiesRevisionId?: string | null;
        /**
         * A list of entity revisions. The entity revisions are appended to the document in the processing order. This field can be used for comparing the entity extraction results at different stages of the processing.
         */
        entitiesRevisions?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntitiesRevision[];
        /**
         * Placeholder. Relationship among Document.entities.
         */
        entityRelations?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntityRelation[];
        /**
         * The entity validation output for the document. This is the validation output for `document.entities` field.
         */
        entityValidationOutput?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntityValidationOutput;
        /**
         * Any error that occurred while processing this document.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * An IANA published [media type (MIME type)](https://www.iana.org/assignments/media-types/media-types.xhtml).
         */
        mimeType?: string | null;
        /**
         * Visual page layout for the Document.
         */
        pages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPage[];
        /**
         * Placeholder. Revision history of this document.
         */
        revisions?: Schema$GoogleCloudDocumentaiV1beta3DocumentRevision[];
        /**
         * Information about the sharding if this document is sharded part of a larger document. If the document is not sharded, this message is not specified.
         */
        shardInfo?: Schema$GoogleCloudDocumentaiV1beta3DocumentShardInfo;
        /**
         * Optional. UTF-8 encoded text in reading order from the document.
         */
        text?: string | null;
        /**
         * Placeholder. A list of text corrections made to Document.text. This is usually used for annotating corrections to OCR mistakes. Text changes for a given revision may not overlap with each other.
         */
        textChanges?: Schema$GoogleCloudDocumentaiV1beta3DocumentTextChange[];
        /**
         * Styles for the Document.text.
         */
        textStyles?: Schema$GoogleCloudDocumentaiV1beta3DocumentStyle[];
        /**
         * Optional. Currently supports Google Cloud Storage URI of the form `gs://bucket_name/object_name`. Object versioning is not supported. For more information, refer to [Google Cloud Storage Request URIs](https://cloud.google.com/storage/docs/reference-uris).
         */
        uri?: string | null;
    }
    /**
     * Represents the annotation of a block or a chunk.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentAnnotations {
        /**
         * The description of the content with this annotation.
         */
        description?: string | null;
    }
    /**
     * Represents a blob asset. It's used to store the content of the inline blob in this document, e.g. image bytes, such that it can be referenced by other fields in the document via asset id.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentBlobAsset {
        /**
         * Optional. The id of the blob asset.
         */
        assetId?: string | null;
        /**
         * Optional. The content of the blob asset, e.g. image bytes.
         */
        content?: string | null;
        /**
         * The mime type of the blob asset. An IANA published [media type (MIME type)](https://www.iana.org/assignments/media-types/media-types.xhtml).
         */
        mimeType?: string | null;
    }
    /**
     * Represents the chunks that the document is divided into.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocument {
        /**
         * List of chunks.
         */
        chunks?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunk[];
    }
    /**
     * Represents a chunk.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunk {
        /**
         * Chunk fields inside this chunk.
         */
        chunkFields?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkField[];
        /**
         * ID of the chunk.
         */
        chunkId?: string | null;
        /**
         * Text content of the chunk.
         */
        content?: string | null;
        /**
         * Page footers associated with the chunk.
         */
        pageFooters?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkPageFooter[];
        /**
         * Page headers associated with the chunk.
         */
        pageHeaders?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkPageHeader[];
        /**
         * Page span of the chunk.
         */
        pageSpan?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkPageSpan;
        /**
         * Unused.
         */
        sourceBlockIds?: string[] | null;
    }
    /**
     * The chunk field in the chunk. A chunk field could be one of the various types (e.g. image, table) supported.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkField {
        /**
         * The image chunk field in the chunk.
         */
        imageChunkField?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkImageChunkField;
        /**
         * The table chunk field in the chunk.
         */
        tableChunkField?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkTableChunkField;
    }
    /**
     * Represents the page footer associated with the chunk.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkPageFooter {
        /**
         * Page span of the footer.
         */
        pageSpan?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkPageSpan;
        /**
         * Footer in text format.
         */
        text?: string | null;
    }
    /**
     * Represents the page header associated with the chunk.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkPageHeader {
        /**
         * Page span of the header.
         */
        pageSpan?: Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkPageSpan;
        /**
         * Header in text format.
         */
        text?: string | null;
    }
    /**
     * Represents where the chunk starts and ends in the document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkChunkPageSpan {
        /**
         * Page where chunk ends in the document.
         */
        pageEnd?: number | null;
        /**
         * Page where chunk starts in the document.
         */
        pageStart?: number | null;
    }
    /**
     * The image chunk field in the chunk.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkImageChunkField {
        /**
         * Annotation of the image chunk field.
         */
        annotations?: Schema$GoogleCloudDocumentaiV1beta3DocumentAnnotations;
        /**
         * Optional. Asset id of the inline image. If set, find the image content in the blob_assets field.
         */
        blobAssetId?: string | null;
        /**
         * Optional. Data uri of the image. It is composed of four parts: a prefix (data:), a MIME type indicating the type of data, an optional base64 token if non-textual, and the data itself: data:,
         */
        dataUri?: string | null;
        /**
         * Optional. Google Cloud Storage uri of the image.
         */
        gcsUri?: string | null;
    }
    /**
     * The table chunk field in the chunk.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentChunkedDocumentChunkTableChunkField {
        /**
         * Annotation of the table chunk field.
         */
        annotations?: Schema$GoogleCloudDocumentaiV1beta3DocumentAnnotations;
    }
    /**
     * Represents the parsed layout of a document as a collection of blocks that the document is divided into.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayout {
        /**
         * List of blocks in the document.
         */
        blocks?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlock[];
    }
    /**
     * Represents a block. A block could be one of the various types (text, table, list) supported.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlock {
        /**
         * ID of the block.
         */
        blockId?: string | null;
        /**
         * Identifies the bounding box for the block.
         */
        boundingBox?: Schema$GoogleCloudDocumentaiV1beta3BoundingPoly;
        /**
         * Block consisting of image content.
         */
        imageBlock?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutImageBlock;
        /**
         * Block consisting of list content/structure.
         */
        listBlock?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock;
        /**
         * Page span of the block.
         */
        pageSpan?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan;
        /**
         * Block consisting of table content/structure.
         */
        tableBlock?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock;
        /**
         * Block consisting of text content.
         */
        textBlock?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock;
    }
    /**
     * Represents an image type block.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutImageBlock {
        /**
         * Annotation of the image block.
         */
        annotations?: Schema$GoogleCloudDocumentaiV1beta3DocumentAnnotations;
        /**
         * Optional. Asset id of the inline image. If set, find the image content in the blob_assets field.
         */
        blobAssetId?: string | null;
        /**
         * Optional. Data uri of the image. It is composed of four parts: a prefix (data:), a MIME type indicating the type of data, an optional base64 token if non-textual, and the data itself: data:,
         */
        dataUri?: string | null;
        /**
         * Optional. Google Cloud Storage uri of the image.
         */
        gcsUri?: string | null;
        /**
         * Text extracted from the image using OCR or alt text describing the image.
         */
        imageText?: string | null;
        /**
         * Mime type of the image. An IANA published [media type (MIME type)] (https://www.iana.org/assignments/media-types/media-types.xhtml).
         */
        mimeType?: string | null;
    }
    /**
     * Represents a list type block.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutListBlock {
        /**
         * List entries that constitute a list block.
         */
        listEntries?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry[];
        /**
         * Type of the list_entries (if exist). Available options are `ordered` and `unordered`.
         */
        type?: string | null;
    }
    /**
     * Represents an entry in the list.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutListEntry {
        /**
         * A list entry is a list of blocks. Repeated blocks support further hierarchies and nested blocks.
         */
        blocks?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlock[];
    }
    /**
     * Represents where the block starts and ends in the document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutPageSpan {
        /**
         * Page where block ends in the document.
         */
        pageEnd?: number | null;
        /**
         * Page where block starts in the document.
         */
        pageStart?: number | null;
    }
    /**
     * Represents a table type block.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTableBlock {
        /**
         * Annotation of the table block.
         */
        annotations?: Schema$GoogleCloudDocumentaiV1beta3DocumentAnnotations;
        /**
         * Body rows containing main table content.
         */
        bodyRows?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow[];
        /**
         * Table caption/title.
         */
        caption?: string | null;
        /**
         * Header rows at the top of the table.
         */
        headerRows?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow[];
    }
    /**
     * Represents a cell in a table row.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell {
        /**
         * A table cell is a list of blocks. Repeated blocks support further hierarchies and nested blocks.
         */
        blocks?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlock[];
        /**
         * How many columns this cell spans.
         */
        colSpan?: number | null;
        /**
         * How many rows this cell spans.
         */
        rowSpan?: number | null;
    }
    /**
     * Represents a row in a table.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTableRow {
        /**
         * A table row is a list of table cells.
         */
        cells?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTableCell[];
    }
    /**
     * Represents a text type block.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlockLayoutTextBlock {
        /**
         * Annotation of the text block.
         */
        annotations?: Schema$GoogleCloudDocumentaiV1beta3DocumentAnnotations;
        /**
         * A text block could further have child blocks. Repeated blocks support further hierarchies and nested blocks.
         */
        blocks?: Schema$GoogleCloudDocumentaiV1beta3DocumentDocumentLayoutDocumentLayoutBlock[];
        /**
         * Text content stored in the block.
         */
        text?: string | null;
        /**
         * Type of the text in the block. Available options are: `paragraph`, `subtitle`, `heading-1`, `heading-2`, `heading-3`, `heading-4`, `heading-5`, `header`, `footer`.
         */
        type?: string | null;
    }
    /**
     * Entity revision.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentEntitiesRevision {
        /**
         * The entities in this revision.
         */
        entities?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntity[];
        /**
         * The entity validation output for this revision.
         */
        entityValidationOutput?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntityValidationOutput;
        /**
         * The revision id.
         */
        revisionId?: string | null;
    }
    /**
     * An entity that could be a phrase in the text or a property that belongs to the document. It is a known entity type, such as a person, an organization, or location.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentEntity {
        /**
         * Optional. Confidence of detected Schema entity. Range `[0, 1]`.
         */
        confidence?: number | null;
        /**
         * Optional. Canonical id. This will be a unique value in the entity list for this document.
         */
        id?: string | null;
        /**
         * Optional. Deprecated. Use `id` field instead.
         */
        mentionId?: string | null;
        /**
         * Optional. Text value of the entity e.g. `1600 Amphitheatre Pkwy`.
         */
        mentionText?: string | null;
        /**
         * Optional. Specifies how the entity's value is obtained.
         */
        method?: string | null;
        /**
         * Optional. Normalized entity value. Absent if the extracted value could not be converted or the type (e.g. address) is not supported for certain parsers. This field is also only populated for certain supported document types.
         */
        normalizedValue?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue;
        /**
         * Optional. Represents the provenance of this entity wrt. the location on the page where it was found.
         */
        pageAnchor?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageAnchor;
        /**
         * Optional. Entities can be nested to form a hierarchical data structure representing the content in the document.
         */
        properties?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntity[];
        /**
         * Optional. The history of this annotation.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance;
        /**
         * Optional. Whether the entity will be redacted for de-identification purposes.
         */
        redacted?: boolean | null;
        /**
         * Optional. Provenance of the entity. Text anchor indexing into the Document.text.
         */
        textAnchor?: Schema$GoogleCloudDocumentaiV1beta3DocumentTextAnchor;
        /**
         * Required. Entity type from a schema e.g. `Address`.
         */
        type?: string | null;
    }
    /**
     * Parsed and normalized entity value.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentEntityNormalizedValue {
        /**
         * Postal address. See also: https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
         */
        addressValue?: Schema$GoogleTypePostalAddress;
        /**
         * Boolean value. Can be used for entities with binary values, or for checkboxes.
         */
        booleanValue?: boolean | null;
        /**
         * DateTime value. Includes date, time, and timezone. See also: https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
         */
        datetimeValue?: Schema$GoogleTypeDateTime;
        /**
         * Date value. Includes year, month, day. See also: https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
         */
        dateValue?: Schema$GoogleTypeDate;
        /**
         * Float value.
         */
        floatValue?: number | null;
        /**
         * Integer value.
         */
        integerValue?: number | null;
        /**
         * Money value. See also: https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
         */
        moneyValue?: Schema$GoogleTypeMoney;
        /**
         * A signature - a graphical representation of a person's name, often used to sign a document.
         */
        signatureValue?: boolean | null;
        /**
         * Optional. An optional field to store a normalized string. For some entity types, one of respective `structured_value` fields may also be populated. Also not all the types of `structured_value` will be normalized. For example, some processors may not generate `float` or `integer` normalized text by default. Below are sample formats mapped to structured values. - Money/Currency type (`money_value`) is in the ISO 4217 text format. - Date type (`date_value`) is in the ISO 8601 text format. - Datetime type (`datetime_value`) is in the ISO 8601 text format.
         */
        text?: string | null;
    }
    /**
     * Relationship between Entities.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentEntityRelation {
        /**
         * Object entity id.
         */
        objectId?: string | null;
        /**
         * Relationship description.
         */
        relation?: string | null;
        /**
         * Subject entity id.
         */
        subjectId?: string | null;
    }
    /**
     * The output of the validation given the document and the validation rules.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentEntityValidationOutput {
        /**
         * The overall result of the validation, true if all applicable rules are valid.
         */
        passAllRules?: boolean | null;
        /**
         * The result of each validation rule.
         */
        validationResults?: Schema$GoogleCloudDocumentaiV1beta3DocumentEntityValidationOutputValidationResult[];
    }
    /**
     * Validation result for a single validation rule.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentEntityValidationOutputValidationResult {
        /**
         * Optional. The name of the rule resource that is used for validation. Format: `projects/{project\}/locations/{location\}/rules/{rule\}`
         */
        rule?: string | null;
        /**
         * The description of the validation rule.
         */
        ruleDescription?: string | null;
        /**
         * The display name of the validation rule.
         */
        ruleName?: string | null;
        /**
         * The detailed information of the running the validation process using the entity from the document based on the validation rule.
         */
        validationDetails?: string | null;
        /**
         * The result of the validation rule.
         */
        validationResultType?: string | null;
    }
    /**
     * Document Identifier.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentId {
        /**
         * A document id within user-managed Cloud Storage.
         */
        gcsManagedDocId?: Schema$GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId;
        /**
         * Points to a specific revision of the document if set.
         */
        revisionRef?: Schema$GoogleCloudDocumentaiV1beta3RevisionRef;
        /**
         * A document id within unmanaged dataset.
         */
        unmanagedDocId?: Schema$GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId;
    }
    /**
     * Identifies a document uniquely within the scope of a dataset in the user-managed Cloud Storage option.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentIdGCSManagedDocumentId {
        /**
         * Id of the document (indexed) managed by Content Warehouse.
         */
        cwDocId?: string | null;
        /**
         * Required. The Cloud Storage URI where the actual document is stored.
         */
        gcsUri?: string | null;
    }
    /**
     * Identifies a document uniquely within the scope of a dataset in unmanaged option.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentIdUnmanagedDocumentId {
        /**
         * Required. The id of the document.
         */
        docId?: string | null;
    }
    /**
     * Metadata about a document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentMetadata {
        /**
         * Type of the dataset split to which the document belongs.
         */
        datasetType?: string | null;
        /**
         * The display name of the document.
         */
        displayName?: string | null;
        /**
         * Document identifier.
         */
        documentId?: Schema$GoogleCloudDocumentaiV1beta3DocumentId;
        /**
         * Labeling state of the document.
         */
        labelingState?: string | null;
        /**
         * Number of pages in the document.
         */
        pageCount?: number | null;
    }
    /**
     * Config that controls the output of documents. All documents will be written as a JSON file.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentOutputConfig {
        /**
         * Output config to write the results to Cloud Storage.
         */
        gcsOutputConfig?: Schema$GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfig;
    }
    /**
     * The configuration used when outputting documents.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfig {
        /**
         * Specifies which fields to include in the output documents. Only supports top level document and pages field so it must be in the form of `{document_field_name\}` or `pages.{page_field_name\}`.
         */
        fieldMask?: string | null;
        /**
         * The Cloud Storage uri (a directory) of the output.
         */
        gcsUri?: string | null;
        /**
         * Specifies the sharding config for the output document.
         */
        shardingConfig?: Schema$GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfigShardingConfig;
    }
    /**
     * The sharding config for the output document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentOutputConfigGcsOutputConfigShardingConfig {
        /**
         * The number of overlapping pages between consecutive shards.
         */
        pagesOverlap?: number | null;
        /**
         * The number of pages per shard.
         */
        pagesPerShard?: number | null;
    }
    /**
     * A page in a Document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPage {
        /**
         * A list of visually detected text blocks on the page. A block has a set of lines (collected into paragraphs) that have a common line-spacing and orientation.
         */
        blocks?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageBlock[];
        /**
         * A list of detected barcodes.
         */
        detectedBarcodes?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedBarcode[];
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Physical dimension of the page.
         */
        dimension?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDimension;
        /**
         * A list of visually detected form fields on the page.
         */
        formFields?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageFormField[];
        /**
         * Rendered image for this page. This image is preprocessed to remove any skew, rotation, and distortions such that the annotation bounding boxes can be upright and axis-aligned.
         */
        image?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageImage;
        /**
         * Image quality scores.
         */
        imageQualityScores?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores;
        /**
         * Layout for the page.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * A list of visually detected text lines on the page. A collection of tokens that a human would perceive as a line.
         */
        lines?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLine[];
        /**
         * 1-based index for current Page in a parent Document. Useful when a page is taken out of a Document for individual processing.
         */
        pageNumber?: number | null;
        /**
         * A list of visually detected text paragraphs on the page. A collection of lines that a human would perceive as a paragraph.
         */
        paragraphs?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageParagraph[];
        /**
         * The history of this page.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance;
        /**
         * A list of visually detected symbols on the page.
         */
        symbols?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageSymbol[];
        /**
         * A list of visually detected tables on the page.
         */
        tables?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageTable[];
        /**
         * A list of visually detected tokens on the page.
         */
        tokens?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageToken[];
        /**
         * Transformation matrices that were applied to the original document image to produce Page.image.
         */
        transforms?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageMatrix[];
        /**
         * A list of detected non-text visual elements e.g. checkbox, signature etc. on the page.
         */
        visualElements?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageVisualElement[];
    }
    /**
     * Referencing the visual context of the entity in the Document.pages. Page anchors can be cross-page, consist of multiple bounding polygons and optionally reference specific layout element types.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageAnchor {
        /**
         * One or more references to visual page elements
         */
        pageRefs?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef[];
    }
    /**
     * Represents a weak reference to a page element within a document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageAnchorPageRef {
        /**
         * Optional. Identifies the bounding polygon of a layout element on the page. If `layout_type` is set, the bounding polygon must be exactly the same to the layout element it's referring to.
         */
        boundingPoly?: Schema$GoogleCloudDocumentaiV1beta3BoundingPoly;
        /**
         * Optional. Confidence of detected page element, if applicable. Range `[0, 1]`.
         */
        confidence?: number | null;
        /**
         * Optional. Deprecated. Use PageRef.bounding_poly instead.
         */
        layoutId?: string | null;
        /**
         * Optional. The type of the layout element that is being referenced if any.
         */
        layoutType?: string | null;
        /**
         * Required. Index into the Document.pages element, for example using `Document.pages` to locate the related page element. This field is skipped when its value is the default `0`. See https://developers.google.com/protocol-buffers/docs/proto3#json.
         */
        page?: string | null;
    }
    /**
     * A block has a set of lines (collected into paragraphs) that have a common line-spacing and orientation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageBlock {
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Layout for Block.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * The history of this annotation.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance;
    }
    /**
     * A detected barcode.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedBarcode {
        /**
         * Detailed barcode information of the DetectedBarcode.
         */
        barcode?: Schema$GoogleCloudDocumentaiV1beta3Barcode;
        /**
         * Layout for DetectedBarcode.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
    }
    /**
     * Detected language for a structural component.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage {
        /**
         * Confidence of detected language. Range `[0, 1]`.
         */
        confidence?: number | null;
        /**
         * The [BCP-47 language code](https://www.unicode.org/reports/tr35/#Unicode_locale_identifier), such as `en-US` or `sr-Latn`.
         */
        languageCode?: string | null;
    }
    /**
     * Dimension for the page.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageDimension {
        /**
         * Page height.
         */
        height?: number | null;
        /**
         * Dimension unit.
         */
        unit?: string | null;
        /**
         * Page width.
         */
        width?: number | null;
    }
    /**
     * A form field detected on the page.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageFormField {
        /**
         * Created for Labeling UI to export key text. If corrections were made to the text identified by the `field_name.text_anchor`, this field will contain the correction.
         */
        correctedKeyText?: string | null;
        /**
         * Created for Labeling UI to export value text. If corrections were made to the text identified by the `field_value.text_anchor`, this field will contain the correction.
         */
        correctedValueText?: string | null;
        /**
         * Layout for the FormField name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         */
        fieldName?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * Layout for the FormField value.
         */
        fieldValue?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * A list of detected languages for name together with confidence.
         */
        nameDetectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * The history of this annotation.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance;
        /**
         * A list of detected languages for value together with confidence.
         */
        valueDetectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * If the value is non-textual, this field represents the type. Current valid values are: - blank (this indicates the `field_value` is normal text) - `unfilled_checkbox` - `filled_checkbox`
         */
        valueType?: string | null;
    }
    /**
     * Rendered image contents for this page.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageImage {
        /**
         * Raw byte content of the image.
         */
        content?: string | null;
        /**
         * Height of the image in pixels.
         */
        height?: number | null;
        /**
         * Encoding [media type (MIME type)](https://www.iana.org/assignments/media-types/media-types.xhtml) for the image.
         */
        mimeType?: string | null;
        /**
         * Width of the image in pixels.
         */
        width?: number | null;
    }
    /**
     * Image quality scores for the page image.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScores {
        /**
         * A list of detected defects.
         */
        detectedDefects?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefect[];
        /**
         * The overall quality score. Range `[0, 1]` where `1` is perfect quality.
         */
        qualityScore?: number | null;
    }
    /**
     * Image Quality Defects
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageImageQualityScoresDetectedDefect {
        /**
         * Confidence of detected defect. Range `[0, 1]` where `1` indicates strong confidence that the defect exists.
         */
        confidence?: number | null;
        /**
         * Name of the defect type. Supported values are: - `quality/defect_blurry` - `quality/defect_noisy` - `quality/defect_dark` - `quality/defect_faint` - `quality/defect_text_too_small` - `quality/defect_document_cutoff` - `quality/defect_text_cutoff` - `quality/defect_glare`
         */
        type?: string | null;
    }
    /**
     * Visual element describing a layout unit on a page.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout {
        /**
         * The bounding polygon for the Layout.
         */
        boundingPoly?: Schema$GoogleCloudDocumentaiV1beta3BoundingPoly;
        /**
         * Confidence of the current Layout within context of the object this layout is for. e.g. confidence can be for a single token, a table, a visual element, etc. depending on context. Range `[0, 1]`.
         */
        confidence?: number | null;
        /**
         * Detected orientation for the Layout.
         */
        orientation?: string | null;
        /**
         * Text anchor indexing into the Document.text.
         */
        textAnchor?: Schema$GoogleCloudDocumentaiV1beta3DocumentTextAnchor;
    }
    /**
     * A collection of tokens that a human would perceive as a line. Does not cross column boundaries, can be horizontal, vertical, etc.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageLine {
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Layout for Line.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * The history of this annotation.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance;
    }
    /**
     * Representation for transformation matrix, intended to be compatible and used with OpenCV format for image manipulation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageMatrix {
        /**
         * Number of columns in the matrix.
         */
        cols?: number | null;
        /**
         * The matrix data.
         */
        data?: string | null;
        /**
         * Number of rows in the matrix.
         */
        rows?: number | null;
        /**
         * This encodes information about what data type the matrix uses. For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list of OpenCV primitive data types, please refer to https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
         */
        type?: number | null;
    }
    /**
     * A collection of lines that a human would perceive as a paragraph.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageParagraph {
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Layout for Paragraph.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * The history of this annotation.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance;
    }
    /**
     * A detected symbol.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageSymbol {
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Layout for Symbol.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
    }
    /**
     * A table representation similar to HTML table structure.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageTable {
        /**
         * Body rows of the table.
         */
        bodyRows?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow[];
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Header rows of the table.
         */
        headerRows?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow[];
        /**
         * Layout for Table.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * The history of this table.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance;
    }
    /**
     * A cell representation inside the table.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageTableTableCell {
        /**
         * How many columns this cell spans.
         */
        colSpan?: number | null;
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Layout for TableCell.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * How many rows this cell spans.
         */
        rowSpan?: number | null;
    }
    /**
     * A row of table cells.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageTableTableRow {
        /**
         * Cells that make up this row.
         */
        cells?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageTableTableCell[];
    }
    /**
     * A detected token.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageToken {
        /**
         * Detected break at the end of a Token.
         */
        detectedBreak?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageTokenDetectedBreak;
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Layout for Token.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * The history of this annotation.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance;
        /**
         * Text style attributes.
         */
        styleInfo?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo;
    }
    /**
     * Detected break at the end of a Token.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageTokenDetectedBreak {
        /**
         * Detected break type.
         */
        type?: string | null;
    }
    /**
     * Font and other text style attributes.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageTokenStyleInfo {
        /**
         * Color of the background.
         */
        backgroundColor?: Schema$GoogleTypeColor;
        /**
         * Whether the text is bold (equivalent to font_weight is at least `700`).
         */
        bold?: boolean | null;
        /**
         * Font size in points (`1` point is `¹⁄₇₂` inches).
         */
        fontSize?: number | null;
        /**
         * Name or style of the font.
         */
        fontType?: string | null;
        /**
         * TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy). Normal is `400`, bold is `700`.
         */
        fontWeight?: number | null;
        /**
         * Whether the text is handwritten.
         */
        handwritten?: boolean | null;
        /**
         * Whether the text is italic.
         */
        italic?: boolean | null;
        /**
         * Letter spacing in points.
         */
        letterSpacing?: number | null;
        /**
         * Font size in pixels, equal to _unrounded font_size_ * _resolution_ ÷ `72.0`.
         */
        pixelFontSize?: number | null;
        /**
         * Whether the text is in small caps. This feature is not supported yet.
         */
        smallcaps?: boolean | null;
        /**
         * Whether the text is strikethrough. This feature is not supported yet.
         */
        strikeout?: boolean | null;
        /**
         * Whether the text is a subscript. This feature is not supported yet.
         */
        subscript?: boolean | null;
        /**
         * Whether the text is a superscript. This feature is not supported yet.
         */
        superscript?: boolean | null;
        /**
         * Color of the text.
         */
        textColor?: Schema$GoogleTypeColor;
        /**
         * Whether the text is underlined.
         */
        underlined?: boolean | null;
    }
    /**
     * Detected non-text visual elements e.g. checkbox, signature etc. on the page.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentPageVisualElement {
        /**
         * A list of detected languages together with confidence.
         */
        detectedLanguages?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageDetectedLanguage[];
        /**
         * Layout for VisualElement.
         */
        layout?: Schema$GoogleCloudDocumentaiV1beta3DocumentPageLayout;
        /**
         * Type of the VisualElement.
         */
        type?: string | null;
    }
    /**
     * Structure to identify provenance relationships between annotations in different revisions.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance {
        /**
         * The Id of this operation. Needs to be unique within the scope of the revision.
         */
        id?: number | null;
        /**
         * References to the original elements that are replaced.
         */
        parents?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenanceParent[];
        /**
         * The index of the revision that produced this element.
         */
        revision?: number | null;
        /**
         * The type of provenance operation.
         */
        type?: string | null;
    }
    /**
     * The parent element the current element is based on. Used for referencing/aligning, removal and replacement operations.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentProvenanceParent {
        /**
         * The id of the parent provenance.
         */
        id?: number | null;
        /**
         * The index of the parent item in the corresponding item list (eg. list of entities, properties within entities, etc.) in the parent revision.
         */
        index?: number | null;
        /**
         * The index of the index into current revision's parent_ids list.
         */
        revision?: number | null;
    }
    /**
     * Contains past or forward revisions of this document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentRevision {
        /**
         * If the change was made by a person specify the name or id of that person.
         */
        agent?: string | null;
        /**
         * The time that the revision was created, internally generated by doc proto storage at the time of create.
         */
        createTime?: string | null;
        /**
         * Human Review information of this revision.
         */
        humanReview?: Schema$GoogleCloudDocumentaiV1beta3DocumentRevisionHumanReview;
        /**
         * Id of the revision, internally generated by doc proto storage. Unique within the context of the document.
         */
        id?: string | null;
        /**
         * The revisions that this revision is based on. This can include one or more parent (when documents are merged.) This field represents the index into the `revisions` field.
         */
        parent?: number[] | null;
        /**
         * The revisions that this revision is based on. Must include all the ids that have anything to do with this revision - eg. there are `provenance.parent.revision` fields that index into this field.
         */
        parentIds?: string[] | null;
        /**
         * If the annotation was made by processor identify the processor by its resource name.
         */
        processor?: string | null;
    }
    /**
     * Human Review information of the document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentRevisionHumanReview {
        /**
         * Human review state. e.g. `requested`, `succeeded`, `rejected`.
         */
        state?: string | null;
        /**
         * A message providing more details about the current state of processing. For example, the rejection reason when the state is `rejected`.
         */
        stateMessage?: string | null;
    }
    /**
     * A set of inline documents.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3Documents {
        /**
         * The list of documents.
         */
        documents?: Schema$GoogleCloudDocumentaiV1beta3Document[];
    }
    /**
     * The schema defines the output of the processed document by a processor.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentSchema {
        /**
         * Description of the schema.
         */
        description?: string | null;
        /**
         * Display name to show to users.
         */
        displayName?: string | null;
        /**
         * Entity types of the schema.
         */
        entityTypes?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchemaEntityType[];
        /**
         * Metadata of the schema.
         */
        metadata?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchemaMetadata;
    }
    /**
     * EntityType is the wrapper of a label of the corresponding model with detailed attributes and limitations for entity-based processors. Multiple types can also compose a dependency tree to represent nested types.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentSchemaEntityType {
        /**
         * The entity type that this type is derived from. For now, one and only one should be set.
         */
        baseTypes?: string[] | null;
        /**
         * The description of the entity type. Could be used to provide more information about the entity type for model calls.
         */
        description?: string | null;
        /**
         * User defined name for the type.
         */
        displayName?: string | null;
        /**
         * Metadata for the entity type.
         */
        entityTypeMetadata?: Schema$GoogleCloudDocumentaiV1beta3EntityTypeMetadata;
        /**
         * If specified, lists all the possible values for this entity. This should not be more than a handful of values. If the number of values is \>10 or could change frequently use the `EntityType.value_ontology` field and specify a list of all possible values in a value ontology file.
         */
        enumValues?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeEnumValues;
        /**
         * Name of the type. It must be unique within the schema file and cannot be a "Common Type". The following naming conventions are used: - Use `snake_casing`. - Name matching is case-sensitive. - Maximum 64 characters. - Must start with a letter. - Allowed characters: ASCII letters `[a-z0-9_-]`. (For backward compatibility internal infrastructure and tooling can handle any ascii character.) - The `/` is sometimes used to denote a property of a type. For example `line_item/amount`. This convention is deprecated, but will still be honored for backward compatibility.
         */
        name?: string | null;
        /**
         * Description the nested structure, or composition of an entity.
         */
        properties?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeProperty[];
    }
    /**
     * Defines the a list of enum values.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeEnumValues {
        /**
         * The individual values that this enum values type can include.
         */
        values?: string[] | null;
    }
    /**
     * Defines properties that can be part of the entity type.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentSchemaEntityTypeProperty {
        /**
         * The description of the property. Could be used to provide more information about the property for model calls.
         */
        description?: string | null;
        /**
         * User defined name for the property.
         */
        displayName?: string | null;
        /**
         * Specifies how the entity's value is obtained.
         */
        method?: string | null;
        /**
         * The name of the property. Follows the same guidelines as the EntityType name.
         */
        name?: string | null;
        /**
         * Occurrence type limits the number of instances an entity type appears in the document.
         */
        occurrenceType?: string | null;
        /**
         * Any additional metadata about the property can be added here.
         */
        propertyMetadata?: Schema$GoogleCloudDocumentaiV1beta3PropertyMetadata;
        /**
         * A reference to the value type of the property. This type is subject to the same conventions as the `Entity.base_types` field.
         */
        valueType?: string | null;
    }
    /**
     * Metadata for global schema behavior.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentSchemaMetadata {
        /**
         * If true, on a given page, there can be multiple `document` annotations covering it.
         */
        documentAllowMultipleLabels?: boolean | null;
        /**
         * If true, a `document` entity type can be applied to subdocument (splitting). Otherwise, it can only be applied to the entire document (classification).
         */
        documentSplitter?: boolean | null;
        /**
         * If set, all the nested entities must be prefixed with the parents.
         */
        prefixedNamingOnProperties?: boolean | null;
        /**
         * If set, we will skip the naming format validation in the schema. So the string values in `DocumentSchema.EntityType.name` and `DocumentSchema.EntityType.Property.name` will not be checked.
         */
        skipNamingValidation?: boolean | null;
    }
    /**
     * For a large document, sharding may be performed to produce several document shards. Each document shard contains this field to detail which shard it is.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentShardInfo {
        /**
         * Total number of shards.
         */
        shardCount?: string | null;
        /**
         * The 0-based index of this shard.
         */
        shardIndex?: string | null;
        /**
         * The index of the first character in Document.text in the overall document global text.
         */
        textOffset?: string | null;
    }
    /**
     * Annotation for common text style attributes. This adheres to CSS conventions as much as possible.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentStyle {
        /**
         * Text background color.
         */
        backgroundColor?: Schema$GoogleTypeColor;
        /**
         * Text color.
         */
        color?: Schema$GoogleTypeColor;
        /**
         * Font family such as `Arial`, `Times New Roman`. https://www.w3schools.com/cssref/pr_font_font-family.asp
         */
        fontFamily?: string | null;
        /**
         * Font size.
         */
        fontSize?: Schema$GoogleCloudDocumentaiV1beta3DocumentStyleFontSize;
        /**
         * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp). Possible values are `normal`, `bold`, `bolder`, and `lighter`.
         */
        fontWeight?: string | null;
        /**
         * Text anchor indexing into the Document.text.
         */
        textAnchor?: Schema$GoogleCloudDocumentaiV1beta3DocumentTextAnchor;
        /**
         * [Text decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp). Follows CSS standard.
         */
        textDecoration?: string | null;
        /**
         * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp). Possible values are `normal`, `italic`, and `oblique`.
         */
        textStyle?: string | null;
    }
    /**
     * Font size with unit.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentStyleFontSize {
        /**
         * Font size for the text.
         */
        size?: number | null;
        /**
         * Unit for the font size. Follows CSS naming (such as `in`, `px`, and `pt`).
         */
        unit?: string | null;
    }
    /**
     * Text reference indexing into the Document.text.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentTextAnchor {
        /**
         * Contains the content of the text span so that users do not have to look it up in the text_segments. It is always populated for formFields.
         */
        content?: string | null;
        /**
         * The text segments from the Document.text.
         */
        textSegments?: Schema$GoogleCloudDocumentaiV1beta3DocumentTextAnchorTextSegment[];
    }
    /**
     * A text segment in the Document.text. The indices may be out of bounds which indicate that the text extends into another document shard for large sharded documents. See ShardInfo.text_offset
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentTextAnchorTextSegment {
        /**
         * TextSegment half open end UTF-8 char index in the Document.text.
         */
        endIndex?: string | null;
        /**
         * TextSegment start UTF-8 char index in the Document.text.
         */
        startIndex?: string | null;
    }
    /**
     * This message is used for text changes aka. OCR corrections.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3DocumentTextChange {
        /**
         * The text that replaces the text identified in the `text_anchor`.
         */
        changedText?: string | null;
        /**
         * The history of this annotation.
         */
        provenance?: Schema$GoogleCloudDocumentaiV1beta3DocumentProvenance[];
        /**
         * Provenance of the correction. Text anchor indexing into the Document.text. There can only be a single `TextAnchor.text_segments` element. If the start and end index of the text segment are the same, the text change is inserted before that index.
         */
        textAnchor?: Schema$GoogleCloudDocumentaiV1beta3DocumentTextAnchor;
    }
    /**
     * The long-running operation metadata for the EnableProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EnableProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * Request message for the EnableProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EnableProcessorRequest {
    }
    /**
     * Response message for the EnableProcessor method. Intentionally empty proto for adding fields in future.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EnableProcessorResponse {
    }
    /**
     * Metadata about an entity type.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EntityTypeMetadata {
        /**
         * Whether the entity type should be considered inactive.
         */
        inactive?: boolean | null;
    }
    /**
     * Metadata of the EvaluateProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * Evaluates the given ProcessorVersion against the supplied documents.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest {
        /**
         * Optional. The documents used in the evaluation. If unspecified, use the processor's dataset as evaluation input.
         */
        evaluationDocuments?: Schema$GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig;
    }
    /**
     * Response of the EvaluateProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionResponse {
        /**
         * The resource name of the created evaluation.
         */
        evaluation?: string | null;
    }
    /**
     * An evaluation of a ProcessorVersion's performance.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3Evaluation {
        /**
         * Metrics for all the entities in aggregate.
         */
        allEntitiesMetrics?: Schema$GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics;
        /**
         * The time that the evaluation was created.
         */
        createTime?: string | null;
        /**
         * Counters for the documents used in the evaluation.
         */
        documentCounters?: Schema$GoogleCloudDocumentaiV1beta3EvaluationCounters;
        /**
         * Metrics across confidence levels, for different entities.
         */
        entityMetrics?: {
            [key: string]: Schema$GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics;
        } | null;
        /**
         * The KMS key name used for encryption.
         */
        kmsKeyName?: string | null;
        /**
         * The KMS key version with which data is encrypted.
         */
        kmsKeyVersionName?: string | null;
        /**
         * The resource name of the evaluation. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processor_version\}/evaluations/{evaluation\}`
         */
        name?: string | null;
    }
    /**
     * Evaluations metrics, at a specific confidence level.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics {
        /**
         * The confidence level.
         */
        confidenceLevel?: number | null;
        /**
         * The metrics at the specific confidence level.
         */
        metrics?: Schema$GoogleCloudDocumentaiV1beta3EvaluationMetrics;
    }
    /**
     * Evaluation counters for the documents that were used.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EvaluationCounters {
        /**
         * How many documents were used in the evaluation.
         */
        evaluatedDocumentsCount?: number | null;
        /**
         * How many documents were not included in the evaluation as Document AI failed to process them.
         */
        failedDocumentsCount?: number | null;
        /**
         * How many documents were sent for evaluation.
         */
        inputDocumentsCount?: number | null;
        /**
         * How many documents were not included in the evaluation as they didn't pass validation.
         */
        invalidDocumentsCount?: number | null;
    }
    /**
     * Evaluation metrics, either in aggregate or about a specific entity.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EvaluationMetrics {
        /**
         * The calculated f1 score.
         */
        f1Score?: number | null;
        /**
         * The amount of false negatives.
         */
        falseNegativesCount?: number | null;
        /**
         * The amount of false positives.
         */
        falsePositivesCount?: number | null;
        /**
         * The amount of documents with a ground truth occurrence.
         */
        groundTruthDocumentCount?: number | null;
        /**
         * The amount of occurrences in ground truth documents.
         */
        groundTruthOccurrencesCount?: number | null;
        /**
         * The calculated precision.
         */
        precision?: number | null;
        /**
         * The amount of documents with a predicted occurrence.
         */
        predictedDocumentCount?: number | null;
        /**
         * The amount of occurrences in predicted documents.
         */
        predictedOccurrencesCount?: number | null;
        /**
         * The calculated recall.
         */
        recall?: number | null;
        /**
         * The amount of documents that had an occurrence of this label.
         */
        totalDocumentsCount?: number | null;
        /**
         * The amount of true positives.
         */
        truePositivesCount?: number | null;
    }
    /**
     * Metrics across multiple confidence levels.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EvaluationMultiConfidenceMetrics {
        /**
         * The calculated area under the precision recall curve (AUPRC), computed by integrating over all confidence thresholds.
         */
        auprc?: number | null;
        /**
         * The AUPRC for metrics with fuzzy matching disabled, i.e., exact matching only.
         */
        auprcExact?: number | null;
        /**
         * Metrics across confidence levels with fuzzy matching enabled.
         */
        confidenceLevelMetrics?: Schema$GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics[];
        /**
         * Metrics across confidence levels with only exact matching.
         */
        confidenceLevelMetricsExact?: Schema$GoogleCloudDocumentaiV1beta3EvaluationConfidenceLevelMetrics[];
        /**
         * The Estimated Calibration Error (ECE) of the confidence of the predicted entities.
         */
        estimatedCalibrationError?: number | null;
        /**
         * The ECE for the predicted entities with fuzzy matching disabled, i.e., exact matching only.
         */
        estimatedCalibrationErrorExact?: number | null;
        /**
         * The metrics type for the label.
         */
        metricsType?: string | null;
    }
    /**
     * Gives a short summary of an evaluation, and links to the evaluation itself.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3EvaluationReference {
        /**
         * An aggregate of the statistics for the evaluation with fuzzy matching on.
         */
        aggregateMetrics?: Schema$GoogleCloudDocumentaiV1beta3EvaluationMetrics;
        /**
         * An aggregate of the statistics for the evaluation with fuzzy matching off.
         */
        aggregateMetricsExact?: Schema$GoogleCloudDocumentaiV1beta3EvaluationMetrics;
        /**
         * The resource name of the evaluation.
         */
        evaluation?: string | null;
        /**
         * The resource name of the Long Running Operation for the evaluation.
         */
        operation?: string | null;
    }
    /**
     * Response message for the FetchProcessorTypes method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse {
        /**
         * The list of processor types.
         */
        processorTypes?: Schema$GoogleCloudDocumentaiV1beta3ProcessorType[];
    }
    /**
     * Metadata for how this field value is extracted.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3FieldExtractionMetadata {
        /**
         * Summary options config.
         */
        summaryOptions?: Schema$GoogleCloudDocumentaiV1beta3SummaryOptions;
    }
    /**
     * Specifies a document stored on Cloud Storage.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3GcsDocument {
        /**
         * The Cloud Storage object uri.
         */
        gcsUri?: string | null;
        /**
         * An IANA MIME type (RFC6838) of the content.
         */
        mimeType?: string | null;
    }
    /**
     * Specifies a set of documents on Cloud Storage.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3GcsDocuments {
        /**
         * The list of documents.
         */
        documents?: Schema$GoogleCloudDocumentaiV1beta3GcsDocument[];
    }
    /**
     * Specifies all documents on Cloud Storage with a common prefix.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3GcsPrefix {
        /**
         * The URI prefix.
         */
        gcsUriPrefix?: string | null;
    }
    /**
     * Request message for GenerateSchemaVersion.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionRequest {
        /**
         * The base schema version name to use for the schema generation. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}`
         */
        baseSchemaVersion?: string | null;
        /**
         * The set of documents placed on Cloud Storage.
         */
        gcsDocuments?: Schema$GoogleCloudDocumentaiV1beta3GcsDocuments;
        /**
         * The common prefix of documents placed on Cloud Storage.
         */
        gcsPrefix?: Schema$GoogleCloudDocumentaiV1beta3GcsPrefix;
        /**
         * Optional. User specified parameters for the schema generation.
         */
        generateSchemaVersionParams?: Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionRequestGenerateSchemaVersionParams;
        /**
         * The set of documents specified inline. For each document, its `uri` or `content` field must be set.
         */
        inlineDocuments?: Schema$GoogleCloudDocumentaiV1beta3Documents;
        /**
         * The set of raw documents.
         */
        rawDocuments?: Schema$GoogleCloudDocumentaiV1beta3RawDocuments;
    }
    /**
     * The parameters for the schema generation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionRequestGenerateSchemaVersionParams {
        /**
         * Optional. Previous prompt-answers in a chronological order.
         */
        history?: Schema$GoogleCloudDocumentaiV1beta3SchemaGenerationHistory;
        /**
         * Optional. The prompt used for the schema generation.
         */
        prompt?: string | null;
    }
    /**
     * Response message for GenerateSchemaVersion.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionResponse {
        /**
         * The schema version generated by the model.
         */
        schemaVersion?: Schema$GoogleCloudDocumentaiV1beta3SchemaVersion;
    }
    export interface Schema$GoogleCloudDocumentaiV1beta3GetDocumentResponse {
        document?: Schema$GoogleCloudDocumentaiV1beta3Document;
    }
    /**
     * The status of human review on a processed document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3HumanReviewStatus {
        /**
         * The name of the operation triggered by the processed document. This field is populated only when the state is `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and metadata as the long-running operation returned by ReviewDocument.
         */
        humanReviewOperation?: string | null;
        /**
         * The state of human review on the processing request.
         */
        state?: string | null;
        /**
         * A message providing more details about the human review state.
         */
        stateMessage?: string | null;
    }
    /**
     * Metadata of the import document operation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
        /**
         * Validation statuses of the batch documents import config.
         */
        importConfigValidationResults?: Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult[];
        /**
         * The list of response details of each document.
         */
        individualImportStatuses?: Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus[];
        /**
         * Total number of the documents that are qualified for importing.
         */
        totalDocumentCount?: number | null;
    }
    /**
     * The validation status of each import config. Status is set to an error if there are no documents to import in the `import_config`, or `OK` if the operation will try to proceed with at least one document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataImportConfigValidationResult {
        /**
         * The source Cloud Storage URI specified in the import config.
         */
        inputGcsSource?: string | null;
        /**
         * The validation status of import config.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * The status of each individual document in the import process.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsMetadataIndividualImportStatus {
        /**
         * The source Cloud Storage URI of the document.
         */
        inputGcsSource?: string | null;
        /**
         * The document id of imported document if it was successful, otherwise empty.
         */
        outputDocumentId?: Schema$GoogleCloudDocumentaiV1beta3DocumentId;
        /**
         * The status of the importing of the document.
         */
        status?: Schema$GoogleRpcStatus;
    }
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsRequest {
        /**
         * Required. The Cloud Storage uri containing raw documents that must be imported.
         */
        batchDocumentsImportConfigs?: Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfig[];
    }
    /**
     * Config for importing documents. Each batch can have its own dataset split type.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfig {
        /**
         * If set, documents will be automatically split into training and test split category with the specified ratio.
         */
        autoSplitConfig?: Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfigAutoSplitConfig;
        /**
         * The common config to specify a set of documents used as input.
         */
        batchInputConfig?: Schema$GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig;
        /**
         * Target dataset split where the documents must be stored.
         */
        datasetSplit?: string | null;
        /**
         * Optional. If set, determines the type of the documents to be imported in this batch. It can be used to auto-label the documents with a single entity of the provided type. This field can only be used with a classifier or splitter processor. Providing this field is mutually exclusive with `entities` and `auto_labeling_config`.
         */
        documentType?: string | null;
    }
    /**
     * The config for auto-split.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsRequestBatchDocumentsImportConfigAutoSplitConfig {
        /**
         * Ratio of training dataset split.
         */
        trainingSplitRatio?: number | null;
    }
    /**
     * Response of the import document operation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsResponse {
    }
    /**
     * The long-running operation metadata for the ImportProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportProcessorVersionMetadata {
        /**
         * The basic metadata for the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * The request message for the ImportProcessorVersion method. The Document AI [Service Agent](https://cloud.google.com/iam/docs/service-agents) of the destination project must have [Document AI Editor role](https://cloud.google.com/document-ai/docs/access-control/iam-roles) on the source project. The destination project is specified as part of the parent field. The source project is specified as part of the source or external_processor_version_source field.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest {
        /**
         * The source processor version to import from. It can be from a different environment and region than the destination processor.
         */
        externalProcessorVersionSource?: Schema$GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequestExternalProcessorVersionSource;
        /**
         * The source processor version to import from. The source processor version and destination processor need to be in the same environment and region.
         */
        processorVersionSource?: string | null;
    }
    /**
     * The external source processor version.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequestExternalProcessorVersionSource {
        /**
         * Required. The processor version name. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        processorVersion?: string | null;
        /**
         * Optional. The Document AI service endpoint. For example, 'https://us-documentai.googleapis.com'
         */
        serviceEndpoint?: string | null;
    }
    /**
     * The response message for the ImportProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ImportProcessorVersionResponse {
        /**
         * The destination processor version name.
         */
        processorVersion?: string | null;
    }
    export interface Schema$GoogleCloudDocumentaiV1beta3ListDocumentsRequest {
        /**
         * Optional. Query to filter the documents based on https://google.aip.dev/160. ## Currently support query strings are: `SplitType=DATASET_SPLIT_TEST|DATASET_SPLIT_TRAIN|DATASET_SPLIT_UNASSIGNED` - `LabelingState=DOCUMENT_LABELED|DOCUMENT_UNLABELED|DOCUMENT_AUTO_LABELED` - `DisplayName=\"file_name.pdf\"` - `EntityType=abc/def` - `TagName=\"auto-labeling-running\"|\"sampled\"` Note: - Only `AND`, `=` and `!=` are supported. e.g. `DisplayName=file_name AND EntityType!=abc` IS supported. - Wildcard `*` is supported only in `DisplayName` filter - No duplicate filter keys are allowed, e.g. `EntityType=a AND EntityType=b` is NOT supported. - String match is case sensitive (for filter `DisplayName` & `EntityType`).
         */
        filter?: string | null;
        /**
         * The maximum number of documents to return. The service may return fewer than this value. If unspecified, at most 20 documents will be returned. The maximum value is 100; values above 100 will be coerced to 100.
         */
        pageSize?: number | null;
        /**
         * A page token, received from a previous `ListDocuments` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListDocuments` must match the call that provided the page token.
         */
        pageToken?: string | null;
        /**
         * Optional. Controls if the request requires a total size of matched documents. See ListDocumentsResponse.total_size. Enabling this flag may adversely impact performance. Defaults to false.
         */
        returnTotalSize?: boolean | null;
        /**
         * Optional. Number of results to skip beginning from the `page_token` if provided. https://google.aip.dev/158#skipping-results. It must be a non-negative integer. Negative values will be rejected. Note that this is not the number of pages to skip. If this value causes the cursor to move past the end of results, ListDocumentsResponse.document_metadata and ListDocumentsResponse.next_page_token will be empty.
         */
        skip?: number | null;
    }
    export interface Schema$GoogleCloudDocumentaiV1beta3ListDocumentsResponse {
        /**
         * Document metadata corresponding to the listed documents.
         */
        documentMetadata?: Schema$GoogleCloudDocumentaiV1beta3DocumentMetadata[];
        /**
         * A token, which can be sent as ListDocumentsRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * Total count of documents queried.
         */
        totalSize?: number | null;
    }
    /**
     * The response from `ListEvaluations`.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ListEvaluationsResponse {
        /**
         * The evaluations requested.
         */
        evaluations?: Schema$GoogleCloudDocumentaiV1beta3Evaluation[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for the ListProcessors method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ListProcessorsResponse {
        /**
         * Points to the next processor, otherwise empty.
         */
        nextPageToken?: string | null;
        /**
         * The list of processors.
         */
        processors?: Schema$GoogleCloudDocumentaiV1beta3Processor[];
    }
    /**
     * Response message for the ListProcessorTypes method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse {
        /**
         * Points to the next page, otherwise empty.
         */
        nextPageToken?: string | null;
        /**
         * The processor types.
         */
        processorTypes?: Schema$GoogleCloudDocumentaiV1beta3ProcessorType[];
    }
    /**
     * Response message for the ListProcessorVersions method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse {
        /**
         * Points to the next processor, otherwise empty.
         */
        nextPageToken?: string | null;
        /**
         * The list of processors.
         */
        processorVersions?: Schema$GoogleCloudDocumentaiV1beta3ProcessorVersion[];
    }
    /**
     * Response message for ListSchemas.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ListSchemasResponse {
        /**
         * Points to the next Schema, otherwise empty.
         */
        nextPageToken?: string | null;
        /**
         * The list of Schemas.
         */
        schemas?: Schema$GoogleCloudDocumentaiV1beta3NextSchema[];
    }
    /**
     * Response message for ListSchemaVersions.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ListSchemaVersionsResponse {
        /**
         * Points to the next SchemaVersion, otherwise empty.
         */
        nextPageToken?: string | null;
        /**
         * The list of SchemaVersions.
         */
        schemaVersions?: Schema$GoogleCloudDocumentaiV1beta3SchemaVersion[];
    }
    /**
     * NextSchema is a collection of SchemaVersions.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3NextSchema {
        /**
         * Output only. The time when the Schema was created.
         */
        createTime?: string | null;
        /**
         * Required. The user-defined name of the Schema.
         */
        displayName?: string | null;
        /**
         * Optional. The GCP labels for the Schema.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Identifier. The resource name of the Schema. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         */
        name?: string | null;
        /**
         * Output only. The time when the Schema was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * A vertex represents a 2D point in the image. NOTE: the normalized vertex coordinates are relative to the original image and range from 0 to 1.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3NormalizedVertex {
        /**
         * X coordinate.
         */
        x?: number | null;
        /**
         * Y coordinate (starts from the top of the image).
         */
        y?: number | null;
    }
    /**
     * Config for Document OCR.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3OcrConfig {
        /**
         * A list of advanced OCR options to further fine-tune OCR behavior. Current valid values are: - `legacy_layout`: a heuristics layout detection algorithm, which serves as an alternative to the current ML-based layout detection algorithm. Customers can choose the best suitable layout algorithm based on their situation.
         */
        advancedOcrOptions?: string[] | null;
        /**
         * Turn on font identification model and return font style information. Deprecated, use PremiumFeatures.compute_style_info instead.
         */
        computeStyleInfo?: boolean | null;
        /**
         * Turn off character box detector in OCR engine. Character box detection is enabled by default in OCR 2.0 (and later) processors.
         */
        disableCharacterBoxesDetection?: boolean | null;
        /**
         * Enables intelligent document quality scores after OCR. Can help with diagnosing why OCR responses are of poor quality for a given input. Adds additional latency comparable to regular OCR to the process call.
         */
        enableImageQualityScores?: boolean | null;
        /**
         * Enables special handling for PDFs with existing text information. Results in better text extraction quality in such PDF inputs.
         */
        enableNativePdfParsing?: boolean | null;
        /**
         * Includes symbol level OCR information if set to true.
         */
        enableSymbol?: boolean | null;
        /**
         * Hints for the OCR model.
         */
        hints?: Schema$GoogleCloudDocumentaiV1beta3OcrConfigHints;
        /**
         * Configurations for premium OCR features.
         */
        premiumFeatures?: Schema$GoogleCloudDocumentaiV1beta3OcrConfigPremiumFeatures;
    }
    /**
     * Hints for OCR Engine
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3OcrConfigHints {
        /**
         * List of BCP-47 language codes to use for OCR. In most cases, not specifying it yields the best results since it enables automatic language detection. For languages based on the Latin alphabet, setting hints is not needed. In rare cases, when the language of the text in the image is known, setting a hint will help get better results (although it will be a significant hindrance if the hint is wrong).
         */
        languageHints?: string[] | null;
    }
    /**
     * Configurations for premium OCR features.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3OcrConfigPremiumFeatures {
        /**
         * Turn on font identification model and return font style information.
         */
        computeStyleInfo?: boolean | null;
        /**
         * Turn on the model that can extract LaTeX math formulas.
         */
        enableMathOcr?: boolean | null;
        /**
         * Turn on selection mark detector in OCR engine. Only available in OCR 2.0 (and later) processors.
         */
        enableSelectionMarkDetection?: boolean | null;
    }
    /**
     * Options for Process API
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessOptions {
        /**
         * Only process certain pages from the end, same as above.
         */
        fromEnd?: number | null;
        /**
         * Only process certain pages from the start. Process all if the document has fewer pages.
         */
        fromStart?: number | null;
        /**
         * Which pages to process (1-indexed).
         */
        individualPageSelector?: Schema$GoogleCloudDocumentaiV1beta3ProcessOptionsIndividualPageSelector;
        /**
         * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`. Returns error if set on other processor types.
         */
        layoutConfig?: Schema$GoogleCloudDocumentaiV1beta3ProcessOptionsLayoutConfig;
        /**
         * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`. Returns error if set on other processor types.
         */
        ocrConfig?: Schema$GoogleCloudDocumentaiV1beta3OcrConfig;
        /**
         * Optional. Override the schema of the ProcessorVersion. Will return an Invalid Argument error if this field is set when the underlying ProcessorVersion doesn't support schema override.
         */
        schemaOverride?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchema;
    }
    /**
     * A list of individual page numbers.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessOptionsIndividualPageSelector {
        /**
         * Optional. Indices of the pages (starting from 1).
         */
        pages?: number[] | null;
    }
    /**
     * Serving config for layout parser processor.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessOptionsLayoutConfig {
        /**
         * Optional. Config for chunking in layout parser processor.
         */
        chunkingConfig?: Schema$GoogleCloudDocumentaiV1beta3ProcessOptionsLayoutConfigChunkingConfig;
        /**
         * Optional. Whether to include image annotations in layout parser response.
         */
        enableImageAnnotation?: boolean | null;
        /**
         * Optional. Whether to extract images in layout parser response.
         */
        enableImageExtraction?: boolean | null;
        /**
         * Optional. Whether to refine PDF layout using LLM.
         */
        enableLlmLayoutParsing?: boolean | null;
        /**
         * Optional. Whether to include table annotations in layout parser response.
         */
        enableTableAnnotation?: boolean | null;
        /**
         * Optional. Whether to split table.
         */
        enableTableSplit?: boolean | null;
        /**
         * Optional. Whether to include bounding boxes in layout parser processor response.
         */
        returnBoundingBoxes?: boolean | null;
        /**
         * Optional. Whether to include images in layout parser processor response.
         */
        returnImages?: boolean | null;
    }
    /**
     * Serving config for chunking.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessOptionsLayoutConfigChunkingConfig {
        /**
         * Optional. The percentile of cosine dissimilarity that must be exceeded between a group of tokens and the next. The smaller this number is, the more chunks will be generated. THIS FIELD IS NOT YET USED.
         */
        breakpointPercentileThreshold?: number | null;
        /**
         * Optional. The chunk sizes to use when splitting documents, in order of level.
         */
        chunkSize?: number | null;
        /**
         * Optional. Whether or not to include ancestor headings when splitting.
         */
        includeAncestorHeadings?: boolean | null;
        /**
         * Optional. The number of tokens to group together when evaluating semantic similarity. THIS FIELD IS NOT YET USED.
         */
        semanticChunkingGroupSize?: boolean | null;
    }
    /**
     * The first-class citizen for Document AI. Each processor defines how to extract structural information from a document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3Processor {
        /**
         * Optional. SchemaVersion used by the Processor. It is the same as Processor's DatasetSchema.schema_version Format is `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}
         */
        activeSchemaVersion?: string | null;
        /**
         * Output only. The time the processor was created.
         */
        createTime?: string | null;
        /**
         * The default processor version.
         */
        defaultProcessorVersion?: string | null;
        /**
         * The display name of the processor.
         */
        displayName?: string | null;
        /**
         * The [KMS key](https://cloud.google.com/security-key-management) used for encryption and decryption in CMEK scenarios.
         */
        kmsKeyName?: string | null;
        /**
         * Output only. Immutable. The resource name of the processor. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`
         */
        name?: string | null;
        /**
         * Output only. Immutable. The http endpoint that can be called to invoke processing.
         */
        processEndpoint?: string | null;
        /**
         * Output only. The processor version aliases.
         */
        processorVersionAliases?: Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionAlias[];
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. The state of the processor.
         */
        state?: string | null;
        /**
         * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`. To get a list of processor types, see FetchProcessorTypes.
         */
        type?: string | null;
    }
    /**
     * A processor type is responsible for performing a certain document understanding task on a certain type of document.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessorType {
        /**
         * Whether the processor type allows creation. If true, users can create a processor of this processor type. Otherwise, users need to request access.
         */
        allowCreation?: boolean | null;
        /**
         * The locations in which this processor is available.
         */
        availableLocations?: Schema$GoogleCloudDocumentaiV1beta3ProcessorTypeLocationInfo[];
        /**
         * The processor category, used by UI to group processor types.
         */
        category?: string | null;
        /**
         * Launch stage of the processor type
         */
        launchStage?: string | null;
        /**
         * The resource name of the processor type. Format: `projects/{project\}/processorTypes/{processor_type\}`
         */
        name?: string | null;
        /**
         * A set of Cloud Storage URIs of sample documents for this processor.
         */
        sampleDocumentUris?: string[] | null;
        /**
         * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
         */
        type?: string | null;
    }
    /**
     * The location information about where the processor is available.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessorTypeLocationInfo {
        /**
         * The location ID. For supported locations, refer to [regional and multi-regional support](/document-ai/docs/regions).
         */
        locationId?: string | null;
    }
    /**
     * A processor version is an implementation of a processor. Each processor can have multiple versions, pretrained by Google internally or uptrained by the customer. A processor can only have one default version at a time. Its document-processing behavior is defined by that version.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessorVersion {
        /**
         * Output only. The time the processor version was created.
         */
        createTime?: string | null;
        /**
         * Output only. If set, information about the eventual deprecation of this version.
         */
        deprecationInfo?: Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionDeprecationInfo;
        /**
         * The display name of the processor version.
         */
        displayName?: string | null;
        /**
         * Output only. The schema of the processor version. Describes the output.
         */
        documentSchema?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchema;
        /**
         * Output only. Information about Generative AI model-based processor versions.
         */
        genAiModelInfo?: Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionGenAiModelInfo;
        /**
         * Output only. Denotes that this `ProcessorVersion` is managed by Google.
         */
        googleManaged?: boolean | null;
        /**
         * Output only. The KMS key name used for encryption.
         */
        kmsKeyName?: string | null;
        /**
         * Output only. The KMS key version with which data is encrypted.
         */
        kmsKeyVersionName?: string | null;
        /**
         * Output only. The most recently invoked evaluation for the processor version.
         */
        latestEvaluation?: Schema$GoogleCloudDocumentaiV1beta3EvaluationReference;
        /**
         * Output only. The model type of this processor version.
         */
        modelType?: string | null;
        /**
         * Identifier. The resource name of the processor version. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processor_version\}`
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. The state of the processor version.
         */
        state?: string | null;
    }
    /**
     * Contains the alias and the aliased resource name of processor version.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionAlias {
        /**
         * The alias in the form of `processor_version` resource name.
         */
        alias?: string | null;
        /**
         * The resource name of aliased processor version.
         */
        processorVersion?: string | null;
    }
    /**
     * Information about the upcoming deprecation of this processor version.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionDeprecationInfo {
        /**
         * The time at which this processor version will be deprecated.
         */
        deprecationTime?: string | null;
        /**
         * If set, the processor version that will be used as a replacement.
         */
        replacementProcessorVersion?: string | null;
    }
    /**
     * Information about Generative AI model-based processor versions.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionGenAiModelInfo {
        /**
         * Information for a custom Generative AI model created by the user.
         */
        customGenAiModelInfo?: Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionGenAiModelInfoCustomGenAiModelInfo;
        /**
         * Information for a pretrained Google-managed foundation model.
         */
        foundationGenAiModelInfo?: Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo;
    }
    /**
     * Information for a custom Generative AI model created by the user. These are created with `Create New Version` in either the `Call foundation model` or `Fine tuning` tabs.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionGenAiModelInfoCustomGenAiModelInfo {
        /**
         * The base processor version ID for the custom model.
         */
        baseProcessorVersionId?: string | null;
        /**
         * The type of custom model created by the user.
         */
        customModelType?: string | null;
    }
    /**
     * Information for a pretrained Google-managed foundation model.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessorVersionGenAiModelInfoFoundationGenAiModelInfo {
        /**
         * Whether finetuning is allowed for this base processor version.
         */
        finetuningAllowed?: boolean | null;
        /**
         * The minimum number of labeled documents in the training dataset required for finetuning.
         */
        minTrainLabeledDocuments?: number | null;
    }
    /**
     * Request message for the ProcessDocument method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessRequest {
        /**
         * The document payload, the content and mime_type fields must be set.
         */
        document?: Schema$GoogleCloudDocumentaiV1beta3Document;
        /**
         * Specifies which fields to include in the ProcessResponse.document output. Only supports top-level document and pages field, so it must be in the form of `{document_field_name\}` or `pages.{page_field_name\}`.
         */
        fieldMask?: string | null;
        /**
         * A raw document on Google Cloud Storage.
         */
        gcsDocument?: Schema$GoogleCloudDocumentaiV1beta3GcsDocument;
        /**
         * Optional. Option to remove images from the document.
         */
        imagelessMode?: boolean | null;
        /**
         * An inline document proto.
         */
        inlineDocument?: Schema$GoogleCloudDocumentaiV1beta3Document;
        /**
         * Optional. The labels with user-defined metadata for the request. Label keys and values can be no longer than 63 characters (Unicode codepoints) and can only contain lowercase letters, numeric characters, underscores, and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Inference-time options for the process API
         */
        processOptions?: Schema$GoogleCloudDocumentaiV1beta3ProcessOptions;
        /**
         * A raw document content (bytes).
         */
        rawDocument?: Schema$GoogleCloudDocumentaiV1beta3RawDocument;
        /**
         * Whether human review should be skipped for this request. Default to `false`.
         */
        skipHumanReview?: boolean | null;
    }
    /**
     * Response message for the ProcessDocument method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ProcessResponse {
        /**
         * The document payload, will populate fields based on the processor's behavior.
         */
        document?: Schema$GoogleCloudDocumentaiV1beta3Document;
        /**
         * The name of the operation triggered by the processed document. If the human review process isn't triggered, this field is empty. It has the same response type and metadata as the long-running operation returned by ReviewDocument.
         */
        humanReviewOperation?: string | null;
        /**
         * The status of human review on the processed document.
         */
        humanReviewStatus?: Schema$GoogleCloudDocumentaiV1beta3HumanReviewStatus;
    }
    /**
     * Metadata about a property.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3PropertyMetadata {
        /**
         * Field extraction metadata on the property.
         */
        fieldExtractionMetadata?: Schema$GoogleCloudDocumentaiV1beta3FieldExtractionMetadata;
        /**
         * Whether the property should be considered as "inactive".
         */
        inactive?: boolean | null;
    }
    /**
     * Payload message of raw document content (bytes).
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3RawDocument {
        /**
         * Inline document content.
         */
        content?: string | null;
        /**
         * The display name of the document, it supports all Unicode characters except the following: `*`, `?`, `[`, `]`, `%`, `{`, `\}`,`'`, `\"`, `,` `~`, `=` and `:` are reserved. If not specified, a default ID is generated.
         */
        displayName?: string | null;
        /**
         * An IANA MIME type (RFC6838) indicating the nature and format of the content.
         */
        mimeType?: string | null;
    }
    /**
     * Specifies a set of raw documents.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3RawDocuments {
        /**
         * Specifies raw document content and mime type.
         */
        documents?: Schema$GoogleCloudDocumentaiV1beta3RawDocument[];
    }
    /**
     * The long-running operation metadata for the ReviewDocument method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ReviewDocumentOperationMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
        /**
         * The creation time of the operation.
         */
        createTime?: string | null;
        /**
         * The Crowd Compute question ID.
         */
        questionId?: string | null;
        /**
         * Used only when Operation.done is false.
         */
        state?: string | null;
        /**
         * A message providing more details about the current state of processing. For example, the error message if the operation is failed.
         */
        stateMessage?: string | null;
        /**
         * The last update time of the operation.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for the ReviewDocument method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ReviewDocumentRequest {
        /**
         * The document that needs human review.
         */
        document?: Schema$GoogleCloudDocumentaiV1beta3Document;
        /**
         * The document schema of the human review task.
         */
        documentSchema?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchema;
        /**
         * Whether the validation should be performed on the ad-hoc review request.
         */
        enableSchemaValidation?: boolean | null;
        /**
         * An inline document proto.
         */
        inlineDocument?: Schema$GoogleCloudDocumentaiV1beta3Document;
        /**
         * The priority of the human review task.
         */
        priority?: string | null;
    }
    /**
     * Response message for the ReviewDocument method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3ReviewDocumentResponse {
        /**
         * The Cloud Storage uri for the human reviewed document if the review is succeeded.
         */
        gcsDestination?: string | null;
        /**
         * The reason why the review is rejected by reviewer.
         */
        rejectionReason?: string | null;
        /**
         * The state of the review operation.
         */
        state?: string | null;
    }
    /**
     * The revision reference specifies which revision on the document to read.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3RevisionRef {
        /**
         * Reads the revision generated by the processor version. The format takes the full resource name of processor version. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        latestProcessorVersion?: string | null;
        /**
         * Reads the revision by the predefined case.
         */
        revisionCase?: string | null;
        /**
         * Reads the revision given by the id.
         */
        revisionId?: string | null;
    }
    /**
     * The history of schema generation iterations.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3SchemaGenerationHistory {
        /**
         * Required. Previous prompt-answers in a chronological order.
         */
        iterations?: Schema$GoogleCloudDocumentaiV1beta3SchemaGenerationIteration[];
    }
    /**
     * A single iteration of the schema generation.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3SchemaGenerationIteration {
        /**
         * Optional. The previous schema version adjusted by the model.
         */
        adjustedSchema?: Schema$GoogleCloudDocumentaiV1beta3SchemaVersion;
        /**
         * Required. The schema version generated by the model.
         */
        generatedSchema?: Schema$GoogleCloudDocumentaiV1beta3SchemaVersion;
        /**
         * Optional. The prompt used for the iteration.
         */
        prompt?: string | null;
    }
    /**
     * SchemaVersion is a version of the Schema which is created in SchemaGroup.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3SchemaVersion {
        /**
         * Output only. The time when the SchemaVersion was created.
         */
        createTime?: string | null;
        /**
         * Required. The user-defined name of the SchemaVersion.
         */
        displayName?: string | null;
        /**
         * Optional. The GCP labels for the SchemaVersion.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Identifier. The resource name of the SchemaVersion. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}`
         */
        name?: string | null;
        /**
         * Required. The schema of the SchemaVersion.
         */
        schema?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchema;
    }
    /**
     * The long-running operation metadata for the SetDefaultProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * Request message for the SetDefaultProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest {
        /**
         * Required. The resource name of child ProcessorVersion to use as default. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{version\}`
         */
        defaultProcessorVersion?: string | null;
    }
    /**
     * Response message for the SetDefaultProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionResponse {
    }
    /**
     * Metadata for document summarization.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3SummaryOptions {
        /**
         * The format the summary should be in.
         */
        format?: string | null;
        /**
         * How long the summary should be.
         */
        length?: string | null;
    }
    /**
     * The metadata that represents a processor version being created.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
        /**
         * The test dataset validation information.
         */
        testDatasetValidation?: Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation;
        /**
         * The training dataset validation information.
         */
        trainingDatasetValidation?: Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation;
    }
    /**
     * The dataset validation information. This includes any and all errors with documents and the dataset.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionMetadataDatasetValidation {
        /**
         * The total number of dataset errors.
         */
        datasetErrorCount?: number | null;
        /**
         * Error information for the dataset as a whole. A maximum of 10 dataset errors will be returned. A single dataset error is terminal for training.
         */
        datasetErrors?: Schema$GoogleRpcStatus[];
        /**
         * The total number of document errors.
         */
        documentErrorCount?: number | null;
        /**
         * Error information pertaining to specific documents. A maximum of 10 document errors will be returned. Any document with errors will not be used throughout training.
         */
        documentErrors?: Schema$GoogleRpcStatus[];
    }
    /**
     * Request message for the TrainProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest {
        /**
         * Optional. The processor version to use as a base for training. This processor version must be a child of `parent`. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`.
         */
        baseProcessorVersion?: string | null;
        /**
         * Options to control Custom Document Extraction (CDE) Processor.
         */
        customDocumentExtractionOptions?: Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestCustomDocumentExtractionOptions;
        /**
         * Optional. The schema the processor version will be trained with.
         */
        documentSchema?: Schema$GoogleCloudDocumentaiV1beta3DocumentSchema;
        /**
         * Options to control foundation model tuning of a processor.
         */
        foundationModelTuningOptions?: Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationModelTuningOptions;
        /**
         * Optional. The input data used to train the ProcessorVersion.
         */
        inputData?: Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestInputData;
        /**
         * Required. The processor version to be created.
         */
        processorVersion?: Schema$GoogleCloudDocumentaiV1beta3ProcessorVersion;
    }
    /**
     * Options to control the training of the Custom Document Extraction (CDE) Processor.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestCustomDocumentExtractionOptions {
        /**
         * Optional. Training method to use for CDE training.
         */
        trainingMethod?: string | null;
    }
    /**
     * Options to control foundation model tuning of the processor.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestFoundationModelTuningOptions {
        /**
         * Optional. The multiplier to apply to the recommended learning rate. Valid values are between 0.1 and 10. If not provided, recommended learning rate will be used.
         */
        learningRateMultiplier?: number | null;
        /**
         * Optional. The number of steps to run for model tuning. Valid values are between 1 and 400. If not provided, recommended steps will be used.
         */
        trainSteps?: number | null;
    }
    /**
     * The input data used to train a new ProcessorVersion.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequestInputData {
        /**
         * The documents used for testing the trained version.
         */
        testDocuments?: Schema$GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig;
        /**
         * The documents used for training the new version.
         */
        trainingDocuments?: Schema$GoogleCloudDocumentaiV1beta3BatchDocumentsInputConfig;
    }
    /**
     * The response for TrainProcessorVersion.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionResponse {
        /**
         * The resource name of the processor version produced by training.
         */
        processorVersion?: string | null;
    }
    /**
     * The long-running operation metadata for the UndeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3UndeployProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * Request message for the UndeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3UndeployProcessorVersionRequest {
    }
    /**
     * Response message for the UndeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3UndeployProcessorVersionResponse {
    }
    export interface Schema$GoogleCloudDocumentaiV1beta3UpdateDatasetOperationMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the UpdateProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3UpdateProcessorVersionMetadata {
        /**
         * The basic metadata for the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1beta3CommonOperationMetadata;
    }
    /**
     * A vertex represents a 2D point in the image. NOTE: the vertex coordinates are in the same scale as the original image.
     */
    export interface Schema$GoogleCloudDocumentaiV1beta3Vertex {
        /**
         * X coordinate.
         */
        x?: number | null;
        /**
         * Y coordinate (starts from the top of the image).
         */
        y?: number | null;
    }
    /**
     * The common metadata for long running operations.
     */
    export interface Schema$GoogleCloudDocumentaiV1CommonOperationMetadata {
        /**
         * The creation time of the operation.
         */
        createTime?: string | null;
        /**
         * A related resource to this operation.
         */
        resource?: string | null;
        /**
         * The state of the operation.
         */
        state?: string | null;
        /**
         * A message providing more details about the current state of processing.
         */
        stateMessage?: string | null;
        /**
         * The last update time of the operation.
         */
        updateTime?: string | null;
    }
    /**
     * The long-running operation metadata for the DeleteProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiV1DeleteProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the DeleteProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1DeleteProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
    }
    /**
     * The long-running operation metadata for the DeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1DeployProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
    }
    /**
     * Response message for the DeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1DeployProcessorVersionResponse {
    }
    /**
     * The long-running operation metadata for the DisableProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiV1DisableProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
    }
    /**
     * Response message for the DisableProcessor method. Intentionally empty proto for adding fields in future.
     */
    export interface Schema$GoogleCloudDocumentaiV1DisableProcessorResponse {
    }
    /**
     * The long-running operation metadata for the EnableProcessor method.
     */
    export interface Schema$GoogleCloudDocumentaiV1EnableProcessorMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
    }
    /**
     * Response message for the EnableProcessor method. Intentionally empty proto for adding fields in future.
     */
    export interface Schema$GoogleCloudDocumentaiV1EnableProcessorResponse {
    }
    /**
     * Metadata of the EvaluateProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1EvaluateProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
    }
    /**
     * Response of the EvaluateProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1EvaluateProcessorVersionResponse {
        /**
         * The resource name of the created evaluation.
         */
        evaluation?: string | null;
    }
    /**
     * The status of human review on a processed document.
     */
    export interface Schema$GoogleCloudDocumentaiV1HumanReviewStatus {
        /**
         * The name of the operation triggered by the processed document. This field is populated only when the state is `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and metadata as the long-running operation returned by ReviewDocument.
         */
        humanReviewOperation?: string | null;
        /**
         * The state of human review on the processing request.
         */
        state?: string | null;
        /**
         * A message providing more details about the human review state.
         */
        stateMessage?: string | null;
    }
    /**
     * The long-running operation metadata for the ReviewDocument method.
     */
    export interface Schema$GoogleCloudDocumentaiV1ReviewDocumentOperationMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
        /**
         * The Crowd Compute question ID.
         */
        questionId?: string | null;
    }
    /**
     * Response message for the ReviewDocument method.
     */
    export interface Schema$GoogleCloudDocumentaiV1ReviewDocumentResponse {
        /**
         * The Cloud Storage uri for the human reviewed document if the review is succeeded.
         */
        gcsDestination?: string | null;
        /**
         * The reason why the review is rejected by reviewer.
         */
        rejectionReason?: string | null;
        /**
         * The state of the review operation.
         */
        state?: string | null;
    }
    /**
     * The long-running operation metadata for the SetDefaultProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1SetDefaultProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
    }
    /**
     * Response message for the SetDefaultProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1SetDefaultProcessorVersionResponse {
    }
    /**
     * The metadata that represents a processor version being created.
     */
    export interface Schema$GoogleCloudDocumentaiV1TrainProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
        /**
         * The test dataset validation information.
         */
        testDatasetValidation?: Schema$GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation;
        /**
         * The training dataset validation information.
         */
        trainingDatasetValidation?: Schema$GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation;
    }
    /**
     * The dataset validation information. This includes any and all errors with documents and the dataset.
     */
    export interface Schema$GoogleCloudDocumentaiV1TrainProcessorVersionMetadataDatasetValidation {
        /**
         * The total number of dataset errors.
         */
        datasetErrorCount?: number | null;
        /**
         * Error information for the dataset as a whole. A maximum of 10 dataset errors will be returned. A single dataset error is terminal for training.
         */
        datasetErrors?: Schema$GoogleRpcStatus[];
        /**
         * The total number of document errors.
         */
        documentErrorCount?: number | null;
        /**
         * Error information pertaining to specific documents. A maximum of 10 document errors will be returned. Any document with errors will not be used throughout training.
         */
        documentErrors?: Schema$GoogleRpcStatus[];
    }
    /**
     * The response for TrainProcessorVersion.
     */
    export interface Schema$GoogleCloudDocumentaiV1TrainProcessorVersionResponse {
        /**
         * The resource name of the processor version produced by training.
         */
        processorVersion?: string | null;
    }
    /**
     * The long-running operation metadata for the UndeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1UndeployProcessorVersionMetadata {
        /**
         * The basic metadata of the long-running operation.
         */
        commonMetadata?: Schema$GoogleCloudDocumentaiV1CommonOperationMetadata;
    }
    /**
     * Response message for the UndeployProcessorVersion method.
     */
    export interface Schema$GoogleCloudDocumentaiV1UndeployProcessorVersionResponse {
    }
    /**
     * The response message for Locations.ListLocations.
     */
    export interface Schema$GoogleCloudLocationListLocationsResponse {
        /**
         * A list of locations that matches the specified filter in the request.
         */
        locations?: Schema$GoogleCloudLocationLocation[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * A resource that represents a Google Cloud location.
     */
    export interface Schema$GoogleCloudLocationLocation {
        /**
         * The friendly name for this location, typically a nearby city name. For example, "Tokyo".
         */
        displayName?: string | null;
        /**
         * Cross-service attributes for the location. For example {"cloud.googleapis.com/region": "us-east1"\}
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * The canonical id for this location. For example: `"us-east1"`.
         */
        locationId?: string | null;
        /**
         * Service-specific metadata. For example the available capacity at the given location.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * Resource name for the location, which may vary between implementations. For example: `"projects/example-project/locations/us-east1"`
         */
        name?: string | null;
    }
    /**
     * The response message for Operations.ListOperations.
     */
    export interface Schema$GoogleLongrunningListOperationsResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
        /**
         * A list of operations that matches the specified filter in the request.
         */
        operations?: Schema$GoogleLongrunningOperation[];
        /**
         * Unordered list. Unreachable resources. Populated when the request sets `ListOperationsRequest.return_partial_success` and reads across collections. For example, when attempting to list all resources across all supported locations.
         */
        unreachable?: string[] | null;
    }
    /**
     * This resource represents a long-running operation that is the result of a network API call.
     */
    export interface Schema$GoogleLongrunningOperation {
        /**
         * If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
         */
        done?: boolean | null;
        /**
         * The error result of the operation in case of failure or cancellation.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id\}`.
         */
        name?: string | null;
        /**
         * The normal, successful response of the operation. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
         */
        response?: {
            [key: string]: any;
        } | null;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); \}
     */
    export interface Schema$GoogleProtobufEmpty {
    }
    /**
     * The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
     */
    export interface Schema$GoogleRpcStatus {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number | null;
        /**
         * A list of messages that carry the error details. There is a common set of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }> | null;
        /**
         * A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
         */
        message?: string | null;
    }
    /**
     * Represents a color in the RGBA color space. This representation is designed for simplicity of conversion to and from color representations in various languages over compactness. For example, the fields of this representation can be trivially provided to the constructor of `java.awt.Color` in Java; it can also be trivially provided to UIColor's `+colorWithRed:green:blue:alpha` method in iOS; and, with just a little work, it can be easily formatted into a CSS `rgba()` string in JavaScript. This reference page doesn't have information about the absolute color space that should be used to interpret the RGB value—for example, sRGB, Adobe RGB, DCI-P3, and BT.2020. By default, applications should assume the sRGB color space. When color equality needs to be decided, implementations, unless documented otherwise, treat two colors as equal if all their red, green, blue, and alpha values each differ by at most `1e-5`. Example (Java): import com.google.type.Color; // ... public static java.awt.Color fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ? protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color( protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); \} public static Color toProto(java.awt.Color color) { float red = (float) color.getRed(); float green = (float) color.getGreen(); float blue = (float) color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder = Color .newBuilder() .setRed(red / denominator) .setGreen(green / denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if (alpha != 255) { result.setAlpha( FloatValue .newBuilder() .setValue(((float) alpha) / denominator) .build()); \} return resultBuilder.build(); \} // ... Example (iOS / Obj-C): // ... static UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float green = [protocolor green]; float blue = [protocolor blue]; FloatValue* alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper != nil) { alpha = [alpha_wrapper value]; \} return [UIColor colorWithRed:red green:green blue:blue alpha:alpha]; \} static Color* toProto(UIColor* color) { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green blue:&blue alpha:&alpha]) { return nil; \} Color* result = [[Color alloc] init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue]; if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; \} [result autorelease]; return result; \} // ... Example (JavaScript): // ... var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red || 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue || 0.0; var red = Math.floor(redFrac * 255); var green = Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if (!('alpha' in rgb_color)) { return rgbToCssColor(red, green, blue); \} var alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green, blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join(''); \}; var rgbToCssColor = function(red, green, blue) { var rgbNumber = new Number((red << 16) | (green << 8) | blue); var hexString = rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) { resultBuilder.push('0'); \} resultBuilder.push(hexString); return resultBuilder.join(''); \}; // ...
     */
    export interface Schema$GoogleTypeColor {
        /**
         * The fraction of this color that should be applied to the pixel. That is, the final pixel color is defined by the equation: `pixel color = alpha * (this color) + (1.0 - alpha) * (background color)` This means that a value of 1.0 corresponds to a solid color, whereas a value of 0.0 corresponds to a completely transparent color. This uses a wrapper message rather than a simple float scalar so that it is possible to distinguish between a default value and the value being unset. If omitted, this color object is rendered as a solid color (as if the alpha value had been explicitly given a value of 1.0).
         */
        alpha?: number | null;
        /**
         * The amount of blue in the color as a value in the interval [0, 1].
         */
        blue?: number | null;
        /**
         * The amount of green in the color as a value in the interval [0, 1].
         */
        green?: number | null;
        /**
         * The amount of red in the color as a value in the interval [0, 1].
         */
        red?: number | null;
    }
    /**
     * Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
     */
    export interface Schema$GoogleTypeDate {
        /**
         * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
         */
        day?: number | null;
        /**
         * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        month?: number | null;
        /**
         * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
         */
        year?: number | null;
    }
    /**
     * Represents civil time (or occasionally physical time). This type can represent a civil time in one of a few possible ways: * When utc_offset is set and time_zone is unset: a civil time on a calendar day with a particular offset from UTC. * When time_zone is set and utc_offset is unset: a civil time on a calendar day in a particular time zone. * When neither time_zone nor utc_offset is set: a civil time on a calendar day in local time. The date is relative to the Proleptic Gregorian Calendar. If year, month, or day are 0, the DateTime is considered not to have a specific year, month, or day respectively. This type may also be used to represent a physical time if all the date and time fields are set and either case of the `time_offset` oneof is set. Consider using `Timestamp` message for physical time instead. If your use case also would like to store the user's timezone, that can be done in another field. This type is more flexible than some applications may want. Make sure to document and validate your application's limitations.
     */
    export interface Schema$GoogleTypeDateTime {
        /**
         * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a datetime without a day.
         */
        day?: number | null;
        /**
         * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API may choose to allow the value "24:00:00" for scenarios like business closing time.
         */
        hours?: number | null;
        /**
         * Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
         */
        minutes?: number | null;
        /**
         * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
         */
        month?: number | null;
        /**
         * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
         */
        nanos?: number | null;
        /**
         * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may allow the value 60 if it allows leap-seconds.
         */
        seconds?: number | null;
        /**
         * Time zone.
         */
        timeZone?: Schema$GoogleTypeTimeZone;
        /**
         * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of -4:00 would be represented as { seconds: -14400 \}.
         */
        utcOffset?: string | null;
        /**
         * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
         */
        year?: number | null;
    }
    /**
     * Represents an amount of money with its currency type.
     */
    export interface Schema$GoogleTypeMoney {
        /**
         * The three-letter currency code defined in ISO 4217.
         */
        currencyCode?: string | null;
        /**
         * Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
         */
        nanos?: number | null;
        /**
         * The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
         */
        units?: string | null;
    }
    /**
     * Represents a postal address, such as for postal delivery or payments addresses. With a postal address, a postal service can deliver items to a premise, P.O. box, or similar. A postal address is not intended to model geographical locations like roads, towns, or mountains. In typical usage, an address would be created by user input or from importing existing data, depending on the type of process. Advice on address input or editing: - Use an internationalization-ready address widget such as https://github.com/google/libaddressinput. - Users should not be presented with UI elements for input or editing of fields outside countries where that field is used. For more guidance on how to use this schema, see: https://support.google.com/business/answer/6397478.
     */
    export interface Schema$GoogleTypePostalAddress {
        /**
         * Unstructured address lines describing the lower levels of an address. Because values in `address_lines` do not have type information and may sometimes contain multiple values in a single field (for example, "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country or region of the address. In places where this can vary (for example, Japan), `address_language` is used to make it explicit (for example, "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). In this way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a `region_code` with all remaining information placed in the `address_lines`. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a `region_code` and `address_lines` and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
         */
        addressLines?: string[] | null;
        /**
         * Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. For Spain, this is the province and not the autonomous community (for example, "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. For example, in Switzerland, this should be left unpopulated.
         */
        administrativeArea?: string | null;
        /**
         * Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
         */
        languageCode?: string | null;
        /**
         * Optional. Generally refers to the city or town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave `locality` empty and use `address_lines`.
         */
        locality?: string | null;
        /**
         * Optional. The name of the organization at the address.
         */
        organization?: string | null;
        /**
         * Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (for example, state or zip code validation in the United States).
         */
        postalCode?: string | null;
        /**
         * Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
         */
        recipients?: string[] | null;
        /**
         * Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See https://cldr.unicode.org/ and https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
         */
        regionCode?: string | null;
        /**
         * The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
         */
        revision?: number | null;
        /**
         * Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (for example, "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (Côte d'Ivoire).
         */
        sortingCode?: string | null;
        /**
         * Optional. Sublocality of the address. For example, this can be a neighborhood, borough, or district.
         */
        sublocality?: string | null;
    }
    /**
     * Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
     */
    export interface Schema$GoogleTypeTimeZone {
        /**
         * IANA Time Zone Database time zone. For example "America/New_York".
         */
        id?: string | null;
        /**
         * Optional. IANA Time Zone Database version number. For example "2019a".
         */
        version?: string | null;
    }
    export class Resource$Projects {
        context: APIRequestContext;
        locations: Resource$Projects$Locations;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Locations {
        context: APIRequestContext;
        operations: Resource$Projects$Locations$Operations;
        processors: Resource$Projects$Locations$Processors;
        processorTypes: Resource$Projects$Locations$Processortypes;
        schemas: Resource$Projects$Locations$Schemas;
        constructor(context: APIRequestContext);
        /**
         * Fetches processor types. Note that we don't use ListProcessorTypes here, because it isn't paginated.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.fetchProcessorTypes({
         *     // Required. The location of processor types to list. Format: `projects/{project\}/locations/{location\}`.
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "processorTypes": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        fetchProcessorTypes(params: Params$Resource$Projects$Locations$Fetchprocessortypes, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        fetchProcessorTypes(params?: Params$Resource$Projects$Locations$Fetchprocessortypes, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse>>;
        fetchProcessorTypes(params: Params$Resource$Projects$Locations$Fetchprocessortypes, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        fetchProcessorTypes(params: Params$Resource$Projects$Locations$Fetchprocessortypes, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse>): void;
        fetchProcessorTypes(params: Params$Resource$Projects$Locations$Fetchprocessortypes, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse>): void;
        fetchProcessorTypes(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3FetchProcessorTypesResponse>): void;
        /**
         * Gets information about a location.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.get({
         *     // Resource name for the location.
         *     name: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "labels": {},
         *   //   "locationId": "my_locationId",
         *   //   "metadata": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudLocationLocation>>;
        get(params: Params$Resource$Projects$Locations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudLocationLocation>, callback: BodyResponseCallback<Schema$GoogleCloudLocationLocation>): void;
        get(params: Params$Resource$Projects$Locations$Get, callback: BodyResponseCallback<Schema$GoogleCloudLocationLocation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudLocationLocation>): void;
        /**
         * Lists information about the supported locations for this service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.list({
         *     // Optional. Do not use this field. It is unsupported and is ignored unless explicitly documented otherwise. This is primarily for internal usage.
         *     extraLocationTypes: 'placeholder-value',
         *     // A filter to narrow down results to a preferred subset. The filtering language accepts strings like `"displayName=tokyo"`, and is documented in more detail in [AIP-160](https://google.aip.dev/160).
         *     filter: 'placeholder-value',
         *     // The resource that owns the locations collection, if applicable.
         *     name: 'projects/my-project',
         *     // The maximum number of results to return. If not set, the service selects a default.
         *     pageSize: 'placeholder-value',
         *     // A page token received from the `next_page_token` field in the response. Send that page token to receive the subsequent page.
         *     pageToken: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "locations": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudLocationListLocationsResponse>>;
        list(params: Params$Resource$Projects$Locations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudLocationListLocationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudLocationListLocationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$List, callback: BodyResponseCallback<Schema$GoogleCloudLocationListLocationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudLocationListLocationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Fetchprocessortypes extends StandardParameters {
        /**
         * Required. The location of processor types to list. Format: `projects/{project\}/locations/{location\}`.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Get extends StandardParameters {
        /**
         * Resource name for the location.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$List extends StandardParameters {
        /**
         * Optional. Do not use this field. It is unsupported and is ignored unless explicitly documented otherwise. This is primarily for internal usage.
         */
        extraLocationTypes?: string[];
        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts strings like `"displayName=tokyo"`, and is documented in more detail in [AIP-160](https://google.aip.dev/160).
         */
        filter?: string;
        /**
         * The resource that owns the locations collection, if applicable.
         */
        name?: string;
        /**
         * The maximum number of results to return. If not set, the service selects a default.
         */
        pageSize?: number;
        /**
         * A page token received from the `next_page_token` field in the response. Send that page token to receive the subsequent page.
         */
        pageToken?: string;
    }
    export class Resource$Projects$Locations$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.operations.cancel({
         *     // The name of the operation resource to be cancelled.
         *     name: 'projects/my-project/locations/my-location/operations/my-operation',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        cancel(params: Params$Resource$Projects$Locations$Operations$Cancel, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        cancel(params?: Params$Resource$Projects$Locations$Operations$Cancel, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        cancel(params: Params$Resource$Projects$Locations$Operations$Cancel, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        cancel(params: Params$Resource$Projects$Locations$Operations$Cancel, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        cancel(params: Params$Resource$Projects$Locations$Operations$Cancel, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        cancel(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.operations.get({
         *     // The name of the operation resource.
         *     name: 'projects/my-project/locations/my-location/operations/my-operation',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Operations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Operations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        get(params: Params$Resource$Projects$Locations$Operations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(params: Params$Resource$Projects$Locations$Operations$Get, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.operations.list({
         *     // The standard list filter.
         *     filter: 'placeholder-value',
         *     // The name of the operation's parent resource.
         *     name: 'projects/my-project/locations/my-location/operations',
         *     // The standard list page size.
         *     pageSize: 'placeholder-value',
         *     // The standard list page token.
         *     pageToken: 'placeholder-value',
         *     // When set to `true`, operations that are reachable are returned as normal, and those that are unreachable are returned in the ListOperationsResponse.unreachable field. This can only be `true` when reading across collections. For example, when `parent` is set to `"projects/example/locations/-"`. This field is not supported by default and will result in an `UNIMPLEMENTED` error if set unless explicitly documented otherwise in service or product specific documentation.
         *     returnPartialSuccess: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "operations": [],
         *   //   "unreachable": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Operations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Operations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningListOperationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Operations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Operations$List, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Operations$Cancel extends StandardParameters {
        /**
         * The name of the operation resource to be cancelled.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Operations$Get extends StandardParameters {
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Operations$List extends StandardParameters {
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
        /**
         * When set to `true`, operations that are reachable are returned as normal, and those that are unreachable are returned in the ListOperationsResponse.unreachable field. This can only be `true` when reading across collections. For example, when `parent` is set to `"projects/example/locations/-"`. This field is not supported by default and will result in an `UNIMPLEMENTED` error if set unless explicitly documented otherwise in service or product specific documentation.
         */
        returnPartialSuccess?: boolean;
    }
    export class Resource$Projects$Locations$Processors {
        context: APIRequestContext;
        dataset: Resource$Projects$Locations$Processors$Dataset;
        humanReviewConfig: Resource$Projects$Locations$Processors$Humanreviewconfig;
        processorVersions: Resource$Projects$Locations$Processors$Processorversions;
        constructor(context: APIRequestContext);
        /**
         * LRO endpoint to batch process many documents. The output is written to Cloud Storage as JSON in the [Document] format.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.batchProcess({
         *     // Required. The resource name of Processor or ProcessorVersion. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`, or `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         *     name: 'projects/my-project/locations/my-location/processors/my-processor',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "documentOutputConfig": {},
         *       //   "inputConfigs": [],
         *       //   "inputDocuments": {},
         *       //   "labels": {},
         *       //   "outputConfig": {},
         *       //   "processOptions": {},
         *       //   "skipHumanReview": false
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchProcess(params: Params$Resource$Projects$Locations$Processors$Batchprocess, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchProcess(params?: Params$Resource$Projects$Locations$Processors$Batchprocess, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchProcess(params: Params$Resource$Projects$Locations$Processors$Batchprocess, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchProcess(params: Params$Resource$Projects$Locations$Processors$Batchprocess, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchProcess(params: Params$Resource$Projects$Locations$Processors$Batchprocess, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchProcess(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Creates a processor from the ProcessorType provided. The processor will be at `ENABLED` state by default after its creation. Note that this method requires the `documentai.processors.create` permission on the project, which is highly privileged. A user or service account with this permission can create new processors that can interact with any gcs bucket in your project.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.create({
         *     // Required. The parent (project and location) under which to create the processor. Format: `projects/{project\}/locations/{location\}`
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "activeSchemaVersion": "my_activeSchemaVersion",
         *       //   "createTime": "my_createTime",
         *       //   "defaultProcessorVersion": "my_defaultProcessorVersion",
         *       //   "displayName": "my_displayName",
         *       //   "kmsKeyName": "my_kmsKeyName",
         *       //   "name": "my_name",
         *       //   "processEndpoint": "my_processEndpoint",
         *       //   "processorVersionAliases": [],
         *       //   "satisfiesPzi": false,
         *       //   "satisfiesPzs": false,
         *       //   "state": "my_state",
         *       //   "type": "my_type"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "activeSchemaVersion": "my_activeSchemaVersion",
         *   //   "createTime": "my_createTime",
         *   //   "defaultProcessorVersion": "my_defaultProcessorVersion",
         *   //   "displayName": "my_displayName",
         *   //   "kmsKeyName": "my_kmsKeyName",
         *   //   "name": "my_name",
         *   //   "processEndpoint": "my_processEndpoint",
         *   //   "processorVersionAliases": [],
         *   //   "satisfiesPzi": false,
         *   //   "satisfiesPzs": false,
         *   //   "state": "my_state",
         *   //   "type": "my_type"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Processors$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Processors$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3Processor>>;
        create(params: Params$Resource$Projects$Locations$Processors$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Processors$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Processor>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Processor>): void;
        create(params: Params$Resource$Projects$Locations$Processors$Create, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Processor>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Processor>): void;
        /**
         * Deletes the processor, unloads all deployed model artifacts if it was enabled and then deletes all artifacts associated with this processor.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.delete({
         *     // Required. The processor resource name to be deleted.
         *     name: 'projects/my-project/locations/my-location/processors/my-processor',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Processors$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Processors$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Locations$Processors$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Processors$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Locations$Processors$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Disables a processor
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.disable({
         *     // Required. The processor resource name to be disabled.
         *     name: 'projects/my-project/locations/my-location/processors/my-processor',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        disable(params: Params$Resource$Projects$Locations$Processors$Disable, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        disable(params?: Params$Resource$Projects$Locations$Processors$Disable, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        disable(params: Params$Resource$Projects$Locations$Processors$Disable, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        disable(params: Params$Resource$Projects$Locations$Processors$Disable, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        disable(params: Params$Resource$Projects$Locations$Processors$Disable, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        disable(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Enables a processor
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.enable({
         *     // Required. The processor resource name to be enabled.
         *     name: 'projects/my-project/locations/my-location/processors/my-processor',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        enable(params: Params$Resource$Projects$Locations$Processors$Enable, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        enable(params?: Params$Resource$Projects$Locations$Processors$Enable, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        enable(params: Params$Resource$Projects$Locations$Processors$Enable, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        enable(params: Params$Resource$Projects$Locations$Processors$Enable, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        enable(params: Params$Resource$Projects$Locations$Processors$Enable, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        enable(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a processor detail.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.get({
         *     // Required. The processor resource name.
         *     name: 'projects/my-project/locations/my-location/processors/my-processor',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "activeSchemaVersion": "my_activeSchemaVersion",
         *   //   "createTime": "my_createTime",
         *   //   "defaultProcessorVersion": "my_defaultProcessorVersion",
         *   //   "displayName": "my_displayName",
         *   //   "kmsKeyName": "my_kmsKeyName",
         *   //   "name": "my_name",
         *   //   "processEndpoint": "my_processEndpoint",
         *   //   "processorVersionAliases": [],
         *   //   "satisfiesPzi": false,
         *   //   "satisfiesPzs": false,
         *   //   "state": "my_state",
         *   //   "type": "my_type"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Processors$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Processors$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3Processor>>;
        get(params: Params$Resource$Projects$Locations$Processors$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Processors$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Processor>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Processor>): void;
        get(params: Params$Resource$Projects$Locations$Processors$Get, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Processor>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Processor>): void;
        /**
         * Lists all processors which belong to this project.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.list({
         *     // The maximum number of processors to return. If unspecified, at most `50` processors will be returned. The maximum value is `100`. Values above `100` will be coerced to `100`.
         *     pageSize: 'placeholder-value',
         *     // We will return the processors sorted by creation time. The page token will point to the next processor.
         *     pageToken: 'placeholder-value',
         *     // Required. The parent (project and location) which owns this collection of Processors. Format: `projects/{project\}/locations/{location\}`
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "processors": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Processors$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Processors$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ListProcessorsResponse>>;
        list(params: Params$Resource$Projects$Locations$Processors$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Processors$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Processors$List, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorsResponse>): void;
        /**
         * Processes a single document.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.process({
         *     // Required. The resource name of the Processor or ProcessorVersion to use for processing. If a Processor is specified, the server will use its default version. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`, or `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         *     name: 'projects/my-project/locations/my-location/processors/my-processor',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "document": {},
         *       //   "fieldMask": "my_fieldMask",
         *       //   "gcsDocument": {},
         *       //   "imagelessMode": false,
         *       //   "inlineDocument": {},
         *       //   "labels": {},
         *       //   "processOptions": {},
         *       //   "rawDocument": {},
         *       //   "skipHumanReview": false
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "document": {},
         *   //   "humanReviewOperation": "my_humanReviewOperation",
         *   //   "humanReviewStatus": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        process(params: Params$Resource$Projects$Locations$Processors$Process, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        process(params?: Params$Resource$Projects$Locations$Processors$Process, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>>;
        process(params: Params$Resource$Projects$Locations$Processors$Process, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        process(params: Params$Resource$Projects$Locations$Processors$Process, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>): void;
        process(params: Params$Resource$Projects$Locations$Processors$Process, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>): void;
        process(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>): void;
        /**
         * Set the default (active) version of a Processor that will be used in ProcessDocument and BatchProcessDocuments.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.setDefaultProcessorVersion({
         *       // Required. The resource name of the Processor to change default version.
         *       processor:
         *         'projects/my-project/locations/my-location/processors/my-processor',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "defaultProcessorVersion": "my_defaultProcessorVersion"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        setDefaultProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Setdefaultprocessorversion, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        setDefaultProcessorVersion(params?: Params$Resource$Projects$Locations$Processors$Setdefaultprocessorversion, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        setDefaultProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Setdefaultprocessorversion, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        setDefaultProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Setdefaultprocessorversion, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        setDefaultProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Setdefaultprocessorversion, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        setDefaultProcessorVersion(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Updates metadata associated with a dataset. Note that this method requires the `documentai.googleapis.com/datasets.update` permission on the project, which is highly privileged. A user or service account with this permission can create new processors that can interact with any gcs bucket in your project.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processors.updateDataset({
         *     // Dataset resource name. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/dataset`
         *     name: 'projects/my-project/locations/my-location/processors/my-processor/dataset',
         *     // The update mask applies to the resource.
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "documentWarehouseConfig": {},
         *       //   "gcsManagedConfig": {},
         *       //   "name": "my_name",
         *       //   "satisfiesPzi": false,
         *       //   "satisfiesPzs": false,
         *       //   "spannerIndexingConfig": {},
         *       //   "state": "my_state",
         *       //   "unmanagedDatasetConfig": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        updateDataset(params: Params$Resource$Projects$Locations$Processors$Updatedataset, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        updateDataset(params?: Params$Resource$Projects$Locations$Processors$Updatedataset, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        updateDataset(params: Params$Resource$Projects$Locations$Processors$Updatedataset, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        updateDataset(params: Params$Resource$Projects$Locations$Processors$Updatedataset, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        updateDataset(params: Params$Resource$Projects$Locations$Processors$Updatedataset, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        updateDataset(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Processors$Batchprocess extends StandardParameters {
        /**
         * Required. The resource name of Processor or ProcessorVersion. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`, or `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3BatchProcessRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Create extends StandardParameters {
        /**
         * Required. The parent (project and location) under which to create the processor. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3Processor;
    }
    export interface Params$Resource$Projects$Locations$Processors$Delete extends StandardParameters {
        /**
         * Required. The processor resource name to be deleted.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Processors$Disable extends StandardParameters {
        /**
         * Required. The processor resource name to be disabled.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3DisableProcessorRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Enable extends StandardParameters {
        /**
         * Required. The processor resource name to be enabled.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3EnableProcessorRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Get extends StandardParameters {
        /**
         * Required. The processor resource name.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Processors$List extends StandardParameters {
        /**
         * The maximum number of processors to return. If unspecified, at most `50` processors will be returned. The maximum value is `100`. Values above `100` will be coerced to `100`.
         */
        pageSize?: number;
        /**
         * We will return the processors sorted by creation time. The page token will point to the next processor.
         */
        pageToken?: string;
        /**
         * Required. The parent (project and location) which owns this collection of Processors. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Processors$Process extends StandardParameters {
        /**
         * Required. The resource name of the Processor or ProcessorVersion to use for processing. If a Processor is specified, the server will use its default version. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`, or `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3ProcessRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Setdefaultprocessorversion extends StandardParameters {
        /**
         * Required. The resource name of the Processor to change default version.
         */
        processor?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3SetDefaultProcessorVersionRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Updatedataset extends StandardParameters {
        /**
         * Dataset resource name. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/dataset`
         */
        name?: string;
        /**
         * The update mask applies to the resource.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3Dataset;
    }
    export class Resource$Projects$Locations$Processors$Dataset {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Deletes a set of documents.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.dataset.batchDeleteDocuments(
         *       {
         *         // Required. The dataset resource name. Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset
         *         dataset:
         *           'projects/my-project/locations/my-location/processors/my-processor/dataset',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "datasetDocuments": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchDeleteDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Batchdeletedocuments, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchDeleteDocuments(params?: Params$Resource$Projects$Locations$Processors$Dataset$Batchdeletedocuments, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchDeleteDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Batchdeletedocuments, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchDeleteDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Batchdeletedocuments, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDeleteDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Batchdeletedocuments, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDeleteDocuments(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets the `DatasetSchema` of a `Dataset`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.dataset.getDatasetSchema({
         *       // Required. The dataset schema resource name. Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset/datasetSchema
         *       name: 'projects/my-project/locations/my-location/processors/my-processor/dataset/datasetSchema',
         *       // If set, only returns the visible fields of the schema.
         *       visibleFieldsOnly: 'placeholder-value',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "documentSchema": {},
         *   //   "name": "my_name",
         *   //   "satisfiesPzi": false,
         *   //   "satisfiesPzs": false
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getDatasetSchema(params: Params$Resource$Projects$Locations$Processors$Dataset$Getdatasetschema, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getDatasetSchema(params?: Params$Resource$Projects$Locations$Processors$Dataset$Getdatasetschema, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>>;
        getDatasetSchema(params: Params$Resource$Projects$Locations$Processors$Dataset$Getdatasetschema, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getDatasetSchema(params: Params$Resource$Projects$Locations$Processors$Dataset$Getdatasetschema, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>): void;
        getDatasetSchema(params: Params$Resource$Projects$Locations$Processors$Dataset$Getdatasetschema, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>): void;
        getDatasetSchema(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>): void;
        /**
         * Returns relevant fields present in the requested document.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.dataset.getDocument({
         *       // Required. The resource name of the dataset that the document belongs to . Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset
         *       dataset:
         *         'projects/my-project/locations/my-location/processors/my-processor/dataset',
         *       // Id of the document (indexed) managed by Content Warehouse.
         *       'documentId.gcsManagedDocId.cwDocId': 'placeholder-value',
         *       // Required. The Cloud Storage URI where the actual document is stored.
         *       'documentId.gcsManagedDocId.gcsUri': 'placeholder-value',
         *       // Reads the revision generated by the processor version. The format takes the full resource name of processor version. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         *       'documentId.revisionRef.latestProcessorVersion': 'placeholder-value',
         *       // Reads the revision by the predefined case.
         *       'documentId.revisionRef.revisionCase': 'placeholder-value',
         *       // Reads the revision given by the id.
         *       'documentId.revisionRef.revisionId': 'placeholder-value',
         *       // Required. The id of the document.
         *       'documentId.unmanagedDocId.docId': 'placeholder-value',
         *       // Last page number (one-based index) to be returned.
         *       'pageRange.end': 'placeholder-value',
         *       // First page number (one-based index) to be returned.
         *       'pageRange.start': 'placeholder-value',
         *       // If set, only fields listed here will be returned. Otherwise, all fields will be returned by default.
         *       readMask: 'placeholder-value',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "document": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getDocument(params: Params$Resource$Projects$Locations$Processors$Dataset$Getdocument, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getDocument(params?: Params$Resource$Projects$Locations$Processors$Dataset$Getdocument, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3GetDocumentResponse>>;
        getDocument(params: Params$Resource$Projects$Locations$Processors$Dataset$Getdocument, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getDocument(params: Params$Resource$Projects$Locations$Processors$Dataset$Getdocument, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3GetDocumentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3GetDocumentResponse>): void;
        getDocument(params: Params$Resource$Projects$Locations$Processors$Dataset$Getdocument, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3GetDocumentResponse>): void;
        getDocument(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3GetDocumentResponse>): void;
        /**
         * Import documents into a dataset.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.dataset.importDocuments({
         *       // Required. The dataset resource name. Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset
         *       dataset:
         *         'projects/my-project/locations/my-location/processors/my-processor/dataset',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "batchDocumentsImportConfigs": []
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        importDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Importdocuments, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        importDocuments(params?: Params$Resource$Projects$Locations$Processors$Dataset$Importdocuments, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        importDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Importdocuments, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        importDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Importdocuments, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        importDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Importdocuments, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        importDocuments(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Returns a list of documents present in the dataset.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.dataset.listDocuments({
         *       // Required. The resource name of the dataset to be listed. Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset
         *       dataset:
         *         'projects/my-project/locations/my-location/processors/my-processor/dataset',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "filter": "my_filter",
         *         //   "pageSize": 0,
         *         //   "pageToken": "my_pageToken",
         *         //   "returnTotalSize": false,
         *         //   "skip": 0
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "documentMetadata": [],
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "totalSize": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        listDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Listdocuments, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        listDocuments(params?: Params$Resource$Projects$Locations$Processors$Dataset$Listdocuments, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ListDocumentsResponse>>;
        listDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Listdocuments, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        listDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Listdocuments, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListDocumentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListDocumentsResponse>): void;
        listDocuments(params: Params$Resource$Projects$Locations$Processors$Dataset$Listdocuments, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListDocumentsResponse>): void;
        listDocuments(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListDocumentsResponse>): void;
        /**
         * Updates a `DatasetSchema`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.dataset.updateDatasetSchema({
         *       // Dataset schema resource name. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/dataset/datasetSchema`
         *       name: 'projects/my-project/locations/my-location/processors/my-processor/dataset/datasetSchema',
         *       // The update mask applies to the resource.
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "documentSchema": {},
         *         //   "name": "my_name",
         *         //   "satisfiesPzi": false,
         *         //   "satisfiesPzs": false
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "documentSchema": {},
         *   //   "name": "my_name",
         *   //   "satisfiesPzi": false,
         *   //   "satisfiesPzs": false
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        updateDatasetSchema(params: Params$Resource$Projects$Locations$Processors$Dataset$Updatedatasetschema, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        updateDatasetSchema(params?: Params$Resource$Projects$Locations$Processors$Dataset$Updatedatasetschema, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>>;
        updateDatasetSchema(params: Params$Resource$Projects$Locations$Processors$Dataset$Updatedatasetschema, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        updateDatasetSchema(params: Params$Resource$Projects$Locations$Processors$Dataset$Updatedatasetschema, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>): void;
        updateDatasetSchema(params: Params$Resource$Projects$Locations$Processors$Dataset$Updatedatasetschema, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>): void;
        updateDatasetSchema(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3DatasetSchema>): void;
    }
    export interface Params$Resource$Projects$Locations$Processors$Dataset$Batchdeletedocuments extends StandardParameters {
        /**
         * Required. The dataset resource name. Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset
         */
        dataset?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3BatchDeleteDocumentsRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Dataset$Getdatasetschema extends StandardParameters {
        /**
         * Required. The dataset schema resource name. Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset/datasetSchema
         */
        name?: string;
        /**
         * If set, only returns the visible fields of the schema.
         */
        visibleFieldsOnly?: boolean;
    }
    export interface Params$Resource$Projects$Locations$Processors$Dataset$Getdocument extends StandardParameters {
        /**
         * Required. The resource name of the dataset that the document belongs to . Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset
         */
        dataset?: string;
        /**
         * Id of the document (indexed) managed by Content Warehouse.
         */
        'documentId.gcsManagedDocId.cwDocId'?: string;
        /**
         * Required. The Cloud Storage URI where the actual document is stored.
         */
        'documentId.gcsManagedDocId.gcsUri'?: string;
        /**
         * Reads the revision generated by the processor version. The format takes the full resource name of processor version. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        'documentId.revisionRef.latestProcessorVersion'?: string;
        /**
         * Reads the revision by the predefined case.
         */
        'documentId.revisionRef.revisionCase'?: string;
        /**
         * Reads the revision given by the id.
         */
        'documentId.revisionRef.revisionId'?: string;
        /**
         * Required. The id of the document.
         */
        'documentId.unmanagedDocId.docId'?: string;
        /**
         * Last page number (one-based index) to be returned.
         */
        'pageRange.end'?: number;
        /**
         * First page number (one-based index) to be returned.
         */
        'pageRange.start'?: number;
        /**
         * If set, only fields listed here will be returned. Otherwise, all fields will be returned by default.
         */
        readMask?: string;
    }
    export interface Params$Resource$Projects$Locations$Processors$Dataset$Importdocuments extends StandardParameters {
        /**
         * Required. The dataset resource name. Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset
         */
        dataset?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3ImportDocumentsRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Dataset$Listdocuments extends StandardParameters {
        /**
         * Required. The resource name of the dataset to be listed. Format: projects/{project\}/locations/{location\}/processors/{processor\}/dataset
         */
        dataset?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3ListDocumentsRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Dataset$Updatedatasetschema extends StandardParameters {
        /**
         * Dataset schema resource name. Format: `projects/{project\}/locations/{location\}/processors/{processor\}/dataset/datasetSchema`
         */
        name?: string;
        /**
         * The update mask applies to the resource.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3DatasetSchema;
    }
    export class Resource$Projects$Locations$Processors$Humanreviewconfig {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Send a document for Human Review. The input document should be processed by the specified processor.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.humanReviewConfig.reviewDocument(
         *       {
         *         // Required. The resource name of the HumanReviewConfig that the document will be reviewed with.
         *         humanReviewConfig:
         *           'projects/my-project/locations/my-location/processors/my-processor/humanReviewConfig',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "document": {},
         *           //   "documentSchema": {},
         *           //   "enableSchemaValidation": false,
         *           //   "inlineDocument": {},
         *           //   "priority": "my_priority"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        reviewDocument(params: Params$Resource$Projects$Locations$Processors$Humanreviewconfig$Reviewdocument, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        reviewDocument(params?: Params$Resource$Projects$Locations$Processors$Humanreviewconfig$Reviewdocument, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        reviewDocument(params: Params$Resource$Projects$Locations$Processors$Humanreviewconfig$Reviewdocument, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        reviewDocument(params: Params$Resource$Projects$Locations$Processors$Humanreviewconfig$Reviewdocument, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        reviewDocument(params: Params$Resource$Projects$Locations$Processors$Humanreviewconfig$Reviewdocument, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        reviewDocument(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Processors$Humanreviewconfig$Reviewdocument extends StandardParameters {
        /**
         * Required. The resource name of the HumanReviewConfig that the document will be reviewed with.
         */
        humanReviewConfig?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3ReviewDocumentRequest;
    }
    export class Resource$Projects$Locations$Processors$Processorversions {
        context: APIRequestContext;
        evaluations: Resource$Projects$Locations$Processors$Processorversions$Evaluations;
        constructor(context: APIRequestContext);
        /**
         * LRO endpoint to batch process many documents. The output is written to Cloud Storage as JSON in the [Document] format.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.batchProcess(
         *       {
         *         // Required. The resource name of Processor or ProcessorVersion. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`, or `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         *         name: 'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "documentOutputConfig": {},
         *           //   "inputConfigs": [],
         *           //   "inputDocuments": {},
         *           //   "labels": {},
         *           //   "outputConfig": {},
         *           //   "processOptions": {},
         *           //   "skipHumanReview": false
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchProcess(params: Params$Resource$Projects$Locations$Processors$Processorversions$Batchprocess, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchProcess(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Batchprocess, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchProcess(params: Params$Resource$Projects$Locations$Processors$Processorversions$Batchprocess, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchProcess(params: Params$Resource$Projects$Locations$Processors$Processorversions$Batchprocess, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchProcess(params: Params$Resource$Projects$Locations$Processors$Processorversions$Batchprocess, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchProcess(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Deletes the processor version, all artifacts under the processor version will be deleted.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.delete({
         *       // Required. The processor version resource name to be deleted.
         *       name: 'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Processors$Processorversions$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Locations$Processors$Processorversions$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Processors$Processorversions$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Locations$Processors$Processorversions$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Deploys the processor version.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.deploy({
         *       // Required. The processor version resource name to be deployed.
         *       name: 'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {}
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        deploy(params: Params$Resource$Projects$Locations$Processors$Processorversions$Deploy, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        deploy(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Deploy, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        deploy(params: Params$Resource$Projects$Locations$Processors$Processorversions$Deploy, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        deploy(params: Params$Resource$Projects$Locations$Processors$Processorversions$Deploy, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        deploy(params: Params$Resource$Projects$Locations$Processors$Processorversions$Deploy, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        deploy(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Evaluates a ProcessorVersion against annotated documents, producing an Evaluation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.evaluateProcessorVersion(
         *       {
         *         // Required. The resource name of the ProcessorVersion to evaluate. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         *         processorVersion:
         *           'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "evaluationDocuments": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        evaluateProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluateprocessorversion, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        evaluateProcessorVersion(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluateprocessorversion, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        evaluateProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluateprocessorversion, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        evaluateProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluateprocessorversion, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        evaluateProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluateprocessorversion, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        evaluateProcessorVersion(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a processor version detail.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.get({
         *       // Required. The processor resource name.
         *       name: 'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "deprecationInfo": {},
         *   //   "displayName": "my_displayName",
         *   //   "documentSchema": {},
         *   //   "genAiModelInfo": {},
         *   //   "googleManaged": false,
         *   //   "kmsKeyName": "my_kmsKeyName",
         *   //   "kmsKeyVersionName": "my_kmsKeyVersionName",
         *   //   "latestEvaluation": {},
         *   //   "modelType": "my_modelType",
         *   //   "name": "my_name",
         *   //   "satisfiesPzi": false,
         *   //   "satisfiesPzs": false,
         *   //   "state": "my_state"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Processors$Processorversions$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ProcessorVersion>>;
        get(params: Params$Resource$Projects$Locations$Processors$Processorversions$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Processors$Processorversions$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessorVersion>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessorVersion>): void;
        get(params: Params$Resource$Projects$Locations$Processors$Processorversions$Get, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessorVersion>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessorVersion>): void;
        /**
         * Imports a processor version from source processor version.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.importProcessorVersion(
         *       {
         *         // Required. The destination processor name to create the processor version in. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`
         *         parent:
         *           'projects/my-project/locations/my-location/processors/my-processor',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "externalProcessorVersionSource": {},
         *           //   "processorVersionSource": "my_processorVersionSource"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        importProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Processorversions$Importprocessorversion, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        importProcessorVersion(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Importprocessorversion, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        importProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Processorversions$Importprocessorversion, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        importProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Processorversions$Importprocessorversion, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        importProcessorVersion(params: Params$Resource$Projects$Locations$Processors$Processorversions$Importprocessorversion, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        importProcessorVersion(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists all versions of a processor.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.list({
         *       // The maximum number of processor versions to return. If unspecified, at most `10` processor versions will be returned. The maximum value is `20`. Values above `20` will be coerced to `20`.
         *       pageSize: 'placeholder-value',
         *       // We will return the processor versions sorted by creation time. The page token will point to the next processor version.
         *       pageToken: 'placeholder-value',
         *       // Required. The parent (project, location and processor) to list all versions. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`
         *       parent:
         *         'projects/my-project/locations/my-location/processors/my-processor',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "processorVersions": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Processors$Processorversions$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Processors$Processorversions$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse>>;
        list(params: Params$Resource$Projects$Locations$Processors$Processorversions$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Processors$Processorversions$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Processors$Processorversions$List, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorVersionsResponse>): void;
        /**
         * Processes a single document.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.process({
         *       // Required. The resource name of the Processor or ProcessorVersion to use for processing. If a Processor is specified, the server will use its default version. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`, or `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         *       name: 'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "document": {},
         *         //   "fieldMask": "my_fieldMask",
         *         //   "gcsDocument": {},
         *         //   "imagelessMode": false,
         *         //   "inlineDocument": {},
         *         //   "labels": {},
         *         //   "processOptions": {},
         *         //   "rawDocument": {},
         *         //   "skipHumanReview": false
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "document": {},
         *   //   "humanReviewOperation": "my_humanReviewOperation",
         *   //   "humanReviewStatus": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        process(params: Params$Resource$Projects$Locations$Processors$Processorversions$Process, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        process(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Process, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>>;
        process(params: Params$Resource$Projects$Locations$Processors$Processorversions$Process, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        process(params: Params$Resource$Projects$Locations$Processors$Processorversions$Process, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>): void;
        process(params: Params$Resource$Projects$Locations$Processors$Processorversions$Process, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>): void;
        process(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessResponse>): void;
        /**
         * Trains a new processor version. Operation metadata is returned as TrainProcessorVersionMetadata.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.train({
         *       // Required. The parent (project, location and processor) to create the new version for. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`.
         *       parent:
         *         'projects/my-project/locations/my-location/processors/my-processor',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "baseProcessorVersion": "my_baseProcessorVersion",
         *         //   "customDocumentExtractionOptions": {},
         *         //   "documentSchema": {},
         *         //   "foundationModelTuningOptions": {},
         *         //   "inputData": {},
         *         //   "processorVersion": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        train(params: Params$Resource$Projects$Locations$Processors$Processorversions$Train, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        train(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Train, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        train(params: Params$Resource$Projects$Locations$Processors$Processorversions$Train, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        train(params: Params$Resource$Projects$Locations$Processors$Processorversions$Train, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        train(params: Params$Resource$Projects$Locations$Processors$Processorversions$Train, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        train(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Undeploys the processor version.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.undeploy({
         *       // Required. The processor version resource name to be undeployed.
         *       name: 'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {}
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        undeploy(params: Params$Resource$Projects$Locations$Processors$Processorversions$Undeploy, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        undeploy(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Undeploy, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        undeploy(params: Params$Resource$Projects$Locations$Processors$Processorversions$Undeploy, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        undeploy(params: Params$Resource$Projects$Locations$Processors$Processorversions$Undeploy, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        undeploy(params: Params$Resource$Projects$Locations$Processors$Processorversions$Undeploy, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        undeploy(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Batchprocess extends StandardParameters {
        /**
         * Required. The resource name of Processor or ProcessorVersion. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`, or `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3BatchProcessRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Delete extends StandardParameters {
        /**
         * Required. The processor version resource name to be deleted.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Deploy extends StandardParameters {
        /**
         * Required. The processor version resource name to be deployed.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3DeployProcessorVersionRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Evaluateprocessorversion extends StandardParameters {
        /**
         * Required. The resource name of the ProcessorVersion to evaluate. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        processorVersion?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3EvaluateProcessorVersionRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Get extends StandardParameters {
        /**
         * Required. The processor resource name.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Importprocessorversion extends StandardParameters {
        /**
         * Required. The destination processor name to create the processor version in. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3ImportProcessorVersionRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$List extends StandardParameters {
        /**
         * The maximum number of processor versions to return. If unspecified, at most `10` processor versions will be returned. The maximum value is `20`. Values above `20` will be coerced to `20`.
         */
        pageSize?: number;
        /**
         * We will return the processor versions sorted by creation time. The page token will point to the next processor version.
         */
        pageToken?: string;
        /**
         * Required. The parent (project, location and processor) to list all versions. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Process extends StandardParameters {
        /**
         * Required. The resource name of the Processor or ProcessorVersion to use for processing. If a Processor is specified, the server will use its default version. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`, or `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3ProcessRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Train extends StandardParameters {
        /**
         * Required. The parent (project, location and processor) to create the new version for. Format: `projects/{project\}/locations/{location\}/processors/{processor\}`.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3TrainProcessorVersionRequest;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Undeploy extends StandardParameters {
        /**
         * Required. The processor version resource name to be undeployed.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3UndeployProcessorVersionRequest;
    }
    export class Resource$Projects$Locations$Processors$Processorversions$Evaluations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Retrieves a specific evaluation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.evaluations.get(
         *       {
         *         // Required. The resource name of the Evaluation to get. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}/evaluations/{evaluation\}`
         *         name: 'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion/evaluations/my-evaluation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "allEntitiesMetrics": {},
         *   //   "createTime": "my_createTime",
         *   //   "documentCounters": {},
         *   //   "entityMetrics": {},
         *   //   "kmsKeyName": "my_kmsKeyName",
         *   //   "kmsKeyVersionName": "my_kmsKeyVersionName",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3Evaluation>>;
        get(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Evaluation>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Evaluation>): void;
        get(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$Get, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Evaluation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3Evaluation>): void;
        /**
         * Retrieves a set of evaluations for a given processor version.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.processors.processorVersions.evaluations.list(
         *       {
         *         // The standard list page size. If unspecified, at most `5` evaluations are returned. The maximum value is `100`. Values above `100` are coerced to `100`.
         *         pageSize: 'placeholder-value',
         *         // A page token, received from a previous `ListEvaluations` call. Provide this to retrieve the subsequent page.
         *         pageToken: 'placeholder-value',
         *         // Required. The resource name of the ProcessorVersion to list evaluations for. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         *         parent:
         *           'projects/my-project/locations/my-location/processors/my-processor/processorVersions/my-processorVersion',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "evaluations": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ListEvaluationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListEvaluationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListEvaluationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$List, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListEvaluationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListEvaluationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$Get extends StandardParameters {
        /**
         * Required. The resource name of the Evaluation to get. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}/evaluations/{evaluation\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Processors$Processorversions$Evaluations$List extends StandardParameters {
        /**
         * The standard list page size. If unspecified, at most `5` evaluations are returned. The maximum value is `100`. Values above `100` are coerced to `100`.
         */
        pageSize?: number;
        /**
         * A page token, received from a previous `ListEvaluations` call. Provide this to retrieve the subsequent page.
         */
        pageToken?: string;
        /**
         * Required. The resource name of the ProcessorVersion to list evaluations for. `projects/{project\}/locations/{location\}/processors/{processor\}/processorVersions/{processorVersion\}`
         */
        parent?: string;
    }
    export class Resource$Projects$Locations$Processortypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Gets a processor type detail.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processorTypes.get({
         *     // Required. The processor type resource name.
         *     name: 'projects/my-project/locations/my-location/processorTypes/my-processorType',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "allowCreation": false,
         *   //   "availableLocations": [],
         *   //   "category": "my_category",
         *   //   "launchStage": "my_launchStage",
         *   //   "name": "my_name",
         *   //   "sampleDocumentUris": [],
         *   //   "type": "my_type"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Processortypes$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Processortypes$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ProcessorType>>;
        get(params: Params$Resource$Projects$Locations$Processortypes$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Processortypes$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessorType>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessorType>): void;
        get(params: Params$Resource$Projects$Locations$Processortypes$Get, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessorType>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ProcessorType>): void;
        /**
         * Lists the processor types that exist.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.processorTypes.list({
         *     // The maximum number of processor types to return. If unspecified, at most `100` processor types will be returned. The maximum value is `500`. Values above `500` will be coerced to `500`.
         *     pageSize: 'placeholder-value',
         *     // Used to retrieve the next page of results, empty if at the end of the list.
         *     pageToken: 'placeholder-value',
         *     // Required. The location of processor types to list. Format: `projects/{project\}/locations/{location\}`.
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "processorTypes": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Processortypes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Processortypes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse>>;
        list(params: Params$Resource$Projects$Locations$Processortypes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Processortypes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Processortypes$List, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListProcessorTypesResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Processortypes$Get extends StandardParameters {
        /**
         * Required. The processor type resource name.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Processortypes$List extends StandardParameters {
        /**
         * The maximum number of processor types to return. If unspecified, at most `100` processor types will be returned. The maximum value is `500`. Values above `500` will be coerced to `500`.
         */
        pageSize?: number;
        /**
         * Used to retrieve the next page of results, empty if at the end of the list.
         */
        pageToken?: string;
        /**
         * Required. The location of processor types to list. Format: `projects/{project\}/locations/{location\}`.
         */
        parent?: string;
    }
    export class Resource$Projects$Locations$Schemas {
        context: APIRequestContext;
        schemaVersions: Resource$Projects$Locations$Schemas$Schemaversions;
        constructor(context: APIRequestContext);
        /**
         * Creates a schema.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.create({
         *     // Required. The parent (project and location) under which to create the Schema. Format: `projects/{project\}/locations/{location\}`
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "displayName": "my_displayName",
         *       //   "labels": {},
         *       //   "name": "my_name",
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "labels": {},
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Schemas$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Schemas$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3NextSchema>>;
        create(params: Params$Resource$Projects$Locations$Schemas$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Schemas$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
        create(params: Params$Resource$Projects$Locations$Schemas$Create, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
        /**
         * Deletes a schema.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.delete({
         *     // Optional. If set to true, any child resources of this Schema will also be deleted. (Otherwise, the request will only work if the Schema has no child resources.)
         *     force: 'placeholder-value',
         *     // Required. The name of the Schema to be deleted. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         *     name: 'projects/my-project/locations/my-location/schemas/my-schema',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Schemas$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Schemas$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Locations$Schemas$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Schemas$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Locations$Schemas$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a schema.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.get({
         *     // Required. The name of the Schema to get. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         *     name: 'projects/my-project/locations/my-location/schemas/my-schema',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "labels": {},
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Schemas$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Schemas$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3NextSchema>>;
        get(params: Params$Resource$Projects$Locations$Schemas$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Schemas$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
        get(params: Params$Resource$Projects$Locations$Schemas$Get, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
        /**
         * Lists Schemas.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.list({
         *     // Optional. The maximum number of schema groups to return. If unspecified, at most `10` Schema will be returned. The maximum value is `20`. Values above `20` will be coerced to `20`.
         *     pageSize: 'placeholder-value',
         *     // Optional. We will return the schema groups sorted by creation time. The page token will point to the next Schema.
         *     pageToken: 'placeholder-value',
         *     // Required. Format: `projects/{project\}/locations/{location\}`
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "schemas": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Schemas$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Schemas$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ListSchemasResponse>>;
        list(params: Params$Resource$Projects$Locations$Schemas$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Schemas$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListSchemasResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListSchemasResponse>): void;
        list(params: Params$Resource$Projects$Locations$Schemas$List, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListSchemasResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListSchemasResponse>): void;
        /**
         * Updates a schema. Editable fields are: - `display_name` - `labels`
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.patch({
         *     // Identifier. The resource name of the Schema. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         *     name: 'projects/my-project/locations/my-location/schemas/my-schema',
         *     // Optional. The update mask to apply to the resource. **Note:** Only the following fields can be updated: - display_name. - labels.
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "displayName": "my_displayName",
         *       //   "labels": {},
         *       //   "name": "my_name",
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "labels": {},
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Schemas$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Schemas$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3NextSchema>>;
        patch(params: Params$Resource$Projects$Locations$Schemas$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Schemas$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
        patch(params: Params$Resource$Projects$Locations$Schemas$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3NextSchema>): void;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Create extends StandardParameters {
        /**
         * Required. The parent (project and location) under which to create the Schema. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3NextSchema;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Delete extends StandardParameters {
        /**
         * Optional. If set to true, any child resources of this Schema will also be deleted. (Otherwise, the request will only work if the Schema has no child resources.)
         */
        force?: boolean;
        /**
         * Required. The name of the Schema to be deleted. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Get extends StandardParameters {
        /**
         * Required. The name of the Schema to get. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Schemas$List extends StandardParameters {
        /**
         * Optional. The maximum number of schema groups to return. If unspecified, at most `10` Schema will be returned. The maximum value is `20`. Values above `20` will be coerced to `20`.
         */
        pageSize?: number;
        /**
         * Optional. We will return the schema groups sorted by creation time. The page token will point to the next Schema.
         */
        pageToken?: string;
        /**
         * Required. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the Schema. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         */
        name?: string;
        /**
         * Optional. The update mask to apply to the resource. **Note:** Only the following fields can be updated: - display_name. - labels.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3NextSchema;
    }
    export class Resource$Projects$Locations$Schemas$Schemaversions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a schema version.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.schemaVersions.create(
         *     {
         *       // Required. The parent (project and location) under which to create the SchemaVersion. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         *       parent: 'projects/my-project/locations/my-location/schemas/my-schema',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "createTime": "my_createTime",
         *         //   "displayName": "my_displayName",
         *         //   "labels": {},
         *         //   "name": "my_name",
         *         //   "schema": {}
         *         // }
         *       },
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "labels": {},
         *   //   "name": "my_name",
         *   //   "schema": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Schemas$Schemaversions$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>>;
        create(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
        create(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Create, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
        /**
         * Deletes a schema version.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.schemaVersions.delete(
         *     {
         *       // Required. The name of the SchemaVersion to delete. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}`
         *       name: 'projects/my-project/locations/my-location/schemas/my-schema/schemaVersions/my-schemaVersion',
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Schemas$Schemaversions$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Generates a schema version.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await documentai.projects.locations.schemas.schemaVersions.generate({
         *       // Required. The parent (project, location and schema) under which to generate the SchemaVersion. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         *       parent: 'projects/my-project/locations/my-location/schemas/my-schema',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "baseSchemaVersion": "my_baseSchemaVersion",
         *         //   "gcsDocuments": {},
         *         //   "gcsPrefix": {},
         *         //   "generateSchemaVersionParams": {},
         *         //   "inlineDocuments": {},
         *         //   "rawDocuments": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "schemaVersion": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        generate(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Generate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        generate(params?: Params$Resource$Projects$Locations$Schemas$Schemaversions$Generate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionResponse>>;
        generate(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Generate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        generate(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Generate, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionResponse>): void;
        generate(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Generate, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionResponse>): void;
        generate(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionResponse>): void;
        /**
         * Gets a schema version.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.schemaVersions.get({
         *     // Required. The name of the SchemaVersion to get. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}`
         *     name: 'projects/my-project/locations/my-location/schemas/my-schema/schemaVersions/my-schemaVersion',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "labels": {},
         *   //   "name": "my_name",
         *   //   "schema": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Schemas$Schemaversions$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>>;
        get(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
        get(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Get, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
        /**
         * Lists SchemaVersions.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.schemaVersions.list({
         *     // Optional. The maximum number of SchemaVersion to return. If unspecified, at most `10` SchemaVersion will be returned. The maximum value is `20`. Values above `20` will be coerced to `20`.
         *     pageSize: 'placeholder-value',
         *     // Optional. We will return the SchemaVersion sorted by creation time. The page token will point to the next SchemaVersion.
         *     pageToken: 'placeholder-value',
         *     // Required. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         *     parent: 'projects/my-project/locations/my-location/schemas/my-schema',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "schemaVersions": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Schemas$Schemaversions$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3ListSchemaVersionsResponse>>;
        list(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListSchemaVersionsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListSchemaVersionsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$List, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListSchemaVersionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3ListSchemaVersionsResponse>): void;
        /**
         * Updates a schema version. Editable fields are: - `display_name` - `labels`
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/documentai.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const documentai = google.documentai('v1beta3');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await documentai.projects.locations.schemas.schemaVersions.patch({
         *     // Identifier. The resource name of the SchemaVersion. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}`
         *     name: 'projects/my-project/locations/my-location/schemas/my-schema/schemaVersions/my-schemaVersion',
         *     // Optional. The update mask to apply to the resource. **Note:** Only the following fields can be updated: - display_name. - labels.
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "displayName": "my_displayName",
         *       //   "labels": {},
         *       //   "name": "my_name",
         *       //   "schema": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "labels": {},
         *   //   "name": "my_name",
         *   //   "schema": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Schemas$Schemaversions$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>>;
        patch(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
        patch(params: Params$Resource$Projects$Locations$Schemas$Schemaversions$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDocumentaiV1beta3SchemaVersion>): void;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Schemaversions$Create extends StandardParameters {
        /**
         * Required. The parent (project and location) under which to create the SchemaVersion. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3SchemaVersion;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Schemaversions$Delete extends StandardParameters {
        /**
         * Required. The name of the SchemaVersion to delete. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Schemaversions$Generate extends StandardParameters {
        /**
         * Required. The parent (project, location and schema) under which to generate the SchemaVersion. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3GenerateSchemaVersionRequest;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Schemaversions$Get extends StandardParameters {
        /**
         * Required. The name of the SchemaVersion to get. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Schemaversions$List extends StandardParameters {
        /**
         * Optional. The maximum number of SchemaVersion to return. If unspecified, at most `10` SchemaVersion will be returned. The maximum value is `20`. Values above `20` will be coerced to `20`.
         */
        pageSize?: number;
        /**
         * Optional. We will return the SchemaVersion sorted by creation time. The page token will point to the next SchemaVersion.
         */
        pageToken?: string;
        /**
         * Required. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}`
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Schemas$Schemaversions$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the SchemaVersion. Format: `projects/{project\}/locations/{location\}/schemas/{schema\}/schemaVersions/{schema_version\}`
         */
        name?: string;
        /**
         * Optional. The update mask to apply to the resource. **Note:** Only the following fields can be updated: - display_name. - labels.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDocumentaiV1beta3SchemaVersion;
    }
    export {};
}
