// src/util/jsonp.ts
var count = 0;
var noop = function() {
};
function jsonp(url, { prefix = "__jp", param = "callback", timeout = 15e3 } = {}) {
  return new Promise(function(resolve, reject) {
    const targetChild = document.getElementsByTagName("script").item(0);
    const target = targetChild?.parentNode ?? document.head;
    const id = `${prefix}${count++}`;
    const cleanup = function() {
      if (script && script.parentNode) {
        script.parentNode.removeChild(script);
      }
      window[id] = noop;
      if (timer) {
        clearTimeout(timer);
      }
    };
    const timer = timeout > 0 ? setTimeout(() => {
      cleanup();
      reject(new Error("Timeout"));
    }, timeout) : void 0;
    const callback = (data) => {
      cleanup();
      resolve(data);
    };
    window[id] = callback;
    const script = document.createElement("script");
    const urlObj = new URL(url);
    urlObj.searchParams.set(param, id);
    script.setAttribute("src", urlObj.toString());
    target.insertBefore(script, targetChild);
  });
}

export {
  jsonp
};
//# sourceMappingURL=chunk-IPDEGCWU.js.map