declare const kDone: unique symbol;
declare const kRun: unique symbol;
/**
 * A very simple job queue with adjustable concurrency. Adapted from
 * https://github.com/STRML/async-limiter
 */
declare class Limiter {
    concurrency: number;
    jobs: Function[];
    pending: number;
    [kDone]: () => void;
    /**
     * Creates a new `Limiter`.
     *
     * @param {Number} [concurrency=Infinity] The maximum number of jobs allowed
     *     to run concurrently
     */
    constructor(concurrency?: number);
    /**
     * Adds a job to the queue.
     *
     * @param {Function} job The job to run
     * @public
     */
    add(job: Function): void;
    /**
     * Removes a job from the queue and runs it if possible.
     *
     * @private
     */
    [kRun](): void;
}
export { Limiter };
//# sourceMappingURL=limiter.d.ts.map