
'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = (n != 1);
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(If left blank, owner will be admin)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)",
    "(at least {placeholder} characters)": "(at least {placeholder} characters)",
    "(current notification)": "(huidige melding)",
    "(current version)": "(huidige versie)",
    "1 Year": "1 jaar",
    "1 cell copied": "1 cell copied",
    "1 filter": "1 filter",
    "1 hidden property": "1 hidden property",
    "1 month ago": "1 maand geleden",
    "1 preset hidden property": "1 preset hidden property",
    "1 record selected": "1 record selected",
    "1 row is copied.": "1 row is copied.",
    "1 sort": "1 sort",
    "1 week ago": "1 week geleden",
    "3 days ago": "3 dagen geleden",
    "30 Days": "30 dagen",
    "7 Days": "7 dagen",
    "A file is being uploaded. Are you sure you want to leave this page?": "A file is being uploaded. Are you sure you want to leave this page?",
    "A file named {upload_file_link} is uploaded to {uploaded_link}.": "A file named {upload_file_link} is uploaded to {uploaded_link}.",
    "A file named {upload_file_link} is uploaded.": "A file named {upload_file_link} is uploaded.",
    "A file with the same name already exists in this folder.": "Een bestand met deze naam bestaat reeds in deze map.",
    "A folder named {upload_folder_link} is uploaded to {uploaded_link}.": "A folder named {upload_folder_link} is uploaded to {uploaded_link}.",
    "A folder named {upload_folder_link} is uploaded.": "A folder named {upload_folder_link} is uploaded.",
    "API Token": "API Token",
    "API token is copied to the clipboard.": "API token is copied to the clipboard.",
    "About": "Over",
    "About Us": "Over ons",
    "Abuse Content": "Abuse Content",
    "Abuse Reports": "Abuse Reports",
    "Abuse Type": "Abuse Type",
    "Abuse report added": "Abuse report added",
    "Accept": "Accepteren",
    "Accepted": "Geaccepteerd",
    "Accepted at": "Geaccepteerd op",
    "Accepter": "Geaccepteerd door",
    "Access Log": "Toegangslogboek",
    "Accurate to minute": "Accurate to minute",
    "Action": "Actie",
    "Actions": "Acties",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email",
    "Activated": "Geactiveerd",
    "Activated Users": "Geactiveerde gebruikers",
    "Active": "Actief",
    "Active Users": "Actieve gebruikers",
    "Activities": "Activiteiten",
    "Add": "Toevoegen",
    "Add Admin": "Admin toevoegen",
    "Add Library": "Voeg bibliotheek toe",
    "Add Member": "Lid toevoegen",
    "Add Organization": "Organisatie toevoegen",
    "Add Terms and Conditions": "Voorwaarden toevoegen",
    "Add User": "Gebruiker toevoegen",
    "Add Wiki": "Wiki toevoegen",
    "Add admin": "Voeg beheerder toe",
    "Add auto expiration": "Voeg automatische vervaldatum toe",
    "Add cover": "Add cover",
    "Add custom permission": "Add custom permission",
    "Add group": "Add group",
    "Add group member": "Groepslid toevoegen",
    "Add icon": "Add icon",
    "Add institution": "Organisatie toevoegen",
    "Add members": "Leden toevoegen",
    "Add new notification": "Voeg melding toe",
    "Add option": "Add option",
    "Add password protection": "Wachtwoord beveiliging toevoegen",
    "Add permission": "Add permission",
    "Add user": "Voeg nieuwe gebruiker toe",
    "Add view": "Add view",
    "Added": "Toegevoegd",
    "Added user {user}": "Gebruiker {user} toegevoegd",
    "Admin": "Admin",
    "Admin Login Logs": "Admin Login Logs",
    "Admin Operation Logs": "Admin Operation Logs",
    "Admin access": "Admin access",
    "Admins": "Admins",
    "Advanced": "Advanced",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.",
    "All": "Alle",
    "All Groups": "Alle groepen",
    "All Notifications": "Alle meldingen",
    "All Public Links": "Alle Openbare Linken",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.",
    "An integer that is greater than 0 or equal to -2.": "An integer that is greater than 0 or equal to -2.",
    "An integer that is greater than or equal to 0.": "Een getal dat groter is dan of gelijk is aan 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Een interne koppeling is een koppeling naar een bestand of folder die toegankelijk is voor gebruikers die leesrechten hebben tot het bestand of de folder.",
    "And": "And",
    "Anonymous User": "Anonieme gebruiker",
    "Another property has this property type": "Another property has this property type",
    "Another user is editing this file!": "Another user is editing this file!",
    "Anyone with the link": "Anyone with the link",
    "App Name": "Appnaam",
    "Are you sure to change group {placeholder} to department ?": "Are you sure to change group {placeholder} to department ?",
    "Are you sure to delete": "Weet je zeker dat je wilt verwijderen",
    "Are you sure to delete ": "Are you sure to delete ",
    "Are you sure to revoke access of user {placeholder} ?": "Are you sure to revoke access of user {placeholder} ?",
    "Are you sure you want to clear trash?": "Weet je zeker dat je de prullenbak wilt legen?",
    "Are you sure you want to delete": "Are you sure you want to delete",
    "Are you sure you want to delete WebDAV password?": "Are you sure you want to delete WebDAV password?",
    "Are you sure you want to delete the notification ?": "Are you sure you want to delete the notification ?",
    "Are you sure you want to delete the selected share link(s) ?": "Are you sure you want to delete the selected share link(s) ?",
    "Are you sure you want to delete the selected user(s) ?": "Are you sure you want to delete the selected user(s) ?",
    "Are you sure you want to delete this page?": "Weet je zeker dat je deze pagina wilt verwijderen?",
    "Are you sure you want to delete {placeholder} ?": "Are you sure you want to delete {placeholder} ?",
    "Are you sure you want to delete {placeholder} completely?": "Are you sure you want to delete {placeholder} completely?",
    "Are you sure you want to disconnect?": "Are you sure you want to disconnect?",
    "Are you sure you want to remove {placeholder} ?": "Are you sure you want to remove {placeholder} ?",
    "Are you sure you want to reset the password of {placeholder} ?": "Are you sure you want to reset the password of {placeholder} ?",
    "Are you sure you want to restore this library?": "Weet je zeker dat je deze bibliotheek wil terughalen?",
    "Are you sure you want to restore {placeholder}?": "Are you sure you want to restore {placeholder}?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "Are you sure you want to revoke the admin permission of {placeholder} ?",
    "Are you sure you want to set {placeholder} as Admin?": "Are you sure you want to set {placeholder} as Admin?",
    "Are you sure you want to set {user_placeholder} inactive?": "Are you sure you want to set {user_placeholder} inactive?",
    "Are you sure you want to unlink this device?": "Weet je zeker dat je dit apparaat wilt ontkoppelen?",
    "At server": "At server",
    "Audio": "Audio",
    "Auth Token created": "Auth Token created",
    "Auth Token deleted": "Auth Token deleted",
    "Auto deletion": "Auto deletion",
    "Automatically delete files that are not modified within certain days:": "Automatically delete files that are not modified within certain days:",
    "Avatar": "Avatar",
    "Avatar updated": "Avatar updated",
    "Avatar:": "Avatar:",
    "Back": "Terug",
    "Basic": "Basic",
    "Bell Icon": "Bell Icon",
    "Besides Write permission, user can also share the library.": "Besides Write permission, user can also share the library.",
    "Branding": "Branding",
    "Broken (please contact your administrator to fix this library)": "Defect (neem contact op met je systeembeheerder om deze bibliotheek te repareren)",
    "By day": "By day",
    "By month": "By month",
    "By name ascending": "By name ascending",
    "By name descending": "By name descending",
    "By quarter": "By quarter",
    "By size ascending": "By size ascending",
    "By size descending": "By size descending",
    "By time ascending": "By time ascending",
    "By time descending": "By time descending",
    "By week": "By week",
    "By year": "By year",
    "Can not copy folder %(src)s to its subfolder %(des)s": "Can not copy folder %(src)s to its subfolder %(des)s",
    "Can not move folder %(src)s to its subfolder %(des)s": "Can not move folder %(src)s to its subfolder %(des)s",
    "Cancel": "Annuleren",
    "Cancel All": "Alles annuleren",
    "Cannot move parent page to child page": "Cannot move parent page to child page",
    "Capture information": "Capture information",
    "Capture time": "Capture time",
    "Certificate": "Certificate",
    "Change": "Wijzig",
    "Change Password": "Wijzig het wachtwoord",
    "Change Password of Library {placeholder}": "Wijzig wachtwoord van bibliotheek {placeholder}",
    "Change cover": "Change cover",
    "Change group to department": "Change group to department",
    "Change to department": "Change to department",
    "Changes": "Changes",
    "Checkbox": "Checkbox",
    "Choose date": "Kies datum",
    "Clean": "Opschonen",
    "Clean succeeded.": "Clean succeeded.",
    "Cleaned trash": "Cleaned trash",
    "Clear": "Wissen",
    "Clear Trash": "Prullenbak legen",
    "Clear files in trash and history\uff1a": "Schoon bestanden in prullenbak en geschiedenis:",
    "Clear selected": "Clear selected",
    "Clients": "Clients",
    "Close": "Sluiten",
    "Close (Esc)": "Sluiten (Esc)",
    "Code": "Code",
    "Collaborator": "Collaborator",
    "Collapse all": "Collapse all",
    "Color space": "Color space",
    "Comment": "Opmerking",
    "Comments": "Opmerkingen",
    "Community Edition": "Community editie",
    "Compressed": "Compressed",
    "Configure Seafile": "Configure Seafile",
    "Configure your Identity Provider": "Configure your Identity Provider",
    "Confirm": "Bevestigen",
    "Confirm Password": "Bevestig Wachtwoord",
    "Confirm password": "Confirm password",
    "Connect": "Connect",
    "Contact Email": "Contact e-mail",
    "Contact Email:": "Contact e-mail:",
    "Contact Information": "Contactinformatie",
    "Contact information is required.": "Contactinformatie is verplicht.",
    "Content Scan Records": "Content Scan Records",
    "Convert & Export": "Convert & Export",
    "Convert Wiki": "Convert Wiki",
    "Convert to Markdown": "Convert to Markdown",
    "Convert to docx": "Convert to docx",
    "Convert to sdoc": "Convert to sdoc",
    "Convert with ONLYOFFICE": "Convert with ONLYOFFICE",
    "Converting, please wait...": "Converting, please wait...",
    "Copied": "Gekopieerd",
    "Copied link to clipboard": "Copied link to clipboard",
    "Copy": "Kopi\u00ebren ",
    "Copy failed": "Copy failed",
    "Copy link": "Copy link",
    "Copy selected": "Copy selected",
    "Copy selected item(s) to:": "Geselecteerde item(s) kopi\u00ebren naar:",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "Copy the IdP's certificate and paste it here. The certificate format is as follows:",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.",
    "Copy {num} items": "Copy {num} items",
    "Copy {placeholder} to": "Copy {placeholder} to",
    "Copyright Infringement": "Copyright Infringement",
    "Count": "Teller",
    "Cover": "Cover",
    "Create": "Aanmaken",
    "Create At": "Gemaakt op",
    "Create Group": "Groep aanmaken",
    "Create Library": "Bibliotheek aanmaken",
    "Create Report": "Create Report",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Create a DNS TXT record to confirm the ownership of your Email Domain.",
    "Create a new tag": "Nieuwe tag aanmaken",
    "Created": "Aangemaakt",
    "Created At": "Gemaakt om",
    "Created Files": "Created Files",
    "Created draft": "Created draft",
    "Created file": "Bestand aangemaakt",
    "Created folder": "Map aangemaakt",
    "Created group {group_name}": "Created group {group_name}",
    "Created library": "Bibliotheek aangemaakt",
    "Created library {library_name} with {owner} as its owner": "Created library {library_name} with {owner} as its owner",
    "Created time": "Created time",
    "Created {n} files": "Created {n} files",
    "Creator": "Maker",
    "Current Connected Devices": "Huidige verbonden apparaten",
    "Current Library": "Huidige bibliotheek",
    "Current Path: ": "Huidig pad:",
    "Current Version": "Huidige versie",
    "Current page": "Current page",
    "Current password": "Current password",
    "Current password cannot be blank": "Huidige wachtwoord mag niet leeg zijn",
    "Current path: ": "Huidig pad:",
    "Custom CSS": "Aangepaste CSS",
    "Custom properties": "Custom properties",
    "Custom sharing permissions": "Custom sharing permissions",
    "Customize URL": "Customize URL",
    "DNS TXT Value": "DNS TXT Value",
    "Date": "Datum",
    "Date Invalid.": "Datum ongeldig.",
    "Day": "Day",
    "Default": "Standaard",
    "Delete": "Verwijderen",
    "Delete Account": "Account verwijderen",
    "Delete Department": "Afdeling verwijderen",
    "Delete Expired Invitations": "Delete Expired Invitations",
    "Delete File": "Bestand verwijderen",
    "Delete Folder": "Map verwijderen",
    "Delete Group": "Groep verwijderen",
    "Delete Institution": "Organisatie verwijderen",
    "Delete Library": "Bibliotheek verwijderen",
    "Delete Member": "Lid verwijderen",
    "Delete Notification": "Melding verwijderen",
    "Delete Organization": "Verwijder Organisatie",
    "Delete Password": "Delete Password",
    "Delete T&C": "Delete T&C",
    "Delete User": "Gebruiker verwijderen",
    "Delete Users": "Delete Users",
    "Delete WebDAV Password": "Delete WebDAV Password",
    "Delete Wiki": "Wiki verwijderen",
    "Delete file": "Delete file",
    "Delete files from this device the next time it comes online.": "Verwijder bestanden van dit apparaat op het moment dat deze weer online komt.",
    "Delete folder": "Delete folder",
    "Delete group": "Delete group",
    "Delete page": "Delete page",
    "Delete property": "Delete property",
    "Delete selected": "Delete selected",
    "Delete share links": "Delete share links",
    "Deleted": "Verwijderd",
    "Deleted Libraries": "Deleted Libraries",
    "Deleted Time": "Tijdstip verwijderd",
    "Deleted directories": "Verwijderde mappen",
    "Deleted draft": "Deleted draft",
    "Deleted file": "Bestand verwijderd",
    "Deleted files": "Verwijderde bestanden",
    "Deleted folder": "Map verwijderd",
    "Deleted group {group_name}": "Groep {group_name} verwijderd",
    "Deleted library": "Verwijderde bibliotheek",
    "Deleted library {library_name}": "Bibliotheek {library_name} verwijderd",
    "Deleted option": "Deleted option",
    "Deleted user %s": "Deleted user %s",
    "Deleted user {user}": "Gebruiker {user} verwijderd",
    "Department renamed": "Department renamed",
    "Departments": "Afdelingen",
    "Description": "Beschrijving",
    "Description is required": "Omschrijving is verplicht",
    "Desktop": "Desktop",
    "Detail": "Detailweergave",
    "Details": "Details",
    "Device": "Apparaat",
    "Device Name": "Apparaatnaam",
    "Device make": "Device make",
    "Device model": "Device model",
    "Devices": "Apparaten",
    "Dimensions": "Dimensions",
    "Direct download link": "Direct download link",
    "Direct download link is copied to the clipboard.": "Direct download link is copied to the clipboard.",
    "Disable Two-Factor Authentication": "Tweestapsauthenticatie uitschakelen",
    "Disconnect": "Disconnect",
    "Discussion": "Discussie",
    "Display files": "Display files",
    "Do not automatically delete files": "Do not automatically delete files",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "Do you really want to turn off extended properties? Existing properties will all be deleted.",
    "Document": "Document",
    "Document conversion failed.": "Document conversion failed.",
    "Document keywords": "Document keywords",
    "Domain verified": "Domain verified",
    "Don't ignore": "Don't ignore",
    "Don't keep history": "Bewaar geschiedenis niet",
    "Don't replace": "Niet vervangen",
    "Don't send emails": "Don't send emails",
    "Done": "Done",
    "Down": "Down",
    "Download": "Downloaden",
    "Download and upload": "Download and upload",
    "Duplicate": "Duplicate",
    "Duplicate page": "Duplicate page",
    "Edit": "Aanpassen",
    "Edit format settings": "Edit format settings",
    "Edit labels": "Labels bewerken",
    "Edit metadata properties": "Edit metadata properties",
    "Edit multiple select": "Edit multiple select",
    "Edit on cloud and download": "Edit on cloud and download",
    "Edit on cloud only": "Edit on cloud only",
    "Edit permission": "Edit permission",
    "Edit single select": "Edit single select",
    "Edit succeeded": "Wijzigen gelukt",
    "Edit succeeded.": "Edit succeeded.",
    "Email": "E-mail",
    "Email Domain": "Email Domain",
    "Email Notification": "Email Notification",
    "Email is invalid.": "E-mailadres is ongeldig",
    "Email notification updated": "Email notification updated",
    "Emails": "E-mails",
    "Emails, separated by ','": "Emails, separated by ','",
    "Emojis": "Emojis",
    "Empty": "Leeg",
    "Enable Two-Factor Authentication": "Tweestapsauthenticatie inschakelen",
    "Enable extended properties": "Enable extended properties",
    "Enable face recognition to identify people in your photos.": "Enable face recognition to identify people in your photos.",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.",
    "Enable two factor authentication": "Tweestapsauthenticatie inschakelen",
    "Enable users to share libraries to any groups in the system.": "Enable users to share libraries to any groups in the system.",
    "Encrypt": "Versleutel",
    "Encrypted library": "Versleutelde bibliotheek",
    "End date": "Einddatum",
    "Enter characters to start searching": "Enter characters to start searching",
    "Error": "Fout",
    "Errors": "Fouten",
    "European": "European",
    "Exact date": "Exact date",
    "Exit Institution Admin": "Exit Institution Admin",
    "Exit Organization Admin": "Exit Organization Admin",
    "Exit System Admin": "Systeembeheer afsluiten",
    "Expand all": "Expand all",
    "Expiration": "Vervaldatum",
    "Expiration days": "Expiration days",
    "Expiration time": "Expiration time",
    "Expired": "Verlopen",
    "Expired at": "Verlopen op",
    "Export": "Export",
    "Export Excel": "Export naar Excel",
    "Export as docx": "Export as docx",
    "Export as zip": "Export as zip",
    "Export tags": "Export tags",
    "Exporting": "Exporting",
    "Exporting...": "Exporting...",
    "Exposure time": "Exposure time",
    "Extended properties": "Extended properties",
    "Extension Prompts": "Extension Prompts",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Extensions of text files that can be online previewed, each suffix is separated by a comma.",
    "Extract file detail": "Extract file detail",
    "Extract file details": "Extract file details",
    "F number": "F number",
    "Face recognition": "Face recognition",
    "Failed": "Mislukt",
    "Failed imported options": "Failed imported options",
    "Failed to convert {name}.": "Failed to convert {name}.",
    "Failed to copy %(name)s": "Kon %(name)s niet kopi\u00ebren",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Failed to copy %(name)s and %(amount)s other item(s).",
    "Failed to copy %(name)s.": "Failed to copy %(name)s.",
    "Failed to copy files to another library.": "Failed to copy files to another library.",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Failed to delete %(virus_file) from library %(library): %(error_msg)",
    "Failed to delete property": "Failed to delete property",
    "Failed to delete records": "Failed to delete records",
    "Failed to delete {name}": "Failed to delete {name}",
    "Failed to delete {name} and {n} other items.": "Failed to delete {name} and {n} other items.",
    "Failed to delete {name}.": "Failed to delete {name}.",
    "Failed to download. The total size of the files exceeded the limit.": "Failed to download. The total size of the files exceeded the limit.",
    "Failed to duplicate page": "Failed to duplicate page",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "Failed to export. Please check whether the size of table attachments exceeds the limit.",
    "Failed to extract file details": "Failed to extract file details",
    "Failed to generate description": "Failed to generate description",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Failed to ignore %(virus_file) from library %(library): %(error_msg)",
    "Failed to insert property": "Failed to insert property",
    "Failed to modify filter": "Failed to modify filter",
    "Failed to modify group": "Failed to modify group",
    "Failed to modify hidden properties": "Failed to modify hidden properties",
    "Failed to modify people name": "Failed to modify people name",
    "Failed to modify property data": "Failed to modify property data",
    "Failed to modify property order": "Failed to modify property order",
    "Failed to modify records": "Failed to modify records",
    "Failed to modify sort": "Failed to modify sort",
    "Failed to move %(name)s and %(amount)s other item(s).": "Failed to move %(name)s and %(amount)s other item(s).",
    "Failed to move %(name)s.": "Failed to move %(name)s.",
    "Failed to move files to another library.": "Failed to move files to another library.",
    "Failed to move {name}.": "Failed to move {name}.",
    "Failed to rename property": "Failed to rename property",
    "Failed to restore records": "Failed to restore records",
    "Failed to restore {name}": "Failed to restore {name}",
    "Failed to restore {name} and {n} other items": "Failed to restore {name} and {n} other items",
    "Failed to save": "Failed to save",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "Failed to send to {email_placeholder}: {errorMsg_placeholder}",
    "Failed to unshare {name}": "Failed to unshare {name}",
    "Failed to upload {file_name}.": "Failed to upload {file_name}.",
    "Failed. Please check the network.": "Mislukt. Controleer de netwerkverbinding.",
    "Favorites": "Favorieten",
    "File": "Bestand",
    "File Access": "File Access",
    "File Operations": "File Operations",
    "File Update": "File Update",
    "File Upload": "Bestandsupload",
    "File Uploading...": "Bestand uploaden...",
    "File already exists.": "File already exists.",
    "File collaborators": "File collaborators",
    "File details": "File details",
    "File download is disabled: the share link traffic of owner is used up.": "Download is niet mogelijk: de limiet voor verkeer van bestanden delen is overschreden.",
    "File expire time": "File expire time",
    "File extension white list": "File extension white list",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.",
    "File extensions can only be {placeholder}.": "File extensions can only be {placeholder}.",
    "File is locked by others.": "File is locked by others.",
    "File name": "File name",
    "File owner": "File owner",
    "File reviewer": "File reviewer",
    "File size is too large.": "File size is too large.",
    "File status": "File status",
    "File too large": "File too large",
    "File type": "File type",
    "Files": "Bestanden",
    "Files and folders": "Files and folders",
    "Filter": "Filter",
    "Filters": "Filters",
    "Find a tag": "Find a tag",
    "Find modifiers": "Find modifiers",
    "Focal length": "Focal length",
    "Folder": "Map",
    "Folder Permission": "Map toegangsrechten",
    "Folder does not exist.": "Folder does not exist.",
    "Folders": "Mappen",
    "Force user to change password when account is newly added or reset by admin": "Force user to change password when account is newly added or reset by admin",
    "Force user to use a strong password when sign up or change password.": "Force user to use a strong password when sign up or change password.",
    "Format": "Format",
    "Freeze Document": "Freeze Document",
    "Freeze user account when failed login attempts exceed limit.": "Freeze user account when failed login attempts exceed limit.",
    "Frozen by {name}": "Frozen by {name}",
    "Full screen": "Volledig scherm",
    "Gallery": "Gallery",
    "General information": "General information",
    "Generate": "Genereer",
    "Generate Link": "Generate Link",
    "Generate description": "Generate description",
    "Generate links in batch": "Generate links in batch",
    "Generate share link": "Generate share link",
    "Germany Russia etc": "Germany Russia etc",
    "Global Address Book": "Global Address Book",
    "Greater than or equal to {minDays_placeholder} days": "Greater than or equal to {minDays_placeholder} days",
    "Grid view": "Grid view",
    "Group": "Groep",
    "Group Permission": "Groepsrechten",
    "Group Shares": "Group Shares",
    "Group by": "Group by",
    "Group members": "Group members",
    "Grouped by 1 property": "Grouped by 1 property",
    "Groups": "Groepen",
    "Guest": "Gast",
    "Handled": "Behandeld",
    "Help": "Help",
    "Hide": "Verbergen",
    "Hide all": "Hide all",
    "Hide properties": "Hide properties",
    "History": "Geschiedenis",
    "History Setting": "Geschiedenis-instellingen",
    "History Versions": "Versiehistorie",
    "IP": "IP",
    "ISO": "ISO",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "If notifications have not been read within one hour, they will be sent to your mailbox.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.",
    "Ignore": "Ignore",
    "Ignored": "Ignored",
    "Import Users": "Import Users",
    "Import members": "Import members",
    "Import members from a .xlsx file": "Import members from a .xlsx file",
    "Import options": "Import options",
    "Import sdoc": "Import sdoc",
    "Import tags": "Import tags",
    "Import users": "Importeer gebruikers",
    "Import users from a .xlsx file": "Import users from a .xlsx file",
    "In progress": "In progress",
    "In review": "In review",
    "Inactive": "Inactief",
    "Info": "Informatie",
    "Institution Admin": "Institution Admin",
    "Institutions": "Organisaties",
    "Internal Link": "Interne link",
    "Internal Server Error": "Interne Server Fout",
    "Internal link has been copied to clipboard": "Interne link is gekopieerd naar het klembord",
    "Invalid destination path": "Ongeldig bestandspad bestemming",
    "Invalid filename.": "Invalid filename.",
    "Invalid filter": "Invalid filter",
    "Invalid month, should be yyyymm.": "Invalid month, should be yyyymm.",
    "Invalid regular expression": "Invalid regular expression",
    "Invisible": "Invisible",
    "Invitations": "Uitnodigingen",
    "Invite Guest": "Gast uitnodigen",
    "Invite Time": "Tijdstip uitnodiging",
    "Invite users": "Invite users",
    "Invited at": "Uitgenodigd op",
    "Inviter": "Uitgenodigd door",
    "Is expired": "Is expired",
    "It is required.": "Het is verplicht.",
    "It may take some time, please wait.": "It may take some time, please wait.",
    "Keep full history": "Bewaar volledige geschiedenis",
    "Keep sharing": "Keep sharing",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP (geimporteerd)",
    "Label": "Label",
    "Label Current State": "Label Current State",
    "Labels": "Labels",
    "Language": "Taal",
    "Language Setting": "Taalinstelling",
    "Last Access": "Laatst gesynchroniseerd",
    "Last Login": "Laatste inlog",
    "Last Update": "Laatste wijziging",
    "Last modified by": "Last modified by",
    "Last modified time": "Last modified time",
    "Last modifier": "Last modifier",
    "Leave": "Verlaten",
    "Leave Group": "Leave Group",
    "Leave Share": "Gedeelde folder verlaten",
    "Leave group": "Verlaat deze groep",
    "Leave this page? The system may not save your changes.": "Leave this page? The system may not save your changes.",
    "Less than or equal to {maxDays_placeholder} days": "Less than or equal to {maxDays_placeholder} days",
    "Libraries": "Bibliotheken",
    "Library": "Bibliotheek",
    "Library Type": "Soort bibliotheek",
    "Library does not exist": "Bibliotheek bestaat niet",
    "Limits": "Limieten",
    "Link": "Link",
    "Link has been copied to clipboard": "Link has been copied to clipboard",
    "Linked Devices": "Gekoppelde apparaten",
    "Links": "Links",
    "List view": "List view",
    "List your account in global address book, so that others can find you by typing your name.": "List your account in global address book, so that others can find you by typing your name.",
    "Load all": "Load all",
    "Loading": "Loading",
    "Loading...": "Laden...",
    "Location": "Locatie",
    "Lock": "Slot",
    "Log out": "Uitloggen",
    "Login": "Login",
    "Login ID": "Login ID",
    "Logo updated": "Logo updated",
    "Logs": "Logbestanden",
    "Long text": "Long text",
    "Manage group members": "Manage group members",
    "Manage members": "Manage members",
    "Mark all read": "Alles als gelezen markeren",
    "Mark as resolved": "Markeren als opgelost",
    "Max": "Max",
    "Max number of members": "Max number of members",
    "Member": "Lid",
    "Members": "Leden",
    "Message": "Bericht",
    "Message (optional):": "Bericht (optioneel):",
    "Migrate User": "Migrate User",
    "Mobile": "Mobiel",
    "Modification Details": "Wijzigingdetails",
    "Modified": "Gewijzigd",
    "Modified by": "Modified by",
    "Modified by:": "Modified by:",
    "Modified files": "Gewijzigde bestanden",
    "Modifier": "Wijziger",
    "Modify": "Modify",
    "Modify includes modify file, move/rename file and folder": "Modify includes modify file, move/rename file and folder",
    "Modify name": "Modify name",
    "Month": "Month",
    "Month:": "Maand:",
    "Monthly User Traffic": "Monthly User Traffic",
    "More": "Meer",
    "More operations": "Meer handelingen",
    "Move": "Verplaatsen",
    "Move selected item(s) to:": "Geselecteerde item(s) verplaatsen naar:",
    "Move {num} items": "Move {num} items",
    "Move {placeholder} to": "Move {placeholder} to",
    "Moved file": "Bestand verplaatst",
    "Moved folder": "Map verplaatst",
    "Multiple select": "Multiple select",
    "My Libraries": "Mijn bibliotheken",
    "My Wikis": "My Wikis",
    "Name": "Naam",
    "Name already exists": "Name already exists",
    "Name cannot be double dots": "Name cannot be double dots",
    "Name cannot be empty": "Name cannot be empty",
    "Name cannot contain backslash": "Name cannot contain backslash",
    "Name cannot contain backtick": "Name cannot contain backtick",
    "Name cannot contain curly braces": "Name cannot contain curly braces",
    "Name cannot contain dots": "Name cannot contain dots",
    "Name cannot contain slash": "Name cannot contain slash",
    "Name is required": "Naam is verplicht",
    "Name is required.": "Naam is vereist.",
    "Name or ID": "Name or ID",
    "Name should be string": "Name should be string",
    "Name should not include '/'.": "Naam mag geen '/' bevatten.",
    "Name updated": "Name updated",
    "Name(optional)": "Naam(optioneel)",
    "Network error": "Netwerkfout",
    "New": "Nieuw",
    "New Department": "Nieuwe afdeling",
    "New Department Library": "New Department Library",
    "New Excel File": "Nieuw Excelbestand",
    "New File": "Nieuw bestand",
    "New Folder": "Nieuwe map",
    "New Group": "Nieuwe groep",
    "New Library": "Nieuwe Bibliotheek",
    "New Markdown File": "New Markdown File",
    "New Password": "Nieuw wachtwoord",
    "New Password Again": "Nieuwe wachtwoord nogmaals",
    "New PowerPoint File": "Nieuw PowerPoint-bestand",
    "New SeaDoc File": "New SeaDoc File",
    "New Sub-department": "Nieuwe subafdeling",
    "New Word File": "Nieuw Word-bestand",
    "New directories": "Nieuwe mappen",
    "New file name": "Nieuwe bestandsnaam",
    "New files": "Nieuwe bestanden",
    "New folder name": "Nieuwe mapnaam",
    "New page": "New page",
    "New password": "Nieuw wachtwoord",
    "New password cannot be the same as old password": "New password cannot be the same as old password",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.",
    "New password is too short": "Nieuwe wachtwoord is te kort",
    "New passwords don't match": "Nieuwe wachtwoorden komen niet overeen",
    "New view": "New view",
    "Next": "Volgende",
    "Next (Right arrow key)": "Volgende (rechter pijltjestoets)",
    "No Admin login logs": "No Admin login logs",
    "No Admin operation logs": "No Admin operation logs",
    "No Wikis": "No Wikis",
    "No changes": "No changes",
    "No collaborators": "No collaborators",
    "No collaborators available": "No collaborators available",
    "No comment yet.": "Nog geen opmerkingen.",
    "No connected devices": "Geen apparaten verbonden",
    "No deleted libraries": "No deleted libraries",
    "No favorites": "No favorites",
    "No file": "No file",
    "No file access logs": "No file access logs",
    "No file update logs": "No file update logs",
    "No filters": "No filters",
    "No folders shared": "No folders shared",
    "No groupings applied to this view.": "No groupings applied to this view.",
    "No groups": "Geen groepen",
    "No guest invitations": "No guest invitations",
    "No invitations": "No invitations",
    "No libraries": "Geen bibliotheken",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.",
    "No libraries have been shared with you": "No libraries have been shared with you",
    "No libraries have been shared with you from other servers.": "No libraries have been shared with you from other servers.",
    "No libraries shared": "No libraries shared",
    "No libraries shared with this group": "No libraries shared with this group",
    "No linked devices": "No linked devices",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.",
    "No login logs": "No login logs",
    "No members": "Geen leden",
    "No more activities": "No more activities",
    "No notifications": "No notifications",
    "No option": "No option",
    "No options": "No options",
    "No options available": "No options available",
    "No permission logs": "No permission logs",
    "No properties available to be hidden": "No properties available to be hidden",
    "No public libraries": "Geen publieke bibliotheken",
    "No record": "No record",
    "No result": "Geen resultaat",
    "No results": "No results",
    "No results matching": "No results matching",
    "No share links": "No share links",
    "No sync errors": "Geen synchronisatiefouten",
    "No tags": "Geen tags",
    "No terms and conditions": "No terms and conditions",
    "No upload links": "No upload links",
    "No version history": "No version history",
    "None": "Geen",
    "Not allow user to clean library trash": "Not allow user to clean library trash",
    "Not allow user to create encrypted libraries": "Not allow user to create encrypted libraries",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Let op: instellingen uit de webomgeving zijn opgeslagen in een databasetabel (seahub-db/constance_config). Zij hebben een hogere prioriteit dan de instellingen in configuratiebestanden.",
    "Notification Detail": "Melding Detail",
    "Notifications": "Meldingen",
    "Notifications of file changes": "Notifications of file changes",
    "Number": "Number",
    "Number of days ago": "Number of days ago",
    "Number of days from now": "Number of days from now",
    "Number of days that keep user sign in.": "Number of days that keep user sign in.",
    "Number of groups": "Aantal groepen",
    "Number of links": "Number of links",
    "Number of members": "Aantal leden",
    "Off": "Uit",
    "Old Password": "Oude wachtwoord",
    "Old Wikis": "Old Wikis",
    "On": "Aan",
    "One month ago": "One month ago",
    "One month from now": "One month from now",
    "One week ago": "One week ago",
    "One week from now": "One week from now",
    "Online Preview": "Online Preview",
    "Online Read-Only": "Online Read-Only",
    "Online Read-Only folder": "Online Read-Only folder",
    "Online Read-Only library": "Online Read-Only library",
    "Online Read-Write": "Online Read-Write",
    "Online Read-Write folder": "Online Read-Write folder",
    "Online Read-Write library": "Online Read-Write library",
    "Online view is not applicable to this file format": "Online view is not applicable to this file format",
    "Only Show": "Only Show",
    "Only files": "Only files",
    "Only folders": "Only folders",
    "Only keep a period of history:": "Bewaar alleen geschiedenis over been bepaalde periode:",
    "Only pictures": "Only pictures",
    "Only videos": "Only videos",
    "Open file": "Open file",
    "Open file in new tab": "Open file in new tab",
    "Open folder": "Open folder",
    "Open folder in new tab": "Open folder in new tab",
    "Open in new tab": "Open in new tab",
    "Open parent folder": "Open parent folder",
    "Open via Client": "Openen via programma",
    "Operation": "Acties",
    "Operation succeeded.": "Handeling gelukt.",
    "Operations": "Handelingen",
    "Optional": "Optioneel",
    "Options imported": "Options imported",
    "Or": "Or",
    "Organization": "Organisatie",
    "Organization Admin": "Organisatiebeheerder",
    "Organizations": "Organisaties",
    "Original path": "Original path",
    "Other": "Anders",
    "Other Libraries": "Andere bibliotheken",
    "Others": "Others",
    "Out of quota.": "Out of quota.",
    "Outdated": "Outdated",
    "Outline": "Uitlijnen",
    "Owned Libraries": "Owned Libraries",
    "Owner": "Eigenaar",
    "Owner can use admin panel in an organization, must be a new account.": "Beheerder kan het beheerpaneel in een organisatie gebruiken, moet een nieuw account zijn.",
    "Packaging...": "Aan het inpakken...",
    "Page name": "Page name",
    "Pages": "Pagina's",
    "Parent folder": "Parent folder",
    "Password": "Wachtwoord",
    "Password again": "Wachtwoord nogmaals",
    "Password cannot be blank": "Wachtwoord mag niet leeg zijn",
    "Password is too short": "Wachtwoord is te kort",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols",
    "Password removed": "Password removed",
    "Password reset": "Password reset",
    "Password set": "Password set",
    "Password strength": "Password strength",
    "Password updated": "Password updated",
    "Passwords do not match.": "Wachtwoorden komen niet overeen.",
    "Passwords don't match": "Wachtwoorden komen niet overeen",
    "Path": "Path",
    "Per 4 hours": "Per 4 uur",
    "Per day": "Per dag",
    "Per hour": "Per uur",
    "Per week": "Per week",
    "Permission": "Toegangsrechten",
    "Permission denied": "Permissie geweigerd",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Permission denied. Please try {placeholder-left}login again.{placeholder-right}",
    "Permission name": "Permission name",
    "Person image": "Person image",
    "Picture": "Picture",
    "Pictures and videos": "Pictures and videos",
    "Platform": "Platform",
    "Please check the network.": "Controleer de netwerkverbinding.",
    "Please choose a .xlsx file.": "Please choose a .xlsx file.",
    "Please choose an image file.": "Please choose an image file.",
    "Please enter 1 or more character": "Voer 1 of meer tekens in.",
    "Please enter a new password": "Geef het nieuwe wachtwoord op",
    "Please enter a non-negative integer": "Voer een niet negatief getal in",
    "Please enter a password.": "Please enter a password.",
    "Please enter a positive integer": "Please enter a positive integer",
    "Please enter an integer bigger than 1 as number of links.": "Please enter an integer bigger than 1 as number of links.",
    "Please enter an integer not bigger than {max_number} as number of links.": "Please enter an integer not bigger than {max_number} as number of links.",
    "Please enter days": "Voer aantal dagen in",
    "Please enter password": "Voer wachtwoord in",
    "Please enter the new password again": "Gelieve het wachtwoord opnieuw in te voeren",
    "Please enter the old password": "Geeft het oude wachtwoord op",
    "Please enter the password again": "Gelieve het wachtwoord opnieuw in te voeren",
    "Please input at least an email.": "Voer minimaal een e-mailadres in.",
    "Please select a file": "Please select a file",
    "Please select a library to share.": "Please select a library to share.",
    "Please select an expiration time": "Please select an expiration time",
    "Please upload no more than {maxFiles} files at a time.": "Please upload no more than {maxFiles} files at a time.",
    "Preset hide properties": "Preset hide properties",
    "Preview and download": "Voorbeeld en download",
    "Preview online": "Preview online",
    "Preview only": "Alleen voorbeeld",
    "Previous": "Vorige",
    "Previous (Left arrow key)": "Vorige (linker pijltjestoets)",
    "Print": "Print",
    "Professional Edition": "Professionele editie",
    "Profile": "Profiel",
    "Profile Setting": "Profielinstelling",
    "Properties": "Properties",
    "Property name": "Property name",
    "Publish": "Publiceren",
    "Publish Wiki": "Publish Wiki",
    "Quota": "Quota",
    "Quota is invalid.": "Quota is invalid.",
    "Rate": "Rate",
    "Read-Only": "Alleen lezen",
    "Read-Only folder": "Read-Only folder",
    "Read-Only library": "Alleen-lezen bibliotheek",
    "Read-Write": "Lezen/schrijven",
    "Read-Write folder": "Read-Write folder",
    "Read-Write library": "Lees-Schrijf bibliotheek",
    "Really want to delete this group?": "Zeker weten dat je deze groep wilt verwijderen?",
    "Really want to delete your account?": "Wil je je account echt verwijderen?",
    "Really want to leave this group?": "Really want to leave this group?",
    "Recognizing portraits. Please refresh the page later.": "Recognizing portraits. Please refresh the page later.",
    "Refresh": "Vernieuwen",
    "Remove": "Verwijderen",
    "Rename": "Hernoem",
    "Rename Department": "Rename Department",
    "Rename File": "Bestand hernoemen",
    "Rename Folder": "Map hernoemen",
    "Rename Group": "Groep hernoemen",
    "Rename Wiki": "Rename Wiki",
    "Rename file": "Rename file",
    "Rename folder": "Rename folder",
    "Rename group to": "Groep hernoemen in",
    "Rename property": "Rename property",
    "Renamed file": "Bestand hernoemd",
    "Renamed folder": "Map hernoemd",
    "Renamed library": "Bibliotheek hernoemd",
    "Renamed or Moved files": "Hernoemde of verplaatste bestanden",
    "Renaming {name} failed": "Renaming {name} failed",
    "Replace": "Vervangen",
    "Replace file {filename}?": "Bestand {filename} vervangen?",
    "Replacing it will overwrite its content.": "Vervanging zal huidige inhoud overschrijven.",
    "Report Abuse": "Report Abuse",
    "Reporter": "Reporter",
    "Reports": "Reports",
    "Required at least three letters.": "Required at least three letters.",
    "Reset": "Reset",
    "Reset Password": "Wachtwoord reset",
    "Reset WebDAV Password": "Reset WebDAV Password",
    "Reset library password": "Reset library password",
    "ResetPwd": "ResetPwd",
    "Resetting user's password, please wait for a moment.": "Resetting user's password, please wait for a moment.",
    "Restore": "Terughalen",
    "Restore Library": "Bibliotheek herstellen",
    "Restored file": "Bestand hersteld",
    "Restored folder": "Map hersteld",
    "Restored library": "Bibliotheek hersteld",
    "Restored {name}": "Restored {name}",
    "Restored {name} and {n} other items": "Restored {name} and {n} other items",
    "Result": "Resultaat",
    "Revoke Access": "Toegang intrekken",
    "Revoke Admin": "Intrekken Admin",
    "Role": "Rol",
    "SAML config": "SAML config",
    "SAML config updated": "SAML config updated",
    "Save": "Opslaan",
    "Save Selected Items": "Save Selected Items",
    "Save as ...": "Opslaan als ...",
    "Save to:": "Save to:",
    "Saving...": "Opslaan...",
    "Scan the QR code to view the shared content directly": "Scan the QR code to view the shared content directly",
    "SeaTable integration": "SeaTable integration",
    "Seafile": "Seafile",
    "Search": "Zoek",
    "Search Groups": "Search Groups",
    "Search Libraries": "Search Libraries",
    "Search Organizations": "Search Organizations",
    "Search Users": "Search Users",
    "Search collaborator": "Search collaborator",
    "Search collaborators": "Search collaborators",
    "Search files": "Search files",
    "Search files in this library": "Zoek bestanden in deze bibliotheek",
    "Search groups": "Zoek groepen",
    "Search groups by name": "Search groups by name",
    "Search libraries by name or ID": "Search libraries by name or ID",
    "Search libraries by owner": "Search libraries by owner",
    "Search option": "Search option",
    "Search organizations": "Search organizations",
    "Search property": "Search property",
    "Search users": "Search users",
    "Search users...": "Zoek gebruikers...",
    "Searching...": "Zoeken...",
    "Select File": "Select File",
    "Select a department": "Select a department",
    "Select a user": "Select a user",
    "Select a user as admin": "Select a user as admin",
    "Select all": "Select all",
    "Select an option": "Select an option",
    "Select collaborators": "Select collaborators",
    "Select libraries to share": "Selecteer bibliotheken om te delen",
    "Select option(s)": "Select option(s)",
    "Select up to 50 files": "Select up to 50 files",
    "Send": "Verzend",
    "Send activation Email after user registration.": "Stuur activatiemail na gebruikersregistratie.",
    "Send to:": "Verzend naar:",
    "Sending new password...": "Sending new password...",
    "Sending...": "Verzenden...",
    "Server Version: ": "Serverversie: ",
    "Set Admin": "Admin instellen",
    "Set Contact Email": "Set Contact Email",
    "Set Download Rate Limit": "Set Download Rate Limit",
    "Set Login ID": "Set Login ID",
    "Set Name": "Set Name",
    "Set Password": "Wachtwoord instellen",
    "Set Quota": "Quota instellen",
    "Set Upload Rate Limit": "Set Upload Rate Limit",
    "Set WebDAV Password": "Set WebDAV Password",
    "Set max number of members": "Set max number of members",
    "Set password": "Set password",
    "Set permission": "Rechten instellen",
    "Set permission of {placeholder}": "Set permission of {placeholder}",
    "Set to current": "Zet naar huidig",
    "Set user contact email": "Set user contact email",
    "Set user default quota": "Set user default quota",
    "Set user name": "Gebruikersnaam instellen",
    "Set user quota": "Set user quota",
    "Setting library history is disabled by Admin.": "Setting library history is disabled by Admin.",
    "Settings": "Instellingen",
    "Share": "Delen",
    "Share Admin": "Delen beheer",
    "Share From": "Delen Van",
    "Share Link": "Deellink",
    "Share Links": "Gedeelde links",
    "Share To": "Delen met",
    "Share To:": "Share To:",
    "Share existing libraries": "Deel bestaande bibliotheken",
    "Share link download": "Share link download",
    "Share link is copied to the clipboard.": "Share link is copied to the clipboard.",
    "Share link upload": "Share link upload",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.",
    "Share to group": "Delen met een groep",
    "Share to other server": "Share to other server",
    "Share to user": "Delen met gebruiker",
    "Shared By": "Gedeeld Door",
    "Shared Libraries": "Shared Libraries",
    "Shared Links": "Gedeelde links",
    "Shared by:": "Gedeeld door:",
    "Shared by: ": "Gedeeld door:",
    "Shared with all": "Gedeeld met iedereen",
    "Shared with me": "Gedeeld met mij",
    "Show": "Toon",
    "Show Codes": "Codes tonen",
    "Show all": "Show all",
    "Show changes": "Show changes",
    "Side Nav Menu": "Side Nav Menu",
    "Single select": "Single select",
    "Site name used in email sending": "Site name used in email sending",
    "Site title shown in a browser tab": "Site title shown in a browser tab",
    "Size": "Grootte",
    "Sort": "Sort",
    "Sort ascending": "Sort ascending",
    "Sort descending": "Sort descending",
    "Space Used": "Ruimte Gebruikt",
    "Space Used / Quota": "Space Used / Quota",
    "Specific people with email address": "Specific people with email address",
    "Specific users in the team": "Specific users in the team",
    "Star": "Favoriet maken",
    "Start date": "Startdatum",
    "Status": "Status",
    "Status: enabled": "Status: enabled",
    "Storage": "Opslagruimte",
    "Storage Backend": "Storage Backend",
    "Storage Used": "Gebruikte opslagruimte",
    "Style": "Style",
    "Submit": "Verzenden",
    "Success": "Gelukt",
    "Successfully added label(s) for library {placeholder}": "Successfully added label(s) for library {placeholder}",
    "Successfully change the group": "Successfully change the group",
    "Successfully changed library password.": "Succesvolle wijziging van wachtwoord bibliotheek",
    "Successfully cleared trash.": "Successfully cleared trash.",
    "Successfully converted the file.": "Successfully converted the file.",
    "Successfully copied %(name)s and %(amount)s other items.": "Kopi\u00ebren van %(name)s en %(amount)s andere items gelukt.",
    "Successfully copied %(name)s and 1 other item.": "Kopi\u00ebren van %(name)s en 1 ander item gelukt.",
    "Successfully copied %(name)s.": "Kopi\u00ebren van %(name)s gelukt.",
    "Successfully copied files to another library.": "Successfully copied files to another library.",
    "Successfully deleted 1 item": "Succesvol 1 item verwijderd.",
    "Successfully deleted 1 item.": "Succesvol 1 item verwijderd.",
    "Successfully deleted 1 share link": "Successfully deleted 1 share link",
    "Successfully deleted 1 user.": "Successfully deleted 1 user.",
    "Successfully deleted {name}": "Successfully deleted {name}",
    "Successfully deleted {name} and {n} other items": "Successfully deleted {name} and {n} other items",
    "Successfully deleted {name} and {n} other items.": "Successfully deleted {name} and {n} other items.",
    "Successfully deleted {name}.": "Successfully deleted {name}.",
    "Successfully deleted {number_placeholder} share links": "Successfully deleted {number_placeholder} share links",
    "Successfully deleted {user_number_placeholder} users.": "Successfully deleted {user_number_placeholder} users.",
    "Successfully edited labels.": "Successfully edited labels.",
    "Successfully invited %(email) and %(num) other people.": "Successfully invited %(email) and %(num) other people.",
    "Successfully invited %(email).": "Successfully invited %(email).",
    "Successfully moved %(name)s and %(amount)s other items.": "Verplaatsen van %(name)s en %(amount)s andere items gelukt.",
    "Successfully moved %(name)s and 1 other item.": "Verplaatsen van %(name)s en 1 ander item gelukt.",
    "Successfully moved %(name)s.": "Verplaatsen van %(name)s gelukt.",
    "Successfully moved files to another library.": "Successfully moved files to another library.",
    "Successfully moved {name}.": "Successfully moved {name}.",
    "Successfully restored the library {library_name}.": "Successfully restored the library {library_name}.",
    "Successfully restored the library.": "Successfully restored the library.",
    "Successfully restored.": "Successfully restored.",
    "Successfully revoke the admin permission of %s": "Adminrechten van %s succesvol ingetrokken",
    "Successfully revoked access of user {placeholder}.": "Successfully revoked access of user {placeholder}.",
    "Successfully revoked the admin permission of {placeholder}.": "Successfully revoked the admin permission of {placeholder}.",
    "Successfully saved": "Successfully saved",
    "Successfully sent to {placeholder}": "Versturen naar {placeholder} gelukt",
    "Successfully set %s as admin.": "%s succesvol ingesteld als admin.",
    "Successfully set it.": "Successfully set it.",
    "Successfully set library history.": "Bibliotheekgeschiedenis instellen gelukt.",
    "Successfully starred {library_name_placeholder}.": "Successfully starred {library_name_placeholder}.",
    "Successfully transferred the group.": "Groep succesvol overgedragen",
    "Successfully transferred the library.": "Verplaatsen van de bibliotheek is gelukt.",
    "Successfully unlinked the device.": "Successfully unlinked the device.",
    "Successfully unshared {name}": "Successfully unshared {name}",
    "Successfully unstarred {library_name_placeholder}.": "Successfully unstarred {library_name_placeholder}.",
    "Suggestion": "Suggestion",
    "Switch sort mode": "Switch sort mode",
    "Switch to plain text editor": "Schakel over naar standaard tekstbewerker",
    "Switch to rich text editor": "Schakel over naar tekstbewerker met opmaak",
    "Switch view mode": "Switch view mode",
    "Sync": "Synchronisatie",
    "Sync Download": "Sync Download",
    "Sync Upload": "Sync Upload",
    "System": "Systeem",
    "System Admin": "Systeembeheerder",
    "System Info": "Systeeminformatie",
    "System settings updated": "System settings updated",
    "Table": "Tabel",
    "Tag not found": "Tag not found",
    "Tagged Files": "Tagged Files",
    "Tags": "Tags",
    "Team name": "Team name",
    "Template": "Sjabloon",
    "Terms": "Terms",
    "Terms and Conditions": "Voorwaarden",
    "Text": "Tekst",
    "Text is required.": "Text is required.",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.",
    "The file is too large. Allowed maximum size is 1MB.": "The file is too large. Allowed maximum size is 1MB.",
    "The imported options are invalid": "The imported options are invalid",
    "The least number of characters a share/upload link password should include.": "The least number of characters a share/upload link password should include.",
    "The least number of characters an encrypted library password should include.": "The least number of characters an encrypted library password should include.",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols",
    "The link is copied to the clipboard.": "The link is copied to the clipboard.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "The list of added, deleted and modified files will be sent to your mailbox.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "The maximum number of failed login attempts before showing CAPTCHA.",
    "The name \"{name}\" is already taken. Please choose a different name.": "The name \"{name}\" is already taken. Please choose a different name.",
    "The next month": "The next month",
    "The next numbers of days": "The next numbers of days",
    "The next week": "The next week",
    "The next year": "The next year",
    "The owner of this library has run out of space.": "De eigenaar van deze bibliotheek heeft geen ruimte meer.",
    "The password is too short.": "The password is too short.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.",
    "The password will be kept in the server for only 1 hour.": "Het wachtwoord wordt maar 1 uur op de server bewaard.",
    "The past month": "The past month",
    "The past numbers of days": "The past numbers of days",
    "The past week": "The past week",
    "The past year": "The past year",
    "There is another option with this name": "There is another option with this name",
    "There is another property with this name": "There is another property with this name",
    "There is no information to display.": "There is no information to display.",
    "This file has (apparently) not been accessed yet": "Dit bestand is (kennelijk) nog niet geraadpleegd",
    "This file has been updated.": "Dit bestand is ge\u00fcpdatet.",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).",
    "This folder has no content at this time.": "This folder has no content at this time.",
    "This is a special group representing a department.": "This is a special group representing a department.",
    "This is required": "This is required",
    "This library has been set to read-only by admin and cannot be updated.": "This library has been set to read-only by admin and cannot be updated.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "This library has been shared to {user_amount} user(s) and {group_amount} group(s).",
    "This library is password protected": "Deze bibliotheek is beveiligd met een wachtwoord",
    "This month": "This month",
    "This operation will not be reverted. Please think twice!": "Deze handeling kan niet ongedaan gemaakt worden",
    "This property can not be deleted": "This property can not be deleted",
    "This property does not support sorting": "This property does not support sorting",
    "This property is not editable": "This property is not editable",
    "This user has not created or joined any groups": "Deze gebruiker is nog geen lid of heeft nog geen groepen aangemaakt",
    "This week": "This week",
    "This year": "This year",
    "Thumbnail": "Thumbnail",
    "Time": "Tijd:",
    "Tip: -2 means no limit.": "Tip: -2 means no limit.",
    "Tip: 0 means default limit": "Tip: 0 betekent standaard limiet",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Tip: Er wordt na iedere wijziging een momentopname gegenereerd, die de status van de bibliotheek na de wijziging opslaat.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.",
    "Tip: you can search by keyword in name or ID.": "Tip: you can search by keyword in name or ID.",
    "Tip: you can search by keyword in name.": "Tip: you can search by keyword in name.",
    "Today": "Today",
    "Token": "Token",
    "Token:": "Token:",
    "Tomorrow": "Tomorrow",
    "Too many requests": "Too many requests",
    "Total Devices": "Totaal aantal apparaten",
    "Total Storage": "Total Storage",
    "Total Users": "Totaal aantal gebruikers",
    "Traffic": "Verkeer",
    "Transfer": "Overzetten",
    "Transfer Group": "Groep overzetten",
    "Transfer Group {placeholder} to": "Transfer Group {placeholder} to",
    "Transfer Library": "Bibliotheek overzetten",
    "Transfer Library {library_name}": "Transfer Library {library_name}",
    "Transfer group to": "Transfer group to",
    "Transfer to department": "Transfer to department",
    "Transfer to user": "Transfer to user",
    "Transferred group {group_name} from {user_from} to {user_to}": "Groep {group_name} van {user_from} naar {user_to} overgezet",
    "Transferred library {library_name} from {user_from} to {user_to}": "Bibliotheek {library_name} van {user_from} naar {user_to} overgezet",
    "Trash": "Prullenbak",
    "Turn off": "Turn off",
    "Turn off extended properties": "Turn off extended properties",
    "Turn on extensible properties and views to experience a new way of managing files": "Turn on extensible properties and views to experience a new way of managing files",
    "Two-Factor Authentication": "Tweestapsauthenticatie",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "Tweestapsauthenticatie is niet ingeschakeld voor je account. Schakel tweestapsauthenticatie in voor uitgebreide accountbeveiliging.",
    "Type": "Type",
    "Type characters to start search": "Type characters to start search",
    "URL is copied to the clipboard": "URL is copied to the clipboard",
    "URL is required": "URL is required",
    "US": "US",
    "Undo": "Undo",
    "Unfreeze Document": "Unfreeze Document",
    "Unhandled": "Unhandled",
    "Unknown": "Onbekend",
    "Unlink": "Ontkoppelen",
    "Unlink device": "Apparaat ontkoppelen",
    "Unlock": "Deblokkeer",
    "Unselect": "Unselect",
    "Unshare": "Delen intrekken",
    "Unshare Library": "Delen ongedaan maken",
    "Unstar": "Ongedaan maken van favoriet",
    "Untitled": "Untitled",
    "Unwatch File Changes": "Unwatch File Changes",
    "Up": "Up",
    "Update": "Bijwerken",
    "Update Terms and Conditions": "Voorwaarden bijwerken",
    "Update password": "Update password",
    "Update succeeded.": "Update succeeded.",
    "Updated draft": "Updated draft",
    "Updated file": "Bestand bijgewerkt",
    "Upgrade to Pro Edition": " Opwaarderen naar de Pro editie",
    "Upload": "Upload",
    "Upload Files": "Bestanden Uploaden",
    "Upload Folder": "Map uploaden",
    "Upload Link": "Upload Link",
    "Upload Links": "Uploadlinks",
    "Upload file": "Upload bestand",
    "Upload license": "Upload license",
    "Upload link is copied to the clipboard.": "Upload link is copied to the clipboard.",
    "Uploading...": "Uploading...",
    "Use custom CSS": "Aangepaste CSS gebruiken",
    "Use information from your Identity Provider to configure Seafile": "Use information from your Identity Provider to configure Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.",
    "Use these values to configure your Identity Provider": "Use these values to configure your Identity Provider",
    "Used:": "Gebruikt:",
    "User": "Gebruiker",
    "User Permission": "Gebruikersrechten",
    "User Shares": "User Shares",
    "User Storage": "User Storage",
    "User can not see this folder.": "User can not see this folder.",
    "User can only view files online via browser. Files can't be downloaded.": "User can only view files online via browser. Files can't be downloaded.",
    "User can read, download and sync files.": "User can read, download and sync files.",
    "User can read, write, upload, download and sync files.": "User can read, write, upload, download and sync files.",
    "User can view and edit file online via browser. Files can't be downloaded.": "User can view and edit file online via browser. Files can't be downloaded.",
    "User info updated": "User info updated",
    "User migrate from {user_from} to {user_to}": "User migrate from {user_from} to {user_to}",
    "User not found": "User not found",
    "User {user_link} has added you to {group_link}": "User {user_link} has added you to {group_link}",
    "Username:": "Gebruikersnaam:",
    "Users": "Gebruikers",
    "Verified": "Verified",
    "Verify": "Verify",
    "Verify Domain": "Verify Domain",
    "Version": "Versie",
    "Version Number": "Versienummer",
    "Version Number is required.": "Version Number is required.",
    "Version Number must be a number.": "Version Number must be a number.",
    "Video": "Video",
    "View": "Bekijken",
    "View Link": "View Link",
    "View Related Snapshot": "View Related Snapshot",
    "View Snapshot": "Bekijk Snapshot",
    "View profile and more": "Profiel en meer weergeven",
    "Views": "Views",
    "Virus": "Virus",
    "Virus File": "Virusbestand",
    "Virus Scan": "Virusscan",
    "Visit count": "Visit count",
    "Visit old version page": "Visit old version page",
    "Visited": "Visited",
    "Visits": "Bezoeken",
    "Watch File Changes": "Watch File Changes",
    "Web API Auth Token": "Web API Auth Token",
    "Web Download": "Webdownload",
    "Web Upload": "Webupload",
    "WebDAV Access": "WebDAV Access",
    "WebDAV password:": "WebDAV password:",
    "WebDAV username:": "WebDAV username:",
    "Wiki custom URL deleted": "Wiki custom URL deleted",
    "Wiki owner": "Wiki owner",
    "Wiki published": "Wiki published",
    "Wikis": "Wikis",
    "Wrong password": "Verkeerd wachtwoord",
    "Year": "Year",
    "Yesterday": "Yesterday",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Je kunt ook een gebruiker als gast toevoegen die geen permissies heeft om gebruikers en bibliotheken aan te maken.",
    "You can create files quickly": "You can create files quickly",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "You can enter multiple emails. An invitation link will be sent to each of them.",
    "You can use this field at login.": "Je kunt dit veld tijdens het aanmelden gebruiken",
    "You do not have permission": "You do not have permission",
    "You don't have any favorite items yet": "You don't have any favorite items yet",
    "You don't have any share links": "You don't have any share links",
    "You don't have any upload links": "You don't have any upload links",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.",
    "You have not shared any folders": "Je hebt geen mappen gedeeld",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".",
    "Your notifications will be sent to this email.": "Je meldingen zullen naar dit e-mailadres worden verzonden.",
    "ZIP": "ZIP",
    "Zoom in": "Inzoomen",
    "Zoom out": "Uitzoomen",
    "all": "alle",
    "all members": "alle leden",
    "contains": "contains",
    "days": "dagen",
    "deleted": "verwijderd",
    "deleted option": "deleted option",
    "details": "details",
    "does not contain": "does not contain",
    "email is required": "e-mail is verplicht",
    "freezed": "freezed",
    "has all of...": "has all of...",
    "has any of...": "has any of...",
    "has none of...": "has none of...",
    "icon": "icoon",
    "in all libraries": "in all libraries",
    "include the current user": "include the current user",
    "is": "is",
    "is after...": "is after...",
    "is any of...": "is any of...",
    "is before...": "is before...",
    "is current user's ID": "is current user's ID",
    "is empty": "is empty",
    "is exactly...": "is exactly...",
    "is none of...": "is none of...",
    "is not": "is not",
    "is not empty": "is not empty",
    "is on or after...": "is on or after...",
    "is on or before...": "is on or before...",
    "is within...": "is within...",
    "items": "items",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}",
    "locked": "Geblokkeerd",
    "locked by {name}": "locked by {name}",
    "mm": "mm",
    "name": "naam",
    "not set": "not set",
    "only show {placeholder}": "only show {placeholder}",
    "progress": "voortgang",
    "s": "s",
    "selected": "selected",
    "show more": "show more",
    "size": "grootte",
    "sorts": "sorts",
    "starred": "favoriet",
    "successfully added user %s.": "successfully added user %s.",
    "successfully sent email to %s.": "successfully sent email to %s.",
    "unstarred": "geen favoriet",
    "xxx cells copied": "xxx cells copied",
    "xxx cells selected": "xxx cells selected",
    "xxx record": "xxx record",
    "xxx records": "xxx records",
    "xxx records selected": "xxx records selected",
    "xxx rows are copied.": "xxx rows are copied.",
    "you can also press \u2192": "you can also press \u2192",
    "{failed_files_num} file(s) failed to upload": "{failed_files_num} file(s) failed to upload",
    "{file} and {n} other files": "{file} and {n} other files",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} days",
    "{number_placeholder} / Page": "{number_placeholder} / Page",
    "{placeholder} Access Log": "{placeholder} Access Log",
    "{placeholder} Folder Permission": "{placeholder} Map toegangsrechten",
    "{placeholder} History Setting": "{placeholder} Geschiedenis instellingen",
    "{placeholder} Modification History": "{placeholder} Modification History",
    "{placeholder} Share Admin": "{placeholder} Share Admin",
    "{placeholder} Snapshot": "{placeholder} Snapshot",
    "{placeholder} Trash": "{placeholder} Trash",
    "{placeholder} Wiki Trash": "{placeholder} Wiki Trash",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} has cancelled the sharing of folder {repo_name}.",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} has cancelled the sharing of library {repo_name}.",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} has changed the permission of folder {repo_link} to {permission}.",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} has changed the permission of library {repo_link} to {permission}.",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} has shared a folder named {repo_link} to group {group_link}.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} has shared a folder named {repo_link} to you.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} has shared a library named {repo_link} to group {group_link}.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} has shared a library named {repo_link} to you.",
    "{uploaded_files_num}/{all_files_num} Files": "{uploaded_files_num}/{all_files_num} Files",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} created file {fileName} in library {libraryName}.": "{user} created file {fileName} in library {libraryName}.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} created folder {folderName} in library {libraryName}.": "{user} created folder {folderName} in library {libraryName}.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} deleted file {fileName} in library {libraryName}.": "{user} deleted file {fileName} in library {libraryName}.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} deleted folder {folderName} in library {libraryName}.": "{user} deleted folder {folderName} in library {libraryName}.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} moved file {fileName} in library {libraryName}.": "{user} moved file {fileName} in library {libraryName}.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} moved folder {folderName} in library {libraryName}.": "{user} moved folder {folderName} in library {libraryName}.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "{user} renamed file {oldFileName} {fileName} in library {libraryName}.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.",
    "{user} restored file {fileName} in library {libraryName}.": "{user} restored file {fileName} in library {libraryName}.",
    "{user} restored folder {folderName} in library {libraryName}.": "{user} restored folder {folderName} in library {libraryName}.",
    "{user} updated file {fileName} in library {libraryName}.": "{user} updated file {fileName} in library {libraryName}."
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "j F Y H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d-%m-%Y %H:%M:%S",
      "%d-%m-%y %H:%M:%S",
      "%Y-%m-%d %H:%M:%S",
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%y %H:%M:%S",
      "%Y/%m/%d %H:%M:%S",
      "%d-%m-%Y %H:%M:%S.%f",
      "%d-%m-%y %H:%M:%S.%f",
      "%Y-%m-%d %H:%M:%S.%f",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%y %H:%M:%S.%f",
      "%Y/%m/%d %H:%M:%S.%f",
      "%d-%m-%Y %H.%M:%S",
      "%d-%m-%y %H.%M:%S",
      "%d/%m/%Y %H.%M:%S",
      "%d/%m/%y %H.%M:%S",
      "%d-%m-%Y %H.%M:%S.%f",
      "%d-%m-%y %H.%M:%S.%f",
      "%d/%m/%Y %H.%M:%S.%f",
      "%d/%m/%y %H.%M:%S.%f",
      "%d-%m-%Y %H:%M",
      "%d-%m-%y %H:%M",
      "%Y-%m-%d %H:%M",
      "%d/%m/%Y %H:%M",
      "%d/%m/%y %H:%M",
      "%Y/%m/%d %H:%M",
      "%d-%m-%Y %H.%M",
      "%d-%m-%y %H.%M",
      "%d/%m/%Y %H.%M",
      "%d/%m/%y %H.%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "j F Y",
    "DATE_INPUT_FORMATS": [
      "%d-%m-%Y",
      "%d-%m-%y",
      "%d/%m/%Y",
      "%d/%m/%y",
      "%Y/%m/%d",
      "%Y-%m-%d"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "j F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "j-n-Y H:i",
    "SHORT_DATE_FORMAT": "j-n-Y",
    "THOUSAND_SEPARATOR": ".",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H.%M:%S",
      "%H.%M:%S.%f",
      "%H.%M",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

