
'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(Si queda en blanco, el propietario ser\u00e1 admin)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "Debe tener al menos {passwordMinLength} caracteres y incluir {passwordStrengthLevel} de los siguientes: n\u00famero, letra may\u00fascula, letra min\u00fascula y otros s\u00edmbolos.",
    "(at least {placeholder} characters)": "(al menos {placeholder} caracteres)",
    "(current notification)": "(notificaci\u00f3n actual)",
    "(current version)": "(versi\u00f3n actual)",
    "(deleted)": "(eliminado)",
    "1 Hidden property": "1 Propiedad oculta",
    "1 Year": "1 a\u00f1o",
    "1 cell copied": "1 celda copiada",
    "1 cell cut": "1 celda recortada",
    "1 filter": "1 filtro",
    "1 hidden property": "1 propiedad oculta",
    "1 month ago": "m\u00e1s de 1 mes",
    "1 preset hidden property": "1 propiedad oculta preestablecida",
    "1 record selected": "1 registro seleccionado",
    "1 row is copied.": "1 fila copiada.",
    "1 sort": "1 orden",
    "1 week ago": "m\u00e1s de 1 semana",
    "3 days ago": "m\u00e1s de 3 d\u00edas",
    "30 Days": "30 d\u00edas",
    "7 Days": "7 d\u00edas",
    "A file is being uploaded. Are you sure you want to leave this page?": "Un archivo est\u00e1 siendo subido, \u00bfest\u00e1s seguro que deseas abandonar esta p\u00e1gina?",
    "A file named {upload_file_link} is uploaded to {uploaded_link}.": "Un archivo llamado {upload_file_link} es subido a {uploaded_link}.",
    "A file named {upload_file_link} is uploaded.": "A file named {upload_file_link} is uploaded.",
    "A file with the same name already exists in this folder.": "Ya existe un archivo con el mismo nombre en esta carpeta.",
    "A folder named {upload_folder_link} is uploaded to {uploaded_link}.": "A folder named {upload_folder_link} is uploaded to {uploaded_link}.",
    "A folder named {upload_folder_link} is uploaded.": "A folder named {upload_folder_link} is uploaded.",
    "AI": "AI",
    "AI credit used this month": "Cr\u00e9dito de IA utilizado este mes",
    "AI credit used:": "Cr\u00e9ditos de IA usados:",
    "API Token": "API Token",
    "API token is copied to the clipboard.": "API token copiado al portapapeles.",
    "About": "Acerca de",
    "About Us": "Acerca de nosotros",
    "Abuse Content": "Contenido Abusivo",
    "Abuse Reports": "Informe de Abuso",
    "Abuse Type": "Tipo de Abuso",
    "Abuse report added": "Informe de abuso agregado",
    "Accept": "Aceptar",
    "Accepted": "Aceptada",
    "Accepted at": "Acepta en",
    "Accepter": "Acepta",
    "Access Log": "Registro de Acceso",
    "Access scope": "\u00c1mbito de acceso",
    "Accurate to minute": "Preciso hasta el minuto",
    "Action": "Acci\u00f3n",
    "Actions": "Acciones",
    "Activate after registration": "Activar despu\u00e9s del registro",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Activar el usuario inmediatamente despu\u00e9s del registro. Si est\u00e1 desmarcado, el usuario necesita ser activado por un administrador o mediante un email de activaci\u00f3n",
    "Activated": "Activado",
    "Activated Users": "Usuarios activados",
    "Active": "Activo",
    "Active Users": "Usuarios Activos",
    "Active users": "Usuarios activos",
    "Activities": "Actividades",
    "Actual size": "Tama\u00f1o original",
    "Add": "Agregar",
    "Add Admin": "Agregar Admin",
    "Add Folder": "A\u00f1adir Carpeta",
    "Add Institution": "Agregar Instituci\u00f3n",
    "Add Library": "Agregar Biblioteca",
    "Add Member": "Agregar Miembro",
    "Add Organization": "Agregar Organizaci\u00f3n",
    "Add Terms and Conditions": "Agregar T\u00e9rminos y Condiciones",
    "Add User": "Agregar Usuario",
    "Add User to Group": "A\u00f1adir usuario al grupo",
    "Add Wiki": "Agregar Wiki",
    "Add admin": "Agregar admin",
    "Add auto expiration": "Agregar vencimiento autom\u00e1tico",
    "Add column": "Agregar columna",
    "Add cover": "Agregar portada",
    "Add custom permission": "Agregar permiso personalizado",
    "Add department at": "Agregar departamento en",
    "Add filter": "Agregar filtro",
    "Add group": "Agregar grupo",
    "Add group member": "Agregar miembro al grupo",
    "Add icon": "Agregar icono",
    "Add institution": "Agregar Instituci\u00f3n",
    "Add member": "A\u00f1adir miembro",
    "Add members": "Agregar miembros",
    "Add new notification": "Agregar nueva notificaci\u00f3n",
    "Add option": "A\u00f1adir opci\u00f3n",
    "Add option: %s": "Agregar opci\u00f3n: %s",
    "Add page": "Agregar p\u00e1gina",
    "Add page above": "Agregar p\u00e1gina arriba",
    "Add page below": "Agregar p\u00e1gina abajo",
    "Add page inside": "Agregar p\u00e1gina dentro",
    "Add password protection": "Agregar protecci\u00f3n por contrase\u00f1a",
    "Add permission": "Agregar permiso",
    "Add sort": "Agregar orden",
    "Add sub-department": "Agregar subdepartamento",
    "Add tag": "Agregar etiqueta",
    "Add to groups": "Agregar a grupos",
    "Add user": "Agregar usuario",
    "Add view": "A\u00f1adir vista",
    "Added": "Agregado",
    "Added a new comment in document {sdoc_link}:": "Se ha agregado un nuevo comentario en el documento {sdoc_link}:",
    "Added a new reply in document {sdoc_link}:": "Se ha agregado una nueva respuesta en el documento {sdoc_link}:",
    "Added user {user}": "Usuario {user} agregado",
    "Added user {user} to group {group}": "Se a\u00f1adi\u00f3 el usuario {user} al grupo {group}",
    "Address": "Direcci\u00f3n",
    "Admin": "Administrar",
    "Admin Login Logs": "Registros de ingreso de Admin",
    "Admin Logs": "Registros de Admin",
    "Admin Operation Logs": "Registros de operaciones de Admin",
    "Admin access": "Acceso de administrador",
    "Admin updated": "Administrador actualizado",
    "Admins": "Administradores",
    "Advanced": "Avanzado",
    "After": "Despu\u00e9s",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "Despu\u00e9s de habilitar las propiedades extendidas para archivos, puede agregar diferentes propiedades a los archivos, como colaboradores, fecha de vencimiento del archivo, descripci\u00f3n del archivo. Tambi\u00e9n puede crear diferentes vistas para archivos basadas en propiedades extendidas.",
    "After exceeding the traffic limit, the file download speed will be restricted.": "Despu\u00e9s de superar el l\u00edmite de tr\u00e1fico, la velocidad de descarga de archivos se restringir\u00e1.",
    "All": "Todas",
    "All Activities": "Todas las actividades",
    "All Groups": "Todos los grupos",
    "All Notifications": "Todas las notificaciones",
    "All Public Links": "Enlaces P\u00fablicos",
    "All comments": "Todos los comentarios",
    "All files uploaded": "Todos los archivos subidos",
    "All tags": "Todas las etiquetas",
    "Allow new registrations": "Permitir nuevos registros",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Permitir que nuevos usuarios se registren. Desmarcar \u00e9sto para que nadie pueda crear una nueva cuenta.",
    "Allow users to change library history settings": "Permitir que los usuarios cambien la configuraci\u00f3n del historial de la biblioteca",
    "Allow users to clean library trash": "Permitir que los usuarios vac\u00eden la papelera de la biblioteca",
    "Allow users to create encrypted libraries": "Permitir que los usuarios creen bibliotecas encriptadas",
    "An integer that is greater than 0 or equal to -2.": "Un n\u00famero entero mayor que 0 o igual a -2.",
    "An integer that is greater than or equal to 0.": "Un n\u00famero entero mayor o igual que 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Un enlace interno es un enlace a un archivo o carpeta que puede ser accedido por usuarios con permiso de lectura al archivo o carpeta. ",
    "And": "Y",
    "Anonymous User": "Usuario An\u00f3nimo",
    "Another property has this property type": "Otra propiedad tiene este tipo de propiedad",
    "Another user is editing this file!": "\u00a1Otro usuario est\u00e1 editando este archivo!",
    "Anyone with the link": "Cualquier persona con el enlace",
    "App Name": "Nombre de App",
    "Are you sure to change group {placeholder} to department ?": "\u00bfEst\u00e1 seguro de cambiar el grupo {placeholder} a departamento?",
    "Are you sure to delete": "\u00bfEst\u00e1 seguro de eliminar?",
    "Are you sure to delete ": "\u00bfEst\u00e1s seguro de eliminar ",
    "Are you sure to delete this comment?": "\u00bfEst\u00e1 seguro de eliminar este comentario?",
    "Are you sure to delete this reply?": "\u00bfEst\u00e1 seguro de eliminar esta respuesta?",
    "Are you sure to revoke access of user {placeholder} ?": "\u00bfSeguro que quieres revocar el acceso del usuario {placeholder} ?",
    "Are you sure you want to clean invalid share links?": "\u00bfEst\u00e1 seguro de que desea limpiar los enlaces de uso compartido inv\u00e1lidos?",
    "Are you sure you want to clean invalid upload links?": "\u00bfEst\u00e1 seguro de que desea limpiar los enlaces de carga inv\u00e1lidos?",
    "Are you sure you want to clear trash?": "\u00bfSeguro que deseas vaciar la papelera?",
    "Are you sure you want to delete": "\u00bfEst\u00e1s seguro de que quieres eliminar?",
    "Are you sure you want to delete WebDAV password?": "\u00bfEst\u00e1 seguro de que desea eliminar la contrase\u00f1a WebDAV?",
    "Are you sure you want to delete Wiki": "\u00bfEst\u00e1 seguro de que desea eliminar la Wiki?",
    "Are you sure you want to delete the notification ?": "\u00bfEst\u00e1 seguro que desea borrar la notificaci\u00f3n?",
    "Are you sure you want to delete the selected share link(s) ?": "\u00bfEst\u00e1 seguro de que desea eliminar los enlaces de compartir seleccionados?",
    "Are you sure you want to delete the selected upload link(s) ?": "\u00bfEst\u00e1 seguro de que desea eliminar los enlaces de subida seleccionados?",
    "Are you sure you want to delete the selected user(s) ?": "\u00bfSeguro que deseas eliminar los usuarios selecionados?",
    "Are you sure you want to delete the share link?": "\u00bfEst\u00e1 seguro que desea eliminar el enlace de compartir?",
    "Are you sure you want to delete this option?": "\u00bfEst\u00e1 seguro que desea eliminar esta opci\u00f3n?",
    "Are you sure you want to delete this page?": "\u00bfSeguro que deseas borrar esta p\u00e1gina?",
    "Are you sure you want to delete {placeholder} ?": "\u00bfSeguro que quieres borrar {placeholder} ?",
    "Are you sure you want to delete {placeholder} completely?": "\u00bfEst\u00e1 seguro que desea eliminar {placeholder} completamente?",
    "Are you sure you want to disconnect?": "\u00bfSeguro que deseas desconectar?",
    "Are you sure you want to leave share Wiki": "\u00bfEst\u00e1 seguro de que desea dejar de compartir la Wiki?",
    "Are you sure you want to remove {placeholder} ?": "\u00bfSeguro que quieres eliminar {placeholder} ?",
    "Are you sure you want to reset the password of {placeholder} ?": "\u00bfEst\u00e1 seguro que desea restablecer la contrase\u00f1a de {placeholder} ?",
    "Are you sure you want to restore this library?": "\u00bfEst\u00e1s seguro que deseas restaurar est\u00e1 biblioteca?",
    "Are you sure you want to restore {placeholder}?": "\u00bfEst\u00e1 seguro que desea restaurar {placeholder} completamente?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "\u00bfEst\u00e1 seguro que desea revocar los permisos de administrador de {placeholder} ?",
    "Are you sure you want to set {placeholder} as Admin?": "\u00bfEst\u00e1 seguro que desea establecer a {placeholder} como Admin?",
    "Are you sure you want to set {user_placeholder} inactive?": "\u00bfEst\u00e1 seguro de que desea marcar como inactivo a {user_placeholder}?",
    "Are you sure you want to unlink this device?": "\u00bfEst\u00e1s seguro que deseas desvincular este dispositivo?",
    "Are you sure you want to unpublish Wiki": "\u00bfEst\u00e1 seguro de que desea dejar de publicar la Wiki?",
    "Are you sure you want to unshare {placeholder} ?": "\u00bfEst\u00e1 seguro que desea dejar de compartir {placeholder} ?",
    "Ascending by count": "Ascendente por recuento",
    "Ascending by creation time": "Ascendente por fecha de creaci\u00f3n",
    "Ascending by name": "Ascendente por nombre",
    "Ascending by role": "Ascendente por rol",
    "Ascending by size": "Ascendente por tama\u00f1o",
    "Ascending by space used": "Ascendente por espacio utilizado",
    "Ascending by time": "Ascendente por fecha",
    "Ascending by visit count": "Ascendente por recuento de visitas",
    "At server": "En el servidor",
    "Audio": "Audio",
    "Auth Token created": "Token de autenticaci\u00f3n creado",
    "Auth Token deleted": "Token de autenticaci\u00f3n eliminado",
    "Authenticated emails": "Correos electr\u00f3nicos autenticados",
    "Authenticated users": "Usuarios autenticados",
    "Auto deletion": "Eliminaci\u00f3n autom\u00e1tica",
    "Automatically delete files that are not modified within certain days:": "Eliminar autom\u00e1ticamente los archivos que no se modifican en determinado lapso de d\u00edas:",
    "Avatar": "Avatar",
    "Avatar updated": "Avatar updated",
    "Avatar:": "Avatar:",
    "Back": "Atr\u00e1s",
    "Basic": "B\u00e1sico",
    "Before": "Antes",
    "Bell Icon": "Icono de campana",
    "Besides Write permission, user can also share the library.": "Adem\u00e1s del permiso de escritura, el usuario tambi\u00e9n puede compartir la biblioteca.",
    "Billing": "Facturaci\u00f3n",
    "Branding": "Personalizar",
    "Broken (please contact your administrator to fix this library)": "Da\u00f1ada (por favor contacte al administrador para reparar esta biblioteca)",
    "Broken ({repo_id_placeholder})": "({repo_id_placeholder}) Da\u00f1ado",
    "By child tags count ascending": "Por n\u00famero de etiquetas hijas ascendente",
    "By child tags count descending": "Por n\u00famero de etiquetas hijas descendente",
    "By day": "Por d\u00eda",
    "By file count ascending": "Por n\u00famero de archivos ascendente",
    "By file count descending": "Por n\u00famero de archivos descendente",
    "By month": "Por mes",
    "By name ascending": "Por nombre ascendente",
    "By name descending": "Por nombre descendente",
    "By quarter": "Por trimestre",
    "By size ascending": "Por tama\u00f1o ascendente",
    "By size descending": "Por tama\u00f1o descendente",
    "By tag name ascending": "Por nombre de etiqueta ascendente",
    "By tag name descending": "Por nombre de etiqueta descendente",
    "By time ascending": "Por fecha ascendente",
    "By time descending": "Por fecha descendente",
    "By week": "Por semana",
    "By year": "Por a\u00f1o",
    "Can not copy folder %(src)s to its subfolder %(des)s": "No se puede copiar la carpeta %(src)s a su subcarpeta %(des)s",
    "Can not move folder %(src)s to its subfolder %(des)s": "No se puede mover la carpeta %(src)s a su subcarpeta %(des)s",
    "Can only copy files that are in the same folder": "Solo se pueden copiar archivos que se encuentren en la misma carpeta",
    "Can only download files that are in the same folder": "Solo se pueden descargar archivos que se encuentren en la misma carpeta",
    "Can only move files that are in the same folder": "Solo se pueden mover archivos que se encuentren en la misma carpeta",
    "Cancel": "Cancelar",
    "Cancel All": "Cancelar Todo",
    "Cannot move parent page to child page": "No se puede mover una p\u00e1gina padre a una p\u00e1gina hija",
    "Capture information": "Informaci\u00f3n de captura",
    "Capture time": "Tiempo de captura",
    "Card": "Tarjeta",
    "Certificate": "Certificado",
    "Change": "Cambiar",
    "Change Password": "Cambiar contrase\u00f1a",
    "Change Password of Library {placeholder}": "Cambiar Contrase\u00f1a de la Biblioteca {placeholder}",
    "Change cover": "Cambiar portada",
    "Change group to department": "Cambiar grupo a departamento",
    "Change to department": "Cambiar a departamento",
    "Change view type": "Cambiar tipo de vista",
    "Changes": "Cambios",
    "Checkbox": "Casilla de verificaci\u00f3n",
    "Child tags count": "N\u00famero de etiquetas hijas",
    "Choose date": "Escoja fecha",
    "Clean": "Limpiar",
    "Clean invalid share links": "Limpiar enlaces de uso compartido inv\u00e1lidos",
    "Clean invalid upload links": "Limpiar enlaces de carga inv\u00e1lidos",
    "Clean succeeded.": "Limpieza exitosa.",
    "Cleaned trash": "Papelera vac\u00eda",
    "Clear": "Limpiar",
    "Clear Trash": "Vaciar Papelera",
    "Clear files in trash and history\uff1a": "Limpiar archivos en la papelera y en el historial :",
    "Clear search": "Limpiar b\u00fasqueda",
    "Clear selected": "Borrar selecci\u00f3n",
    "Clients": "Clientes",
    "Close": "Cerrar",
    "Close (Esc)": "Cerrar (Esc)",
    "Close the panel": "Cerrar el panel",
    "Code": "C\u00f3digo",
    "Collaborator": "Colaborador",
    "Collaborators": "Colaboradores",
    "Collapse all": "Contraer todo",
    "Collected time": "Fecha de recolecci\u00f3n",
    "Color": "Color",
    "Color space": "Espacio de color",
    "Comma (1,000,000)": "Coma (1,000,000)",
    "Comma(1,03)": "Coma(1,03)",
    "Comment": "Comentar",
    "Comment details": "Detalles del comentario",
    "Comments": "Comentarios",
    "Community Edition": "Versi\u00f3n Community",
    "Compressed": "Comprimido",
    "Configure Seafile": "Configurar Seafile",
    "Configure your Identity Provider": "Configura tu Proveedor de Identidad",
    "Confirm": "Confirmar",
    "Confirm Password": "Confirmar contrase\u00f1a",
    "Confirm password": "Confirmar contrase\u00f1a",
    "Confluence export file": "Archivo de exportaci\u00f3n de Confluence",
    "Confluence file imported": "Archivo de Confluence importado",
    "Confluence imported": "Confluence importado",
    "Connect": "Conectar",
    "Contact Email": "Email de Contacto",
    "Contact Email:": "Email de contacto:",
    "Contact Information": "Informaci\u00f3n de contacto",
    "Contact email": "Correo electr\u00f3nico de contacto",
    "Contact information is required.": "Se requiere informaci\u00f3n de contacto.",
    "Content Scan Records": "Registros de An\u00e1lisis de Contenido",
    "Convert & Export": "Convertir y exportar",
    "Convert Wiki": "Convertir Wiki",
    "Convert to Markdown": "Convertir a Markdown",
    "Convert to docx": "Convertir a docx",
    "Convert to new Wiki": "Convertir a nueva Wiki",
    "Convert to sdoc": "Convertir a sdoc",
    "Convert with ONLYOFFICE": "Convertir con ONLYOFFICE",
    "Converting": "Convirtiendo",
    "Converting, please wait...": "Convirtiendo, por favor espere...",
    "Converting...": "Convirtiendo...",
    "Copied": "Copiado",
    "Copied link to clipboard": "Enlace copiado al portapapeles",
    "Copy": "Copiar",
    "Copy failed": "Error al copiar",
    "Copy link": "Copiar enlace",
    "Copy path": "Copiar ruta",
    "Copy selected": "Copiar selecci\u00f3n",
    "Copy selected item(s) to:": "Copiar item(s) seleccionados a:",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "Copie el certificado del IdP y p\u00e9guelo aqu\u00ed. El formato del certificado es el siguiente:",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "Copia el DNS TXT del dominio y agr\u00e9galo a los registros DNS de tu dominio, luego haz clic en el bot\u00f3n para verificar la propiedad del dominio. Debes verificar la propiedad del dominio antes del inicio de sesi\u00f3n \u00fanico.",
    "Copy {num} items": "Copiar {num} items",
    "Copy {placeholder} to": "Copiar {placeholder} a",
    "Copyright Infringement": "Violaci\u00f3n de derechos de autor",
    "Count": "Cuenta",
    "Cover": "Portada",
    "Cover photo set": "Foto de portada establecida",
    "Create": "Crear",
    "Create At": "Creado el",
    "Create Group": "Crear Grupo",
    "Create Library": "Crear Biblioteca",
    "Create Report": "Crear Informe",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Crea un registro DNS TXT para confirmar la propiedad de tu Dominio de Correo Electr\u00f3nico.",
    "Create a new tag": "Cear una nueva etiqueta",
    "Create time": "Fecha de creaci\u00f3n",
    "Create top department": "Crear departamento superior",
    "Created": "Creado",
    "Created At": "Creado En",
    "Created Files": "Archivos Creados",
    "Created draft": "Borrador creado",
    "Created file": "Archivo creado",
    "Created folder": "Carpeta creada",
    "Created group {group_name}": "Grupo {group_name} creado",
    "Created library": "Biblioteca creada",
    "Created library {library_name} with {owner} as its owner": "Biblioteca {library_name} creada con {owner} como su propietario",
    "Created time": "Hora de creaci\u00f3n",
    "Created {n} files": "Creado {n} archivos",
    "Creator": "Creador",
    "Currency symbol is required": "Se requiere s\u00edmbolo de moneda",
    "Current Connected Devices": "Dispositivos Conectados Actualmente",
    "Current Library": "Biblioteca actual",
    "Current Path: ": "Ruta actual:",
    "Current Version": "Versi\u00f3n Actual",
    "Current page": "P\u00e1gina actual",
    "Current password": "Contrase\u00f1a actual",
    "Current password cannot be blank": "La contrase\u00f1a no puede estar en blanco",
    "Current path: ": "Ruta actual:",
    "Custom CSS": "CSS personalizado",
    "Custom currency": "Moneda personalizada",
    "Custom properties": "Propiedades personalizadas",
    "Custom sharing permissions": "Permisos de compartir personalizados",
    "Custom symbol": "S\u00edmbolo personalizado",
    "Custom time": "Tiempo personalizado",
    "Customer Portal": "Portal de Clientes",
    "Customize URL": "Personalizar URL",
    "DNS TXT Value": "Valor DNS TXT",
    "Dark mode": "Modo oscuro",
    "Date": "Fecha",
    "Date Invalid.": "Fecha inv\u00e1lida.",
    "Day": "D\u00eda",
    "Decimal separator": "Separador decimal",
    "Decrypt document": "Descifrar documento",
    "Default": "Predeterminado",
    "Delete": "Borrar",
    "Delete Account": "Eliminar Cuenta",
    "Delete Department": "Eliminar Departamento",
    "Delete Expired Invitations": "Borrar invitaciones vencidas",
    "Delete File": "Eliminar Archivo",
    "Delete Folder": "Eliminar Carpeta",
    "Delete Group": "Borrar Grupo",
    "Delete Institution": "Eliminar Instituci\u00f3n",
    "Delete Library": "Eliminar Biblioteca",
    "Delete Member": "Eliminar Miembro",
    "Delete Notification": "Borrar notificaci\u00f3n",
    "Delete Organization": "Borrar organizaci\u00f3n",
    "Delete Password": "Eliminar Contrase\u00f1a",
    "Delete T&C": "Eliminar T&C",
    "Delete Team": "Eliminar Equipo",
    "Delete User": "Eliminar usuario",
    "Delete User from Group": "Eliminar usuario del grupo",
    "Delete Users": "Eliminar Usuarios",
    "Delete WebDAV Password": "Eliminar contrase\u00f1a WebDAV",
    "Delete Wiki": "Eliminar Wiki",
    "Delete department": "Eliminar departamento",
    "Delete file": "Eliminar archivo",
    "Delete files from this device the next time it comes online.": "Eliminar archivos de este dispositivo la pr\u00f3xima vez que est\u00e9 en l\u00ednea.",
    "Delete folder": "Eliminar carpeta",
    "Delete group": "Eliminar grupo",
    "Delete location": "Eliminar ubicaci\u00f3n",
    "Delete member": "Eliminar miembro",
    "Delete page": "Eliminar p\u00e1gina",
    "Delete property": "Eliminar propiedad",
    "Delete selected": "Eliminar selecci\u00f3n",
    "Delete share link": "Eliminar enlace de compartir",
    "Delete share links": "Eliminar enlaces de compartir",
    "Delete tag": "Eliminar etiqueta",
    "Delete tags": "Eliminar etiquetas",
    "Delete upload links": "Eliminar enlaces de subida",
    "Deleted": "Borrado",
    "Deleted Libraries": "Bibliotecas eliminadas",
    "Deleted Time": "Fecha de eliminaci\u00f3n",
    "Deleted by": "Eliminado por",
    "Deleted directories": "Carpetas eliminadas",
    "Deleted draft": "Borrador eliminado",
    "Deleted file": "Archivo eliminado",
    "Deleted files": "Archivos eliminados",
    "Deleted folder": "Carpeta eliminada",
    "Deleted group {group_name}": "Grupo {group_name} eliminado",
    "Deleted library": "Biblioteca eliminada",
    "Deleted library {library_name}": "Biblioteca {library_name} eliminada",
    "Deleted option": "Opci\u00f3n eliminada",
    "Deleted time": "Tiempo eliminado",
    "Deleted user %s": "Deleted user %s",
    "Deleted user {user}": "Usuario {user} eliminado",
    "Deleted user {user} from group {group}": "Se elimin\u00f3 el usuario {user} del grupo {group}",
    "Department ID": "ID de departamento",
    "Department moved successfully": "Grupo movido con \u00e9xito",
    "Department not found": "Departamento no encontrado",
    "Department renamed": "Departamento renombrado",
    "Departments": "Departmentos",
    "Descending by count": "Descendente por recuento",
    "Descending by creation time": "Descendente por fecha de creaci\u00f3n",
    "Descending by files": "Descendente por archivos",
    "Descending by name": "Descendente por nombre",
    "Descending by role": "Descendente por rol",
    "Descending by size": "Descendente por tama\u00f1o",
    "Descending by space used": "Descendente por espacio utilizado",
    "Descending by time": "Descendente por fecha",
    "Descending by visit count": "Descendente por recuento de visitas",
    "Description": "Descripci\u00f3n",
    "Description generated": "Descripci\u00f3n generada",
    "Description is required": "Descripci\u00f3n requerida",
    "Desktop": "Escritorio",
    "Detail": "Detalles",
    "Details": "Detalles",
    "Detect faces": "Detectar caras",
    "Detecting faces by AI...": "Detectando caras por IA...",
    "Device": "Dispositivo",
    "Device Name": "Nombre de dispositivo",
    "Device make": "Fabricante del dispositivo",
    "Device model": "Modelo del dispositivo",
    "Devices": "Dispositivos",
    "Diagram": "Diagrama",
    "Dimensions": "Dimensiones",
    "Direct download link": "Enlace de descarga directa",
    "Direct download link is copied to the clipboard.": "Enlace de descarga directa copiado al portapapeles.",
    "Disable SSO user email / password login": "Deshabilitar inicio de sesi\u00f3n de usuario con correo electr\u00f3nico / contrase\u00f1a si la cuenta SAML est\u00e1 vinculada",
    "Disable Two-Factor Authentication": "Deshabilitar Autenticaci\u00f3n de dos Factores",
    "Disable sync with any folder": "Desactivar sincronizaci\u00f3n con cualquier carpeta",
    "Disable user clean trash": "Deshabilitar limpieza de papelera por parte del usuario",
    "Disconnect": "Desconectar",
    "Discussion": "Discusi\u00f3n",
    "Display files": "Mostrar archivos",
    "Do not automatically delete files": "No eliminar autom\u00e1ticamente los archivos",
    "Do not keep sharing": "No mantener compartici\u00f3n",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "\u00bfRealmente quieres desactivar las propiedades extendidas? Todas las propiedades existentes se eliminar\u00e1n.",
    "Do you really want to turn off face recognition? Existing results will all be deleted.": "\u00bfRealmente desea desactivar el reconocimiento facial? Todos los resultados existentes ser\u00e1n eliminados.",
    "Do you really want to turn off tags? Existing tags will all be deleted.": "\u00bfRealmente quieres desactivar las etiquetas? Todas las etiquetas existentes se eliminar\u00e1n.",
    "Do you want to keep the library sharing relationships?": "\u00bfDeseas mantener las relaciones de compartici\u00f3n de bibliotecas?",
    "Document": "Documento",
    "Document conversion failed.": "La conversi\u00f3n del documento fall\u00f3.",
    "Document keywords": "Palabras clave del documento",
    "Dollar": "D\u00f3lar",
    "Domain verified": "Dominio verificado",
    "Don't ignore": "No ignorar",
    "Don't keep history": "No mantener historial",
    "Don't replace": "No reemplazar",
    "Don't send emails": "No enviar emails",
    "Don't show empty values": "No mostrar valores vac\u00edos",
    "Done": "Hecho",
    "Dot(1.03)": "Punto(1.03)",
    "Down": "Abajo",
    "Download": "Descargar",
    "Download Rate Limit": "L\u00edmite de velocidad de descarga",
    "Download an example file": "Descargar un archivo de ejemplo",
    "Download and upload": "Descargar y subir",
    "Drag and drop files or folders here.": "Arrastrar y soltar archivos aqu\u00ed.",
    "Duplicate": "Duplicar",
    "Duplicate page": "Duplicar p\u00e1gina",
    "Edit": "Editar",
    "Edit format settings": "Editar configuraciones de formato",
    "Edit labels": "Editar etiquetas",
    "Edit metadata properties": "Editar propiedades de metadatos",
    "Edit multiple select": "Editar selecci\u00f3n m\u00faltiple",
    "Edit on cloud and download": "Editar en la nube y descargar",
    "Edit on cloud only": "Editar s\u00f3lo en la nube",
    "Edit permission": "Editar permiso",
    "Edit single select": "Editar selecci\u00f3n \u00fanica",
    "Edit succeeded": "Editado con \u00e9xito",
    "Edit succeeded.": "Editado con \u00e9xito.",
    "Edit tag": "Editar etiqueta",
    "Email": "Email",
    "Email Domain": "Dominio de correo electr\u00f3nico",
    "Email Notification": "Email de notificaci\u00f3n",
    "Email is invalid.": "Email es inv\u00e1lido",
    "Email notification updated": "Notificaci\u00f3n por correo electr\u00f3nico actualizada",
    "Emails": "Emails",
    "Emails, separated by ','": "Emails, separados por ','",
    "Emojis": "Emojis",
    "Empty": "Vac\u00edo",
    "Enable Two-Factor Authentication": "Habilitar Autenticaci\u00f3n de dos Factores",
    "Enable branding CSS": "Habilitar CSS de marca",
    "Enable departments feature": "Habilitar la funci\u00f3n de departamentos",
    "Enable extended properties": "Habilitar propiedades extendidas",
    "Enable face recognition to identify people in your photos.": "Habilite el reconocimiento facial para identificar personas en sus fotos.",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Habilitar al administrador del sistema a agregar T\u00e9rminos y Condiciones, y todos los usuarios deber\u00e1n aceptar los t\u00e9rminos.",
    "Enable tags to add tags to files and search files by tags.": "Habilita las etiquetas para agregar etiquetas a archivos y buscar archivos por etiquetas.",
    "Enable terms and conditions": "Habilitar t\u00e9rminos y condiciones",
    "Enable two factor authentication": "Habilitar autenticaci\u00f3n de dos factores",
    "Enable users to clean trash": "Permitir que los usuarios vac\u00eden la papelera",
    "Enable users to share libraries to any groups in the system.": "Habilitar que los usuarios puedan compartir bibliotecas con cualquier grupo en el sistema.",
    "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups": "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups",
    "Encrypt": "Encriptar",
    "Encrypted library": "Biblioteca encriptada",
    "End date": "Fecha Fin",
    "Enforce precision": "Forzar precisi\u00f3n",
    "Enter characters to start searching": "Ingrese caracteres para comenzar la b\u00fasqueda",
    "Enter custom currency symbol": "Introduzca s\u00edmbolo de moneda personalizado",
    "Enter date": "Introducir fecha",
    "Error": "Error",
    "Errors": "Errores",
    "Euro": "Euro",
    "European": "Europeo",
    "Exact date": "Fecha exacta",
    "Exit Institution Admin": "Salir de Administrador de la Instituci\u00f3n",
    "Exit Organization Admin": "Salir de Administrador de la Organizaci\u00f3n",
    "Exit System Admin": "Salir de Administrador",
    "Expand all": "Expandir todo",
    "Expiration": "Vencimiento",
    "Expiration date": "Fecha de expiraci\u00f3n",
    "Expiration days": "D\u00edas de vencimiento",
    "Expiration time": "Tiempo de vencimiento",
    "Expired": "Expirado",
    "Expired at": "Vencido en",
    "Export": "Exportar",
    "Export Excel": "Exportar Excel",
    "Export as Markdown": "Exportar como Markdown",
    "Export as docx": "Exportar como docx",
    "Export as sdoc": "Exportar como sdoc",
    "Export as zip": "Exportar como zip",
    "Export options": "Exportar opciones",
    "Export tags": "Exportar etiquetas",
    "Exporting": "Exportando",
    "Exporting...": "Exportando...",
    "Exposure time": "Tiempo de exposici\u00f3n",
    "Extended properties": "Propiedades extendidas",
    "Extension Prompts": "Prompts de extensi\u00f3n",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Extensiones de los archivos de texto con vista previa en l\u00ednea, sufijos separados por una coma.",
    "Extract file detail": "Extraer detalles del archivo",
    "Extract file details": "Extraer detalles del archivo",
    "Extract text": "Extraer texto",
    "Extracting file details by AI...": "Extrayendo detalles del archivo por IA...",
    "Extracting text, please wait...": "Extrayendo texto, por favor espere...",
    "F number": "N\u00famero de apertura",
    "Face recognition": "Reconocimiento facial",
    "Face recognition is done for library {libraryName}.": "Reconocimiento facial completado para la biblioteca {libraryName}.",
    "Faces detected": "Caras detectadas",
    "Failed": "Fall\u00f3",
    "Failed imported options": "Error al importar opciones",
    "Failed to add linked tags": "Error al agregar etiquetas vinculadas",
    "Failed to add people photos": "No se pudieron agregar las fotos de la persona",
    "Failed to add tags": "Error al agregar etiquetas",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "Fallo al agregar {email_placeholder}: {error_msg_placeholder}",
    "Failed to convert {name}.": "No se pudo convertir {name}.",
    "Failed to copy %(name)s": "Fallo al copiar %(name)s",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Fallo al copiar %(name)s y %(amount)s otros item(s).",
    "Failed to copy %(name)s.": "Fallo al copiar %(name)s.",
    "Failed to copy file": "No se pudo copiar el archivo",
    "Failed to copy files to another library.": "Fallo al copiar archivos a otra biblioteca.",
    "Failed to copy {n} items": "No se pudieron copiar {n} elementos",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Fallo al eliminar %(virus_file) de la biblioteca %(library): %(error_msg)",
    "Failed to delete linked tags": "Error al eliminar etiquetas vinculadas",
    "Failed to delete property": "No se pudo eliminar la propiedad",
    "Failed to delete records": "No se pudieron eliminar los registros",
    "Failed to delete tags": "Error al eliminar etiquetas",
    "Failed to delete {name}": "Fallo al eliminar {name}",
    "Failed to delete {name} and {n} other items.": "No se pudieron eliminar {name} y {n} elementos adicionales.",
    "Failed to delete {name}.": "Fallo al eliminar {name}.",
    "Failed to detect faces": "Error al detectar caras",
    "Failed to download. The total size of the files exceeded the limit.": "Descarga fallida. El tama\u00f1o total de los archivos excede el l\u00edmite.",
    "Failed to duplicate file": "No se pudo duplicar el archivo",
    "Failed to duplicate folder": "No se pudo duplicar la carpeta",
    "Failed to duplicate page": "Error al duplicar p\u00e1gina",
    "Failed to export tags": "Error al exportar etiquetas",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "Exportaci\u00f3n fallida. Por favor, verifique si el tama\u00f1o de los adjuntos de la tabla excede el l\u00edmite.",
    "Failed to extract file details": "Error al extraer detalles del archivo",
    "Failed to extract text": "Error al extraer texto",
    "Failed to generate description": "Error al generar descripci\u00f3n",
    "Failed to generate file tags": "Error al generar etiquetas de archivo",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Fallo al ignorar %(virus_file) de la biblioteca %(library): %(error_msg)",
    "Failed to import Confluence": "Error al importar Confluence",
    "Failed to import Confluence file": "Error al importar archivo de Confluence",
    "Failed to import page": "Error al importar p\u00e1gina",
    "Failed to import tags": "Error al importar etiquetas",
    "Failed to insert property": "No se pudo insertar la propiedad",
    "Failed to merge tags": "Error al unir etiquetas",
    "Failed to modify filter": "No se pudo modificar el filtro",
    "Failed to modify group": "No se pudo modificar el grupo",
    "Failed to modify hidden properties": "No se pudieron modificar las propiedades ocultas",
    "Failed to modify people name": "No se pudo modificar el nombre de la persona",
    "Failed to modify property data": "No se pudo modificar los datos de la propiedad",
    "Failed to modify property order": "No se pudo modificar el orden de la propiedad",
    "Failed to modify records": "No se pudieron modificar los registros",
    "Failed to modify settings": "No se pudieron modificar la configuraci\u00f3n",
    "Failed to modify sort": "No se pudo modificar la clasificaci\u00f3n",
    "Failed to modify tags": "No se pudieron modificar las etiquetas",
    "Failed to move %(name)s and %(amount)s other item(s).": "Fallo al mover %(name)s y %(amount)s otros item(s).",
    "Failed to move %(name)s.": "Fallo al mover %(name)s.",
    "Failed to move file": "No se pudo mover el archivo",
    "Failed to move files to another library.": "Fallo al mover archivos a otra biblioteca.",
    "Failed to move folder": "No se pudo mover la carpeta",
    "Failed to move {name}.": "Fallo al mover {name}.",
    "Failed to move {n} items": "No se pudieron mover {n} elementos",
    "Failed to remove people photos": "No se pudieron eliminar las fotos de la persona",
    "Failed to rename property": "No se pudo renombrar la propiedad",
    "Failed to restore records": "No se pudieron restaurar los registros",
    "Failed to restore tags": "Error al restaurar etiquetas",
    "Failed to restore {name}": "No se pudo restaurar {name}",
    "Failed to restore {name} and {n} other items": "No se pudieron restaurar {name} y {n} elementos adicionales",
    "Failed to save": "Error al guardar",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "Failo al enviar a {email_placeholder}: {errorMsg_placeholder}",
    "Failed to set people cover photo": "No se pudo establecer la foto de portada de la persona",
    "Failed to unshare {name}": "Fallo al dejar de compartir {name}",
    "Failed to upload {file_name}.": "Fallo al subir {file_name}.",
    "Failed. Please check the network.": "Fallo. Por favor, verifica la red.",
    "Favicon": "Favicon",
    "Favorites": "Favoritos",
    "File": "Archivo",
    "File Access": "Acceso a archivo",
    "File Operations": "Operaciones de archivos",
    "File Scan": "Escanear Archivo",
    "File Update": "Actualizaci\u00f3n de archivo",
    "File Upload": "Subir archivo",
    "File Uploading...": "Subiendo archivo...",
    "File already exists.": "El archivo ya existe.",
    "File collaborators": "Colaboradores del archivo",
    "File count": "N\u00famero de archivos",
    "File details": "Detalles del archivo",
    "File details extracted": "Detalles del archivo extra\u00eddos",
    "File download is disabled: the share link traffic of owner is used up.": "Descarga de archivos deshabilitada: tr\u00e1fico del propietario para compartir enlaces agotado.",
    "File expire time": "Tiempo de expiraci\u00f3n del archivo",
    "File extension white list": "Lista blanca de extensiones de archivos",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "Lista blanca de extensiones de archivos para carga de archivos a trav\u00e9s de la interfaz web y la API. Por ejemplo, \"md;txt;docx\". Vac\u00edo significa sin l\u00edmite.",
    "File extensions can only be {placeholder}.": "Las extensiones de archivo solamente pueden ser {placeholder}.",
    "File is locked by others.": "El archivo est\u00e1 bloqueado por otros.",
    "File name": "Nombre del archivo",
    "File name and content": "Nombre y contenido del archivo",
    "File name only": "Solo nombre de archivo",
    "File owner": "Propietario del archivo",
    "File rate": "Calificaci\u00f3n del archivo",
    "File reviewer": "Revisor del archivo",
    "File size is too large.": "El tama\u00f1o de archivo es demasiado grande.",
    "File size should be smaller than {max_size_placeholder}.": "El tama\u00f1o debe ser menor que {max_size_placeholder}.",
    "File status": "Estado del archivo",
    "File suffix": "Sufijo de archivo",
    "File too large": "El archivo es demasiado grande",
    "File type": "Tipo de archivo",
    "File {file_link} has a new comment form user {author}.": "El archivo {file_link} tiene un nuevo comentario del usuario {author}.",
    "Files": "Archivos",
    "Files and folders": "Archivos y carpetas",
    "Files by creator": "Archivos por creador",
    "Files by time": "Archivos por tiempo",
    "Files by type": "Archivos por tipo",
    "Fill in": "Rellenar",
    "Filter": "Filtrar",
    "Filters": "Filtros",
    "Find": "Buscar",
    "Find a tag": "Buscar una etiqueta",
    "Find libraries": "Buscar bibliotecas",
    "Find modifiers": "Buscar modificadores",
    "Find users": "Buscar usuarios",
    "Focal length": "Longitud focal",
    "Fold": "Colapsar",
    "Fold the sidebar": "Contraer la barra lateral",
    "Folder": "Carpeta",
    "Folder Permission": "Permiso de Carpeta",
    "Folder does not exist.": "La carpeta no existe",
    "Folder permission is only effective after the library is shared to users or groups. It is used to fine tune sub-folder permissions.": "El permiso de carpeta solo es v\u00e1lido despu\u00e9s de que la biblioteca se haya compartido con usuarios o grupos. Se utiliza para ajustar permisos de subcarpetas.",
    "Folders": "Carpetas",
    "Force Two-Factor Authentication": "Forzar Autenticaci\u00f3n de Dos Factores",
    "Force password change": "Forzar cambio de contrase\u00f1a",
    "Force user to change password when account is newly added or reset by admin": "Forzar a que el usuario cambie la contrase\u00f1a cuando se crea la cuenta o reestablecida por un administrador",
    "Force user to use SSO login if SSO account is bound": "Forzar al usuario a usar inicio de sesi\u00f3n SSO si la cuenta SSO est\u00e1 vinculada",
    "Force user to use a strong password when sign up or change password.": "Forzar a que el usuario utilice una contrase\u00f1a segura al registrarse o al cambiar la contrase\u00f1a.",
    "Force users to use password when generating share/upload link.": "Forzar a que los usuarios utilicen una contrase\u00f1a al generar un enlace de compartir/subir.",
    "Format": "Formato",
    "Freeze Document": "Congelar documento",
    "Freeze page": "Congelar p\u00e1gina",
    "Freeze user account when failed login attempts exceed limit.": "Inmovilizar la cuenta del usuario cuando el n\u00famero de intentos de acceso fallidos exceda el l\u00edmite.",
    "Freeze user on login failed": "Congelar usuario en caso de fallo de inicio de sesi\u00f3n",
    "Frozen by {name}": "Congelado por {name}",
    "Full screen": "Pantalla completa",
    "Gallery": "Galer\u00eda",
    "General": "General",
    "General information": "Informaci\u00f3n general",
    "Generate": "Generar",
    "Generate Link": "Generar Enlace",
    "Generate description": "Generar descripci\u00f3n",
    "Generate file tags": "Generar etiquetas de archivo",
    "Generate links in batch": "Generar enlaces en lote",
    "Generate share link": "Generar enlace de compartir",
    "Generating description by AI...": "Generando descripci\u00f3n por IA...",
    "Germany Russia etc": "Alemania, Rusia, etc.",
    "Global Address Book": "Libreta de direcciones global",
    "Global hidden properties": "Propiedades ocultas globales",
    "Global hidden properties will not be displayed in all views.": "Las propiedades ocultas globales no se mostrar\u00e1n en todas las vistas.",
    "Go back": "Volver",
    "Go to Library": "Ir a la Biblioteca",
    "Greater than or equal to {minDays_placeholder} days": "Mayor o igual que {minDays_placeholder} d\u00edas",
    "Grid view": "Vista de cuadr\u00edcula",
    "Group": "Grupo",
    "Group Invite": "Invitaci\u00f3n a grupo",
    "Group Member": "Miembro del grupo",
    "Group Permission": "Permiso de grupo",
    "Group Shares": "Comparticiones de Grupo",
    "Group by": "Agrupar por",
    "Group deleted": "Grupo borrado",
    "Group has been transferred": "El grupo ha sido transferido",
    "Group info": "Informaci\u00f3n del grupo",
    "Group invitation link": "Enlace de invitaci\u00f3n de grupo",
    "Group members": "Miembros del grupo",
    "Grouped by 1 property": "Agrupado por 1 propiedad",
    "Grouped by {name_placeholder} properties": "Agrupado por {name_placeholder} propiedades",
    "Groups": "Grupos",
    "Guest": "Invitado",
    "Handled": "Manejado",
    "Help": "Ayuda",
    "Help and resources": "Ayuda y recursos",
    "Hidden properties": "Propiedades ocultas",
    "Hide": "Ocultar",
    "Hide advanced search": "Ocultar b\u00fasqueda avanzada",
    "Hide all": "Ocultar todas",
    "Hide properties": "Ocultar propiedades",
    "History": "Historial",
    "History Setting": "Configuraci\u00f3n de historial",
    "History Versions": "Historial de Versiones",
    "ID": "ID",
    "IP": "IP",
    "ISO": "ISO",
    "Identifying portraits...": "Identificando retratos...",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "Si las notificaciones no han sido le\u00eddas en el plazo de una hora, ser\u00e1n enviadas a su casilla de correo.",
    "If the library is shared to another department, the sharing will be kept.": "Si la biblioteca est\u00e1 compartida con otro departamento, la compartici\u00f3n se mantendr\u00e1.",
    "If the library is shared to another user, the sharing will be kept.": "Si la biblioteca est\u00e1 compartida con otro usuario, la compartici\u00f3n se mantendr\u00e1.",
    "If there are multiple items in the cell, a random one will be chosen and be compared with the filter value.": "Si hay varios elementos en la celda, se elegir\u00e1 uno al azar y se comparar\u00e1 con el valor del filtro.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "Si est\u00e1 activado el cliente de escritorio no podr\u00e1 sincronizar una carpeta fuera de la carpeta Seafile preestablecida.",
    "If you don't have any device with you, you can access your account using backup codes.": "Si no posse ning\u00fan dispositivo consigo, puede acceder a su cuenta utilizando c\u00f3digos de respaldo.",
    "Ignore": "Ignorar",
    "Ignored": "Ignorado",
    "Image saved": "Imagen guardada",
    "Import": "Importar",
    "Import Confluence": "Importar Confluence",
    "Import Confluence Wiki": "Importar Wiki de Confluence",
    "Import Users": "Importar Usuarios",
    "Import members": "Importar miembros",
    "Import members from a .xlsx file": "Importar miembros desde un archivo .xlsx",
    "Import options": "Importar opciones",
    "Import page": "Importar p\u00e1gina",
    "Import page from Markdown": "Importar p\u00e1gina desde Markdown",
    "Import page from docx": "Importar p\u00e1gina desde docx",
    "Import sdoc": "Importar sdoc",
    "Import tags": "Importar etiquetas",
    "Import users": "Importar usuarios",
    "Import users from a .xlsx file": "importar usuarios desde un archivo .xlsx",
    "Importing page...": "Importando p\u00e1gina...",
    "Importing sdoc, please wait...": "Importando sdoc, por favor espere...",
    "Importing tags...": "Importando etiquetas...",
    "Importing...": "Importando...",
    "In progress": "En progreso",
    "In review": "En revisi\u00f3n",
    "Inactive": "Inactivo",
    "Info": "Info",
    "Institution Admin": "Administrador de la Instituci\u00f3n",
    "Institutions": "Instituciones",
    "Internal Link": "Enlace interno",
    "Internal Server Error": "Error interno del servidor",
    "Internal link has been copied to clipboard": "El enlace interno ha sido copiado al portapapeles",
    "Invalid destination path": "Ruta de destino inv\u00e1lida",
    "Invalid filename.": "Nombre de archivo inv\u00e1lido.",
    "Invalid filter": "Filtro inv\u00e1lido",
    "Invalid month, should be yyyymm.": "Mes inv\u00e1lido, debe ser yyyymm.",
    "Invalid regular expression": "Expresi\u00f3n regular no v\u00e1lida",
    "Invisible": "Invisible",
    "Invitation link has been copied to clipboard": "Enlace de invitaci\u00f3n copiado al portapapeles",
    "Invitations": "Invitaciones",
    "Invite Guest": "Convocar Invitado",
    "Invite Time": "Fecha de Invitaci\u00f3n",
    "Invite members": "Invitar miembros",
    "Invite users": "Invitar usuarios",
    "Invite users via WeChat": "Invitar usuarios via WeChat",
    "Invited at": "Invita en",
    "Inviter": "Invita",
    "Is expired": "Est\u00e1 expirado",
    "It is already shared to user": "Ya est\u00e1 compartido con este usuario",
    "It is required.": "Es requerido.",
    "It may take some time, please wait.": "Puede tomar un tiempo, por favor espere.",
    "Kanban": "Kanban",
    "Keep full history": "Mantener historial completo",
    "Keep sharing": "Mantener compartici\u00f3n",
    "Keep sign in": "Mantener la sesi\u00f3n iniciada",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP (importado)",
    "Label": "Etiqueta",
    "Label Current State": "Etiquetar el estado actual",
    "Labels": "Etiquetas",
    "Language": "Idioma",
    "Language Setting": "Configuraci\u00f3n de idioma",
    "Language for tags generated by AI": "Idioma para etiquetas generadas por IA",
    "Last 30 days": "\u00daltimos 30 d\u00edas",
    "Last 7 days": "\u00daltimos 7 d\u00edas",
    "Last Access": "\u00daltimo acceso",
    "Last Login": "\u00daltimo Ingreso",
    "Last Update": "\u00daltima actualizaci\u00f3n",
    "Last modification": "\u00daltima modificaci\u00f3n",
    "Last modified by": "\u00daltima modificaci\u00f3n por",
    "Last modified time": "\u00daltima modificaci\u00f3n",
    "Last modifier": "\u00daltimo modificador",
    "Leave": "Abandonar",
    "Leave Group": "Abandonar el grupo",
    "Leave Share": "Dejar de compartir",
    "Leave Share Wiki": "Dejar de compartir Wiki",
    "Leave group": "Abandonar el grupo",
    "Leave this page? The system may not save your changes.": "\u00bfDejar esta p\u00e1gina? El sistema podr\u00eda no guardar sus cambios.",
    "Less than or equal to {maxDays_placeholder} days": "Menor o igual que {maxDays_placeholder} d\u00edas",
    "Libraries": "Bibliotecas",
    "Library": "Biblioteca",
    "Library Type": "Tipo de Biblioteca",
    "Library can not be shared to owner.": "La biblioteca no puede ser compartida con su propietario.",
    "Library does not exist": "La biblioteca no existe",
    "Library history": "Historial de biblioteca",
    "Library not found": "Biblioteca no encontrada",
    "Library password minimum length": "Longitud m\u00ednima de la contrase\u00f1a de la biblioteca",
    "Light mode": "Modo claro",
    "Limits": "L\u00edmites",
    "Line wrapping": "Ajustar l\u00edneas",
    "Link": "Enlace",
    "Link has been copied to clipboard": "El enlace ha sido copiado al portapapeles",
    "Link image": "Enlace de imagen",
    "Linked Devices": "Dispositivos vinculados",
    "Links": "Enlaces",
    "List view": "Vista de lista",
    "List your account in global address book, so that others can find you by typing your name.": "Incluya su cuenta en la libreta de direcciones global, de manera que otros puedan encontrarlo tipeando su nombre.",
    "Load all": "Cargar todo",
    "Loading": "Cargando",
    "Loading metadata...": "Cargando metadatos...",
    "Loading...": "Cargando...",
    "Location": "Ubicaci\u00f3n",
    "Lock": "Bloquear",
    "Log out": "Desconectarse",
    "Login": "Acceder",
    "Login ID": "Login ID",
    "Login attempt limit": "L\u00edmite de intentos de inicio de sesi\u00f3n",
    "Login background image": "Imagen de fondo del inicio de sesi\u00f3n",
    "Logo": "Logotipo",
    "Logo updated": "Logo actualizado",
    "Logs": "Registros",
    "Long text": "Texto largo",
    "Manage group members": "Administrar miembros del grupo",
    "Manage members": "Gestionar miembros",
    "Map": "Mapa",
    "Map is not ready": "El mapa no est\u00e1 listo",
    "Mark all as read": "Marcar todo como le\u00eddo",
    "Mark all read": "Marcar todo le\u00eddo",
    "Mark as resolved": "Marcar como resuelto",
    "Marked \"{resolve_comment}\" as resolved in document {sdoc_link}": "Marcado \"{resolve_comment}\" como resuelto en el documento {sdoc_link}",
    "Marked as resolved in document {sdoc_link}": "Marcado como resuelto en el documento {sdoc_link}",
    "Matching tags": "Etiquetas coincidentes",
    "Max": "M\u00e1x",
    "Max number of members": "N\u00famero m\u00e1ximo de miembros",
    "Member": "Miembro",
    "Members": "Miembros",
    "Merge tags": "Unir etiquetas",
    "Merge tags to": "Unir etiquetas a",
    "Message": "Mensaje",
    "Message (optional):": "Mensaje (opcional):",
    "Metrics": "M\u00e9tricas",
    "Migrate": "Migrar",
    "Migrate User": "Migrar usuario",
    "Migrate old version tags": "Migrar etiquetas de versi\u00f3n antigua",
    "Mobile": "M\u00f3vil",
    "Modification Details": "Detalles de modificaci\u00f3n",
    "Modified": "Modificado",
    "Modified by": "Modificado por",
    "Modified by:": "Modificado por:",
    "Modified files": "Archivos modificados",
    "Modified time": "Fecha de modificaci\u00f3n",
    "Modifier": "Modific\u00f3",
    "Modify": "Modificar",
    "Modify includes modify file, move/rename file and folder": "Modificar incluye modificar archivo, mover/renombrar archivo y carpeta",
    "Modify name": "Modificar nombre",
    "Month": "Mes",
    "Month:": "Mes:",
    "Monthly User Traffic": "Tr\u00e1fico Mensual de Usuario",
    "More": "M\u00e1s",
    "More operations": "M\u00e1s opciones",
    "Move": "Mover",
    "Move department": "Mover departamento",
    "Move file": "Mover archivo",
    "Move folder": "Mover carpeta",
    "Move selected item(s) to:": "Mover item(s) seleccionados a:",
    "Move to department": "Mover a departamento",
    "Move {num} items": "Mover {num} items",
    "Move {placeholder} to": "Mover {placeholder} a",
    "Moved file": "Archivo movido",
    "Moved folder": "Carpeta movida",
    "Multiple select": "Selecci\u00f3n m\u00faltiple",
    "My Activities": "Mis actividades",
    "My Libraries": "Mis Bibliotecas",
    "My Wikis": "Mis Wikis",
    "Name": "Nombre",
    "Name already exists": "El nombre ya existe",
    "Name cannot be double dots": "Name cannot be double dots",
    "Name cannot be empty": "El nombre no puede estar vac\u00edo",
    "Name cannot contain backslash": "El nombre no puede contener barras invertidas",
    "Name cannot contain backtick": "El nombre no puede contener acento grave",
    "Name cannot contain curly braces": "El nombre no puede contener llaves",
    "Name cannot contain dots": "El nombre no puede contener puntos",
    "Name cannot contain slash": "El nombre no puede contener barras inclinadas",
    "Name is required": "Nombre requerido",
    "Name is required.": "Se requiere nombre.",
    "Name or ID": "Nombre o ID",
    "Name should be string": "El nombre debe ser una cadena",
    "Name should not include '/'.": "El nombre no debe contener ' / '.",
    "Name updated": "Nombre actualizado",
    "Name(optional)": "Nombre (opcional)",
    "Names don't match": "Nombres no coinciden",
    "Network error": "Error de red",
    "New": "Nuevo",
    "New Department": "Nuevo Departamento",
    "New Department Library": "Nueva Biblioteca Departamental",
    "New Docxf File": "Nuevo archivo Docxf",
    "New Excalidraw File": "Nuevo archivo Excalidraw",
    "New Excel File": "Nuevo Archivo Excel",
    "New File": "Nuevo archivo",
    "New Folder": "Nueva Carpeta",
    "New Group": "Nuevo Grupo",
    "New Library": "Nueva biblioteca",
    "New Markdown File": "Nuevo Archivo Markdown",
    "New Password": "Nueva Contrase\u00f1a",
    "New Password Again": "Nueva contrase\u00f1a otra vez",
    "New PowerPoint File": "Nuevo Archivo PowerPoint",
    "New SeaDoc File": "Nuevo archivo SeaDoc",
    "New Sub-department": "Nuevo Sub-departamento",
    "New Whiteboard File": "Nuevo archivo de pizarra blanca",
    "New Word File": "Nuevo Archivo Word",
    "New category": "Nueva categor\u00eda",
    "New child tag": "Nueva etiqueta hija",
    "New directories": "Carpetas nuevas",
    "New file name": "Nuevo nombre de archivo",
    "New files": "Archivos nuevos",
    "New folder": "Nueva carpeta",
    "New folder name": "Nuevo nombre de carpeta",
    "New page": "Nueva p\u00e1gina",
    "New password": "Nueva contrase\u00f1a",
    "New password cannot be the same as old password": "La nueva contrase\u00f1a no puede ser la misma que la contrase\u00f1a actual",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "La nueva contrase\u00f1a fue enviada a tu email {mail}. Por favor verifica tu casilla de correo Si no recibes la contrase\u00f1a, por favor verifica que tu direcci\u00f3n de correo est\u00e9 bien configurada.",
    "New password is too short": "La nueva contrase\u00f1a es demasiado corta",
    "New passwords don't match": "Las contrase\u00f1as no coinciden",
    "New tag": "Nueva etiqueta",
    "New view": "Nueva vista",
    "Next": "Siguiente",
    "Next (Right arrow key)": "Siguiente (Flecha derecha)",
    "Next modification": "Pr\u00f3xima modificaci\u00f3n",
    "No Admin login logs": "No hay registros de ingreso de Admin",
    "No Admin operation logs": "No hay registros de operaciones de Admin",
    "No Wikis": "Sin Wikis",
    "No categories": "No hay categor\u00edas",
    "No changes": "No hay cambios",
    "No collaborators": "Sin colaboradores",
    "No collaborators available": "No hay colaboradores disponibles",
    "No comment yet.": "No hay comentarios.",
    "No connected devices": "No hay dispositivos conectados",
    "No creator data available": "No hay datos de creador disponibles",
    "No data available for statistics": "No hay datos disponibles para estad\u00edsticas",
    "No deleted libraries": "No hay bibliotecas eliminadas",
    "No favorites": "No hay favoritos",
    "No file": "No hay archivos",
    "No file access logs": "No hay registro de acceso a archivos.",
    "No file selected": "Ning\u00fan archivo seleccionado",
    "No file update logs": "No hay registros de actualizaci\u00f3n de archivo.",
    "No files": "No hay archivos",
    "No files or folders have been shared with you": "No se han compartido archivos ni carpetas contigo",
    "No files or folders have been shared with you from other servers.": "No se han compartido archivos ni carpetas contigo desde otros servidores.",
    "No filters": "No hay filtros",
    "No folders shared": "No hay carpetas compartidas",
    "No group invitation link yet. Group invitation link let registered users to join the group by clicking a link.": "A\u00fan no hay enlace de invitaci\u00f3n de grupo. El enlace de invitaci\u00f3n de grupo permite a los usuarios registrados unirse al grupo haciendo clic en un enlace.",
    "No group shares": "No hay compartidos de grupos.",
    "No groupings applied to this view.": "No se han aplicado agrupaciones a esta vista.",
    "No groups": "No hay grupos",
    "No guest invitations": "No hay convocaciones a invitados",
    "No invitations": "No hay invitaciones",
    "No items": "No hay elementos",
    "No libraries": "No hay bibliotecas",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "No se han compartido bibliotecas directamente contigo. Una biblioteca se puede compartir con permisos totales o restringidos. Si necesitas acceder a una biblioteca de otro usuario, solic\u00edtale que la comparta contigo.",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" item in the dropdown menu.": "Todav\u00eda no se han compartido bibliotecas con este grupo. Una biblioteca compartida con un grupo puede ser accedida por todos los miembros del grupo. Puede compartir una biblioteca con un grupo en \"Mis Bibliotecas\". Tambi\u00e9n puede crear una nueva biblioteca para compartir con este grupo haciendo clic en el elemento \"Nueva Biblioteca\" en el men\u00fa desplegable.",
    "No libraries have been shared with you": "No hay bibliotecas compartidas contigo",
    "No libraries have been shared with you from other servers.": "No se han compartido bibliotecas contigo desde otros servidores.",
    "No libraries shared": "No hay bibliotecas compartidas",
    "No libraries shared with this group": "No hay bibliotecas compartidas este grupo",
    "No linked devices": "No hay dispositivos vinculados",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "No hay dispositivos vinculados. A\u00fan no has accedido a tus archivos con ning\u00fan cliente (de escritorio o m\u00f3vil). Configura los clientes en tus dispositivos para acceder a tus datos de manera m\u00e1s c\u00f3moda.",
    "No login logs": "No hay registros de ingreso.",
    "No matching tags": "No hay etiquetas coincidentes",
    "No members": "No hay miembros",
    "No more activities": "No hay m\u00e1s actividades",
    "No notifications": "No hay notificaciones",
    "No option": "Sin opci\u00f3n",
    "No options": "Sin opciones",
    "No options available": "No hay opciones disponibles",
    "No permission logs": "No hay registros de permisos.",
    "No properties available to be hidden": "No hay propiedades disponibles para ocultar",
    "No public libraries": "No hay bibliotecas p\u00fablicas",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" item in the dropdown menu.": "A\u00fan no se han creado bibliotecas p\u00fablicas. Una biblioteca p\u00fablica es accesible para todos los usuarios. Puedes crear una biblioteca p\u00fablica haciendo clic en la opci\u00f3n \"A\u00f1adir Biblioteca\" en el men\u00fa desplegable.",
    "No recommended new tags": "No hay nuevas etiquetas recomendadas",
    "No record": "Sin registros",
    "No result": "No hay resultados",
    "No results": "No hay resultados",
    "No results found": "No se encontraron resultados",
    "No results matching": "No se encontraron resultados que coincidan con",
    "No separator (1000000)": "Sin separador (1000000)",
    "No share links": "No hay enlaces de compartir",
    "No shared Wikis": "No hay Wikis compartidas",
    "No shared libraries": "No hay bibliotecas compartidas",
    "No sorts": "No hay ordenes",
    "No sync errors": "No hay errores de sincronizaci\u00f3n",
    "No tag": "Sin etiqueta",
    "No tags": "Sin etiquetas",
    "No tags available": "No hay etiquetas disponibles",
    "No terms and conditions": "T\u00e9rminos y condiciones",
    "No text extracted": "No se extrajo texto",
    "No time-based data available": "No hay datos basados en el tiempo disponibles",
    "No upload links": "No hay enlaces de subida",
    "No user shares": "No hay compartidos de usuarios.",
    "No users found": "No se encontraron usuarios",
    "No version history": "Sin historial de versiones",
    "Node": "Nodo",
    "None": "Ninguna",
    "Not allow user to clean library trash": "No permitir al usuario limpiar la papelera de la biblioteca",
    "Not allow user to create encrypted libraries": "No permitir al usuario crear bibliotecas cifradas",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Nota: las configuraciones via la interfaz web se guardan en una tabla de la base de datos (seahub-db/constance_config). Tienen prioridad sobre las configuraciones en los archivos.",
    "Notification": "Notificaci\u00f3n",
    "Notification Detail": "Detalles de notificaciones",
    "Notifications": "Notificaciones",
    "Notifications of collaboration": "Notificaciones de colaboraci\u00f3n",
    "Notifications of file changes": "Notificaciones de modificaciones en archivos",
    "Number": "N\u00famero",
    "Number format settings": "Configuraci\u00f3n de formato de n\u00fameros",
    "Number of days ago": "N\u00famero de d\u00edas atr\u00e1s",
    "Number of days from now": "N\u00famero de d\u00edas a partir de ahora",
    "Number of days that keep user sign in.": "N\u00famero de d\u00edas que el usuario permanece identificado",
    "Number of groups": "N\u00famero de grupos",
    "Number of links": "N\u00famero de enlaces",
    "Number of members": "N\u00famero de miembros",
    "Number of records exceeds the limit of 1000": "El n\u00famero de registros supera el l\u00edmite de 1000",
    "OCR": "OCR",
    "OCR result": "Resultado de OCR",
    "Off": "No",
    "Office Suite": "Suite de Office",
    "Old Password": "Contrase\u00f1a anterior",
    "Old Wikis": "Wikis antiguas",
    "On": "Si",
    "One month ago": "Hace un mes",
    "One month from now": "Dentro de un mes",
    "One week ago": "Hace una semana",
    "One week from now": "Dentro de una semana",
    "Online Preview": "Vista previa en l\u00ednea",
    "Online Read-Only": "S\u00f3lo lectura en l\u00ednea",
    "Online Read-Only folder": "Carpeta de s\u00f3lo lectura en l\u00ednea",
    "Online Read-Only library": "Biblioteca de s\u00f3lo lectura en l\u00ednea",
    "Online Read-Write": "Lectura / Escritura en l\u00ednea",
    "Online Read-Write folder": "Carpeta de lectura / escritura en l\u00ednea",
    "Online Read-Write library": "Biblioteca de lectura / escritura en l\u00ednea",
    "Online view is not applicable to this file format": "La visualizaci\u00f3n en l\u00ednea no se aplica a este tipo de archivo",
    "Only Show": "S\u00f3lo Mostrar",
    "Only files": "Solo archivos",
    "Only folders": "Solo carpetas",
    "Only keep a period of history:": "S\u00f3lo mantener el historial por:",
    "Only pictures": "Solo im\u00e1genes",
    "Only videos": "Solo videos",
    "Open file": "Abrir archivo",
    "Open file in new tab": "Abrir archivo en una nueva pesta\u00f1a",
    "Open folder": "Abrir carpeta",
    "Open folder in new tab": "Abrir carpeta en una nueva pesta\u00f1a",
    "Open in new tab": "Abrir en nueva pesta\u00f1a",
    "Open parent folder": "Abrir carpeta contenedora",
    "Open the panel": "Abrir el panel",
    "Open via Client": "Abrir via el Cliente",
    "Open via client": "Abrir via cliente",
    "Operation": "Operaci\u00f3n",
    "Operation succeeded.": "Operaci\u00f3n exitosa.",
    "Operations": "Operaciones",
    "Operator": "Operador",
    "Optional": "Opcional",
    "Options imported": "Opciones importadas",
    "Or": "O",
    "Organization": "Organizaci\u00f3n",
    "Organization Admin": "Administrador de la Organizaci\u00f3n",
    "Organizations": "Organizaciones",
    "Original path": "Ruta original",
    "Other": "Otro",
    "Other Libraries": "Otras bibliotecas",
    "Others": "Otros",
    "Out of quota.": "Cuota agotada.",
    "Outdated": "Desactualizado",
    "Outline": "Esquema",
    "Owned Libraries": "Bibliotecas Propias",
    "Owner": "Propietario",
    "Owner can use admin panel in an organization, must be a new account.": "El propietario puede utilizar el panel de admin en una organizaci\u00f3n, debe ser una cuenta nueva.",
    "Packaging...": "Empaquetando...",
    "Page fit": "Ajustar p\u00e1gina",
    "Page imported": "P\u00e1gina importada",
    "Page is frozen": "La p\u00e1gina est\u00e1 congelada",
    "Page name": "Nombre de p\u00e1gina",
    "Page {name_placeholder} deleted.": "P\u00e1gina {name_placeholder} eliminada.",
    "Pages": "P\u00e1ginas",
    "Parent folder": "Carpeta padre",
    "Parent tags": "Etiquetas padre",
    "Password": "Contrase\u00f1a ",
    "Password again": "Repetir contrase\u00f1a",
    "Password cannot be blank": "La cntrase\u00f1a no puede estar en blanco",
    "Password is too short": "Contrase\u00f1a demasiado corta",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "La contrase\u00f1a debe tener al menos 8 caracteres y contener diferentes caracteres: letras may\u00fasculas, min\u00fasculas, n\u00fameros y s\u00edmbolos especiales",
    "Password removed": "Contrase\u00f1a eliminada",
    "Password reset": "Contrase\u00f1a restablecida",
    "Password set": "Contrase\u00f1a establecida",
    "Password strength": "Fuerza de contrase\u00f1a",
    "Password strength should be strong or very strong": "La contrase\u00f1a debe tener una fuerza fuerte o muy fuerte",
    "Password updated": "Contrase\u00f1a actualizada",
    "Passwords do not match.": "Las contrase\u00f1as no coinciden.",
    "Passwords don't match": "Las contrase\u00f1as no coinciden",
    "Path": "Ruta",
    "People": "Personas",
    "Per 4 hours": "Por 4 horas",
    "Per day": "Por d\u00eda",
    "Per hour": "Por hora",
    "Per week": "Por semana",
    "Percent": "Porcentaje",
    "Permission": "Permiso",
    "Permission denied": "Permiso denegado",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Permiso denegado. Por favor intente {placeholder-left}acceder nuevamente.{placeholder-right}",
    "Permission name": "Nombre de permiso",
    "Person image": "Imagen de persona",
    "Picture": "Imagen",
    "Pictures and videos": "Im\u00e1genes y videos",
    "Platform": "Plataforma",
    "Please check the network.": "Por favor verifique la red.",
    "Please choose a .xlsx file.": "Por favor escoja un archivo .xlsx",
    "Please choose an image file.": "Por favor escoja un archivo de imagen.",
    "Please enter 1 or more character": "Por favor ingrese uno o m\u00e1s caracteres",
    "Please enter a new password": "Ingrese una nueva contrase\u00f1a",
    "Please enter a new quota": "Por favor, ingrese una nueva cuota",
    "Please enter a non-negative integer": "Por favor, ingrese un n\u00famero entero no negativo",
    "Please enter a password.": "Por favor, ingrese una contrase\u00f1a.",
    "Please enter a positive integer": "Por favor ingrese un entero positivo",
    "Please enter an integer bigger than 1 as number of links.": "Por favor, ingrese un n\u00famero entero mayor que 1 como n\u00famero de enlaces.",
    "Please enter an integer not bigger than {max_number} as number of links.": "Por favor, ingrese un n\u00famero entero no mayor que {max_number} como n\u00famero de enlaces.",
    "Please enter days": "Ingresa cantidad de d\u00edas",
    "Please enter password": "Ingresa una contrase\u00f1a",
    "Please enter the address": "Por favor ingrese la direcci\u00f3n",
    "Please enter the new password again": "Ingrese la nueva contrase\u00f1a otra vez",
    "Please enter the old password": "Ingrese la contrase\u00f1a anterior",
    "Please enter the password again": "Ingresa la contrase\u00f1a nuevamente",
    "Please input at least an email.": "Ingresa al menos un correo.",
    "Please select": "Por favor seleccione",
    "Please select a file": "Por favor, seleccione un archivo",
    "Please select a library or folder first.": "Por favor selecciona una biblioteca o carpeta primero.",
    "Please select a library to share.": "Por favor seleccione una biblioteca para compartir.",
    "Please select an expiration time": "Por favor, seleccione una fecha de expiraci\u00f3n",
    "Please turn on extended properties setting first": "Por favor, active primero la configuraci\u00f3n de propiedades extendidas",
    "Please upload no more than {maxFiles} files at a time.": "Por favor no suba mas de {maxFiles} archivos al mismo tiempo.",
    "Precision": "Precisi\u00f3n",
    "Preparing to upload...": "Preparando para subir...",
    "Preset hide properties": "Propiedades ocultas preestablecidas",
    "Preview and download": "Vista previa y descargar",
    "Preview online": "Previsualizar en l\u00ednea",
    "Preview only": "Vista previa solamente",
    "Previous": "Anterior",
    "Previous (Left arrow key)": "Anterior (Flecha izquierda)",
    "Print": "Imprimir",
    "Print document": "Imprimir documento",
    "Professional Edition": "Versi\u00f3n Profesional",
    "Profile": "Perfil",
    "Profile Setting": "Configuraci\u00f3n del perfil",
    "Properties": "Propiedades",
    "Properties to display on the card": "Propiedades para mostrar en la tarjeta",
    "Property name": "Nombre de propiedad",
    "Publish": "Publicar",
    "Publish Wiki": "Publicar Wiki",
    "Published": "Publicado",
    "QR Code": "C\u00f3digo QR",
    "Quota": "Cuota",
    "Quota is invalid.": "La cuota es inv\u00e1lida.",
    "Rate": "Calificaci\u00f3n",
    "Read-Only": "S\u00f3lo lectura",
    "Read-Only folder": "Carpeta de s\u00f3lo lectura",
    "Read-Only library": "Biblioteca de s\u00f3lo lectura",
    "Read-Write": "Lectura / Escritura",
    "Read-Write folder": "Carpeta de lectura / escritura",
    "Read-Write library": "Biblioteca de lectura / escritura",
    "Really want to delete this group?": "\u00bfSeguro que deseas borrar este grupo?",
    "Really want to delete your account?": "\u00bfSeguro que deseas eliminar tu cuenta?",
    "Really want to leave this group?": "\u00bfSeguro que deseas abandorar este grupo?",
    "Recently Used": "M\u00e1s recientemente usadas",
    "Recently used tags": "Etiquetas usadas recientemente",
    "Recognizing portraits. Please refresh the page later.": "Reconociendo retratos. Por favor, actualice la p\u00e1gina m\u00e1s tarde.",
    "Recommended new tags": "Nuevas etiquetas recomendadas",
    "Refresh": "Refrescar",
    "Refresh the view": "Actualizar la vista",
    "Remaining": "Restante",
    "Remove": "Remover",
    "Remove Member": "Eliminar Miembro",
    "Remove from this group": "Quitar de este grupo",
    "Removed all items from trash": "Se han eliminado todos los elementos de la papelera",
    "Removed items older than {n} days from trash": "Se han eliminado los elementos con m\u00e1s de {n} d\u00edas de antig\u00fcedad de la papelera",
    "Rename": "Renombrar",
    "Rename Department": "Renombrar Departmento",
    "Rename File": "Renombrar Archivo",
    "Rename Folder": "Renombrar Carpeta",
    "Rename Group": "Renombrar Grupo",
    "Rename Library": "Renombrar Biblioteca",
    "Rename Wiki": "Renombrar Wiki",
    "Rename file": "Renombrar archivo",
    "Rename folder": "Renombrar carpeta",
    "Rename group to": "Renombrar grupo a",
    "Rename property": "Renombrar propiedad",
    "Renamed file": "Archivo renombrado",
    "Renamed folder": "Carpeta renombrada",
    "Renamed library": "Biblioteca renombrada",
    "Renamed or Moved files": "Archivos movidos o renombrados",
    "Renaming {name} failed": "Fallo al renombrar {name}",
    "Replace": "Reemplazar",
    "Replace file {filename}?": "\u00bfReemplazar archivo {filename}?",
    "Replacing it will overwrite its content.": "Al reemplazarlo se sobreescribir\u00e1 su contenido.",
    "Repo Transfer": "Transferencia de repositorio",
    "Report Abuse": "Informar Abuso",
    "Reporter": "Informador",
    "Reports": "Informes",
    "Required at least three letters.": "Se requieren al menos tres letras.",
    "Reset": "Restablecer",
    "Reset Password": "Reestablecer contrase\u00f1a",
    "Reset WebDAV Password": "Reestablecer contrase\u00f1a WebDAV",
    "Reset library password": "Reestablecer contrase\u00f1a de la biblioteca",
    "ResetPwd": "Restaurar contrase\u00f1a",
    "Resetting user's password, please wait for a moment.": "Resetenado contrase\u00f1a del usuario, por favor espere un momento.",
    "Resolved comments": "Comentarios resueltos",
    "Restore": "Restaurar",
    "Restore Library": "Restaurar biblioteca",
    "Restored 1 item": "Se ha restaurado 1 elemento",
    "Restored file": "Archivo restaurado",
    "Restored folder": "Carpeta restaurada",
    "Restored library": "Biblioteca restaurada",
    "Restored {name}": "Se ha restaurado {name}",
    "Restored {name} and {n} other items": "Se han restaurado {name} y {n} elementos adicionales",
    "Resubmit": "Reenviar",
    "Result": "Resultado",
    "Retry": "Reintentar",
    "Retry All": "Reintentar Todo",
    "Revoke": "Revocar",
    "Revoke Access": "Revocar Acceso",
    "Revoke Admin": "Revocar Privilegios",
    "Role": "Rol",
    "Rotate": "Rotar",
    "SAML config": "Configuraci\u00f3n SAML",
    "SAML config updated": "Configuraci\u00f3n SAML actualizada",
    "SSO": "SSO",
    "Satellite": "Sat\u00e9lite",
    "Save": "Guardar",
    "Save Selected Items": "Guardar elementos seleccionados",
    "Save as ...": "Guardar como...",
    "Save to description field": "Guardar en el campo de descripci\u00f3n",
    "Save to:": "Guardar en:",
    "Saving...": "Guardando...",
    "Scan the QR code to view the shared content directly": "Escanear el c\u00f3digo QR para ver el contenido compartido directamente",
    "SeaTable integration": "Integraci\u00f3n con SeaTable",
    "Seafile": "Seafile",
    "Search": "Buscar",
    "Search Groups": "Buscar Grupos",
    "Search Libraries": "Buscar Bibliotecas",
    "Search Organizations": "Buscar Organizaciones",
    "Search Users": "Buscar Usuarios",
    "Search collaborator": "Buscar colaborador",
    "Search collaborators": "Buscar colaboradores",
    "Search department": "Buscar departamento",
    "Search departments": "Buscar departamentos",
    "Search failed": "Busqueda fallida",
    "Search failed. Please try again.": "Busqueda fallida. Por favor, int\u00e9ntelo de nuevo.",
    "Search files": "Buscar archivos",
    "Search files in this library": "Buscar archivos en esta biblioteca",
    "Search group members": "Buscar miembros del grupo",
    "Search groups": "Buscar grupos",
    "Search groups by name": "Buscar grupos por nombre",
    "Search in trash": "Buscar en papelera",
    "Search in trash...": "Buscar en la papelera...",
    "Search libraries by name or ID": "Buscar bibliotecas por nombre o ID",
    "Search libraries by owner": "Buscar bibliotecas por propietario",
    "Search option": "Buscar opci\u00f3n",
    "Search organizations": "Buscar organizaciones",
    "Search properties": "Buscar propiedades",
    "Search property": "Buscar propiedad",
    "Search results": "Resultados de b\u00fasqueda",
    "Search results visited recently": "Resultados de b\u00fasqueda visitados recientemente",
    "Search service unavailable": "El servicio de b\u00fasqueda no est\u00e1 disponible",
    "Search tag": "Buscar etiqueta",
    "Search user": "Buscar usuario",
    "Search users": "Buscar usuarios",
    "Search users...": "Buscar usuarios...",
    "Searching...": "Buscando...",
    "Select": "Seleccionar",
    "Select File": "Seleccionar Archivo",
    "Select a Confluence HTML export file (.html.zip)": "Seleccionar archivo exportado de Confluence HTML (.html.zip)",
    "Select a Confluence HTML exported file (.html.zip)": "Seleccionar archivo exportado de Confluence HTML (.html.zip)",
    "Select a Confluence exported file": "Seleccionar archivo exportado de Confluence",
    "Select a department": "Seleccionar un departamento",
    "Select a server": "Seleccionar un servidor",
    "Select a user": "Seleccionar un usuario",
    "Select a user as admin": "Seleccione un usuario como admin",
    "Select all": "Seleccionar todo",
    "Select all items": "Seleccionar todos los elementos",
    "Select an office suite": "Seleccione una suite de oficina",
    "Select an option": "Seleccionar una opci\u00f3n",
    "Select collaborators": "Seleccionar colaboradores",
    "Select group members": "Seleccionar miembros de grupo",
    "Select image": "Seleccionar imagen",
    "Select items": "Seleccionar \u00edtems",
    "Select libraries to share": "Seleccionar bibliotecas para compartir",
    "Select option(s)": "Seleccionar opci\u00f3n(es)",
    "Select shared users": "Seleccionar usuarios compartidos",
    "Select tag": "Seleccionar etiqueta",
    "Select target department": "Seleccionar departamento objetivo",
    "Select this item": "Seleccionar este elemento",
    "Select up to 50 files": "Seleccione hasta 50 archivos",
    "Select users": "Seleccionar usuarios",
    "Selected": "Seleccionado",
    "Send": "Enviar",
    "Send activation Email after user registration.": "Enviar email de activaci\u00f3n despu\u00e9s del registro del usuario.",
    "Send activation email": "Enviar email de activaci\u00f3n",
    "Send to:": "Enviar a:",
    "Sending new password...": "Enviando la nueva contrase\u00f1a...",
    "Sending...": "Enviando\u2026",
    "Separate multiple suffixes by \",\"(like sdoc, pdf)": "Separar m\u00faltiples sufijos por \",\" (como sdoc, pdf)",
    "Server": "Servidor",
    "Server Version: ": "Versi\u00f3n del servidor: ",
    "Set": "Establecer",
    "Set Admin": "Establecer Admin",
    "Set Contact Email": "Establecer Email de Contacto",
    "Set Download Rate Limit": "Establecer l\u00edmite de velocidad de descarga",
    "Set Login ID": "Establecer Login ID",
    "Set Name": "Establecer Nombre",
    "Set Password": "Establecer Contrase\u00f1a",
    "Set Quota": "Fijar Cuota",
    "Set Upload Rate Limit": "Establecer l\u00edmite de velocidad de subida",
    "Set WebDAV Password": "Establecer contrase\u00f1a WebDAV",
    "Set access scope": "Establecer \u00e1mbito de acceso",
    "Set as cover photo": "Establecer como foto de portada",
    "Set child tags": "Establecer etiquetas hijas",
    "Set max number of members": "Establecer m\u00e1ximo n\u00famero de miembros",
    "Set organization inactive": "Marcar organizaci\u00f3n como inactiva",
    "Set password": "Establecer contrase\u00f1a",
    "Set permission": "Establecer permiso",
    "Set permission of {placeholder}": "Establecer permiso de {placeholder}",
    "Set quota": "Establecer cuota",
    "Set to current": "Establecer actual",
    "Set user contact email": "Establecer email de contacto del usuario",
    "Set user default quota": "Establecer cuota predeterminada del usuario",
    "Set user inactive": "Establecer usuario inactivo",
    "Set user name": "Establecer nombre del usuario",
    "Set user quota": "Establecer cuota del usuario",
    "Setting library history is disabled by Admin.": "Establecer el historial de la biblioteca est\u00e1 deshabilitado por el Administrador.",
    "Setting updated": "Configuraci\u00f3n actualizada",
    "Settings": "Configuraci\u00f3n",
    "Share": "Compartir",
    "Share Admin": "Admin de Compartidos",
    "Share From": "Compartir desde",
    "Share Link": "Compartir enlace",
    "Share Link Traffic": "Tr\u00e1fico de enlaces compartidos",
    "Share Links": "Enlaces Compartidos",
    "Share To": "Compartir con",
    "Share To:": "Compartir con:",
    "Share existing libraries": "Compartir bibliotecas existentes",
    "Share link download": "Descargar enlace de compartir",
    "Share link is copied to the clipboard.": "Enlace de compartir copiado al portapapeles",
    "Share link upload": "Subir enlace de compartir",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "No se pueden generar enlaces de compartir porque se ha establecido \"Invisible\", \"Lectura-Escritura en l\u00ednea\" o \"Solo lectura en l\u00ednea\" para usted en alguna(s) carpeta(s) de la biblioteca.",
    "Share to group": "Compartir con grupo",
    "Share to other server": "Compartir a otro servidor",
    "Share to user": "Compartir con usuario",
    "Share/upload link force password": "Forzar contrase\u00f1a en enlaces de compartir/subir",
    "Share/upload link password minimum length": "Longitud m\u00ednima de la contrase\u00f1a del enlace de compartir/subir",
    "Share/upload link password strength level": "Nivel de seguridad de la contrase\u00f1a del enlace de compartir/subir",
    "Shared By": "Compartida por",
    "Shared Libraries": "Bibliotecas Compartidas",
    "Shared Links": "Enlaces Compartidos",
    "Shared by:": "Compartido por:",
    "Shared by: ": "Compartido por:",
    "Shared from other servers": "Compartido desde otros servidores",
    "Shared with all": "Compartido con todos",
    "Shared with me": "Compartido conmigo",
    "Sharing Time": "Hora de compartici\u00f3n",
    "Show": "Mostrar",
    "Show Codes": "Mostrar C\u00f3digos",
    "Show advanced search": "Mostrar b\u00fasqueda avanzada",
    "Show all": "Mostrar todas",
    "Show changes": "Mostrar cambios",
    "Show daily history": "Mostrar historial diario",
    "Show property names": "Mostrar nombres de propiedades",
    "Side Nav Menu": "Men\u00fa Lateral de Navegaci\u00f3n",
    "Single Sign On (SSO)": "Single Sign On (SSO)",
    "Single select": "Selecci\u00f3n \u00fanica",
    "Site name": "Nombre del sitio",
    "Site name used in email sending": "Nombre del sitio utilizado en el env\u00edo de email",
    "Site title": "T\u00edtulo del sitio",
    "Site title shown in a browser tab": "T\u00edtulo del sitio mostrado en una pesta\u00f1a del navegador",
    "Size": "Tama\u00f1o",
    "Sort": "Ordenar",
    "Sort ascending": "Ordenar de forma ascendente",
    "Sort descending": "Ordenar de forma descendente",
    "Space (1 000 000)": "Espacio (1 000 000)",
    "Space Used": "Espacio utilizado",
    "Space Used / Quota": "Espacio utilizado / Cuota",
    "Space used": "Espacio utilizado",
    "Specific people with email address": "Personas espec\u00edficas con direcci\u00f3n de correo electr\u00f3nico",
    "Specific users in the team": "Usuarios espec\u00edficos del equipo",
    "Star": "Marcar",
    "Start date": "Fecha Inicio",
    "Statistic": "Estad\u00edstica",
    "Statistics": "Estad\u00edsticas",
    "Status": "Estado",
    "Status: enabled": "Status: habilitado",
    "Storage": "Almacenamiento",
    "Storage Backend": "Backend de Almacenamiento",
    "Storage Used": "Espacio Utilizado",
    "Strong password": "Contrase\u00f1a segura",
    "Style": "Estilo",
    "Submit": "Enviar",
    "Success": "\u00c9xito",
    "Successfully added %s.": "Se agreg\u00f3 correctamente %s.",
    "Successfully added label(s) for library {placeholder}": "Etiqueta(s) agregada(s) con \u00e9xito para la biblioteca {placeholder}",
    "Successfully added the file.": "Archivo agregado con \u00e9xito.",
    "Successfully added {email_placeholder}": "{email_placeholder} agregado con \u00e9xito",
    "Successfully change the group": "Se ha cambiado el grupo correctamente",
    "Successfully changed library password.": "Contrase\u00f1a de la biblioteca cambiada con \u00e9xito.",
    "Successfully changed the office suite.": "Se ha cambiado la suite de oficina con \u00e9xito.",
    "Successfully cleaned all errors.": "Errores eliminados con \u00e9xito.",
    "Successfully cleaned invalid share links.": "Enlaces de uso compartido inv\u00e1lidos limpiados con \u00e9xito.",
    "Successfully cleaned invalid upload links.": "Enlaces de carga inv\u00e1lidos limpiados con \u00e9xito.",
    "Successfully cleared trash.": "Papelera vaciada con \u00e9xito.",
    "Successfully converted the file.": "Archivo convertido correctamente.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s y otros %(amount)s elementos copiados con \u00e9xito.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s y 1 otro \u00edtem copiados con \u00e9xito.",
    "Successfully copied %(name)s.": "%(name)s copiados con \u00e9xito.",
    "Successfully copied files to another library.": "Archivos copiados con \u00e9xito a otra biblioteca.",
    "Successfully copied {name} and {n} other items": "Se copi\u00f3 correctamente {name} y {n} otros elementos",
    "Successfully deleted 1 item": "1 \u00edtem eliminado con \u00e9xito",
    "Successfully deleted 1 item.": "1 \u00edtem eliminado con \u00e9xito",
    "Successfully deleted 1 share link": "Se elimin\u00f3 correctamente 1 enlace de compartir",
    "Successfully deleted 1 upload link": "1 enlace de subida eliminado con \u00e9xito",
    "Successfully deleted 1 user.": "1 usuario eliminado con \u00e9xito.",
    "Successfully deleted {name}": "Eliminado con \u00e9xito {name}",
    "Successfully deleted {name} and {n} other items": "Se han eliminado correctamente {name} y {n} elementos adicionales",
    "Successfully deleted {name} and {n} other items.": "Se han eliminado correctamente {name} y {n} elementos adicionales.",
    "Successfully deleted {name}.": "{name} eliminado con \u00e9xito.",
    "Successfully deleted {number_placeholder} share links": "Se eliminaron correctamente {number_placeholder} enlaces de compartir",
    "Successfully deleted {number_placeholder} upload links": "{number_placeholder} enlaces de subida eliminados con \u00e9xito",
    "Successfully deleted {user_number_placeholder} users.": "{user_number_placeholder} usuarios eliminados con \u00e9xito.",
    "Successfully edited labels.": "Etiquetas editadas con \u00e9xito",
    "Successfully imported tags.": "Etiquetas importadas correctamente.",
    "Successfully imported {user_placeholder}": "Se han importado correctamente {user_placeholder}",
    "Successfully invited %(email) and %(num) other people.": "%(email) y  otros %(num) invitados con \u00e9xito.",
    "Successfully invited %(email).": "%(email) invitado con \u00e9xito.",
    "Successfully modified permission.": "Permiso modificado con \u00e9xito.",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s y otros %(amount)s elementos movidos con \u00e9xito.",
    "Successfully moved %(name)s and 1 other item.": "%(name)s y 1 otro \u00edtem movidos con \u00e9xito.",
    "Successfully moved %(name)s.": "%(name)s movido con \u00e9xito.",
    "Successfully moved files to another library.": "Archivos movidos con \u00e9xito a otra biblioteca.",
    "Successfully moved {name} and {n} other items": "Se movi\u00f3 correctamente {name} y {n} otros elementos",
    "Successfully moved {name}.": "Movido con \u00e9xito {name}.",
    "Successfully removed {placeholder}.": "{placeholder} eliminado con \u00e9xito.",
    "Successfully renamed the library.": "Biblioteca renombrada con \u00e9xito.",
    "Successfully restored the library {library_name}.": "Restaurada la biblioteca {library_name}.",
    "Successfully restored the library.": "Biblioteca restaurada con \u00e9xito.",
    "Successfully restored.": "Restaurado con \u00e9xito.",
    "Successfully revoke the admin permission of %s": "Los permisos de administrador de %s fueron revocados",
    "Successfully revoked access of user {placeholder}.": "El acceso del usuario {placeholder} fue revocado con \u00e9xito.",
    "Successfully revoked the admin permission of {placeholder}.": "Permisos de {placeholder} fueron revocados con \u00e9xito.",
    "Successfully saved": "Guardado con \u00e9xito",
    "Successfully sent to {placeholder}": "Enviado con \u00e9xito a  {placeholder}",
    "Successfully set %s as admin.": "%s asignado como administrador.",
    "Successfully set it.": "Establecido con \u00e9xito",
    "Successfully set library history.": "Historial de biblioteca establecido con \u00e9xito.",
    "Successfully set quota.": "Cuota establecida con  \u00e9xito.",
    "Successfully starred {library_name_placeholder}.": "Marcado con \u00e9xito {library_name_placeholder}.",
    "Successfully starred {name_placeholder}.": "Se ha marcado con \u00e9xito {name_placeholder}.",
    "Successfully transferred the group.": "Grupo transferido con \u00e9xito.",
    "Successfully transferred the library.": "Biblioteca transferida con \u00e9xito.",
    "Successfully unlinked %(name)s.": "Desvinculado exitosamente %(name)s.",
    "Successfully unlinked the device.": "Dispositivo desvinculado con \u00e9xito.",
    "Successfully unshared library {placeholder}": "Se dej\u00f3 de compartir la biblioteca {placeholder} exitosamente",
    "Successfully unshared {name}": "Dejado de compartir con \u00e9xito {name}",
    "Successfully unstarred {library_name_placeholder}.": "Desmarcado con \u00e9xito {library_name_placeholder}.",
    "Successfully unstarred {name_placeholder}.": "Se ha desmarcado con \u00e9xito {name_placeholder}.",
    "Successfully unwatched the library.": "Biblioteca desobservada con \u00e9xito.",
    "Successfully watched the library.": "Biblioteca observada con \u00e9xito.",
    "Suggestion": "Sugerencia",
    "Switch sort mode": "Cambiar modo de ordenaci\u00f3n",
    "Switch to plain text editor": "Cambiar a editor de texto sin formato",
    "Switch to rich text editor": "Cambiar a editor de texto enriquecido",
    "Switch view mode": "Cambiar modo de vista",
    "Symbol position": "Posici\u00f3n del s\u00edmbolo",
    "Sync": "Sincronizar",
    "Sync Download": "Descargar Sinc",
    "Sync Traffic": "Tr\u00e1fico de sincronizaci\u00f3n",
    "Sync Upload": "Subir Sinc",
    "System": "Sistema",
    "System Admin": "Administraci\u00f3n del Sistema",
    "System Info": "Informaci\u00f3n del Sistema",
    "System settings updated": "Configuraciones del sistema actualizadas",
    "Table": "Tabla",
    "Tag": "Etiqueta",
    "Tag not found": "No hay opciones disponibles",
    "Tagged Files": "Archivos Etiquetados",
    "Tags": "R\u00f3tulos",
    "Tags migrated successfully": "Etiquetas migradas con \u00e9xito",
    "Team deleted": "Equipo eliminado",
    "Team name": "Nombre del equipo",
    "Template": "Plantilla",
    "Terms": "T\u00e9rminos",
    "Terms and Conditions": "T\u00e9rminos y Condiciones",
    "Text": "Texto",
    "Text file extensions": "Extensiones de archivos de texto",
    "Text is required.": "Se requiere texto.",
    "Text wraps": "Ajuste de texto",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "El contenido del documento ha excedido el l\u00edmite de 100000 caracteres y solo se guardan los primeros 100000 caracteres",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "El contenido del documento ha excedido el l\u00edmite de 100000 caracteres y no se puede guardar",
    "The current quota for {group_name} is {quota}": "La cuota actual para {group_name} es {quota}",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "La parte personalizada de la URL debe tener entre 5 y 30 caracteres y solo puede contener letras (a-z), n\u00fameros y guiones.",
    "The file is too large. Allowed maximum size is 1MB.": "El archivo es demasiado grande. El tama\u00f1o m\u00e1ximo admitido es 1MB.",
    "The image could not be previewed.": "No se pudo previsualizar la imagen.",
    "The import process may take several minutes depending on the size of your Confluence export.": "El proceso de importaci\u00f3n puede tardar varios minutos dependiendo del tama\u00f1o de tu exportaci\u00f3n de Confluence.",
    "The imported options already exists": "Las opciones importadas ya existen",
    "The imported options are invalid": "Las opciones importadas son inv\u00e1lidas",
    "The least number of characters a share/upload link password should include.": "El m\u00ednimo n\u00famero de caracteres que deber\u00eda incluir una contrase\u00f1a de compartir/enlace de subida.",
    "The least number of characters an encrypted library password should include.": "El m\u00ednimo n\u00famero de caracteres que deber\u00eda contener la contrase\u00f1a de una biblioteca encriptada.",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "El nivel (1-4) de seguridad de una contrase\u00f1a de compartir/enlace de subida. Por ejemplo, '3' significa que la contrase\u00f1a debe contener al menos 3 de los siguientes: n\u00fameros, may\u00fasculas, min\u00fasculas y otros s\u00edmbolos",
    "The link is copied to the clipboard.": "Enlace copiado al portapapeles.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "La lista de archivos agregados, eliminados y modificados ser\u00e1 enviada a su casilla de correo.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "El n\u00famero m\u00e1ximo de intentos de acceso fallidos antes de mostrar el CAPTCHA.",
    "The name \"{name}\" is already taken. Please choose a different name.": "El nombre '{name}' ya est\u00e1 en uso, por favor escoja otro nombre.",
    "The next month": "El pr\u00f3ximo mes",
    "The next numbers of days": "Los pr\u00f3ximos d\u00edas",
    "The next week": "La pr\u00f3xima semana",
    "The next year": "El pr\u00f3ximo a\u00f1o",
    "The owner of this library has run out of space.": "El due\u00f1o de esta biblioteca se qued\u00f3 sin espacio.",
    "The password is too short.": "La contrase\u00f1a es demasiado corta.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "La contrase\u00f1a es demasiado d\u00e9bil. Debe incluir al menos {passwordStrengthLevel} de los siguientes: n\u00famero, letra may\u00fascula, letra min\u00fascula y otros s\u00edmbolos.",
    "The password will be kept in the server for only 1 hour.": "La contrase\u00f1a ser\u00e1 almacenada en el servidor por 1 hora.",
    "The past month": "El mes pasado",
    "The past numbers of days": "Los d\u00edas pasados",
    "The past week": "La semana pasada",
    "The past year": "El a\u00f1o pasado",
    "The path has been copied to the clipboard": "La ruta ha sido copiada al portapapeles",
    "The row is locked and cannot be modified": "La fila est\u00e1 bloqueada y no se puede modificar",
    "The uploaded image has not been saved yet. Please close this page later.": "La imagen subida a\u00fan no se ha guardado. Por favor, cierre esta p\u00e1gina m\u00e1s tarde.",
    "There is another option with this name": "Ya existe otra opci\u00f3n con este nombre",
    "There is another property with this name": "Ya existe otra propiedad con este nombre",
    "There is no information to display.": "No hay informaci\u00f3n para mostrar.",
    "This file has (apparently) not been accessed yet": "Este archivo todav\u00eda no ha sido accedido (aparentemente)",
    "This file has been updated.": "Este archivo ha sido actualizado.",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "Esta carpeta ha sido compartida con {user_amount} usuario(s) y {group_amount} grupo(s).",
    "This folder has no content at this time.": "Esta carpeta no tiene contenido en este momento.",
    "This is a special group representing a department.": "Este es un grupo especial que representa a un departamento.",
    "This is required": "Esto es obligatorio",
    "This library contains tags of old version. Do you like to migrate the tags to new version?": "Esta biblioteca contiene etiquetas de versi\u00f3n antigua. \u00bfTe gustar\u00eda migrar las etiquetas a la nueva versi\u00f3n?",
    "This library has been set to read-only by admin and cannot be updated.": "Esta biblioteca ha sido configurada como de s\u00f3lo lectura, y no puede ser actualizada.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "Esta biblioteca ha sido compartida con {user_amount} usuario(s) y {group_amount} grupo(s).",
    "This library is password protected": "Esta biblioteca est\u00e1 protegida por contrase\u00f1a",
    "This list is collapsed": "Esta lista est\u00e1 colapsada",
    "This month": "Este mes",
    "This operation will not be reverted. Please think twice!": "Esta operaci\u00f3n no se puede revertir. \u00bfEst\u00e1s seguro?",
    "This property can not be deleted": "Esta propiedad no se puede eliminar",
    "This property does not support sorting": "Esta propiedad no admite ordenaci\u00f3n",
    "This property is not editable": "Esta propiedad no es editable",
    "This user has not created or joined any groups": "Este usuario no ha creado ni se ha unido a ning\u00fan grupo",
    "This week": "Esta semana",
    "This year": "Este a\u00f1o",
    "Thousands separator": "Separador de miles",
    "Thumbnail": "Miniatura",
    "Time": "Fecha",
    "Tip: -2 means no limit.": "Ayuda: -2 significa sin l\u00edmite.",
    "Tip: 0 means default limit": "Tip: con 0 se mantiene el l\u00edmite predeterminado",
    "Tip: 0 means default limit, the unit is MB": "Sugerencia: 0 significa l\u00edmite predeterminado, la unidad es MB",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Consejo: una instant\u00e1nea ser\u00e1 generada despu\u00e9s de cada modificaci\u00f3n, para almacenar el estado posterior a la modificaci\u00f3n.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Consejo: bibliotecas eliminadas hace {placeholder} d\u00edas ser\u00e1n removidas autom\u00e1ticamente.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Consejo: bibliotecas eliminadas hace {trashReposExpireDays} d\u00edas ser\u00e1n removidas autom\u00e1ticamente.",
    "Tip: you can search by keyword in name or ID.": "Consejo: puede buscar por palabra clave en el nombre o ID.",
    "Tip: you can search by keyword in name.": "Consejo: puede buscar por palabra clave en el nombre.",
    "Tips: There are tags of old version. Please migrate tags to new version.": "Tips: Hay etiquetas de la versi\u00f3n antigua. Por favor migre las etiquetas a la nueva versi\u00f3n.",
    "Tips: These are tags of old version. The feature is deprecated and can no longer be used.": "Tips: Esta es una caracter\u00edstica deprecada y ya no se puede utilizar.",
    "Title property": "Propiedad de t\u00edtulo",
    "To confirm, type \"{placeholder}\" in the box below": "Para confirmar, escriba \"{placeholder}\" en la caja de texto a continuaci\u00f3n",
    "Today": "Hoy",
    "Toggle children": "Alternar hijos",
    "Toggle repo selector": "Alternar selector de biblioteca",
    "Toggle selector menu": "Alternar men\u00fa de selector",
    "Toggle user selector": "Alternar selector de usuario",
    "Token": "Identificador",
    "Token:": "Identificador:",
    "Tomorrow": "Ma\u00f1ana",
    "Too many requests": "Demasiadas solicitudes",
    "Total Devices": "Total de Dispositivos",
    "Total Storage": "Almacenamiento Total",
    "Total Traffic": "Tr\u00e1fico total",
    "Total Users": "Usuarios Total",
    "Total users": "Usuarios totales",
    "Total {comments_count} comment": "Total {comments_count} comentario",
    "Total {comments_count} comments": "Total {comments_count} comentarios",
    "Traffic": "Tr\u00e1fico",
    "Traffic exceeded": "Tr\u00e1fico excedido",
    "Traffic this month": "Tr\u00e1fico este mes",
    "Transfer": "Transferir",
    "Transfer From": "Transferir desde",
    "Transfer Group": "Tranferir Grupo",
    "Transfer Group {placeholder} to": "Transferir Grupo {placeholder} a",
    "Transfer Library": "Transferir Biblioteca",
    "Transfer Library {library_name}": "Transferir Biblioteca {library_name}",
    "Transfer To": "Transferir a",
    "Transfer group to": "Transferir el grupo a",
    "Transfer to department": "Transferir al departamento",
    "Transfer to user": "Transferir al usuario",
    "Transferred group {group_name} from {user_from} to {user_to}": "Grupo {group_name} transferido de {user_from} a {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "Biblioteca {library_name} transferida de  {user_from} a {user_to}",
    "Trash": "Papelera",
    "Turn off": "Desactivar",
    "Turn off extended properties": "Desactivar propiedades extendidas",
    "Turn off face recognition": "Desactivar reconocimiento facial",
    "Turn off tags": "Desactivar etiquetas",
    "Turn on extensible properties and views to experience a new way of managing files": "Activa propiedades y vistas extensibles para experimentar una nueva manera de gestionar archivos",
    "Two-Factor Authentication": "Autenticaci\u00f3n de dos Factores",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "La autenticaci\u00f3n de dos factores no est\u00e1 habilitada para su cuenta. Habilite autenticaci\u00f3n de dos factores para seguridad mejorada.",
    "Type": "Tipo",
    "Type characters to start search": "Escriba caracteres para iniciar la b\u00fasqueda",
    "URL is copied to the clipboard": "URL copiada al portapapeles",
    "URL is required": "URL es requerida",
    "US": "EE.UU.",
    "Uncategorized": "Sin categor\u00eda",
    "Undo": "Deshacer",
    "Unfold": "Descolapsar",
    "Unfold the sidebar": "Unfold the sidebar",
    "Unfreeze Document": "Descongelar documento",
    "Unhandled": "Sin manejar",
    "Unknown": "Desconocido",
    "Unknown people": "Personas desconocidas",
    "Unlink": "Desvincular",
    "Unlink device": "Desvincular dispositivo",
    "Unlock": "Desbloquear",
    "Unpublish": "Dejar de publicar",
    "Unpublish Wiki": "Dejar de publicar Wiki",
    "Unresolved comments": "Comentarios no resueltos",
    "Unselect": "Deseleccionar",
    "Unselect all": "Deseleccionar todo",
    "Unselect all items": "Deseleccionar todos los elementos",
    "Unselect items": "Deseleccionar \u00edtems",
    "Unselect this item": "Deseleccionar este elemento",
    "Unshare": "Dejar de compartir",
    "Unshare Library": "Dejar de compartir Biblioteca",
    "Unstar": "Desmarcar",
    "Untitled": "Sin t\u00edtulo",
    "Unwatch File Changes": "Dejar de observar cambios de archivo",
    "Up": "Arriba",
    "Update": "Actualizar",
    "Update Terms and Conditions": "Actualizar T\u00e9rminos y Condiciones",
    "Update password": "Actualizar contrase\u00f1a",
    "Update succeeded.": "Actualizaci\u00f3n exitosa.",
    "Update time": "Hora de actualizaci\u00f3n",
    "Updated draft": "Borrador actualizado",
    "Updated file": "Archivo actualizado",
    "Upgrade to Pro Edition": "Actualizar a Versi\u00f3n Pro",
    "Upload": "Subir archivo",
    "Upload Files": "Subir archivos",
    "Upload Folder": "Carpeta de Subida",
    "Upload Link": "Link de subida",
    "Upload Links": "Enlaces de subida",
    "Upload failed": "Error al subir",
    "Upload file": "Subir archivo",
    "Upload files to": "Subir archivos a",
    "Upload license": "Subir licencia",
    "Upload link is copied to the clipboard.": "Enlace de subida copiado al portapapeles",
    "Uploaded": "Subido",
    "Uploading...": "Subiendo...",
    "Use custom CSS": "Utilizar CSS personalizado",
    "Use information from your Identity Provider to configure Seafile": "Utiliza la informaci\u00f3n de tu Proveedor de Identidad para configurar Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "Utilice la funci\u00f3n de importar/exportar para transferir opciones r\u00e1pidamente. (La exportaci\u00f3n est\u00e1 en formato JSON). Tambi\u00e9n puede agregar opciones r\u00e1pidamente pegando celdas copiadas desde una columna de texto, un archivo Excel o un archivo TXT.",
    "Use these values to configure your Identity Provider": "Utiliza estos valores para configurar tu Proveedor de Identidad",
    "Used:": "Utilizado:",
    "User": "Usuario",
    "User Email": "Email del Usuario",
    "User ID": "ID de Usuario",
    "User Permission": "Permiso del usuario",
    "User Shares": "Comparticiones de Usuario",
    "User Storage": "Almacenamiento de Usuario",
    "User can not see this folder.": "El usuario no puede ver esta carpeta.",
    "User can only view files online via browser. Files can't be downloaded.": "El usuario s\u00f3lo puede ver archivos en l\u00ednea con el navegador. Los archivos no pueden ser descargados.",
    "User can read, download and sync files.": "El usuario puede leer, descargar y sincronizar archivos.",
    "User can read, write, upload, download and sync files.": "El usuario puede leer, escribir, subir, descargar y sincronizar archivos.",
    "User can view and edit file online via browser. Files can't be downloaded.": "El usuario  puede ver y editar archivos en l\u00ednea con el navegador. Los archivos no pueden ser descargados.",
    "User default quota": "Cuota predeterminada de usuario",
    "User default quota updated": "Cuota predeterminada de usuario actualizada",
    "User deleted": "Usuario eliminado",
    "User info updated": "Informaci\u00f3n de usuario actualizada",
    "User is already in this group": "El usuario ya est\u00e1 en este grupo",
    "User migrate from {user_from} to {user_to}": "Usuario migrado de {user_from} a {user_to}",
    "User not found": "Usuario no encontrado",
    "User number limit": "L\u00edmite de n\u00famero de usuarios",
    "User {user_link} has added you to {group_link}": "El usuario {user_link} te ha agregado a {group_link}",
    "Username:": "Nombre de usuario:",
    "Users": "Usuarios",
    "Value": "Valor",
    "Verified": "Verificado",
    "Verify": "Verificar",
    "Verify Domain": "Verificar Dominio",
    "Version": "Versi\u00f3n",
    "Version Number": "N\u00famero de Versi\u00f3n",
    "Version Number is required.": "Se requiere N\u00famero de Versi\u00f3n.",
    "Version Number must be a number.": "N\u00famero de Versi\u00f3n debe ser un n\u00famero.",
    "Video": "Video",
    "View": "Ver",
    "View Link": "Ver Enlace",
    "View Related Snapshot": "Ver instant\u00e1nea relacionada",
    "View Snapshot": "Ver inst\u00e1ntanea",
    "View all notifications": "Ver todas las notificaciones",
    "View original image": "Ver imagen original",
    "View profile and more": "Ver perfil y m\u00e1s",
    "View published page": "Ver p\u00e1gina publicada",
    "Views": "Vistas",
    "Virus": "Virus",
    "Virus File": "Archivo de Virus",
    "Virus Scan": "An\u00e1lisis de Virus",
    "Visit count": "Recuento de visitas",
    "Visit old version page": "Visitar p\u00e1gina de versi\u00f3n antigua",
    "Visited": "Visitado",
    "Visits": "Visitas",
    "Waiting...": "Esperando...",
    "Watch File Changes": "Observar cambios de archivo ",
    "Web API Auth Token": "Web API Auth Token",
    "Web Download": "Descargar Web",
    "Web Traffic": "Tr\u00e1fico Web",
    "Web Upload": "Subir Web",
    "WebDAV Access": "Acceso WebDAV",
    "WebDAV password:": "Contrase\u00f1a WebDAV:",
    "WebDAV username:": "Nombre de usuario WebDAV:",
    "Welcome to {site_name_placeholder}": "Bienvenido a {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "Si las notificaciones de colaboraci\u00f3n como compartir bibliotecas o unirse a un grupo deben ser enviadas a su casilla de correo.",
    "Wiki custom URL deleted": "URL personalizada eliminada",
    "Wiki owner": "Propietario de wiki",
    "Wiki published": "Wiki publicado",
    "Wikis": "Wikis",
    "Workspace": "Espacio de trabajo",
    "Wrong password": "Contrase\u00f1a incorrecta",
    "Year": "A\u00f1o",
    "Yesterday": "Ayer",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Tambi\u00e9n puedes agregar un usuario como invitado, que no podr\u00e1 crear bibliotecas ni grupos.",
    "You can click the \"Add Wiki\" button below to add a new Wiki.": "Puede hacer clic en el bot\u00f3n \"Agregar Wiki\" debajo para agregar una nueva Wiki.",
    "You can create files quickly": "Puedes crear archivos r\u00e1pidamente",
    "You can create libraries by clicking the \"New Library\" item in the dropdown menu.": "Puedes crear bibliotecas haciendo clic en el elemento \"Nueva biblioteca\" del men\u00fa desplegable.",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "Puede ingresar m\u00faltiples direcciones de correo electr\u00f3nico. Se enviar\u00e1 un enlace de invitaci\u00f3n a cada uno de ellos.",
    "You can use this field at login.": "Puede utilizar este campo para iniciar sesi\u00f3n",
    "You do not have permission": "No tienes permiso",
    "You don't have any favorite items yet": "Todav\u00eda no tienes items favoritos",
    "You don't have any share links": "No tienes enlaces de compartir",
    "You don't have any upload links": "No tienes ning\u00fan enlace de subida",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Todav\u00eda no has accedido a tus archivos con ning\u00fan cliente (escritorio o m\u00f3vil). Configura clientes en tus dispositivos para acceder a tus datos de una forma m\u00e1s c\u00f3moda.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "Todavia no has agregado bibliotecas, carpetas o archivos a tu lista de favoritos. La lista de favoritos te brinda un acceso r\u00e1pido a los objetos que ulilizas con mayor frecuencia. Puedes agregar una biblioteca, carpeta o archivo a tu lista de favoritos haciendo click en la esrtella que est\u00e1 a la izquierda de su nombre.",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" item in the dropdown menu.": "A\u00fan no ha creado ninguna biblioteca. Una biblioteca es un contenedor para organizar sus archivos y carpetas. Una biblioteca tambi\u00e9n se puede compartir con otras personas y sincronizar con sus dispositivos conectados. Puede crear una biblioteca haciendo clic en el elemento \"Nueva Biblioteca\" en el men\u00fa desplegable.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "Todav\u00eda no has creado enlaces de compartir. Un enlace de compartir se puede utilizar para compartir archivos y carpetas con cualquier persona. Puedes crear un enlace de compartir para un archivo o una carpeta haciendo click en el icono de compartir que est\u00e1 a la derecha de su nombre.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "Todav\u00eda no has creado enlaces de subida. Un enlace de subida permite que cualquier persona suba archivos a una carpeta o biblioteca. Puedes crear un enlace de subida para una carpeta o biblioteca haciendo click en el icono de compartir que est\u00e1 a la derecha de su nombre.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "No has eliminado bibliotecas en los \u00faltimos {placeholder} d\u00edas. Una biblioteca eliminada ser\u00e1 removida autom\u00e1ticamente una vez transcurrido este per\u00edodo.",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" item in the dropdown menu.": "Todav\u00eda no ha invitado a ning\u00fan invitado. Un invitado puede acceder a las bibliotecas compartidas a trav\u00e9s de la interfaz web, lo que permite formas m\u00e1s eficientes de colaborar que a trav\u00e9s de enlaces. Puede invitar a un invitado haciendo clic en el elemento \"Invitar Invitado\" en el men\u00fa desplegable.",
    "You have not shared any folders": "No has compartido ninguna carpeta",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "Todav\u00eda no has compartido carpetas con otros usuarios. Puedes compartir una carpeta con otros usuarios haciendo click en el icono compartir que est\u00e1 a la derecha del nombre de la carpeta.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "Todav\u00eda no has compartido bibliotecas con otros usuarios. Puedes compartir una biblioteca con otros usuarios haciendo click en el icono compartir que est\u00e1 a la derecha del nombre de la biblioteca en \"Mis Bibliotecas\"",
    "You have only one backup code remaining.": "Le queda solamente un c\u00f3digo de resguardo.",
    "You have {num} backup codes remaining.": "Le quedan  {num} c\u00f3digos de resguardo.",
    "Your name": "Tu nombre",
    "Your notifications will be sent to this email.": "Las notificaciones ser\u00e1n enviadas a esta direcci\u00f3n.",
    "Yuan": "Yuan",
    "ZIP": "ZIP",
    "Zoom in": "Acercar",
    "Zoom out": "Alejar",
    "all": "todos",
    "all members": "todos los miembros",
    "contains": "Contiene",
    "copy": "copiar",
    "days": "d\u00edas",
    "deleted": "eliminado",
    "deleted option": "opci\u00f3n eliminada",
    "details": "detalles",
    "does not contain": "No contiene",
    "email is required": "direcci\u00f3n de correo requerida",
    "freezed": "Congelado",
    "has all of...": "tiene todos los...",
    "has any of...": "tiene alguno de...",
    "has none of...": "no tiene ninguno de...",
    "icon": "icono",
    "in all libraries": "en todas las bibliotecas",
    "in this folder": "en esta carpeta",
    "in this library": "en esta biblioteca",
    "include the current user": "Incluirme",
    "is": "Es",
    "is after...": "es despu\u00e9s de...",
    "is any of...": "es cualquiera de...",
    "is before...": "es antes de...",
    "is current user's ID": "Es el ID de usuario actual",
    "is empty": "Est\u00e1 vac\u00edo",
    "is exactly...": "es exactamente...",
    "is none of...": "no es ninguno de...",
    "is not": "No es",
    "is not empty": "No est\u00e1 vac\u00edo",
    "is on or after...": "es el d\u00eda o despu\u00e9s de...",
    "is on or before...": "es el d\u00eda o antes de...",
    "is within...": "est\u00e1 dentro de...",
    "items": "elementos",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "licenciado a {placeholder_license_to},  caduca en {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "licenciado a {placeholder_license_to}, servicio de actualizaci\u00f3n caducado en {placeholder_license_expiration}",
    "locked": "bloqueado",
    "locked by {name}": "bloqueado por {name}",
    "members": "Miembros",
    "mm": "mm",
    "name": "nombre",
    "not set": "no establecido",
    "only show {placeholder}": "mostrar s\u00f3lo {placeholder}",
    "progress": "progreso",
    "s": "s",
    "selected": "seleccionado",
    "show more": "ver m\u00e1s",
    "size": "tama\u00f1o",
    "sorts": "Ordenes",
    "starred": "marcado",
    "state": "estado",
    "successfully added user %s.": "usuario %s  agregado con \u00e9xito.",
    "successfully sent email to %s.": "successfully sent email to %s.",
    "tags": "etiquetas",
    "unstarred": "desmarcado",
    "xxx cells copied": "xxx celdas copiadas",
    "xxx cells cut": "xxx celdas recortadas",
    "xxx cells selected": "xxx celdas seleccionadas",
    "xxx record": "xxx registro",
    "xxx records": "xxx registros",
    "xxx records selected": "xxx registros seleccionados",
    "xxx rows are copied.": "xxx filas copiadas.",
    "you can also press \u2192": "tambi\u00e9n puedes presionar \u2192 ",
    "{failed_files_num} file(s) failed to upload": "{failed_files_num} archivo(s) fallaron al subir",
    "{file} and {n} other files": "{file} y {n} otros archivos",
    "{library_name} Office Suite": "Suite de Oficina de {library_name}",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} d\u00edas",
    "{name_placeholder} cells copied": "{name_placeholder} celdas copiadas",
    "{name_placeholder} cells cut": "{name_placeholder} celdas cortadas",
    "{name_placeholder} cells selected": "{name_placeholder} celdas seleccionadas",
    "{name_placeholder} hidden properties": "{name_placeholder} propiedades ocultas",
    "{name_placeholder} preset hidden properties": "{name_placeholder} propiedades ocultas preestablecidas",
    "{name_placeholder} record": "{name_placeholder} registro",
    "{name_placeholder} records": "{name_placeholder} registros",
    "{name_placeholder} records selected": "{name_placeholder} registros seleccionados",
    "{name_placeholder} rows are copied.": "{name_placeholder} filas copiadas.",
    "{name} rows use this option.": "{name} filas usan esta opci\u00f3n.",
    "{number_placeholder} / Page": "{number_placeholder} / P\u00e1gina",
    "{placeholder} API Token": "{placeholder} API Token",
    "{placeholder} Access Log": "Registro de acceso a {placeholder}",
    "{placeholder} Folder Permission": "{placeholder} Permiso de Carpeta",
    "{placeholder} History Setting": "{placeholder} Configuraci\u00f3n del historial",
    "{placeholder} Modification History": "Historial de Cambios de {placeholder}",
    "{placeholder} Share Admin": "Administrador de Compartici\u00f3n de {placeholder}",
    "{placeholder} Snapshot": "{placeholder} Instant\u00e1nea",
    "{placeholder} Trash": "{placeholder} Papelera",
    "{placeholder} Wiki Trash": "{placeholder} Papelera de Wiki",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} ha cancelado el uso compartido de la carpeta {repo_name}.",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} ha cancelado el uso compartido de la biblioteca {repo_name}.",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} ha cambiado el permiso de la carpeta {repo_link} a {permission}.",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} ha cambiado el permiso de la biblioteca {repo_link} a {permission}.",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} ha compartido una carpeta llamada {repo_link} al grupo {group_link}.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} ha compartido una carpeta llamada {repo_link} contigo.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} ha compartido una biblioteca llamada {repo_link} al grupo {group_link}.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} ha compartido una biblioteca llamada {repo_link} contigo.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "{site_name_placeholder} organiza los archivos en bibliotecas. Cada biblioteca se puede sincronizar y compartir por separado. Sin embargo, ya que eres un invitado, no puedes crear bibliotecas.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder} organiza los archivos en bibliotecas. Cada biblioteca se puede sincronizar y compartir por separado. Se ha creado una biblioteca personal. Puedes crear m\u00e1s despu\u00e9s.",
    "{uploaded_files_num}/{all_files_num} Files": "Archivo(s) {uploaded_files_num}/{all_files_num}",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "{userCount} usuario(s) y {repoCount} bibliotecas de esta organizaci\u00f3n tambi\u00e9n ser\u00e1n eliminados.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} ha creado el archivo {fileName} y {fileCount} archivo(s) m\u00e1s en la biblioteca {libraryName}.",
    "{user} created file {fileName} in library {libraryName}.": "{user} ha creado el archivo {fileName} en la biblioteca {libraryName}.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha creado la carpeta {folderName} y {folderCount} carpeta(s) m\u00e1s en la biblioteca {libraryName}.",
    "{user} created folder {folderName} in library {libraryName}.": "{user} ha creado la carpeta {folderName} en la biblioteca {libraryName}.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} ha eliminado el archivo {fileName} y {fileCount} archivo(s) m\u00e1s en la biblioteca {libraryName}.",
    "{user} deleted file {fileName} in library {libraryName}.": "{user} ha eliminado el archivo {fileName} en la biblioteca {libraryName}.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha eliminado la carpeta {folderName} y {folderCount} carpeta(s) m\u00e1s en la biblioteca {libraryName}.",
    "{user} deleted folder {folderName} in library {libraryName}.": "{user} ha eliminado la carpeta {folderName} en la biblioteca {libraryName}.",
    "{user} has transferred a library named {repo_link} to you.": "{user} te ha transferido una biblioteca llamada {repo_link}.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} ha movido el archivo {fileName} y {fileCount} archivo(s) m\u00e1s en la biblioteca {libraryName}.",
    "{user} moved file {fileName} in library {libraryName}.": "{user} ha movido el archivo {fileName} en la biblioteca {libraryName}.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha movido la carpeta {folderName} y {folderCount} carpeta(s) m\u00e1s en la biblioteca {libraryName}.",
    "{user} moved folder {folderName} in library {libraryName}.": "{user} ha movido la carpeta {folderName} en la biblioteca {libraryName}.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "{user} ha renombrado el archivo {oldFileName} a {fileName} en la biblioteca {libraryName}.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "{user} ha renombrado la carpeta {oldFolderName} a {folderName} en la biblioteca {libraryName}.",
    "{user} restored file {fileName} in library {libraryName}.": "{user} ha restaurado el archivo {fileName} en la biblioteca {libraryName}.",
    "{user} restored folder {folderName} in library {libraryName}.": "{user} ha restaurado la carpeta {folderName} en la biblioteca {libraryName}.",
    "{user} updated file {fileName} in library {libraryName}.": "{user} ha actualizado el archivo {fileName} en la biblioteca {libraryName}.",
    "{xxx} items have been selected": "Se han seleccionado {xxx} elementos"
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "j \\d\\e F \\d\\e Y \\a \\l\\a\\s H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%Y %H:%M",
      "%d/%m/%y %H:%M:%S",
      "%d/%m/%y %H:%M:%S.%f",
      "%d/%m/%y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "j \\d\\e F \\d\\e Y",
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y",
      "%d/%m/%y",
      "%Y%m%d",
      "%Y-%m-%d"
    ],
    "DECIMAL_SEPARATOR": ".",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "j \\d\\e F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i",
    "SHORT_DATE_FORMAT": "d/m/Y",
    "THOUSAND_SEPARATOR": ",",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F \\d\\e Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

