# Generated by Django 4.2.2 on 2024-08-27 14:16

from django.db import migrations, models
import django.db.models.deletion
import seahub.base.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='TermsAndConditions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(default='site-terms')),
                ('name', models.TextField(max_length=255)),
                ('version_number', models.DecimalField(decimal_places=2, default=1.0, max_digits=6)),
                ('text', models.TextField(blank=True, null=True)),
                ('info', models.TextField(blank=True, help_text="Provide users with some info about what's changed and why", null=True)),
                ('date_active', models.DateTimeField(blank=True, help_text='Leave Null To Never Make Active', null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Terms and Conditions',
                'verbose_name_plural': 'Terms and Conditions',
                'ordering': ['-date_active'],
                'get_latest_by': 'date_active',
            },
        ),
        migrations.CreateModel(
            name='UserTermsAndConditions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', seahub.base.fields.LowerCaseCharField(max_length=255)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True, verbose_name='IP Address')),
                ('date_accepted', models.DateTimeField(auto_now_add=True, verbose_name='Date Accepted')),
                ('terms', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='userterms', to='termsandconditions.termsandconditions')),
            ],
            options={
                'verbose_name': 'User Terms and Conditions',
                'verbose_name_plural': 'User Terms and Conditions',
                'get_latest_by': 'date_accepted',
                'unique_together': {('username', 'terms')},
            },
        ),
    ]
