CREATE TABLE IF NOT EXISTS RoleUploadRateLimit (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  role VARCHAR(255),
  upload_limit BIGINT,
  UNIQUE INDEX(role)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS RoleDownloadRateLimit (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  role VARCHAR(255),
  download_limit BIGINT,
  UNIQUE INDEX(role)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS UserUploadRateLimit (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  user VARCHAR(255),
  upload_limit BIGINT,
  UNIQUE INDEX(user)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS UserDownloadRateLimit (
  id BIGINT NOT NULL PRIMARY KEY AUTO_INCREMENT,
  user VARCHAR(255),
  download_limit BIGINT,
  UNIQUE INDEX(user)
) ENGINE=INNODB;

ALTER TABLE `WebUploadTempFiles` ADD INDEX IF NOT EXISTS `repo_id` (`repo_id`);
ALTER TABLE `RepoTokenPeerInfo` CHANGE COLUMN `peer_ip` `peer_ip` varchar(50);
