# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_stellar_global_optspecs
	string join \n global config-dir= f/filter-logs= q/quiet v/verbose very-verbose list no-cache h/help V/version
end

function __fish_stellar_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_stellar_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_stellar_using_subcommand
	set -l cmd (__fish_stellar_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c stellar -n "__fish_stellar_needs_command" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_needs_command" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_needs_command" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_needs_command" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_needs_command" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_needs_command" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_needs_command" -l list -d '⚠️ Deprecated, use `stellar plugin ls`. List installed plugins. E.g. `stellar-hello`'
complete -c stellar -n "__fish_stellar_needs_command" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_needs_command" -s V -l version -d 'Print version'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "contract" -d 'Tools for smart contract developers'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "doctor" -d 'Diagnose and troubleshoot CLI and network issues'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "events" -d 'Watch the network for contract events'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "env" -d 'Prints the environment variables'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "keys" -d 'Create and manage identities including keys and addresses'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "network" -d 'Configure connection to networks'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "container" -d 'Start local networks in containers'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "config" -d 'Manage cli configuration'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "snapshot" -d 'Download a snapshot of a ledger from an archive'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "tx" -d 'Sign, Simulate, and Send transactions'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "xdr" -d 'Decode and encode XDR'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "strkey" -d 'Decode and encode strkey'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "completion" -d 'Print shell completion code for the specified shell'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "cache" -d 'Cache for transactions and contract specs'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "version" -d 'Print version information'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "plugin" -d 'The subcommand for CLI plugins'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "ledger" -d 'Fetch ledger information'
complete -c stellar -n "__fish_stellar_needs_command" -f -a "fee-stats" -d 'Fetch network feestats'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "asset" -d 'Utilities to deploy a Stellar Asset Contract or get its id'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "alias" -d 'Utilities to manage contract aliases'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "bindings" -d 'Generate code client bindings for a contract'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "build" -d 'Build a contract from source'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "extend" -d 'Extend the time to live ledger of a contract-data ledger entry'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "deploy" -d 'Deploy a wasm contract'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "fetch" -d 'Fetch a contract\'s Wasm binary'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "id" -d 'Generate the contract id for a given contract or asset'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "info" -d 'Access info about contracts'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "init" -d 'Initialize a Soroban contract project'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "inspect" -d '⚠️ Deprecated, use `contract info`. Inspect a WASM file listing contract functions, meta, etc'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "upload" -d 'Install a WASM file to the ledger without creating a contract instance'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "install" -d '⚠️ Deprecated, use `contract upload`. Install a WASM file to the ledger without creating a contract instance'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "invoke" -d 'Invoke a contract function'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "optimize" -d '⚠️ Deprecated, use `build --optimize`. Optimize a WASM file'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "read" -d 'Print the current value of a contract-data ledger entry'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and not __fish_seen_subcommand_from asset alias bindings build extend deploy fetch id info init inspect upload install invoke optimize read restore" -f -a "restore" -d 'Restore an evicted value for a contract-data legder entry'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -f -a "id" -d 'Get Id of builtin Soroban Asset Contract. Deprecated, use `stellar contract id asset` instead'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from asset" -f -a "deploy" -d 'Deploy builtin Soroban Asset Contract'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -f -a "remove" -d 'Remove contract alias'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -f -a "add" -d 'Add contract alias'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -f -a "show" -d 'Show the contract id associated with a given alias'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from alias" -f -a "ls" -d 'List all aliases'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -f -a "json" -d 'Generate Json Bindings'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -f -a "rust" -d 'Generate Rust bindings'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -f -a "typescript" -d 'Generate a TypeScript / JavaScript package'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -f -a "python" -d 'Generate Python bindings'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -f -a "java" -d 'Generate Java bindings'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -f -a "flutter" -d 'Generate Flutter bindings'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -f -a "swift" -d 'Generate Swift bindings'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from bindings" -f -a "php" -d 'Generate PHP bindings'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l manifest-path -d 'Path to Cargo.toml' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l package -d 'Package to build' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l profile -d 'Build with the specified profile' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l features -d 'Build with the list of features activated, space or comma separated' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l out-dir -d 'Directory to copy wasm files to' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l meta -d 'Add key-value to contract meta (adds the meta to the `contractmetav0` custom section)' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l all-features -d 'Build with the all features activated'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l no-default-features -d 'Build with the default feature not activated'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l print-commands-only -d 'Print commands to build without executing them'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l optimize -d 'Optimize the generated wasm'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from build" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l ledgers-to-extend -d 'Number of ledgers to extend the entries' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l id -d 'Contract ID to which owns the data entries. If no keys provided the Contract\'s instance will be extended' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l key -d 'Storage key (symbols only)' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l key-xdr -d 'Storage key (base64-encoded XDR)' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l wasm -d 'Path to Wasm file of contract code to extend' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l wasm-hash -d 'Path to Wasm file of contract code to extend' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l durability -d 'Storage entry durability' -r -f -a "persistent\t'Persistent'
temporary\t'Temporary'"
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -s s -l source-account -l source -d 'Account that where transaction originates from. Alias `source`. Can be an identity (--source alice), a public key (--source GDKW...), a muxed account (--source MDA…), a secret key (--source SC36…), or a seed phrase (--source "kite urban…"). If `--build-only` or `--sim-only` flags were NOT provided, this key will also be used to sign the final transaction. In that case, trying to sign with public key will fail' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l sign-with-key -d 'Sign with a local key or key saved in OS secure storage. Can be an identity (--sign-with-key alice), a secret key (--sign-with-key SC36…), or a seed phrase (--sign-with-key "kite urban…"). If using seed phrase, `--hd-path` defaults to the `0` path' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l hd-path -d 'If using a seed phrase to sign, sets which hierarchical deterministic path to use, e.g. `m/44\'/148\'/{hd_path}`. Example: `--hd-path 1`. Default: `0`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l fee -d 'fee amount for transaction, in stroops. 1 stroop = 0.0000001 xlm' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l instructions -d 'Number of instructions to simulate' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l instruction-leeway -d 'Allow this many extra instructions when budgeting resources during transaction simulation' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l ttl-ledger-only -d 'Only print the new Time To Live ledger'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l sign-with-lab -d 'Sign with https://lab.stellar.org'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l sign-with-ledger -d 'Sign with a ledger wallet'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l cost -d 'Output the cost execution to stderr'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l build-only -d 'Build the transaction and only write the base64 xdr to stdout'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from extend" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l wasm -d 'WASM file to deploy' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l wasm-hash -d 'Hash of the already installed/deployed WASM file' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l salt -d 'Custom salt 32-byte salt for the token id' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -s s -l source-account -l source -d 'Account that where transaction originates from. Alias `source`. Can be an identity (--source alice), a public key (--source GDKW...), a muxed account (--source MDA…), a secret key (--source SC36…), or a seed phrase (--source "kite urban…"). If `--build-only` or `--sim-only` flags were NOT provided, this key will also be used to sign the final transaction. In that case, trying to sign with public key will fail' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l sign-with-key -d 'Sign with a local key or key saved in OS secure storage. Can be an identity (--sign-with-key alice), a secret key (--sign-with-key SC36…), or a seed phrase (--sign-with-key "kite urban…"). If using seed phrase, `--hd-path` defaults to the `0` path' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l hd-path -d 'If using a seed phrase to sign, sets which hierarchical deterministic path to use, e.g. `m/44\'/148\'/{hd_path}`. Example: `--hd-path 1`. Default: `0`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l fee -d 'fee amount for transaction, in stroops. 1 stroop = 0.0000001 xlm' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l instructions -d 'Number of instructions to simulate' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l instruction-leeway -d 'Allow this many extra instructions when budgeting resources during transaction simulation' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l alias -d 'The alias that will be used to save the contract\'s id. Whenever used, `--alias` will always overwrite the existing contract id configuration without asking for confirmation' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l sign-with-lab -d 'Sign with https://lab.stellar.org'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l sign-with-ledger -d 'Sign with a ledger wallet'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l cost -d 'Output the cost execution to stderr'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l build-only -d 'Build the transaction and only write the base64 xdr to stdout'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -s i -l ignore-checks -d 'Whether to ignore safety checks when deploying contracts'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from deploy" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l id -d 'Contract ID to fetch' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l wasm-hash -d 'Wasm to fetch' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -s o -l out-file -d 'Where to write output otherwise stdout is used' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -f -a "asset" -d 'Deploy builtin Soroban Asset Contract'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from id" -f -a "wasm" -d 'Deploy normal Wasm Contract'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -f -a "interface" -d 'Output the interface of a contract'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -f -a "meta" -d 'Output the metadata stored in a contract'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -f -a "env-meta" -d 'Output the env required metadata stored in a contract'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from info" -f -a "build" -d 'Output the contract build information, if available'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -l name -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -l overwrite
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from init" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -l wasm -d 'Path to wasm binary' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -l output -d 'Output just XDR in base64' -r -f -a "xdr-base64\t'XDR of array of contract spec entries'
xdr-base64-array\t'Array of xdr of contract spec entries'
docs\t'Pretty print of contract spec entries'"
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from inspect" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -s s -l source-account -l source -d 'Account that where transaction originates from. Alias `source`. Can be an identity (--source alice), a public key (--source GDKW...), a muxed account (--source MDA…), a secret key (--source SC36…), or a seed phrase (--source "kite urban…"). If `--build-only` or `--sim-only` flags were NOT provided, this key will also be used to sign the final transaction. In that case, trying to sign with public key will fail' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l sign-with-key -d 'Sign with a local key or key saved in OS secure storage. Can be an identity (--sign-with-key alice), a secret key (--sign-with-key SC36…), or a seed phrase (--sign-with-key "kite urban…"). If using seed phrase, `--hd-path` defaults to the `0` path' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l hd-path -d 'If using a seed phrase to sign, sets which hierarchical deterministic path to use, e.g. `m/44\'/148\'/{hd_path}`. Example: `--hd-path 1`. Default: `0`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l fee -d 'fee amount for transaction, in stroops. 1 stroop = 0.0000001 xlm' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l instructions -d 'Number of instructions to simulate' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l instruction-leeway -d 'Allow this many extra instructions when budgeting resources during transaction simulation' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l wasm -d 'Path to wasm binary' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l sign-with-lab -d 'Sign with https://lab.stellar.org'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l sign-with-ledger -d 'Sign with a ledger wallet'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l cost -d 'Output the cost execution to stderr'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l build-only -d 'Build the transaction and only write the base64 xdr to stdout'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -s i -l ignore-checks -d 'Whether to ignore safety checks when deploying contracts'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from upload" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -s s -l source-account -l source -d 'Account that where transaction originates from. Alias `source`. Can be an identity (--source alice), a public key (--source GDKW...), a muxed account (--source MDA…), a secret key (--source SC36…), or a seed phrase (--source "kite urban…"). If `--build-only` or `--sim-only` flags were NOT provided, this key will also be used to sign the final transaction. In that case, trying to sign with public key will fail' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l sign-with-key -d 'Sign with a local key or key saved in OS secure storage. Can be an identity (--sign-with-key alice), a secret key (--sign-with-key SC36…), or a seed phrase (--sign-with-key "kite urban…"). If using seed phrase, `--hd-path` defaults to the `0` path' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l hd-path -d 'If using a seed phrase to sign, sets which hierarchical deterministic path to use, e.g. `m/44\'/148\'/{hd_path}`. Example: `--hd-path 1`. Default: `0`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l fee -d 'fee amount for transaction, in stroops. 1 stroop = 0.0000001 xlm' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l instructions -d 'Number of instructions to simulate' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l instruction-leeway -d 'Allow this many extra instructions when budgeting resources during transaction simulation' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l wasm -d 'Path to wasm binary' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l sign-with-lab -d 'Sign with https://lab.stellar.org'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l sign-with-ledger -d 'Sign with a ledger wallet'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l cost -d 'Output the cost execution to stderr'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l build-only -d 'Build the transaction and only write the base64 xdr to stdout'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -s i -l ignore-checks -d 'Whether to ignore safety checks when deploying contracts'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from install" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l id -d 'Contract ID to invoke' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -s s -l source-account -l source -d 'Account that where transaction originates from. Alias `source`. Can be an identity (--source alice), a public key (--source GDKW...), a muxed account (--source MDA…), a secret key (--source SC36…), or a seed phrase (--source "kite urban…"). If `--build-only` or `--sim-only` flags were NOT provided, this key will also be used to sign the final transaction. In that case, trying to sign with public key will fail' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l sign-with-key -d 'Sign with a local key or key saved in OS secure storage. Can be an identity (--sign-with-key alice), a secret key (--sign-with-key SC36…), or a seed phrase (--sign-with-key "kite urban…"). If using seed phrase, `--hd-path` defaults to the `0` path' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l hd-path -d 'If using a seed phrase to sign, sets which hierarchical deterministic path to use, e.g. `m/44\'/148\'/{hd_path}`. Example: `--hd-path 1`. Default: `0`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l fee -d 'fee amount for transaction, in stroops. 1 stroop = 0.0000001 xlm' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l instructions -d 'Number of instructions to simulate' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l instruction-leeway -d 'Allow this many extra instructions when budgeting resources during transaction simulation' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l send -d 'Whether or not to send a transaction' -r -f -a "default\t'Send transaction if simulation indicates there are ledger writes, published events, or auth required, otherwise return simulation result'
no\t'Do not send transaction, return simulation result'
yes\t'Always send transaction'"
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l is-view -d '⚠️ Deprecated, use `--send=no`. View the result simulating and do not sign and submit transaction'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l sign-with-lab -d 'Sign with https://lab.stellar.org'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l sign-with-ledger -d 'Sign with a ledger wallet'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l cost -d 'Output the cost execution to stderr'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l build-only -d 'Build the transaction and only write the base64 xdr to stdout'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from invoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -l wasm -d 'Path to one or more wasm binaries' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -l wasm-out -d 'Path to write the optimized WASM file to (defaults to same location as --wasm with .optimized.wasm suffix)' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from optimize" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l output -d 'Type of output to generate' -r -f -a "string\t'String'
json\t'Json'
xdr\t'XDR'"
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l id -d 'Contract ID to which owns the data entries. If no keys provided the Contract\'s instance will be extended' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l key -d 'Storage key (symbols only)' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l key-xdr -d 'Storage key (base64-encoded XDR)' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l wasm -d 'Path to Wasm file of contract code to extend' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l wasm-hash -d 'Path to Wasm file of contract code to extend' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l durability -d 'Storage entry durability' -r -f -a "persistent\t'Persistent'
temporary\t'Temporary'"
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from read" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l id -d 'Contract ID to which owns the data entries. If no keys provided the Contract\'s instance will be extended' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l key -d 'Storage key (symbols only)' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l key-xdr -d 'Storage key (base64-encoded XDR)' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l wasm -d 'Path to Wasm file of contract code to extend' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l wasm-hash -d 'Path to Wasm file of contract code to extend' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l durability -d 'Storage entry durability' -r -f -a "persistent\t'Persistent'
temporary\t'Temporary'"
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l ledgers-to-extend -d 'Number of ledgers to extend the entry' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -s s -l source-account -l source -d 'Account that where transaction originates from. Alias `source`. Can be an identity (--source alice), a public key (--source GDKW...), a muxed account (--source MDA…), a secret key (--source SC36…), or a seed phrase (--source "kite urban…"). If `--build-only` or `--sim-only` flags were NOT provided, this key will also be used to sign the final transaction. In that case, trying to sign with public key will fail' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l sign-with-key -d 'Sign with a local key or key saved in OS secure storage. Can be an identity (--sign-with-key alice), a secret key (--sign-with-key SC36…), or a seed phrase (--sign-with-key "kite urban…"). If using seed phrase, `--hd-path` defaults to the `0` path' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l hd-path -d 'If using a seed phrase to sign, sets which hierarchical deterministic path to use, e.g. `m/44\'/148\'/{hd_path}`. Example: `--hd-path 1`. Default: `0`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l fee -d 'fee amount for transaction, in stroops. 1 stroop = 0.0000001 xlm' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l instructions -d 'Number of instructions to simulate' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l instruction-leeway -d 'Allow this many extra instructions when budgeting resources during transaction simulation' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l ttl-ledger-only -d 'Only print the new Time To Live ledger'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l sign-with-lab -d 'Sign with https://lab.stellar.org'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l sign-with-ledger -d 'Sign with a ledger wallet'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l cost -d 'Output the cost execution to stderr'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l build-only -d 'Build the transaction and only write the base64 xdr to stdout'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand contract; and __fish_seen_subcommand_from restore" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand doctor" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand doctor" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand doctor" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand doctor" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand doctor" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand doctor" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand doctor" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand doctor" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand events" -l start-ledger -d 'The first ledger sequence number in the range to pull events https://developers.stellar.org/docs/learn/encyclopedia/network-configuration/ledger-headers#ledger-sequence' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -l cursor -d 'The cursor corresponding to the start of the event range' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -l output -d 'Output formatting options for event stream' -r -f -a "pretty\t'Colorful, human-oriented console output'
plain\t'Human-oriented console output without colors'
json\t'JSON formatted console output'"
complete -c stellar -n "__fish_stellar_using_subcommand events" -s c -l count -d 'The maximum number of events to display (defer to the server-defined limit)' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -l id -d 'A set of (up to 5) contract IDs to filter events on. This parameter can be passed multiple times, e.g. `--id C123.. --id C456..`, or passed with multiple parameters, e.g. `--id C123 C456`' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -l topic -d 'A set of (up to 5) topic filters to filter event topics on. A single topic filter can contain 1-4 different segments, separated by commas. An asterisk (`*` character) indicates a wildcard segment' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -l type -d 'Specifies which type of contract events to display' -r -f -a "all\t''
contract\t''
system\t''"
complete -c stellar -n "__fish_stellar_using_subcommand events" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand events" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand events" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand events" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand events" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand events" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand events" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand events" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand env" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand env" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand env" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand env" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand env" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand env" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand env" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand env" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "add" -d 'Add a new identity (keypair, ledger, OS specific secure store)'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "public-key" -d 'Given an identity return its address (public key)'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "address" -d 'Given an identity return its address (public key)'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "fund" -d 'Fund an identity on a test network'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "generate" -d 'Generate a new identity using a 24-word seed phrase The seed phrase can be stored in a config file (default) or in an OS-specific secure store'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "ls" -d 'List identities'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "rm" -d 'Remove an identity'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "secret" -d 'Output an identity\'s secret key'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "use" -d 'Set the default identity that will be used on all commands. This allows you to skip `--source-account` or setting a environment variable, while reusing this value in all commands that require it'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and not __fish_seen_subcommand_from add public-key address fund generate ls rm secret use unset" -f -a "unset" -d 'Unset the default key identity defined previously with `keys use <identity>`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l public-key -d 'Add a public key, ed25519, or muxed account, e.g. G1.., M2..' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l secret-key -d '⚠️ Deprecated, use `--secure-store`. Enter secret (S) key when prompted'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l seed-phrase -d '⚠️ Deprecated, use `--secure-store`. Enter key using 12-24 word seed phrase'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l secure-store -d 'Save the new key in your OS\'s credential secure store'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l overwrite -d 'Overwrite existing identity if it already exists'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -l hd-path -d 'If identity is a seed phrase use this hd path, default is 0' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from public-key" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -l hd-path -d 'If identity is a seed phrase use this hd path, default is 0' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from address" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -l hd-path -d 'If identity is a seed phrase use this hd path, default is 0' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from fund" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l seed -d 'Optional seed to use when generating seed phrase. Random otherwise' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l hd-path -d 'When generating a secret key, which `hd_path` should be used from the original `seed_phrase`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -s s -l as-secret -d 'Output the generated identity as a secret key'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l secure-store -d 'Save the new key in your OS\'s credential secure store'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l fund -d 'Fund generated key pair'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l overwrite -d 'Overwrite existing identity if it already exists'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -s l -l long
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from rm" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from rm" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from rm" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from rm" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from rm" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from rm" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from rm" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from rm" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -l hd-path -d 'If identity is a seed phrase use this hd path, default is 0' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -l phrase -d 'Output seed phrase instead of private key'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from secret" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from use" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from use" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from use" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from use" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from use" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from use" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from use" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from use" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from unset" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from unset" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from unset" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from unset" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from unset" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from unset" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from unset" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand keys; and __fish_seen_subcommand_from unset" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -f -a "add" -d 'Add a new network'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -f -a "rm" -d 'Remove a network'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -f -a "ls" -d 'List networks'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -f -a "use" -d 'Set the default network that will be used on all commands. This allows you to skip `--network` or setting a environment variable, while reusing this value in all commands that require it'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -f -a "health" -d 'Fetch the health of the configured RPC'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -f -a "info" -d 'Checks the health of the configured RPC'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -f -a "settings" -d 'Fetch the network\'s config settings'
complete -c stellar -n "__fish_stellar_using_subcommand network; and not __fish_seen_subcommand_from add rm ls use health info settings unset" -f -a "unset" -d 'Unset the default network defined previously with `network use <network>`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -l rpc-header -d 'Optional header to include in requests to the RPC, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from rm" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from rm" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from rm" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from rm" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from rm" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from rm" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from rm" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from rm" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -s l -l long -d 'Get more info about the networks'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from use" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from use" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from use" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from use" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from use" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from use" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from use" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from use" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -l output -d 'Format of the output' -r -f -a "text\t'Text output of network health status'
json\t'JSON result of the RPC request'
json-formatted\t'Formatted (multiline) JSON output of the RPC request'"
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from health" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -l output -d 'Format of the output' -r -f -a "text\t'Text output of network info'
json\t'JSON result of the RPC request'
json-formatted\t'Formatted (multiline) JSON output of the RPC request'"
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l output -d 'Format of the output' -r -f -a "xdr\t'XDR (`ConfigUpgradeSet` type)'
json\t'JSON, XDR-JSON of the `ConfigUpgradeSet` XDR type'
json-formatted\t'JSON formatted, XDR-JSON of the `ConfigUpgradeSet` XDR type'"
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l internal -d 'Include internal config settings that are not upgradeable and are internally maintained by the network'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from settings" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from unset" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from unset" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from unset" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from unset" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from unset" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from unset" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from unset" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand network; and __fish_seen_subcommand_from unset" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -f -a "logs" -d 'Get logs from a running network container'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -f -a "start" -d 'Start a container running a Stellar node, RPC, API, and friendbot (faucet)'
complete -c stellar -n "__fish_stellar_using_subcommand container; and not __fish_seen_subcommand_from logs start stop" -f -a "stop" -d 'Stop a network container started with `stellar container start`'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -s d -l docker-host -d 'Optional argument to override the default docker host. This is useful when you are using a non-standard docker host path for your Docker-compatible container runtime, e.g. Docker Desktop defaults to $HOME/.docker/run/docker.sock instead of /var/run/docker.sock' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from logs" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -s d -l docker-host -d 'Optional argument to override the default docker host. This is useful when you are using a non-standard docker host path for your Docker-compatible container runtime, e.g. Docker Desktop defaults to $HOME/.docker/run/docker.sock instead of /var/run/docker.sock' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -l name -d 'Optional argument to specify the container name' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -s l -l limits -d 'Optional argument to specify the limits for the local network only' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -s p -l ports-mapping -d 'Argument to specify the `HOST_PORT:CONTAINER_PORT` mapping' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -s t -l image-tag-override -d 'Optional argument to override the default docker image tag for the given network' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -l protocol-version -d 'Optional argument to specify the protocol version for the local network only' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from start" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -s d -l docker-host -d 'Optional argument to override the default docker host. This is useful when you are using a non-standard docker host path for your Docker-compatible container runtime, e.g. Docker Desktop defaults to $HOME/.docker/run/docker.sock instead of /var/run/docker.sock' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand container; and __fish_seen_subcommand_from stop" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -f -a "migrate" -d 'Migrate the local configuration to the global directory'
complete -c stellar -n "__fish_stellar_using_subcommand config; and not __fish_seen_subcommand_from migrate dir" -f -a "dir" -d 'Show the global configuration directory'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from migrate" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from migrate" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from migrate" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from migrate" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from migrate" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from migrate" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from migrate" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from migrate" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from dir" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from dir" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from dir" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from dir" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from dir" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from dir" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from dir" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand config; and __fish_seen_subcommand_from dir" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -f -a "create" -d 'Create a ledger snapshot using a history archive'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and not __fish_seen_subcommand_from create merge" -f -a "merge" -d 'Merge multiple ledger snapshots into a single snapshot file'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l ledger -d 'The ledger sequence number to snapshot. Defaults to latest history archived ledger' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l address -d 'Account or contract address/alias to include in the snapshot' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l wasm-hash -d 'WASM hashes to include in the snapshot' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l output -d 'Format of the out file' -r -f -a "json\t''"
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l out -d 'Out path that the snapshot is written to' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l archive-url -d 'Archive URL' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -s o -l out -d 'Output path for the merged snapshot' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand snapshot; and __fish_seen_subcommand_from merge" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "update" -d 'Update the transaction'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "edit" -d 'Edit a transaction envelope from stdin. This command respects the environment variables `STELLAR_EDITOR`, `EDITOR` and `VISUAL`, in that order'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "hash" -d 'Calculate the hash of a transaction envelope'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "new" -d 'Create a new transaction'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "operation" -d 'Manipulate the operations in a transaction, including adding new operations'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "op" -d 'Manipulate the operations in a transaction, including adding new operations'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "send" -d 'Send a transaction envelope to the network'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "sign" -d 'Sign a transaction envelope appending the signature to the envelope'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "simulate" -d 'Simulate a transaction envelope from stdin'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "fetch" -d 'Fetch a transaction from the network by hash If no subcommand is passed in, the transaction envelope will be returned'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "decode" -d 'Decode a transaction envelope from XDR to JSON'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and not __fish_seen_subcommand_from update edit hash new operation op send sign simulate fetch decode encode" -f -a "encode" -d 'Encode a transaction envelope from JSON to XDR'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -f -a "sequence-number" -d 'Edit the sequence number on a transaction'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from update" -f -a "seq-num" -d 'Edit the sequence number on a transaction'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from edit" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from edit" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from edit" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from edit" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from edit" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from edit" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from edit" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from edit" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from hash" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "account-merge" -d 'Transfer XLM balance to another account and remove source account'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "begin-sponsoring-future-reserves" -d 'Begin sponsoring future reserves for another account'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "bump-sequence" -d 'Bump sequence number to invalidate older transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "change-trust" -d 'Create, update, or delete a trustline'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "claim-claimable-balance" -d 'Claim a claimable balance by its balance ID'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "clawback" -d 'Clawback an asset from an account'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "clawback-claimable-balance" -d 'Clawback a claimable balance by its balance ID'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "create-account" -d 'Create and fund a new account'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "create-claimable-balance" -d 'Create a claimable balance that can be claimed by specified accounts'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "create-passive-sell-offer" -d 'Create a passive sell offer on the Stellar DEX'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "end-sponsoring-future-reserves" -d 'End sponsoring future reserves'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "liquidity-pool-deposit" -d 'Deposit assets into a liquidity pool'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "liquidity-pool-withdraw" -d 'Withdraw assets from a liquidity pool'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "manage-buy-offer" -d 'Create, update, or delete a buy offer'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "manage-data" -d 'Set, modify, or delete account data entries'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "manage-sell-offer" -d 'Create, update, or delete a sell offer'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "path-payment-strict-send" -d 'Send a payment with a different asset using path finding, specifying the send amount'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "path-payment-strict-receive" -d 'Send a payment with a different asset using path finding, specifying the receive amount'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "payment" -d 'Send asset to destination account'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "revoke-sponsorship" -d 'Revoke sponsorship of a ledger entry or signer'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "set-options" -d 'Set account options like flags, signers, and home domain'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from new" -f -a "set-trustline-flags" -d 'Configure authorization and trustline flags for an asset'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from operation" -f -a "add" -d 'Add Operation to a transaction'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from op" -f -a "add" -d 'Add Operation to a transaction'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from send" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l sign-with-key -d 'Sign with a local key or key saved in OS secure storage. Can be an identity (--sign-with-key alice), a secret key (--sign-with-key SC36…), or a seed phrase (--sign-with-key "kite urban…"). If using seed phrase, `--hd-path` defaults to the `0` path' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l hd-path -d 'If using a seed phrase to sign, sets which hierarchical deterministic path to use, e.g. `m/44\'/148\'/{hd_path}`. Example: `--hd-path 1`. Default: `0`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l sign-with-lab -d 'Sign with https://lab.stellar.org'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l sign-with-ledger -d 'Sign with a ledger wallet'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from sign" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -s s -l source-account -l source -d 'Account that where transaction originates from. Alias `source`. Can be an identity (--source alice), a public key (--source GDKW...), a muxed account (--source MDA…), a secret key (--source SC36…), or a seed phrase (--source "kite urban…"). If `--build-only` or `--sim-only` flags were NOT provided, this key will also be used to sign the final transaction. In that case, trying to sign with public key will fail' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l sign-with-key -d 'Sign with a local key or key saved in OS secure storage. Can be an identity (--sign-with-key alice), a secret key (--sign-with-key SC36…), or a seed phrase (--sign-with-key "kite urban…"). If using seed phrase, `--hd-path` defaults to the `0` path' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l hd-path -d 'If using a seed phrase to sign, sets which hierarchical deterministic path to use, e.g. `m/44\'/148\'/{hd_path}`. Example: `--hd-path 1`. Default: `0`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l instruction-leeway -d 'Allow this many extra instructions when budgeting resources during transaction simulation' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l sign-with-lab -d 'Sign with https://lab.stellar.org'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l sign-with-ledger -d 'Sign with a ledger wallet'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from simulate" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l hash -d 'Hash of transaction to fetch' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l output -d 'Format of the output' -r -f -a "json\t'JSON output with parsed XDRs (one line, not formatted)'
json-formatted\t'Formatted (multiline) JSON output with parsed XDRs'
xdr\t'Original RPC output (containing XDRs)'"
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -f -a "result" -d 'Fetch the transaction result'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -f -a "meta" -d 'Fetch the transaction meta'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -f -a "fee" -d 'Fetch the transaction fee information'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -f -a "events" -d 'Fetch the transaction events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from fetch" -f -a "envelope" -d 'Fetch the transaction envelope'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -l input -r -f -a "single-base64\t''
single\t''"
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -l output -r -f -a "json\t''
json-formatted\t''"
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from decode" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -l input -r -f -a "json\t''"
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -l output -r -f -a "single-base64\t''
single\t''"
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand tx; and __fish_seen_subcommand_from encode" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -a "types" -d 'View information about types'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -a "guess" -d 'Guess the XDR type'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -a "decode" -d 'Decode XDR'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -a "encode" -d 'Encode XDR'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -a "compare" -d 'Compare two XDR values with each other'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -a "generate" -d 'Generate XDR values'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and not __fish_seen_subcommand_from types guess decode encode compare generate version" -a "version" -d 'Print version information'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -f -a "list"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -f -a "schema"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from types" -f -a "schema-files" -d 'Generate JSON schema files for the XDR types, writing a file for each type to the out directory'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -l input -r -f -a "single\t''
single-base64\t''
stream\t''
stream-base64\t''
stream-framed\t''"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -l output -r -f -a "list\t''"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -l certainty -d 'Certainty as an arbitrary value' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from guess" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -l type -d 'XDR type to decode' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -l input -r -f -a "single\t''
single-base64\t''
stream\t''
stream-base64\t''
stream-framed\t''"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -l output -r -f -a "json\t''
json-formatted\t''
text\t''
rust-debug\t''
rust-debug-formatted\t''"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from decode" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -l type -d 'XDR type to encode' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -l input -r -f -a "json\t''"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -l output -r -f -a "single\t''
single-base64\t''
stream\t''"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from encode" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -l type -d 'XDR type of both inputs' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -l input -r -f -a "single\t''
single-base64\t''"
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from compare" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -f -a "default" -d 'Generate default XDR values'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from generate" -f -a "arbitrary" -d 'Generate arbitrary XDR values'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from version" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from version" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from version" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from version" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from version" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from version" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from version" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand xdr; and __fish_seen_subcommand_from version" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -f -a "decode" -d 'Decode strkey'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -f -a "encode" -d 'Encode strkey'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -f -a "zero" -d 'Generate the zero strkey'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and not __fish_seen_subcommand_from decode encode zero version" -f -a "version" -d 'Print version information'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from decode" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from decode" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from decode" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from decode" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from decode" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from decode" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from decode" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from decode" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from encode" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from encode" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from encode" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from encode" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from encode" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from encode" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from encode" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from encode" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -l output -d 'Output format' -r -f -a "strkey\t''
json\t''"
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from zero" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from version" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from version" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from version" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from version" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from version" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from version" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from version" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand strkey; and __fish_seen_subcommand_from version" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand completion" -l shell -d 'The shell type' -r -f -a "bash\t''
elvish\t''
fish\t''
powershell\t''
zsh\t''"
complete -c stellar -n "__fish_stellar_using_subcommand completion" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand completion" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand completion" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand completion" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand completion" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand completion" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand completion" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand completion" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -f -a "clean" -d 'Delete the cache'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -f -a "path" -d 'Show the location of the cache'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and not __fish_seen_subcommand_from clean path actionlog" -f -a "actionlog" -d 'Access details about cached actions like transactions, and simulations. (Experimental. May see breaking changes at any time.)'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from clean" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from clean" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from clean" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from clean" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from clean" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from clean" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from clean" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from clean" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from path" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from path" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from path" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from path" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from path" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from path" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from path" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from path" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -f -a "ls" -d 'List cached actions (transactions, simulations)'
complete -c stellar -n "__fish_stellar_using_subcommand cache; and __fish_seen_subcommand_from actionlog" -f -a "read" -d 'Read cached action'
complete -c stellar -n "__fish_stellar_using_subcommand version" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand version" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand version" -l only-version -d 'Print only the version'
complete -c stellar -n "__fish_stellar_using_subcommand version" -l only-version-major -d 'Print only the major version'
complete -c stellar -n "__fish_stellar_using_subcommand version" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand version" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand version" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand version" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand version" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand version" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -f -a "search" -d 'Search for CLI plugins using GitHub'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and not __fish_seen_subcommand_from search ls" -f -a "ls" -d 'List installed plugins'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from search" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from search" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from search" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from search" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from search" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from search" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from search" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from search" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from ls" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from ls" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from ls" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from ls" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from ls" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from ls" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from ls" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand plugin; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -f -a "entry" -d 'Work with ledger entries'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -f -a "latest" -d 'Get the latest ledger sequence and information from the network'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and not __fish_seen_subcommand_from entry latest fetch" -f -a "fetch"
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -s h -l help -d 'Print help'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from entry" -f -a "fetch" -d 'Fetch ledger entries. This command supports all types of ledger entries supported by the RPC. Read more about the RPC command here: [https://developers.stellar.org/docs/data/apis/rpc/api-reference/methods/getLedgerEntries#types-of-ledgerkeys](https://developers.stellar.org/docs/data/apis/rpc/api-reference/methods/getLedgerEntries#types-of-ledgerkeys)'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -l output -d 'Format of the output' -r -f -a "text\t'Text output of network info'
json\t'JSON result of the RPC request'
json-formatted\t'Formatted (multiline) JSON output of the RPC request'"
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from latest" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l limit -d 'Number of ledgers to fetch' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l output -d 'Format of the output' -r -f -a "text\t'Text output of network info'
json\t'JSON result of the RPC request'
json-formatted\t'Formatted (multiline) JSON output of the RPC request'"
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l xdr-format -d 'Format of the xdr in the output' -r -f -a "json\t'XDR fields will be fetched as json and accessible via the headerJson and metadataJson fields'
xdr\t'XDR fields will be fetched as xdr and accessible via the headerXdr and metadataXdr fields'"
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand ledger; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -l rpc-url -d 'RPC server endpoint' -r
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -l rpc-header -d 'RPC Header(s) to include in requests to the RPC provider, example: "X-API-Key: abc123". Multiple headers can be added by passing the option multiple times' -r
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -l network-passphrase -d 'Network passphrase to sign the transaction sent to the rpc server' -r
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -s n -l network -d 'Name of network to use from config' -r
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -l output -d 'Format of the output' -r -f -a "text\t'Text output of network info'
json\t'JSON result of the RPC request'
json-formatted\t'Formatted (multiline) JSON output of the RPC request'"
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -l config-dir -d 'Location of config directory. By default, it uses `$XDG_CONFIG_HOME/stellar` if set, falling back to `~/.config/stellar` otherwise. Contains configuration files, aliases, and other persistent settings' -r -F
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -s f -l filter-logs -d 'Filter logs output. To turn on `stellar_cli::log::footprint=debug` or off `=off`. Can also use env var `RUST_LOG`' -r
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -l global -d '⚠️ Deprecated: global config is always on'
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -s q -l quiet -d 'Do not write logs to stderr including `INFO`'
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -s v -l verbose -d 'Log DEBUG events'
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -l very-verbose -l vv -d 'Log DEBUG and TRACE events'
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -l no-cache -d 'Do not cache your simulations and transactions'
complete -c stellar -n "__fish_stellar_using_subcommand fee-stats" -s h -l help -d 'Print help (see more with \'--help\')'
