#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::BlockList *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"blockListMain", 1352930172},
    {"blockListStories", 103323228}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ChatMemberStatus *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"chatMemberStatusCreator", -160019714},
    {"chatMemberStatusAdministrator", -70024163},
    {"chatMemberStatusMember", -32707562},
    {"chatMemberStatusRestricted", 1661432998},
    {"chatMemberStatusLeft", -5815259},
    {"chatMemberStatusBanned", -1653518666}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::FirebaseAuthenticationSettings *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"firebaseAuthenticationSettingsAndroid", -1771112932},
    {"firebaseAuthenticationSettingsIos", 222930116}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputChatTheme *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputChatThemeEmoji", -1461787199},
    {"inputChatThemeGift", 2026976301}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputPassportElement *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputPassportElementPersonalDetails", 164791359},
    {"inputPassportElementPassport", -497011356},
    {"inputPassportElementDriverLicense", 304813264},
    {"inputPassportElementIdentityCard", -9963390},
    {"inputPassportElementInternalPassport", 715360043},
    {"inputPassportElementAddress", 461630480},
    {"inputPassportElementUtilityBill", 1389203841},
    {"inputPassportElementBankStatement", -26585208},
    {"inputPassportElementRentalAgreement", 1736154155},
    {"inputPassportElementPassportRegistration", 1314562128},
    {"inputPassportElementTemporaryRegistration", -1913238047},
    {"inputPassportElementPhoneNumber", 1319357497},
    {"inputPassportElementEmailAddress", -248605659}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::MaskPoint *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"maskPointForehead", 1027512005},
    {"maskPointEyes", 1748310861},
    {"maskPointMouth", 411773406},
    {"maskPointChin", 534995335}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::OptionValue *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"optionValueBoolean", 63135518},
    {"optionValueEmpty", 918955155},
    {"optionValueInteger", -186858780},
    {"optionValueString", 756248212}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ProfileTab *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"profileTabPosts", -1181952362},
    {"profileTabGifts", 1296815210},
    {"profileTabMedia", 1925597525},
    {"profileTabFiles", -1422681088},
    {"profileTabLinks", -748329831},
    {"profileTabMusic", -1624780178},
    {"profileTabVoice", -461960914},
    {"profileTabGifs", -1564412267}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::SearchMessagesFilter *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"searchMessagesFilterEmpty", -869395657},
    {"searchMessagesFilterAnimation", -155713339},
    {"searchMessagesFilterAudio", 867505275},
    {"searchMessagesFilterDocument", 1526331215},
    {"searchMessagesFilterPhoto", 925932293},
    {"searchMessagesFilterVideo", 115538222},
    {"searchMessagesFilterVoiceNote", 1841439357},
    {"searchMessagesFilterPhotoAndVideo", 1352130963},
    {"searchMessagesFilterUrl", -1828724341},
    {"searchMessagesFilterChatPhoto", -1247751329},
    {"searchMessagesFilterVideoNote", 564323321},
    {"searchMessagesFilterVoiceAndVideoNote", 664174819},
    {"searchMessagesFilterMention", 2001258652},
    {"searchMessagesFilterUnreadMention", -95769149},
    {"searchMessagesFilterUnreadReaction", -1379651328},
    {"searchMessagesFilterFailedToSend", -596322564},
    {"searchMessagesFilterPinned", 371805512}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::SupergroupMembersFilter *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"supergroupMembersFilterRecent", 1178199509},
    {"supergroupMembersFilterContacts", -1282910856},
    {"supergroupMembersFilterAdministrators", -2097380265},
    {"supergroupMembersFilterSearch", -1696358469},
    {"supergroupMembersFilterRestricted", -1107800034},
    {"supergroupMembersFilterBanned", -1210621683},
    {"supergroupMembersFilterMention", 1151301973},
    {"supergroupMembersFilterBots", 492138918}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::UserPrivacySettingRule *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"userPrivacySettingRuleAllowAll", -1967186881},
    {"userPrivacySettingRuleAllowContacts", -1892733680},
    {"userPrivacySettingRuleAllowBots", 1404208925},
    {"userPrivacySettingRuleAllowPremiumUsers", 1624147265},
    {"userPrivacySettingRuleAllowUsers", 1110988334},
    {"userPrivacySettingRuleAllowChatMembers", -2048749863},
    {"userPrivacySettingRuleRestrictAll", -1406495408},
    {"userPrivacySettingRuleRestrictContacts", 1008389378},
    {"userPrivacySettingRuleRestrictBots", -1902547363},
    {"userPrivacySettingRuleRestrictUsers", 622796522},
    {"userPrivacySettingRuleRestrictChatMembers", 392530897}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::affiliateTypeCurrentUser &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::backgroundFillSolid &to, JsonObject &from) {
  TRY_STATUS(from_json(to.color_, from.extract_field("color")));
  return Status::OK();
}

Status from_json(td_api::blockListStories &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::botMenuButton &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::businessFeatureQuickReplies &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessGreetingMessageSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_id_, from.extract_field("shortcut_id")));
  TRY_STATUS(from_json(to.recipients_, from.extract_field("recipients")));
  TRY_STATUS(from_json(to.inactivity_days_, from.extract_field("inactivity_days")));
  return Status::OK();
}

Status from_json(td_api::callProblemSilentLocal &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionTyping &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionChoosingContact &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatEventLogFilters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_edits_, from.extract_field("message_edits")));
  TRY_STATUS(from_json(to.message_deletions_, from.extract_field("message_deletions")));
  TRY_STATUS(from_json(to.message_pins_, from.extract_field("message_pins")));
  TRY_STATUS(from_json(to.member_joins_, from.extract_field("member_joins")));
  TRY_STATUS(from_json(to.member_leaves_, from.extract_field("member_leaves")));
  TRY_STATUS(from_json(to.member_invites_, from.extract_field("member_invites")));
  TRY_STATUS(from_json(to.member_promotions_, from.extract_field("member_promotions")));
  TRY_STATUS(from_json(to.member_restrictions_, from.extract_field("member_restrictions")));
  TRY_STATUS(from_json(to.info_changes_, from.extract_field("info_changes")));
  TRY_STATUS(from_json(to.setting_changes_, from.extract_field("setting_changes")));
  TRY_STATUS(from_json(to.invite_link_changes_, from.extract_field("invite_link_changes")));
  TRY_STATUS(from_json(to.video_chat_changes_, from.extract_field("video_chat_changes")));
  TRY_STATUS(from_json(to.forum_changes_, from.extract_field("forum_changes")));
  TRY_STATUS(from_json(to.subscription_extensions_, from.extract_field("subscription_extensions")));
  return Status::OK();
}

Status from_json(td_api::chatLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.address_, from.extract_field("address")));
  return Status::OK();
}

Status from_json(td_api::chatMembersFilterMembers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatPhotoStickerTypeCustomEmoji &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_emoji_id_, from.extract_field("custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenMicrosoftPush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.channel_uri_, from.extract_field("channel_uri")));
  return Status::OK();
}

Status from_json(td_api::emailAddressAuthenticationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::emojiStatusTypeUpgradedGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.upgraded_gift_id_, from.extract_field("upgraded_gift_id")));
  TRY_STATUS(from_json(to.gift_title_, from.extract_field("gift_title")));
  TRY_STATUS(from_json(to.gift_name_, from.extract_field("gift_name")));
  TRY_STATUS(from_json(to.model_custom_emoji_id_, from.extract_field("model_custom_emoji_id")));
  TRY_STATUS(from_json(to.symbol_custom_emoji_id_, from.extract_field("symbol_custom_emoji_id")));
  TRY_STATUS(from_json(to.backdrop_colors_, from.extract_field("backdrop_colors")));
  return Status::OK();
}

Status from_json(td_api::fileTypeProfilePhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeThumbnail &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::formattedText &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.entities_, from.extract_field("entities")));
  return Status::OK();
}

Status from_json(td_api::groupCallDataChannelMain &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeLoginUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.forward_text_, from.extract_field("forward_text")));
  return Status::OK();
}

Status from_json(td_api::inlineQueryResultsButton &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::inputChatPhotoStatic &to, JsonObject &from) {
  TRY_STATUS(from_json(to.photo_, from.extract_field("photo")));
  return Status::OK();
}

Status from_json(td_api::inputCredentialsApplePay &to, JsonObject &from) {
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultAnimation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.thumbnail_mime_type_, from.extract_field("thumbnail_mime_type")));
  TRY_STATUS(from_json(to.video_url_, from.extract_field("video_url")));
  TRY_STATUS(from_json(to.video_mime_type_, from.extract_field("video_mime_type")));
  TRY_STATUS(from_json(to.video_duration_, from.extract_field("video_duration")));
  TRY_STATUS(from_json(to.video_width_, from.extract_field("video_width")));
  TRY_STATUS(from_json(to.video_height_, from.extract_field("video_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultVenue &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.venue_, from.extract_field("venue")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.thumbnail_width_, from.extract_field("thumbnail_width")));
  TRY_STATUS(from_json(to.thumbnail_height_, from.extract_field("thumbnail_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputMessageDocument &to, JsonObject &from) {
  TRY_STATUS(from_json(to.document_, from.extract_field("document")));
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.disable_content_type_detection_, from.extract_field("disable_content_type_detection")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  return Status::OK();
}

Status from_json(td_api::inputMessageContact &to, JsonObject &from) {
  TRY_STATUS(from_json(to.contact_, from.extract_field("contact")));
  return Status::OK();
}

Status from_json(td_api::inputMessageReplyToExternalMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.quote_, from.extract_field("quote")));
  TRY_STATUS(from_json(to.checklist_task_id_, from.extract_field("checklist_task_id")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementInternalPassport &to, JsonObject &from) {
  TRY_STATUS(from_json(to.internal_passport_, from.extract_field("internal_passport")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementError &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.message_, from.extract_field("message")));
  TRY_STATUS(from_json(to.source_, from.extract_field("source")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceFiles &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.file_hashes_, from.extract_field("file_hashes")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypeLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeActiveSessions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeChangePhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeGame &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.game_short_name_, from.extract_field("game_short_name")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeLoginEmailSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePhoneNumberPrivacySettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeUserPhoneNumber &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  TRY_STATUS(from_json(to.draft_text_, from.extract_field("draft_text")));
  TRY_STATUS(from_json(to.open_profile_, from.extract_field("open_profile")));
  return Status::OK();
}

Status from_json(td_api::jsonValueString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::keyboardButtonTypeRequestChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.chat_is_channel_, from.extract_field("chat_is_channel")));
  TRY_STATUS(from_json(to.restrict_chat_is_forum_, from.extract_field("restrict_chat_is_forum")));
  TRY_STATUS(from_json(to.chat_is_forum_, from.extract_field("chat_is_forum")));
  TRY_STATUS(from_json(to.restrict_chat_has_username_, from.extract_field("restrict_chat_has_username")));
  TRY_STATUS(from_json(to.chat_has_username_, from.extract_field("chat_has_username")));
  TRY_STATUS(from_json(to.chat_is_created_, from.extract_field("chat_is_created")));
  TRY_STATUS(from_json(to.user_administrator_rights_, from.extract_field("user_administrator_rights")));
  TRY_STATUS(from_json(to.bot_administrator_rights_, from.extract_field("bot_administrator_rights")));
  TRY_STATUS(from_json(to.bot_is_member_, from.extract_field("bot_is_member")));
  TRY_STATUS(from_json(to.request_title_, from.extract_field("request_title")));
  TRY_STATUS(from_json(to.request_username_, from.extract_field("request_username")));
  TRY_STATUS(from_json(to.request_photo_, from.extract_field("request_photo")));
  return Status::OK();
}

Status from_json(td_api::location &to, JsonObject &from) {
  TRY_STATUS(from_json(to.latitude_, from.extract_field("latitude")));
  TRY_STATUS(from_json(to.longitude_, from.extract_field("longitude")));
  TRY_STATUS(from_json(to.horizontal_accuracy_, from.extract_field("horizontal_accuracy")));
  return Status::OK();
}

Status from_json(td_api::maskPosition &to, JsonObject &from) {
  TRY_STATUS(from_json(to.point_, from.extract_field("point")));
  TRY_STATUS(from_json(to.x_shift_, from.extract_field("x_shift")));
  TRY_STATUS(from_json(to.y_shift_, from.extract_field("y_shift")));
  TRY_STATUS(from_json(to.scale_, from.extract_field("scale")));
  return Status::OK();
}

Status from_json(td_api::messageSenderUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::messageSourceChatEventLog &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::networkStatisticsEntryCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.network_type_, from.extract_field("network_type")));
  TRY_STATUS(from_json(to.sent_bytes_, from.extract_field("sent_bytes")));
  TRY_STATUS(from_json(to.received_bytes_, from.extract_field("received_bytes")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  return Status::OK();
}

Status from_json(td_api::notificationSettingsScopeChannelChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypePersonalDetails &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypePassportRegistration &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::pollTypeRegular &to, JsonObject &from) {
  TRY_STATUS(from_json(to.allow_multiple_answers_, from.extract_field("allow_multiple_answers")));
  return Status::OK();
}

Status from_json(td_api::premiumFeatureCustomEmoji &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureChatBoost &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeSupergroupCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeCaptionLength &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeSimilarChatCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeaturePermanentViewsHistory &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabLinks &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::reactionNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_reaction_source_, from.extract_field("message_reaction_source")));
  TRY_STATUS(from_json(to.story_reaction_source_, from.extract_field("story_reaction_source")));
  TRY_STATUS(from_json(to.sound_id_, from.extract_field("sound_id")));
  TRY_STATUS(from_json(to.show_preview_, from.extract_field("show_preview")));
  return Status::OK();
}

Status from_json(td_api::replyMarkupForceReply &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_personal_, from.extract_field("is_personal")));
  TRY_STATUS(from_json(to.input_field_placeholder_, from.extract_field("input_field_placeholder")));
  return Status::OK();
}

Status from_json(td_api::reportReasonFake &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesChatTypeFilterGroup &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterPhotoAndVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterPinned &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::storePaymentPurposePremiumSubscription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_restore_, from.extract_field("is_restore")));
  TRY_STATUS(from_json(to.is_upgrade_, from.extract_field("is_upgrade")));
  return Status::OK();
}

Status from_json(td_api::storyAreaPosition &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_percentage_, from.extract_field("x_percentage")));
  TRY_STATUS(from_json(to.y_percentage_, from.extract_field("y_percentage")));
  TRY_STATUS(from_json(to.width_percentage_, from.extract_field("width_percentage")));
  TRY_STATUS(from_json(to.height_percentage_, from.extract_field("height_percentage")));
  TRY_STATUS(from_json(to.rotation_angle_, from.extract_field("rotation_angle")));
  TRY_STATUS(from_json(to.corner_radius_percentage_, from.extract_field("corner_radius_percentage")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionCheckPassword &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionSetBirthdate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::supergroupMembersFilterContacts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::targetChatInternalLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::testInt &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypePhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypePreCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_, from.extract_field("language")));
  return Status::OK();
}

Status from_json(td_api::themeParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.background_color_, from.extract_field("background_color")));
  TRY_STATUS(from_json(to.secondary_background_color_, from.extract_field("secondary_background_color")));
  TRY_STATUS(from_json(to.header_background_color_, from.extract_field("header_background_color")));
  TRY_STATUS(from_json(to.bottom_bar_background_color_, from.extract_field("bottom_bar_background_color")));
  TRY_STATUS(from_json(to.section_background_color_, from.extract_field("section_background_color")));
  TRY_STATUS(from_json(to.section_separator_color_, from.extract_field("section_separator_color")));
  TRY_STATUS(from_json(to.text_color_, from.extract_field("text_color")));
  TRY_STATUS(from_json(to.accent_text_color_, from.extract_field("accent_text_color")));
  TRY_STATUS(from_json(to.section_header_text_color_, from.extract_field("section_header_text_color")));
  TRY_STATUS(from_json(to.subtitle_text_color_, from.extract_field("subtitle_text_color")));
  TRY_STATUS(from_json(to.destructive_text_color_, from.extract_field("destructive_text_color")));
  TRY_STATUS(from_json(to.hint_color_, from.extract_field("hint_color")));
  TRY_STATUS(from_json(to.link_color_, from.extract_field("link_color")));
  TRY_STATUS(from_json(to.button_color_, from.extract_field("button_color")));
  TRY_STATUS(from_json(to.button_text_color_, from.extract_field("button_text_color")));
  return Status::OK();
}

Status from_json(td_api::transactionDirectionIncoming &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowPhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAutosaveGifts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleRestrictContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::webAppOpenParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.theme_, from.extract_field("theme")));
  TRY_STATUS(from_json(to.application_name_, from.extract_field("application_name")));
  TRY_STATUS(from_json(to.mode_, from.extract_field("mode")));
  return Status::OK();
}

Status from_json(td_api::addChecklistTasks &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.tasks_, from.extract_field("tasks")));
  return Status::OK();
}

Status from_json(td_api::addNetworkStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.entry_, from.extract_field("entry")));
  return Status::OK();
}

Status from_json(td_api::addRecentSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_attached_, from.extract_field("is_attached")));
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::answerCustomQuery &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_query_id_, from.extract_field("custom_query_id")));
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::banGroupCallParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::canTransferOwnership &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationEmailCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::checkLoginEmailAddressCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::clearAllDraftMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.exclude_secret_chats_, from.extract_field("exclude_secret_chats")));
  return Status::OK();
}

Status from_json(td_api::clickChatSponsoredMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.is_media_click_, from.extract_field("is_media_click")));
  TRY_STATUS(from_json(to.from_fullscreen_, from.extract_field("from_fullscreen")));
  return Status::OK();
}

Status from_json(td_api::commitPendingLiveStoryReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::createChatFolderInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  return Status::OK();
}

Status from_json(td_api::createNewStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.needs_repainting_, from.extract_field("needs_repainting")));
  TRY_STATUS(from_json(to.stickers_, from.extract_field("stickers")));
  TRY_STATUS(from_json(to.source_, from.extract_field("source")));
  return Status::OK();
}

Status from_json(td_api::declineSuggestedPost &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.comment_, from.extract_field("comment")));
  return Status::OK();
}

Status from_json(td_api::deleteBusinessStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::deleteCommands &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  return Status::OK();
}

Status from_json(td_api::deleteLanguagePack &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  return Status::OK();
}

Status from_json(td_api::deleteSavedMessagesTopicMessagesByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.min_date_, from.extract_field("min_date")));
  TRY_STATUS(from_json(to.max_date_, from.extract_field("max_date")));
  return Status::OK();
}

Status from_json(td_api::disconnectAffiliateProgram &to, JsonObject &from) {
  TRY_STATUS(from_json(to.affiliate_, from.extract_field("affiliate")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::editBusinessMessageLiveLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.live_period_, from.extract_field("live_period")));
  TRY_STATUS(from_json(to.heading_, from.extract_field("heading")));
  TRY_STATUS(from_json(to.proximity_alert_radius_, from.extract_field("proximity_alert_radius")));
  return Status::OK();
}

Status from_json(td_api::editCustomLanguagePackInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.info_, from.extract_field("info")));
  return Status::OK();
}

Status from_json(td_api::editMessageLiveLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.live_period_, from.extract_field("live_period")));
  TRY_STATUS(from_json(to.heading_, from.extract_field("heading")));
  TRY_STATUS(from_json(to.proximity_alert_radius_, from.extract_field("proximity_alert_radius")));
  return Status::OK();
}

Status from_json(td_api::editStoryCover &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.cover_frame_timestamp_, from.extract_field("cover_frame_timestamp")));
  return Status::OK();
}

Status from_json(td_api::getAccountTtl &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getAttachedStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  return Status::OK();
}

Status from_json(td_api::getBasicGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.basic_group_id_, from.extract_field("basic_group_id")));
  return Status::OK();
}

Status from_json(td_api::getBotSimilarBots &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::getChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatBoostLinkInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::getChatFolderNewChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::getChatMessageByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.date_, from.extract_field("date")));
  return Status::OK();
}

Status from_json(td_api::getChatRevenueWithdrawalUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDatabaseStatistics &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDirectMessagesChatTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getFavoriteStickers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getForumTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_date_, from.extract_field("offset_date")));
  TRY_STATUS(from_json(to.offset_message_id_, from.extract_field("offset_message_id")));
  TRY_STATUS(from_json(to.offset_forum_topic_id_, from.extract_field("offset_forum_topic_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getGrossingWebAppBots &to, JsonObject &from) {
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getInlineQueryResults &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.user_location_, from.extract_field("user_location")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  return Status::OK();
}

Status from_json(td_api::getLanguagePackString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_database_path_, from.extract_field("language_pack_database_path")));
  TRY_STATUS(from_json(to.localization_target_, from.extract_field("localization_target")));
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  TRY_STATUS(from_json(to.key_, from.extract_field("key")));
  return Status::OK();
}

Status from_json(td_api::getLogTagVerbosityLevel &to, JsonObject &from) {
  TRY_STATUS(from_json(to.tag_, from.extract_field("tag")));
  return Status::OK();
}

Status from_json(td_api::getMenuButton &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getMessageLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.media_timestamp_, from.extract_field("media_timestamp")));
  TRY_STATUS(from_json(to.for_album_, from.extract_field("for_album")));
  TRY_STATUS(from_json(to.in_message_thread_, from.extract_field("in_message_thread")));
  return Status::OK();
}

Status from_json(td_api::getMessageViewers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getPassportAuthorizationFormAvailableElements &to, JsonObject &from) {
  TRY_STATUS(from_json(to.authorization_form_id_, from.extract_field("authorization_form_id")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getPremiumFeatures &to, JsonObject &from) {
  TRY_STATUS(from_json(to.source_, from.extract_field("source")));
  return Status::OK();
}

Status from_json(td_api::getProxies &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getRecentStickers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_attached_, from.extract_field("is_attached")));
  return Status::OK();
}

Status from_json(td_api::getSavedMessagesTags &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  return Status::OK();
}

Status from_json(td_api::getSecretChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.secret_chat_id_, from.extract_field("secret_chat_id")));
  return Status::OK();
}

Status from_json(td_api::getStatisticalGraph &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::getStoryAlbumStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_album_id_, from.extract_field("story_album_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getSuitablePersonalChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getThemedChatEmojiStatuses &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUpgradedGiftEmojiStatuses &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUserProfilePhotos &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getWebPageInstantView &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.only_local_, from.extract_field("only_local")));
  return Status::OK();
}

Status from_json(td_api::isLoginEmailAddressRequired &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::leaveGroupCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::markChecklistTasksAsDone &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.marked_as_done_task_ids_, from.extract_field("marked_as_done_task_ids")));
  TRY_STATUS(from_json(to.marked_as_not_done_task_ids_, from.extract_field("marked_as_not_done_task_ids")));
  return Status::OK();
}

Status from_json(td_api::optimizeStorage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.size_, from.extract_field("size")));
  TRY_STATUS(from_json(to.ttl_, from.extract_field("ttl")));
  TRY_STATUS(from_json(to.count_, from.extract_field("count")));
  TRY_STATUS(from_json(to.immunity_delay_, from.extract_field("immunity_delay")));
  TRY_STATUS(from_json(to.file_types_, from.extract_field("file_types")));
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  TRY_STATUS(from_json(to.exclude_chat_ids_, from.extract_field("exclude_chat_ids")));
  TRY_STATUS(from_json(to.return_deleted_file_statistics_, from.extract_field("return_deleted_file_statistics")));
  TRY_STATUS(from_json(to.chat_limit_, from.extract_field("chat_limit")));
  return Status::OK();
}

Status from_json(td_api::processChatJoinRequest &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.approve_, from.extract_field("approve")));
  return Status::OK();
}

Status from_json(td_api::readBusinessMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::registerUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.first_name_, from.extract_field("first_name")));
  TRY_STATUS(from_json(to.last_name_, from.extract_field("last_name")));
  TRY_STATUS(from_json(to.disable_notification_, from.extract_field("disable_notification")));
  return Status::OK();
}

Status from_json(td_api::removeMessageReaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  return Status::OK();
}

Status from_json(td_api::removeRecentSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_attached_, from.extract_field("is_attached")));
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::reorderBotActiveUsernames &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.usernames_, from.extract_field("usernames")));
  return Status::OK();
}

Status from_json(td_api::reorderSupergroupActiveUsernames &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.usernames_, from.extract_field("usernames")));
  return Status::OK();
}

Status from_json(td_api::reportMessageReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.sender_id_, from.extract_field("sender_id")));
  return Status::OK();
}

Status from_json(td_api::requestQrCodeAuthentication &to, JsonObject &from) {
  TRY_STATUS(from_json(to.other_user_ids_, from.extract_field("other_user_ids")));
  return Status::OK();
}

Status from_json(td_api::resetInstalledBackgrounds &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchBackground &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::searchEmojis &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.input_language_codes_, from.extract_field("input_language_codes")));
  return Status::OK();
}

Status from_json(td_api::searchPublicMessagesByTag &to, JsonObject &from) {
  TRY_STATUS(from_json(to.tag_, from.extract_field("tag")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.ignore_cache_, from.extract_field("ignore_cache")));
  return Status::OK();
}

Status from_json(td_api::sendBotStartMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.parameter_, from.extract_field("parameter")));
  return Status::OK();
}

Status from_json(td_api::sendEmailAddressVerificationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.email_address_, from.extract_field("email_address")));
  return Status::OK();
}

Status from_json(td_api::sendPhoneNumberFirebaseSms &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::setApplicationVerificationToken &to, JsonObject &from) {
  TRY_STATUS(from_json(to.verification_id_, from.extract_field("verification_id")));
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::setBotInfoDescription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  return Status::OK();
}

Status from_json(td_api::setBusinessAccountUsername &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  return Status::OK();
}

Status from_json(td_api::setChatActiveStoriesList &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_list_, from.extract_field("story_list")));
  return Status::OK();
}

Status from_json(td_api::setChatEmojiStatus &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.emoji_status_, from.extract_field("emoji_status")));
  return Status::OK();
}

Status from_json(td_api::setChatPinnedStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_ids_, from.extract_field("story_ids")));
  return Status::OK();
}

Status from_json(td_api::setCustomLanguagePackString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  TRY_STATUS(from_json(to.new_string_, from.extract_field("new_string")));
  return Status::OK();
}

Status from_json(td_api::setFileGenerationProgress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.generation_id_, from.extract_field("generation_id")));
  TRY_STATUS(from_json(to.expected_size_, from.extract_field("expected_size")));
  TRY_STATUS(from_json(to.local_prefix_size_, from.extract_field("local_prefix_size")));
  return Status::OK();
}

Status from_json(td_api::setInactiveSessionTtl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.inactive_session_ttl_days_, from.extract_field("inactive_session_ttl_days")));
  return Status::OK();
}

Status from_json(td_api::setMessageFactCheck &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::setPassportElement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.element_, from.extract_field("element")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::setProfileAccentColor &to, JsonObject &from) {
  TRY_STATUS(from_json(to.profile_accent_color_id_, from.extract_field("profile_accent_color_id")));
  TRY_STATUS(from_json(to.profile_background_custom_emoji_id_, from.extract_field("profile_background_custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::setStickerEmojis &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  TRY_STATUS(from_json(to.emojis_, from.extract_field("emojis")));
  return Status::OK();
}

Status from_json(td_api::setSupergroupCustomEmojiStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.custom_emoji_sticker_set_id_, from.extract_field("custom_emoji_sticker_set_id")));
  return Status::OK();
}

Status from_json(td_api::setUserPersonalProfilePhoto &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.photo_, from.extract_field("photo")));
  return Status::OK();
}

Status from_json(td_api::startGroupCallRecording &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.record_video_, from.extract_field("record_video")));
  TRY_STATUS(from_json(to.use_portrait_orientation_, from.extract_field("use_portrait_orientation")));
  return Status::OK();
}

Status from_json(td_api::terminateAllOtherSessions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::testGetDifference &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::toggleBotUsernameIsActive &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  TRY_STATUS(from_json(to.is_active_, from.extract_field("is_active")));
  return Status::OK();
}

Status from_json(td_api::toggleChatViewAsTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.view_as_topics_, from.extract_field("view_as_topics")));
  return Status::OK();
}

Status from_json(td_api::toggleGroupCallIsMyVideoPaused &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.is_my_video_paused_, from.extract_field("is_my_video_paused")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupCanHaveSponsoredMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.can_have_sponsored_messages_, from.extract_field("can_have_sponsored_messages")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupSignMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.sign_messages_, from.extract_field("sign_messages")));
  TRY_STATUS(from_json(to.show_message_sender_, from.extract_field("show_message_sender")));
  return Status::OK();
}

Status from_json(td_api::translateText &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.to_language_code_, from.extract_field("to_language_code")));
  return Status::OK();
}

Status from_json(td_api::viewMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.source_, from.extract_field("source")));
  TRY_STATUS(from_json(to.force_read_, from.extract_field("force_read")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::accountTtl &object) {
  auto jo = jv.enter_object();
  jo("@type", "accountTtl");
  jo("days", object.days_);
}

void to_json(JsonValueScope &jv, const td_api::ageVerificationParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "ageVerificationParameters");
  jo("min_age", object.min_age_);
  jo("verification_bot_username", object.verification_bot_username_);
  jo("country", object.country_);
}

void to_json(JsonValueScope &jv, const td_api::auctionBid &object) {
  auto jo = jv.enter_object();
  jo("@type", "auctionBid");
  jo("star_count", object.star_count_);
  jo("bid_date", object.bid_date_);
  jo("position", object.position_);
}

void to_json(JsonValueScope &jv, const td_api::autosaveSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "autosaveSettings");
  if (object.private_chat_settings_) {
    jo("private_chat_settings", ToJson(*object.private_chat_settings_));
  }
  if (object.group_settings_) {
    jo("group_settings", ToJson(*object.group_settings_));
  }
  if (object.channel_settings_) {
    jo("channel_settings", ToJson(*object.channel_settings_));
  }
  jo("exceptions", ToJson(object.exceptions_));
}

void to_json(JsonValueScope &jv, const td_api::BackgroundType &object) {
  td_api::downcast_call(const_cast<td_api::BackgroundType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::backgroundTypeWallpaper &object) {
  auto jo = jv.enter_object();
  jo("@type", "backgroundTypeWallpaper");
  jo("is_blurred", JsonBool{object.is_blurred_});
  jo("is_moving", JsonBool{object.is_moving_});
}

void to_json(JsonValueScope &jv, const td_api::backgroundTypePattern &object) {
  auto jo = jv.enter_object();
  jo("@type", "backgroundTypePattern");
  if (object.fill_) {
    jo("fill", ToJson(*object.fill_));
  }
  jo("intensity", object.intensity_);
  jo("is_inverted", JsonBool{object.is_inverted_});
  jo("is_moving", JsonBool{object.is_moving_});
}

void to_json(JsonValueScope &jv, const td_api::backgroundTypeFill &object) {
  auto jo = jv.enter_object();
  jo("@type", "backgroundTypeFill");
  if (object.fill_) {
    jo("fill", ToJson(*object.fill_));
  }
}

void to_json(JsonValueScope &jv, const td_api::backgroundTypeChatTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "backgroundTypeChatTheme");
  jo("theme_name", object.theme_name_);
}

void to_json(JsonValueScope &jv, const td_api::botCommands &object) {
  auto jo = jv.enter_object();
  jo("@type", "botCommands");
  jo("bot_user_id", object.bot_user_id_);
  jo("commands", ToJson(object.commands_));
}

void to_json(JsonValueScope &jv, const td_api::BuiltInTheme &object) {
  td_api::downcast_call(const_cast<td_api::BuiltInTheme &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::builtInThemeClassic &object) {
  auto jo = jv.enter_object();
  jo("@type", "builtInThemeClassic");
}

void to_json(JsonValueScope &jv, const td_api::builtInThemeDay &object) {
  auto jo = jv.enter_object();
  jo("@type", "builtInThemeDay");
}

void to_json(JsonValueScope &jv, const td_api::builtInThemeNight &object) {
  auto jo = jv.enter_object();
  jo("@type", "builtInThemeNight");
}

void to_json(JsonValueScope &jv, const td_api::builtInThemeTinted &object) {
  auto jo = jv.enter_object();
  jo("@type", "builtInThemeTinted");
}

void to_json(JsonValueScope &jv, const td_api::builtInThemeArctic &object) {
  auto jo = jv.enter_object();
  jo("@type", "builtInThemeArctic");
}

void to_json(JsonValueScope &jv, const td_api::businessConnection &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessConnection");
  jo("id", object.id_);
  jo("user_id", object.user_id_);
  jo("user_chat_id", object.user_chat_id_);
  jo("date", object.date_);
  if (object.rights_) {
    jo("rights", ToJson(*object.rights_));
  }
  jo("is_enabled", JsonBool{object.is_enabled_});
}

void to_json(JsonValueScope &jv, const td_api::businessOpeningHours &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessOpeningHours");
  jo("time_zone_id", object.time_zone_id_);
  jo("opening_hours", ToJson(object.opening_hours_));
}

void to_json(JsonValueScope &jv, const td_api::CallServerType &object) {
  td_api::downcast_call(const_cast<td_api::CallServerType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::callServerTypeTelegramReflector &object) {
  auto jo = jv.enter_object();
  jo("@type", "callServerTypeTelegramReflector");
  jo("peer_tag", base64_encode(object.peer_tag_));
  jo("is_tcp", JsonBool{object.is_tcp_});
}

void to_json(JsonValueScope &jv, const td_api::callServerTypeWebrtc &object) {
  auto jo = jv.enter_object();
  jo("@type", "callServerTypeWebrtc");
  jo("username", object.username_);
  jo("password", object.password_);
  jo("supports_turn", JsonBool{object.supports_turn_});
  jo("supports_stun", JsonBool{object.supports_stun_});
}

void to_json(JsonValueScope &jv, const td_api::ChatAction &object) {
  td_api::downcast_call(const_cast<td_api::ChatAction &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatActionTyping &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionTyping");
}

void to_json(JsonValueScope &jv, const td_api::chatActionRecordingVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionRecordingVideo");
}

void to_json(JsonValueScope &jv, const td_api::chatActionUploadingVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionUploadingVideo");
  jo("progress", object.progress_);
}

void to_json(JsonValueScope &jv, const td_api::chatActionRecordingVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionRecordingVoiceNote");
}

void to_json(JsonValueScope &jv, const td_api::chatActionUploadingVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionUploadingVoiceNote");
  jo("progress", object.progress_);
}

void to_json(JsonValueScope &jv, const td_api::chatActionUploadingPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionUploadingPhoto");
  jo("progress", object.progress_);
}

void to_json(JsonValueScope &jv, const td_api::chatActionUploadingDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionUploadingDocument");
  jo("progress", object.progress_);
}

void to_json(JsonValueScope &jv, const td_api::chatActionChoosingSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionChoosingSticker");
}

void to_json(JsonValueScope &jv, const td_api::chatActionChoosingLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionChoosingLocation");
}

void to_json(JsonValueScope &jv, const td_api::chatActionChoosingContact &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionChoosingContact");
}

void to_json(JsonValueScope &jv, const td_api::chatActionStartPlayingGame &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionStartPlayingGame");
}

void to_json(JsonValueScope &jv, const td_api::chatActionRecordingVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionRecordingVideoNote");
}

void to_json(JsonValueScope &jv, const td_api::chatActionUploadingVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionUploadingVideoNote");
  jo("progress", object.progress_);
}

void to_json(JsonValueScope &jv, const td_api::chatActionWatchingAnimations &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionWatchingAnimations");
  jo("emoji", object.emoji_);
}

void to_json(JsonValueScope &jv, const td_api::chatActionCancel &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionCancel");
}

void to_json(JsonValueScope &jv, const td_api::chatBoostFeatures &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostFeatures");
  jo("features", ToJson(object.features_));
  jo("min_profile_background_custom_emoji_boost_level", object.min_profile_background_custom_emoji_boost_level_);
  jo("min_background_custom_emoji_boost_level", object.min_background_custom_emoji_boost_level_);
  jo("min_emoji_status_boost_level", object.min_emoji_status_boost_level_);
  jo("min_chat_theme_background_boost_level", object.min_chat_theme_background_boost_level_);
  jo("min_custom_background_boost_level", object.min_custom_background_boost_level_);
  jo("min_custom_emoji_sticker_set_boost_level", object.min_custom_emoji_sticker_set_boost_level_);
  jo("min_automatic_translation_boost_level", object.min_automatic_translation_boost_level_);
  jo("min_speech_recognition_boost_level", object.min_speech_recognition_boost_level_);
  jo("min_sponsored_message_disable_boost_level", object.min_sponsored_message_disable_boost_level_);
}

void to_json(JsonValueScope &jv, const td_api::ChatEventAction &object) {
  td_api::downcast_call(const_cast<td_api::ChatEventAction &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatEventMessageEdited &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMessageEdited");
  if (object.old_message_) {
    jo("old_message", ToJson(*object.old_message_));
  }
  if (object.new_message_) {
    jo("new_message", ToJson(*object.new_message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventMessageDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMessageDeleted");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  jo("can_report_anti_spam_false_positive", JsonBool{object.can_report_anti_spam_false_positive_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventMessagePinned &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMessagePinned");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventMessageUnpinned &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMessageUnpinned");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventPollStopped &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventPollStopped");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventMemberJoined &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMemberJoined");
}

void to_json(JsonValueScope &jv, const td_api::chatEventMemberJoinedByInviteLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMemberJoinedByInviteLink");
  if (object.invite_link_) {
    jo("invite_link", ToJson(*object.invite_link_));
  }
  jo("via_chat_folder_invite_link", JsonBool{object.via_chat_folder_invite_link_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventMemberJoinedByRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMemberJoinedByRequest");
  jo("approver_user_id", object.approver_user_id_);
  if (object.invite_link_) {
    jo("invite_link", ToJson(*object.invite_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventMemberInvited &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMemberInvited");
  jo("user_id", object.user_id_);
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventMemberLeft &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMemberLeft");
}

void to_json(JsonValueScope &jv, const td_api::chatEventMemberPromoted &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMemberPromoted");
  jo("user_id", object.user_id_);
  if (object.old_status_) {
    jo("old_status", ToJson(*object.old_status_));
  }
  if (object.new_status_) {
    jo("new_status", ToJson(*object.new_status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventMemberRestricted &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMemberRestricted");
  if (object.member_id_) {
    jo("member_id", ToJson(*object.member_id_));
  }
  if (object.old_status_) {
    jo("old_status", ToJson(*object.old_status_));
  }
  if (object.new_status_) {
    jo("new_status", ToJson(*object.new_status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventMemberSubscriptionExtended &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMemberSubscriptionExtended");
  jo("user_id", object.user_id_);
  if (object.old_status_) {
    jo("old_status", ToJson(*object.old_status_));
  }
  if (object.new_status_) {
    jo("new_status", ToJson(*object.new_status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventAvailableReactionsChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventAvailableReactionsChanged");
  if (object.old_available_reactions_) {
    jo("old_available_reactions", ToJson(*object.old_available_reactions_));
  }
  if (object.new_available_reactions_) {
    jo("new_available_reactions", ToJson(*object.new_available_reactions_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventBackgroundChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventBackgroundChanged");
  if (object.old_background_) {
    jo("old_background", ToJson(*object.old_background_));
  }
  if (object.new_background_) {
    jo("new_background", ToJson(*object.new_background_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventDescriptionChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventDescriptionChanged");
  jo("old_description", object.old_description_);
  jo("new_description", object.new_description_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventEmojiStatusChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventEmojiStatusChanged");
  if (object.old_emoji_status_) {
    jo("old_emoji_status", ToJson(*object.old_emoji_status_));
  }
  if (object.new_emoji_status_) {
    jo("new_emoji_status", ToJson(*object.new_emoji_status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventLinkedChatChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventLinkedChatChanged");
  jo("old_linked_chat_id", object.old_linked_chat_id_);
  jo("new_linked_chat_id", object.new_linked_chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventLocationChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventLocationChanged");
  if (object.old_location_) {
    jo("old_location", ToJson(*object.old_location_));
  }
  if (object.new_location_) {
    jo("new_location", ToJson(*object.new_location_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventMessageAutoDeleteTimeChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventMessageAutoDeleteTimeChanged");
  jo("old_message_auto_delete_time", object.old_message_auto_delete_time_);
  jo("new_message_auto_delete_time", object.new_message_auto_delete_time_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventPermissionsChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventPermissionsChanged");
  if (object.old_permissions_) {
    jo("old_permissions", ToJson(*object.old_permissions_));
  }
  if (object.new_permissions_) {
    jo("new_permissions", ToJson(*object.new_permissions_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventPhotoChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventPhotoChanged");
  if (object.old_photo_) {
    jo("old_photo", ToJson(*object.old_photo_));
  }
  if (object.new_photo_) {
    jo("new_photo", ToJson(*object.new_photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventSlowModeDelayChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventSlowModeDelayChanged");
  jo("old_slow_mode_delay", object.old_slow_mode_delay_);
  jo("new_slow_mode_delay", object.new_slow_mode_delay_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventStickerSetChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventStickerSetChanged");
  jo("old_sticker_set_id", ToJson(JsonInt64{object.old_sticker_set_id_}));
  jo("new_sticker_set_id", ToJson(JsonInt64{object.new_sticker_set_id_}));
}

void to_json(JsonValueScope &jv, const td_api::chatEventCustomEmojiStickerSetChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventCustomEmojiStickerSetChanged");
  jo("old_sticker_set_id", ToJson(JsonInt64{object.old_sticker_set_id_}));
  jo("new_sticker_set_id", ToJson(JsonInt64{object.new_sticker_set_id_}));
}

void to_json(JsonValueScope &jv, const td_api::chatEventTitleChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventTitleChanged");
  jo("old_title", object.old_title_);
  jo("new_title", object.new_title_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventUsernameChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventUsernameChanged");
  jo("old_username", object.old_username_);
  jo("new_username", object.new_username_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventActiveUsernamesChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventActiveUsernamesChanged");
  jo("old_usernames", ToJson(object.old_usernames_));
  jo("new_usernames", ToJson(object.new_usernames_));
}

void to_json(JsonValueScope &jv, const td_api::chatEventAccentColorChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventAccentColorChanged");
  jo("old_accent_color_id", object.old_accent_color_id_);
  jo("old_background_custom_emoji_id", ToJson(JsonInt64{object.old_background_custom_emoji_id_}));
  jo("new_accent_color_id", object.new_accent_color_id_);
  jo("new_background_custom_emoji_id", ToJson(JsonInt64{object.new_background_custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::chatEventProfileAccentColorChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventProfileAccentColorChanged");
  jo("old_profile_accent_color_id", object.old_profile_accent_color_id_);
  jo("old_profile_background_custom_emoji_id", ToJson(JsonInt64{object.old_profile_background_custom_emoji_id_}));
  jo("new_profile_accent_color_id", object.new_profile_accent_color_id_);
  jo("new_profile_background_custom_emoji_id", ToJson(JsonInt64{object.new_profile_background_custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::chatEventHasProtectedContentToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventHasProtectedContentToggled");
  jo("has_protected_content", JsonBool{object.has_protected_content_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventInvitesToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventInvitesToggled");
  jo("can_invite_users", JsonBool{object.can_invite_users_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventIsAllHistoryAvailableToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventIsAllHistoryAvailableToggled");
  jo("is_all_history_available", JsonBool{object.is_all_history_available_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventHasAggressiveAntiSpamEnabledToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventHasAggressiveAntiSpamEnabledToggled");
  jo("has_aggressive_anti_spam_enabled", JsonBool{object.has_aggressive_anti_spam_enabled_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventSignMessagesToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventSignMessagesToggled");
  jo("sign_messages", JsonBool{object.sign_messages_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventShowMessageSenderToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventShowMessageSenderToggled");
  jo("show_message_sender", JsonBool{object.show_message_sender_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventAutomaticTranslationToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventAutomaticTranslationToggled");
  jo("has_automatic_translation", JsonBool{object.has_automatic_translation_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventInviteLinkEdited &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventInviteLinkEdited");
  if (object.old_invite_link_) {
    jo("old_invite_link", ToJson(*object.old_invite_link_));
  }
  if (object.new_invite_link_) {
    jo("new_invite_link", ToJson(*object.new_invite_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventInviteLinkRevoked &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventInviteLinkRevoked");
  if (object.invite_link_) {
    jo("invite_link", ToJson(*object.invite_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventInviteLinkDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventInviteLinkDeleted");
  if (object.invite_link_) {
    jo("invite_link", ToJson(*object.invite_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventVideoChatCreated &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventVideoChatCreated");
  jo("group_call_id", object.group_call_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventVideoChatEnded &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventVideoChatEnded");
  jo("group_call_id", object.group_call_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventVideoChatMuteNewParticipantsToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventVideoChatMuteNewParticipantsToggled");
  jo("mute_new_participants", JsonBool{object.mute_new_participants_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventVideoChatParticipantIsMutedToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventVideoChatParticipantIsMutedToggled");
  if (object.participant_id_) {
    jo("participant_id", ToJson(*object.participant_id_));
  }
  jo("is_muted", JsonBool{object.is_muted_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventVideoChatParticipantVolumeLevelChanged &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventVideoChatParticipantVolumeLevelChanged");
  if (object.participant_id_) {
    jo("participant_id", ToJson(*object.participant_id_));
  }
  jo("volume_level", object.volume_level_);
}

void to_json(JsonValueScope &jv, const td_api::chatEventIsForumToggled &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventIsForumToggled");
  jo("is_forum", JsonBool{object.is_forum_});
}

void to_json(JsonValueScope &jv, const td_api::chatEventForumTopicCreated &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventForumTopicCreated");
  if (object.topic_info_) {
    jo("topic_info", ToJson(*object.topic_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventForumTopicEdited &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventForumTopicEdited");
  if (object.old_topic_info_) {
    jo("old_topic_info", ToJson(*object.old_topic_info_));
  }
  if (object.new_topic_info_) {
    jo("new_topic_info", ToJson(*object.new_topic_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventForumTopicToggleIsClosed &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventForumTopicToggleIsClosed");
  if (object.topic_info_) {
    jo("topic_info", ToJson(*object.topic_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventForumTopicToggleIsHidden &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventForumTopicToggleIsHidden");
  if (object.topic_info_) {
    jo("topic_info", ToJson(*object.topic_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventForumTopicDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventForumTopicDeleted");
  if (object.topic_info_) {
    jo("topic_info", ToJson(*object.topic_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatEventForumTopicPinned &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEventForumTopicPinned");
  if (object.old_topic_info_) {
    jo("old_topic_info", ToJson(*object.old_topic_info_));
  }
  if (object.new_topic_info_) {
    jo("new_topic_info", ToJson(*object.new_topic_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLink");
  jo("invite_link", object.invite_link_);
  jo("name", object.name_);
  jo("creator_user_id", object.creator_user_id_);
  jo("date", object.date_);
  jo("edit_date", object.edit_date_);
  jo("expiration_date", object.expiration_date_);
  if (object.subscription_pricing_) {
    jo("subscription_pricing", ToJson(*object.subscription_pricing_));
  }
  jo("member_limit", object.member_limit_);
  jo("member_count", object.member_count_);
  jo("expired_member_count", object.expired_member_count_);
  jo("pending_join_request_count", object.pending_join_request_count_);
  jo("creates_join_request", JsonBool{object.creates_join_request_});
  jo("is_primary", JsonBool{object.is_primary_});
  jo("is_revoked", JsonBool{object.is_revoked_});
}

void to_json(JsonValueScope &jv, const td_api::chatJoinRequests &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatJoinRequests");
  jo("total_count", object.total_count_);
  jo("requests", ToJson(object.requests_));
}

void to_json(JsonValueScope &jv, const td_api::chatMessageSenders &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMessageSenders");
  jo("senders", ToJson(object.senders_));
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueAmount &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueAmount");
  jo("cryptocurrency", object.cryptocurrency_);
  jo("total_amount", ToJson(JsonInt64{object.total_amount_}));
  jo("balance_amount", ToJson(JsonInt64{object.balance_amount_}));
  jo("available_amount", ToJson(JsonInt64{object.available_amount_}));
  jo("withdrawal_enabled", JsonBool{object.withdrawal_enabled_});
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsInviterInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsInviterInfo");
  jo("user_id", object.user_id_);
  jo("added_member_count", object.added_member_count_);
}

void to_json(JsonValueScope &jv, const td_api::checklistTask &object) {
  auto jo = jv.enter_object();
  jo("@type", "checklistTask");
  jo("id", object.id_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  if (object.completed_by_) {
    jo("completed_by", ToJson(*object.completed_by_));
  }
  jo("completion_date", object.completion_date_);
}

void to_json(JsonValueScope &jv, const td_api::contact &object) {
  auto jo = jv.enter_object();
  jo("@type", "contact");
  jo("phone_number", object.phone_number_);
  jo("first_name", object.first_name_);
  jo("last_name", object.last_name_);
  jo("vcard", object.vcard_);
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::date &object) {
  auto jo = jv.enter_object();
  jo("@type", "date");
  jo("day", object.day_);
  jo("month", object.month_);
  jo("year", object.year_);
}

void to_json(JsonValueScope &jv, const td_api::emailAddressAuthenticationCodeInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "emailAddressAuthenticationCodeInfo");
  jo("email_address_pattern", object.email_address_pattern_);
  jo("length", object.length_);
}

void to_json(JsonValueScope &jv, const td_api::emojiStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiStatus");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("expiration_date", object.expiration_date_);
}

void to_json(JsonValueScope &jv, const td_api::failedToAddMember &object) {
  auto jo = jv.enter_object();
  jo("@type", "failedToAddMember");
  jo("user_id", object.user_id_);
  jo("premium_would_allow_invite", JsonBool{object.premium_would_allow_invite_});
  jo("premium_required_to_send_messages", JsonBool{object.premium_required_to_send_messages_});
}

void to_json(JsonValueScope &jv, const td_api::forumTopicIcon &object) {
  auto jo = jv.enter_object();
  jo("@type", "forumTopicIcon");
  jo("color", object.color_);
  jo("custom_emoji_id", ToJson(JsonInt64{object.custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::foundMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundMessages");
  jo("total_count", object.total_count_);
  jo("messages", ToJson(object.messages_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::gameHighScores &object) {
  auto jo = jv.enter_object();
  jo("@type", "gameHighScores");
  jo("scores", ToJson(object.scores_));
}

void to_json(JsonValueScope &jv, const td_api::giftCollection &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftCollection");
  jo("id", object.id_);
  jo("name", object.name_);
  if (object.icon_) {
    jo("icon", ToJson(*object.icon_));
  }
  jo("gift_count", object.gift_count_);
}

void to_json(JsonValueScope &jv, const td_api::giftUpgradePrice &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftUpgradePrice");
  jo("date", object.date_);
  jo("star_count", object.star_count_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallMessage");
  jo("message_id", object.message_id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("date", object.date_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("paid_message_star_count", object.paid_message_star_count_);
  jo("is_from_owner", JsonBool{object.is_from_owner_});
  jo("can_be_deleted", JsonBool{object.can_be_deleted_});
}

void to_json(JsonValueScope &jv, const td_api::hashtags &object) {
  auto jo = jv.enter_object();
  jo("@type", "hashtags");
  jo("hashtags", ToJson(object.hashtags_));
}

void to_json(JsonValueScope &jv, const td_api::InlineQueryResultsButtonType &object) {
  td_api::downcast_call(const_cast<td_api::InlineQueryResultsButtonType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inlineQueryResultsButtonTypeStartBot &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineQueryResultsButtonTypeStartBot");
  jo("parameter", object.parameter_);
}

void to_json(JsonValueScope &jv, const td_api::inlineQueryResultsButtonTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineQueryResultsButtonTypeWebApp");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::inputTextQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputTextQuote");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("position", object.position_);
}

void to_json(JsonValueScope &jv, const td_api::KeyboardButtonType &object) {
  td_api::downcast_call(const_cast<td_api::KeyboardButtonType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeText &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeText");
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestPhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestLocation");
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestPoll &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestPoll");
  jo("force_regular", JsonBool{object.force_regular_});
  jo("force_quiz", JsonBool{object.force_quiz_});
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestUsers &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestUsers");
  jo("id", object.id_);
  jo("restrict_user_is_bot", JsonBool{object.restrict_user_is_bot_});
  jo("user_is_bot", JsonBool{object.user_is_bot_});
  jo("restrict_user_is_premium", JsonBool{object.restrict_user_is_premium_});
  jo("user_is_premium", JsonBool{object.user_is_premium_});
  jo("max_quantity", object.max_quantity_);
  jo("request_name", JsonBool{object.request_name_});
  jo("request_username", JsonBool{object.request_username_});
  jo("request_photo", JsonBool{object.request_photo_});
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestChat");
  jo("id", object.id_);
  jo("chat_is_channel", JsonBool{object.chat_is_channel_});
  jo("restrict_chat_is_forum", JsonBool{object.restrict_chat_is_forum_});
  jo("chat_is_forum", JsonBool{object.chat_is_forum_});
  jo("restrict_chat_has_username", JsonBool{object.restrict_chat_has_username_});
  jo("chat_has_username", JsonBool{object.chat_has_username_});
  jo("chat_is_created", JsonBool{object.chat_is_created_});
  if (object.user_administrator_rights_) {
    jo("user_administrator_rights", ToJson(*object.user_administrator_rights_));
  }
  if (object.bot_administrator_rights_) {
    jo("bot_administrator_rights", ToJson(*object.bot_administrator_rights_));
  }
  jo("bot_is_member", JsonBool{object.bot_is_member_});
  jo("request_title", JsonBool{object.request_title_});
  jo("request_username", JsonBool{object.request_username_});
  jo("request_photo", JsonBool{object.request_photo_});
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeWebApp");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::LinkPreviewType &object) {
  td_api::downcast_call(const_cast<td_api::LinkPreviewType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeAlbum");
  jo("media", ToJson(object.media_));
  jo("caption", object.caption_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeAnimation");
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeApp");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeArticle &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeArticle");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeAudio");
  if (object.audio_) {
    jo("audio", ToJson(*object.audio_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeBackground");
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
  if (object.background_type_) {
    jo("background_type", ToJson(*object.background_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeChannelBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeChannelBoost");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeChat");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("creates_join_request", JsonBool{object.creates_join_request_});
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeDirectMessagesChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeDirectMessagesChat");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeDocument");
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeEmbeddedAnimationPlayer &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeEmbeddedAnimationPlayer");
  jo("url", object.url_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeEmbeddedAudioPlayer &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeEmbeddedAudioPlayer");
  jo("url", object.url_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeEmbeddedVideoPlayer &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeEmbeddedVideoPlayer");
  jo("url", object.url_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeExternalAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeExternalAudio");
  jo("url", object.url_);
  jo("mime_type", object.mime_type_);
  jo("duration", object.duration_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeExternalVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeExternalVideo");
  jo("url", object.url_);
  jo("mime_type", object.mime_type_);
  jo("width", object.width_);
  jo("height", object.height_);
  jo("duration", object.duration_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeGiftAuction &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeGiftAuction");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  if (object.gift_background_) {
    jo("gift_background", ToJson(*object.gift_background_));
  }
  jo("auction_end_date", object.auction_end_date_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeGiftCollection &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeGiftCollection");
  jo("icons", ToJson(object.icons_));
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeGroupCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeGroupCall");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeInvoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeInvoice");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeLiveStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeLiveStory");
  jo("story_poster_chat_id", object.story_poster_chat_id_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeMessage");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypePhoto");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypePremiumGiftCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypePremiumGiftCode");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeShareableChatFolder &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeShareableChatFolder");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeSticker");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeStickerSet &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeStickerSet");
  jo("stickers", ToJson(object.stickers_));
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeStory");
  jo("story_poster_chat_id", object.story_poster_chat_id_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeStoryAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeStoryAlbum");
  if (object.photo_icon_) {
    jo("photo_icon", ToJson(*object.photo_icon_));
  }
  if (object.video_icon_) {
    jo("video_icon", ToJson(*object.video_icon_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeSupergroupBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeSupergroupBoost");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeTheme");
  jo("documents", ToJson(object.documents_));
  if (object.settings_) {
    jo("settings", ToJson(*object.settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeUnsupported &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeUnsupported");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeUpgradedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeUpgradedGift");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeUser");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("is_bot", JsonBool{object.is_bot_});
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeVideo");
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
  if (object.cover_) {
    jo("cover", ToJson(*object.cover_));
  }
  jo("start_timestamp", object.start_timestamp_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeVideoChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeVideoChat");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("is_live_stream", JsonBool{object.is_live_stream_});
  jo("joins_as_speaker", JsonBool{object.joins_as_speaker_});
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeVideoNote");
  if (object.video_note_) {
    jo("video_note", ToJson(*object.video_note_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeVoiceNote");
  if (object.voice_note_) {
    jo("voice_note", ToJson(*object.voice_note_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeWebApp");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::LoginUrlInfo &object) {
  td_api::downcast_call(const_cast<td_api::LoginUrlInfo &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::loginUrlInfoOpen &object) {
  auto jo = jv.enter_object();
  jo("@type", "loginUrlInfoOpen");
  jo("url", object.url_);
  jo("skip_confirmation", JsonBool{object.skip_confirmation_});
}

void to_json(JsonValueScope &jv, const td_api::loginUrlInfoRequestConfirmation &object) {
  auto jo = jv.enter_object();
  jo("@type", "loginUrlInfoRequestConfirmation");
  jo("url", object.url_);
  jo("domain", object.domain_);
  jo("bot_user_id", object.bot_user_id_);
  jo("request_write_access", JsonBool{object.request_write_access_});
}

void to_json(JsonValueScope &jv, const td_api::messageCopyOptions &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageCopyOptions");
  jo("send_copy", JsonBool{object.send_copy_});
  jo("replace_caption", JsonBool{object.replace_caption_});
  if (object.new_caption_) {
    jo("new_caption", ToJson(*object.new_caption_));
  }
  jo("new_show_caption_above_media", JsonBool{object.new_show_caption_above_media_});
}

void to_json(JsonValueScope &jv, const td_api::MessageOrigin &object) {
  td_api::downcast_call(const_cast<td_api::MessageOrigin &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageOriginUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageOriginUser");
  jo("sender_user_id", object.sender_user_id_);
}

void to_json(JsonValueScope &jv, const td_api::messageOriginHiddenUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageOriginHiddenUser");
  jo("sender_name", object.sender_name_);
}

void to_json(JsonValueScope &jv, const td_api::messageOriginChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageOriginChat");
  jo("sender_chat_id", object.sender_chat_id_);
  jo("author_signature", object.author_signature_);
}

void to_json(JsonValueScope &jv, const td_api::messageOriginChannel &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageOriginChannel");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("author_signature", object.author_signature_);
}

void to_json(JsonValueScope &jv, const td_api::MessageSchedulingState &object) {
  td_api::downcast_call(const_cast<td_api::MessageSchedulingState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageSchedulingStateSendAtDate &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSchedulingStateSendAtDate");
  jo("send_date", object.send_date_);
  jo("repeat_period", object.repeat_period_);
}

void to_json(JsonValueScope &jv, const td_api::messageSchedulingStateSendWhenOnline &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSchedulingStateSendWhenOnline");
}

void to_json(JsonValueScope &jv, const td_api::messageSchedulingStateSendWhenVideoProcessed &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSchedulingStateSendWhenVideoProcessed");
  jo("send_date", object.send_date_);
}

void to_json(JsonValueScope &jv, const td_api::messageViewers &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageViewers");
  jo("viewers", ToJson(object.viewers_));
}

void to_json(JsonValueScope &jv, const td_api::NotificationGroupType &object) {
  td_api::downcast_call(const_cast<td_api::NotificationGroupType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::notificationGroupTypeMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationGroupTypeMessages");
}

void to_json(JsonValueScope &jv, const td_api::notificationGroupTypeMentions &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationGroupTypeMentions");
}

void to_json(JsonValueScope &jv, const td_api::notificationGroupTypeSecretChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationGroupTypeSecretChat");
}

void to_json(JsonValueScope &jv, const td_api::notificationGroupTypeCalls &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationGroupTypeCalls");
}

void to_json(JsonValueScope &jv, const td_api::PageBlock &object) {
  td_api::downcast_call(const_cast<td_api::PageBlock &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::pageBlockTitle &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockTitle");
  if (object.title_) {
    jo("title", ToJson(*object.title_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockSubtitle &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockSubtitle");
  if (object.subtitle_) {
    jo("subtitle", ToJson(*object.subtitle_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockAuthorDate &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockAuthorDate");
  if (object.author_) {
    jo("author", ToJson(*object.author_));
  }
  jo("publish_date", object.publish_date_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockHeader &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockHeader");
  if (object.header_) {
    jo("header", ToJson(*object.header_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockSubheader &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockSubheader");
  if (object.subheader_) {
    jo("subheader", ToJson(*object.subheader_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockKicker &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockKicker");
  if (object.kicker_) {
    jo("kicker", ToJson(*object.kicker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockParagraph &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockParagraph");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockPreformatted &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockPreformatted");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("language", object.language_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockFooter &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockFooter");
  if (object.footer_) {
    jo("footer", ToJson(*object.footer_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockDivider &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockDivider");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockAnchor &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockAnchor");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockList &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockList");
  jo("items", ToJson(object.items_));
}

void to_json(JsonValueScope &jv, const td_api::pageBlockBlockQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockBlockQuote");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  if (object.credit_) {
    jo("credit", ToJson(*object.credit_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockPullQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockPullQuote");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  if (object.credit_) {
    jo("credit", ToJson(*object.credit_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockAnimation");
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("need_autoplay", JsonBool{object.need_autoplay_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockAudio");
  if (object.audio_) {
    jo("audio", ToJson(*object.audio_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockPhoto");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockVideo");
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("need_autoplay", JsonBool{object.need_autoplay_});
  jo("is_looped", JsonBool{object.is_looped_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockVoiceNote");
  if (object.voice_note_) {
    jo("voice_note", ToJson(*object.voice_note_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockCover &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockCover");
  if (object.cover_) {
    jo("cover", ToJson(*object.cover_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockEmbedded &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockEmbedded");
  jo("url", object.url_);
  jo("html", object.html_);
  if (object.poster_photo_) {
    jo("poster_photo", ToJson(*object.poster_photo_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("is_full_width", JsonBool{object.is_full_width_});
  jo("allow_scrolling", JsonBool{object.allow_scrolling_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockEmbeddedPost &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockEmbeddedPost");
  jo("url", object.url_);
  jo("author", object.author_);
  if (object.author_photo_) {
    jo("author_photo", ToJson(*object.author_photo_));
  }
  jo("date", object.date_);
  jo("page_blocks", ToJson(object.page_blocks_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockCollage &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockCollage");
  jo("page_blocks", ToJson(object.page_blocks_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockSlideshow &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockSlideshow");
  jo("page_blocks", ToJson(object.page_blocks_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockChatLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockChatLink");
  jo("title", object.title_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("accent_color_id", object.accent_color_id_);
  jo("username", object.username_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockTable &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockTable");
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("cells", ToJson(object.cells_));
  jo("is_bordered", JsonBool{object.is_bordered_});
  jo("is_striped", JsonBool{object.is_striped_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockDetails &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockDetails");
  if (object.header_) {
    jo("header", ToJson(*object.header_));
  }
  jo("page_blocks", ToJson(object.page_blocks_));
  jo("is_open", JsonBool{object.is_open_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockRelatedArticles &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockRelatedArticles");
  if (object.header_) {
    jo("header", ToJson(*object.header_));
  }
  jo("articles", ToJson(object.articles_));
}

void to_json(JsonValueScope &jv, const td_api::pageBlockMap &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockMap");
  if (object.location_) {
    jo("location", ToJson(*object.location_));
  }
  jo("zoom", object.zoom_);
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::paidReactor &object) {
  auto jo = jv.enter_object();
  jo("@type", "paidReactor");
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("star_count", object.star_count_);
  jo("is_top", JsonBool{object.is_top_});
  jo("is_me", JsonBool{object.is_me_});
  jo("is_anonymous", JsonBool{object.is_anonymous_});
}

void to_json(JsonValueScope &jv, const td_api::passportSuitableElement &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportSuitableElement");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("is_selfie_required", JsonBool{object.is_selfie_required_});
  jo("is_translation_required", JsonBool{object.is_translation_required_});
  jo("is_native_name_required", JsonBool{object.is_native_name_required_});
}

void to_json(JsonValueScope &jv, const td_api::personalDetails &object) {
  auto jo = jv.enter_object();
  jo("@type", "personalDetails");
  jo("first_name", object.first_name_);
  jo("middle_name", object.middle_name_);
  jo("last_name", object.last_name_);
  jo("native_first_name", object.native_first_name_);
  jo("native_middle_name", object.native_middle_name_);
  jo("native_last_name", object.native_last_name_);
  if (object.birthdate_) {
    jo("birthdate", ToJson(*object.birthdate_));
  }
  jo("gender", object.gender_);
  jo("country_code", object.country_code_);
  jo("residence_country_code", object.residence_country_code_);
}

void to_json(JsonValueScope &jv, const td_api::PremiumFeature &object) {
  td_api::downcast_call(const_cast<td_api::PremiumFeature &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureIncreasedLimits &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureIncreasedLimits");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureIncreasedUploadFileSize &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureIncreasedUploadFileSize");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureImprovedDownloadSpeed &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureImprovedDownloadSpeed");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureVoiceRecognition &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureVoiceRecognition");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureDisabledAds &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureDisabledAds");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureUniqueReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureUniqueReactions");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureUniqueStickers &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureUniqueStickers");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureCustomEmoji");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureAdvancedChatManagement &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureAdvancedChatManagement");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureProfileBadge &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureProfileBadge");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureEmojiStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureEmojiStatus");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureAnimatedProfilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureAnimatedProfilePhoto");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureForumTopicIcon &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureForumTopicIcon");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureAppIcons &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureAppIcons");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureRealTimeChatTranslation &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureRealTimeChatTranslation");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureUpgradedStories &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureUpgradedStories");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureChatBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureChatBoost");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureAccentColor &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureAccentColor");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureBackgroundForBoth &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureBackgroundForBoth");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureSavedMessagesTags &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureSavedMessagesTags");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureMessagePrivacy &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureMessagePrivacy");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureLastSeenTimes &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureLastSeenTimes");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureBusiness &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureBusiness");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureMessageEffects &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureMessageEffects");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureChecklists &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureChecklists");
}

void to_json(JsonValueScope &jv, const td_api::PremiumLimitType &object) {
  td_api::downcast_call(const_cast<td_api::PremiumLimitType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeSupergroupCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeSupergroupCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypePinnedChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypePinnedChatCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeCreatedPublicChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeCreatedPublicChatCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeSavedAnimationCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeSavedAnimationCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeFavoriteStickerCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeFavoriteStickerCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeChatFolderCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeChatFolderCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeChatFolderChosenChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeChatFolderChosenChatCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypePinnedArchivedChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypePinnedArchivedChatCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypePinnedSavedMessagesTopicCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypePinnedSavedMessagesTopicCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeCaptionLength &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeCaptionLength");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeBioLength &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeBioLength");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeChatFolderInviteLinkCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeChatFolderInviteLinkCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeShareableChatFolderCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeShareableChatFolderCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeActiveStoryCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeActiveStoryCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeWeeklyPostedStoryCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeWeeklyPostedStoryCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeMonthlyPostedStoryCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeMonthlyPostedStoryCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeStoryCaptionLength &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeStoryCaptionLength");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeStorySuggestedReactionAreaCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeStorySuggestedReactionAreaCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeSimilarChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeSimilarChatCount");
}

void to_json(JsonValueScope &jv, const td_api::profileAccentColors &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileAccentColors");
  jo("palette_colors", ToJson(object.palette_colors_));
  jo("background_colors", ToJson(object.background_colors_));
  jo("story_colors", ToJson(object.story_colors_));
}

void to_json(JsonValueScope &jv, const td_api::PushMessageContent &object) {
  td_api::downcast_call(const_cast<td_api::PushMessageContent &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentHidden &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentHidden");
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentAnimation");
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
  jo("caption", object.caption_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentAudio");
  if (object.audio_) {
    jo("audio", ToJson(*object.audio_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentContact &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentContact");
  jo("name", object.name_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentContactRegistered &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentContactRegistered");
  jo("as_premium_account", JsonBool{object.as_premium_account_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentDocument");
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentGame &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentGame");
  jo("title", object.title_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentGameScore &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentGameScore");
  jo("title", object.title_);
  jo("score", object.score_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentInvoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentInvoice");
  jo("price", object.price_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentLocation");
  jo("is_live", JsonBool{object.is_live_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentPaidMedia &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentPaidMedia");
  jo("star_count", object.star_count_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentPhoto");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("caption", object.caption_);
  jo("is_secret", JsonBool{object.is_secret_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentPoll &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentPoll");
  jo("question", object.question_);
  jo("is_regular", JsonBool{object.is_regular_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentPremiumGiftCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentPremiumGiftCode");
  jo("month_count", object.month_count_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentGiveaway &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentGiveaway");
  jo("winner_count", object.winner_count_);
  if (object.prize_) {
    jo("prize", ToJson(*object.prize_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentGift");
  jo("star_count", object.star_count_);
  jo("is_prepaid_upgrade", JsonBool{object.is_prepaid_upgrade_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentUpgradedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentUpgradedGift");
  jo("is_upgrade", JsonBool{object.is_upgrade_});
  jo("is_prepaid_upgrade", JsonBool{object.is_prepaid_upgrade_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentScreenshotTaken &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentScreenshotTaken");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentSticker");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
  jo("emoji", object.emoji_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentStory");
  jo("is_mention", JsonBool{object.is_mention_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentText &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentText");
  jo("text", object.text_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChecklist &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChecklist");
  jo("title", object.title_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVideo");
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
  jo("caption", object.caption_);
  jo("is_secret", JsonBool{object.is_secret_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVideoNote");
  if (object.video_note_) {
    jo("video_note", ToJson(*object.video_note_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVoiceNote");
  if (object.voice_note_) {
    jo("voice_note", ToJson(*object.voice_note_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentBasicGroupChatCreate &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentBasicGroupChatCreate");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVideoChatStarted &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVideoChatStarted");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVideoChatEnded &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVideoChatEnded");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentInviteVideoChatParticipants &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentInviteVideoChatParticipants");
  jo("is_current_user", JsonBool{object.is_current_user_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatAddMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatAddMembers");
  jo("member_name", object.member_name_);
  jo("is_current_user", JsonBool{object.is_current_user_});
  jo("is_returned", JsonBool{object.is_returned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatChangePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatChangePhoto");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatChangeTitle &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatChangeTitle");
  jo("title", object.title_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatSetBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatSetBackground");
  jo("is_same", JsonBool{object.is_same_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatSetTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatSetTheme");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatDeleteMember &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatDeleteMember");
  jo("member_name", object.member_name_);
  jo("is_current_user", JsonBool{object.is_current_user_});
  jo("is_left", JsonBool{object.is_left_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatJoinByLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatJoinByLink");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatJoinByRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatJoinByRequest");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentRecurringPayment &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentRecurringPayment");
  jo("amount", object.amount_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentSuggestProfilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentSuggestProfilePhoto");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentSuggestBirthdate &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentSuggestBirthdate");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentProximityAlertTriggered &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentProximityAlertTriggered");
  jo("distance", object.distance_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChecklistTasksAdded &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChecklistTasksAdded");
  jo("task_count", object.task_count_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChecklistTasksDone &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChecklistTasksDone");
  jo("task_count", object.task_count_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentMessageForwards &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentMessageForwards");
  jo("total_count", object.total_count_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentMediaAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentMediaAlbum");
  jo("total_count", object.total_count_);
  jo("has_photos", JsonBool{object.has_photos_});
  jo("has_videos", JsonBool{object.has_videos_});
  jo("has_audios", JsonBool{object.has_audios_});
  jo("has_documents", JsonBool{object.has_documents_});
}

void to_json(JsonValueScope &jv, const td_api::readDatePrivacySettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "readDatePrivacySettings");
  jo("show_read_date", JsonBool{object.show_read_date_});
}

void to_json(JsonValueScope &jv, const td_api::reportOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportOption");
  jo("id", base64_encode(object.id_));
  jo("text", object.text_);
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTag &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTag");
  if (object.tag_) {
    jo("tag", ToJson(*object.tag_));
  }
  jo("label", object.label_);
  jo("count", object.count_);
}

void to_json(JsonValueScope &jv, const td_api::SentGift &object) {
  td_api::downcast_call(const_cast<td_api::SentGift &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::sentGiftRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "sentGiftRegular");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::sentGiftUpgraded &object) {
  auto jo = jv.enter_object();
  jo("@type", "sentGiftUpgraded");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::sponsoredChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "sponsoredChat");
  jo("unique_id", object.unique_id_);
  jo("chat_id", object.chat_id_);
  jo("sponsor_info", object.sponsor_info_);
  jo("additional_info", object.additional_info_);
}

void to_json(JsonValueScope &jv, const td_api::starPaymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "starPaymentOption");
  jo("currency", object.currency_);
  jo("amount", object.amount_);
  jo("star_count", object.star_count_);
  jo("store_product_id", object.store_product_id_);
  jo("is_additional", JsonBool{object.is_additional_});
}

void to_json(JsonValueScope &jv, const td_api::StarTransactionType &object) {
  td_api::downcast_call(const_cast<td_api::StarTransactionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePremiumBotDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePremiumBotDeposit");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeAppStoreDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeAppStoreDeposit");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGooglePlayDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGooglePlayDeposit");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeFragmentDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeFragmentDeposit");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeUserDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeUserDeposit");
  jo("user_id", object.user_id_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiveawayDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiveawayDeposit");
  jo("chat_id", object.chat_id_);
  jo("giveaway_message_id", object.giveaway_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeFragmentWithdrawal &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeFragmentWithdrawal");
  if (object.withdrawal_state_) {
    jo("withdrawal_state", ToJson(*object.withdrawal_state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeTelegramAdsWithdrawal &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeTelegramAdsWithdrawal");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeTelegramApiUsage &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeTelegramApiUsage");
  jo("request_count", object.request_count_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotPaidMediaPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotPaidMediaPurchase");
  jo("user_id", object.user_id_);
  jo("media", ToJson(object.media_));
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotPaidMediaSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotPaidMediaSale");
  jo("user_id", object.user_id_);
  jo("media", ToJson(object.media_));
  jo("payload", object.payload_);
  if (object.affiliate_) {
    jo("affiliate", ToJson(*object.affiliate_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelPaidMediaPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelPaidMediaPurchase");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("media", ToJson(object.media_));
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelPaidMediaSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelPaidMediaSale");
  jo("user_id", object.user_id_);
  jo("message_id", object.message_id_);
  jo("media", ToJson(object.media_));
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotInvoicePurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotInvoicePurchase");
  jo("user_id", object.user_id_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotInvoiceSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotInvoiceSale");
  jo("user_id", object.user_id_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
  jo("invoice_payload", base64_encode(object.invoice_payload_));
  if (object.affiliate_) {
    jo("affiliate", ToJson(*object.affiliate_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotSubscriptionPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotSubscriptionPurchase");
  jo("user_id", object.user_id_);
  jo("subscription_period", object.subscription_period_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotSubscriptionSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotSubscriptionSale");
  jo("user_id", object.user_id_);
  jo("subscription_period", object.subscription_period_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
  jo("invoice_payload", base64_encode(object.invoice_payload_));
  if (object.affiliate_) {
    jo("affiliate", ToJson(*object.affiliate_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelSubscriptionPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelSubscriptionPurchase");
  jo("chat_id", object.chat_id_);
  jo("subscription_period", object.subscription_period_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelSubscriptionSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelSubscriptionSale");
  jo("user_id", object.user_id_);
  jo("subscription_period", object.subscription_period_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftAuctionBid &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftAuctionBid");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftPurchase");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftTransfer &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftTransfer");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftOriginalDetailsDrop &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftOriginalDetailsDrop");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftSale");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftUpgrade &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftUpgrade");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftUpgradePurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftUpgradePurchase");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeUpgradedGiftPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeUpgradedGiftPurchase");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeUpgradedGiftSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeUpgradedGiftSale");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("commission_per_mille", object.commission_per_mille_);
  if (object.commission_star_amount_) {
    jo("commission_star_amount", ToJson(*object.commission_star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelPaidReactionSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelPaidReactionSend");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelPaidReactionReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelPaidReactionReceive");
  jo("user_id", object.user_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeAffiliateProgramCommission &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeAffiliateProgramCommission");
  jo("chat_id", object.chat_id_);
  jo("commission_per_mille", object.commission_per_mille_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidMessageSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidMessageSend");
  jo("chat_id", object.chat_id_);
  jo("message_count", object.message_count_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidMessageReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidMessageReceive");
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("message_count", object.message_count_);
  jo("commission_per_mille", object.commission_per_mille_);
  if (object.commission_star_amount_) {
    jo("commission_star_amount", ToJson(*object.commission_star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidGroupCallMessageSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidGroupCallMessageSend");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidGroupCallMessageReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidGroupCallMessageReceive");
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("commission_per_mille", object.commission_per_mille_);
  if (object.commission_star_amount_) {
    jo("commission_star_amount", ToJson(*object.commission_star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidGroupCallReactionSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidGroupCallReactionSend");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidGroupCallReactionReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidGroupCallReactionReceive");
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("commission_per_mille", object.commission_per_mille_);
  if (object.commission_star_amount_) {
    jo("commission_star_amount", ToJson(*object.commission_star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeSuggestedPostPaymentSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeSuggestedPostPaymentSend");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeSuggestedPostPaymentReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeSuggestedPostPaymentReceive");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePremiumPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePremiumPurchase");
  jo("user_id", object.user_id_);
  jo("month_count", object.month_count_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBusinessBotTransferSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBusinessBotTransferSend");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBusinessBotTransferReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBusinessBotTransferReceive");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePublicPostSearch &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePublicPostSearch");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeUnsupported &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeUnsupported");
}

void to_json(JsonValueScope &jv, const td_api::stickerSetInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerSetInfo");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("title", object.title_);
  jo("name", object.name_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.thumbnail_outline_) {
    jo("thumbnail_outline", ToJson(*object.thumbnail_outline_));
  }
  jo("is_owned", JsonBool{object.is_owned_});
  jo("is_installed", JsonBool{object.is_installed_});
  jo("is_archived", JsonBool{object.is_archived_});
  jo("is_official", JsonBool{object.is_official_});
  if (object.sticker_type_) {
    jo("sticker_type", ToJson(*object.sticker_type_));
  }
  jo("needs_repainting", JsonBool{object.needs_repainting_});
  jo("is_allowed_as_chat_emoji_status", JsonBool{object.is_allowed_as_chat_emoji_status_});
  jo("is_viewed", JsonBool{object.is_viewed_});
  jo("size", object.size_);
  jo("covers", ToJson(object.covers_));
}

void to_json(JsonValueScope &jv, const td_api::story &object) {
  auto jo = jv.enter_object();
  jo("@type", "story");
  jo("id", object.id_);
  jo("poster_chat_id", object.poster_chat_id_);
  if (object.poster_id_) {
    jo("poster_id", ToJson(*object.poster_id_));
  }
  jo("date", object.date_);
  jo("is_being_posted", JsonBool{object.is_being_posted_});
  jo("is_being_edited", JsonBool{object.is_being_edited_});
  jo("is_edited", JsonBool{object.is_edited_});
  jo("is_posted_to_chat_page", JsonBool{object.is_posted_to_chat_page_});
  jo("is_visible_only_for_self", JsonBool{object.is_visible_only_for_self_});
  jo("can_be_added_to_album", JsonBool{object.can_be_added_to_album_});
  jo("can_be_deleted", JsonBool{object.can_be_deleted_});
  jo("can_be_edited", JsonBool{object.can_be_edited_});
  jo("can_be_forwarded", JsonBool{object.can_be_forwarded_});
  jo("can_be_replied", JsonBool{object.can_be_replied_});
  jo("can_set_privacy_settings", JsonBool{object.can_set_privacy_settings_});
  jo("can_toggle_is_posted_to_chat_page", JsonBool{object.can_toggle_is_posted_to_chat_page_});
  jo("can_get_statistics", JsonBool{object.can_get_statistics_});
  jo("can_get_interactions", JsonBool{object.can_get_interactions_});
  jo("has_expired_viewers", JsonBool{object.has_expired_viewers_});
  if (object.repost_info_) {
    jo("repost_info", ToJson(*object.repost_info_));
  }
  if (object.interaction_info_) {
    jo("interaction_info", ToJson(*object.interaction_info_));
  }
  if (object.chosen_reaction_type_) {
    jo("chosen_reaction_type", ToJson(*object.chosen_reaction_type_));
  }
  if (object.privacy_settings_) {
    jo("privacy_settings", ToJson(*object.privacy_settings_));
  }
  if (object.content_) {
    jo("content", ToJson(*object.content_));
  }
  jo("areas", ToJson(object.areas_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("album_ids", ToJson(object.album_ids_));
}

void to_json(JsonValueScope &jv, const td_api::storyInteractionInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInteractionInfo");
  jo("view_count", object.view_count_);
  jo("forward_count", object.forward_count_);
  jo("reaction_count", object.reaction_count_);
  jo("recent_viewer_user_ids", ToJson(object.recent_viewer_user_ids_));
}

void to_json(JsonValueScope &jv, const td_api::SuggestedAction &object) {
  td_api::downcast_call(const_cast<td_api::SuggestedAction &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionEnableArchiveAndMuteNewChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionEnableArchiveAndMuteNewChats");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionCheckPassword &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionCheckPassword");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionCheckPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionCheckPhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionViewChecksHint &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionViewChecksHint");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionConvertToBroadcastGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionConvertToBroadcastGroup");
  jo("supergroup_id", object.supergroup_id_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSetPassword &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSetPassword");
  jo("authorization_delay", object.authorization_delay_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionUpgradePremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionUpgradePremium");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionRestorePremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionRestorePremium");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSubscribeToAnnualPremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSubscribeToAnnualPremium");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionGiftPremiumForChristmas &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionGiftPremiumForChristmas");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSetBirthdate &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSetBirthdate");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSetProfilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSetProfilePhoto");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionExtendPremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionExtendPremium");
  jo("manage_premium_subscription_url", object.manage_premium_subscription_url_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionExtendStarSubscriptions &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionExtendStarSubscriptions");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionCustom &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionCustom");
  jo("name", object.name_);
  if (object.title_) {
    jo("title", ToJson(*object.title_));
  }
  if (object.description_) {
    jo("description", ToJson(*object.description_));
  }
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSetLoginEmailAddress &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSetLoginEmailAddress");
  jo("can_be_hidden", JsonBool{object.can_be_hidden_});
}

void to_json(JsonValueScope &jv, const td_api::tMeUrls &object) {
  auto jo = jv.enter_object();
  jo("@type", "tMeUrls");
  jo("urls", ToJson(object.urls_));
}

void to_json(JsonValueScope &jv, const td_api::testVectorIntObject &object) {
  auto jo = jv.enter_object();
  jo("@type", "testVectorIntObject");
  jo("value", ToJson(object.value_));
}

void to_json(JsonValueScope &jv, const td_api::thumbnail &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnail");
  if (object.format_) {
    jo("format", ToJson(*object.format_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.file_) {
    jo("file", ToJson(*object.file_));
  }
}

void to_json(JsonValueScope &jv, const td_api::trendingStickerSets &object) {
  auto jo = jv.enter_object();
  jo("@type", "trendingStickerSets");
  jo("total_count", object.total_count_);
  jo("sets", ToJson(object.sets_));
  jo("is_premium", JsonBool{object.is_premium_});
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftBackdropCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftBackdropCount");
  if (object.backdrop_) {
    jo("backdrop", ToJson(*object.backdrop_));
  }
  jo("total_count", object.total_count_);
}

void to_json(JsonValueScope &jv, const td_api::user &object) {
  auto jo = jv.enter_object();
  jo("@type", "user");
  jo("id", object.id_);
  jo("first_name", object.first_name_);
  jo("last_name", object.last_name_);
  if (object.usernames_) {
    jo("usernames", ToJson(*object.usernames_));
  }
  jo("phone_number", object.phone_number_);
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
  if (object.profile_photo_) {
    jo("profile_photo", ToJson(*object.profile_photo_));
  }
  jo("accent_color_id", object.accent_color_id_);
  jo("background_custom_emoji_id", ToJson(JsonInt64{object.background_custom_emoji_id_}));
  if (object.upgraded_gift_colors_) {
    jo("upgraded_gift_colors", ToJson(*object.upgraded_gift_colors_));
  }
  jo("profile_accent_color_id", object.profile_accent_color_id_);
  jo("profile_background_custom_emoji_id", ToJson(JsonInt64{object.profile_background_custom_emoji_id_}));
  if (object.emoji_status_) {
    jo("emoji_status", ToJson(*object.emoji_status_));
  }
  jo("is_contact", JsonBool{object.is_contact_});
  jo("is_mutual_contact", JsonBool{object.is_mutual_contact_});
  jo("is_close_friend", JsonBool{object.is_close_friend_});
  if (object.verification_status_) {
    jo("verification_status", ToJson(*object.verification_status_));
  }
  jo("is_premium", JsonBool{object.is_premium_});
  jo("is_support", JsonBool{object.is_support_});
  if (object.restriction_info_) {
    jo("restriction_info", ToJson(*object.restriction_info_));
  }
  if (object.active_story_state_) {
    jo("active_story_state", ToJson(*object.active_story_state_));
  }
  jo("restricts_new_chats", JsonBool{object.restricts_new_chats_});
  jo("paid_message_star_count", object.paid_message_star_count_);
  jo("have_access", JsonBool{object.have_access_});
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("language_code", object.language_code_);
  jo("added_to_attachment_menu", JsonBool{object.added_to_attachment_menu_});
}

void to_json(JsonValueScope &jv, const td_api::userSupportInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "userSupportInfo");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  jo("author", object.author_);
  jo("date", object.date_);
}

void to_json(JsonValueScope &jv, const td_api::videoChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "videoChat");
  jo("group_call_id", object.group_call_id_);
  jo("has_participants", JsonBool{object.has_participants_});
  if (object.default_participant_id_) {
    jo("default_participant_id", ToJson(*object.default_participant_id_));
  }
}

void to_json(JsonValueScope &jv, const td_api::webPageInstantView &object) {
  auto jo = jv.enter_object();
  jo("@type", "webPageInstantView");
  jo("page_blocks", ToJson(object.page_blocks_));
  jo("view_count", object.view_count_);
  jo("version", object.version_);
  jo("is_rtl", JsonBool{object.is_rtl_});
  jo("is_full", JsonBool{object.is_full_});
  if (object.feedback_link_) {
    jo("feedback_link", ToJson(*object.feedback_link_));
  }
}

}  // namespace td_api
}  // namespace td
