#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::BotCommandScope *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"botCommandScopeDefault", 795652779},
    {"botCommandScopeAllPrivateChats", -344889543},
    {"botCommandScopeAllGroupChats", -981088162},
    {"botCommandScopeAllChatAdministrators", 1998329169},
    {"botCommandScopeChat", -430234971},
    {"botCommandScopeChatAdministrators", 1119682126},
    {"botCommandScopeChatMember", -211380494}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ChatMembersFilter *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"chatMembersFilterContacts", 1774485671},
    {"chatMembersFilterAdministrators", -1266893796},
    {"chatMembersFilterMembers", 670504342},
    {"chatMembersFilterMention", 1932296772},
    {"chatMembersFilterRestricted", 1256282813},
    {"chatMembersFilterBanned", -1863102648},
    {"chatMembersFilterBots", -1422567288}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::GiftForResaleOrder *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"giftForResaleOrderPrice", 1371740258},
    {"giftForResaleOrderPriceChangeDate", -1694144054},
    {"giftForResaleOrderNumber", -1301157632}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputCredentials *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputCredentialsSaved", -2034385364},
    {"inputCredentialsNew", -829689558},
    {"inputCredentialsApplePay", -1246570799},
    {"inputCredentialsGooglePay", 844384100}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputPassportElementErrorSource *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputPassportElementErrorSourceUnspecified", 267230319},
    {"inputPassportElementErrorSourceDataField", -426795002},
    {"inputPassportElementErrorSourceFrontSide", 588023741},
    {"inputPassportElementErrorSourceReverseSide", 413072891},
    {"inputPassportElementErrorSourceSelfie", -773575528},
    {"inputPassportElementErrorSourceTranslationFile", 505842299},
    {"inputPassportElementErrorSourceTranslationFiles", -527254048},
    {"inputPassportElementErrorSourceFile", -298492469},
    {"inputPassportElementErrorSourceFiles", -2008541640}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::MessageSchedulingState *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"messageSchedulingStateSendAtDate", 1505903015},
    {"messageSchedulingStateSendWhenOnline", 2092947464},
    {"messageSchedulingStateSendWhenVideoProcessed", 2101578734}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PaidReactionType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"paidReactionTypeRegular", -1199187333},
    {"paidReactionTypeAnonymous", 47892621},
    {"paidReactionTypeChat", -675782044}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ProxyType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"proxyTypeSocks5", -890027341},
    {"proxyTypeHttp", -1547188361},
    {"proxyTypeMtproto", -1964826627}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::StickerFormat *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"stickerFormatWebp", -2123043040},
    {"stickerFormatTgs", 1614588662},
    {"stickerFormatWebm", -2070162097}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::TargetChat *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"targetChatCurrent", -416689904},
    {"targetChatChosen", -1392978522},
    {"targetChatInternalLink", -579301408}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::WebAppOpenMode *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"webAppOpenModeCompact", 1711603675},
    {"webAppOpenModeFullSize", 189320513},
    {"webAppOpenModeFullScreen", 1871315357}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::affiliateTypeBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::backgroundFillGradient &to, JsonObject &from) {
  TRY_STATUS(from_json(to.top_color_, from.extract_field("top_color")));
  TRY_STATUS(from_json(to.bottom_color_, from.extract_field("bottom_color")));
  TRY_STATUS(from_json(to.rotation_angle_, from.extract_field("rotation_angle")));
  return Status::OK();
}

Status from_json(td_api::botCommand &to, JsonObject &from) {
  TRY_STATUS(from_json(to.command_, from.extract_field("command")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  return Status::OK();
}

Status from_json(td_api::businessAwayMessageScheduleAlways &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessFeatureGreetingMessage &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.address_, from.extract_field("address")));
  return Status::OK();
}

Status from_json(td_api::callProblemSilentRemote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionRecordingVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionStartPlayingGame &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatFolder &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.icon_, from.extract_field("icon")));
  TRY_STATUS(from_json(to.color_id_, from.extract_field("color_id")));
  TRY_STATUS(from_json(to.is_shareable_, from.extract_field("is_shareable")));
  TRY_STATUS(from_json(to.pinned_chat_ids_, from.extract_field("pinned_chat_ids")));
  TRY_STATUS(from_json(to.included_chat_ids_, from.extract_field("included_chat_ids")));
  TRY_STATUS(from_json(to.excluded_chat_ids_, from.extract_field("excluded_chat_ids")));
  TRY_STATUS(from_json(to.exclude_muted_, from.extract_field("exclude_muted")));
  TRY_STATUS(from_json(to.exclude_read_, from.extract_field("exclude_read")));
  TRY_STATUS(from_json(to.exclude_archived_, from.extract_field("exclude_archived")));
  TRY_STATUS(from_json(to.include_contacts_, from.extract_field("include_contacts")));
  TRY_STATUS(from_json(to.include_non_contacts_, from.extract_field("include_non_contacts")));
  TRY_STATUS(from_json(to.include_bots_, from.extract_field("include_bots")));
  TRY_STATUS(from_json(to.include_groups_, from.extract_field("include_groups")));
  TRY_STATUS(from_json(to.include_channels_, from.extract_field("include_channels")));
  return Status::OK();
}

Status from_json(td_api::chatMemberStatusCreator &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_title_, from.extract_field("custom_title")));
  TRY_STATUS(from_json(to.is_anonymous_, from.extract_field("is_anonymous")));
  TRY_STATUS(from_json(to.is_member_, from.extract_field("is_member")));
  return Status::OK();
}

Status from_json(td_api::chatMembersFilterMention &to, JsonObject &from) {
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  return Status::OK();
}

Status from_json(td_api::collectibleItemTypeUsername &to, JsonObject &from) {
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenMicrosoftPushVoIP &to, JsonObject &from) {
  TRY_STATUS(from_json(to.channel_uri_, from.extract_field("channel_uri")));
  return Status::OK();
}

Status from_json(td_api::emailAddressAuthenticationAppleId &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::error &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  TRY_STATUS(from_json(to.message_, from.extract_field("message")));
  return Status::OK();
}

Status from_json(td_api::fileTypeSecret &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeUnknown &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::forumTopicIcon &to, JsonObject &from) {
  TRY_STATUS(from_json(to.color_, from.extract_field("color")));
  TRY_STATUS(from_json(to.custom_emoji_id_, from.extract_field("custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::groupCallDataChannelScreenSharing &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::inlineQueryResultsButtonTypeStartBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.parameter_, from.extract_field("parameter")));
  return Status::OK();
}

Status from_json(td_api::inputChatPhotoAnimation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.animation_, from.extract_field("animation")));
  TRY_STATUS(from_json(to.main_frame_timestamp_, from.extract_field("main_frame_timestamp")));
  return Status::OK();
}

Status from_json(td_api::inputCredentialsGooglePay &to, JsonObject &from) {
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultArticle &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.thumbnail_width_, from.extract_field("thumbnail_width")));
  TRY_STATUS(from_json(to.thumbnail_height_, from.extract_field("thumbnail_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultVideo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.video_url_, from.extract_field("video_url")));
  TRY_STATUS(from_json(to.mime_type_, from.extract_field("mime_type")));
  TRY_STATUS(from_json(to.video_width_, from.extract_field("video_width")));
  TRY_STATUS(from_json(to.video_height_, from.extract_field("video_height")));
  TRY_STATUS(from_json(to.video_duration_, from.extract_field("video_duration")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputMessagePaidMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  TRY_STATUS(from_json(to.paid_media_, from.extract_field("paid_media")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.show_caption_above_media_, from.extract_field("show_caption_above_media")));
  TRY_STATUS(from_json(to.payload_, from.extract_field("payload")));
  return Status::OK();
}

Status from_json(td_api::inputMessageDice &to, JsonObject &from) {
  TRY_STATUS(from_json(to.emoji_, from.extract_field("emoji")));
  TRY_STATUS(from_json(to.clear_draft_, from.extract_field("clear_draft")));
  return Status::OK();
}

Status from_json(td_api::inputMessageReplyToStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.address_, from.extract_field("address")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceUnspecified &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.element_hash_, from.extract_field("element_hash")));
  return Status::OK();
}

Status from_json(td_api::inputPersonalDocument &to, JsonObject &from) {
  TRY_STATUS(from_json(to.files_, from.extract_field("files")));
  TRY_STATUS(from_json(to.translation_, from.extract_field("translation")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypeWeather &to, JsonObject &from) {
  TRY_STATUS(from_json(to.temperature_, from.extract_field("temperature")));
  TRY_STATUS(from_json(to.emoji_, from.extract_field("emoji")));
  TRY_STATUS(from_json(to.background_color_, from.extract_field("background_color")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeAttachmentMenuBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.target_chat_, from.extract_field("target_chat")));
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeChatAffiliateProgram &to, JsonObject &from) {
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  TRY_STATUS(from_json(to.referrer_, from.extract_field("referrer")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeGiftAuction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.auction_id_, from.extract_field("auction_id")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeMainWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.start_parameter_, from.extract_field("start_parameter")));
  TRY_STATUS(from_json(to.mode_, from.extract_field("mode")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePremiumFeatures &to, JsonObject &from) {
  TRY_STATUS(from_json(to.referrer_, from.extract_field("referrer")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_set_name_, from.extract_field("sticker_set_name")));
  TRY_STATUS(from_json(to.expect_custom_emoji_, from.extract_field("expect_custom_emoji")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeUserToken &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::jsonValueArray &to, JsonObject &from) {
  TRY_STATUS(from_json(to.values_, from.extract_field("values")));
  return Status::OK();
}

Status from_json(td_api::keyboardButtonTypeWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::locationAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.country_code_, from.extract_field("country_code")));
  TRY_STATUS(from_json(to.state_, from.extract_field("state")));
  TRY_STATUS(from_json(to.city_, from.extract_field("city")));
  TRY_STATUS(from_json(to.street_, from.extract_field("street")));
  return Status::OK();
}

Status from_json(td_api::messageAutoDeleteTime &to, JsonObject &from) {
  TRY_STATUS(from_json(to.time_, from.extract_field("time")));
  return Status::OK();
}

Status from_json(td_api::messageSenderChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::messageSourceNotification &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::networkTypeNone &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::optionValueBoolean &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::passportElementTypePassport &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypeTemporaryRegistration &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::pollTypeQuiz &to, JsonObject &from) {
  TRY_STATUS(from_json(to.correct_option_id_, from.extract_field("correct_option_id")));
  TRY_STATUS(from_json(to.explanation_, from.extract_field("explanation")));
  return Status::OK();
}

Status from_json(td_api::premiumFeatureAdvancedChatManagement &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureAccentColor &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypePinnedChatCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeBioLength &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumSourceLimitExceeded &to, JsonObject &from) {
  TRY_STATUS(from_json(to.limit_type_, from.extract_field("limit_type")));
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeatureCustomExpirationDuration &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabMusic &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::reactionNotificationSourceNone &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::replyMarkupShowKeyboard &to, JsonObject &from) {
  TRY_STATUS(from_json(to.rows_, from.extract_field("rows")));
  TRY_STATUS(from_json(to.is_persistent_, from.extract_field("is_persistent")));
  TRY_STATUS(from_json(to.resize_keyboard_, from.extract_field("resize_keyboard")));
  TRY_STATUS(from_json(to.one_time_, from.extract_field("one_time")));
  TRY_STATUS(from_json(to.is_personal_, from.extract_field("is_personal")));
  TRY_STATUS(from_json(to.input_field_placeholder_, from.extract_field("input_field_placeholder")));
  return Status::OK();
}

Status from_json(td_api::reportReasonIllegalDrugs &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesChatTypeFilterChannel &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterUrl &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::shippingOption &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.price_parts_, from.extract_field("price_parts")));
  return Status::OK();
}

Status from_json(td_api::storePaymentPurposePremiumGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::storyFullId &to, JsonObject &from) {
  TRY_STATUS(from_json(to.poster_chat_id_, from.extract_field("poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionCheckPhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionSetProfilePhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::supergroupMembersFilterAdministrators &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::targetChatTypes &to, JsonObject &from) {
  TRY_STATUS(from_json(to.allow_user_chats_, from.extract_field("allow_user_chats")));
  TRY_STATUS(from_json(to.allow_bot_chats_, from.extract_field("allow_bot_chats")));
  TRY_STATUS(from_json(to.allow_group_chats_, from.extract_field("allow_group_chats")));
  TRY_STATUS(from_json(to.allow_channel_chats_, from.extract_field("allow_channel_chats")));
  return Status::OK();
}

Status from_json(td_api::testString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypeBankCardNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypeBlockQuote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::topChatCategoryUsers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::transactionDirectionOutgoing &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowBio &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAllowUnpaidMessages &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleRestrictBots &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::acceptCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json(to.protocol_, from.extract_field("protocol")));
  return Status::OK();
}

Status from_json(td_api::addContact &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.contact_, from.extract_field("contact")));
  TRY_STATUS(from_json(to.share_phone_number_, from.extract_field("share_phone_number")));
  return Status::OK();
}

Status from_json(td_api::addOffer &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.options_, from.extract_field("options")));
  return Status::OK();
}

Status from_json(td_api::addRecentlyFoundChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::answerInlineQuery &to, JsonObject &from) {
  TRY_STATUS(from_json(to.inline_query_id_, from.extract_field("inline_query_id")));
  TRY_STATUS(from_json(to.is_personal_, from.extract_field("is_personal")));
  TRY_STATUS(from_json(to.button_, from.extract_field("button")));
  TRY_STATUS(from_json(to.results_, from.extract_field("results")));
  TRY_STATUS(from_json(to.cache_time_, from.extract_field("cache_time")));
  TRY_STATUS(from_json(to.next_offset_, from.extract_field("next_offset")));
  return Status::OK();
}

Status from_json(td_api::blockMessageSenderFromReplies &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.delete_message_, from.extract_field("delete_message")));
  TRY_STATUS(from_json(to.delete_all_messages_, from.extract_field("delete_all_messages")));
  TRY_STATUS(from_json(to.report_spam_, from.extract_field("report_spam")));
  return Status::OK();
}

Status from_json(td_api::cancelDownloadFile &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  TRY_STATUS(from_json(to.only_if_pending_, from.extract_field("only_if_pending")));
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationPassword &to, JsonObject &from) {
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::checkPasswordRecoveryCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.recovery_code_, from.extract_field("recovery_code")));
  return Status::OK();
}

Status from_json(td_api::clearAutosaveSettingsExceptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::clickPremiumSubscriptionButton &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::commitPendingPaidMessageReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::createChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.expiration_date_, from.extract_field("expiration_date")));
  TRY_STATUS(from_json(to.member_limit_, from.extract_field("member_limit")));
  TRY_STATUS(from_json(to.creates_join_request_, from.extract_field("creates_join_request")));
  return Status::OK();
}

Status from_json(td_api::createNewSupergroupChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.is_forum_, from.extract_field("is_forum")));
  TRY_STATUS(from_json(to.is_channel_, from.extract_field("is_channel")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.message_auto_delete_time_, from.extract_field("message_auto_delete_time")));
  TRY_STATUS(from_json(to.for_import_, from.extract_field("for_import")));
  return Status::OK();
}

Status from_json(td_api::decryptGroupCallData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.participant_id_, from.extract_field("participant_id")));
  TRY_STATUS(from_json(to.data_channel_, from.extract_field("data_channel")));
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::deleteChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::deleteDefaultBackground &to, JsonObject &from) {
  TRY_STATUS(from_json(to.for_dark_theme_, from.extract_field("for_dark_theme")));
  return Status::OK();
}

Status from_json(td_api::deleteMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.revoke_, from.extract_field("revoke")));
  return Status::OK();
}

Status from_json(td_api::deleteSavedOrderInfo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::disconnectAllWebsites &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::editBusinessMessageMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::editForumTopic &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.edit_icon_custom_emoji_, from.extract_field("edit_icon_custom_emoji")));
  TRY_STATUS(from_json(to.icon_custom_emoji_id_, from.extract_field("icon_custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::editMessageMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::editUserStarSubscription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.telegram_payment_charge_id_, from.extract_field("telegram_payment_charge_id")));
  TRY_STATUS(from_json(to.is_canceled_, from.extract_field("is_canceled")));
  return Status::OK();
}

Status from_json(td_api::getActiveSessions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getAttachmentMenuBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::getBasicGroupFullInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.basic_group_id_, from.extract_field("basic_group_id")));
  return Status::OK();
}

Status from_json(td_api::getBusinessAccountStarAmount &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  return Status::OK();
}

Status from_json(td_api::getChatActiveStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatBoostStatus &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.only_local_, from.extract_field("only_local")));
  return Status::OK();
}

Status from_json(td_api::getChatMessageCalendar &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.filter_, from.extract_field("filter")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  return Status::OK();
}

Status from_json(td_api::getChatScheduledMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatsForChatFolderInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::getCountries &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDeepLinkInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::getDirectMessagesChatTopicMessageByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.date_, from.extract_field("date")));
  return Status::OK();
}

Status from_json(td_api::getFile &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  return Status::OK();
}

Status from_json(td_api::getGameHighScores &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getGroupCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getInstalledBackgrounds &to, JsonObject &from) {
  TRY_STATUS(from_json(to.for_dark_theme_, from.extract_field("for_dark_theme")));
  return Status::OK();
}

Status from_json(td_api::getLanguagePackStrings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  TRY_STATUS(from_json(to.keys_, from.extract_field("keys")));
  return Status::OK();
}

Status from_json(td_api::getLogTags &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getMessageLinkInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::getMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  return Status::OK();
}

Status from_json(td_api::getPassportElement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getPremiumGiftPaymentOptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getProxyLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.proxy_id_, from.extract_field("proxy_id")));
  return Status::OK();
}

Status from_json(td_api::getRecentlyOpenedChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getSavedMessagesTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getStarAdAccountUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  return Status::OK();
}

Status from_json(td_api::getStickerEmojis &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::getStoryAvailableReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.row_size_, from.extract_field("row_size")));
  return Status::OK();
}

Status from_json(td_api::getSupergroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  return Status::OK();
}

Status from_json(td_api::getThemedEmojiStatuses &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUpgradedGiftValueInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::getUserSupportInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::giftPremiumWithStars &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  TRY_STATUS(from_json(to.month_count_, from.extract_field("month_count")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::isProfileAudio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  return Status::OK();
}

Status from_json(td_api::loadActiveStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_list_, from.extract_field("story_list")));
  return Status::OK();
}

Status from_json(td_api::openBotSimilarBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.opened_bot_user_id_, from.extract_field("opened_bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::parseMarkdown &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::processChatJoinRequests &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.approve_, from.extract_field("approve")));
  return Status::OK();
}

Status from_json(td_api::readChatList &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  return Status::OK();
}

Status from_json(td_api::removeAllFilesFromDownloads &to, JsonObject &from) {
  TRY_STATUS(from_json(to.only_active_, from.extract_field("only_active")));
  TRY_STATUS(from_json(to.only_completed_, from.extract_field("only_completed")));
  TRY_STATUS(from_json(to.delete_from_cache_, from.extract_field("delete_from_cache")));
  return Status::OK();
}

Status from_json(td_api::removeMessageSenderBotVerification &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.verified_id_, from.extract_field("verified_id")));
  return Status::OK();
}

Status from_json(td_api::removeRecentlyFoundChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::reorderBotMediaPreviews &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.file_ids_, from.extract_field("file_ids")));
  return Status::OK();
}

Status from_json(td_api::replaceLiveStoryRtmpUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::reportPhoneNumberCodeMissing &to, JsonObject &from) {
  TRY_STATUS(from_json(to.mobile_network_code_, from.extract_field("mobile_network_code")));
  return Status::OK();
}

Status from_json(td_api::resendAuthenticationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reason_, from.extract_field("reason")));
  return Status::OK();
}

Status from_json(td_api::resetNetworkStatistics &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchCallMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.only_missed_, from.extract_field("only_missed")));
  return Status::OK();
}

Status from_json(td_api::searchFileDownloads &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.only_active_, from.extract_field("only_active")));
  TRY_STATUS(from_json(to.only_completed_, from.extract_field("only_completed")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchPublicPosts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::searchStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::sendBusinessMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.reply_to_, from.extract_field("reply_to")));
  TRY_STATUS(from_json(to.disable_notification_, from.extract_field("disable_notification")));
  TRY_STATUS(from_json(to.protect_content_, from.extract_field("protect_content")));
  TRY_STATUS(from_json(to.effect_id_, from.extract_field("effect_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::sendGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_id_, from.extract_field("gift_id")));
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.is_private_, from.extract_field("is_private")));
  TRY_STATUS(from_json(to.pay_for_upgrade_, from.extract_field("pay_for_upgrade")));
  return Status::OK();
}

Status from_json(td_api::sendQuickReplyShortcutMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.shortcut_id_, from.extract_field("shortcut_id")));
  TRY_STATUS(from_json(to.sending_id_, from.extract_field("sending_id")));
  return Status::OK();
}

Status from_json(td_api::setArchiveChatListSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setBotInfoShortDescription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.short_description_, from.extract_field("short_description")));
  return Status::OK();
}

Status from_json(td_api::setBusinessAwayMessageSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.away_message_settings_, from.extract_field("away_message_settings")));
  return Status::OK();
}

Status from_json(td_api::setChatAffiliateProgram &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  return Status::OK();
}

Status from_json(td_api::setChatLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  return Status::OK();
}

Status from_json(td_api::setChatProfileAccentColor &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.profile_accent_color_id_, from.extract_field("profile_accent_color_id")));
  TRY_STATUS(from_json(to.profile_background_custom_emoji_id_, from.extract_field("profile_background_custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::setDatabaseEncryptionKey &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.new_encryption_key_, from.extract_field("new_encryption_key")));
  return Status::OK();
}

Status from_json(td_api::setForumTopicNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  TRY_STATUS(from_json(to.notification_settings_, from.extract_field("notification_settings")));
  return Status::OK();
}

Status from_json(td_api::setInlineGameScore &to, JsonObject &from) {
  TRY_STATUS(from_json(to.inline_message_id_, from.extract_field("inline_message_id")));
  TRY_STATUS(from_json(to.edit_message_, from.extract_field("edit_message")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.score_, from.extract_field("score")));
  TRY_STATUS(from_json(to.force_, from.extract_field("force")));
  return Status::OK();
}

Status from_json(td_api::setMessageReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reaction_types_, from.extract_field("reaction_types")));
  TRY_STATUS(from_json(to.is_big_, from.extract_field("is_big")));
  return Status::OK();
}

Status from_json(td_api::setPassportElementErrors &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.errors_, from.extract_field("errors")));
  return Status::OK();
}

Status from_json(td_api::setProfileAudioPosition &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  TRY_STATUS(from_json(to.after_file_id_, from.extract_field("after_file_id")));
  return Status::OK();
}

Status from_json(td_api::setStickerKeywords &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  TRY_STATUS(from_json(to.keywords_, from.extract_field("keywords")));
  return Status::OK();
}

Status from_json(td_api::setSupergroupMainProfileTab &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.main_profile_tab_, from.extract_field("main_profile_tab")));
  return Status::OK();
}

Status from_json(td_api::setUserPrivacySettingRules &to, JsonObject &from) {
  TRY_STATUS(from_json(to.setting_, from.extract_field("setting")));
  TRY_STATUS(from_json(to.rules_, from.extract_field("rules")));
  return Status::OK();
}

Status from_json(td_api::startGroupCallScreenSharing &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.audio_source_id_, from.extract_field("audio_source_id")));
  TRY_STATUS(from_json(to.payload_, from.extract_field("payload")));
  return Status::OK();
}

Status from_json(td_api::terminateSession &to, JsonObject &from) {
  TRY_STATUS(from_json(to.session_id_, from.extract_field("session_id")));
  return Status::OK();
}

Status from_json(td_api::testNetwork &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::toggleBusinessConnectedBotChatIsPaused &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_paused_, from.extract_field("is_paused")));
  return Status::OK();
}

Status from_json(td_api::toggleDirectMessagesChatTopicCanSendUnpaidMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.can_send_unpaid_messages_, from.extract_field("can_send_unpaid_messages")));
  TRY_STATUS(from_json(to.refund_payments_, from.extract_field("refund_payments")));
  return Status::OK();
}

Status from_json(td_api::toggleGroupCallParticipantIsHandRaised &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.participant_id_, from.extract_field("participant_id")));
  TRY_STATUS(from_json(to.is_hand_raised_, from.extract_field("is_hand_raised")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupHasAggressiveAntiSpamEnabled &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.has_aggressive_anti_spam_enabled_, from.extract_field("has_aggressive_anti_spam_enabled")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupUsernameIsActive &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  TRY_STATUS(from_json(to.is_active_, from.extract_field("is_active")));
  return Status::OK();
}

Status from_json(td_api::unpinAllChatMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::viewPremiumFeature &to, JsonObject &from) {
  TRY_STATUS(from_json(to.feature_, from.extract_field("feature")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::ActiveStoryState &object) {
  td_api::downcast_call(const_cast<td_api::ActiveStoryState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::activeStoryStateLive &object) {
  auto jo = jv.enter_object();
  jo("@type", "activeStoryStateLive");
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::activeStoryStateUnread &object) {
  auto jo = jv.enter_object();
  jo("@type", "activeStoryStateUnread");
}

void to_json(JsonValueScope &jv, const td_api::activeStoryStateRead &object) {
  auto jo = jv.enter_object();
  jo("@type", "activeStoryStateRead");
}

void to_json(JsonValueScope &jv, const td_api::alternativeVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "alternativeVideo");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("width", object.width_);
  jo("height", object.height_);
  jo("codec", object.codec_);
  if (object.hls_file_) {
    jo("hls_file", ToJson(*object.hls_file_));
  }
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
}

void to_json(JsonValueScope &jv, const td_api::AuctionState &object) {
  td_api::downcast_call(const_cast<td_api::AuctionState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::auctionStateActive &object) {
  auto jo = jv.enter_object();
  jo("@type", "auctionStateActive");
  jo("start_date", object.start_date_);
  jo("end_date", object.end_date_);
  jo("min_bid", object.min_bid_);
  jo("bid_levels", ToJson(object.bid_levels_));
  jo("top_bidder_user_ids", ToJson(object.top_bidder_user_ids_));
  jo("current_round_end_date", object.current_round_end_date_);
  jo("current_round_number", object.current_round_number_);
  jo("total_round_count", object.total_round_count_);
  jo("left_item_count", object.left_item_count_);
  jo("acquired_item_count", object.acquired_item_count_);
  if (object.user_bid_) {
    jo("user_bid", ToJson(*object.user_bid_));
  }
}

void to_json(JsonValueScope &jv, const td_api::auctionStateFinished &object) {
  auto jo = jv.enter_object();
  jo("@type", "auctionStateFinished");
  jo("start_date", object.start_date_);
  jo("end_date", object.end_date_);
  jo("average_price", object.average_price_);
  jo("acquired_item_count", object.acquired_item_count_);
}

void to_json(JsonValueScope &jv, const td_api::autosaveSettingsException &object) {
  auto jo = jv.enter_object();
  jo("@type", "autosaveSettingsException");
  jo("chat_id", object.chat_id_);
  if (object.settings_) {
    jo("settings", ToJson(*object.settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::backgrounds &object) {
  auto jo = jv.enter_object();
  jo("@type", "backgrounds");
  jo("backgrounds", ToJson(object.backgrounds_));
}

void to_json(JsonValueScope &jv, const td_api::botInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "botInfo");
  jo("short_description", object.short_description_);
  jo("description", object.description_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
  if (object.menu_button_) {
    jo("menu_button", ToJson(*object.menu_button_));
  }
  jo("commands", ToJson(object.commands_));
  jo("privacy_policy_url", object.privacy_policy_url_);
  if (object.default_group_administrator_rights_) {
    jo("default_group_administrator_rights", ToJson(*object.default_group_administrator_rights_));
  }
  if (object.default_channel_administrator_rights_) {
    jo("default_channel_administrator_rights", ToJson(*object.default_channel_administrator_rights_));
  }
  if (object.affiliate_program_) {
    jo("affiliate_program", ToJson(*object.affiliate_program_));
  }
  jo("web_app_background_light_color", object.web_app_background_light_color_);
  jo("web_app_background_dark_color", object.web_app_background_dark_color_);
  jo("web_app_header_light_color", object.web_app_header_light_color_);
  jo("web_app_header_dark_color", object.web_app_header_dark_color_);
  if (object.verification_parameters_) {
    jo("verification_parameters", ToJson(*object.verification_parameters_));
  }
  jo("can_get_revenue_statistics", JsonBool{object.can_get_revenue_statistics_});
  jo("can_manage_emoji_status", JsonBool{object.can_manage_emoji_status_});
  jo("has_media_previews", JsonBool{object.has_media_previews_});
  if (object.edit_commands_link_) {
    jo("edit_commands_link", ToJson(*object.edit_commands_link_));
  }
  if (object.edit_description_link_) {
    jo("edit_description_link", ToJson(*object.edit_description_link_));
  }
  if (object.edit_description_media_link_) {
    jo("edit_description_media_link", ToJson(*object.edit_description_media_link_));
  }
  if (object.edit_settings_link_) {
    jo("edit_settings_link", ToJson(*object.edit_settings_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::BusinessAwayMessageSchedule &object) {
  td_api::downcast_call(const_cast<td_api::BusinessAwayMessageSchedule &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::businessAwayMessageScheduleAlways &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessAwayMessageScheduleAlways");
}

void to_json(JsonValueScope &jv, const td_api::businessAwayMessageScheduleOutsideOfOpeningHours &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessAwayMessageScheduleOutsideOfOpeningHours");
}

void to_json(JsonValueScope &jv, const td_api::businessAwayMessageScheduleCustom &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessAwayMessageScheduleCustom");
  jo("start_date", object.start_date_);
  jo("end_date", object.end_date_);
}

void to_json(JsonValueScope &jv, const td_api::BusinessFeature &object) {
  td_api::downcast_call(const_cast<td_api::BusinessFeature &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureLocation");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureOpeningHours &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureOpeningHours");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureQuickReplies &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureQuickReplies");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureGreetingMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureGreetingMessage");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureAwayMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureAwayMessage");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureAccountLinks &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureAccountLinks");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureStartPage &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureStartPage");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureBots &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureBots");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureEmojiStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureEmojiStatus");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureChatFolderTags &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureChatFolderTags");
}

void to_json(JsonValueScope &jv, const td_api::businessFeatureUpgradedStories &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatureUpgradedStories");
}

void to_json(JsonValueScope &jv, const td_api::businessOpeningHoursInterval &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessOpeningHoursInterval");
  jo("start_minute", object.start_minute_);
  jo("end_minute", object.end_minute_);
}

void to_json(JsonValueScope &jv, const td_api::CallState &object) {
  td_api::downcast_call(const_cast<td_api::CallState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::callStatePending &object) {
  auto jo = jv.enter_object();
  jo("@type", "callStatePending");
  jo("is_created", JsonBool{object.is_created_});
  jo("is_received", JsonBool{object.is_received_});
}

void to_json(JsonValueScope &jv, const td_api::callStateExchangingKeys &object) {
  auto jo = jv.enter_object();
  jo("@type", "callStateExchangingKeys");
}

void to_json(JsonValueScope &jv, const td_api::callStateReady &object) {
  auto jo = jv.enter_object();
  jo("@type", "callStateReady");
  if (object.protocol_) {
    jo("protocol", ToJson(*object.protocol_));
  }
  jo("servers", ToJson(object.servers_));
  jo("config", object.config_);
  jo("encryption_key", base64_encode(object.encryption_key_));
  jo("emojis", ToJson(object.emojis_));
  jo("allow_p2p", JsonBool{object.allow_p2p_});
  jo("is_group_call_supported", JsonBool{object.is_group_call_supported_});
  jo("custom_parameters", object.custom_parameters_);
}

void to_json(JsonValueScope &jv, const td_api::callStateHangingUp &object) {
  auto jo = jv.enter_object();
  jo("@type", "callStateHangingUp");
}

void to_json(JsonValueScope &jv, const td_api::callStateDiscarded &object) {
  auto jo = jv.enter_object();
  jo("@type", "callStateDiscarded");
  if (object.reason_) {
    jo("reason", ToJson(*object.reason_));
  }
  jo("need_rating", JsonBool{object.need_rating_});
  jo("need_debug_information", JsonBool{object.need_debug_information_});
  jo("need_log", JsonBool{object.need_log_});
}

void to_json(JsonValueScope &jv, const td_api::callStateError &object) {
  auto jo = jv.enter_object();
  jo("@type", "callStateError");
  if (object.error_) {
    jo("error", ToJson(*object.error_));
  }
}

void to_json(JsonValueScope &jv, const td_api::ChatActionBar &object) {
  td_api::downcast_call(const_cast<td_api::ChatActionBar &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatActionBarReportSpam &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionBarReportSpam");
  jo("can_unarchive", JsonBool{object.can_unarchive_});
}

void to_json(JsonValueScope &jv, const td_api::chatActionBarInviteMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionBarInviteMembers");
}

void to_json(JsonValueScope &jv, const td_api::chatActionBarReportAddBlock &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionBarReportAddBlock");
  jo("can_unarchive", JsonBool{object.can_unarchive_});
  if (object.account_info_) {
    jo("account_info", ToJson(*object.account_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatActionBarAddContact &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionBarAddContact");
}

void to_json(JsonValueScope &jv, const td_api::chatActionBarSharePhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionBarSharePhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::chatActionBarJoinRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActionBarJoinRequest");
  jo("title", object.title_);
  jo("is_channel", JsonBool{object.is_channel_});
  jo("request_date", object.request_date_);
}

void to_json(JsonValueScope &jv, const td_api::chatBoostLevelFeatures &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostLevelFeatures");
  jo("level", object.level_);
  jo("story_per_day_count", object.story_per_day_count_);
  jo("custom_emoji_reaction_count", object.custom_emoji_reaction_count_);
  jo("title_color_count", object.title_color_count_);
  jo("profile_accent_color_count", object.profile_accent_color_count_);
  jo("can_set_profile_background_custom_emoji", JsonBool{object.can_set_profile_background_custom_emoji_});
  jo("accent_color_count", object.accent_color_count_);
  jo("can_set_background_custom_emoji", JsonBool{object.can_set_background_custom_emoji_});
  jo("can_set_emoji_status", JsonBool{object.can_set_emoji_status_});
  jo("chat_theme_background_count", object.chat_theme_background_count_);
  jo("can_set_custom_background", JsonBool{object.can_set_custom_background_});
  jo("can_set_custom_emoji_sticker_set", JsonBool{object.can_set_custom_emoji_sticker_set_});
  jo("can_enable_automatic_translation", JsonBool{object.can_enable_automatic_translation_});
  jo("can_recognize_speech", JsonBool{object.can_recognize_speech_});
  jo("can_disable_sponsored_messages", JsonBool{object.can_disable_sponsored_messages_});
}

void to_json(JsonValueScope &jv, const td_api::chatEvents &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEvents");
  jo("events", ToJson(object.events_));
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLinkCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLinkCount");
  jo("user_id", object.user_id_);
  jo("invite_link_count", object.invite_link_count_);
  jo("revoked_invite_link_count", object.revoked_invite_link_count_);
}

void to_json(JsonValueScope &jv, const td_api::chatJoinRequestsInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatJoinRequestsInfo");
  jo("total_count", object.total_count_);
  jo("user_ids", ToJson(object.user_ids_));
}

void to_json(JsonValueScope &jv, const td_api::chatNotificationSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatNotificationSettings");
  jo("use_default_mute_for", JsonBool{object.use_default_mute_for_});
  jo("mute_for", object.mute_for_);
  jo("use_default_sound", JsonBool{object.use_default_sound_});
  jo("sound_id", ToJson(JsonInt64{object.sound_id_}));
  jo("use_default_show_preview", JsonBool{object.use_default_show_preview_});
  jo("show_preview", JsonBool{object.show_preview_});
  jo("use_default_mute_stories", JsonBool{object.use_default_mute_stories_});
  jo("mute_stories", JsonBool{object.mute_stories_});
  jo("use_default_story_sound", JsonBool{object.use_default_story_sound_});
  jo("story_sound_id", ToJson(JsonInt64{object.story_sound_id_}));
  jo("use_default_show_story_poster", JsonBool{object.use_default_show_story_poster_});
  jo("show_story_poster", JsonBool{object.show_story_poster_});
  jo("use_default_disable_pinned_message_notifications", JsonBool{object.use_default_disable_pinned_message_notifications_});
  jo("disable_pinned_message_notifications", JsonBool{object.disable_pinned_message_notifications_});
  jo("use_default_disable_mention_notifications", JsonBool{object.use_default_disable_mention_notifications_});
  jo("disable_mention_notifications", JsonBool{object.disable_mention_notifications_});
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueStatistics");
  if (object.revenue_by_hour_graph_) {
    jo("revenue_by_hour_graph", ToJson(*object.revenue_by_hour_graph_));
  }
  if (object.revenue_graph_) {
    jo("revenue_graph", ToJson(*object.revenue_graph_));
  }
  if (object.revenue_amount_) {
    jo("revenue_amount", ToJson(*object.revenue_amount_));
  }
  jo("usd_rate", object.usd_rate_);
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsMessageSenderInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsMessageSenderInfo");
  jo("user_id", object.user_id_);
  jo("sent_message_count", object.sent_message_count_);
  jo("average_character_count", object.average_character_count_);
}

void to_json(JsonValueScope &jv, const td_api::closeBirthdayUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "closeBirthdayUser");
  jo("user_id", object.user_id_);
  if (object.birthdate_) {
    jo("birthdate", ToJson(*object.birthdate_));
  }
}

void to_json(JsonValueScope &jv, const td_api::count &object) {
  auto jo = jv.enter_object();
  jo("@type", "count");
  jo("count", object.count_);
}

void to_json(JsonValueScope &jv, const td_api::dateRange &object) {
  auto jo = jv.enter_object();
  jo("@type", "dateRange");
  jo("start_date", object.start_date_);
  jo("end_date", object.end_date_);
}

void to_json(JsonValueScope &jv, const td_api::EmailAddressResetState &object) {
  td_api::downcast_call(const_cast<td_api::EmailAddressResetState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::emailAddressResetStateAvailable &object) {
  auto jo = jv.enter_object();
  jo("@type", "emailAddressResetStateAvailable");
  jo("wait_period", object.wait_period_);
}

void to_json(JsonValueScope &jv, const td_api::emailAddressResetStatePending &object) {
  auto jo = jv.enter_object();
  jo("@type", "emailAddressResetStatePending");
  jo("reset_in", object.reset_in_);
}

void to_json(JsonValueScope &jv, const td_api::emojiStatusCustomEmojis &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiStatusCustomEmojis");
  jo("custom_emoji_ids", ToJson(JsonVectorInt64{object.custom_emoji_ids_}));
}

void to_json(JsonValueScope &jv, const td_api::failedToAddMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "failedToAddMembers");
  jo("failed_to_add_members", ToJson(object.failed_to_add_members_));
}

void to_json(JsonValueScope &jv, const td_api::forumTopicInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "forumTopicInfo");
  jo("chat_id", object.chat_id_);
  jo("forum_topic_id", object.forum_topic_id_);
  jo("name", object.name_);
  if (object.icon_) {
    jo("icon", ToJson(*object.icon_));
  }
  jo("creation_date", object.creation_date_);
  if (object.creator_id_) {
    jo("creator_id", ToJson(*object.creator_id_));
  }
  jo("is_general", JsonBool{object.is_general_});
  jo("is_outgoing", JsonBool{object.is_outgoing_});
  jo("is_closed", JsonBool{object.is_closed_});
  jo("is_hidden", JsonBool{object.is_hidden_});
  jo("is_name_implicit", JsonBool{object.is_name_implicit_});
}

void to_json(JsonValueScope &jv, const td_api::foundPosition &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundPosition");
  jo("position", object.position_);
}

void to_json(JsonValueScope &jv, const td_api::gift &object) {
  auto jo = jv.enter_object();
  jo("@type", "gift");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("publisher_chat_id", object.publisher_chat_id_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
  jo("star_count", object.star_count_);
  jo("default_sell_star_count", object.default_sell_star_count_);
  jo("upgrade_star_count", object.upgrade_star_count_);
  jo("has_colors", JsonBool{object.has_colors_});
  jo("is_for_birthday", JsonBool{object.is_for_birthday_});
  jo("is_premium", JsonBool{object.is_premium_});
  if (object.auction_info_) {
    jo("auction_info", ToJson(*object.auction_info_));
  }
  jo("next_send_date", object.next_send_date_);
  if (object.user_limits_) {
    jo("user_limits", ToJson(*object.user_limits_));
  }
  if (object.overall_limits_) {
    jo("overall_limits", ToJson(*object.overall_limits_));
  }
  jo("first_send_date", object.first_send_date_);
  jo("last_send_date", object.last_send_date_);
}

void to_json(JsonValueScope &jv, const td_api::giftCollections &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftCollections");
  jo("collections", ToJson(object.collections_));
}

void to_json(JsonValueScope &jv, const td_api::giftsForResale &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftsForResale");
  jo("total_count", object.total_count_);
  jo("gifts", ToJson(object.gifts_));
  jo("models", ToJson(object.models_));
  jo("symbols", ToJson(object.symbols_));
  jo("backdrops", ToJson(object.backdrops_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallMessageLevel &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallMessageLevel");
  jo("min_star_count", object.min_star_count_);
  jo("pin_duration", object.pin_duration_);
  jo("max_text_length", object.max_text_length_);
  jo("max_custom_emoji_count", object.max_custom_emoji_count_);
  jo("first_color", object.first_color_);
  jo("second_color", object.second_color_);
  jo("background_color", object.background_color_);
}

void to_json(JsonValueScope &jv, const td_api::httpUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "httpUrl");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::inputChecklist &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputChecklist");
  if (object.title_) {
    jo("title", ToJson(*object.title_));
  }
  jo("tasks", ToJson(object.tasks_));
  jo("others_can_add_tasks", JsonBool{object.others_can_add_tasks_});
  jo("others_can_mark_tasks_as_done", JsonBool{object.others_can_mark_tasks_as_done_});
}

void to_json(JsonValueScope &jv, const td_api::inputThumbnail &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputThumbnail");
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
}

void to_json(JsonValueScope &jv, const td_api::labeledPricePart &object) {
  auto jo = jv.enter_object();
  jo("@type", "labeledPricePart");
  jo("label", object.label_);
  jo("amount", object.amount_);
}

void to_json(JsonValueScope &jv, const td_api::liveStoryDonors &object) {
  auto jo = jv.enter_object();
  jo("@type", "liveStoryDonors");
  jo("total_star_count", object.total_star_count_);
  jo("top_donors", ToJson(object.top_donors_));
}

void to_json(JsonValueScope &jv, const td_api::mainWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "mainWebApp");
  jo("url", object.url_);
  if (object.mode_) {
    jo("mode", ToJson(*object.mode_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messageEffect &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageEffect");
  jo("id", ToJson(JsonInt64{object.id_}));
  if (object.static_icon_) {
    jo("static_icon", ToJson(*object.static_icon_));
  }
  jo("emoji", object.emoji_);
  jo("is_premium", JsonBool{object.is_premium_});
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messagePosition &object) {
  auto jo = jv.enter_object();
  jo("@type", "messagePosition");
  jo("position", object.position_);
  jo("message_id", object.message_id_);
  jo("date", object.date_);
}

void to_json(JsonValueScope &jv, const td_api::MessageSelfDestructType &object) {
  td_api::downcast_call(const_cast<td_api::MessageSelfDestructType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageSelfDestructTypeTimer &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSelfDestructTypeTimer");
  jo("self_destruct_time", object.self_destruct_time_);
}

void to_json(JsonValueScope &jv, const td_api::messageSelfDestructTypeImmediately &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSelfDestructTypeImmediately");
}

void to_json(JsonValueScope &jv, const td_api::messages &object) {
  auto jo = jv.enter_object();
  jo("@type", "messages");
  jo("total_count", object.total_count_);
  jo("messages", ToJson(object.messages_));
}

void to_json(JsonValueScope &jv, const td_api::NotificationSettingsScope &object) {
  td_api::downcast_call(const_cast<td_api::NotificationSettingsScope &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::notificationSettingsScopePrivateChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSettingsScopePrivateChats");
}

void to_json(JsonValueScope &jv, const td_api::notificationSettingsScopeGroupChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSettingsScopeGroupChats");
}

void to_json(JsonValueScope &jv, const td_api::notificationSettingsScopeChannelChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSettingsScopeChannelChats");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockCaption &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockCaption");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  if (object.credit_) {
    jo("credit", ToJson(*object.credit_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportAuthorizationForm &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportAuthorizationForm");
  jo("id", object.id_);
  jo("required_elements", ToJson(object.required_elements_));
  jo("privacy_policy_url", object.privacy_policy_url_);
}

void to_json(JsonValueScope &jv, const td_api::passwordState &object) {
  auto jo = jv.enter_object();
  jo("@type", "passwordState");
  jo("has_password", JsonBool{object.has_password_});
  jo("password_hint", object.password_hint_);
  jo("has_recovery_email_address", JsonBool{object.has_recovery_email_address_});
  jo("has_passport_data", JsonBool{object.has_passport_data_});
  if (object.recovery_email_address_code_info_) {
    jo("recovery_email_address_code_info", ToJson(*object.recovery_email_address_code_info_));
  }
  jo("login_email_address_pattern", object.login_email_address_pattern_);
  jo("pending_reset_date", object.pending_reset_date_);
}

void to_json(JsonValueScope &jv, const td_api::personalDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "personalDocument");
  jo("files", ToJson(object.files_));
  jo("translation", ToJson(object.translation_));
}

void to_json(JsonValueScope &jv, const td_api::premiumFeaturePromotionAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeaturePromotionAnimation");
  if (object.feature_) {
    jo("feature", ToJson(*object.feature_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::premiumPaymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumPaymentOption");
  jo("currency", object.currency_);
  jo("amount", object.amount_);
  jo("discount_percentage", object.discount_percentage_);
  jo("month_count", object.month_count_);
  jo("store_product_id", object.store_product_id_);
  if (object.payment_link_) {
    jo("payment_link", ToJson(*object.payment_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::profilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "profilePhoto");
  jo("id", ToJson(JsonInt64{object.id_}));
  if (object.small_) {
    jo("small", ToJson(*object.small_));
  }
  if (object.big_) {
    jo("big", ToJson(*object.big_));
  }
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  jo("has_animation", JsonBool{object.has_animation_});
  jo("is_personal", JsonBool{object.is_personal_});
}

void to_json(JsonValueScope &jv, const td_api::pushReceiverId &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushReceiverId");
  jo("id", ToJson(JsonInt64{object.id_}));
}

void to_json(JsonValueScope &jv, const td_api::receivedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "receivedGift");
  jo("received_gift_id", object.received_gift_id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("is_private", JsonBool{object.is_private_});
  jo("is_saved", JsonBool{object.is_saved_});
  jo("is_pinned", JsonBool{object.is_pinned_});
  jo("can_be_upgraded", JsonBool{object.can_be_upgraded_});
  jo("can_be_transferred", JsonBool{object.can_be_transferred_});
  jo("was_refunded", JsonBool{object.was_refunded_});
  jo("date", object.date_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("collection_ids", ToJson(object.collection_ids_));
  jo("sell_star_count", object.sell_star_count_);
  jo("prepaid_upgrade_star_count", object.prepaid_upgrade_star_count_);
  jo("is_upgrade_separate", JsonBool{object.is_upgrade_separate_});
  jo("transfer_star_count", object.transfer_star_count_);
  jo("drop_original_details_star_count", object.drop_original_details_star_count_);
  jo("next_transfer_date", object.next_transfer_date_);
  jo("next_resale_date", object.next_resale_date_);
  jo("export_date", object.export_date_);
  jo("prepaid_upgrade_hash", object.prepaid_upgrade_hash_);
}

void to_json(JsonValueScope &jv, const td_api::ReportSponsoredResult &object) {
  td_api::downcast_call(const_cast<td_api::ReportSponsoredResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultOk");
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultFailed &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultFailed");
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultOptionRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultOptionRequired");
  jo("title", object.title_);
  jo("options", ToJson(object.options_));
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultAdsHidden &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultAdsHidden");
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultPremiumRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultPremiumRequired");
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTags &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTags");
  jo("tags", ToJson(object.tags_));
}

void to_json(JsonValueScope &jv, const td_api::sentWebAppMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "sentWebAppMessage");
  jo("inline_message_id", object.inline_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::sponsoredChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "sponsoredChats");
  jo("chats", ToJson(object.chats_));
}

void to_json(JsonValueScope &jv, const td_api::starPaymentOptions &object) {
  auto jo = jv.enter_object();
  jo("@type", "starPaymentOptions");
  jo("options", ToJson(object.options_));
}

void to_json(JsonValueScope &jv, const td_api::starTransactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactions");
  if (object.star_amount_) {
    jo("star_amount", ToJson(*object.star_amount_));
  }
  jo("transactions", ToJson(object.transactions_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::stickerSets &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerSets");
  jo("total_count", object.total_count_);
  jo("sets", ToJson(object.sets_));
}

void to_json(JsonValueScope &jv, const td_api::storyAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyAlbum");
  jo("id", object.id_);
  jo("name", object.name_);
  if (object.photo_icon_) {
    jo("photo_icon", ToJson(*object.photo_icon_));
  }
  if (object.video_icon_) {
    jo("video_icon", ToJson(*object.video_icon_));
  }
}

void to_json(JsonValueScope &jv, const td_api::StoryInteractionType &object) {
  td_api::downcast_call(const_cast<td_api::StoryInteractionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::storyInteractionTypeView &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInteractionTypeView");
  if (object.chosen_reaction_type_) {
    jo("chosen_reaction_type", ToJson(*object.chosen_reaction_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::storyInteractionTypeForward &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInteractionTypeForward");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::storyInteractionTypeRepost &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInteractionTypeRepost");
  if (object.story_) {
    jo("story", ToJson(*object.story_));
  }
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostInfo");
  if (object.price_) {
    jo("price", ToJson(*object.price_));
  }
  jo("send_date", object.send_date_);
  if (object.state_) {
    jo("state", ToJson(*object.state_));
  }
  jo("can_be_approved", JsonBool{object.can_be_approved_});
  jo("can_be_declined", JsonBool{object.can_be_declined_});
}

void to_json(JsonValueScope &jv, const td_api::TargetChat &object) {
  td_api::downcast_call(const_cast<td_api::TargetChat &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::targetChatCurrent &object) {
  auto jo = jv.enter_object();
  jo("@type", "targetChatCurrent");
}

void to_json(JsonValueScope &jv, const td_api::targetChatChosen &object) {
  auto jo = jv.enter_object();
  jo("@type", "targetChatChosen");
  if (object.types_) {
    jo("types", ToJson(*object.types_));
  }
}

void to_json(JsonValueScope &jv, const td_api::targetChatInternalLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "targetChatInternalLink");
  if (object.link_) {
    jo("link", ToJson(*object.link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::testVectorString &object) {
  auto jo = jv.enter_object();
  jo("@type", "testVectorString");
  jo("value", ToJson(object.value_));
}

void to_json(JsonValueScope &jv, const td_api::ThumbnailFormat &object) {
  td_api::downcast_call(const_cast<td_api::ThumbnailFormat &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::thumbnailFormatJpeg &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnailFormatJpeg");
}

void to_json(JsonValueScope &jv, const td_api::thumbnailFormatGif &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnailFormatGif");
}

void to_json(JsonValueScope &jv, const td_api::thumbnailFormatMpeg4 &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnailFormatMpeg4");
}

void to_json(JsonValueScope &jv, const td_api::thumbnailFormatPng &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnailFormatPng");
}

void to_json(JsonValueScope &jv, const td_api::thumbnailFormatTgs &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnailFormatTgs");
}

void to_json(JsonValueScope &jv, const td_api::thumbnailFormatWebm &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnailFormatWebm");
}

void to_json(JsonValueScope &jv, const td_api::thumbnailFormatWebp &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnailFormatWebp");
}

void to_json(JsonValueScope &jv, const td_api::unconfirmedSession &object) {
  auto jo = jv.enter_object();
  jo("@type", "unconfirmedSession");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("log_in_date", object.log_in_date_);
  jo("device_model", object.device_model_);
  jo("location", object.location_);
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftColors &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftColors");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("model_custom_emoji_id", ToJson(JsonInt64{object.model_custom_emoji_id_}));
  jo("symbol_custom_emoji_id", ToJson(JsonInt64{object.symbol_custom_emoji_id_}));
  jo("light_theme_accent_color", object.light_theme_accent_color_);
  jo("light_theme_colors", ToJson(object.light_theme_colors_));
  jo("dark_theme_accent_color", object.dark_theme_accent_color_);
  jo("dark_theme_colors", ToJson(object.dark_theme_colors_));
}

void to_json(JsonValueScope &jv, const td_api::userAuctionBid &object) {
  auto jo = jv.enter_object();
  jo("@type", "userAuctionBid");
  jo("star_count", object.star_count_);
  jo("bid_date", object.bid_date_);
  jo("next_bid_star_count", object.next_bid_star_count_);
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  jo("was_returned", JsonBool{object.was_returned_});
}

void to_json(JsonValueScope &jv, const td_api::UserType &object) {
  td_api::downcast_call(const_cast<td_api::UserType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::userTypeRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "userTypeRegular");
}

void to_json(JsonValueScope &jv, const td_api::userTypeDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "userTypeDeleted");
}

void to_json(JsonValueScope &jv, const td_api::userTypeBot &object) {
  auto jo = jv.enter_object();
  jo("@type", "userTypeBot");
  jo("can_be_edited", JsonBool{object.can_be_edited_});
  jo("can_join_groups", JsonBool{object.can_join_groups_});
  jo("can_read_all_group_messages", JsonBool{object.can_read_all_group_messages_});
  jo("has_main_web_app", JsonBool{object.has_main_web_app_});
  jo("has_topics", JsonBool{object.has_topics_});
  jo("is_inline", JsonBool{object.is_inline_});
  jo("inline_query_placeholder", object.inline_query_placeholder_);
  jo("need_location", JsonBool{object.need_location_});
  jo("can_connect_to_business", JsonBool{object.can_connect_to_business_});
  jo("can_be_added_to_attachment_menu", JsonBool{object.can_be_added_to_attachment_menu_});
  jo("active_user_count", object.active_user_count_);
}

void to_json(JsonValueScope &jv, const td_api::userTypeUnknown &object) {
  auto jo = jv.enter_object();
  jo("@type", "userTypeUnknown");
}

void to_json(JsonValueScope &jv, const td_api::videoMessageAdvertisement &object) {
  auto jo = jv.enter_object();
  jo("@type", "videoMessageAdvertisement");
  jo("unique_id", object.unique_id_);
  jo("text", object.text_);
  jo("min_display_duration", object.min_display_duration_);
  jo("max_display_duration", object.max_display_duration_);
  jo("can_be_reported", JsonBool{object.can_be_reported_});
  if (object.sponsor_) {
    jo("sponsor", ToJson(*object.sponsor_));
  }
  jo("title", object.title_);
  jo("additional_info", object.additional_info_);
}

}  // namespace td_api
}  // namespace td
