/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.UncivGame;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.unit.RoadBetweenCitiesAutomation;
import com.unciv.logic.automation.unit.RoadToAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActions;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsFromUniques;
import com.unciv.utils.LogKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 E2\u00020\u0001:\u0002DEB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00190#j\b\u0012\u0004\u0012\u00020\u0019`$2\b\b\u0002\u0010%\u001a\u00020&J \u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0019H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J \u0010+\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0002J(\u0010-\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020!2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190/2\u0006\u0010%\u001a\u00020&H\u0003J.\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190/2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0003J\u0018\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0007J \u00104\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0003J \u00105\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0003J \u00106\u001a\u00020(2\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0003J\"\u00107\u001a\u0004\u0018\u0001082\u0006\u0010 \u001a\u00020!2\u0006\u00101\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0003J4\u00109\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010:\u001a\u00020;2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=H\u0003J$\u0010>\u001a\u00020(2\u0006\u00101\u001a\u00020\u00192\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002080@H\u0003J\u0010\u0010A\u001a\u00020(2\u0006\u0010B\u001a\u000208H\u0007J\u000e\u0010C\u001a\u00020(2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a`\u001b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u00a8\u0006F"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "cachedForTurn", "", "cloningSource", "<init>", "(Lcom/unciv/logic/civilization/Civilization;ILcom/unciv/logic/automation/unit/WorkerAutomation;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "getCachedForTurn", "()I", "roadToAutomation", "Lcom/unciv/logic/automation/unit/RoadToAutomation;", "getRoadToAutomation", "()Lcom/unciv/logic/automation/unit/RoadToAutomation;", "roadBetweenCitiesAutomation", "Lcom/unciv/logic/automation/unit/RoadBetweenCitiesAutomation;", "getRoadBetweenCitiesAutomation", "()Lcom/unciv/logic/automation/unit/RoadBetweenCitiesAutomation;", "ruleSet", "Lcom/unciv/models/ruleset/Ruleset;", "tileRankings", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "Lkotlin/collections/HashMap;", "getTileRankings$annotations", "()V", "automateWorkerAction", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "dangerousTiles", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "tryHeadTowardsUndevelopedCity", "", "currentTile", "startWorkOnCurrentTile", "headTowardsTileToWork", "tileToWork", "findTileToWork", "tilesToAvoid", "", "isAutomationWorkableTile", "tile", "getBasePriority", "", "getImprovementPriority", "getFullPriority", "tileHasWorkToDo", "chooseImprovement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "getImprovementRanking", "improvementName", "", "currentTileStats", "Lcom/unciv/models/stats/Stats;", "isResourceImprovementAllowedOnFeature", "potentialTileImprovements", "", "isImprovementProbablyAFort", "improvement", "automateWorkBoats", "TileImprovementRank", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nWorkerAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,595:1\n774#2:596\n865#2:597\n866#2:602\n1056#2:603\n295#2,2:604\n1056#2:621\n774#2:645\n865#2,2:646\n1999#2,14:648\n295#2,2:664\n1761#2,2:668\n1761#2,3:670\n1763#2:673\n1255#3:598\n2275#3,2:599\n1256#3:601\n996#3:606\n1025#3,3:607\n1028#3,3:617\n622#3:620\n2275#3,2:622\n1463#3,14:631\n1255#3,2:662\n2275#3,2:666\n608#3:674\n183#3,2:675\n382#4,7:610\n536#4:624\n521#4,6:625\n*S KotlinDebug\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation\n*L\n123#1:596\n123#1:597\n123#1:602\n126#1:603\n127#1:604,2\n223#1:621\n399#1:645\n399#1:646,2\n400#1:648,14\n461#1:664,2\n531#1:668,2\n534#1:670,3\n531#1:673\n123#1:598\n124#1:599,2\n123#1:601\n215#1:606\n215#1:607,3\n215#1:617,3\n216#1:620\n256#1:622,2\n376#1:631,14\n450#1:662,2\n508#1:666,2\n554#1:674\n555#1:675,2\n215#1:610,7\n365#1:624\n365#1:625,6\n*E\n"})
public final class WorkerAutomation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Civilization civInfo;
    private final int cachedForTurn;
    @NotNull
    private final RoadToAutomation roadToAutomation;
    @NotNull
    private final RoadBetweenCitiesAutomation roadBetweenCitiesAutomation;
    @NotNull
    private final Ruleset ruleSet;
    @NotNull
    private final HashMap<Tile, TileImprovementRank> tileRankings;

    public WorkerAutomation(@NotNull Civilization civInfo, int cachedForTurn, @Nullable WorkerAutomation cloningSource) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.cachedForTurn = cachedForTurn;
        this.roadToAutomation = new RoadToAutomation(this.civInfo);
        WorkerAutomation workerAutomation = cloningSource;
        this.roadBetweenCitiesAutomation = new RoadBetweenCitiesAutomation(this.civInfo, this.cachedForTurn, workerAutomation != null ? workerAutomation.roadBetweenCitiesAutomation : null);
        this.ruleSet = this.civInfo.getGameInfo().getRuleset();
        this.tileRankings = new HashMap();
    }

    public /* synthetic */ WorkerAutomation(Civilization civilization, int n, WorkerAutomation workerAutomation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            workerAutomation = null;
        }
        this(civilization, n, workerAutomation);
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    public final int getCachedForTurn() {
        return this.cachedForTurn;
    }

    @NotNull
    public final RoadToAutomation getRoadToAutomation() {
        return this.roadToAutomation;
    }

    @NotNull
    public final RoadBetweenCitiesAutomation getRoadBetweenCitiesAutomation() {
        return this.roadBetweenCitiesAutomation;
    }

    @Cache
    private static /* synthetic */ void getTileRankings$annotations() {
    }

    public final void automateWorkerAction(@NotNull MapUnit unit, @NotNull HashSet<Tile> dangerousTiles, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(dangerousTiles, "dangerousTiles");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Tile currentTile = unit.getTile();
        List<City> citiesToConnect = this.roadBetweenCitiesAutomation.getNearbyCitiesToConnect$core(unit);
        if (currentTile.getImprovementInProgress() != null && !dangerousTiles.contains(currentTile) && this.getFullPriority(unit.getTile(), unit, localUniqueCache) >= 2.0f) {
            return;
        }
        Tile tileToWork = this.findTileToWork(unit, (Set<Tile>)dangerousTiles, localUniqueCache);
        if (!Intrinsics.areEqual(tileToWork, currentTile) && tileToWork != null) {
            this.headTowardsTileToWork(unit, tileToWork, localUniqueCache);
            return;
        }
        if (currentTile.getImprovementInProgress() != null) {
            return;
        }
        if (Intrinsics.areEqual(tileToWork, currentTile) && this.tileHasWorkToDo(currentTile, unit, localUniqueCache)) {
            this.startWorkOnCurrentTile(unit);
            return;
        }
        if (unit.getCache().getHasUniqueToCreateWaterImprovements() && this.automateWorkBoats(unit)) {
            return;
        }
        if (this.tryHeadTowardsUndevelopedCity(unit, localUniqueCache, currentTile)) {
            return;
        }
        if (this.roadBetweenCitiesAutomation.tryConnectingCities$core(unit, citiesToConnect)) {
            return;
        }
        Object[] objectArray = new Object[]{unit.toString()};
        LogKt.debug("WorkerAutomation: %s -> nothing to do", objectArray);
        objectArray = new String[]{unit.getName(), "OtherIcons/Sleep"};
        unit.getCiv().addNotification(unit.shortDisplayName() + " has no work to do.", new MapUnitAction(unit), Notification.NotificationCategory.Units, (String[])objectArray);
        if (unit.getCiv().isCityState()) {
            UnitAutomation.INSTANCE.wander(unit, true, (Set<Tile>)dangerousTiles);
        }
    }

    public static /* synthetic */ void automateWorkerAction$default(WorkerAutomation workerAutomation, MapUnit mapUnit, HashSet hashSet, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false, 1, null);
        }
        workerAutomation.automateWorkerAction(mapUnit, hashSet, localUniqueCache);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final boolean tryHeadTowardsUndevelopedCity(MapUnit unit, LocalUniqueCache localUniqueCache, Tile currentTile) {
        block12: {
            var5_4 = unit.getCiv().getCities();
            $i$f$filter = false;
            var7_6 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block11: {
                    it = (City)element$iv$iv;
                    $i$a$-filter-WorkerAutomation$tryHeadTowardsUndevelopedCity$closestUndevelopedCity$1 = false;
                    if (Intrinsics.areEqual(it, unit.getCurrentTile().getOwningCity())) ** GOTO lbl-1000
                    $this$any$iv = it.getTiles();
                    $i$f$any = false;
                    var16_17 = $this$any$iv.iterator();
                    while (var16_17.hasNext()) {
                        block10: {
                            tile = element$iv = var16_17.next();
                            $i$a$-any-WorkerAutomation$tryHeadTowardsUndevelopedCity$closestUndevelopedCity$1$1 = false;
                            if (!tile.isLand()) ** GOTO lbl-1000
                            $this$none$iv = tile.getUnits();
                            $i$f$none = false;
                            var22_23 = $this$none$iv.iterator();
                            while (var22_23.hasNext()) {
                                unit = element$iv = var22_23.next();
                                $i$a$-none-WorkerAutomation$tryHeadTowardsUndevelopedCity$closestUndevelopedCity$1$1$1 = false;
                                if (!unit.getCache().getHasUniqueToBuildImprovements()) continue;
                                v0 = false;
                                break block10;
                            }
                            v0 = true;
                        }
                        if (v0 && (tile.isPillaged() || this.tileHasWorkToDo(tile, unit, localUniqueCache))) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                        if (!v1) continue;
                        v2 = true;
                        break block11;
                    }
                    v2 = false;
                }
                if (v2) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(currentTile){
                final /* synthetic */ Tile $currentTile$inlined;
                {
                    this.$currentTile$inlined = tile;
                }

                public final int compare(T a, T b) {
                    City it = (City)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$currentTile$inlined));
                    it = (City)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$currentTile$inlined));
                }
            });
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (City)element$iv;
                $i$a$-firstOrNull-WorkerAutomation$tryHeadTowardsUndevelopedCity$closestUndevelopedCity$3 = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                v4 = element$iv;
                break block12;
            }
            v4 = null;
        }
        closestUndevelopedCity = v4;
        if (closestUndevelopedCity != null) {
            $this$firstOrNull$iv = new Object[]{unit, closestUndevelopedCity.getName()};
            LogKt.debug("WorkerAutomation: %s -> head towards undeveloped city %s", $this$firstOrNull$iv);
            reachedTile = unit.getMovement().headTowards(closestUndevelopedCity.getCenterTile());
            if (!Intrinsics.areEqual(reachedTile, currentTile)) {
                unit.doAction();
            }
            return true;
        }
        return false;
    }

    private final void startWorkOnCurrentTile(MapUnit unit) {
        Tile currentTile = unit.getCurrentTile();
        TileImprovementRank tileImprovementRank = this.tileRankings.get(currentTile);
        Intrinsics.checkNotNull(tileImprovementRank);
        TileImprovementRank tileRanking = tileImprovementRank;
        if (Intrinsics.areEqual(tileRanking.getRepairImprovment(), true)) {
            LogKt.debug("WorkerAutomation: " + unit + " -> repairs " + currentTile, new Object[0]);
            Object object = UnitActionsFromUniques.INSTANCE.getRepairAction(unit);
            if (object != null && (object = ((UnitAction)object).getAction()) != null) {
                object.invoke();
            }
            return;
        }
        if (tileRanking.getBestImprovement() != null) {
            LogKt.debug("WorkerAutomation: " + unit + "} -> start improving " + currentTile, new Object[0]);
            TileImprovement tileImprovement = tileRanking.getBestImprovement();
            Intrinsics.checkNotNull(tileImprovement);
            currentTile.startWorkingOnImprovement(tileImprovement, this.civInfo, unit);
            return;
        }
        throw new IllegalStateException("We didn't find anything to improve on this tile even though there was supposed to be something to improve!");
    }

    private final void headTowardsTileToWork(MapUnit unit, Tile tileToWork, LocalUniqueCache localUniqueCache) {
        Object[] objectArray = new Object[]{unit.toString(), tileToWork};
        LogKt.debug("WorkerAutomation: %s -> head towards %s", objectArray);
        Tile currentTile = unit.getTile();
        Tile reachedTile = unit.getMovement().headTowards(tileToWork);
        if (SequencesKt.contains(reachedTile.getNeighbors(), tileToWork) && UnitMovement.canMoveTo$default(unit.getMovement(), tileToWork, false, true, false, 10, null) && !UnitMovement.canMoveTo$default(unit.getMovement(), tileToWork, false, false, false, 10, null) && unit.getMovement().canUnitSwapTo(tileToWork)) {
            UnitMovement.swapMoveToTile$default(unit.getMovement(), tileToWork, false, 2, null);
        }
        if (!Intrinsics.areEqual(reachedTile, currentTile)) {
            unit.doAction();
        }
        if (Intrinsics.areEqual(reachedTile, tileToWork) && Intrinsics.areEqual(reachedTile.getImprovementInProgress(), "Fort")) {
            LogKt.debug("Replacing fort in progress with new improvement", new Object[0]);
            reachedTile.stopWorkingOnImprovement();
        }
        if (!unit.hasMovement() || !Intrinsics.areEqual(reachedTile, tileToWork)) {
            return;
        }
        if (this.tileHasWorkToDo(unit.getCurrentTile(), unit, localUniqueCache)) {
            this.startWorkOnCurrentTile(unit);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final Tile findTileToWork(MapUnit unit, Set<Tile> tilesToAvoid, LocalUniqueCache localUniqueCache) {
        void $this$groupByTo$iv$iv;
        Sequence<Tile> workableTilesCenterFirst;
        Tile currentTile = unit.getTile();
        if (this.isAutomationWorkableTile(currentTile, tilesToAvoid, currentTile, unit) && this.getBasePriority(currentTile, unit) >= 3.0f && (currentTile.isPillaged() || currentTile.hasFalloutEquivalent() || this.tileHasWorkToDo(currentTile, unit, localUniqueCache))) {
            return currentTile;
        }
        Sequence<Tile> $this$groupBy$iv = workableTilesCenterFirst = SequencesKt.filter(currentTile.getTilesInDistance(3), arg_0 -> WorkerAutomation.findTileToWork$lambda$0(unit, this, tilesToAvoid, currentTile, arg_0));
        boolean $i$f$groupBy = false;
        Sequence<Tile> sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            Float key$iv$iv = Float.valueOf(this.getBasePriority(it, unit));
            Map map2 = destination$iv$iv;
            Float key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Sequence $this$sortedByDescending$iv = MapsKt.asSequence(destination$iv$iv);
        boolean $i$f$sortedByDescending = false;
        Sequence workableTilesPrioritized = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Float)it.getKey();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getKey()));
            }
        });
        Iterator iterator2 = workableTilesPrioritized.iterator();
        while (iterator2.hasNext()) {
            Map.Entry tilePriorityGroup = iterator2.next();
            Tile bestTile = null;
            Iterable $this$sortedBy$iv = (Iterable)tilePriorityGroup.getValue();
            boolean $i$f$sortedBy = false;
            for (Tile tileInGroup : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$unit$inlined.getTile().aerialDistanceTo(it));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getTile().aerialDistanceTo(it));
                }
            })) {
                if (!this.tileHasWorkToDo(tileInGroup, unit, localUniqueCache)) continue;
                if (Intrinsics.areEqual(unit.getTile(), tileInGroup)) {
                    return unit.getTile();
                }
                if (!unit.getMovement().canReach(tileInGroup) || bestTile != null && !(this.getFullPriority(tileInGroup, unit, localUniqueCache) > this.getFullPriority(bestTile, unit, localUniqueCache))) continue;
                bestTile = tileInGroup;
            }
            if (bestTile == null) continue;
            return bestTile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean isAutomationWorkableTile(Tile tile, Set<Tile> tilesToAvoid, Tile currentTile, MapUnit unit) {
        block14: {
            block15: {
                if (tilesToAvoid.contains(tile)) {
                    return false;
                }
                if (Intrinsics.areEqual(tile, currentTile)) break block14;
                if (!unit.isCivilian()) break block15;
                if (tile.getCivilianUnit() == null) break block14;
                MapUnit mapUnit = tile.getCivilianUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (!mapUnit.getCache().getHasUniqueToBuildImprovements()) break block14;
            }
            if (!unit.isMilitary()) return false;
            if (tile.getMilitaryUnit() != null) {
                MapUnit mapUnit = tile.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (mapUnit.getCache().getHasUniqueToBuildImprovements()) {
                    return false;
                }
            }
        }
        if (tile.getOwningCity() != null && !Intrinsics.areEqual(tile.getOwner(), this.civInfo)) {
            return false;
        }
        if (tile.isCityCenter()) {
            return false;
        }
        if (((Map)this.roadBetweenCitiesAutomation.getTilesOfRoadsMap$core()).containsKey(tile)) {
            return true;
        }
        if (!tile.hasViewableResource(this.civInfo)) {
            boolean bl;
            void $this$none$iv;
            Sequence<Tile> sequence = tile.getTilesInDistance(this.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getCityWorkRange());
            boolean $i$f$none = false;
            Iterator iterator2 = $this$none$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                Tile it = (Tile)element$iv;
                boolean bl2 = false;
                if (it.isCityCenter()) {
                    City city = it.getCity();
                    if (Intrinsics.areEqual(city != null ? city.getCiv() : null, this.civInfo)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            boolean bl3 = false;
            if (bl3) {
                return false;
            }
        }
        TileImprovement tileImprovement = tile.getTileImprovement();
        if (tileImprovement == null) return true;
        if (!IHasUniques.hasUnique$default(tileImprovement, UniqueType.AutomatedUnitsWillNotReplace, null, 2, null)) return true;
        boolean bl = true;
        if (!bl) return true;
        if (tile.isPillaged()) return true;
        return false;
    }

    @Readonly
    public final float getBasePriority(@NotNull Tile tile, @NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(unit, "unit");
        float unitSpecificPriority = (float)2 - RangesKt.coerceIn((float)tile.aerialDistanceTo(unit.getTile()) / 2.0f, 0.0f, 2.0f) * (float)3;
        if (this.tileRankings.containsKey(tile)) {
            TileImprovementRank tileImprovementRank = this.tileRankings.get(tile);
            Intrinsics.checkNotNull(tileImprovementRank);
            return tileImprovementRank.getTilePriority() + unitSpecificPriority;
        }
        float priority = 0.0f;
        if (Intrinsics.areEqual(tile.getOwner(), this.civInfo)) {
            priority += 1.0f;
            if (tile.providesYield()) {
                priority += (float)2;
            }
            if (tile.hasFalloutEquivalent()) {
                priority += 1.0f;
            }
            if (!((Collection)tile.getTerrainFeatures()).isEmpty()) {
                if (IHasUniques.hasUnique$default(tile.getLastTerrain(), UniqueType.ProductionBonusWhenRemoved, null, 2, null)) {
                    priority += 0.5f;
                } else if (IHasUniques.hasUnique$default(tile.getLastTerrain(), UniqueType.Vegetation, null, 2, null)) {
                    priority -= 0.3f;
                }
            }
            if (Tile.terrainHasUnique$default(tile, UniqueType.FreshWater, null, 2, null)) {
                priority += 1.0f;
            }
        }
        if (tile.hasViewableResource(this.civInfo)) {
            priority += 1.0f;
            if (tile.getTileResource().getResourceType() == ResourceType.Luxury) {
                priority += (float)5;
            }
        }
        ((Map)this.tileRankings).put(tile, new TileImprovementRank(priority, null, null, null, 14, null));
        return priority + unitSpecificPriority;
    }

    @Readonly
    private final float getImprovementPriority(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        TileImprovementRank rank;
        block8: {
            block9: {
                this.getBasePriority(tile, unit);
                TileImprovementRank tileImprovementRank = rank = this.tileRankings.get(tile);
                Intrinsics.checkNotNull(tileImprovementRank);
                if (tileImprovementRank.getImprovementPriority() == null) {
                    rank.setImprovementPriority(Float.valueOf(-100.0f));
                    rank.setBestImprovement(null);
                    rank.setRepairImprovment(false);
                    TileImprovement bestImprovement = this.chooseImprovement(unit, tile, localUniqueCache);
                    if (bestImprovement != null) {
                        rank.setBestImprovement(bestImprovement);
                        int timeSpentPriority = Intrinsics.areEqual(tile.getImprovementInProgress(), bestImprovement.getName()) ? bestImprovement.getTurnsToBuild(unit.getCiv(), unit) - tile.getTurnsToImprovement() : 0;
                        TileImprovement tileImprovement = rank.getBestImprovement();
                        Intrinsics.checkNotNull(tileImprovement);
                        rank.setImprovementPriority(Float.valueOf(WorkerAutomation.getImprovementRanking$default(this, tile, unit, tileImprovement.getName(), localUniqueCache, null, 16, null) + (float)timeSpentPriority));
                    }
                    if (tile.getImprovement() != null && tile.isPillaged() && tile.getOwningCity() != null) {
                        TileImprovement tileImprovement = tile.getImprovementToRepair();
                        Intrinsics.checkNotNull(tileImprovement);
                        int repairBonusPriority = tileImprovement.getTurnsToBuild(unit.getCiv(), unit) - UnitActionsFromUniques.INSTANCE.getRepairTurns$core(unit);
                        if (Intrinsics.areEqual(tile.getImprovementInProgress(), "Repair")) {
                            repairBonusPriority += UnitActionsFromUniques.INSTANCE.getRepairTurns$core(unit) - tile.getTurnsToImprovement();
                        }
                        float f = repairBonusPriority;
                        TileStatFunctions tileStatFunctions = tile.getStats();
                        TileImprovement tileImprovement2 = tile.getTileImprovement();
                        Intrinsics.checkNotNull(tileImprovement2);
                        float repairPriority = f + Automation.INSTANCE.rankStatsValue(TileStatFunctions.getStatDiffForImprovement$default(tileStatFunctions, tileImprovement2, unit.getCiv(), tile.getOwningCity(), null, null, 24, null), unit.getCiv());
                        Float f2 = rank.getImprovementPriority();
                        Intrinsics.checkNotNull(f2);
                        if (repairPriority > f2.floatValue()) {
                            rank.setImprovementPriority(Float.valueOf(repairPriority));
                            rank.setBestImprovement(null);
                            rank.setRepairImprovment(true);
                        }
                    }
                }
                Boolean bl = rank.getRepairImprovment();
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) break block8;
                if (rank.getBestImprovement() == null) break block9;
                TileImprovement tileImprovement = rank.getBestImprovement();
                Intrinsics.checkNotNull(tileImprovement);
                if (unit.canBuildImprovement(tileImprovement, tile)) break block8;
            }
            return -100.0f;
        }
        Float f = rank.getImprovementPriority();
        Intrinsics.checkNotNull(f);
        return f.floatValue();
    }

    @Readonly
    private final float getFullPriority(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        return this.getBasePriority(tile, unit) + this.getImprovementPriority(tile, unit, localUniqueCache);
    }

    @Readonly
    private final boolean tileHasWorkToDo(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        if (this.getImprovementPriority(tile, unit, localUniqueCache) <= 0.0f) {
            return false;
        }
        TileImprovementRank tileImprovementRank = this.tileRankings.get(tile);
        Intrinsics.checkNotNull(tileImprovementRank);
        if (tileImprovementRank.getBestImprovement() == null) {
            TileImprovementRank tileImprovementRank2 = this.tileRankings.get(tile);
            Intrinsics.checkNotNull(tileImprovementRank2);
            Boolean bl = tileImprovementRank2.getRepairImprovment();
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) {
                throw new IllegalStateException("There was an improvementPriority > 0 and nothing to do");
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Readonly
    private final TileImprovement chooseImprovement(MapUnit unit, Tile tile, LocalUniqueCache localUniqueCache) {
        block27: {
            block29: {
                block28: {
                    block26: {
                        if (tile.getImprovementInProgress() != null) {
                            v0 = this.ruleSet.getTileImprovements();
                            v1 = tile.getImprovementInProgress();
                            Intrinsics.checkNotNull(v1);
                            return v0.get(v1);
                        }
                        gameContext = new GameContext(unit.getCiv(), null, unit, tile, null, null, null, null, null, null, false, 2034, null);
                        $this$filter$iv = this.ruleSet.getTileImprovements();
                        $i$f$filter = false;
                        var8_8 = $this$filter$iv;
                        destination$iv$iv = new LinkedHashMap<K, V>();
                        $i$f$filterTo = false;
                        for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                            block25: {
                                it = element$iv$iv;
                                $i$a$-filter-WorkerAutomation$chooseImprovement$potentialTileImprovements$1 = false;
                                if (((TileImprovement)it.getValue()).getUniqueTo() == null) break block25;
                                v2 = unit.getCiv();
                                v3 = ((TileImprovement)it.getValue()).getUniqueTo();
                                Intrinsics.checkNotNull(v3);
                                if (!Civilization.matchesFilter$default(v2, v3, gameContext, false, 4, null)) ** GOTO lbl-1000
                            }
                            if (unit.canBuildImprovement((TileImprovement)it.getValue(), tile) && tile.getImprovementFunctions().canBuildImprovement((TileImprovement)it.getValue(), gameContext)) {
                                v4 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = false;
                            }
                            if (!v4) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        potentialTileImprovements = destination$iv$iv;
                        if (potentialTileImprovements.isEmpty()) {
                            return null;
                        }
                        currentTileStats = tile.getStats().getTileStats(tile.getCity(), this.civInfo, localUniqueCache);
                        destination$iv$iv = SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)potentialTileImprovements.values()), (Function1<TileImprovement, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseImprovement$lambda$1(com.unciv.logic.automation.unit.WorkerAutomation com.unciv.logic.map.tile.Tile com.unciv.logic.map.mapunit.MapUnit com.unciv.models.ruleset.unique.LocalUniqueCache com.unciv.models.stats.Stats com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Lkotlin/Pair;)((WorkerAutomation)this, (Tile)tile, (MapUnit)unit, (LocalUniqueCache)localUniqueCache, (Stats)currentTileStats)), (Function1<Pair, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, chooseImprovement$lambda$2(kotlin.Pair ), (Lkotlin/Pair;)Ljava/lang/Boolean;)());
                        $i$f$maxByOrNull = false;
                        iterator$iv = $this$maxByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v5 = null;
                        } else {
                            maxElem$iv /* !! */  = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v5 = maxElem$iv /* !! */ ;
                            } else {
                                it = (Pair)maxElem$iv /* !! */ ;
                                $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$bestBuildableImprovement$3 = false;
                                maxValue$iv = ((Number)it.getSecond()).floatValue();
                                do {
                                    e$iv = iterator$iv.next();
                                    it = (Pair)e$iv;
                                    $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$bestBuildableImprovement$3 = false;
                                    v$iv = ((Number)it.getSecond()).floatValue();
                                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                    maxElem$iv /* !! */  = e$iv;
                                    maxValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v5 = maxElem$iv /* !! */ ;
                            }
                        }
                        $this$filterTo$iv$iv = v5;
                        v6 = bestBuildableImprovement = $this$filterTo$iv$iv != null ? (TileImprovement)$this$filterTo$iv$iv.getFirst() : null;
                        if (tile.getImprovement() != null && this.civInfo.isHuman() && !UncivGame.Companion.getCurrent().getSettings().getAutomatedWorkersReplaceImprovements()) {
                            v7 = UncivGame.Companion.getCurrent().getWorldScreen();
                            v8 = v7 != null && (v7 = v7.getAutoPlay()) != null ? !v7.isAutoPlayingAndFullAutoPlayAI() : false;
                            if (v8) {
                                bestBuildableImprovement = null;
                            }
                        }
                        lastTerrain = tile.getLastTerrain();
                        if (tile.getResource() == null || !tile.hasViewableResource(this.civInfo)) {
                            v9 = null;
                        } else if (((Collection)tile.getTerrainFeatures()).isEmpty() == false && lastTerrain.getUnbuildable() && WorkerAutomation.chooseImprovement$isRemovable((Map<String, TileImprovement>)potentialTileImprovements, lastTerrain) && !tile.providesResources(this.civInfo) && !this.isResourceImprovementAllowedOnFeature(tile, (Map<String, TileImprovement>)potentialTileImprovements)) {
                            v9 = "Remove " + lastTerrain.getName();
                        } else {
                            $this$filter$iv = tile.getTileResource().getImprovements();
                            $i$f$filter = false;
                            maxElem$iv /* !! */  = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (String)element$iv$iv;
                                $i$a$-filter-WorkerAutomation$chooseImprovement$improvementStringForResource$1 = false;
                                if (!(potentialTileImprovements.containsKey(it) != false || Intrinsics.areEqual(it, tile.getImprovement()) != false)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            $i$f$maxByOrNull = false;
                            iterator$iv = $this$maxByOrNull$iv.iterator();
                            if (!iterator$iv.hasNext()) {
                                v10 = null;
                            } else {
                                maxElem$iv = iterator$iv.next();
                                if (!iterator$iv.hasNext()) {
                                    v10 = maxElem$iv;
                                } else {
                                    it = (String)maxElem$iv;
                                    $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$improvementStringForResource$2 = false;
                                    maxValue$iv = WorkerAutomation.getImprovementRanking$default(this, tile, unit, it, localUniqueCache, null, 16, null);
                                    do {
                                        e$iv = iterator$iv.next();
                                        it = (String)e$iv;
                                        $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$improvementStringForResource$2 = false;
                                        v$iv = WorkerAutomation.getImprovementRanking$default(this, tile, unit, it, localUniqueCache, null, 16, null);
                                        if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                        maxElem$iv = e$iv;
                                        maxValue$iv = v$iv;
                                    } while (iterator$iv.hasNext());
                                    v10 = maxElem$iv;
                                }
                            }
                            v9 = v10;
                        }
                        improvementStringForResource = v9;
                        if (bestBuildableImprovement == null || !bestBuildableImprovement.isRoad()) break block26;
                        v11 /* !! */  = bestBuildableImprovement.getName();
                        break block27;
                    }
                    if (improvementStringForResource == null || tile.getTileResource().getResourceType() == ResourceType.Bonus) break block28;
                    v11 /* !! */  = Intrinsics.areEqual(improvementStringForResource, tile.getImprovement()) ? null : improvementStringForResource;
                    break block27;
                }
                if (tile.getResource() != null && tile.hasViewableResource(this.civInfo) && tile.getTileResource().getResourceType() != ResourceType.Bonus && CollectionsKt.any((Iterable)tile.getTileResource().getImprovements())) {
                    return null;
                }
                if (bestBuildableImprovement != null) break block29;
                v11 /* !! */  = null;
                break block27;
            }
            if (tile.getImprovement() == null) ** GOTO lbl-1000
            v12 = tile.getImprovement();
            Intrinsics.checkNotNull(v12);
            if (WorkerAutomation.getImprovementRanking$default(this, tile, unit, v12, localUniqueCache, null, 16, null) > WorkerAutomation.getImprovementRanking$default(this, tile, unit, bestBuildableImprovement.getName(), localUniqueCache, null, 16, null)) {
                v11 /* !! */  = null;
            } else lbl-1000:
            // 2 sources

            {
                it = lastTerrain;
                $i$a$-let-WorkerAutomation$chooseImprovement$improvementString$1 = false;
                v11 /* !! */  = (WorkerAutomation.chooseImprovement$isRemovable((Map<String, TileImprovement>)potentialTileImprovements, it) && (Automation.INSTANCE.rankStatsValue(it, this.civInfo) < 0.0f || IHasUniques.hasUnique$default(it, UniqueType.NullifyYields, null, 2, null))) != false ? "Remove " + lastTerrain.getName() : bestBuildableImprovement.getName();
            }
        }
        improvementString = v11 /* !! */ ;
        return (TileImprovement)((Map)this.ruleSet.getTileImprovements()).get(improvementString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final float getImprovementRanking(Tile tile, MapUnit unit, String improvementName, LocalUniqueCache localUniqueCache, Stats currentTileStats) {
        boolean isResourceImprovedByNewImprovement;
        TileImprovement tileImprovement = this.ruleSet.getTileImprovements().get(improvementName);
        Intrinsics.checkNotNull(tileImprovement);
        TileImprovement improvement = tileImprovement;
        if (improvement.isRoad() && Intrinsics.areEqual(this.roadBetweenCitiesAutomation.getBestRoadAvailable$core().improvement(this.ruleSet), improvement) && ((Map)this.roadBetweenCitiesAutomation.getTilesOfRoadsMap$core()).containsKey(tile)) {
            RoadBetweenCitiesAutomation.RoadPlan roadPlan = this.roadBetweenCitiesAutomation.getTilesOfRoadsMap$core().get(tile);
            Intrinsics.checkNotNull(roadPlan);
            RoadBetweenCitiesAutomation.RoadPlan roadPlan2 = roadPlan;
            return roadPlan2.getPriority() - (float)9;
        }
        if (!Intrinsics.areEqual(tile.getOwner(), unit.getCiv())) {
            boolean bl;
            TileImprovement tileImprovement2 = this.ruleSet.getTileImprovements().get(improvementName);
            Intrinsics.checkNotNull(tileImprovement2);
            if (!IHasUniques.hasUnique$default(tileImprovement2, UniqueType.CanBuildOutsideBorders, null, 2, null)) return 0.0f;
            Sequence<Tile> $this$any$iv = tile.getNeighbors();
            boolean $i$f$any = false;
            Iterator<Tile> iterator2 = $this$any$iv.iterator();
            do {
                Tile element$iv;
                if (!iterator2.hasNext()) return 0.0f;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (Intrinsics.areEqual(it.getOwner(), unit.getCiv()) && it.getOwningCity() != null) {
                    City city = it.getOwningCity();
                    Intrinsics.checkNotNull(city);
                    if (tile.aerialDistanceTo(city.getCenterTile()) <= this.civInfo.getModConstants().getCityWorkRange()) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            boolean bl3 = true;
            if (!bl3) {
                return 0.0f;
            }
        }
        Stats stats = tile.getStats().getStatDiffForImprovement(improvement, this.civInfo, tile.getCity(), localUniqueCache, currentTileStats);
        boolean bl = isResourceImprovedByNewImprovement = tile.hasViewableResource(this.civInfo) && tile.getTileResource().isImprovedBy(improvementName);
        if (StringsKt.startsWith$default(improvementName, "Remove ", false, 2, null)) {
            String removedImprovement;
            Object v7;
            String removedObject;
            block25: {
                removedObject = StringsKt.replace$default(improvementName, "Remove ", "", false, 4, null);
                Iterable $this$firstOrNull$iv = tile.getTerrainFeatures();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it, removedObject)) continue;
                    v7 = element$iv;
                    break block25;
                }
                v7 = null;
            }
            String removedFeature = v7;
            String string = removedImprovement = Intrinsics.areEqual(removedObject, tile.getImprovement()) ? removedObject : null;
            if (removedFeature != null || removedImprovement != null) {
                TileImprovement wantedFinalImprovement;
                Tile newTile = tile.clone(false);
                newTile.setTerrainTransients();
                if (removedFeature != null) {
                    newTile.removeTerrainFeature(removedFeature);
                }
                if (removedImprovement != null) {
                    newTile.removeImprovement();
                }
                if ((wantedFinalImprovement = this.chooseImprovement(unit, newTile, localUniqueCache)) != null) {
                    Stats statDiff = TileStatFunctions.getStatDiffForImprovement$default(newTile.getStats(), wantedFinalImprovement, this.civInfo, newTile.getCity(), localUniqueCache, null, 16, null);
                    stats.add(statDiff);
                    isResourceImprovedByNewImprovement = newTile.getResource() != null && newTile.getTileResource().isImprovedBy(wantedFinalImprovement.getName());
                    if (!((Collection)tile.getTerrainFeatures()).isEmpty() && IHasUniques.hasUnique$default(tile.getLastTerrain(), UniqueType.ProductionBonusWhenRemoved, null, 2, null)) {
                        stats.add(Stat.Production, 0.5f);
                    }
                }
            }
        }
        if (!Intrinsics.areEqual(tile.getOwner(), unit.getCiv())) {
            stats.div(3.0f);
        }
        float value = Automation.INSTANCE.rankStatsValue(stats, unit.getCiv());
        if (tile.getResource() != null) {
            if (tile.getTileResource().getResourceType() != ResourceType.Bonus) {
                if (tile.getImprovement() != null) {
                    TileResource tileResource = tile.getTileResource();
                    String string = tile.getImprovement();
                    Intrinsics.checkNotNull(string);
                    if (tileResource.isImprovedBy(string)) {
                        value -= 2.0f;
                    }
                }
                if (isResourceImprovedByNewImprovement) {
                    value += 2.0f;
                }
            } else {
                if (tile.getImprovement() != null) {
                    TileResource tileResource = tile.getTileResource();
                    String string = tile.getImprovement();
                    Intrinsics.checkNotNull(string);
                    if (tileResource.isImprovedBy(string)) {
                        value -= 0.3f;
                    }
                }
                if (isResourceImprovedByNewImprovement) {
                    boolean bl5;
                    block26: {
                        Sequence<Tile> $this$none$iv = tile.getTilesInDistance(4);
                        boolean $i$f$none = false;
                        Iterator<Tile> iterator3 = $this$none$iv.iterator();
                        while (iterator3.hasNext()) {
                            Tile element$iv;
                            Tile it = element$iv = iterator3.next();
                            boolean bl6 = false;
                            TileImprovement tileImprovement3 = it.getTileImprovement();
                            if (!Intrinsics.areEqual(tileImprovement3 != null ? tileImprovement3.getName() : null, improvementName)) continue;
                            bl5 = false;
                            break block26;
                        }
                        bl5 = true;
                    }
                    if (bl5) {
                        value += 0.3f;
                    }
                }
            }
        }
        if (tile.getTileImprovement() == null) return value;
        TileImprovement tileImprovement4 = tile.getTileImprovement();
        Intrinsics.checkNotNull(tileImprovement4);
        if (!this.isImprovementProbablyAFort(tileImprovement4)) return value;
        value /= (float)2;
        return value;
    }

    static /* synthetic */ float getImprovementRanking$default(WorkerAutomation workerAutomation, Tile tile, MapUnit mapUnit, String string, LocalUniqueCache localUniqueCache, Stats stats, int n, Object object) {
        if ((n & 0x10) != 0) {
            stats = null;
        }
        return workerAutomation.getImprovementRanking(tile, mapUnit, string, localUniqueCache, stats);
    }

    @Readonly
    private final boolean isResourceImprovementAllowedOnFeature(Tile tile, Map<String, TileImprovement> potentialTileImprovements) {
        boolean bl;
        block9: {
            Iterable $this$any$iv = tile.getTileResource().getImprovements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        String resourceImprovementName = (String)element$iv;
                        boolean bl3 = false;
                        if (!potentialTileImprovements.containsKey(resourceImprovementName)) {
                            bl2 = false;
                        } else {
                            Intrinsics.checkNotNull(potentialTileImprovements.get(resourceImprovementName));
                            Iterable $this$any$iv2 = tile.getTerrainFeatureObjects();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    TileImprovement resourceImprovement;
                                    Terrain it = (Terrain)element$iv2;
                                    boolean bl4 = false;
                                    if (!resourceImprovement.isAllowedOnFeature(it)) continue;
                                    bl2 = true;
                                    break block8;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Readonly
    public final boolean isImprovementProbablyAFort(@NotNull TileImprovement improvement) {
        Intrinsics.checkNotNullParameter(improvement, "improvement");
        return IHasUniques.hasUnique$default(improvement, UniqueType.DefensiveBonus, null, 2, null);
    }

    public final boolean automateWorkBoats(@NotNull MapUnit unit) {
        Tile tile;
        block3: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Sequence<Tile> $this$sortedBy$iv = SequencesKt.filter(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), WorkerAutomation::automateWorkBoats$lambda$0), arg_0 -> WorkerAutomation.automateWorkBoats$lambda$1(unit, arg_0));
            boolean $i$f$sortedBy = false;
            Sequence<Tile> $this$firstOrNull$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator<Tile> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(unit.getMovement().canReach(it) && Companion.isNotBonusResourceOrWorkable(it, unit.getCiv()))) continue;
                tile = element$iv;
                break block3;
            }
            tile = null;
        }
        Tile tile2 = tile;
        if (tile2 == null) {
            return false;
        }
        Tile closestReachableResource = tile2;
        unit.getMovement().headTowards(closestReachableResource);
        if (!Intrinsics.areEqual(unit.getCurrentTile(), closestReachableResource)) {
            return true;
        }
        return UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.CreateImprovement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findTileToWork$lambda$0(MapUnit $unit, WorkerAutomation this$0, Set $tilesToAvoid, Tile $currentTile, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getOwner() != null && !Intrinsics.areEqual(it.getOwner(), $unit.getCiv())) {
            Civilization civilization = it.getOwner();
            Intrinsics.checkNotNull(civilization);
            if (!civilization.isCityState()) return false;
        }
        if (!this$0.isAutomationWorkableTile(it, $tilesToAvoid, $currentTile, $unit)) return false;
        if (!(this$0.getBasePriority(it, $unit) >= 0.0f)) return false;
        return true;
    }

    private static final Pair chooseImprovement$lambda$1(WorkerAutomation this$0, Tile $tile, MapUnit $unit, LocalUniqueCache $localUniqueCache, Stats $currentTileStats, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new Pair<TileImprovement, Float>(it, Float.valueOf(this$0.getImprovementRanking($tile, $unit, it.getName(), $localUniqueCache, $currentTileStats)));
    }

    private static final boolean chooseImprovement$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Number)it.getSecond()).floatValue() > 0.0f;
    }

    @Readonly
    private static final boolean chooseImprovement$isRemovable(Map<String, TileImprovement> potentialTileImprovements, Terrain terrain) {
        return potentialTileImprovements.containsKey("Remove " + terrain.getName());
    }

    private static final Sequence automateWorkBoats$lambda$0(City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        return city.getTiles();
    }

    private static final boolean automateWorkBoats$lambda$1(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Companion.hasWorkableSeaResource(it, $unit.getCiv()) && (Intrinsics.areEqual($unit.getCurrentTile(), it) || UnitMovement.canMoveTo$default($unit.getMovement(), it, false, false, false, 14, null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation$Companion;", "", "<init>", "()V", "hasWorkableSeaResource", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "isNotBonusResourceOrWorkable", "core"})
    @SourceDebugExtension(value={"SMAP\nWorkerAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,595:1\n1761#2,3:596\n1761#2,3:599\n*S KotlinDebug\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation$Companion\n*L\n578#1:596,3\n592#1:599,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Readonly
        public final boolean hasWorkableSeaResource(@NotNull Tile tile, @NotNull Civilization civInfo) {
            TileImprovement improvement;
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            if (!tile.isWater()) {
                return false;
            }
            if (tile.getResource() == null) {
                return false;
            }
            if (tile.getImprovement() != null) {
                TileResource tileResource = tile.getTileResource();
                String string = tile.getImprovement();
                Intrinsics.checkNotNull(string);
                if (tileResource.isImprovedBy(string)) {
                    return false;
                }
            }
            if (!tile.hasViewableResource(civInfo)) {
                return false;
            }
            Iterable $this$any$iv = tile.getTileResource().getImprovements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(civInfo.getGameInfo().getRuleset().getTileImprovements().get(it));
            } while (!tile.getImprovementFunctions().canBuildImprovement(improvement, civInfo.getState()));
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Readonly
        public final boolean isNotBonusResourceOrWorkable(@NotNull Tile tile, @NotNull Civilization civInfo) {
            City it;
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            if (tile.getTileResource().getResourceType() != ResourceType.Bonus) return true;
            Iterable $this$any$iv = civInfo.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (City)element$iv;
                boolean bl = false;
            } while (!it.getTilesInRange().contains(tile));
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J<\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "", "tilePriority", "", "improvementPriority", "bestImprovement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "repairImprovment", "", "<init>", "(FLjava/lang/Float;Lcom/unciv/models/ruleset/tile/TileImprovement;Ljava/lang/Boolean;)V", "getTilePriority", "()F", "getImprovementPriority", "()Ljava/lang/Float;", "setImprovementPriority", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "getBestImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "setBestImprovement", "(Lcom/unciv/models/ruleset/tile/TileImprovement;)V", "getRepairImprovment", "()Ljava/lang/Boolean;", "setRepairImprovment", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "component1", "component2", "component3", "component4", "copy", "(FLjava/lang/Float;Lcom/unciv/models/ruleset/tile/TileImprovement;Ljava/lang/Boolean;)Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "equals", "other", "hashCode", "", "toString", "", "core"})
    public static final class TileImprovementRank {
        private final float tilePriority;
        @Nullable
        private Float improvementPriority;
        @Nullable
        private TileImprovement bestImprovement;
        @Nullable
        private Boolean repairImprovment;

        public TileImprovementRank(float tilePriority, @Nullable Float improvementPriority, @Nullable TileImprovement bestImprovement, @Nullable Boolean repairImprovment) {
            this.tilePriority = tilePriority;
            this.improvementPriority = improvementPriority;
            this.bestImprovement = bestImprovement;
            this.repairImprovment = repairImprovment;
        }

        public /* synthetic */ TileImprovementRank(float f, Float f2, TileImprovement tileImprovement, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f2 = null;
            }
            if ((n & 4) != 0) {
                tileImprovement = null;
            }
            if ((n & 8) != 0) {
                bl = null;
            }
            this(f, f2, tileImprovement, bl);
        }

        public final float getTilePriority() {
            return this.tilePriority;
        }

        @Nullable
        public final Float getImprovementPriority() {
            return this.improvementPriority;
        }

        public final void setImprovementPriority(@Nullable Float f) {
            this.improvementPriority = f;
        }

        @Nullable
        public final TileImprovement getBestImprovement() {
            return this.bestImprovement;
        }

        public final void setBestImprovement(@Nullable TileImprovement tileImprovement) {
            this.bestImprovement = tileImprovement;
        }

        @Nullable
        public final Boolean getRepairImprovment() {
            return this.repairImprovment;
        }

        public final void setRepairImprovment(@Nullable Boolean bl) {
            this.repairImprovment = bl;
        }

        public final float component1() {
            return this.tilePriority;
        }

        @Nullable
        public final Float component2() {
            return this.improvementPriority;
        }

        @Nullable
        public final TileImprovement component3() {
            return this.bestImprovement;
        }

        @Nullable
        public final Boolean component4() {
            return this.repairImprovment;
        }

        @NotNull
        public final TileImprovementRank copy(float tilePriority, @Nullable Float improvementPriority, @Nullable TileImprovement bestImprovement, @Nullable Boolean repairImprovment) {
            return new TileImprovementRank(tilePriority, improvementPriority, bestImprovement, repairImprovment);
        }

        public static /* synthetic */ TileImprovementRank copy$default(TileImprovementRank tileImprovementRank, float f, Float f2, TileImprovement tileImprovement, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                f = tileImprovementRank.tilePriority;
            }
            if ((n & 2) != 0) {
                f2 = tileImprovementRank.improvementPriority;
            }
            if ((n & 4) != 0) {
                tileImprovement = tileImprovementRank.bestImprovement;
            }
            if ((n & 8) != 0) {
                bl = tileImprovementRank.repairImprovment;
            }
            return tileImprovementRank.copy(f, f2, tileImprovement, bl);
        }

        @NotNull
        public String toString() {
            return "TileImprovementRank(tilePriority=" + this.tilePriority + ", improvementPriority=" + this.improvementPriority + ", bestImprovement=" + this.bestImprovement + ", repairImprovment=" + this.repairImprovment + ')';
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.tilePriority);
            result2 = result2 * 31 + (this.improvementPriority == null ? 0 : ((Object)this.improvementPriority).hashCode());
            result2 = result2 * 31 + (this.bestImprovement == null ? 0 : this.bestImprovement.hashCode());
            result2 = result2 * 31 + (this.repairImprovment == null ? 0 : ((Object)this.repairImprovment).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TileImprovementRank)) {
                return false;
            }
            TileImprovementRank tileImprovementRank = (TileImprovementRank)other;
            if (Float.compare(this.tilePriority, tileImprovementRank.tilePriority) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.improvementPriority, (Object)tileImprovementRank.improvementPriority)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.bestImprovement, tileImprovementRank.bestImprovement)) {
                return false;
            }
            return Intrinsics.areEqual(this.repairImprovment, tileImprovementRank.repairImprovment);
        }
    }
}

