/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 b2\u00020\u0001:\u0001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010&\u001a\u00020!H\u0007J\u0006\u00108\u001a\u00020\u0000J$\u00109\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020;0:j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020;`<H\u0003J\u0010\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020\u0019H\u0007J\u000e\u0010?\u001a\u00020@2\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020;H\u0002J\u0010\u0010C\u001a\u00020@2\u0006\u0010B\u001a\u00020;H\u0002J\u000e\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020\u000fJ\u000e\u0010F\u001a\u00020@2\u0006\u0010E\u001a\u00020\u000fJ\b\u0010G\u001a\u00020\u000fH\u0007J*\u0010H\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u000f0(2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020;0J2\u0006\u0010K\u001a\u00020\u000fH\u0007J\u0010\u0010L\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0007J\u0018\u0010M\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aH\u0007J(\u0010N\u001a\b\u0012\u0004\u0012\u00020;0J2\u0006\u0010O\u001a\u00020\u00192\u0006\u0010P\u001a\u00020Q2\b\b\u0002\u0010R\u001a\u00020!H\u0007J\u0010\u0010S\u001a\u00020!2\u0006\u0010T\u001a\u00020\u0019H\u0007J\u001a\u0010U\u001a\u00020!2\u0006\u0010B\u001a\u00020;2\b\b\u0002\u0010V\u001a\u00020!H\u0007J\b\u0010W\u001a\u00020!H\u0007J\u0018\u0010X\u001a\u00020@2\u0006\u0010B\u001a\u00020;2\b\b\u0002\u0010Y\u001a\u00020!J\"\u0010Z\u001a\u00020@2\u0006\u0010B\u001a\u00020;2\b\b\u0002\u0010Y\u001a\u00020!2\b\b\u0002\u0010[\u001a\u00020!J\u001d\u0010\\\u001a\u0004\u0018\u00010\u000f2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020)0-H\u0007\u00a2\u0006\u0002\u0010^J\b\u0010_\u001a\u00020\u000fH\u0007J\u0010\u0010`\u001a\u00020@2\u0006\u0010E\u001a\u00020\u000fH\u0002J\u0010\u0010a\u001a\u00020!2\u0006\u0010V\u001a\u00020!H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001d\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u000f0(8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020)0-8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020)0-8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010/R\u001d\u00104\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u000f0(8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010+R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020)0-8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010/\u00a8\u0006c"}, d2={"Lcom/unciv/logic/civilization/managers/PolicyManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "policyUniques", "Lcom/unciv/models/ruleset/unique/UniqueMap;", "getPolicyUniques$core", "()Lcom/unciv/models/ruleset/unique/UniqueMap;", "freePolicies", "", "getFreePolicies", "()I", "setFreePolicies", "(I)V", "storedCulture", "getStoredCulture", "setStoredCulture", "adoptedPolicies", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getAdoptedPolicies$core", "()Ljava/util/HashSet;", "numberOfAdoptedPolicies", "cultureOfLast8Turns", "", "shouldOpenPolicyPicker", "", "getShouldOpenPolicyPicker", "()Z", "setShouldOpenPolicyPicker", "(Z)V", "shouldShowPolicyPicker", "priorityMap", "", "Lcom/unciv/models/ruleset/PolicyBranch;", "getPriorityMap", "()Ljava/util/Map;", "adoptableBranches", "", "getAdoptableBranches", "()Ljava/util/Set;", "incompleteBranches", "getIncompleteBranches", "completedBranches", "getCompletedBranches", "branchCompletionMap", "getBranchCompletionMap", "branches", "getBranches", "clone", "getRulesetPolicies", "Ljava/util/LinkedHashMap;", "Lcom/unciv/models/ruleset/Policy;", "Lkotlin/collections/LinkedHashMap;", "getPolicyByName", "name", "setTransients", "", "addPolicyToTransients", "policy", "removePolicyFromTransients", "addCulture", "culture", "endTurn", "getCultureNeededForNextPolicy", "getCultureRefundMap", "policiesToRemove", "Lkotlin/sequences/Sequence;", "refundPercentage", "getPolicyCultureCost", "getAdoptedPolicies", "getAdoptedPoliciesMatching", "policyFilter", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "forRemoval", "isAdopted", "policyName", "isAdoptable", "checkEra", "canAdoptPolicy", "adopt", "branchCompletion", "removePolicy", "assumeWasFree", "getMaxPriority", "branchesToCompare", "(Ljava/util/Set;)Ljava/lang/Integer;", "getCultureFromGreatWriter", "addCurrentCultureToCultureOfLast8Turns", "allPoliciesAdopted", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPolicyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolicyManager.kt\ncom/unciv/logic/civilization/managers/PolicyManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,342:1\n1#2:343\n774#3:344\n865#3,2:345\n1761#3,3:347\n1740#3,3:350\n1788#3,4:353\n1788#3,4:357\n1788#3,4:364\n1788#3,4:368\n2746#3,3:379\n622#4:361\n1255#4,2:362\n488#5,7:372\n*S KotlinDebug\n*F\n+ 1 PolicyManager.kt\ncom/unciv/logic/civilization/managers/PolicyManager\n*L\n61#1:344\n61#1:345,2\n67#1:347,3\n76#1:350,3\n85#1:353,4\n173#1:357,4\n260#1:364,4\n305#1:368,4\n340#1:379,3\n208#1:361\n227#1:362,2\n325#1:372,7\n*E\n"})
public final class PolicyManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public transient Civilization civInfo;
    @NotNull
    private final transient UniqueMap policyUniques = new UniqueMap();
    private int freePolicies;
    private int storedCulture;
    @NotNull
    private final HashSet<String> adoptedPolicies = new HashSet();
    private int numberOfAdoptedPolicies;
    @NotNull
    private int[] cultureOfLast8Turns = new int[8];
    private boolean shouldOpenPolicyPicker;
    public static final int FREE_POLICY_MARKER = -1;

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    @NotNull
    public final UniqueMap getPolicyUniques$core() {
        return this.policyUniques;
    }

    public final int getFreePolicies() {
        return this.freePolicies;
    }

    public final void setFreePolicies(int n) {
        this.freePolicies = n;
    }

    public final int getStoredCulture() {
        return this.storedCulture;
    }

    public final void setStoredCulture(int n) {
        this.storedCulture = n;
    }

    @NotNull
    public final HashSet<String> getAdoptedPolicies$core() {
        return this.adoptedPolicies;
    }

    public final boolean getShouldOpenPolicyPicker() {
        return this.shouldOpenPolicyPicker;
    }

    public final void setShouldOpenPolicyPicker(boolean bl) {
        this.shouldOpenPolicyPicker = bl;
    }

    @Readonly
    public final boolean shouldShowPolicyPicker() {
        return (this.shouldOpenPolicyPicker || this.freePolicies > 0) && this.canAdoptPolicy();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<PolicyBranch, Integer> getPriorityMap() {
        HashMap value = new HashMap();
        for (PolicyBranch branch : this.getBranches()) {
            Iterable iterable = this.getCivInfo().getPreferredVictoryTypes();
            int n = 0;
            for (Object t : iterable) {
                void it;
                String string = (String)t;
                int n2 = n;
                boolean bl = false;
                Integer n3 = branch.getPriorities().get(it);
                int n4 = n3 != null ? n3 : 0;
                n = n2 + n4;
            }
            int victoryPriority = n;
            Integer n5 = this.getCivInfo().getPersonality().getPriorities().get(branch.getName());
            int personalityPriority = n5 != null ? n5 : 0;
            float branchPriority = (float)(victoryPriority + personalityPriority) * branch.getWeightForAiDecision(this.getCivInfo().getState());
            ((Map)value).put(branch, MathKt.roundToInt(branchPriority));
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<PolicyBranch> getAdoptableBranches() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getBranches();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PolicyBranch it = (PolicyBranch)element$iv$iv;
            boolean bl = false;
            if (!PolicyManager.isAdoptable$default(this, it, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @NotNull
    public final Set<PolicyBranch> getIncompleteBranches() {
        HashSet<PolicyBranch> value = new HashSet<PolicyBranch>();
        for (PolicyBranch branch : this.getBranches()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = branch.getPolicies();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Policy it = (Policy)element$iv;
                        boolean bl2 = false;
                        if (!PolicyManager.isAdoptable$default(this, it, false, 2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            value.add(branch);
        }
        return value;
    }

    @NotNull
    public final Set<PolicyBranch> getCompletedBranches() {
        HashSet<PolicyBranch> value = new HashSet<PolicyBranch>();
        for (PolicyBranch branch : this.getBranches()) {
            boolean bl;
            block4: {
                Iterable $this$all$iv = branch.getPolicies();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Policy it = (Policy)element$iv;
                        boolean bl2 = false;
                        if (this.isAdopted(it.getName())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            value.add(branch);
        }
        return value;
    }

    @NotNull
    public final Map<PolicyBranch, Integer> getBranchCompletionMap() {
        HashMap value = new HashMap();
        for (PolicyBranch branch : this.getBranches()) {
            int n;
            Map map2 = value;
            Iterable $this$count$iv = this.adoptedPolicies;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!branch.getPolicies().contains(this.getPolicyByName(it)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            Integer n2 = n;
            map2.put(branch, n2);
        }
        return value;
    }

    @NotNull
    public final Set<PolicyBranch> getBranches() {
        Collection<PolicyBranch> collection = this.getCivInfo().getGameInfo().getRuleset().getPolicyBranches().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @NotNull
    public final PolicyManager clone() {
        PolicyManager toReturn = new PolicyManager();
        toReturn.numberOfAdoptedPolicies = this.numberOfAdoptedPolicies;
        toReturn.adoptedPolicies.addAll((Collection<String>)this.adoptedPolicies);
        toReturn.freePolicies = this.freePolicies;
        toReturn.shouldOpenPolicyPicker = this.shouldOpenPolicyPicker;
        toReturn.storedCulture = this.storedCulture;
        toReturn.cultureOfLast8Turns = (int[])this.cultureOfLast8Turns.clone();
        return toReturn;
    }

    @Readonly
    private final LinkedHashMap<String, Policy> getRulesetPolicies() {
        return this.getCivInfo().getGameInfo().getRuleset().getPolicies();
    }

    @Readonly
    @NotNull
    public final Policy getPolicyByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Policy policy = this.getRulesetPolicies().get(name);
        Intrinsics.checkNotNull(policy);
        return policy;
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.setCivInfo(civInfo);
        Iterator<String> iterator2 = this.adoptedPolicies.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String policyName;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            this.addPolicyToTransients(this.getPolicyByName(policyName));
        }
    }

    private final void addPolicyToTransients(Policy policy) {
        for (Unique unique : policy.getUniqueObjects()) {
            this.policyUniques.addUnique(unique);
        }
    }

    private final void removePolicyFromTransients(Policy policy) {
        for (Unique unique : policy.getUniqueObjects()) {
            this.policyUniques.removeUnique(unique);
        }
    }

    public final void addCulture(int culture) {
        boolean couldAdoptPolicyBefore = this.canAdoptPolicy();
        this.storedCulture += culture;
        if (!couldAdoptPolicyBefore && this.canAdoptPolicy()) {
            this.shouldOpenPolicyPicker = true;
        }
    }

    public final void endTurn(int culture) {
        this.addCulture(culture);
        this.addCurrentCultureToCultureOfLast8Turns(culture);
    }

    @Readonly
    public final int getCultureNeededForNextPolicy() {
        return this.getPolicyCultureCost(this.numberOfAdoptedPolicies);
    }

    @Readonly
    @NotNull
    public final Map<Policy, Integer> getCultureRefundMap(@NotNull Sequence<? extends Policy> policiesToRemove, int refundPercentage) {
        Intrinsics.checkNotNullParameter(policiesToRemove, "policiesToRemove");
        int policyCostInput = this.numberOfAdoptedPolicies;
        Map policyMap = new LinkedHashMap();
        Iterator<? extends Policy> iterator2 = policiesToRemove.iterator();
        while (iterator2.hasNext()) {
            Policy policy = iterator2.next();
            if (policy.getPolicyBranchType() == Policy.PolicyBranchType.BranchComplete) continue;
            policyMap.put(policy, --policyCostInput < 0 ? -1 : MathKt.roundToInt((float)(this.getPolicyCultureCost(policyCostInput) * refundPercentage) / 100.0f));
        }
        return policyMap;
    }

    @Readonly
    public final int getPolicyCultureCost(int numberOfAdoptedPolicies) {
        int n;
        Iterator $this$count$iv;
        double policyCultureCost = (double)25 + Math.pow(numberOfAdoptedPolicies * 6, 1.7);
        float worldSizeModifier = this.getCivInfo().getGameInfo().getTileMap().getMapParameters().getMapSize().getPredefinedOrNextSmaller().getPolicyCostPerCityModifier();
        Iterable iterable = this.getCivInfo().getCities();
        float f = worldSizeModifier;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)((Object)$this$count$iv)).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                City it = (City)element$iv;
                boolean bl = false;
                if (!(!it.isPuppet()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = n;
        float cityModifier = f * (float)(n2 - 1);
        $this$count$iv = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.LessPolicyCostFromCities, null, 2, null).iterator();
        while ($this$count$iv.hasNext()) {
            Unique unique = (Unique)$this$count$iv.next();
            cityModifier *= 1.0f - Float.parseFloat(unique.getParams().get(0)) / (float)100;
        }
        $this$count$iv = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.LessPolicyCost, null, 2, null).iterator();
        while ($this$count$iv.hasNext()) {
            Unique unique = (Unique)$this$count$iv.next();
            policyCultureCost *= (double)FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        if (this.getCivInfo().isHuman()) {
            policyCultureCost *= (double)this.getCivInfo().getDifficulty().getPolicyCostModifier();
        }
        int cost = MathKt.roundToInt((policyCultureCost *= (double)this.getCivInfo().getGameInfo().getSpeed().getCultureCostModifier()) * (double)(1.0f + cityModifier));
        return cost - cost % 5;
    }

    @Readonly
    @NotNull
    public final HashSet<String> getAdoptedPolicies() {
        return this.adoptedPolicies;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final Sequence<Policy> getAdoptedPoliciesMatching(@NotNull String policyFilter, @NotNull GameContext gameContext, boolean forRemoval) {
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter(policyFilter, "policyFilter");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        LinkedHashMap<String, Policy> rulesetPolicies = this.getRulesetPolicies();
        Sequence<Policy> matchingPolicies = SequencesKt.filter(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)this.adoptedPolicies), arg_0 -> PolicyManager.getAdoptedPoliciesMatching$lambda$0(rulesetPolicies, arg_0)), arg_0 -> PolicyManager.getAdoptedPoliciesMatching$lambda$1(policyFilter, gameContext, arg_0));
        if (!forRemoval) {
            return matchingPolicies;
        }
        Sequence<Policy> sequence = SequencesKt.filterNot(matchingPolicies, PolicyManager::getAdoptedPoliciesMatching$lambda$2);
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(rulesetPolicies){
            final /* synthetic */ LinkedHashMap $rulesetPolicies$inlined;
            {
                this.$rulesetPolicies$inlined = linkedHashMap;
            }

            public final int compare(T a, T b) {
                Policy it = (Policy)b;
                boolean bl = false;
                Collection<V> collection = this.$rulesetPolicies$inlined.values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                Comparable comparable = Integer.valueOf(CollectionsKt.indexOf((Iterable)collection, it));
                it = (Policy)a;
                Comparable comparable2 = comparable;
                bl = false;
                Collection<V> collection2 = this.$rulesetPolicies$inlined.values();
                Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
                return ComparisonsKt.compareValues(comparable2, CollectionsKt.indexOf((Iterable)collection2, it));
            }
        });
    }

    public static /* synthetic */ Sequence getAdoptedPoliciesMatching$default(PolicyManager policyManager, String string, GameContext gameContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return policyManager.getAdoptedPoliciesMatching(string, gameContext, bl);
    }

    @Readonly
    public final boolean isAdopted(@NotNull String policyName) {
        Intrinsics.checkNotNullParameter(policyName, "policyName");
        return this.adoptedPolicies.contains(policyName);
    }

    @Readonly
    public final boolean isAdoptable(@NotNull Policy policy, boolean checkEra) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(policy, "policy");
            if (this.isAdopted(policy.getName())) {
                return false;
            }
            if (policy.getPolicyBranchType() == Policy.PolicyBranchType.BranchComplete) {
                return false;
            }
            HashSet<String> hashSet = this.getAdoptedPolicies();
            ArrayList<String> arrayList = policy.getRequires();
            Intrinsics.checkNotNull(arrayList);
            if (!hashSet.containsAll((Collection)arrayList)) {
                return false;
            }
            if (checkEra) {
                Era era = this.getCivInfo().getGameInfo().getRuleset().getEras().get(policy.getBranch().getEra());
                Intrinsics.checkNotNull(era);
                if (era.getEraNumber() > this.getCivInfo().getEraNumber()) {
                    return false;
                }
            }
            Sequence<Unique> $this$any$iv = policy.getMatchingUniques(UniqueType.OnlyAvailable, GameContext.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            Iterator<Unique> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Unique element$iv;
                Unique it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(!it.conditionalsApply(this.getCivInfo().getState()))) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        return !policy.hasUnique(UniqueType.Unavailable, this.getCivInfo().getState());
    }

    public static /* synthetic */ boolean isAdoptable$default(PolicyManager policyManager, Policy policy, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return policyManager.isAdoptable(policy, bl);
    }

    @Readonly
    public final boolean canAdoptPolicy() {
        if (this.getCivInfo().isSpectator()) {
            return false;
        }
        if (this.freePolicies == 0 && this.storedCulture < this.getCultureNeededForNextPolicy()) {
            return false;
        }
        return !this.allPoliciesAdopted(true);
    }

    public final void adopt(@NotNull Policy policy, boolean branchCompletion) {
        Intrinsics.checkNotNullParameter(policy, "policy");
        if (!branchCompletion) {
            if (this.freePolicies > 0) {
                int n = this.freePolicies;
                this.freePolicies = n + -1;
            } else if (!this.getCivInfo().getGameInfo().getGameParameters().getGodMode()) {
                int cultureNeededForNextPolicy = this.getCultureNeededForNextPolicy();
                if (cultureNeededForNextPolicy > this.storedCulture) {
                    throw new Exception("Trying to adopt a policy without enough culture????");
                }
                this.storedCulture -= cultureNeededForNextPolicy;
                int n = this.numberOfAdoptedPolicies;
                this.numberOfAdoptedPolicies = n + 1;
            }
        }
        this.adoptedPolicies.add(policy.getName());
        this.addPolicyToTransients(policy);
        if (!branchCompletion) {
            int n;
            PolicyBranch branch = policy.getBranch();
            Iterable $this$count$iv = branch.getPolicies();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl = false;
                    if (!this.isAdopted(it.getName()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n == branch.getPolicies().size() - 1) {
                this.adopt((Policy)CollectionsKt.last((List)branch.getPolicies()), true);
            }
        }
        String triggerNotificationText = "due to adopting [" + policy.getName() + ']';
        for (Unique unique : policy.getUniqueObjects()) {
            if (!unique.isTriggerable() || unique.hasTriggerConditional() || !unique.conditionalsApply(this.getCivInfo().getState())) continue;
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, triggerNotificationText, 60, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponAdoptingPolicyOrBelief, null, arg_0 -> PolicyManager.adopt$lambda$1(policy, arg_0), 2, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, triggerNotificationText, 60, null);
        }
        this.getCivInfo().getCache().updateCivResources();
        for (City city : this.getCivInfo().getCities()) {
            CityStats.update$default(city.getCityStats(), null, false, false, null, false, 31, null);
            city.reassignPopulationDeferred();
        }
        if (!this.canAdoptPolicy()) {
            this.shouldOpenPolicyPicker = false;
        }
    }

    public static /* synthetic */ void adopt$default(PolicyManager policyManager, Policy policy, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        policyManager.adopt(policy, bl);
    }

    public final void removePolicy(@NotNull Policy policy, boolean branchCompletion, boolean assumeWasFree) {
        Intrinsics.checkNotNullParameter(policy, "policy");
        if (!this.adoptedPolicies.remove(policy.getName())) {
            throw new IllegalStateException("Attempt to remove non-adopted Policy " + policy.getName());
        }
        if (!assumeWasFree && this.numberOfAdoptedPolicies > 0) {
            --this.numberOfAdoptedPolicies;
        }
        this.removePolicyFromTransients(policy);
        if (!branchCompletion) {
            int n;
            PolicyBranch branch = policy.getBranch();
            Iterable $this$count$iv = branch.getPolicies();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl = false;
                    if (!this.isAdopted(it.getName()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n == branch.getPolicies().size() - 1) {
                PolicyManager.removePolicy$default(this, (Policy)CollectionsKt.last((List)branch.getPolicies()), true, false, 4, null);
            }
        }
        this.getCivInfo().getCache().updateCivResources();
        for (City city : this.getCivInfo().getCities()) {
            CityStats.update$default(city.getCityStats(), null, false, false, null, false, 31, null);
            city.reassignPopulationDeferred();
        }
    }

    public static /* synthetic */ void removePolicy$default(PolicyManager policyManager, Policy policy, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        policyManager.removePolicy(policy, bl, bl2);
    }

    @Readonly
    @Nullable
    public final Integer getMaxPriority(@NotNull Set<PolicyBranch> branchesToCompare) {
        Intrinsics.checkNotNullParameter(branchesToCompare, "branchesToCompare");
        Map<PolicyBranch, Integer> $this$filterKeys$iv = this.getPriorityMap();
        boolean $i$f$filterKeys = false;
        LinkedHashMap<PolicyBranch, Integer> result$iv = new LinkedHashMap<PolicyBranch, Integer>();
        for (Map.Entry<PolicyBranch, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
            PolicyBranch branch = entry$iv.getKey();
            boolean bl = false;
            if (!branchesToCompare.contains(branch)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map filteredMap = result$iv;
        return (Integer)CollectionsKt.maxOrNull(filteredMap.values());
    }

    @Readonly
    public final int getCultureFromGreatWriter() {
        return (int)((float)ArraysKt.sum(this.cultureOfLast8Turns) * this.getCivInfo().getGameInfo().getSpeed().getCultureCostModifier());
    }

    private final void addCurrentCultureToCultureOfLast8Turns(int culture) {
        this.cultureOfLast8Turns[this.getCivInfo().getGameInfo().getTurns() % 8] = culture;
    }

    @Readonly
    public final boolean allPoliciesAdopted(boolean checkEra) {
        boolean bl;
        block3: {
            Collection<Policy> collection = this.getRulesetPolicies().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it);
                    if (!this.isAdoptable(it, checkEra)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final Policy getAdoptedPoliciesMatching$lambda$0(LinkedHashMap $rulesetPolicies, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Policy)$rulesetPolicies.get(it);
    }

    private static final boolean getAdoptedPoliciesMatching$lambda$1(String $policyFilter, GameContext $gameContext, Policy it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.matchesFilter($policyFilter, $gameContext);
    }

    private static final boolean getAdoptedPoliciesMatching$lambda$2(Policy it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPolicyBranchType() == Policy.PolicyBranchType.BranchComplete;
    }

    private static final boolean adopt$lambda$1(Policy $policy, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getParams().get(0), $policy.getName());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/civilization/managers/PolicyManager$Companion;", "", "<init>", "()V", "FREE_POLICY_MARKER", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

