/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001c\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ5\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\fH\u0007J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0007J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0007J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0003J\u0018\u0010\r\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\b\b\u0002\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nJ\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0007J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0007J\u0006\u0010&\u001a\u00020\"J\u0012\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020\fH\u0007J\u0014\u0010)\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\nJ\u0016\u0010+\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/unciv/logic/civilization/managers/UnitManager;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "unitList", "", "Lcom/unciv/logic/map/mapunit/MapUnit;", "nextPotentiallyDueAt", "", "addUnit", "unitName", "", "city", "Lcom/unciv/logic/city/City;", "baseUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "placeUnitNearTile", "location", "Lcom/unciv/logic/map/HexCoord;", "unitId", "copiedFrom", "(Lcom/unciv/logic/map/HexCoord;Lcom/unciv/models/ruleset/unit/BaseUnit;Ljava/lang/Integer;Lcom/unciv/logic/map/mapunit/MapUnit;)Lcom/unciv/logic/map/mapunit/MapUnit;", "getCivUnitsSize", "getCivUnits", "Lkotlin/sequences/Sequence;", "getCivGreatPeople", "getCivUnitsStartingAtNextDue", "", "mapUnit", "updateCivInfo", "", "removeUnit", "getIdleUnits", "getDueUnits", "shouldGoToDueUnit", "getUnitById", "id", "cycleThroughDueUnits", "unitToSkip", "alternateCycleThroughDueUnits", "core"})
@SourceDebugExtension(value={"SMAP\nUnitManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitManager.kt\ncom/unciv/logic/civilization/managers/UnitManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,231:1\n827#2:232\n855#2,2:233\n774#2:235\n865#2,2:236\n774#2:238\n865#2,2:239\n774#2:243\n865#2,2:244\n2423#2,14:246\n183#3,2:241\n*S KotlinDebug\n*F\n+ 1 UnitManager.kt\ncom/unciv/logic/civilization/managers/UnitManager\n*L\n58#1:232\n58#1:233,2\n65#1:235\n65#1:236,2\n66#1:238\n66#1:239,2\n224#1:243\n224#1:244,2\n225#1:246,14\n189#1:241,2\n*E\n"})
public final class UnitManager {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private List<MapUnit> unitList;
    private int nextPotentiallyDueAt;

    public UnitManager(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.unitList = CollectionsKt.emptyList();
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    @Nullable
    public final MapUnit addUnit(@NotNull String unitName, @Nullable City city) {
        Intrinsics.checkNotNullParameter(unitName, "unitName");
        BaseUnit baseUnit = this.civInfo.getGameInfo().getRuleset().getUnits().get(unitName);
        if (baseUnit == null) {
            return null;
        }
        BaseUnit unit = baseUnit;
        return this.addUnit(unit, city);
    }

    public static /* synthetic */ MapUnit addUnit$default(UnitManager unitManager, String string, City city, int n, Object object) {
        if ((n & 2) != 0) {
            city = null;
        }
        return unitManager.addUnit(string, city);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MapUnit addUnit(@NotNull BaseUnit baseUnit, @Nullable City city) {
        MapUnit placedUnit;
        block17: {
            City cityToAddTo;
            block18: {
                City city2;
                void $this$filterNotTo$iv$iv;
                Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
                if (this.civInfo.getCities().isEmpty()) {
                    return null;
                }
                BaseUnit unit = this.civInfo.getEquivalentUnit(baseUnit);
                Iterable $this$filterNot$iv = this.civInfo.getCities();
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    City it = (City)element$iv$iv;
                    boolean bl = false;
                    if (it.isInResistance()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List citiesNotInResistance = (List)destination$iv$iv;
                City city3 = city;
                boolean canSpawnUnitOnWater = city3 != null ? city3.isNaval() : false;
                if (unit.isWaterUnit() && canSpawnUnitOnWater) {
                    city2 = city;
                } else if (unit.isWaterUnit()) {
                    City it;
                    Iterable $this$filterTo$iv$iv;
                    Object element$iv$iv;
                    Iterable $this$filter$iv = citiesNotInResistance;
                    boolean $i$f$filter = false;
                    element$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        it = (City)element$iv$iv2;
                        boolean bl = false;
                        if (!it.isNaval()) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    city2 = (City)CollectionsKt.randomOrNull((List)destination$iv$iv2, Random.Default);
                    if (city2 == null) {
                        $this$filter$iv = this.civInfo.getCities();
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv2 = new ArrayList();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                            it = (City)element$iv$iv2;
                            boolean bl = false;
                            if (!it.isNaval()) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        city2 = (City)CollectionsKt.randomOrNull((List)destination$iv$iv2, Random.Default);
                    }
                } else {
                    city2 = city;
                    if (city2 == null && (city2 = (City)CollectionsKt.randomOrNull(citiesNotInResistance, Random.Default)) == null) {
                        city2 = (City)CollectionsKt.random((Collection)this.civInfo.getCities(), Random.Default);
                    }
                }
                if (city2 == null) {
                    return null;
                }
                cityToAddTo = city2;
                MapUnit mapUnit = this.placeUnitNearTile(cityToAddTo.getLocation().toHexCoord(), unit.getName());
                if (mapUnit == null) {
                    return null;
                }
                placedUnit = mapUnit;
                if (unit.isGreatPerson()) {
                    String[] stringArray = new String[]{unit.getName()};
                    this.civInfo.addNotification("A [" + unit.getName() + "] has been born in [" + cityToAddTo.getName() + "]!", new MapUnitAction(placedUnit), Notification.NotificationCategory.General, stringArray);
                    this.civInfo.getQuestManager().handleIndividualQuests();
                }
                if (!MapUnit.hasUnique$default(placedUnit, UniqueType.ReligiousUnit, null, false, 6, null) || !this.civInfo.getGameInfo().isReligionEnabled()) break block17;
                if (!MapUnit.hasUnique$default(placedUnit, UniqueType.TakeReligionOverBirthCity, null, false, 6, null)) break block18;
                Religion religion = this.civInfo.getReligionManager().getReligion();
                boolean bl = religion != null ? !religion.isMajorReligion() : false;
                if (!bl) break block17;
            }
            placedUnit.setReligion(cityToAddTo.getReligion().getMajorityReligionName());
        }
        return placedUnit;
    }

    public static /* synthetic */ MapUnit addUnit$default(UnitManager unitManager, BaseUnit baseUnit, City city, int n, Object object) {
        if ((n & 2) != 0) {
            city = null;
        }
        return unitManager.addUnit(baseUnit, city);
    }

    @Nullable
    public final MapUnit placeUnitNearTile(@NotNull HexCoord location, @NotNull String unitName) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(unitName, "unitName");
        BaseUnit baseUnit = this.civInfo.getGameInfo().getRuleset().getUnits().get(unitName);
        Intrinsics.checkNotNull(baseUnit);
        BaseUnit unit = baseUnit;
        return UnitManager.placeUnitNearTile$default(this, location, unit, null, null, 12, null);
    }

    @Nullable
    public final MapUnit placeUnitNearTile(@NotNull HexCoord location, @NotNull BaseUnit baseUnit, @Nullable Integer unitId, @Nullable MapUnit copiedFrom) {
        Unique unique2;
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        MapUnit unit = this.civInfo.getGameInfo().getTileMap().placeUnitNearTile(location, baseUnit, this.civInfo, unitId);
        if (unit == null) {
            return unit;
        }
        MapUnit mapUnit = copiedFrom;
        if (mapUnit != null) {
            mapUnit.copyStatisticsTo(unit);
        }
        String triggerNotificationText = "due to gaining a [" + unit.getName() + ']';
        Iterator<Unique> iterator2 = unit.getUniques().iterator();
        while (iterator2.hasNext()) {
            unique2 = iterator2.next();
            if (unique2.hasTriggerConditional() || unique2.getSourceObjectType() == UniqueTarget.Promotion || !unique2.conditionalsApply(unit.getCache().getState())) continue;
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, unit, null, triggerNotificationText, 4, null);
        }
        for (Unique unique2 : this.civInfo.getTriggeredUniques(UniqueType.TriggerUponGainingUnit, unit.getCache().getState(), arg_0 -> UnitManager.placeUnitNearTile$lambda$0(unit, arg_0))) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, unit, null, triggerNotificationText, 4, null);
        }
        if (!((Map)unit.getResourceRequirementsPerTurn()).isEmpty()) {
            this.civInfo.getCache().updateCivResources();
        }
        iterator2 = this.civInfo.getMatchingUniques(UniqueType.LandUnitsCrossTerrainAfterUnitGained, unit.getCache().getState()).iterator();
        while (iterator2.hasNext()) {
            unique2 = iterator2.next();
            if (!MapUnit.matchesFilter$default(unit, unique2.getParams().get(1), false, 2, null)) continue;
            this.civInfo.setPassThroughImpassableUnlocked(true);
            this.civInfo.getPassableImpassables().add(unique2.getParams().get(0));
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.ReligiousUnit, null, false, 6, null) && this.civInfo.getGameInfo().isReligionEnabled()) {
            Religion religion = this.civInfo.getReligionManager().getReligion();
            unit.setReligion(religion != null ? religion.getName() : null);
        }
        return unit;
    }

    public static /* synthetic */ MapUnit placeUnitNearTile$default(UnitManager unitManager, HexCoord hexCoord, BaseUnit baseUnit, Integer n, MapUnit mapUnit, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            mapUnit = null;
        }
        return unitManager.placeUnitNearTile(hexCoord, baseUnit, n, mapUnit);
    }

    @Readonly
    public final int getCivUnitsSize() {
        return this.unitList.size();
    }

    @Readonly
    @NotNull
    public final Sequence<MapUnit> getCivUnits() {
        return CollectionsKt.asSequence((Iterable)this.unitList);
    }

    @Readonly
    @NotNull
    public final Sequence<MapUnit> getCivGreatPeople() {
        return SequencesKt.filter(this.getCivUnits(), UnitManager::getCivGreatPeople$lambda$0);
    }

    @Readonly
    private final Sequence<MapUnit> getCivUnitsStartingAtNextDue() {
        return SequencesKt.flattenSequenceOfIterable(SequencesKt.sequenceOf(CollectionsKt.plus((Collection)this.unitList.subList(this.nextPotentiallyDueAt, this.unitList.size()), (Iterable)this.unitList.subList(0, this.nextPotentiallyDueAt))));
    }

    public final void addUnit(@NotNull MapUnit mapUnit, boolean updateCivInfo) {
        Intrinsics.checkNotNullParameter(mapUnit, "mapUnit");
        List<MapUnit> newList = SequencesKt.toMutableList(this.getCivUnitsStartingAtNextDue());
        newList.add(mapUnit);
        this.unitList = newList;
        this.nextPotentiallyDueAt = 0;
        if (updateCivInfo) {
            this.civInfo.updateStatsForNextTurn();
            if (!((Map)mapUnit.getResourceRequirementsPerTurn()).isEmpty()) {
                this.civInfo.getCache().updateCivResources();
            }
        }
    }

    public static /* synthetic */ void addUnit$default(UnitManager unitManager, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        unitManager.addUnit(mapUnit, bl);
    }

    public final void removeUnit(@NotNull MapUnit mapUnit) {
        Intrinsics.checkNotNullParameter(mapUnit, "mapUnit");
        List<MapUnit> newList = SequencesKt.toMutableList(this.getCivUnitsStartingAtNextDue());
        newList.remove(mapUnit);
        this.unitList = newList;
        this.nextPotentiallyDueAt = 0;
        this.civInfo.updateStatsForNextTurn();
        if (!((Map)mapUnit.getResourceRequirementsPerTurn()).isEmpty()) {
            this.civInfo.getCache().updateCivResources();
        }
    }

    @Readonly
    @NotNull
    public final Sequence<MapUnit> getIdleUnits() {
        return SequencesKt.filter(this.getCivUnits(), UnitManager::getIdleUnits$lambda$0);
    }

    @Readonly
    @NotNull
    public final Sequence<MapUnit> getDueUnits() {
        return SequencesKt.filter(this.getCivUnitsStartingAtNextDue(), UnitManager::getDueUnits$lambda$0);
    }

    public final boolean shouldGoToDueUnit() {
        return UncivGame.Companion.getCurrent().getSettings().getCheckForDueUnits() && SequencesKt.any(this.getDueUnits());
    }

    @Readonly
    @Nullable
    public final MapUnit getUnitById(int id) {
        MapUnit mapUnit;
        block1: {
            Sequence<MapUnit> $this$firstOrNull$iv = this.getCivUnits();
            boolean $i$f$firstOrNull = false;
            Iterator<MapUnit> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(it.getId() == id)) continue;
                mapUnit = element$iv;
                break block1;
            }
            mapUnit = null;
        }
        return mapUnit;
    }

    @Nullable
    public final MapUnit cycleThroughDueUnits(@Nullable MapUnit unitToSkip) {
        if (CollectionsKt.none((Iterable)this.unitList)) {
            return null;
        }
        if (GUI.INSTANCE.getSettings().getAlternateUnitCycleOrder()) {
            return this.alternateCycleThroughDueUnits(unitToSkip);
        }
        int returnAt = this.nextPotentiallyDueAt;
        int fallbackAt = -1;
        do {
            if (!this.unitList.get(returnAt).getDue() || !MapUnit.isIdle$default(this.unitList.get(returnAt), false, 1, null)) continue;
            if (!Intrinsics.areEqual(this.unitList.get(returnAt), unitToSkip)) {
                this.nextPotentiallyDueAt = (returnAt + 1) % this.unitList.size();
                return this.unitList.get(returnAt);
            }
            fallbackAt = returnAt;
        } while ((returnAt = (returnAt + 1) % this.unitList.size()) != this.nextPotentiallyDueAt);
        if (fallbackAt >= 0) {
            this.nextPotentiallyDueAt = (fallbackAt + 1) % this.unitList.size();
            return this.unitList.get(fallbackAt);
        }
        return null;
    }

    public static /* synthetic */ MapUnit cycleThroughDueUnits$default(UnitManager unitManager, MapUnit mapUnit, int n, Object object) {
        if ((n & 1) != 0) {
            mapUnit = null;
        }
        return unitManager.cycleThroughDueUnits(mapUnit);
    }

    /*
     * WARNING - void declaration
     */
    private final MapUnit alternateCycleThroughDueUnits(MapUnit unitToSkip) {
        Object v2;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = unitToSkip;
        if (isPartOfGameInfoSerialization == null || (isPartOfGameInfoSerialization = isPartOfGameInfoSerialization.getCurrentTile()) == null) {
            City city = this.civInfo.getCapital(true);
            isPartOfGameInfoSerialization = city != null ? city.getCenterTile() : this.civInfo.getGameInfo().getTileMap().get(0, 0);
        }
        IsPartOfGameInfoSerialization center = isPartOfGameInfoSerialization;
        Iterable iterable = CollectionsKt.withIndex((Iterable)this.unitList);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            if (!(((MapUnit)it.getValue()).getDue() && !Intrinsics.areEqual(it.getValue(), unitToSkip) && MapUnit.isIdle$default((MapUnit)it.getValue(), false, 1, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                IndexedValue it = (IndexedValue)minElem$iv;
                boolean bl = false;
                int minValue$iv = ((MapUnit)it.getValue()).getCurrentTile().aerialDistanceTo((Tile)center);
                do {
                    Object e$iv = iterator$iv.next();
                    IndexedValue it2 = (IndexedValue)e$iv;
                    $i$a$-minByOrNull-UnitManager$alternateCycleThroughDueUnits$nextUnitEntry$2 = false;
                    int v$iv = ((MapUnit)it2.getValue()).getCurrentTile().aerialDistanceTo((Tile)center);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        IndexedValue indexedValue = v2;
        if (indexedValue == null) {
            return null;
        }
        IndexedValue nextUnitEntry = indexedValue;
        this.nextPotentiallyDueAt = (nextUnitEntry.getIndex() + 1) % this.unitList.size();
        return (MapUnit)nextUnitEntry.getValue();
    }

    static /* synthetic */ MapUnit alternateCycleThroughDueUnits$default(UnitManager unitManager, MapUnit mapUnit, int n, Object object) {
        if ((n & 1) != 0) {
            mapUnit = null;
        }
        return unitManager.alternateCycleThroughDueUnits(mapUnit);
    }

    private static final boolean placeUnitNearTile$lambda$0(MapUnit $unit, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return MapUnit.matchesFilter$default($unit, it.getParams().get(0), false, 2, null);
    }

    private static final boolean getCivGreatPeople$lambda$0(MapUnit mapUnit) {
        Intrinsics.checkNotNullParameter(mapUnit, "mapUnit");
        return mapUnit.isGreatPerson();
    }

    private static final boolean getIdleUnits$lambda$0(MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return MapUnit.isIdle$default(it, false, 1, null);
    }

    private static final boolean getDueUnits$lambda$0(MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDue() && MapUnit.isIdle$default(it, false, 1, null);
    }
}

