/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.models.ModConstants;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.RulesetFile;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.nation.NationKt;
import com.unciv.models.ruleset.nation.Personality;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.unit.UnitMovementType;
import com.unciv.models.ruleset.unit.UnitNameGroup;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.models.ruleset.validation.BaseRulesetValidator;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.TextSimilarityKt;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stats;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.models.tilesets.TileSetConfig;
import com.unciv.ui.images.AtlasPreview;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.images.PortraitPromotion;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0006\b\u0016\u0018\u0000 U2\u00020\u0001:\u0002UVB\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u00100\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u00101\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u00102\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u00103\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0018\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u0002062\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u00107\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u00108\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J\u0010\u00109\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J$\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\u0006\u0010=\u001a\u00020<2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020<0;H\u0004J(\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010$\u001a\u00020C2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010D\u001a\u00020E2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0002J\u0010\u0010F\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010G\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010H\u001a\u00020\u00152\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010K\u001a\u00020\u00152\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010L\u001a\u00020\u00152\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010M\u001a\u00020\u00152\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010N\u001a\u00020\u00152\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010O\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020<0QH\u0002J\u000e\u0010R\u001a\u00020\u00052\u0006\u0010S\u001a\u00020<J\u0010\u0010T\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/unciv/models/ruleset/validation/RulesetValidator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "tryFixUnknownUniques", "", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;Z)V", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "reportRulesetSpecificErrors", "uniqueValidator", "Lcom/unciv/models/ruleset/validation/UniqueValidator;", "getUniqueValidator", "()Lcom/unciv/models/ruleset/validation/UniqueValidator;", "textureNamesCache", "Lcom/unciv/ui/images/AtlasPreview;", "getErrorList", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "getErrorListInternal", "addBeliefErrors", "", "lines", "addBuildingErrors", "checkBuilding", "building", "Lcom/unciv/models/ruleset/Building;", "addCityStateTypeErrors", "addDifficultyErrors", "addEraErrors", "addEventErrors", "addGlobalUniqueErrors", "addImprovementErrors", "addModOptionsErrors", "addNationErrors", "checkNation", "nation", "Lcom/unciv/models/ruleset/nation/Nation;", "addPersonalityErrors", "addPolicyErrors", "addPromotionErrors", "checkPromotion", "promotion", "Lcom/unciv/models/ruleset/unit/Promotion;", "addResourceErrors", "addRuinsErrors", "addSpecialistErrors", "addSpeedErrors", "addTechErrors", "addTechColumnErrors", "addTerrainErrors", "addUnitErrors", "checkUnit", "unit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "addUnitTypeErrors", "addUnitNameGroupsErrors", "addVictoryTypeErrors", "getPossibleMisspellings", "", "", "originalText", "possibleMisspellings", "checkContrasts", "innerColor", "Lcom/badlogic/gdx/graphics/Color;", "outerColor", "Lcom/unciv/models/ruleset/RulesetObject;", "getSuggestedColors", "Lcom/unciv/models/ruleset/validation/RulesetValidator$SuggestedColors;", "initTextureNamesCache", "checkFileNames", "checkMisspelledFolders", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "checkMisplacedJsonFiles", "checkImagesFolders", "checkUnknownJsonFilenames", "warnSplitAtlasesPerformanceDegradation", "checkTilesetSanity", "getTilesetNamesFromAtlases", "", "uncachedImageExists", "name", "checkCivilopediaText", "Companion", "SuggestedColors", "core"})
@SourceDebugExtension(value={"SMAP\nRulesetValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesetValidator.kt\ncom/unciv/models/ruleset/validation/RulesetValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,756:1\n1563#2:757\n1634#2,3:758\n774#2:761\n865#2,2:762\n1788#2,4:766\n774#2:774\n865#2:775\n1563#2:776\n1634#2,3:777\n866#2:780\n774#2:781\n865#2,2:782\n774#2:784\n865#2,2:785\n1563#2:787\n1634#2,3:788\n774#2:791\n865#2,2:792\n1563#2:794\n1634#2,3:795\n1374#2:798\n1460#2,5:799\n1563#2:807\n1634#2,3:808\n1563#2:811\n1634#2,3:812\n774#2:815\n865#2,2:816\n1563#2:818\n1634#2,3:819\n1761#2,3:822\n1255#3,2:764\n11561#4:770\n11896#4,3:771\n3919#4:804\n4434#4,2:805\n*S KotlinDebug\n*F\n+ 1 RulesetValidator.kt\ncom/unciv/models/ruleset/validation/RulesetValidator\n*L\n242#1:757\n242#1:758,3\n252#1:761\n252#1:762,2\n300#1:766,4\n433#1:774\n433#1:775\n434#1:776\n434#1:777,3\n433#1:780\n437#1:781\n437#1:782,2\n444#1:784\n444#1:785,2\n480#1:787\n480#1:788,3\n518#1:791\n518#1:792,2\n620#1:794\n620#1:795,3\n620#1:798\n620#1:799,5\n652#1:807\n652#1:808,3\n655#1:811\n655#1:812,3\n734#1:815\n734#1:816,2\n735#1:818\n735#1:819,3\n335#1:822,3\n255#1:764,2\n309#1:770\n309#1:771,3\n623#1:804\n623#1:805,2\n*E\n"})
public class RulesetValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    private final boolean tryFixUnknownUniques;
    private final boolean reportRulesetSpecificErrors;
    @NotNull
    private final UniqueValidator uniqueValidator;
    private AtlasPreview textureNamesCache;

    protected RulesetValidator(@NotNull Ruleset ruleset, boolean tryFixUnknownUniques) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.ruleset = ruleset;
        this.tryFixUnknownUniques = tryFixUnknownUniques;
        this.reportRulesetSpecificErrors = this.ruleset.getModOptions().isBaseRuleset();
        this.uniqueValidator = new UniqueValidator(this.ruleset);
    }

    @NotNull
    protected final Ruleset getRuleset() {
        return this.ruleset;
    }

    @NotNull
    protected final UniqueValidator getUniqueValidator() {
        return this.uniqueValidator;
    }

    @NotNull
    public final RulesetErrorList getErrorList() {
        RulesetErrorList rulesetErrorList;
        try {
            rulesetErrorList = this.getErrorListInternal();
        }
        catch (Exception e) {
            RulesetErrorList rulesetErrorList2;
            RulesetErrorList $this$getErrorList_u24lambda_u240 = rulesetErrorList2 = new RulesetErrorList(this.ruleset);
            boolean bl = false;
            RulesetErrorList.add$default($this$getErrorList_u24lambda_u240, "Error while validating ruleset " + this.ruleset.getName() + ": " + e.getMessage(), null, null, null, 14, null);
            RulesetErrorList.add$default($this$getErrorList_u24lambda_u240, ExceptionsKt.stackTraceToString(e), null, null, null, 14, null);
            rulesetErrorList = rulesetErrorList2;
        }
        return rulesetErrorList;
    }

    private final RulesetErrorList getErrorListInternal() {
        RulesetErrorList lines2 = new RulesetErrorList(this.ruleset);
        this.addModOptionsErrors(lines2);
        this.addGlobalUniqueErrors(lines2);
        this.addUnitErrors(lines2);
        this.addBuildingErrors(lines2);
        this.addSpecialistErrors(lines2);
        this.addResourceErrors(lines2);
        this.addImprovementErrors(lines2);
        this.addTerrainErrors(lines2);
        this.addTechErrors(lines2);
        this.addTechColumnErrors(lines2);
        this.addEraErrors(lines2);
        this.addSpeedErrors(lines2);
        this.addPersonalityErrors(lines2);
        this.addBeliefErrors(lines2);
        this.addNationErrors(lines2);
        this.addPolicyErrors(lines2);
        this.addRuinsErrors(lines2);
        this.addPromotionErrors(lines2);
        this.addUnitTypeErrors(lines2);
        this.addUnitNameGroupsErrors(lines2);
        this.addVictoryTypeErrors(lines2);
        this.addDifficultyErrors(lines2);
        this.addEventErrors(lines2);
        this.addCityStateTypeErrors(lines2);
        this.initTextureNamesCache(lines2);
        this.checkTilesetSanity(lines2);
        this.checkCivilopediaText(lines2);
        this.checkFileNames(lines2);
        return lines2;
    }

    protected void addBeliefErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Belief> iterator2 = this.ruleset.getBeliefs().values().iterator();
        while (iterator2.hasNext()) {
            Belief belief;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (belief.getType() == BeliefType.Any || belief.getType() == BeliefType.None) {
                RulesetErrorList.add$default(lines2, belief.getName() + " type is " + (Object)((Object)belief.getType()) + ", which is not allowed!", null, belief, null, 10, null);
            }
            this.uniqueValidator.checkUniques(belief, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addBuildingErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Building> iterator2 = this.ruleset.getBuildings().values().iterator();
        while (iterator2.hasNext()) {
            Building building;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            this.checkBuilding(building, lines2);
            this.uniqueValidator.checkUniques(building, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void checkBuilding(@NotNull Building building, @NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        if (SequencesKt.none(building.requiredTechs()) && building.getCost() == -1 && !IHasUniques.hasUnique$default(building, UniqueType.Unbuildable, null, 2, null)) {
            RulesetErrorList.add$default(lines2, building.getName() + " is buildable and therefore should either have an explicit cost or reference an existing tech!", RulesetErrorSeverity.Warning, building, null, 8, null);
        }
        if (building.getReplaces() != null && building.getUniqueTo() == null) {
            RulesetErrorList.add$default(lines2, building.getName() + " should replace " + building.getReplaces() + " but does not have uniqueTo assigned!", null, null, null, 14, null);
        }
    }

    protected void addCityStateTypeErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<CityStateType> iterator2 = this.ruleset.getCityStateTypes().values().iterator();
        while (iterator2.hasNext()) {
            CityStateType cityStateType;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Iterator<Unique> iterator3 = SequencesKt.plus(cityStateType.getAllyBonusUniqueMap().getAllUniques(), cityStateType.getFriendBonusUniqueMap().getAllUniques()).iterator();
            while (iterator3.hasNext()) {
                Unique unique = iterator3.next();
                RulesetErrorList errors = this.uniqueValidator.checkUnique(unique, this.tryFixUnknownUniques, null, this.reportRulesetSpecificErrors);
                lines2.addAll(errors);
            }
        }
    }

    protected void addDifficultyErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Difficulty> iterator2 = this.ruleset.getDifficulties().values().iterator();
        while (iterator2.hasNext()) {
            Difficulty difficulty;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (difficulty.getAiBuildingCostModifier() < 0.0f || difficulty.getAiBuildingMaintenanceModifier() < 0.0f || difficulty.getAiCityGrowthModifier() < 0.0f || difficulty.getAiUnhappinessModifier() < 0.0f || difficulty.getAiUnitCostModifier() < 0.0f || difficulty.getAiUnitMaintenanceModifier() < 0.0f || difficulty.getAiUnitSupplyModifier() < 0.0f || difficulty.getAiWonderCostModifier() < 0.0f || difficulty.getBuildingCostModifier() < 0.0f || difficulty.getPolicyCostModifier() < 0.0f || difficulty.getResearchCostModifier() < 0.0f || difficulty.getUnhappinessModifier() < 0.0f || difficulty.getUnitCostModifier() < 0.0f) {
                RulesetErrorList.add$default(lines2, "Difficulty " + difficulty.getName() + " contains one or more negative modifier(s)!", null, null, null, 10, null);
            }
            if (difficulty.getTurnBarbariansCanEnterPlayerTiles() < 0) {
                RulesetErrorList.add$default(lines2, "Difficulty " + difficulty.getName() + " has a negative turnBarbariansCanEnterPlayerTiles!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
            this.uniqueValidator.checkUniques(difficulty, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addEraErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Era> iterator2 = this.ruleset.getEras().values().iterator();
        while (iterator2.hasNext()) {
            Era era;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (era.getResearchAgreementCost() < 0 || era.getStartingSettlerCount() < 0 || era.getStartingWorkerCount() < 0 || era.getStartingMilitaryUnitCount() < 0 || era.getStartingGold() < 0 || era.getStartingCulture() < 0) {
                RulesetErrorList.add$default(lines2, "Unexpected negative number found while parsing era " + era.getName(), null, era, null, 10, null);
            }
            if (era.getSettlerPopulation() <= 0) {
                RulesetErrorList.add$default(lines2, "Population in cities from settlers must be strictly positive! Found value " + era.getSettlerPopulation() + " for era " + era.getName(), null, era, null, 10, null);
            }
            if (!((Map)era.getAllyBonus()).isEmpty() || !((Map)era.getFriendBonus()).isEmpty()) {
                RulesetErrorList.add$default(lines2, "Era " + era.getName() + " contains city-state bonuses. City-state bonuses are now defined in CityStateType.json", RulesetErrorSeverity.WarningOptionsOnly, era, null, 8, null);
            }
            this.uniqueValidator.checkUniques(era, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addEventErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Event> iterator2 = this.ruleset.getEvents().values().iterator();
        while (iterator2.hasNext()) {
            Iterator<EventChoice> iterator3;
            Event event;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(event.getChoices().iterator(), "iterator(...)");
            while (iterator3.hasNext()) {
                EventChoice choice;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                this.uniqueValidator.checkUniques(choice, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
            }
            this.uniqueValidator.checkUniques(event, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addGlobalUniqueErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        this.uniqueValidator.checkUniques(this.ruleset.getGlobalUniques$core(), lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        IHasUniques fakeUniqueContainer2 = new IHasUniques(){
            private ArrayList<String> uniques;
            private final List<Unique> uniqueObjects;
            private final UniqueMap uniqueMap;
            private String name;
            {
                this.uniques = new ArrayList<E>();
                this.uniqueObjects = CollectionsKt.emptyList();
                this.uniqueMap = UniqueMap.Companion.getEMPTY();
                this.name = "Global unit uniques";
            }

            public ArrayList<String> getUniques() {
                return this.uniques;
            }

            public void setUniques(ArrayList<String> arrayList) {
                Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
                this.uniques = arrayList;
            }

            public List<Unique> getUniqueObjects() {
                return this.uniqueObjects;
            }

            public UniqueMap getUniqueMap() {
                return this.uniqueMap;
            }

            public UniqueTarget getUniqueTarget() {
                return UniqueTarget.Unit;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.name = string;
            }
        };
        Iterator<String> iterator2 = this.ruleset.getGlobalUniques$core().getUnitUniques().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String uniqueText;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Unique unique = new Unique(uniqueText, null, null, 6, null);
            RulesetErrorList errors = this.uniqueValidator.checkUnique(unique, this.tryFixUnknownUniques, fakeUniqueContainer2, this.reportRulesetSpecificErrors);
            lines2.addAll(errors);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addImprovementErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<TileImprovement> iterator2 = this.ruleset.getTileImprovements().values().iterator();
        while (iterator2.hasNext()) {
            boolean hasPillageUnique;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterator item$iv$iv2;
            Collection destination$iv$iv;
            TileImprovement improvement;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (improvement.getReplaces() != null && improvement.getUniqueTo() == null) {
                RulesetErrorList.add$default(lines2, improvement.getName() + " should replace " + improvement.getReplaces() + " but does not have uniqueTo assigned!", null, null, null, 14, null);
            }
            if (improvement.getTerrainsCanBeBuiltOn().isEmpty() && !IHasUniques.hasUnique$default(improvement, UniqueType.CanOnlyImproveResource, null, 2, null) && !IHasUniques.hasUnique$default(improvement, UniqueType.Unbuildable, null, 2, null) && !StringsKt.startsWith$default(improvement.getName(), "Remove ", false, 2, null)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = RoadStatus.getEntries();
                boolean $i$f$map = false;
                Object object = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Iterator item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    RoadStatus roadStatus = (RoadStatus)((Object)item$iv$iv2);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getRemoveAction());
                }
                if (!((List)destination$iv$iv).contains(improvement.getName()) && !Intrinsics.areEqual(improvement.getName(), "Cancel improvement order")) {
                    RulesetErrorList.add$default(lines2, improvement.getName() + " has an empty `terrainsCanBeBuiltOn`, isn't allowed to only improve resources. As such it isn't buildable! Either give this the unique \"Unbuildable\", \"Can only be built to improve a resource\", or add \"Land\", \"Water\" or any other value to `terrainsCanBeBuiltOn`.", RulesetErrorSeverity.Warning, improvement, null, 8, null);
                }
            }
            Iterable $i$f$map = improvement.getUniqueObjects();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            item$iv$iv2 = $this$filterTo$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                Object element$iv$iv = item$iv$iv2.next();
                Unique it = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == UniqueType.PillageYieldRandom || it.getType() == UniqueType.PillageYieldFixed)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (Unique unique : (List)destination$iv$iv2) {
                boolean bl;
                block9: {
                    if (!Stats.Companion.isStats(unique.getParams().get(0))) continue;
                    Stats params = Stats.Companion.parse(unique.getParams().get(0));
                    Sequence<Float> $this$any$iv = params.getValues();
                    boolean $i$f$any = false;
                    Iterator<Float> iterator3 = $this$any$iv.iterator();
                    while (iterator3.hasNext()) {
                        Float element$iv = iterator3.next();
                        float it = ((Number)element$iv).floatValue();
                        boolean bl2 = false;
                        if (!(it < 0.0f)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (!bl) continue;
                RulesetErrorList.add$default(lines2, improvement.getName() + " cannot have a negative value for a pillage yield!", RulesetErrorSeverity.Error, improvement, null, 8, null);
            }
            boolean bl = hasPillageUnique = improvement.hasUnique(UniqueType.PillageYieldRandom, GameContext.Companion.getIgnoreConditionals()) || improvement.hasUnique(UniqueType.PillageYieldFixed, GameContext.Companion.getIgnoreConditionals());
            if (hasPillageUnique && improvement.hasUnique(UniqueType.Unpillagable, GameContext.Companion.getIgnoreConditionals())) {
                RulesetErrorList.add$default(lines2, improvement.getName() + " has both an `Unpillagable` unique type and a `PillageYieldRandom` or `PillageYieldFixed` unique type!", RulesetErrorSeverity.Warning, improvement, null, 8, null);
            }
            this.uniqueValidator.checkUniques(improvement, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addModOptionsErrors(@NotNull RulesetErrorList lines2) {
        List<Unique> mapSelectUniques;
        Object[] it;
        int n;
        Intrinsics.checkNotNullParameter(lines2, "lines");
        this.uniqueValidator.checkUniques(this.ruleset.getModOptions(), lines2, true, this.tryFixUnknownUniques);
        ModConstants constants = this.ruleset.getModOptions().getConstants();
        int n2 = constants.getCityExpandRange();
        if (!(1 <= n2 ? n2 < 101 : false)) {
            RulesetErrorList.add$default(lines2, "Invalid ModConstant 'cityExpandRange'.", null, null, null, 10, null);
        }
        if (!(1 <= (n2 = constants.getCityWorkRange()) ? n2 < 101 : false)) {
            RulesetErrorList.add$default(lines2, "Invalid ModConstant 'cityWorkRange'.", null, null, null, 10, null);
        }
        if (constants.getMinimalCityDistance() < 1) {
            RulesetErrorList.add$default(lines2, "Invalid ModConstant 'minimalCityDistance'.", null, null, null, 10, null);
        }
        if (constants.getMinimalCityDistanceOnDifferentContinents() < 1) {
            RulesetErrorList.add$default(lines2, "Invalid ModConstant 'minimalCityDistanceOnDifferentContinents'.", null, null, null, 10, null);
        }
        if (constants.getBaseCityBombardRange() < 1) {
            RulesetErrorList.add$default(lines2, "Invalid ModConstant 'baseCityBombardRange'.", null, null, null, 10, null);
        }
        if (StringsKt.isBlank(this.ruleset.getName())) {
            return;
        }
        UniqueType[] uniqueTypeArray = new UniqueType[]{UniqueType.ModIsAudioVisual, UniqueType.ModIsAudioVisualOnly, UniqueType.ModIsNotAudioVisual};
        Set<UniqueType> audioVisualUniqueTypes = SetsKt.setOf(uniqueTypeArray);
        Iterable $this$count$iv = this.ruleset.getModOptions().getUniqueObjects();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Object[])element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)audioVisualUniqueTypes, it.getType()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n > 1) {
            RulesetErrorList.add$default(lines2, "A mod should only specify one of the 'can/should/cannot be used as permanent audiovisual mod' options.", null, null, null, 10, null);
        }
        if ((mapSelectUniques = SequencesKt.toList(IHasUniques.getMatchingUniques$default(this.ruleset.getModOptions(), UniqueType.ModMapPreselection, null, 2, null))).size() > 1) {
            RulesetErrorList.add$default(lines2, "Specifying more than one map as preselection makes no sense", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
        }
        if (!((Collection)mapSelectUniques).isEmpty()) {
            FileHandle mapsFolder = UncivGame.Companion.getCurrent().getFiles().getModFolder(this.ruleset.getName()).child("maps");
            if (mapsFolder.exists()) {
                void $this$mapTo$iv$iv;
                FileHandle[] fileHandleArray = mapsFolder.list();
                Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
                Object[] $this$map$iv = fileHandleArray;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    FileHandle fileHandle = (FileHandle)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it2.name();
                    Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                    collection.add(string2);
                }
                List maps = (List)destination$iv$iv;
                for (Unique unique : mapSelectUniques) {
                    String string = unique.getParams().get(0).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    if (maps.contains(string)) continue;
                    RulesetErrorList.add$default(lines2, "Mod names map '" + unique.getParams().get(0) + "' as preselection, which does not exist.", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
                }
            } else {
                RulesetErrorList.add$default(lines2, "Mod option for map preselection exists but Mod has no 'maps' folder.", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
            }
        }
    }

    protected void addNationErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Nation> iterator2 = this.ruleset.getNations().values().iterator();
        while (iterator2.hasNext()) {
            Nation nation;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            this.checkNation(nation, lines2);
            this.uniqueValidator.checkUniques(nation, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void checkNation(@NotNull Nation nation, @NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(nation, "nation");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        if (nation.getCities().isEmpty() && !nation.isSpectator() && !nation.isBarbarian()) {
            RulesetErrorList.add$default(lines2, nation.getName() + " can settle cities, but has no city names!", null, nation, null, 10, null);
        }
        boolean badInner = RulesetValidator.checkNation$isColorFaulty(nation.getInnerColor());
        boolean badOuter = RulesetValidator.checkNation$isColorFaulty(nation.getOuterColor());
        if (badInner) {
            RulesetErrorList.add$default(lines2, nation.getName() + "'s innerColor is not an array of three integers in the 0..255 range", null, nation, null, 10, null);
        }
        if (badOuter) {
            RulesetErrorList.add$default(lines2, nation.getName() + "'s outerColor is not an array of three integers in the 0..255 range", null, nation, null, 10, null);
        }
        if (!badInner && !badOuter) {
            this.checkContrasts(nation.getInnerColor(), nation.getOuterColor(), nation, lines2);
        }
    }

    protected void addPersonalityErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Personality> iterator2 = this.ruleset.getPersonalities().values().iterator();
        while (iterator2.hasNext()) {
            Personality personality;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (!(!((Collection)personality.getUniques()).isEmpty())) continue;
            RulesetErrorList.add$default(lines2, "Personality Uniques are not supported", RulesetErrorSeverity.Warning, personality, null, 8, null);
        }
    }

    protected void addPolicyErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Policy> iterator2 = this.ruleset.getPolicies().values().iterator();
        while (iterator2.hasNext()) {
            Policy policy;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            this.uniqueValidator.checkUniques(policy, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addPromotionErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Promotion> iterator2 = this.ruleset.getUnitPromotions().values().iterator();
        while (iterator2.hasNext()) {
            Color color;
            Promotion promotion;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            this.uniqueValidator.checkUniques(promotion, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
            Color color2 = promotion.getInnerColorObject();
            if (color2 == null) {
                color2 = PortraitPromotion.Companion.getDefaultInnerColor();
            }
            if ((color = promotion.getOuterColorObject()) == null) {
                color = PortraitPromotion.Companion.getDefaultOuterColor();
            }
            this.checkContrasts(color2, color, promotion, lines2);
            this.checkPromotion(promotion, lines2);
        }
    }

    protected void checkPromotion(@NotNull Promotion promotion, @NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(promotion, "promotion");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        if (promotion.getRow() < -1) {
            RulesetErrorList.add$default(lines2, "Promotion " + promotion.getName() + " has invalid row value: " + promotion.getRow(), null, promotion, null, 10, null);
        }
        if (promotion.getColumn() < 0) {
            RulesetErrorList.add$default(lines2, "Promotion " + promotion.getName() + " has invalid column value: " + promotion.getColumn(), null, promotion, null, 10, null);
        }
        if (promotion.getRow() == -1) {
            return;
        }
        Iterator<Promotion> iterator2 = this.ruleset.getUnitPromotions().values().iterator();
        while (iterator2.hasNext()) {
            Promotion otherPromotion;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (Intrinsics.areEqual(promotion, otherPromotion) || promotion.getColumn() != otherPromotion.getColumn() || promotion.getRow() != otherPromotion.getRow()) continue;
            RulesetErrorList.add$default(lines2, "Promotions " + promotion.getName() + " and " + otherPromotion.getName() + " have the same position: " + promotion.getRow() + '/' + promotion.getColumn(), null, promotion, null, 10, null);
        }
    }

    protected void addResourceErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<TileResource> iterator2 = this.ruleset.getTileResources().values().iterator();
        while (iterator2.hasNext()) {
            TileResource resource;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            this.uniqueValidator.checkUniques(resource, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addRuinsErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<RuinReward> iterator2 = this.ruleset.getRuinRewards().values().iterator();
        while (iterator2.hasNext()) {
            RuinReward reward;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (reward.getWeight() < 0) {
                RulesetErrorList.add$default(lines2, reward.getName() + " has a negative weight, which is not allowed!", null, reward, null, 10, null);
            }
            this.uniqueValidator.checkUniques(reward, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addSpecialistErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
    }

    protected void addSpeedErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Speed> iterator2 = this.ruleset.getSpeeds().values().iterator();
        while (iterator2.hasNext()) {
            Iterator<Speed.YearsPerTurn> iterator3;
            Speed speed;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (speed.getModifier() < 0.0f || speed.getBarbarianModifier() < 0.0f || speed.getCultureCostModifier() < 0.0f || speed.getFaithCostModifier() < 0.0f || speed.getGoldCostModifier() < 0.0f || speed.getGoldGiftModifier() < 0.0f || speed.getGoldenAgeLengthModifier() < 0.0f || speed.getImprovementBuildLengthModifier() < 0.0f || speed.getProductionCostModifier() < 0.0f || speed.getScienceCostModifier() < 0.0f) {
                RulesetErrorList.add$default(lines2, "One or more negative speed modifier(s) for game speed " + speed.getName(), null, speed, null, 10, null);
            }
            if (speed.getDealDuration() < 1 || speed.getPeaceDealDuration() < 1) {
                RulesetErrorList.add$default(lines2, "Deal durations must be positive", null, speed, null, 10, null);
            }
            if (speed.getReligiousPressureAdjacentCity() < 0) {
                RulesetErrorList.add$default(lines2, "'religiousPressureAdjacentCity' must not be negative", null, speed, null, 10, null);
            }
            if (speed.getYearsPerTurn().isEmpty()) {
                RulesetErrorList.add$default(lines2, "Empty turn increment list for game speed " + speed.getName(), null, speed, null, 10, null);
            }
            int lastTurn = 0;
            Intrinsics.checkNotNullExpressionValue(speed.getYearsPerTurn().iterator(), "iterator(...)");
            while (iterator3.hasNext()) {
                Speed.YearsPerTurn yearsPerTurn;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                float yearInterval = yearsPerTurn.component1();
                int untilTurn = yearsPerTurn.component2();
                if (yearInterval <= 0.0f) {
                    RulesetErrorList.add$default(lines2, "Negative year interval " + yearInterval + " in turn increment list", null, speed, null, 10, null);
                }
                if (untilTurn <= lastTurn) {
                    RulesetErrorList.add$default(lines2, "The 'untilTurn' field in the turn increment list must be monotonously increasing, but " + untilTurn + " is <= " + lastTurn, null, speed, null, 10, null);
                }
                lastTurn = untilTurn;
            }
            this.uniqueValidator.checkUniques(speed, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addTechErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Technology> iterator2 = this.ruleset.getTechnologies().values().iterator();
        while (iterator2.hasNext()) {
            Technology tech;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (tech.getRow() < 1) {
                RulesetErrorList.add$default(lines2, "Tech " + tech.getName() + " has a row value below 1: " + tech.getRow(), null, tech, null, 10, null);
            }
            this.uniqueValidator.checkUniques(tech, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void addTechColumnErrors(@NotNull RulesetErrorList lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        v0 = this.ruleset.getTechColumns().iterator();
        Intrinsics.checkNotNullExpressionValue(v0, "iterator(...)");
        var2_2 = v0;
        while (var2_2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(var2_2.next(), "next(...)");
            if (techColumn.getColumnNumber() < 0) {
                RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " is negative", null, null, null, 10, null);
            }
            v1 = this.ruleset.getBuildings().values();
            Intrinsics.checkNotNullExpressionValue(v1, "<get-values>(...)");
            $this$filter$iv = v1;
            $i$f$filter = false;
            var7_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                building = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrors$buildingsWithoutAssignedCost$1 = false;
                if (building.getCost() != -1) ** GOTO lbl-1000
                $this$map$iv = techColumn.getTechs();
                $i$f$map = false;
                var16_26 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_31 = (Technology)item$iv$iv;
                    var22_32 = destination$iv$iv;
                    $i$a$-map-RulesetValidator$addTechColumnErrors$buildingsWithoutAssignedCost$1$1 = false;
                    var22_32.add(it.getName());
                }
                if (CollectionsKt.contains((List)destination$iv$iv, building.getRequiredTech())) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            buildingsWithoutAssignedCost = CollectionsKt.toList((List)destination$iv$iv);
            $this$filter$iv = buildingsWithoutAssignedCost;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv /* !! */  = new ArrayList<E>();
            $i$f$filterTo = false;
            element$iv$iv = $this$filterTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                element$iv$iv = element$iv$iv.next();
                it = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrors$nonWondersWithoutAssignedCost$1 = false;
                if (!(it.isAnyWonder() == false)) continue;
                destination$iv$iv /* !! */ .add(element$iv$iv);
            }
            nonWondersWithoutAssignedCost = (List)destination$iv$iv /* !! */ ;
            if (techColumn.getBuildingCost() == -1 && CollectionsKt.any(nonWondersWithoutAssignedCost)) {
                RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " has no explicit building cost leaving " + CollectionsKt.joinToString$default(nonWondersWithoutAssignedCost, null, null, null, 0, null, null, 63, null) + " unassigned", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
            $this$filter$iv = buildingsWithoutAssignedCost;
            $i$f$filter = false;
            destination$iv$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrors$wondersWithoutAssignedCost$1 = false;
                if (!it.isAnyWonder()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            wondersWithoutAssignedCost = (List)destination$iv$iv;
            if (techColumn.getWonderCost() != -1 || !CollectionsKt.any(wondersWithoutAssignedCost)) continue;
            RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " has no explicit wonder cost leaving " + CollectionsKt.joinToString$default(wondersWithoutAssignedCost, null, null, null, 0, null, null, 63, null) + " unassigned", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
    }

    protected void addTerrainErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Terrain> iterator2 = this.ruleset.getTerrains().values().iterator();
        while (iterator2.hasNext()) {
            Terrain terrain;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            this.uniqueValidator.checkUniques(terrain, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addUnitErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<BaseUnit> iterator2 = this.ruleset.getUnits().values().iterator();
        while (iterator2.hasNext()) {
            BaseUnit unit;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            this.checkUnit(unit, lines2);
            this.uniqueValidator.checkUniques(unit, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void checkUnit(@NotNull BaseUnit unit, @NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<String> iterator2 = unit.getUpgradeUnits(GameContext.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            String upgradesTo = iterator2.next();
            if (!Intrinsics.areEqual(upgradesTo, unit.getName()) && !Intrinsics.areEqual(upgradesTo, unit.getReplaces())) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " upgrades to itself!", null, unit, null, 10, null);
        }
        if (unit.getReplaces() != null && unit.getUniqueTo() == null) {
            RulesetErrorList.add$default(lines2, unit.getName() + " should replace " + unit.getReplaces() + " but does not have uniqueTo assigned!", null, null, null, 14, null);
        }
        if (unit.isMilitary() && unit.getStrength() == 0) {
            RulesetErrorList.add$default(lines2, unit.getName() + " is a military unit but has no assigned strength!", null, unit, null, 10, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addUnitTypeErrors(@NotNull RulesetErrorList lines2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterable $this$map$iv = UnitMovementType.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UnitMovementType unitMovementType = (UnitMovementType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        Set unitMovementTypes = CollectionsKt.toSet((List)destination$iv$iv);
        Iterator<UnitType> iterator2 = this.ruleset.getUnitTypes().values().iterator();
        while (iterator2.hasNext()) {
            UnitType unitType;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (!CollectionsKt.contains(unitMovementTypes, unitType.getMovementType$core())) {
                RulesetErrorList.add$default(lines2, "Unit type " + unitType.getName() + " has an invalid movement type " + unitType.getMovementType$core(), null, unitType, null, 10, null);
            }
            this.uniqueValidator.checkUniques(unitType, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addUnitNameGroupsErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<UnitNameGroup> iterator2 = this.ruleset.getUnitNameGroups().values().iterator();
        while (iterator2.hasNext()) {
            UnitNameGroup unitNameGroup;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            this.uniqueValidator.checkUniques(unitNameGroup, lines2, this.reportRulesetSpecificErrors, this.tryFixUnknownUniques);
        }
    }

    protected void addVictoryTypeErrors(@NotNull RulesetErrorList lines2) {
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterator<Victory> iterator2 = this.ruleset.getVictories().values().iterator();
        while (iterator2.hasNext()) {
            Victory victoryType;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            for (Milestone milestone : victoryType.getMilestoneObjects()) {
                if (milestone.getType() != null) continue;
                RulesetErrorList.add$default(lines2, "Victory type " + victoryType.getName() + " has milestone \"" + milestone.getUniqueDescription() + "\" that is of an unknown type!", RulesetErrorSeverity.Error, null, null, 8, null);
            }
            for (Object object : this.ruleset.getVictories().values()) {
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                Victory otherVictory = (Victory)object;
                if (otherVictory.getName().compareTo(victoryType.getName()) <= 0 || !Intrinsics.areEqual(otherVictory.getMilestones(), victoryType.getMilestones())) continue;
                RulesetErrorList.add$default(lines2, "Victory types " + victoryType.getName() + " and " + otherVictory.getName() + " have the same requirements!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<String> getPossibleMisspellings(@NotNull String originalText, @NotNull List<String> possibleMisspellings) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(originalText, "originalText");
        Intrinsics.checkNotNullParameter(possibleMisspellings, "possibleMisspellings");
        Iterable $this$filter$iv = possibleMisspellings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = TextSimilarityKt.getRelativeTextDistance(it, originalText) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void checkContrasts(Color innerColor, Color outerColor, RulesetObject nation, RulesetErrorList lines2) {
        double constrastRatio = NationKt.getContrastRatio(innerColor, outerColor);
        if (constrastRatio < 3.0) {
            SuggestedColors suggestedColors = this.getSuggestedColors(innerColor, outerColor);
            Color newInnerColor = suggestedColors.component1();
            Color newOuterColor = suggestedColors.component2();
            String text2 = nation.getName() + "'s colors do not contrast enough - it is unreadable!";
            text2 = text2 + "\nSuggested colors: ";
            text2 = text2 + "\n\t\t\"outerColor\": [" + (int)(newOuterColor.r * (float)255) + ", " + (int)(newOuterColor.g * (float)255) + ", " + (int)(newOuterColor.b * (float)255) + "],";
            text2 = text2 + "\n\t\t\"innerColor\": [" + (int)(newInnerColor.r * (float)255) + ", " + (int)(newInnerColor.g * (float)255) + ", " + (int)(newInnerColor.b * (float)255) + "],";
            RulesetErrorList.add$default(lines2, text2, RulesetErrorSeverity.WarningOptionsOnly, nation, null, 8, null);
        }
    }

    private final SuggestedColors getSuggestedColors(Color innerColor, Color outerColor) {
        double innerColorLuminance = NationKt.getRelativeLuminance(innerColor);
        double outerColorLuminance = NationKt.getRelativeLuminance(outerColor);
        Color innerLerpColor = null;
        Color outerLerpColor = null;
        if (innerColorLuminance > outerColorLuminance) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            innerLerpColor = color;
            outerLerpColor = ImageGetter.INSTANCE.getCHARCOAL();
        } else {
            innerLerpColor = ImageGetter.INSTANCE.getCHARCOAL();
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            outerLerpColor = color;
        }
        for (int i = 1; i < 11; ++i) {
            Color newInnerColor = innerColor.cpy().lerp(innerLerpColor, 0.05f * (float)i);
            Color newOuterColor = outerColor.cpy().lerp(outerLerpColor, 0.05f * (float)i);
            Intrinsics.checkNotNull(newInnerColor);
            Intrinsics.checkNotNull(newOuterColor);
            if (!(NationKt.getContrastRatio(newInnerColor, newOuterColor) > 3.0)) continue;
            return new SuggestedColors(newInnerColor, newOuterColor);
        }
        throw new Exception("Error getting suggested colors");
    }

    private final void initTextureNamesCache(RulesetErrorList lines2) {
        if (this.textureNamesCache == null) {
            this.textureNamesCache = new AtlasPreview(this.ruleset, lines2);
        }
    }

    private final void checkFileNames(RulesetErrorList lines2) {
        FileHandle fileHandle = this.ruleset.getFolderLocation();
        if (fileHandle == null) {
            return;
        }
        FileHandle folder = fileHandle;
        this.checkMisplacedJsonFiles(folder, lines2);
        this.checkMisspelledFolders(folder, lines2);
        this.checkImagesFolders(folder, lines2);
        this.checkUnknownJsonFilenames(folder, lines2);
        this.warnSplitAtlasesPerformanceDegradation(folder, lines2);
    }

    private final void checkMisspelledFolders(FileHandle folder, RulesetErrorList lines2) {
        Object[] objectArray = new String[]{"jsons", "maps", "sounds", "Images", "fonts"};
        List<String> knownFolderNames = CollectionsKt.listOf(objectArray);
        FileHandle[] fileHandleArray = folder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        for (FileHandle child : fileHandleArray) {
            if (!child.isDirectory() || knownFolderNames.contains(child.name())) continue;
            String string = child.name();
            Intrinsics.checkNotNullExpressionValue(string, "name(...)");
            List<String> possibleMisspellings = this.getPossibleMisspellings(string, knownFolderNames);
            if (!(!((Collection)possibleMisspellings).isEmpty())) continue;
            RulesetErrorList.add$default(lines2, "Folder \"" + child.name() + "\" is probably a misspelling of " + CollectionsKt.joinToString$default(possibleMisspellings, "/", null, null, 0, null, null, 62, null), RulesetErrorSeverity.OK, null, null, 12, null);
        }
    }

    private final void checkMisplacedJsonFiles(FileHandle folder, RulesetErrorList lines2) {
        FileHandle[] fileHandleArray = folder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        for (FileHandle child : fileHandleArray) {
            String string = child.name();
            Intrinsics.checkNotNullExpressionValue(string, "name(...)");
            if (!StringsKt.endsWith$default(string, "json", false, 2, null)) continue;
            String string2 = child.name();
            Intrinsics.checkNotNullExpressionValue(string2, "name(...)");
            if (StringsKt.startsWith$default(string2, "Atlas", false, 2, null)) continue;
            RulesetErrorList.add$default(lines2, "File " + child.name() + " is located in the root folder - it should be moved to a 'jsons' folder", null, null, null, 14, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkImagesFolders(FileHandle folder, RulesetErrorList lines2) {
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        String[] $this$flatMap$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = Portrait.Type.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Portrait.Type type = (Portrait.Type)((Object)item$iv$iv);
            Object[] objectArray = destination$iv$iv;
            boolean bl = false;
            objectArray.add(((Portrait.Type)((Object)it)).getDirectory());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{it + "Icons", it + "Portraits"};
            Iterable list$iv$iv = CollectionsKt.listOf(stringArray);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = new String[]{"CityStateIcons", "PolicyBranchIcons", "PolicyIcons", "OtherIcons", "EmojiIcons", "StatIcons", "TileIcons", "TileSets"};
        List<String> knownImageFolders = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf($this$flatMap$iv));
        FileHandle[] fileHandleArray = folder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        Object[] $this$filter$iv = fileHandleArray;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            FileHandle it2 = (FileHandle)element$iv$iv;
            boolean bl = false;
            String string = it2.name();
            Intrinsics.checkNotNullExpressionValue(string, "name(...)");
            if (!StringsKt.startsWith$default(string, "Images", false, 2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List imageFolders2 = (List)destination$iv$iv2;
        for (FileHandle imageFolder : imageFolders2) {
            FileHandle[] fileHandleArray2;
            Intrinsics.checkNotNullExpressionValue(imageFolder.list(), "list(...)");
            for (FileHandle child : fileHandleArray2) {
                if (!child.isDirectory()) {
                    RulesetErrorList.add$default(lines2, "File \"" + imageFolder + '/' + child.name() + "\" is misplaced - Images folders should not contain any files directly - only subfolders", RulesetErrorSeverity.OK, null, null, 12, null);
                    continue;
                }
                if (knownImageFolders.contains(child.name())) continue;
                String string = child.name();
                Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                List<String> possibleMisspellings = this.getPossibleMisspellings(string, knownImageFolders);
                if (!(!((Collection)possibleMisspellings).isEmpty())) continue;
                RulesetErrorList.add$default(lines2, "Folder \"" + imageFolder + '/' + child.name() + "\" is probably a misspelling of " + CollectionsKt.joinToString$default(possibleMisspellings, "/", null, null, 0, null, null, 62, null), RulesetErrorSeverity.OK, null, null, 12, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkUnknownJsonFilenames(FileHandle folder, RulesetErrorList lines2) {
        FileHandle jsonFolder = folder.child("jsons");
        if (!jsonFolder.exists()) {
            return;
        }
        FileHandle[] fileHandleArray = jsonFolder.list("json");
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        for (FileHandle file : fileHandleArray) {
            String string;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = RulesetFile.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                RulesetFile rulesetFile = (RulesetFile)((Object)item$iv$iv);
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getFilename());
            }
            if (((List)destination$iv$iv).contains(file.name())) continue;
            String text2 = "File " + file.name() + " is in the jsons folder but is not a recognized ruleset file";
            Intrinsics.checkNotNullExpressionValue(file.name(), "name(...)");
            $this$mapTo$iv$iv2 = RulesetFile.getEntries();
            object = this;
            boolean $i$f$map2 = false;
            void $i$f$mapTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RulesetFile rulesetFile = (RulesetFile)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getFilename());
            }
            collection = (List)destination$iv$iv2;
            List<String> possibleMisspellings = ((RulesetValidator)object).getPossibleMisspellings(string, (List<String>)collection);
            if (!((Collection)possibleMisspellings).isEmpty()) {
                text2 = text2 + "\nPossible misspelling of: " + CollectionsKt.joinToString$default(possibleMisspellings, "/", null, null, 0, null, null, 62, null);
            }
            RulesetErrorList.add$default(lines2, text2, RulesetErrorSeverity.OK, null, null, 12, null);
        }
    }

    private final void warnSplitAtlasesPerformanceDegradation(FileHandle folder, RulesetErrorList lines2) {
        if (folder.child("game2.png").exists()) {
            RulesetErrorList.add$default(lines2, "Your images are being generated into multiple atlas files - this can cause lag for players. Please consult https://yairm210.github.io/Unciv/Modders/Images-and-Audio/#rendering-performance on how to improve rendering performance.", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
        }
    }

    private final void checkTilesetSanity(RulesetErrorList lines2) {
        Set<String> atlasOnlyTilesets;
        Set<Object> set;
        FileHandle tilesetConfigFolder;
        FileHandle fileHandle;
        if (this.ruleset.getFolderLocation() == null) {
            Package package_ = this.getClass().getPackage();
            if ((package_ != null ? package_.getSpecificationVersion() : null) != null) {
                return;
            }
        }
        if ((fileHandle = this.ruleset.getFolderLocation()) == null) {
            fileHandle = Gdx.files.internal("");
        }
        if (!(tilesetConfigFolder = fileHandle.child("jsons/TileSets")).exists()) {
            return;
        }
        Set configTilesets = new LinkedHashSet();
        Set allFallbacks = new LinkedHashSet();
        FileHandle[] folderContent = tilesetConfigFolder.list();
        boolean folderContentBad = false;
        Intrinsics.checkNotNull(folderContent);
        for (FileHandle file : folderContent) {
            if (file.isDirectory() || !Intrinsics.areEqual(file.extension(), "json")) {
                folderContentBad = true;
                continue;
            }
            try {
                Json json = UncivJsonKt.json();
                Intrinsics.checkNotNull(file);
                TileSetConfig config2 = UncivJsonKt.fromJsonFile(json, TileSetConfig.class, file);
                Collection collection = configTilesets;
                String string = file.nameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
                collection.add(StringsKt.removeSuffix(string, (CharSequence)"Config"));
                String string2 = config2.getFallbackTileSet();
                boolean bl = string2 != null ? ((CharSequence)string2).length() > 0 : false;
                if (!bl) continue;
                String string3 = config2.getFallbackTileSet();
                Intrinsics.checkNotNull(string3);
                allFallbacks.add(string3);
            }
            catch (Exception ex) {
                Throwable throwable = ex.getCause();
                RulesetErrorList.add$default(lines2, "Tileset config '" + file.name() + "' cannot be loaded (" + (throwable != null ? throwable.getMessage() : null) + ')', RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
        if (folderContentBad) {
            RulesetErrorList.add$default(lines2, "The Mod tileset config folder contains non-json files or subdirectories", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        if (configTilesets.isEmpty()) {
            RulesetErrorList.add$default(lines2, "The Mod tileset config folder contains no json files", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        Set<String> atlasTilesets = this.getTilesetNamesFromAtlases();
        if (this instanceof BaseRulesetValidator && !((Collection)this.ruleset.getMods()).isEmpty()) {
            String[] stringArray = new String[]{"Minimal", "HexaRealm", "FantasyHex"};
            set = SetsKt.setOf(stringArray);
        } else {
            set = SetsKt.emptySet();
        }
        Set vanillaTilesets = set;
        Set configOnlyTilesets = SetsKt.minus(SetsKt.minus(configTilesets, (Iterable)atlasTilesets), vanillaTilesets);
        if (!((Collection)configOnlyTilesets).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Mod has no graphics for configured tilesets: " + CollectionsKt.joinToString$default(configOnlyTilesets, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        if (!((Collection)(atlasOnlyTilesets = SetsKt.minus(atlasTilesets, configTilesets))).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Mod has no configuration for tileset graphics: " + CollectionsKt.joinToString$default(atlasOnlyTilesets, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        Set<String> set2 = TileSetCache.INSTANCE.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Set<String> unknownFallbacks = SetsKt.minus(SetsKt.minus(allFallbacks, (Iterable)set2), "FantasyHex");
        if (!((Collection)unknownFallbacks).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Fallback tileset invalid: " + CollectionsKt.joinToString$default(unknownFallbacks, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getTilesetNamesFromAtlases() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        AtlasPreview atlasPreview = this.textureNamesCache;
        if (atlasPreview == null) {
            Intrinsics.throwUninitializedPropertyAccessException("textureNamesCache");
            atlasPreview = null;
        }
        Iterable $this$filter$iv = atlasPreview;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default(it, "TileSets/", false, 2, null) && !StringsKt.contains$default((CharSequence)it, "/Units/", false, 2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"/"};
            collection.add((String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(1));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    public final boolean uncachedImageExists(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        AtlasPreview atlasPreview = this.textureNamesCache;
        if (atlasPreview == null) {
            Intrinsics.throwUninitializedPropertyAccessException("textureNamesCache");
            atlasPreview = null;
        }
        return atlasPreview.imageExists(name);
    }

    private final void checkCivilopediaText(RulesetErrorList lines2) {
        Iterator<ICivilopediaText> iterator2 = this.ruleset.allICivilopediaText().iterator();
        while (iterator2.hasNext()) {
            ICivilopediaText sourceObject = iterator2.next();
            Iterator iterator3 = ((Iterable)sourceObject.getCivilopediaText()).iterator();
            int n = 0;
            while (iterator3.hasNext()) {
                int index = n++;
                FormattedLine line = (FormattedLine)iterator3.next();
                Iterator<String> iterator4 = line.unsupportedReasons(this).iterator();
                while (iterator4.hasNext()) {
                    String string;
                    String string2;
                    String error2 = iterator4.next();
                    INamed iNamed = sourceObject instanceof INamed ? (INamed)((Object)sourceObject) : null;
                    String nameText = iNamed != null && (string2 = iNamed.getName()) != null && (string = string2 + "'s ") != null ? string : "";
                    String text2 = '(' + sourceObject.getClass().getSimpleName() + ") " + nameText + "civilopediaText line " + (index + 1) + ": " + error2;
                    lines2.add(text2, RulesetErrorSeverity.WarningOptionsOnly, sourceObject instanceof IRulesetObject ? (IRulesetObject)sourceObject : null, null);
                }
            }
        }
    }

    private static final boolean checkNation$isColorFaulty(List<Integer> rgb) {
        boolean bl;
        if (rgb == null) {
            bl = false;
        } else if (rgb.size() != 3) {
            bl = true;
        } else {
            boolean bl2;
            block7: {
                Iterable $this$any$iv = rgb;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl3 = false;
                        boolean bl4 = 0 <= it ? it < 256 : false;
                        if (!(!bl4)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/unciv/models/ruleset/validation/RulesetValidator$Companion;", "", "<init>", "()V", "create", "Lcom/unciv/models/ruleset/validation/RulesetValidator;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "tryFixUnknownUniques", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RulesetValidator create(@NotNull Ruleset ruleset, boolean tryFixUnknownUniques) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return ruleset.getModOptions().isBaseRuleset() ? (RulesetValidator)new BaseRulesetValidator(ruleset, tryFixUnknownUniques) : new RulesetValidator(ruleset, tryFixUnknownUniques);
        }

        public static /* synthetic */ RulesetValidator create$default(Companion companion, Ruleset ruleset, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.create(ruleset, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/unciv/models/ruleset/validation/RulesetValidator$SuggestedColors;", "", "innerColor", "Lcom/badlogic/gdx/graphics/Color;", "outerColor", "<init>", "(Lcom/badlogic/gdx/graphics/Color;Lcom/badlogic/gdx/graphics/Color;)V", "getInnerColor", "()Lcom/badlogic/gdx/graphics/Color;", "getOuterColor", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class SuggestedColors {
        @NotNull
        private final Color innerColor;
        @NotNull
        private final Color outerColor;

        public SuggestedColors(@NotNull Color innerColor, @NotNull Color outerColor) {
            Intrinsics.checkNotNullParameter(innerColor, "innerColor");
            Intrinsics.checkNotNullParameter(outerColor, "outerColor");
            this.innerColor = innerColor;
            this.outerColor = outerColor;
        }

        @NotNull
        public final Color getInnerColor() {
            return this.innerColor;
        }

        @NotNull
        public final Color getOuterColor() {
            return this.outerColor;
        }

        @NotNull
        public final Color component1() {
            return this.innerColor;
        }

        @NotNull
        public final Color component2() {
            return this.outerColor;
        }

        @NotNull
        public final SuggestedColors copy(@NotNull Color innerColor, @NotNull Color outerColor) {
            Intrinsics.checkNotNullParameter(innerColor, "innerColor");
            Intrinsics.checkNotNullParameter(outerColor, "outerColor");
            return new SuggestedColors(innerColor, outerColor);
        }

        public static /* synthetic */ SuggestedColors copy$default(SuggestedColors suggestedColors, Color color, Color color2, int n, Object object) {
            if ((n & 1) != 0) {
                color = suggestedColors.innerColor;
            }
            if ((n & 2) != 0) {
                color2 = suggestedColors.outerColor;
            }
            return suggestedColors.copy(color, color2);
        }

        @NotNull
        public String toString() {
            return "SuggestedColors(innerColor=" + this.innerColor + ", outerColor=" + this.outerColor + ')';
        }

        public int hashCode() {
            int result2 = this.innerColor.hashCode();
            result2 = result2 * 31 + this.outerColor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuggestedColors)) {
                return false;
            }
            SuggestedColors suggestedColors = (SuggestedColors)other;
            if (!Intrinsics.areEqual(this.innerColor, suggestedColors.innerColor)) {
                return false;
            }
            return Intrinsics.areEqual(this.outerColor, suggestedColors.outerColor);
        }
    }
}

