/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u001e\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityReligionInfoTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "religionManager", "Lcom/unciv/logic/city/managers/CityReligionManager;", "showMajority", "", "<init>", "(Lcom/unciv/logic/city/managers/CityReligionManager;Z)V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getIconAndLabel", "Lkotlin/Pair;", "", "religionName", "religion", "Lcom/unciv/models/Religion;", "linkedReligionIcon", "Lcom/unciv/ui/images/Portrait;", "iconName", "asExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "onChange", "Lkotlin/Function0;", "", "core"})
@SourceDebugExtension(value={"SMAP\nCityReligionInfoTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityReligionInfoTable.kt\ncom/unciv/ui/screens/cityscreen/CityReligionInfoTable\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,111:1\n622#2:112\n*S KotlinDebug\n*F\n+ 1 CityReligionInfoTable.kt\ncom/unciv/ui/screens/cityscreen/CityReligionInfoTable\n*L\n59#1:112\n*E\n"})
public final class CityReligionInfoTable
extends Table {
    @NotNull
    private final CityReligionManager religionManager;
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final GameInfo gameInfo;

    public CityReligionInfoTable(@NotNull CityReligionManager religionManager, boolean showMajority) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(religionManager, "religionManager");
        super(BaseScreen.Companion.getSkin());
        this.religionManager = religionManager;
        this.civInfo = this.religionManager.getCity().getCiv();
        this.gameInfo = this.civInfo.getGameInfo();
        Color gridColor = Color.DARK_GRAY;
        Counter<String> followers = this.religionManager.getNumberOfFollowers();
        Counter<String> futurePressures = this.religionManager.getPressuresFromSurroundingCities();
        if (showMajority) {
            Religion majorityReligion = this.religionManager.getMajorityReligion();
            object2 = this.getIconAndLabel(majorityReligion);
            String iconName = ((Pair)object2).component1();
            String label = ((Pair)object2).component2();
            Religion religion = majorityReligion;
            this.add((Actor)this.linkedReligionIcon(iconName, religion != null ? religion.getName() : null)).pad(5.0f);
            this.add();
            this.add((Actor)Scene2dExtensionsKt.toLabel("Majority Religion: [" + label + ']')).colspan(3).center().row();
        }
        if (this.religionManager.getReligionThisIsTheHolyCityOf() != null) {
            object = this.getIconAndLabel(this.religionManager.getReligionThisIsTheHolyCityOf());
            String iconName = ((Pair)object).component1();
            String label = ((Pair)object).component2();
            this.add((Actor)this.linkedReligionIcon(iconName, this.religionManager.getReligionThisIsTheHolyCityOf())).pad(5.0f);
            this.add();
            if (!this.religionManager.isBlockedHolyCity()) {
                this.add((Actor)Scene2dExtensionsKt.toLabel("Holy City of: [" + label + ']')).colspan(3).center().row();
            } else {
                this.add((Actor)Scene2dExtensionsKt.toLabel("Former Holy City of: [" + label + ']')).colspan(3).center().row();
            }
        }
        if (!followers.isEmpty()) {
            this.add().pad(5.0f);
            Table table2 = this;
            Intrinsics.checkNotNull(gridColor);
            Scene2dExtensionsKt.addSeparatorVertical$default(table2, gridColor, 0.0f, 2, null);
            this.add((Actor)Scene2dExtensionsKt.toLabel("Followers")).pad(5.0f);
            Scene2dExtensionsKt.addSeparatorVertical$default(this, gridColor, 0.0f, 2, null);
            this.add((Actor)Scene2dExtensionsKt.toLabel("Pressure")).pad(5.0f).row();
            Scene2dExtensionsKt.addSeparator$default(this, gridColor, 0, 0.0f, 6, null);
            Sequence $this$sortedByDescending$iv = MapsKt.asSequence((Map)followers);
            boolean $i$f$sortedByDescending = false;
            object = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
                }
            }).iterator();
            while (object.hasNext()) {
                object2 = (Map.Entry)object.next();
                String religion = (String)object2.getKey();
                int followerCount = ((Number)object2.getValue()).intValue();
                Religion religion2 = this.gameInfo.getReligions().get(religion);
                Intrinsics.checkNotNull(religion2);
                String iconName = religion2.getIconName();
                this.add((Actor)this.linkedReligionIcon(iconName, religion)).pad(5.0f);
                Scene2dExtensionsKt.addSeparatorVertical$default(this, gridColor, 0.0f, 2, null);
                this.add((Actor)Scene2dExtensionsKt.toLabel(followerCount)).pad(5.0f);
                Scene2dExtensionsKt.addSeparatorVertical$default(this, gridColor, 0.0f, 2, null);
                Cell<Actor> cell = futurePressures.containsKey(religion) ? this.add((Actor)Scene2dExtensionsKt.toLabel("+ [" + ((Number)futurePressures.get(religion)).intValue() + "] pressure")).pad(5.0f) : this.add();
                this.row();
            }
        }
    }

    public /* synthetic */ CityReligionInfoTable(CityReligionManager cityReligionManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(cityReligionManager, bl);
    }

    private final Pair<String, String> getIconAndLabel(String religionName) {
        return this.getIconAndLabel((Religion)((Map)this.gameInfo.getReligions()).get(religionName));
    }

    private final Pair<String, String> getIconAndLabel(Religion religion) {
        return religion == null ? TuplesKt.to("Religion", "None") : TuplesKt.to(religion.getIconName(), religion.getReligionDisplayName());
    }

    private final Portrait linkedReligionIcon(String iconName, String religion) {
        Portrait icon = ImageGetter.INSTANCE.getReligionPortrait(iconName, 30.0f);
        if (religion == null) {
            return icon;
        }
        Actor actor = Intrinsics.areEqual(religion, iconName) ? ActivationExtensionsKt.onClick(icon, () -> CityReligionInfoTable.linkedReligionIcon$lambda$0(religion)) : ActivationExtensionsKt.onClick(icon, () -> CityReligionInfoTable.linkedReligionIcon$lambda$1(religion));
        return icon;
    }

    @NotNull
    public final ExpanderTab asExpander(@Nullable Function0<Unit> onChange) {
        Pair<String, String> pair = this.getIconAndLabel(this.religionManager.getMajorityReligion());
        String icon = pair.component1();
        String label = pair.component2();
        String string = "Majority Religion: [" + label + ']';
        Portrait portrait = ImageGetter.INSTANCE.getReligionPortrait(icon, 30.0f);
        KeyboardBinding keyboardBinding = KeyboardBinding.ReligionDetail;
        return new ExpanderTab(string, 18, (Actor)portrait, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "CityStatsTable.Religion", keyboardBinding, onChange, arg_0 -> CityReligionInfoTable.asExpander$lambda$0(this, arg_0), 480, null);
    }

    private static final Unit linkedReligionIcon$lambda$0(String $religion) {
        GUI.INSTANCE.getWorldScreen().openEmpireOverview(EmpireOverviewCategories.Religion, $religion);
        return Unit.INSTANCE;
    }

    private static final Unit linkedReligionIcon$lambda$1(String $religion) {
        GUI.INSTANCE.openCivilopedia("Belief/" + $religion);
        return Unit.INSTANCE;
    }

    private static final Unit asExpander$lambda$0(CityReligionInfoTable this$0, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.defaults().center().pad(5.0f);
        it.add((Actor)this$0);
        return Unit.INSTANCE;
    }
}

