/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeOffersList;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ0\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/OffersListScroll;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "persistenceID", "", "onOfferClicked", "Lkotlin/Function1;", "Lcom/unciv/logic/trade/TradeOffer;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "table", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "expanderTabs", "Ljava/util/HashMap;", "Lcom/unciv/logic/trade/TradeOfferType;", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "Lkotlin/collections/HashMap;", "update", "offersToDisplay", "Lcom/unciv/logic/trade/TradeOffersList;", "otherSideOffers", "untradableOffers", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "ourCiv", "Lcom/unciv/logic/civilization/Civilization;", "theirCiv", "core"})
@SourceDebugExtension(value={"SMAP\nOffersListScroll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OffersListScroll.kt\ncom/unciv/ui/screens/diplomacyscreen/OffersListScroll\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1#2:141\n774#3:142\n865#3,2:143\n774#3:145\n865#3,2:146\n1740#3,3:148\n*S KotlinDebug\n*F\n+ 1 OffersListScroll.kt\ncom/unciv/ui/screens/diplomacyscreen/OffersListScroll\n*L\n69#1:142\n69#1:143,2\n78#1:145\n78#1:146,2\n120#1:148,3\n*E\n"})
public final class OffersListScroll
extends AutoScrollPane {
    @NotNull
    private final String persistenceID;
    @NotNull
    private final Function1<TradeOffer, Unit> onOfferClicked;
    @NotNull
    private final Table table;
    @NotNull
    private final HashMap<TradeOfferType, ExpanderTab> expanderTabs;

    /*
     * WARNING - void declaration
     */
    public OffersListScroll(@NotNull String persistenceID, @NotNull Function1<? super TradeOffer, Unit> onOfferClicked) {
        void $this$table_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(persistenceID, "persistenceID");
        Intrinsics.checkNotNullParameter(onOfferClicked, "onOfferClicked");
        super(null, null, 2, null);
        this.persistenceID = persistenceID;
        this.onOfferClicked = onOfferClicked;
        Table table3 = table2 = new Table(BaseScreen.Companion.getSkin());
        OffersListScroll offersListScroll = this;
        boolean bl = false;
        $this$table_u24lambda_u240.defaults().pad(5.0f);
        offersListScroll.table = table2;
        this.expanderTabs = new HashMap();
        this.setFadeScrollBars(false);
        this.setScrollbarsVisible(true);
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull TradeOffersList offersToDisplay, @NotNull TradeOffersList otherSideOffers, @NotNull ResourceSupplyList untradableOffers, @NotNull Civilization ourCiv, @NotNull Civilization theirCiv) {
        Intrinsics.checkNotNullParameter(offersToDisplay, "offersToDisplay");
        Intrinsics.checkNotNullParameter(otherSideOffers, "otherSideOffers");
        Intrinsics.checkNotNullParameter(untradableOffers, "untradableOffers");
        Intrinsics.checkNotNullParameter(ourCiv, "ourCiv");
        Intrinsics.checkNotNullParameter(theirCiv, "theirCiv");
        this.table.clear();
        this.expanderTabs.clear();
        for (TradeOfferType offerType : TradeOfferType.getEntries()) {
            void $this$filterTo$iv$iv;
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[offerType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "";
                    break;
                }
                case 7: {
                    string = "Luxury resources";
                    break;
                }
                case 8: {
                    string = "Strategic resources";
                    break;
                }
                case 9: {
                    string = "Stockpiled resources";
                    break;
                }
                case 10: {
                    string = "Technologies";
                    break;
                }
                case 11: {
                    string = "Declarations of war";
                    break;
                }
                case 12: {
                    string = "Peace Proposals";
                    break;
                }
                case 13: {
                    string = "Cities";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String labelName = string;
            Iterable $this$filter$iv = offersToDisplay;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == offerType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List offersOfType = (List)destination$iv$iv;
            if (!(((CharSequence)labelName).length() > 0) || !CollectionsKt.any(offersOfType)) continue;
            ((Map)this.expanderTabs).put(offerType, new ExpanderTab(labelName, 0, null, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "Trade." + this.persistenceID + '.' + (Object)((Object)offerType), null, null, OffersListScroll::update$lambda$1, 3582, null));
        }
        for (TradeOfferType offerType : TradeOfferType.getEntries()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = offersToDisplay;
            boolean $i$f$filter = false;
            Iterable $i$f$filter2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == offerType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Function1[] function1Array = new Function1[]{OffersListScroll::update$lambda$3, OffersListScroll::update$lambda$4};
            List offersOfType = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy(function1Array));
            if (this.expanderTabs.containsKey((Object)offerType)) {
                ExpanderTab expanderTab = this.expanderTabs.get((Object)offerType);
                Intrinsics.checkNotNull(expanderTab);
                expanderTab.getInnerTable().clear();
                ExpanderTab expanderTab2 = this.expanderTabs.get((Object)offerType);
                Intrinsics.checkNotNull(expanderTab2);
                this.table.add((Actor)expanderTab2).row();
            }
            for (Object e : offersOfType) {
                int amountPerClick;
                TradeOfferType[] $i$f$filterTo2;
                Actor actor;
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                TradeOffer offer = (TradeOffer)e;
                String tradeLabel = offer.getOfferText(untradableOffers.sumBy(offer.getName()));
                switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
                    case 1: {
                        actor = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Star", null, 2, null);
                        break;
                    }
                    case 7: 
                    case 8: {
                        actor = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, offer.getName(), 30.0f, 0, 4, null);
                        break;
                    }
                    case 11: 
                    case 12: {
                        Nation nation = ourCiv.getGameInfo().getRuleset().getNations().get(offer.getName());
                        Intrinsics.checkNotNull(nation);
                        actor = ImageGetter.INSTANCE.getNationPortrait(nation, 30.0f);
                        break;
                    }
                    default: {
                        actor = null;
                    }
                }
                Actor tradeIcon = actor;
                TradeOfferType[] $this$update_u24lambda_u245 = $i$f$filterTo2 = new IconTextButton(tradeLabel, tradeIcon, 0, null, 12, null);
                boolean bl = false;
                if (tradeIcon != null) {
                    $this$update_u24lambda_u245.getIconCell().size(30.0f);
                }
                $this$update_u24lambda_u245.getLabel().setAlignment(1);
                $this$update_u24lambda_u245.getLabelCell().pad(5.0f).grow();
                TradeOfferType[] tradeButton = $i$f$filterTo2;
                switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
                    case 2: {
                        int n = 50;
                        break;
                    }
                    case 4: {
                        int n = Integer.MAX_VALUE;
                        break;
                    }
                    default: {
                        int n = amountPerClick = 1;
                    }
                }
                if (!(!offer.isTradable() || Intrinsics.areEqual(offer.getName(), "Peace Treaty") || Intrinsics.areEqual(offer.getName(), "Research Agreement") && ourCiv.getGold() + theirCiv.getGold() <= ourCiv.getDiplomacyFunctions().getResearchAgreementCost(theirCiv) * 2)) {
                    $this$update_u24lambda_u245 = new TradeOfferType[]{TradeOfferType.Luxury_Resource, TradeOfferType.Strategic_Resource};
                    if (CollectionsKt.listOf($this$update_u24lambda_u245).contains((Object)offerType)) {
                        boolean bl2;
                        block34: {
                            Iterable $this$all$iv = otherSideOffers;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    TradeOffer it = (TradeOffer)element$iv;
                                    boolean bl3 = false;
                                    if (it.getType() != offer.getType() || !Intrinsics.areEqual(it.getName(), offer.getName()) || it.getAmount() < 0) continue;
                                    bl2 = false;
                                    break block34;
                                }
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            tradeButton.setColor(Color.GREEN);
                        }
                    }
                    ActivationExtensionsKt.onClick((Actor)tradeButton, () -> OffersListScroll.update$lambda$7(amountPerClick, offer, this));
                } else {
                    Scene2dExtensionsKt.disable((Button)tradeButton);
                }
                if (this.expanderTabs.containsKey((Object)offerType)) {
                    ExpanderTab expanderTab = this.expanderTabs.get((Object)offerType);
                    Intrinsics.checkNotNull(expanderTab);
                    expanderTab.getInnerTable().add((Actor)tradeButton).row();
                    continue;
                }
                this.table.add((Actor)tradeButton).row();
            }
        }
        this.setActor(this.table);
    }

    public static /* synthetic */ void update$default(OffersListScroll offersListScroll, TradeOffersList tradeOffersList, TradeOffersList tradeOffersList2, ResourceSupplyList resourceSupplyList, Civilization civilization, Civilization civilization2, int n, Object object) {
        if ((n & 4) != 0) {
            resourceSupplyList = ResourceSupplyList.Companion.getEmptyList();
        }
        offersListScroll.update(tradeOffersList, tradeOffersList2, resourceSupplyList, civilization, civilization2);
    }

    private static final Unit update$lambda$1(Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.defaults().pad(5.0f);
        return Unit.INSTANCE;
    }

    private static final Comparable update$lambda$3(TradeOffer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return UncivGame.Companion.getCurrent().getSettings().getOrderTradeOffersByAmount() ? (Comparable)Integer.valueOf(-it.getAmount()) : (Comparable)Integer.valueOf(0);
    }

    private static final Comparable update$lambda$4(TradeOffer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() == TradeOfferType.City ? (Comparable)((Object)TradeOffer.getOfferText$default(it, 0, 1, null)) : (Comparable)((Object)TranslationsKt.tr$default(it.getName(), false, false, 3, null));
    }

    private static final Unit update$lambda$7(int $amountPerClick, TradeOffer $offer, OffersListScroll this$0) {
        int amountTransferred = Math.min($amountPerClick, $offer.getAmount());
        this$0.onOfferClicked.invoke(TradeOffer.copy$default($offer, null, null, amountTransferred, 0, 11, null));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TradeOfferType.values().length];
            try {
                nArray[TradeOfferType.Embassy.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Gold.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Gold_Per_Turn.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Treaty.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Agreement.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Introduction.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Luxury_Resource.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Strategic_Resource.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Stockpiled_Resource.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Technology.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.WarDeclaration.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.PeaceProposal.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.City.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

