/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.actions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.UncivGame;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.UpgradeUnitAction;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.popups.UnitUpgradeMenu;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "currentPage", "", "buttonsPerPage", "numPages", "shownForUnitHash", "animationNotFinished", "", "changePage", "", "delta", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "update", "updateButtonsPerPage", "button", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "getUnitActionButton", "unitAction", "Lcom/unciv/models/UnitAction;", "activateAction", "animateButton", "delay", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUnitActionsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitActionsTable.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n622#2:224\n808#3,11:225\n*S KotlinDebug\n*F\n+ 1 UnitActionsTable.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable\n*L\n86#1:224\n140#1:225,11\n*E\n"})
public final class UnitActionsTable
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorldScreen worldScreen;
    private int currentPage;
    private int buttonsPerPage;
    private int numPages;
    private int shownForUnitHash;
    private boolean animationNotFinished;
    private static final int maxAllowedPages = 10;
    private static final int minButtonsPerPage = 3;
    private static final int maxButtonsPerPage = 7;
    private static final int maxSinglePageButtons = 5;
    private static final float padBetweenButtons = 2.0f;

    public UnitActionsTable(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.worldScreen = worldScreen;
        this.buttonsPerPage = Integer.MAX_VALUE;
        this.numPages = 2;
        this.defaults().left().padLeft(2.0f).padBottom(2.0f);
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    public final void changePage(int delta, @NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (delta == 0 || this.numPages <= 1) {
            return;
        }
        this.currentPage = (this.currentPage + delta) % this.numPages;
        this.update(unit);
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@Nullable MapUnit unit) {
        int page;
        MapUnit mapUnit = unit;
        int newUnitHash = mapUnit != null ? mapUnit.hashCode() : 0;
        boolean unitChanged = false;
        if (this.shownForUnitHash != newUnitHash) {
            unitChanged = true;
            this.currentPage = 0;
            this.shownForUnitHash = newUnitHash;
        }
        this.clear();
        ActivationExtensionsKt.getKeyShortcuts(this).clear();
        if (unit == null) {
            return;
        }
        if (!this.worldScreen.getCanChangeState()) {
            return;
        }
        this.numPages = 0;
        int n = 0;
        ArrayDeque[] arrayDequeArray = new ArrayDeque[10];
        while (n < 10) {
            int n2 = n++;
            arrayDequeArray[n2] = new ArrayDeque();
        }
        ArrayDeque[] pageActionBuckets = arrayDequeArray;
        Pair<UnitAction, UnitAction> pair = UnitActions.INSTANCE.getPagingActions$core(unit, this);
        UnitAction nextPageAction = pair.component1();
        UnitAction previousPageAction = pair.component2();
        Button nextPageButton = this.getUnitActionButton(unit, nextPageAction);
        Button previousPageButton = this.getUnitActionButton(unit, previousPageAction);
        this.updateButtonsPerPage(nextPageButton);
        Object $this$sortedByDescending$iv = UnitActions.INSTANCE.getUnitActions(unit);
        boolean $i$f$sortedByDescending = false;
        Sequence<UnitAction> sortedUnitActions = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                UnitAction it = (UnitAction)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getUseFrequency());
                it = (UnitAction)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(it.getUseFrequency()));
            }
        });
        $this$sortedByDescending$iv = sortedUnitActions.iterator();
        while ($this$sortedByDescending$iv.hasNext()) {
            int actionPage;
            UnitAction unitAction = (UnitAction)$this$sortedByDescending$iv.next();
            for (actionPage = UnitActions.INSTANCE.getActionDefaultPage(unit, unitAction.getType()); actionPage < 10 && UnitActionsTable.update$freeSlotsOnPage(this, pageActionBuckets, actionPage) <= 0; ++actionPage) {
            }
            if (actionPage >= 10) break;
            if (actionPage >= this.numPages) {
                this.numPages = actionPage + 1;
            }
            pageActionBuckets[actionPage].addLast(unitAction);
        }
        for (page = 0; page < 9; ++page) {
            while (UnitActionsTable.update$freeSlotsOnPage(this, pageActionBuckets, page) < 0) {
                UnitAction element = (UnitAction)pageActionBuckets[page].removeLast();
                pageActionBuckets[page + 1].addFirst(element);
                if (this.numPages >= page + 2) continue;
                this.numPages = page + 2;
            }
        }
        if (this.numPages == 2 && this.buttonsPerPage >= 5 && pageActionBuckets[0].size() + pageActionBuckets[1].size() <= 5) {
            pageActionBuckets[0].addAll(pageActionBuckets[1]);
            pageActionBuckets[1].clear();
            this.numPages = 1;
        }
        page = this.numPages;
        int element = this.currentPage;
        if (!(0 <= element ? element < page : false)) {
            this.currentPage = 0;
        }
        for (UnitAction unitAction : pageActionBuckets[this.currentPage]) {
            Button button = this.getUnitActionButton(unit, unitAction);
            if (unitAction instanceof UpgradeUnitAction) {
                button.setDisabled(false);
                button.setTouchable(Touchable.enabled);
                ActivationExtensionsKt.onRightClick$default(button, null, () -> UnitActionsTable.update$lambda$1(this, button, unit, unitAction), 1, null);
            }
            this.add((Actor)button).colspan(2).row();
        }
        if (this.currentPage > 0) {
            this.add((Actor)previousPageButton);
        }
        if (this.currentPage < this.numPages - 1) {
            this.add((Actor)nextPageButton);
        }
        if (UncivGame.Companion.getCurrent().getSettings().getUnitActionsTableAnimation() && (unitChanged || this.animationNotFinished)) {
            void $this$filterIsInstanceTo$iv$iv;
            SnapshotArray<Actor> snapshotArray = this.getChildren();
            Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
            Iterable $this$filterIsInstance$iv = snapshotArray;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Button)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List buttons = (List)destination$iv$iv;
            float delay2 = 0.0f;
            for (Button button : buttons) {
                this.animateButton(button, delay2);
                delay2 += 0.05f;
            }
        }
        this.pack();
        int n3 = pageActionBuckets.length;
        for (page = 0; page < n3; ++page) {
            if (page == this.currentPage) continue;
            for (UnitAction unitAction : pageActionBuckets[page]) {
                if (unitAction.getAction() == null) continue;
                KeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(this), unitAction.getType().getBinding(), 0, () -> UnitActionsTable.update$lambda$2(this, unitAction, unit), 2, null);
            }
        }
    }

    private final void updateButtonsPerPage(Button button) {
        float upperLimit = this.worldScreen.getTechPolicyAndDiplomacy$core().getY();
        float lowerLimit = this.getY();
        float availableHeight = upperLimit - lowerLimit - 2.0f;
        float buttonHeight = button.getHeight() + 2.0f;
        this.buttonsPerPage = RangesKt.coerceIn((int)(availableHeight / buttonHeight), 3, 7);
    }

    private final Button getUnitActionButton(MapUnit unit, UnitAction unitAction) {
        Actor icon = UnitAction.getIcon$default(unitAction, 0.0f, 1, null);
        KeyboardBinding binding = unitAction.getType().getBinding();
        Color fontColor = unitAction.isCurrentAction() ? Color.YELLOW : Color.WHITE;
        String string = unitAction.getTitle();
        Intrinsics.checkNotNull(fontColor);
        IconTextButton actionButton = new IconTextButton(string, icon, 0, fontColor, 4, null);
        actionButton.getLabelCell().padTop(0.0f);
        if (unitAction.getType() == UnitActionType.Promote && unitAction.getAction() != null) {
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            actionButton.setColor(Scene2dExtensionsKt.brighten(color, 0.5f));
        }
        actionButton.pack();
        if (unitAction.getAction() == null) {
            Scene2dExtensionsKt.disable(actionButton);
        } else {
            ActivationExtensionsKt.onActivation(actionButton, unitAction.getUncivSound(), binding, () -> UnitActionsTable.getUnitActionButton$lambda$0(this, unitAction, unit));
        }
        return actionButton;
    }

    private final void activateAction(UnitAction unitAction, MapUnit unit) {
        Function0<Unit> function0 = unitAction.getAction();
        Intrinsics.checkNotNull(function0);
        function0.invoke();
        this.worldScreen.setShouldUpdate(true);
        this.worldScreen.getMapHolder().removeUnitActionOverlay();
        if (!UncivGame.Companion.getCurrent().getSettings().getAutoUnitCycle()) {
            return;
        }
        if (unit.isDestroyed() || unitAction.getType().isSkippingToNextUnit() && (!unit.isMoving() || !unit.hasMovement())) {
            WorldScreen.switchToNextUnit$default(this.worldScreen, false, 1, null);
        } else {
            this.worldScreen.getBottomUnitTable$core().setShouldUpdate(true);
        }
    }

    private final void animateButton(Button button, float delay2) {
        button.getColor().a = 0.0f;
        button.addAction(Actions.sequence((Action)Actions.run(() -> UnitActionsTable.animateButton$lambda$0(this)), (Action)Actions.run(() -> UnitActionsTable.animateButton$lambda$1(button, delay2)), (Action)Actions.run(() -> UnitActionsTable.animateButton$lambda$2(this))));
    }

    @Readonly
    private static final int update$freeSlotsOnPage(UnitActionsTable this$0, ArrayDeque<UnitAction>[] pageActionBuckets, int page) {
        return this$0.buttonsPerPage - pageActionBuckets[page].size() - (this$0.numPages > 1 ? 1 : 0);
    }

    private static final Unit update$lambda$1(UnitActionsTable this$0, Button $button, MapUnit $unit, UnitAction $unitAction) {
        new UnitUpgradeMenu(this$0.worldScreen.getStage(), (Actor)$button, $unit, (UpgradeUnitAction)$unitAction, $unitAction.getAction() != null, true, () -> UnitActionsTable.update$lambda$1$0(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$1$0(UnitActionsTable this$0) {
        this$0.worldScreen.setShouldUpdate(true);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$2(UnitActionsTable this$0, UnitAction $unitAction, MapUnit $unit) {
        this$0.activateAction($unitAction, $unit);
        return Unit.INSTANCE;
    }

    private static final Unit getUnitActionButton$lambda$0(UnitActionsTable this$0, UnitAction $unitAction, MapUnit $unit) {
        this$0.activateAction($unitAction, $unit);
        return Unit.INSTANCE;
    }

    private static final void animateButton$lambda$0(UnitActionsTable this$0) {
        this$0.animationNotFinished = true;
    }

    private static final void animateButton$lambda$1(Button $button, float $delay) {
        $button.addAction(Actions.moveBy(-150.0f, 0.0f));
        $button.addAction(Actions.alpha(1.0f, 0.15f));
        $button.addAction(Actions.delay($delay, Actions.moveBy(150.0f, 0.0f, 0.15f, Interpolation.smooth)));
    }

    private static final void animateButton$lambda$2(UnitActionsTable this$0) {
        this$0.animationNotFinished = false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable$Companion;", "", "<init>", "()V", "maxAllowedPages", "", "minButtonsPerPage", "maxButtonsPerPage", "maxSinglePageButtons", "padBetweenButtons", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

