/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.jvm.nio;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/ktor/utils/io/jvm/nio/ReadableByteChannelSource;", "Lkotlinx/io/RawSource;", "Ljava/nio/channels/ReadableByteChannel;", "channel", "<init>", "(Ljava/nio/channels/ReadableByteChannel;)V", "Lkotlinx/io/Buffer;", "sink", "", "byteCount", "readAtMostTo", "(Lkotlinx/io/Buffer;J)J", "", "close", "()V", "", "toString", "()Ljava/lang/String;", "Ljava/nio/channels/ReadableByteChannel;", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nReading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reading.kt\nio/ktor/utils/io/jvm/nio/ReadableByteChannelSource\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n*L\n1#1,78:1\n195#2,28:79\n*S KotlinDebug\n*F\n+ 1 Reading.kt\nio/ktor/utils/io/jvm/nio/ReadableByteChannelSource\n*L\n62#1:79,28\n*E\n"})
class ReadableByteChannelSource
implements RawSource {
    @NotNull
    private final ReadableByteChannel channel;

    public ReadableByteChannelSource(@NotNull ReadableByteChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        this.channel = channel2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        void pos;
        void limit;
        Intrinsics.checkNotNullParameter(sink, "sink");
        if (byteCount <= 0L) {
            return 0L;
        }
        int readTotal = 0;
        int actualByteCount = (int)Math.min(byteCount, Integer.MAX_VALUE);
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        int minimumCapacity$iv = 1;
        boolean $i$f$writeToTail = false;
        Segment tail$iv = sink.writableSegment(minimumCapacity$iv);
        byte[] data$iv = tail$iv.dataAsByteArray(false);
        int n = data$iv.length;
        int n2 = tail$iv.getLimit();
        byte[] data = data$iv;
        boolean bl = false;
        int maxToCopy = Math.min(actualByteCount, (int)(limit - pos));
        ByteBuffer buffer = ByteBuffer.wrap(data, (int)pos, maxToCopy);
        readTotal = this.channel.read(buffer);
        int bytesWritten$iv = Math.max(readTotal, 0);
        if (bytesWritten$iv == minimumCapacity$iv) {
            tail$iv.writeBackData(data$iv, bytesWritten$iv);
            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
            sink.setSizeMut(sink.getSizeMut() + (long)bytesWritten$iv);
        } else {
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl2 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                sink.setSizeMut(sink.getSizeMut() + (long)bytesWritten$iv);
            } else if (SegmentKt.isEmpty(tail$iv)) {
                sink.recycleTail();
            }
        }
        return readTotal;
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @NotNull
    public String toString() {
        return "ReadableByteChannelSource(" + this.channel + ')';
    }
}

