/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.tech;

import com.unciv.Constants;
import com.unciv.logic.GameInfo;
import com.unciv.logic.MultiFilter;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.objectdescriptions.TechnologyDescriptions;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\fH\u0007J\b\u0010&\u001a\u00020'H\u0007J\u000e\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\fH\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010/2\u0006\u0010#\u001a\u00020$H\u0016J&\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\f2\n\b\u0002\u00102\u001a\u0004\u0018\u0001032\b\b\u0002\u00104\u001a\u00020'H\u0007J\u001c\u00105\u001a\u00020'2\u0006\u00101\u001a\u00020\f2\n\b\u0002\u00102\u001a\u0004\u0018\u000103H\u0007J\u0010\u00106\u001a\u00020'2\u0006\u00107\u001a\u000208H\u0007J\u0010\u00109\u001a\u00020'2\u0006\u00107\u001a\u000208H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR*\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0007\"\u0004\b\u001c\u0010\tR\u001a\u0010\u001d\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006:"}, d2={"Lcom/unciv/models/ruleset/tech/Technology;", "Lcom/unciv/models/ruleset/RulesetObject;", "<init>", "()V", "cost", "", "getCost", "()I", "setCost", "(I)V", "prerequisites", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getPrerequisites", "()Ljava/util/HashSet;", "setPrerequisites", "(Ljava/util/HashSet;)V", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "column", "Lcom/unciv/models/ruleset/tech/TechColumn;", "getColumn", "()Lcom/unciv/models/ruleset/tech/TechColumn;", "setColumn", "(Lcom/unciv/models/ruleset/tech/TechColumn;)V", "row", "getRow", "setRow", "quote", "getQuote", "()Ljava/lang/String;", "setQuote", "(Ljava/lang/String;)V", "getSortGroup", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "era", "isContinuallyResearchable", "", "getDescription", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "makeLink", "getCivilopediaTextLines", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "Lcom/unciv/models/ruleset/tech/Era;", "matchesFilter", "filter", "state", "Lcom/unciv/models/ruleset/unique/GameContext;", "multiFilter", "matchesSingleFilter", "uniqueIsRequirementForThisTech", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "uniqueIsNotRequirementForThisTech", "core"})
@SourceDebugExtension(value={"SMAP\nTechnology.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Technology.kt\ncom/unciv/models/ruleset/tech/Technology\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class Technology
extends RulesetObject {
    private int cost;
    @NotNull
    private HashSet<String> prerequisites = new HashSet();
    @Nullable
    private TechColumn column;
    private int row;
    @NotNull
    private String quote = "";

    public final int getCost() {
        return this.cost;
    }

    public final void setCost(int n) {
        this.cost = n;
    }

    @NotNull
    public final HashSet<String> getPrerequisites() {
        return this.prerequisites;
    }

    public final void setPrerequisites(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.prerequisites = hashSet;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Tech;
    }

    @Nullable
    public final TechColumn getColumn() {
        return this.column;
    }

    public final void setColumn(@Nullable TechColumn techColumn) {
        this.column = techColumn;
    }

    public final int getRow() {
        return this.row;
    }

    public final void setRow(int n) {
        this.row = n;
    }

    @NotNull
    public final String getQuote() {
        return this.quote;
    }

    public final void setQuote(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.quote = string;
    }

    @Override
    public int getSortGroup(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        TechColumn techColumn = this.column;
        return techColumn != null ? techColumn.getColumnNumber() : 0;
    }

    @Readonly
    @NotNull
    public final String era() {
        TechColumn techColumn = this.column;
        Intrinsics.checkNotNull(techColumn);
        return techColumn.getEra();
    }

    @Readonly
    public final boolean isContinuallyResearchable() {
        return IHasUniques.hasUnique$default(this, UniqueType.ResearchableMultipleTimes, null, 2, null);
    }

    @NotNull
    public final String getDescription(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return TechnologyDescriptions.INSTANCE.getDescription(this, viewingCiv);
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Technology/" + this.getName();
    }

    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return TechnologyDescriptions.INSTANCE.getCivilopediaTextLines(this, ruleset);
    }

    @Override
    @Nullable
    public Era era(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return ruleset.getEras().get(this.era());
    }

    @Readonly
    public final boolean matchesFilter(@NotNull String filter2, @Nullable GameContext state, boolean multiFilter) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return multiFilter ? MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, arg_0 -> Technology.matchesFilter$lambda$0(this, filter2, state, arg_0), false, 4, null) : this.matchesSingleFilter(filter2, state) || state != null && this.hasTagUnique(filter2, state) || state == null && this.hasTagUnique(filter2);
    }

    public static /* synthetic */ boolean matchesFilter$default(Technology technology, String string, GameContext gameContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return technology.matchesFilter(string, gameContext, bl);
    }

    @Readonly
    public final boolean matchesSingleFilter(@NotNull String filter2, @Nullable GameContext state) {
        Object object;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        String string = filter2;
        return Constants.INSTANCE.getAll().contains(string) ? true : (Intrinsics.areEqual(string, this.getName()) ? true : (Intrinsics.areEqual(string, this.era()) ? true : ((object = state) != null && (object = ((GameContext)object).getGameInfo()) != null && (object = ((GameInfo)object).getRuleset()) != null && (object = ((Ruleset)object).getEras()) != null && (object = ((LinkedHashMap)object).get(this.era())) != null ? ((Era)object).matchesFilter(filter2, state, false) : false)));
    }

    public static /* synthetic */ boolean matchesSingleFilter$default(Technology technology, String string, GameContext gameContext, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = null;
        }
        return technology.matchesSingleFilter(string, gameContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean uniqueIsRequirementForThisTech(@NotNull Unique unique) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        if (unique.getType() != UniqueType.OnlyAvailable) return false;
        if (unique.getModifiers().size() != 1) return false;
        Unique it = unique.getModifiers().get(0);
        boolean bl = false;
        if (it.getType() != UniqueType.ConditionalTech) return false;
        if (!Intrinsics.areEqual(it.getParams().get(0), this.getName())) return false;
        return true;
    }

    @Readonly
    public final boolean uniqueIsNotRequirementForThisTech(@NotNull Unique unique) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        return !this.uniqueIsRequirementForThisTech(unique);
    }

    private static final boolean matchesFilter$lambda$0(Technology this$0, String $filter, GameContext $state, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.matchesSingleFilter($filter, $state) || $state != null && this$0.hasTagUnique($filter, $state) || $state == null && this$0.hasTagUnique($filter);
    }
}

