/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenArchetypesProvider;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenSystemIndicesManager;
import org.jetbrains.idea.maven.indices.archetype.MavenCatalog;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.project.MavenEmbedderWrappers;
import org.jetbrains.idea.maven.project.MavenEmbedderWrappersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0016J6\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\b\u0010\u0014\u001a\u0004\u0018\u00010\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J'\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H\u001f0!H\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenArchetypeManager;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getArchetypes", "", "Lorg/jetbrains/idea/maven/model/MavenArchetype;", "catalog", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog;", "", "localArchetypes", "getLocalArchetypes", "()Ljava/util/Collection;", "innerArchetypes", "getInnerArchetypes", "path", "Ljava/nio/file/Path;", "getRemoteArchetypes", "url", "Ljava/net/URL;", "", "resolveAndGetArchetypeDescriptor", "", "groupId", "artifactId", "version", "addToLocalIndex", "", "executeWithMavenEmbedderWrapper", "R", "function", "Lkotlin/Function1;", "Lorg/jetbrains/idea/maven/server/MavenEmbedderWrapper;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenArchetypeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenArchetypeManager.kt\norg/jetbrains/idea/maven/indices/MavenArchetypeManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,278:1\n30#2,2:279\n*S KotlinDebug\n*F\n+ 1 MavenArchetypeManager.kt\norg/jetbrains/idea/maven/indices/MavenArchetypeManager\n*L\n171#1:279,2\n*E\n"})
public final class MavenArchetypeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private static final String ELEMENT_ARCHETYPES = "archetypes";
    @NotNull
    private static final String ELEMENT_ARCHETYPE = "archetype";
    @NotNull
    private static final String ELEMENT_GROUP_ID = "groupId";
    @NotNull
    private static final String ELEMENT_ARTIFACT_ID = "artifactId";
    @NotNull
    private static final String ELEMENT_VERSION = "version";
    @NotNull
    private static final String ELEMENT_REPOSITORY = "repository";
    @NotNull
    private static final String ELEMENT_DESCRIPTION = "description";

    public MavenArchetypeManager(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public final Collection<MavenArchetype> getArchetypes(@NotNull MavenCatalog catalog) {
        Intrinsics.checkNotNullParameter((Object)catalog, (String)"catalog");
        if (catalog instanceof MavenCatalog.System.Internal) {
            return this.getInnerArchetypes();
        }
        if (catalog instanceof MavenCatalog.System.DefaultLocal) {
            return this.getLocalArchetypes();
        }
        if (catalog instanceof MavenCatalog.System.MavenCentral) {
            return this.getRemoteArchetypes(((MavenCatalog.System.MavenCentral)catalog).getUrl());
        }
        if (catalog instanceof MavenCatalog.Local) {
            return this.getInnerArchetypes(((MavenCatalog.Local)catalog).getPath());
        }
        if (catalog instanceof MavenCatalog.Remote) {
            return this.getRemoteArchetypes(((MavenCatalog.Remote)catalog).getUrl());
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final Set<MavenArchetype> getArchetypes() {
        MavenIndicesManager indicesManager = MavenIndicesManager.Companion.getInstance(this.myProject);
        Set result2 = new HashSet<MavenArchetype>(this.getInnerArchetypes());
        result2.addAll((Collection)Companion.loadUserArchetypes(MavenArchetypeManager.Companion.getUserArchetypesFile()));
        if (!indicesManager.isInit()) {
            indicesManager.updateIndicesListSync();
        }
        for (MavenArchetypesProvider each : MavenArchetypesProvider.EP_NAME.getExtensionList()) {
            Collection<MavenArchetype> collection = each.getArchetypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getArchetypes(...)");
            result2.addAll(collection);
        }
        return result2;
    }

    @NotNull
    public final Collection<MavenArchetype> getLocalArchetypes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final Collection<MavenArchetype> getInnerArchetypes() {
        Object[] objectArray = new MavenArchetype[]{new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-archetype", "1.0", null, "An archetype which contains a sample archetype."), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-j2ee-simple", "1.0", null, "An archetype which contains a simplified sample J2EE application."), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-plugin", "1.2", null, "An archetype which contains a sample Maven plugin."), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-plugin-site", "1.1", null, "An archetype which contains a sample Maven plugin site. This archetype can be layered upon an existing Maven plugin project."), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-portlet", "1.0.1", null, "An archetype which contains a sample JSR-268 Portlet."), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-profiles", "1.0-alpha-4", null, ""), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-quickstart", "1.1", null, "An archetype which contains a sample Maven project."), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-site", "1.1", null, "An archetype which contains a sample Maven site which demonstrates some of the supported document types like APT, XDoc, and FML and demonstrates how to i18n your site. This archetype can be layered upon an existing Maven project."), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-site-simple", "1.1", null, "An archetype which contains a sample Maven site."), new MavenArchetype("org.apache.maven.archetypes", "maven-archetype-webapp", "1.0", null, "An archetype which contains a sample Maven Webapp project.")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Collection<MavenArchetype> getInnerArchetypes(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (Collection)this.executeWithMavenEmbedderWrapper(arg_0 -> MavenArchetypeManager.getInnerArchetypes$lambda$0(path, arg_0));
    }

    @NotNull
    public final Collection<MavenArchetype> getRemoteArchetypes(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        return this.getRemoteArchetypes(string);
    }

    @NotNull
    public final Collection<MavenArchetype> getRemoteArchetypes(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (Collection)this.executeWithMavenEmbedderWrapper(arg_0 -> MavenArchetypeManager.getRemoteArchetypes$lambda$0(url, arg_0));
    }

    @Nullable
    public final Map<String, String> resolveAndGetArchetypeDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)ELEMENT_GROUP_ID);
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)ELEMENT_ARTIFACT_ID);
        Intrinsics.checkNotNullParameter((Object)version, (String)ELEMENT_VERSION);
        Map map = (Map)this.executeWithMavenEmbedderWrapper(arg_0 -> MavenArchetypeManager.resolveAndGetArchetypeDescriptor$lambda$0(groupId, artifactId, version, url, arg_0));
        if (map != null) {
            this.addToLocalIndex(groupId, artifactId, version);
        }
        return map;
    }

    private final void addToLocalIndex(String groupId, String artifactId, String version) {
        MavenId mavenId = new MavenId(groupId, artifactId, version);
        MavenRepositoryInfo localRepo = MavenIndexUtils.getLocalRepository(this.myProject);
        if (localRepo == null) {
            return;
        }
        Path path = Path.of(localRepo.getUrl(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path artifactPath = MavenUtil.getArtifactPath(path, mavenId, "jar", null);
        if (artifactPath != null && Files.exists(artifactPath, new LinkOption[0])) {
            MavenIndicesManager mavenIndicesManager = MavenIndicesManager.Companion.getInstance(this.myProject);
            String string = localRepo.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            mavenIndicesManager.scheduleArtifactIndexing(mavenId, artifactPath, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R executeWithMavenEmbedderWrapper(Function1<? super MavenEmbedderWrapper, ? extends R> function) {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        Ref.ObjectRef baseDir = new Ref.ObjectRef();
        baseDir.element = "";
        List<MavenProject> list = projectsManager.getRootProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRootProjects(...)");
        List<MavenProject> projects = list;
        if (!projects.isEmpty()) {
            MavenProject mavenProject = projects.get(0);
            Intrinsics.checkNotNull((Object)mavenProject);
            baseDir.element = ((Object)MavenUtil.getBaseDir(mavenProject.getDirectoryFile())).toString();
        }
        ComponentManager $this$service$iv = (ComponentManager)this.myProject;
        boolean $i$f$service = false;
        Class<MavenEmbedderWrappersManager> serviceClass$iv = MavenEmbedderWrappersManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        MavenEmbedderWrappers mavenEmbedderWrappers = ((MavenEmbedderWrappersManager)object).createMavenEmbedderWrappers();
        AutoCloseable autoCloseable = mavenEmbedderWrappers;
        Throwable throwable = null;
        try {
            MavenEmbedderWrappers it = (MavenEmbedderWrappers)autoCloseable;
            boolean bl = false;
            MavenEmbedderWrapper mavenEmbedderWrapper2 = (MavenEmbedderWrapper)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MavenEmbedderWrapper>, Object>(mavenEmbedderWrappers, (Ref.ObjectRef<String>)baseDir, null){
                int label;
                final /* synthetic */ MavenEmbedderWrappers $mavenEmbedderWrappers;
                final /* synthetic */ Ref.ObjectRef<String> $baseDir;
                {
                    this.$mavenEmbedderWrappers = $mavenEmbedderWrappers;
                    this.$baseDir = $baseDir;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$mavenEmbedderWrappers.getEmbedder((String)this.$baseDir.element, (Continuation<? super MavenEmbedderWrapper>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super MavenEmbedderWrapper> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            Object object2 = function.invoke((Object)mavenEmbedderWrapper2);
            return (R)object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final Collection getInnerArchetypes$lambda$0(Path $path, MavenEmbedderWrapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getInnerArchetypes($path);
    }

    private static final Collection getRemoteArchetypes$lambda$0(String $url, MavenEmbedderWrapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRemoteArchetypes($url);
    }

    private static final Map resolveAndGetArchetypeDescriptor$lambda$0(String $groupId, String $artifactId, String $version, String $url, MavenEmbedderWrapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.resolveAndGetArchetypeDescriptor($groupId, $artifactId, $version, new ArrayList(), $url);
    }

    @JvmStatic
    @NotNull
    public static final MavenArchetypeManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/indices/MavenArchetypeManager$Companion;", "", "<init>", "()V", "ELEMENT_ARCHETYPES", "", "ELEMENT_ARCHETYPE", "ELEMENT_GROUP_ID", "ELEMENT_ARTIFACT_ID", "ELEMENT_VERSION", "ELEMENT_REPOSITORY", "ELEMENT_DESCRIPTION", "getInstance", "Lorg/jetbrains/idea/maven/indices/MavenArchetypeManager;", "project", "Lcom/intellij/openapi/project/Project;", "loadUserArchetypes", "", "Lorg/jetbrains/idea/maven/model/MavenArchetype;", "userArchetypesPath", "Ljava/nio/file/Path;", "addArchetype", "", "archetype", "userArchetypesFile", "getUserArchetypesFile", "()Ljava/nio/file/Path;", "saveUserArchetypes", "userArchetypes", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MavenArchetypeManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(MavenArchetypeManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (MavenArchetypeManager)object;
        }

        @NotNull
        public final List<MavenArchetype> loadUserArchetypes(@NotNull Path userArchetypesPath) {
            Intrinsics.checkNotNullParameter((Object)userArchetypesPath, (String)"userArchetypesPath");
            try {
                if (!Files.exists(userArchetypesPath, new LinkOption[0])) {
                    return CollectionsKt.emptyList();
                }
                Collection result2 = new LinkedHashSet();
                List children = JDOMUtil.load((Path)userArchetypesPath).getChildren(MavenArchetypeManager.ELEMENT_ARCHETYPE);
                int n = ((Collection)children).size() + -1;
                if (0 <= n) {
                    do {
                        int i2 = n--;
                        Element each = (Element)children.get(i2);
                        String groupId = each.getAttributeValue(MavenArchetypeManager.ELEMENT_GROUP_ID);
                        String artifactId = each.getAttributeValue(MavenArchetypeManager.ELEMENT_ARTIFACT_ID);
                        String version = each.getAttributeValue(MavenArchetypeManager.ELEMENT_VERSION);
                        String repository = each.getAttributeValue(MavenArchetypeManager.ELEMENT_REPOSITORY);
                        String description = each.getAttributeValue(MavenArchetypeManager.ELEMENT_DESCRIPTION);
                        CharSequence charSequence = groupId;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)artifactId) == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)version) == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                        result2.add(new MavenArchetype(groupId, artifactId, version, repository, description));
                    } while (0 <= n);
                }
                List listResult = CollectionsKt.toMutableList((Collection)result2);
                CollectionsKt.reverse((List)listResult);
                return listResult;
            }
            catch (IOException e) {
                MavenLog.LOG.warn((Throwable)e);
                return new ArrayList();
            }
            catch (JDOMException e) {
                MavenLog.LOG.warn((Throwable)e);
                return new ArrayList();
            }
        }

        public final void addArchetype(@NotNull MavenArchetype archetype, @NotNull Path userArchetypesPath) {
            Intrinsics.checkNotNullParameter((Object)archetype, (String)MavenArchetypeManager.ELEMENT_ARCHETYPE);
            Intrinsics.checkNotNullParameter((Object)userArchetypesPath, (String)"userArchetypesPath");
            List archetypes = new ArrayList(this.loadUserArchetypes(userArchetypesPath));
            int idx = archetypes.indexOf(archetype);
            if (idx >= 0) {
                archetypes.set(idx, archetype);
            } else {
                archetypes.add(archetype);
            }
            this.saveUserArchetypes(archetypes, userArchetypesPath);
        }

        private final Path getUserArchetypesFile() {
            Path path = MavenSystemIndicesManager.Companion.getInstance().getIndicesDir().resolve("UserArchetypes.xml");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final void saveUserArchetypes(List<MavenArchetype> userArchetypes, Path userArchetypesPath) {
            Element root = new Element(MavenArchetypeManager.ELEMENT_ARCHETYPES);
            for (MavenArchetype each : userArchetypes) {
                Element childElement = new Element(MavenArchetypeManager.ELEMENT_ARCHETYPE);
                childElement.setAttribute(MavenArchetypeManager.ELEMENT_GROUP_ID, each.groupId);
                childElement.setAttribute(MavenArchetypeManager.ELEMENT_ARTIFACT_ID, each.artifactId);
                childElement.setAttribute(MavenArchetypeManager.ELEMENT_VERSION, each.version);
                if (each.repository != null) {
                    childElement.setAttribute(MavenArchetypeManager.ELEMENT_REPOSITORY, each.repository);
                }
                if (each.description != null) {
                    childElement.setAttribute(MavenArchetypeManager.ELEMENT_DESCRIPTION, each.description);
                }
                root.addContent(childElement);
            }
            try {
                JDOMUtil.write((Element)root, (Path)userArchetypesPath);
            }
            catch (IOException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

