/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/config/GroovyLanguageVersionCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "groovySdkVersion", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "getGroup", "requiresReadAccess", "", "requiresSmartMode", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nGroovyLanguageVersionCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyLanguageVersionCollector.kt\norg/jetbrains/plugins/groovy/config/GroovyLanguageVersionCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1869#2,2:37\n*S KotlinDebug\n*F\n+ 1 GroovyLanguageVersionCollector.kt\norg/jetbrains/plugins/groovy/config/GroovyLanguageVersionCollector\n*L\n27#1:37,2\n*E\n"})
public final class GroovyLanguageVersionCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup group = new EventLogGroup("groovy.language", 1, null, 4, null);
    @NotNull
    private final EventId1<String> groovySdkVersion = this.group.registerEvent("GROOVY_SDK_VERSION", (EventField)EventFields.Version);

    @NotNull
    public EventLogGroup getGroup() {
        return this.group;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    protected boolean requiresSmartMode() {
        return true;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set metricEventSet = new LinkedHashSet();
        List<VirtualFile> list = LibrariesUtil.findAllJarsWithClass(project, "org.codehaus.groovy.control.CompilationUnit");
        Intrinsics.checkNotNullExpressionValue(list, (String)"findAllJarsWithClass(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile jar = (VirtualFile)element$iv;
            boolean bl = false;
            Object object = jar.getParent();
            if (object == null || (object = object.getPath()) == null) continue;
            Object path = object;
            boolean bl2 = false;
            String version = GroovyConfigUtils.getInstance().getSDKVersionOrNull((String)path);
            metricEventSet.add(this.groovySdkVersion.metric((Object)version));
        }
        return metricEventSet;
    }
}

