/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.debugger;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.task.debugger.GradleDebuggerSupport;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/service/debugger/GradleJvmDebuggerBackend;", "Lcom/intellij/openapi/externalSystem/debugger/DebuggerBackendExtension;", "<init>", "()V", "id", "", "debugConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "processName", "processParameters", "Companion", "intellij.gradle.java"})
public final class GradleJvmDebuggerBackend
implements DebuggerBackendExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "Gradle JVM";

    @NotNull
    public String id() {
        return ID;
    }

    @NotNull
    public RunnerAndConfigurationSettings debugConfigurationSettings(@NotNull Project project, @NotNull String processName, @NotNull String processParameters) {
        String localDebuggerPort;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        RunManager runManager = RunManager.Companion.getInstance(project);
        RunnerAndConfigurationSettings runSettings = runManager.createConfiguration(processName, RemoteConfigurationType.class);
        HashMap description = this.splitParameters(processParameters);
        RunConfiguration runConfiguration = runSettings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.execution.remote.RemoteConfiguration");
        RemoteConfiguration configuration = (RemoteConfiguration)runConfiguration;
        configuration.HOST = "localhost";
        String debuggerPort = (String)description.get("DEBUG_SERVER_PORT");
        configuration.PORT = localDebuggerPort = GradleDebuggerSupport.getDebuggeeLocalPort((Project)project, (String)debuggerPort);
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = true;
        configuration.putUserData(DebuggerBackendExtension.RUNTIME_MODULE_DIR_KEY, description.get("MODULE_DIR"));
        return runSettings;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/service/debugger/GradleJvmDebuggerBackend$Companion;", "", "<init>", "()V", "ID", "", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

