/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryDataListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDiscoveryProjectData {
    public static final String PROJECT_DATA_OWNER = "com/intellij/rt/coverage/data/TestDiscoveryProjectData";
    public static final String TEST_DISCOVERY_DATA_LISTENER_PROP = "test.discovery.data.listener";
    public static final String INSTRUMENT_SHUTDOWN_HOOKS = "test.discovery.use.very.late.shutdown.hook";
    protected static final TestDiscoveryProjectData ourProjectData = new TestDiscoveryProjectData();
    private final NameEnumerator myNameEnumerator;
    private final ConcurrentMap<Integer, boolean[]> myClassToVisitedMethods = new ConcurrentHashMap<Integer, boolean[]>();
    private final ConcurrentMap<Integer, int[]> myClassToMethodNames = new ConcurrentHashMap<Integer, int[]>();
    final ConcurrentMap<Integer, ClassMetadata> classesToMetadata = new ConcurrentHashMap<Integer, ClassMetadata>();
    private final TestDiscoveryDataListener myDataListener;
    private static Long ourTraceTime = 0L;
    private static Long ourCleanupTime = 0L;
    private volatile boolean myFinished;
    private static final Map<Object, File> myOpenFilesMap = new WeakHashMap<Object, File>();
    private static final Collection<String> myOpenFilesPerTest = new LinkedHashSet<String>();
    public static final String AFFECTED_ROOTS = "test.discovery.affected.roots";
    public static final String EXCLUDED_ROOTS = "test.discovery.excluded.roots";
    public static final String TRACK_FILES = "test.discovery.track.files";
    private static final String[] myAffectedRoots = TestDiscoveryProjectData.split("test.discovery.affected.roots");
    private static final String[] myExcludedRoots = TestDiscoveryProjectData.split("test.discovery.excluded.roots");

    /*
     * WARNING - void declaration
     */
    private TestDiscoveryProjectData() {
        void var1_5;
        try {
            String testDiscoveryDataListener = System.getProperty(TEST_DISCOVERY_DATA_LISTENER_PROP);
            if (testDiscoveryDataListener == null) {
                throw new RuntimeException("Property \"test.discovery.data.listener\" should be specified");
            }
            this.myDataListener = (TestDiscoveryDataListener)Class.forName(testDiscoveryDataListener).newInstance();
            this.myNameEnumerator = this.myDataListener.getNameEnumerator();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        boolean useVeryLateShutDownHook = Boolean.TRUE.toString().equals(System.getProperty(INSTRUMENT_SHUTDOWN_HOOKS));
        if (useVeryLateShutDownHook && !TestDiscoveryProjectData.tryRegisterHook()) {
            useVeryLateShutDownHook = false;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this, (boolean)var1_5){
            final /* synthetic */ boolean val$finalUseVeryLateShutDownHook;
            final /* synthetic */ TestDiscoveryProjectData this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$finalUseVeryLateShutDownHook = bl;
            }

            public void run() {
                this.this$0.testDiscoveryFinished();
                if (!this.val$finalUseVeryLateShutDownHook) {
                    TestDiscoveryProjectData.logTestInfo();
                }
            }
        }));
    }

    public static TestDiscoveryProjectData getProjectData() {
        return ourProjectData;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] trace(String className, boolean[] methodFlags, String[] methodNames) {
        Object object;
        long s = System.nanoTime();
        try {
            void var2_3;
            void var1_2;
            object = ourProjectData.traceLines((String)object, (boolean[])var1_2, (String[])var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            ourTraceTime = ourTraceTime + (System.nanoTime() - var3_4);
            throw throwable;
        }
        ourTraceTime = ourTraceTime + (System.nanoTime() - s);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized boolean[] traceLines(String className, boolean[] methodFlags, String[] methodNames) {
        void var2_3;
        void var3_4;
        void var1_2;
        int classId = this.myNameEnumerator.enumerate(className);
        boolean[] previousMethodFlags = this.myClassToVisitedMethods.putIfAbsent(classId, methodFlags);
        if (previousMethodFlags != null) {
            if (previousMethodFlags.length == methodFlags.length) {
                return previousMethodFlags;
            }
            this.myClassToVisitedMethods.put(classId, methodFlags);
        }
        this.myClassToMethodNames.put((int)var1_2, NameEnumerator.enumerate((String[])var3_4, this.myNameEnumerator));
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void testDiscoveryEnded(String className, String methodName) {
        Exception exception;
        try {
            this.myDataListener.testFinished((String)((Object)exception), methodName, this.myClassToVisitedMethods, this.myClassToMethodNames, this.enumerateFiles(myOpenFilesPerTest));
            block2: for (Map.Entry e : this.myClassToVisitedMethods.entrySet()) {
                for (boolean bl : (boolean[])e.getValue()) {
                    void var2_5;
                    if (!bl) continue;
                    ClassMetadata cm = (ClassMetadata)this.classesToMetadata.remove(e.getKey());
                    if (cm == null) continue block2;
                    this.myDataListener.addClassMetadata(Collections.singletonList(var2_5));
                    continue block2;
                }
            }
            return;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<int[]> enumerateFiles(Collection<String> openedFiles) {
        void var2_2;
        Iterator iterator;
        ArrayList<int[]> files = new ArrayList<int[]>(openedFiles.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String file = (String)iterator.next();
            files.add(this.fileToInts((String)var3_3));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int[] fileToInts(String file) {
        void var2_2;
        String[] split = file.split("/");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = this.myNameEnumerator.enumerate(split[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void testDiscoveryStarted(String className, String methodName) {
        long s = System.nanoTime();
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            void var3_4;
            ourCleanupTime = ourCleanupTime + (System.nanoTime() - var3_4);
            throw throwable;
        }
        ourCleanupTime = ourCleanupTime + (System.nanoTime() - s);
    }

    private void cleanup() {
        for (Map.Entry entry : this.myClassToVisitedMethods.entrySet()) {
            boolean[] used = (boolean[])entry.getValue();
            int len = used.length;
            for (int i = 0; i < len; ++i) {
                if (!used[i]) continue;
                used[i] = false;
            }
        }
        myOpenFilesPerTest.clear();
    }

    public synchronized void testDiscoveryFinished() {
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        try {
            this.myDataListener.testsFinished();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addClassMetadata(List<ClassMetadata> classMetadata) {
        for (ClassMetadata cm : classMetadata) {
            void var2_2;
            this.classesToMetadata.put(this.myNameEnumerator.enumerate(cm.getFqn()), (ClassMetadata)var2_2);
        }
    }

    NameEnumerator getMyNameEnumerator() {
        return this.myNameEnumerator;
    }

    ConcurrentMap<Integer, int[]> getClassToMethodNames() {
        return this.myClassToMethodNames;
    }

    ConcurrentMap<Integer, boolean[]> getClassToVisitedMethods() {
        return this.myClassToVisitedMethods;
    }

    private static String[] split(String key) {
        String string;
        String affected = System.getProperty(key);
        if (affected == null) {
            return new String[0];
        }
        return string.split(";");
    }

    private static String stripRoot(String path) {
        String[] stringArray = myAffectedRoots;
        int n = myAffectedRoots.length;
        for (int i = 0; i < n; ++i) {
            String prefix = stringArray[i];
            if (!path.startsWith(prefix)) continue;
            return path.substring(prefix.length());
        }
        return null;
    }

    private static boolean excluded(String path) {
        String[] stringArray = myExcludedRoots;
        int n = myExcludedRoots.length;
        for (int i = 0; i < n; ++i) {
            String prefix = stringArray[i];
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static String toSystemIndependentName(String fileName) {
        return fileName.replace('\\', '/');
    }

    public static synchronized void openPath(Object path) {
        try {
            Object object;
            Class<?> clazz = Class.forName("java.nio.file.Path");
            File file = (File)clazz.getDeclaredMethod("toFile", new Class[0]).invoke(path, new Object[0]);
            TestDiscoveryProjectData.openFile(object, clazz);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized void openFile(Object o, File file) {
        void var3_3;
        void var1_1;
        Object object;
        void var2_2;
        if (file == null) {
            return;
        }
        String absolutePath = TestDiscoveryProjectData.getPath(file);
        String trimmedPath = TestDiscoveryProjectData.stripRoot(absolutePath);
        if (trimmedPath == null) {
            return;
        }
        if (TestDiscoveryProjectData.excluded((String)var2_2)) {
            return;
        }
        myOpenFilesMap.put(object, (File)var1_1);
        myOpenFilesPerTest.add(TestDiscoveryProjectData.toSystemIndependentName((String)var3_3));
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            File file2;
            return file2.getAbsolutePath();
        }
    }

    public static synchronized void closeFile(Object o) {
        Object object;
        myOpenFilesMap.remove(object);
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void logTestInfo() {
        System.out.println("Trace time: " + 1.0 * (double)ourTraceTime.longValue() / 1.0E9);
        System.out.println("Cleanup time: " + 1.0 * (double)ourCleanupTime.longValue() / 1.0E9);
        System.out.println("Leaked files: " + myOpenFilesMap.size());
        for (File value : new ArrayList<File>(myOpenFilesMap.values())) {
            void var1_1;
            System.out.println(var1_1.getPath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean tryRegisterHook() {
        try {
            void var0;
            void var1_2;
            Object javaLangAccess = TestDiscoveryProjectData.getJavaLangAccess();
            if (javaLangAccess == null) {
                return false;
            }
            Method registerShutdownHook = null;
            for (Method method : javaLangAccess.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("registerShutdownHook")) continue;
                registerShutdownHook = method;
            }
            if (registerShutdownHook == null) {
                return false;
            }
            registerShutdownHook.setAccessible(true);
            var1_2.invoke((Object)var0, 9, Boolean.TRUE, new Runnable(){

                public final void run() {
                    TestDiscoveryProjectData.logTestInfo();
                }
            });
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return false;
        }
    }

    private static Object getJavaLangAccess() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method;
        Class<?> sharedSecrets;
        try {
            sharedSecrets = Class.forName("sun.misc.SharedSecrets");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                sharedSecrets = Class.forName("jdk.internal.misc.SharedSecrets");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
        method = ((Class)((Object)method)).getDeclaredMethod("getJavaLangAccess", new Class[0]);
        return method.invoke(null, new Object[0]);
    }
}

