/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.ir.KlibSymbols;
import org.jetbrains.kotlin.backend.common.ir.PreSerializationKlibSymbols;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\t*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesPrimitiveBoxSpecializationLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/KlibSymbols;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/ir/KlibSymbols;)V", "genericSharedVariableBox", "Lorg/jetbrains/kotlin/backend/common/ir/PreSerializationKlibSymbols$SharedVariableBoxClassInfo;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getPrimitiveBoxClassIfPossible", "Lorg/jetbrains/kotlin/ir/types/IrType;", "replaceIfNeeded", "Transformer", "ir.backend.common"})
public final class SharedVariablesPrimitiveBoxSpecializationLowering
implements BodyLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final KlibSymbols symbols;
    @NotNull
    private final PreSerializationKlibSymbols.SharedVariableBoxClassInfo genericSharedVariableBox;

    public SharedVariablesPrimitiveBoxSpecializationLowering(@NotNull CommonBackendContext context2, @NotNull KlibSymbols symbols) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        this.context = context2;
        this.symbols = symbols;
        this.genericSharedVariableBox = this.symbols.getGenericSharedVariableBox();
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new Transformer());
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix(this, irFile, true);
    }

    private final PreSerializationKlibSymbols.SharedVariableBoxClassInfo getPrimitiveBoxClassIfPossible(IrType $this$getPrimitiveBoxClassIfPossible) {
        if (!($this$getPrimitiveBoxClassIfPossible instanceof IrSimpleType)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)((IrSimpleType)$this$getPrimitiveBoxClassIfPossible).getClassifier(), (Object)this.genericSharedVariableBox.getKlass())) {
            return null;
        }
        IrTypeArgument irTypeArgument = (IrTypeArgument)CollectionsKt.getOrNull(((IrSimpleType)$this$getPrimitiveBoxClassIfPossible).getArguments(), (int)0);
        if (irTypeArgument == null || (irTypeArgument = IrTypesKt.getTypeOrNull(irTypeArgument)) == null) {
            return null;
        }
        IrTypeArgument argument = irTypeArgument;
        return this.symbols.getPrimitiveSharedVariableBoxes().get(argument);
    }

    private final IrType replaceIfNeeded(IrType $this$replaceIfNeeded) {
        Object object = this.getPrimitiveBoxClassIfPossible($this$replaceIfNeeded);
        return object != null && (object = ((PreSerializationKlibSymbols.SharedVariableBoxClassInfo)object).getKlass()) != null && (object = IrTypesKt.getDefaultType((IrClassifierSymbol)object)) != null ? (IrType)object : $this$replaceIfNeeded;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesPrimitiveBoxSpecializationLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesPrimitiveBoxSpecializationLowering;)V", "visitVariable", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitLocalDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.backend.common"})
    private final class Transformer
    extends IrElementTransformerVoid {
        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            declaration.setType(SharedVariablesPrimitiveBoxSpecializationLowering.this.replaceIfNeeded(declaration.getType()));
            return super.visitVariable(declaration);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            declaration.setType(SharedVariablesPrimitiveBoxSpecializationLowering.this.replaceIfNeeded(declaration.getType()));
            return super.visitValueParameter(declaration);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            declaration.setType(SharedVariablesPrimitiveBoxSpecializationLowering.this.replaceIfNeeded(declaration.getType()));
            return super.visitField(declaration);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            declaration.setType(SharedVariablesPrimitiveBoxSpecializationLowering.this.replaceIfNeeded(declaration.getType()));
            return super.visitLocalDelegatedProperty(declaration);
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            declaration.setReturnType(SharedVariablesPrimitiveBoxSpecializationLowering.this.replaceIfNeeded(declaration.getReturnType()));
            return super.visitFunction(declaration);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            expression.setType(SharedVariablesPrimitiveBoxSpecializationLowering.this.replaceIfNeeded(expression.getType()));
            return super.visitExpression(expression);
        }

        @Override
        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression) {
            IrConstructorCallImpl irConstructorCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (!Intrinsics.areEqual((Object)expression.getSymbol(), (Object)SharedVariablesPrimitiveBoxSpecializationLowering.this.genericSharedVariableBox.getConstructor())) {
                return super.visitConstructorCall(expression);
            }
            PreSerializationKlibSymbols.SharedVariableBoxClassInfo sharedVariableBoxClassInfo = SharedVariablesPrimitiveBoxSpecializationLowering.this.getPrimitiveBoxClassIfPossible(expression.getType());
            if (sharedVariableBoxClassInfo == null) {
                return super.visitConstructorCall(expression);
            }
            PreSerializationKlibSymbols.SharedVariableBoxClassInfo primitiveBoxClass = sharedVariableBoxClassInfo;
            IrConstructorCallImpl $this$visitConstructorCall_u24lambda_u240 = irConstructorCallImpl = BuildersKt.IrConstructorCallImpl$default(expression.getStartOffset(), expression.getEndOffset(), IrTypesKt.getDefaultType(primitiveBoxClass.getKlass()), primitiveBoxClass.getConstructor(), 0, 0, expression.getOrigin(), null, 128, null);
            boolean bl = false;
            IrExpression irExpression = (IrExpression)expression.getArguments().get(0);
            $this$visitConstructorCall_u24lambda_u240.getArguments().set(0, irExpression != null ? irExpression.transform((IrTransformer)this, (Object)null) : null);
            return irConstructorCallImpl;
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression) {
            PreSerializationKlibSymbols.SharedVariableBoxClassInfo sharedVariableBoxClassInfo;
            IrType irType;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            IrExpression irExpression = (IrExpression)CollectionsKt.getOrNull((List)expression.getArguments(), (int)0);
            if (irExpression == null || (irType = irExpression.getType()) == null || (sharedVariableBoxClassInfo = SharedVariablesPrimitiveBoxSpecializationLowering.this.getPrimitiveBoxClassIfPossible(irType)) == null) {
                return super.visitCall(expression);
            }
            PreSerializationKlibSymbols.SharedVariableBoxClassInfo primitiveBoxClass = sharedVariableBoxClassInfo;
            if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)SharedVariablesPrimitiveBoxSpecializationLowering.this.genericSharedVariableBox.getLoad())) {
                IrExpression $this$visitCall_u24lambda_u240 = irExpression = BuildersKt.IrCallImpl$default(expression.getStartOffset(), expression.getEndOffset(), expression.getType(), primitiveBoxClass.getLoad(), 0, expression.getOrigin(), null, 80, null);
                boolean bl = false;
                IrExpression irExpression2 = (IrExpression)expression.getArguments().get(0);
                ((IrMemberAccessExpression)$this$visitCall_u24lambda_u240).getArguments().set(0, irExpression2 != null ? irExpression2.transform((IrTransformer)this, (Object)null) : null);
                return irExpression;
            }
            if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)SharedVariablesPrimitiveBoxSpecializationLowering.this.genericSharedVariableBox.getStore())) {
                IrExpression $this$visitCall_u24lambda_u241 = irExpression = BuildersKt.IrCallImpl$default(expression.getStartOffset(), expression.getEndOffset(), SharedVariablesPrimitiveBoxSpecializationLowering.this.context.getIrBuiltIns().getUnitType(), primitiveBoxClass.getStore(), 0, expression.getOrigin(), null, 80, null);
                boolean bl = false;
                IrExpression irExpression3 = (IrExpression)expression.getArguments().get(0);
                ((IrMemberAccessExpression)$this$visitCall_u24lambda_u241).getArguments().set(0, irExpression3 != null ? irExpression3.transform((IrTransformer)this, (Object)null) : null);
                IrExpression irExpression4 = (IrExpression)expression.getArguments().get(1);
                ((IrMemberAccessExpression)$this$visitCall_u24lambda_u241).getArguments().set(1, irExpression4 != null ? irExpression4.transform((IrTransformer)this, (Object)null) : null);
                return irExpression;
            }
            return super.visitCall(expression);
        }
    }
}

