/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.ExponentialBackoff;

public class ExponentialBackoffManager {
    private final int maxAttempts;
    private int attempts;
    private final ExponentialBackoff backoff;

    public ExponentialBackoffManager(int maxAttempts, long initialInterval, int multiplier, long maxInterval, double jitter) {
        this.maxAttempts = maxAttempts;
        this.backoff = new ExponentialBackoff(initialInterval, multiplier, maxInterval, jitter);
    }

    public void incrementAttempt() {
        ++this.attempts;
    }

    public void resetAttempts() {
        this.attempts = 0;
    }

    public boolean canAttempt() {
        return this.attempts < this.maxAttempts;
    }

    public long backOff() {
        return this.backoff.backoff(this.attempts);
    }

    public int attempts() {
        return this.attempts;
    }
}

