/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.tox;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.testing.tox.PyToxConfiguration;
import com.jetbrains.python.testing.tox.PyToxConfigurationFactory;
import com.jetbrains.python.testing.tox.PyToxTestLocator;
import org.jetbrains.annotations.NotNull;

public final class PyToxConfigurationProducer
extends LazyRunConfigurationProducer<PyToxConfiguration> {
    private static final String TOX_FILE_NAME = "tox.ini";

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = PyToxConfigurationFactory.INSTANCE;
        if (configurationFactory == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    public boolean isConfigurationFromContext(@NotNull PyToxConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        VirtualFile virtualFile = location.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String currentPath = virtualFile.getParent().getCanonicalPath();
        String directoryPath = configuration.getWorkingDirectory();
        if (currentPath != null && directoryPath != null && !directoryPath.equals(currentPath)) {
            return false;
        }
        return TOX_FILE_NAME.equals(virtualFile.getName());
    }

    protected boolean setupConfigurationFromContext(@NotNull PyToxConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile file;
        if (configuration == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((file = ((PsiElement)sourceElement.get()).getContainingFile()) == null) {
            return false;
        }
        String envName = PyToxTestLocator.getEnvNameFromElement(file);
        if (envName != null) {
            configuration.setRunOnlyEnvs(envName);
            configuration.setName(String.format("tox: run on %s", envName));
            return true;
        }
        PsiDirectory directory = file.getContainingDirectory();
        if (directory == null) {
            return false;
        }
        configuration.setWorkingDirectory(directory.getVirtualFile().getCanonicalPath());
        if (TOX_FILE_NAME.equals(file.getName())) {
            configuration.setName("tox");
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/tox/PyToxConfigurationProducer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/tox/PyToxConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

