/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.intentions;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.json.JsonBundle;
import com.intellij.json.intentions.AbstractSortPropertiesSession;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\t\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0019\u0010\r\u001a\u00130\u000e\u00a2\u0006\u000e\b\u000f\u0012\n\b\u0010\u0012\u0006\b\n0\u00118\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J!\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0094\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/json/intentions/JsonSortPropertiesIntention;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "createSession", "Lcom/intellij/json/intentions/AbstractSortPropertiesSession;", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/modcommand/ActionContext;", "file", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "element", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "JsonSortSession", "intellij.json.backend"})
public class JsonSortPropertiesIntention
extends PsiUpdateModCommandAction<PsiFile>
implements LightEditCompatible,
DumbAware {
    public JsonSortPropertiesIntention() {
        super(PsiFile.class);
    }

    @NotNull
    protected AbstractSortPropertiesSession<? extends PsiElement, ? extends PsiElement> createSession(@NotNull ActionContext context, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new JsonSortSession(context, file);
    }

    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message((String)"json.intention.sort.properties", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiFile element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        AbstractSortPropertiesSession<? extends PsiElement, ? extends PsiElement> session = this.createSession(context, element);
        PsiElement psiElement = session.getRootElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement root = psiElement;
        if (!session.hasUnsortedObjects()) {
            return null;
        }
        TextRange[] textRangeArray = new TextRange[]{root.getTextRange()};
        return Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.LOW).withHighlighting(textRangeArray);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiFile element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        AbstractSortPropertiesSession<? extends PsiElement, ? extends PsiElement> session = this.createSession(context, element);
        PsiElement psiElement = session.getRootElement();
        if (psiElement == null) {
            return;
        }
        PsiElement root = psiElement;
        session.sort();
        CodeStyleManager.getInstance((Project)context.project()).reformatText(element, (Collection)SetsKt.setOf((Object)root.getTextRange()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00160\u0019H\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/json/intentions/JsonSortPropertiesIntention$JsonSortSession;", "Lcom/intellij/json/intentions/AbstractSortPropertiesSession;", "Lcom/intellij/json/psi/JsonObject;", "Lcom/intellij/json/psi/JsonProperty;", "context", "Lcom/intellij/modcommand/ActionContext;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/modcommand/ActionContext;Lcom/intellij/psi/PsiFile;)V", "findRootObject", "collectObjects", "", "rootObj", "getProperties", "", "obj", "getPropertyName", "", "prop", "getParentObject", "traverseObjects", "", "root", "visitor", "Lkotlin/Function1;", "intellij.json.backend"})
    @SourceDebugExtension(value={"SMAP\nJsonSortPropertiesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSortPropertiesIntention.kt\ncom/intellij/json/intentions/JsonSortPropertiesIntention$JsonSortSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n808#2,11:77\n*S KotlinDebug\n*F\n+ 1 JsonSortPropertiesIntention.kt\ncom/intellij/json/intentions/JsonSortPropertiesIntention$JsonSortSession\n*L\n54#1:77,11\n*E\n"})
    private static final class JsonSortSession
    extends AbstractSortPropertiesSession<JsonObject, JsonProperty> {
        public JsonSortSession(@NotNull ActionContext context, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(context, file);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected JsonObject findRootObject() {
            int offset = this.getContext().offset();
            JsonObject jsonObject = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(offset), JsonObject.class);
            if (jsonObject == null) {
                JsonSortSession $this$findRootObject_u24lambda_u240 = this;
                boolean bl = false;
                PsiFile psiFile = $this$findRootObject_u24lambda_u240.getFile();
                JsonFile jsonFile = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
                if (jsonFile == null) {
                    jsonObject = null;
                } else {
                    void $this$filterIsInstanceTo$iv$iv;
                    JsonFile jsonFile2 = jsonFile;
                    List list = jsonFile2.getAllTopLevelValues();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllTopLevelValues(...)");
                    Iterable $this$filterIsInstance$iv = list;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JsonObject)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (JsonObject)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                }
            }
            JsonObject initObj = jsonObject;
            return (JsonObject)this.adjustToSelectionContainer((PsiElement)initObj);
        }

        @Override
        @NotNull
        protected Set<JsonObject> collectObjects(@NotNull JsonObject rootObj) {
            Intrinsics.checkNotNullParameter((Object)rootObj, (String)"rootObj");
            return this.collectIntersectingObjects((PsiElement)rootObj);
        }

        @Override
        @NotNull
        protected List<JsonProperty> getProperties(@NotNull JsonObject obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            List list = obj.getPropertyList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyList(...)");
            return list;
        }

        @Override
        @Nullable
        protected String getPropertyName(@NotNull JsonProperty prop) {
            Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
            return prop.getName();
        }

        @Override
        @Nullable
        protected JsonObject getParentObject(@NotNull JsonObject obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)obj), JsonObject.class);
        }

        @Override
        protected void traverseObjects(@NotNull JsonObject root, @NotNull Function1<? super JsonObject, Unit> visitor) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            new JsonRecursiveElementVisitor(visitor){
                final /* synthetic */ Function1<JsonObject, Unit> $visitor;
                {
                    this.$visitor = $visitor;
                }

                public void visitObject(JsonObject o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    super.visitObject(o);
                    this.$visitor.invoke((Object)o);
                }
            }.visitObject(root);
        }
    }
}

