/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "<init>", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Left", "Center", "Right", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nSetColumnAlignmentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetColumnAlignmentAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,76:1\n7#2,6:77\n*S KotlinDebug\n*F\n+ 1 SetColumnAlignmentAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction\n*L\n53#1:77,6\n*E\n"})
public abstract class SetColumnAlignmentAction
extends ToggleAction {
    @NotNull
    private final MarkdownTableSeparatorRow.CellAlignment alignment;

    public SetColumnAlignmentAction(@NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        this.alignment = alignment;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        Integer offset;
        PsiFile file;
        Editor editor2;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
                file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
                Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
                Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
                if (editor2 == null || file == null || offset == null) break block3;
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) break block4;
            }
            event.getPresentation().setEnabledAndVisible(false);
            return false;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, document2, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        MarkdownTable markdownTable = table;
        event.getPresentation().setEnabledAndVisible(markdownTable != null ? TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTable) : false);
        return table == null || columnIndex == null ? false : TableUtils.INSTANCE.getColumnAlignment(table, columnIndex) == this.alignment;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Integer offset;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
        if (editor2 == null || file == null || offset == null) {
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, document2, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        if (table != null && columnIndex != null) {
            ActionsKt.runWriteAction(() -> SetColumnAlignmentAction.setSelected$lambda$0(table, state, this, editor2, columnIndex));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final Unit setSelected$lambda$0(MarkdownTable $table, boolean $state, SetColumnAlignmentAction this$0, Editor $editor, Integer $columnIndex) {
        Project project$iv = $table.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable($state, this$0, $table, $editor, $columnIndex){
            final /* synthetic */ boolean $state$inlined;
            final /* synthetic */ SetColumnAlignmentAction this$0;
            final /* synthetic */ MarkdownTable $table$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ Integer $columnIndex$inlined;
            {
                this.$state$inlined = bl;
                this.this$0 = setColumnAlignmentAction;
                this.$table$inlined = markdownTable;
                this.$editor$inlined = editor2;
                this.$columnIndex$inlined = n;
            }

            public final void run() {
                boolean bl = false;
                MarkdownTableSeparatorRow.CellAlignment actualAlignment = this.$state$inlined ? SetColumnAlignmentAction.access$getAlignment$p(this.this$0) : MarkdownTableSeparatorRow.CellAlignment.NONE;
                Document document = this.$editor$inlined.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                TableModificationUtils.INSTANCE.updateColumnAlignment(this.$table$inlined, document, this.$columnIndex$inlined, actualAlignment);
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MarkdownTableSeparatorRow.CellAlignment access$getAlignment$p(SetColumnAlignmentAction $this) {
        return $this.alignment;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Center;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "<init>", "()V", "intellij.markdown"})
    public static final class Center
    extends SetColumnAlignmentAction {
        public Center() {
            super(MarkdownTableSeparatorRow.CellAlignment.CENTER);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Left;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "<init>", "()V", "intellij.markdown"})
    public static final class Left
    extends SetColumnAlignmentAction {
        public Left() {
            super(MarkdownTableSeparatorRow.CellAlignment.LEFT);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Right;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "<init>", "()V", "intellij.markdown"})
    public static final class Right
    extends SetColumnAlignmentAction {
        public Right() {
            super(MarkdownTableSeparatorRow.CellAlignment.RIGHT);
        }
    }
}

