/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream32;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashFunnel;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.ToLongFunction;

interface AbstractHashStream64
extends AbstractHashStream32,
HashStream64 {
    @Override
    default public int getAsInt() {
        return (int)this.getAsLong();
    }

    @Override
    default public HashStream64 putBoolean(boolean v) {
        AbstractHashStream32.super.putBoolean(v);
        return this;
    }

    @Override
    default public HashStream64 putBooleans(boolean[] x) {
        AbstractHashStream32.super.putBooleans(x);
        return this;
    }

    @Override
    default public HashStream64 putBooleans(boolean[] x, int off, int len) {
        AbstractHashStream32.super.putBooleans(x, off, len);
        return this;
    }

    @Override
    default public HashStream64 putBooleanArray(boolean[] x) {
        AbstractHashStream32.super.putBooleanArray(x);
        return this;
    }

    @Override
    default public HashStream64 putBytes(byte[] b) {
        AbstractHashStream32.super.putBytes(b);
        return this;
    }

    @Override
    default public HashStream64 putBytes(byte[] b, int off, int len) {
        AbstractHashStream32.super.putBytes(b, off, len);
        return this;
    }

    @Override
    default public <T> HashStream64 putBytes(T b, long off, long len, ByteAccess<T> access) {
        AbstractHashStream32.super.putBytes((Object)b, off, len, (ByteAccess)access);
        return this;
    }

    @Override
    default public HashStream64 putByteArray(byte[] x) {
        AbstractHashStream32.super.putByteArray(x);
        return this;
    }

    @Override
    default public HashStream64 putChar(char v) {
        AbstractHashStream32.super.putChar(v);
        return this;
    }

    @Override
    default public HashStream64 putChars(char[] x) {
        AbstractHashStream32.super.putChars(x);
        return this;
    }

    @Override
    default public HashStream64 putChars(char[] x, int off, int len) {
        AbstractHashStream32.super.putChars(x, off, len);
        return this;
    }

    @Override
    default public HashStream64 putChars(CharSequence s) {
        AbstractHashStream32.super.putChars(s);
        return this;
    }

    @Override
    default public HashStream64 putCharArray(char[] x) {
        AbstractHashStream32.super.putCharArray(x);
        return this;
    }

    @Override
    default public HashStream64 putString(String s) {
        AbstractHashStream32.super.putString(s);
        return this;
    }

    @Override
    default public HashStream64 putShort(short v) {
        AbstractHashStream32.super.putShort(v);
        return this;
    }

    @Override
    default public HashStream64 putShortArray(short[] x) {
        AbstractHashStream32.super.putShortArray(x);
        return this;
    }

    @Override
    default public HashStream64 putShorts(short[] x) {
        AbstractHashStream32.super.putShorts(x);
        return this;
    }

    @Override
    default public HashStream64 putShorts(short[] x, int off, int len) {
        AbstractHashStream32.super.putShorts(x, off, len);
        return this;
    }

    @Override
    default public HashStream64 putInt(int v) {
        AbstractHashStream32.super.putInt(v);
        return this;
    }

    @Override
    default public HashStream64 putIntArray(int[] x) {
        AbstractHashStream32.super.putIntArray(x);
        return this;
    }

    @Override
    default public HashStream64 putInts(int[] x) {
        AbstractHashStream32.super.putInts(x);
        return this;
    }

    @Override
    default public HashStream64 putInts(int[] x, int off, int len) {
        AbstractHashStream32.super.putInts(x, off, len);
        return this;
    }

    @Override
    default public HashStream64 putLong(long v) {
        AbstractHashStream32.super.putLong(v);
        return this;
    }

    @Override
    default public HashStream64 putLongArray(long[] x) {
        AbstractHashStream32.super.putLongArray(x);
        return this;
    }

    @Override
    default public HashStream64 putLongs(long[] x) {
        AbstractHashStream32.super.putLongs(x);
        return this;
    }

    @Override
    default public HashStream64 putLongs(long[] x, int off, int len) {
        AbstractHashStream32.super.putLongs(x, off, len);
        return this;
    }

    @Override
    default public HashStream64 putFloat(float v) {
        AbstractHashStream32.super.putFloat(v);
        return this;
    }

    @Override
    default public HashStream64 putFloats(float[] x) {
        AbstractHashStream32.super.putFloats(x);
        return this;
    }

    @Override
    default public HashStream64 putFloats(float[] x, int off, int len) {
        AbstractHashStream32.super.putFloats(x, off, len);
        return this;
    }

    @Override
    default public HashStream64 putFloatArray(float[] x) {
        AbstractHashStream32.super.putFloatArray(x);
        return this;
    }

    @Override
    default public HashStream64 putDouble(double v) {
        AbstractHashStream32.super.putDouble(v);
        return this;
    }

    @Override
    default public HashStream64 putDoubleArray(double[] x) {
        AbstractHashStream32.super.putDoubleArray(x);
        return this;
    }

    @Override
    default public HashStream64 putDoubles(double[] x) {
        AbstractHashStream32.super.putDoubles(x);
        return this;
    }

    @Override
    default public HashStream64 putDoubles(double[] x, int off, int len) {
        AbstractHashStream32.super.putDoubles(x, off, len);
        return this;
    }

    @Override
    default public HashStream64 putUUID(UUID uuid) {
        AbstractHashStream32.super.putUUID(uuid);
        return this;
    }

    @Override
    default public <T> HashStream64 put(T data, HashFunnel<T> funnel) {
        AbstractHashStream32.super.put((Object)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    default public <T> HashStream64 putNullable(T data, HashFunnel<T> funnel) {
        AbstractHashStream32.super.putNullable((Object)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    default public <T> HashStream64 putOrderedIterable(Iterable<T> data, HashFunnel<? super T> funnel) {
        AbstractHashStream32.super.putOrderedIterable((Iterable)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    default public <T> HashStream64 putUnorderedIterable(Iterable<T> data, HashFunnel<? super T> funnel, Hasher64 hasher) {
        AbstractHashStream32.super.putUnorderedIterable((Iterable)data, (HashFunnel)funnel, hasher);
        return this;
    }

    @Override
    default public <T> HashStream64 putUnorderedIterable(Iterable<T> data, HashFunnel<? super T> funnel, HashStream64 hashStream) {
        AbstractHashStream32.super.putUnorderedIterable((Iterable)data, (HashFunnel)funnel, hashStream);
        return this;
    }

    @Override
    default public <T> HashStream64 putUnorderedIterable(Iterable<T> data, ToLongFunction<? super T> elementHashFunction) {
        AbstractHashStream32.super.putUnorderedIterable((Iterable)data, (ToLongFunction)elementHashFunction);
        return this;
    }

    @Override
    default public <T> HashStream64 putOptional(Optional<T> obj, HashFunnel<? super T> funnel) {
        AbstractHashStream32.super.putOptional((Optional)obj, (HashFunnel)funnel);
        return this;
    }

    @Override
    default public HashStream64 putOptionalInt(OptionalInt v) {
        AbstractHashStream32.super.putOptionalInt(v);
        return this;
    }

    @Override
    default public HashStream64 putOptionalLong(OptionalLong v) {
        AbstractHashStream32.super.putOptionalLong(v);
        return this;
    }

    @Override
    default public HashStream64 putOptionalDouble(OptionalDouble v) {
        AbstractHashStream32.super.putOptionalDouble(v);
        return this;
    }

    @Override
    default public <T> long resetAndHashToLong(T obj, HashFunnel<T> funnel) {
        funnel.put(obj, this.reset());
        return this.getAsLong();
    }

    @Override
    default public HashStream64 copy() {
        return this.getHasher().hashStreamFromState(this.getState());
    }
}

