/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class XmlValueReference
implements PsiReference {
    protected final XmlTag myTag;
    protected TextRange myRange;

    protected XmlValueReference(XmlTag tag) {
        this.myTag = tag;
        this.myRange = ElementManipulators.getValueTextRange((PsiElement)tag);
    }

    @NotNull
    public PsiElement getElement() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            XmlValueReference.$$$reportNull$$$0(0);
        }
        return xmlTag;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            XmlValueReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRange.substring(this.myTag.getText());
        if (string == null) {
            XmlValueReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void replaceContent(String str) throws IncorrectOperationException {
        ElementManipulators.handleContentChange((PsiElement)this.myTag, (TextRange)this.myRange, (String)str);
        this.myRange = ElementManipulators.getValueTextRange((PsiElement)this.myTag);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            XmlValueReference.$$$reportNull$$$0(3);
        }
        return this.myTag.getManager().areElementsEquivalent(element, this.resolve());
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlValueReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlValueReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

