﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/ResultSet.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class GetQueryResultsResult
  {
  public:
    AWS_ATHENA_API GetQueryResultsResult() = default;
    AWS_ATHENA_API GetQueryResultsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API GetQueryResultsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The number of rows inserted with a <code>CREATE TABLE AS SELECT</code>,
     * <code>INSERT INTO</code>, or <code>UPDATE</code> statement. </p>
     */
    inline long long GetUpdateCount() const { return m_updateCount; }
    inline void SetUpdateCount(long long value) { m_updateCountHasBeenSet = true; m_updateCount = value; }
    inline GetQueryResultsResult& WithUpdateCount(long long value) { SetUpdateCount(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The results of the query execution.</p>
     */
    inline const ResultSet& GetResultSet() const { return m_resultSet; }
    template<typename ResultSetT = ResultSet>
    void SetResultSet(ResultSetT&& value) { m_resultSetHasBeenSet = true; m_resultSet = std::forward<ResultSetT>(value); }
    template<typename ResultSetT = ResultSet>
    GetQueryResultsResult& WithResultSet(ResultSetT&& value) { SetResultSet(std::forward<ResultSetT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    GetQueryResultsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    GetQueryResultsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    long long m_updateCount{0};
    bool m_updateCountHasBeenSet = false;

    ResultSet m_resultSet;
    bool m_resultSetHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
