﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SageMaker
{
namespace Model
{

  /**
   * <p>The workspace settings for the SageMaker Canvas application.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/WorkspaceSettings">AWS
   * API Reference</a></p>
   */
  class WorkspaceSettings
  {
  public:
    AWS_SAGEMAKER_API WorkspaceSettings() = default;
    AWS_SAGEMAKER_API WorkspaceSettings(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKER_API WorkspaceSettings& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The Amazon S3 bucket used to store artifacts generated by Canvas. Updating
     * the Amazon S3 location impacts existing configuration settings, and Canvas users
     * no longer have access to their artifacts. Canvas users must log out and log back
     * in to apply the new location.</p>
     */
    inline const Aws::String& GetS3ArtifactPath() const { return m_s3ArtifactPath; }
    inline bool S3ArtifactPathHasBeenSet() const { return m_s3ArtifactPathHasBeenSet; }
    template<typename S3ArtifactPathT = Aws::String>
    void SetS3ArtifactPath(S3ArtifactPathT&& value) { m_s3ArtifactPathHasBeenSet = true; m_s3ArtifactPath = std::forward<S3ArtifactPathT>(value); }
    template<typename S3ArtifactPathT = Aws::String>
    WorkspaceSettings& WithS3ArtifactPath(S3ArtifactPathT&& value) { SetS3ArtifactPath(std::forward<S3ArtifactPathT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Web Services Key Management Service (KMS) encryption key ID that
     * is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.</p>
     */
    inline const Aws::String& GetS3KmsKeyId() const { return m_s3KmsKeyId; }
    inline bool S3KmsKeyIdHasBeenSet() const { return m_s3KmsKeyIdHasBeenSet; }
    template<typename S3KmsKeyIdT = Aws::String>
    void SetS3KmsKeyId(S3KmsKeyIdT&& value) { m_s3KmsKeyIdHasBeenSet = true; m_s3KmsKeyId = std::forward<S3KmsKeyIdT>(value); }
    template<typename S3KmsKeyIdT = Aws::String>
    WorkspaceSettings& WithS3KmsKeyId(S3KmsKeyIdT&& value) { SetS3KmsKeyId(std::forward<S3KmsKeyIdT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_s3ArtifactPath;
    bool m_s3ArtifactPathHasBeenSet = false;

    Aws::String m_s3KmsKeyId;
    bool m_s3KmsKeyIdHasBeenSet = false;
  };

} // namespace Model
} // namespace SageMaker
} // namespace Aws
