﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>
#include <aws/dms/model/EventSubscription.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DatabaseMigrationService {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscriptionResponse">AWS
 * API Reference</a></p>
 */
class CreateEventSubscriptionResult {
 public:
  AWS_DATABASEMIGRATIONSERVICE_API CreateEventSubscriptionResult() = default;
  AWS_DATABASEMIGRATIONSERVICE_API CreateEventSubscriptionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DATABASEMIGRATIONSERVICE_API CreateEventSubscriptionResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The event subscription that was created.</p>
   */
  inline const EventSubscription& GetEventSubscription() const { return m_eventSubscription; }
  template <typename EventSubscriptionT = EventSubscription>
  void SetEventSubscription(EventSubscriptionT&& value) {
    m_eventSubscriptionHasBeenSet = true;
    m_eventSubscription = std::forward<EventSubscriptionT>(value);
  }
  template <typename EventSubscriptionT = EventSubscription>
  CreateEventSubscriptionResult& WithEventSubscription(EventSubscriptionT&& value) {
    SetEventSubscription(std::forward<EventSubscriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateEventSubscriptionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  EventSubscription m_eventSubscription;

  Aws::String m_requestId;
  bool m_eventSubscriptionHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DatabaseMigrationService
}  // namespace Aws
