/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.RangeIntegerValue;
import proguard.evaluation.value.SpecificIntegerValue;

final class ParticularIntegerValue
extends SpecificIntegerValue {
    private final int value;

    public ParticularIntegerValue(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public IntegerValue negate() {
        return new ParticularIntegerValue(-this.value);
    }

    @Override
    public IntegerValue convertToByte() {
        byte byteValue = (byte)this.value;
        return byteValue == this.value ? this : new ParticularIntegerValue(byteValue);
    }

    @Override
    public IntegerValue convertToCharacter() {
        char charValue = (char)this.value;
        return charValue == this.value ? this : new ParticularIntegerValue(charValue);
    }

    @Override
    public IntegerValue convertToShort() {
        short shortValue = (short)this.value;
        return shortValue == this.value ? this : new ParticularIntegerValue(shortValue);
    }

    @Override
    public LongValue convertToLong() {
        return new ParticularLongValue(this.value);
    }

    @Override
    public FloatValue convertToFloat() {
        return new ParticularFloatValue(this.value);
    }

    @Override
    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    @Override
    public IntegerValue generalize(IntegerValue other) {
        return other.generalize(this);
    }

    @Override
    public IntegerValue add(IntegerValue other) {
        return other.add(this);
    }

    @Override
    public IntegerValue subtract(IntegerValue other) {
        return other.subtractFrom(this);
    }

    @Override
    public IntegerValue subtractFrom(IntegerValue other) {
        return other.subtract(this);
    }

    @Override
    public IntegerValue multiply(IntegerValue other) {
        return other.multiply(this);
    }

    @Override
    public IntegerValue divide(IntegerValue other) throws ArithmeticException {
        return other.divideOf(this);
    }

    @Override
    public IntegerValue divideOf(IntegerValue other) throws ArithmeticException {
        return other.divide(this);
    }

    @Override
    public IntegerValue remainder(IntegerValue other) throws ArithmeticException {
        return other.remainderOf(this);
    }

    @Override
    public IntegerValue remainderOf(IntegerValue other) throws ArithmeticException {
        return other.remainder(this);
    }

    @Override
    public IntegerValue shiftLeft(IntegerValue other) {
        return other.shiftLeftOf(this);
    }

    @Override
    public IntegerValue shiftLeftOf(IntegerValue other) {
        return other.shiftLeft(this);
    }

    @Override
    public IntegerValue shiftRight(IntegerValue other) {
        return other.shiftRightOf(this);
    }

    @Override
    public IntegerValue shiftRightOf(IntegerValue other) {
        return other.shiftRight(this);
    }

    @Override
    public IntegerValue unsignedShiftRight(IntegerValue other) {
        return other.unsignedShiftRightOf(this);
    }

    @Override
    public IntegerValue unsignedShiftRightOf(IntegerValue other) {
        return other.unsignedShiftRight(this);
    }

    @Override
    public LongValue shiftLeftOf(LongValue other) {
        return other.shiftLeft(this);
    }

    @Override
    public LongValue shiftRightOf(LongValue other) {
        return other.shiftRight(this);
    }

    @Override
    public LongValue unsignedShiftRightOf(LongValue other) {
        return other.unsignedShiftRight(this);
    }

    @Override
    public IntegerValue and(IntegerValue other) {
        return other.and(this);
    }

    @Override
    public IntegerValue or(IntegerValue other) {
        return other.or(this);
    }

    @Override
    public IntegerValue xor(IntegerValue other) {
        return other.xor(this);
    }

    @Override
    public int equal(IntegerValue other) {
        return other.equal(this);
    }

    @Override
    public int lessThan(IntegerValue other) {
        return other.greaterThan(this);
    }

    @Override
    public int lessThanOrEqual(IntegerValue other) {
        return other.greaterThanOrEqual(this);
    }

    @Override
    public IntegerValue generalize(ParticularIntegerValue other) {
        return this.generalize((SpecificIntegerValue)other);
    }

    @Override
    public IntegerValue add(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value + other.value);
    }

    @Override
    public IntegerValue subtract(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value - other.value);
    }

    @Override
    public IntegerValue subtractFrom(ParticularIntegerValue other) {
        return new ParticularIntegerValue(other.value - this.value);
    }

    @Override
    public IntegerValue multiply(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value * other.value);
    }

    @Override
    public IntegerValue divide(ParticularIntegerValue other) throws ArithmeticException {
        return new ParticularIntegerValue(this.value / other.value);
    }

    @Override
    public IntegerValue divideOf(ParticularIntegerValue other) throws ArithmeticException {
        return new ParticularIntegerValue(other.value / this.value);
    }

    @Override
    public IntegerValue remainder(ParticularIntegerValue other) throws ArithmeticException {
        return new ParticularIntegerValue(this.value % other.value);
    }

    @Override
    public IntegerValue remainderOf(ParticularIntegerValue other) throws ArithmeticException {
        return new ParticularIntegerValue(other.value % this.value);
    }

    @Override
    public IntegerValue shiftLeft(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value << other.value);
    }

    @Override
    public IntegerValue shiftRight(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value >> other.value);
    }

    @Override
    public IntegerValue unsignedShiftRight(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value >>> other.value);
    }

    @Override
    public IntegerValue shiftLeftOf(ParticularIntegerValue other) {
        return new ParticularIntegerValue(other.value << this.value);
    }

    @Override
    public IntegerValue shiftRightOf(ParticularIntegerValue other) {
        return new ParticularIntegerValue(other.value >> this.value);
    }

    @Override
    public IntegerValue unsignedShiftRightOf(ParticularIntegerValue other) {
        return new ParticularIntegerValue(other.value >>> this.value);
    }

    @Override
    public LongValue shiftLeftOf(ParticularLongValue other) {
        return new ParticularLongValue(other.value() << this.value);
    }

    @Override
    public LongValue shiftRightOf(ParticularLongValue other) {
        return new ParticularLongValue(other.value() >> this.value);
    }

    @Override
    public LongValue unsignedShiftRightOf(ParticularLongValue other) {
        return new ParticularLongValue(other.value() >>> this.value);
    }

    @Override
    public IntegerValue and(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value & other.value);
    }

    @Override
    public IntegerValue or(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value | other.value);
    }

    @Override
    public IntegerValue xor(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value ^ other.value);
    }

    @Override
    public int equal(ParticularIntegerValue other) {
        return this.value == other.value ? 1 : -1;
    }

    @Override
    public int lessThan(ParticularIntegerValue other) {
        return this.value < other.value ? 1 : -1;
    }

    @Override
    public int lessThanOrEqual(ParticularIntegerValue other) {
        return this.value <= other.value ? 1 : -1;
    }

    @Override
    public IntegerValue generalize(RangeIntegerValue other) {
        return other.generalize(this);
    }

    @Override
    public IntegerValue add(RangeIntegerValue other) {
        return other.add(this);
    }

    @Override
    public IntegerValue subtract(RangeIntegerValue other) {
        return other.subtractFrom(this);
    }

    @Override
    public IntegerValue subtractFrom(RangeIntegerValue other) {
        return other.subtract(this);
    }

    @Override
    public IntegerValue multiply(RangeIntegerValue other) {
        return other.multiply(this);
    }

    @Override
    public IntegerValue divide(RangeIntegerValue other) throws ArithmeticException {
        return other.divideOf(this);
    }

    @Override
    public IntegerValue divideOf(RangeIntegerValue other) throws ArithmeticException {
        return other.divide(this);
    }

    @Override
    public IntegerValue remainder(RangeIntegerValue other) throws ArithmeticException {
        return other.remainderOf(this);
    }

    @Override
    public IntegerValue remainderOf(RangeIntegerValue other) throws ArithmeticException {
        return other.remainder(this);
    }

    @Override
    public IntegerValue shiftLeft(RangeIntegerValue other) {
        return other.shiftLeftOf(this);
    }

    @Override
    public IntegerValue shiftLeftOf(RangeIntegerValue other) {
        return other.shiftLeft(this);
    }

    @Override
    public IntegerValue shiftRight(RangeIntegerValue other) {
        return other.shiftRightOf(this);
    }

    @Override
    public IntegerValue shiftRightOf(RangeIntegerValue other) {
        return other.shiftRight(this);
    }

    @Override
    public IntegerValue unsignedShiftRight(RangeIntegerValue other) {
        return other.unsignedShiftRightOf(this);
    }

    @Override
    public IntegerValue unsignedShiftRightOf(RangeIntegerValue other) {
        return other.unsignedShiftRight(this);
    }

    @Override
    public IntegerValue and(RangeIntegerValue other) {
        return other.and(this);
    }

    @Override
    public IntegerValue or(RangeIntegerValue other) {
        return other.or(this);
    }

    @Override
    public IntegerValue xor(RangeIntegerValue other) {
        return other.xor(this);
    }

    @Override
    public int equal(RangeIntegerValue other) {
        return other.equal(this);
    }

    @Override
    public int lessThan(RangeIntegerValue other) {
        return other.greaterThan(this);
    }

    @Override
    public int lessThanOrEqual(RangeIntegerValue other) {
        return other.greaterThanOrEqual(this);
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularIntegerValue)object).value;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

